# Generated by Django 3.2 on 2022-07-15 14:27
from django.utils import timezone
from django.db import migrations, models

def _migrate_annotation_data(apps, schema_editor):
    Annotation = apps.get_model("backend", "Annotation")
    AnnotationChangeHistory = apps.get_model("backend", "AnnotationChangeHistory")
    for annotation in Annotation.objects.all():
        if annotation._data:
            # This migration changes annotation's .data field to ._data so that .data can be used for writing
            # to the change history instead, we then need to the contents of ._data to the change history as
            # ._data will be removed in the next migration.
            AnnotationChangeHistory.objects.create(data=annotation._data,
                                                   annotation_id=annotation.pk,
                                                   time=annotation.status_time if annotation.status_time else timezone.now(),
                                                   changed_by=annotation.user)



class Migration(migrations.Migration):

    dependencies = [
        ('backend', '0023_annotationchangehistory'),
    ]

    operations = [
        migrations.RenameField(
            model_name='annotation',
            old_name='data',
            new_name='_data',
        ),
        migrations.RunPython(_migrate_annotation_data, reverse_code=migrations.RunPython.noop),
    ]

