# Generated by Django 3.2.8 on 2022-03-18 16:20
from django.utils import timezone
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

def _migrate_project_annotators(apps, schema_editor):
    User = apps.get_model('backend', 'ServiceUser')
    AnnotatorProject = apps.get_model('backend', 'AnnotatorProject')
    Project = apps.get_model('backend', 'Project')
    for user in User.objects.all():
        project = user.annotates_old

        # Add user if currently active in project
        if project:
            AnnotatorProject.objects.create(annotator=user,
                                            project=project)

        # Add all user annotated projects that they're not active in
        non_active_project_query = Project.objects.filter(documents__annotations__user=user).distinct()
        if project:
            non_active_project_query = non_active_project_query.exclude(id=project.id)

        for anno_proj in non_active_project_query:
            AnnotatorProject.objects.create(annotator=user,
                                            project=anno_proj,
                                            status=1,
                                            annotations_completed=timezone.now()
                                            )



class Migration(migrations.Migration):

    dependencies = [
        ('backend', '0014a_change_user_annotates_to_old'),
    ]

    operations = [
        migrations.AddField(
            model_name='project',
            name='can_annotate_after_passing_test',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='project',
            name='has_test_stage',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='project',
            name='has_training_stage',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='project',
            name='min_test_pass_threshold',
            field=models.FloatField(default=1.0, null=True),
        ),
        migrations.CreateModel(
            name='AnnotatorProject',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('training_score', models.FloatField(null=True)),
                ('test_score', models.FloatField(null=True)),
                ('training_completed', models.DateTimeField(null=True)),
                ('test_completed', models.DateTimeField(null=True)),
                ('annotations_completed', models.DateTimeField(null=True)),
                ('status', models.IntegerField(choices=[(0, 'Active'), (1, 'Completed')], default=0)),
                ('annotator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='backend.project')),
            ],
        ),
        migrations.AddField(
            model_name='project',
            name='annotators',
            field=models.ManyToManyField(related_name='annotates', through='backend.AnnotatorProject', to=settings.AUTH_USER_MODEL),
        ),
        migrations.RunPython(_migrate_project_annotators, reverse_code=migrations.RunPython.noop),
    ]
