McLellan, C. F., Cuthill, I. C. & Montgomery, S. H. Pattern variation is linked to anti-predator colouration in butterfly larvae

Callum F. McLellan, University of Bristol, cm15245@bristol.ac.uk
Stephen H. Montgomery, University of Bristol, s.montgomery@bristol.ac.uk
Innes C. Cuthill, University of Bristol, I.Cuthill@bristol.ac.uk

C. F. McLellan is responsible for collecting data and writing the code.

This data folder contains the R script to perform all analyses described in the study, all data files need for analyses and two phylogenetic trees in nexus format needed for analyses.

Data files within folder:
Variables (columns) in all data files are described as follows:
'Genus' = larval genera
'SB' = larval social behaviour (0/1 = solitary/gregarious)
'CP' = larval colour strategy (0/1 = cryptic/aposematic)
'SD' = structural defence (0/1 = no defence/has defence)
'CD' = Coloured defence
'PE_num' = number of pattern elements possessed by larva (0/1/2 = no pattern/one element/more than one element)
Pattern elements (Bands, CD, None, Other, Spots, Stripes) given as binary (0/1 = larva does not possess element/larvae possesses element)

Traits_tree.nex - phylogenetic tree including all species for which data on social behaviour, colour strategy and structural defence was available.
Patterns_tree.nex - phylogenetic tree including all species for which data on pattern elements was available.

Table S1 - Recorded data for larval pattern elements with literature citations. The ‘Social behaviour’, ‘Colour strategy’ and ‘Structural defence’ columns display data previously mined from the literature (0/1 = solitary/gregarious, cryptic/aposematic, no defence/has defence respectively). ING = Image not gregarious, these species were recorded as solitary in the main analyses. INA = Image not aposematic, this species was recorded as cryptic in the main analyses. Both ‘lat stripes’ and ‘long stripes’ were recorded under the single category ‘Stripes’ in the main analyses. The 'Image 1 source' column provides the research paper citation or website address at which the image from 'Image 1 link' can be found.

Pattern_data_long - data on which larvae possess which traits and pattern elements for use in long format. PE1, PE2, PE3 = pattern elements that larvae possess.
Pattern_data_wide - data on which larvae possess which traits and pattern elements for use in wide format.
Phylosig_traits - data on the non-pattern traits larvae possess.
Random_reps_data - data on which larvae possess which traits and pattern elements for use in both long and wide formats, the single genus representatives have been randomly selected for 19 genera. PE1, PE2, PE3 = pattern elements that larvae possess.
Source_descriptions - a list of non-primary sources used in the study from which images of larvae were used to collect pattern data. Also given are brief descriptions of each source along with the authors' assessment of their putative reliability.
Suppl_data - data on which larvae possess which traits and pattern elements for use in both long and wide formats with 11 genera omitted. PE1, PE2, PE3 = pattern elements that larvae possess.
Trusted_data - data on which larvae possess which traits and pattern elements for use in both long and wide formats with 17 genera omitted. PE1, PE2, PE3 = pattern elements that larvae possess.

Script files within folder:
R script.R - script for calculating phylogenetic signal of traits, analysing interactions using MCMCglmm and analysing supplementary data.

All quantitative analyses performed using R v. 4.2.2
ape v 5.7
geiger v. 2.0.7
phytools v. 1.0
MCMCglmm v. 2.32
