Columns
-------

**track_id** -- unique cell track identifier [integer],

**time_in_minutes** -- time of the experiment (in minutes) [integer],

**is_light_pulse** -- whether an input light pulse has been applied in the current minute [integer: 0 or 1],

**nuc_area** -- area of the nuclear contour [float],

**nuc_center_x** -- X coordinate of the geometric center of the nuclear contour [float],

**nuc_center_y** -- Y coordinate of the geometric center of the nuclear contour [float],

**nuc_H2B_intensity_mean** -- mean intensity of pixels within the nuclear contour in the H2B channel [float],

**nuc_ERKKTR_intensity_mean** -- mean intensity of pixels within the nuclear contour in the ERK-KTR channel [float],

**img_H2B_intensity_mean** -- mean intensity of the whole image in the H2B channel [float],

**img_ERKKTR_intensity_mean** -- mean intensity of the whole image in the ERK-KTR channel [float],

**nuc_ERKKTR_intensity_mean_normalized_with_image** -- derived value: nuc_ERKKTR_intensity_mean / img_ERKKTR_intensity_mean [float],

**nuc_ERKKTR_intensity_mean_normalized_with_image_and_history** -- derived value: nuc_ERKKTR_intensity_mean_normalized_with_image normalized using 120 min-long history [float],

**ERKKTR_translocation** -- derived value: 1 minus nuc_ERKKTR_intensity_mean_normalized_with_image_and_history [float],

**is_preselected** -- is the whole track among the 400 tracks preselected based on the variance of the discrete derivative of nuc_ERKKTR_intensity_mean_normalized_with_image [boolean]

