---
title: Version Control, Clean Code and Documentation
author: Dr. Anthea Alberto and Dr. Maximilian Hindermann
institute: RISE and UB
theme: Metropolis
date: February 17, 2023
---

# Program

- 0900-0915 Introduction
- 0915-0945 Brief introduction to version control with Git
- 0945-1030 Documentation with examples from Python
- 1030-1100 Break
- 1100-1230 Clean code with examples from R
- 1230-1300 Q&A

# About us

![](images/rise.jpg "The RISE team")

- Email: rise@unibas.ch 
- Web: https://rise.unibas.ch/
- GitHub: https://github.com/RISE-UNIBAS

# Today's goal

![](images/title_image.png "'An oil painting of a programmer cleaning her code with soap' by Maximilian Hindermann and DALLE-2")

Understand how using version control, clean code and documentation can be used to:

- read and maintain your code
- comply with [FAIR data principles](https://force11.org/info/the-fair-data-principles/) and [FAIR4RS principles](https://zenodo.org/record/6623556#.Y-uTsq2ZNaQ) (see also [Barker et al. 2022](https://doi.org/10.1038/s41597-022-01710-x)) 
- avoid tech debt

# Course materials

![](images/qr.png "https://github.com/RISE-UNIBAS/clean-code")

Available right now at [https://github.com/RISE-UNIBAS/clean-code](https://github.com/RISE-UNIBAS/clean-code)
