ReadMe file of source data for:

Trade-offs between immunity and competitive ability in fighting ant males 
by Sina Metzler, Jessica Kirchner, Anna V. Grasse and Sylvia Cremer
ISTA (Institute of Science and Technology Austria)

Corresponding author: sylvia.cremer@ist.ac.at
Data collectors: Sina Metzler, Jessica Kirchner, Anna V. Grasse

BioRxiv: https://www.biorxiv.org/content/10.1101/2023.01.30.526206v1


Metzler_Fig1ab_fight_outcome.csv: number of fights ending decided (one winner and one loser) vs undecided (both males dead or alive) for fights including one infected male or only two healthy males, and proportion of fights lost by infected males depending on infection stage 

Columns:
 infection_stage : early-infected or late-infected; males fighting immediately after fungal spore exposure (early) or after establishment of the infection after an isolation period of 48h (late)
 dose : exposure dose of males; high, low
 colony : colony of origin
 fight_combination : combination of males per fight; healthy-healthy: two healthy males, 	healthy-infected: one healthy and one infected male
 fight_outcome : outcome of the fight; one dead (i.e. one winner and one loser), both alive, both dead 
 male_ID_decided_fights : method used to differentiate between the two males in fights between a healthy and an infected male that had a winner and a loser; ddPCR: spore load determination with digital droplet PCR; colour-code: males were differentiated on the basis of the colour mark applied onto their abdomen; na: non-applicable
 infected_male_loser : fights in which the infected male died; yes: infected male loser; no: infected male winner; not possible: no differentiation between the males possible, both males: both males died; na: non-applicable 
 male_pair_identification : numbers 1-208 refer to male pairs, for which scan sampling was performed;  (see Fig 1cdef); letters (E  early; L  late ) with numbers (1-20 each) indicate male pairs, for which spore load was determined by ddPCR for both males after fight (see tab  cross-contamination ); na: non-applicable 

Some of these data were also used to create Fig1 g,h.  


Metzler_Fig1cdef_behaviour.csv: aggressive behaviour performed by the males towards their rivals (Fig 1c,d) and by the workers towards the males (Fig1 e,f) 

Columns:
 infection_stage : early-infected or late-infected; males fighting immediately after fungal spore exposure (early) or after establishment of the infection after an isolation period of 48h (late)
 dose : exposure dose of males; high, low
 colony : colony of origin
 replicate : running number of male fighting pairs that were observed for their behavior (see also 1ab)
 male_treatment : treatment of the male; healthy (sham-treated), infected (pathogen-exposed)
 fight_combination : combination of males per fight; healthy-healthy: two healthy males, 	healthy-infected: one healthy and one infected male
 survival : mortality of the male; alive, dead
"fight_outcome": outcome of the fight; one dead (i.e. one winner and one loser), both alive, both dead 
 male_biting : number of bites performed by the male towards the other male
 male_holding : number of holdings (grabbing the rival with the mandibles) performed by the male towards the other male
 male_besmearing : number of besmearings (male bending its abdominal tip to apply hindgut secretion onto the rival) performed by the male towards the other male
 worker_biting : number of worker bites received by the male
 worker_carrying: number of worker carrying events received by the male
 worker_dismembering : number of intensive worker attacks received by the male (sometimes body parts bitten-off)
 worker_dragging : number of dragging events (male is held and pulled over the ground) received by the male by the workers

For the analysis, all male behaviours performed resp. worker behaviours received were summed and analysed as male-derived resp. worker-derived aggression. 


Metzler_Fig1gh_fight_costs.csv: infected male mortality in the presence or absence of fighting: cost of fighting in dependence of infection stage  

Columns:
 infection_stage : early-infected or late-infected; males fighting immediately after fungal spore exposure (early) or after establishment of the infection after an isolation period of 48h (late)
 dose : exposure dose of males; high, low
 colony : colony of origin
 survival : mortality of male; alive, dead
 male_fighting : no: males without a rival (baseline mortality), yes: males fighting a rival 

Some of these data (infected male mortality in the absence of fight) are repeated in tab S1_baseline_mortality, which also contained the mortality of healthy males in the absence of fight. See also tab 1a,b as we here show the mortality of all infected males either from decided fights (one male dead) or fights with both males dead. 


Metzler_FigS1_baseline_mortality.csv: healthy and infected male mortality in the absence of fight

Columns:
 infection_stage : early-infected or late-infected; males fighting immediately after fungal spore exposure (early) or after establishment of the infection after an isolation period of 48h (late)
 colony : colony of origin
 male_treatment : treatment of the male; sham: sham control treatment, low: low pathogen exposure, high: high pathogen exposure
  survival : mortality of males after 24h without another male present; alive, dead


Metzler_Figs2_S2_mmune_genes.csv: expression of 3 immune genes and the housekeeping gene at 12h (Fig S2) and 24h (Fig 2) after exposure

Columns:
 male_treatment : treatment of the male; sham: sham control treatment, low: low pathogen exposure, high: high pathogen exposure
  timepoint : timepoint after treatment with the sham, low or high pathogen load, at which immune gene expression was measured; 12h, 24h 
 colony : colony of origin 
 male_ID : running number of the males used for immune gene expression (number not related to the main experiment)
 immune_gene : immune gene analysed by ddPCR; Relish, PPOAF (Prophenoloxidase activating-factor), Defensin
  immune_gene_expression_value : immune gene expression value, as quantified by ddPCR for the three genes (Relish, PPOAF, Defensin)
 EF1_gene_expression_value : housekeeping gene (EF1) expression, as quantified by ddPCR
 normalised_gene_expression : normalized gene expression; expression of immune gene / expression of EF1 (housekeeping gene)


Metzler_cross_contamination.csv: fungal load determination with ddPCR, inferred infection status and cross-contamination of the males in fights of healthy and infected males that ended with a clear winner and loser

Columns
 infection_stage : early-infected or late-infected; males fighting immediately after fungal spore exposure (early) or after establishment of the infection after an isolation period of 48h (late)
 replicate : running number of male fighting pairs that were analysed for their fungal load (see also 1ab)
 survival : mortality of males; alive, dead
 fungal_load : fungal load per male; fungal load/male (calculated by the quantified value of copies of the mRFP1 gene in the 20 l well of the ddPCR reaction, divided by the 2 l of extracted DNA used in the PCR reaction, times 50 l, which corresponds to the (final elution volume of DNA extraction),  below detection  threshold when less than 2 positive droplets in PCR. 
 inferred_male_type : infected, healthy; the male with the higher fungal load per pair determined to be the infected male, the male with either no spores or less spores than the other male in the fight determined as the healthy male
 cross-contamination : cases in which both males had a detectable fungal load; yes: detectable fungal load in both males; no: detectable fungal load only in one male. Note that replicates in which none of the males had detectable spore load could not be included (which was the case for some of the late-infected pairings); na: non-applicable (infected male)


Metzler_accession_numbers.csv: Accession numbers of DNA sequences used for the identification of the
Cardiocondyla obscurior gene sequences, as well as sequence IDs within the published 
Cardiocondyla obscurior genome

Columns
 Gene name : genes of interest that were analysed by ddPCR
 Drosophila : protein accession numbers of the genes of interest in Drosophila melanogaster
 Temnothorax longispinosus : NCBI reference sequence ID and definition of the proteins of interest in Temnothorax longispinosus
 Atta cephalotes : NCBI reference sequence ID and definition of the proteins of interest in Atta cephalotes






```python

```
