/*
 * ** header v3.0
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2021 IndiScale GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * ** end header
 */

'use strict';

QUnit.module("form_panel.js", {
    before: function (assert) {

    },
    after: function (assert) {
    }
});

QUnit.test("availability", function (assert) {
    assert.ok(form_panel.init, "init available");
    assert.ok(form_panel.create_show_form_callback , "version available");
});

QUnit.test("create_show_form_callback ", function (assert) {
    const title = "Upload CSV File"; // title of the form and text in the toolbox
    const panel_id = "csv_upload_form_panel";
    const server_side_script = "csv_script.py";
    const tool_box = "Tools"; // Name of the drop-down menu where the button is added in the navbar
    const help_text = "something";
    const accepted_files_formats = [ ".csv", "text/tsv", ] // Mime types and file endings.

    const csv_form_config = {
        script: server_side_script,
        fields: [{
            type: "file",
            name: "csv_file",
            label: "CSV File", // label of the file selector in the form
            required: true,
            cached: false,
            accept: accepted_files_formats.join(","),
            help: help_text,
        }, ],
    };
    const cb = form_panel.create_show_form_callback( panel_id, title, csv_form_config);
    assert.equal(typeof cb, "function", "function created");
    cb()
});


