/*
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2021 IndiScale GmbH <info@indiscale.com>
 * Copyright (C) 2021 Timm Fitschen <t.fitschen@indiscale.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

'use strict';

QUnit.module("ext_cosmetics.js", {
    before: function (assert) {
        cosmetics.init();
        // setup before module
    },
    beforeEach: function (assert) {
        // setup before each test
    },
    afterEach: function (assert) {
        // teardown after each test
    },
    after: function (assert) {
        // teardown after module
    }
});

QUnit.test("linkify - https", function (assert) {
    assert.ok(cosmetics.linkify, "linkify available");
    var test_cases = [
        ["https://link", 1],
        ["this is other text https://link", 1],
        ["https://link this is other text", 1],
        ["this is other text https://link and this as well", 1],
        ["this is other text https://link", 1],
        ["this is other text https://link and here comes another link https://link and more text", 2],
    ];

    for (let test_case of test_cases) {
        const container = $('<div></div>');
        $(document.body).append(container);
        const text_value = $(`<div class="caosdb-f-property-text-value">${test_case[0]}</div>`);
        container.append(text_value);
        assert.equal($(container).find("a[href='https://link']").length, 0, "no link present");
        cosmetics.linkify();
        assert.equal($(container).find("a[href='https://link']").length, test_case[1], "link is present");
        container.remove();
    }
});

QUnit.test("linkify - http", function (assert) {
    var test_cases = [
        ["http://link", 1],
        ["this is other text http://link", 1],
        ["http://link this is other text", 1],
        ["this is other text http://link and this as well", 1],
        ["this is other text http://link", 1],
        ["this is other text http://link and here comes another link http://link and more text", 2],
    ];
    for (let test_case of test_cases) {
        const container = $('<div></div>');
        $(document.body).append(container);
        const text_value = $(`<div class="caosdb-f-property-text-value">${test_case[0]}</div>`);
        $(container).append(text_value);
        assert.equal($(container).find("a[href='http://link']").length, 0, "no link present");
        cosmetics.linkify();
        assert.equal($(container).find("a[href='http://link']").length, test_case[1], "link is present");
        container.remove();
    }
});

QUnit.test("linkify cut-off (40)", function (assert) {
    const container = $('<div></div>');
    $(document.body).append(container);
    const test_case = "here is some text https://this.is.a.link/with/more/than/40/characters/ this is more text";
    const text_value = $(`<div class="caosdb-f-property-text-value">${test_case}</div>`);
    $(container).append(text_value);
    assert.equal($(container).find("a").length, 0, "no link present");
    cosmetics.linkify();
    assert.equal($(container).find("a").length, 1, "link is present");
    assert.equal($(container).find("a").text(), "https://this.is.a.link/with/more/th[...] ", "link text has been cut off");
    container.remove();
});
