/*
 * ** header v3.0
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2019 IndiScale GmbH <info@indiscale.com>
 * Copyright (C) 2019 Timm Fitschen <t.fitschen@indiscale.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * ** end header
 */

'use strict';

/**
 * @module ext_trigger_crawler_form
 * @version 0.1
 *
 * Adds a button to a configurable navbar toolbox which opens a form for
 * triggering the crawler as a server-side scripting job.
 *
 * The form has two fields. The text field `Path` sets the directory tree which
 * is searched by the crawler. The checkbox `Suppress Warnings` can be checked
 * to suppress the crawlers warnings.
 *
 * The module has to be enabled via the
 * `BUILD_MODULE_EXT_TRIGGER_CRAWLER_FORM=ENABLED` build variable.
 *
 * The toolbox where the button is added can be configured via the build
 * variable `BUILD_MODULE_EXT_TRIGGER_CRAWLER_FORM_TOOLBOX`. The default is
 * `Tools`.
 */
var ext_trigger_crawler_form = function () {

    var init = function (toolbox) {
        const _toolbox = toolbox || "${BUILD_MODULE_EXT_TRIGGER_CRAWLER_FORM_TOOLBOX}";

        const script = "crawl.py"
        const button_name = "Trigger Crawler";
        const title = "The LinkAhead-Crawler will run over the filesystem and make necessary updates.";

        const crawler_form = make_scripting_caller_form(
            script, button_name);
        const modal = make_form_modal(crawler_form);


        navbar.add_tool(button_name, _toolbox, {
            title: title,
            callback: () => {
                $(modal).modal("toggle");
            }
        });
    }

    /**
     * Wrap the form into a Bootstrap modal.
     */
    var make_form_modal = function (form) {
        const title = "Trigger the Crawler";
        const modal = $(`
          <div class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <button type="button"
                    class="btn-close"
                    data-bs-dismiss="modal"
                    aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                  <h4 class="modal-title">${title}</h4>
                </div>
                <div class="modal-body">
                </div>
              </div>
            </div>`);
        modal.find(".modal-body").append(form);
        return modal[0];
    }

    /**
     * Create the trigger crawler form.
     */
    var make_scripting_caller_form = function (script, button_name) {
        const path_field = form_elements.make_text_input({
            name: "-p1",
            value: "/",
            label: "Path"
        });
        const warning_checkbox = form_elements.make_checkbox_input({
            name: "-Osuppress",
            label: "Suppress Warnings"
        });
        $(warning_checkbox).find("input").attr("value", "TRUE");

        const scripting_caller = $(`
        <form method="POST" action="/scripting">
          <input type="hidden" name="call" value="${script}"/>
          <input type="hidden" name="-p0" value=""/>
          <div class="form-control">
            <input type="submit"
              class="form-control btn btn-primary" value="${button_name}"/>
          </div>
        </form>`);

        scripting_caller.prepend(warning_checkbox).prepend(path_field);

        return scripting_caller[0];
    }

    return {
        init: init,
    };

}();

$(document).ready(function () {
    if ("${BUILD_MODULE_EXT_TRIGGER_CRAWLER_FORM}" === "ENABLED") {
        caosdb_modules.register(ext_trigger_crawler_form);
    }
});
