/*
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2021 IndiScale GmbH <info@indiscale.com>
 * Copyright (C) 2021 Timm Fitschen <t.fitschen@indiscale.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

"use strict";

/**
 * Cosmetics module is a collection of small look-and-feel tweaks for the
 * caosdb webui.
 *
 * @author Timm Fitschen
 */
var cosmetics = new function () {

    /**
     * Cut-off length of links. When linkify processes the links any href
     * longer than this will be cut off at character 25 and "[...]" will be
     * appended for the link text.
     */
    var _link_cut_off_length = 40;

    var _linkify = function () {
        $('.caosdb-f-property-text-value').each(function (index) {
            if (/https?:\/\//.test(this.innerText)) {
                var result = this.innerText.replace(/https?:\/\/[^\s]*/g, function (href, index) {
                    var link_text = href;
                    if (_link_cut_off_length > 4 && link_text.length > _link_cut_off_length) {
                        link_text = link_text.substring(0, _link_cut_off_length - 5) + "[...]";
                    }

                    return `<a title="Open ${href} in a new tab." target="_blank" class="caosdb-v-property-href-value" href="${href}">${link_text} <i class="bi bi-box-arrow-up-right"></i></a>`;
                });

                $(this).hide();
                $(this).after(result);
            }
        });
    }

    /**
     * Convert any substring of a text-value beginning with 'http(s)://' into a
     * link.
     *
     * A listener detects edit-mode changes and previews
     */
    var linkify = function () {
        _linkify();

        // edit-mode-listener
        document.body.addEventListener(edit_mode.end_edit.type, _linkify, true);
        // preview listener
        document.body.addEventListener(preview.previewReadyEvent.type, _linkify, true);
    }

    this.init = function () {
        this.linkify = linkify;
        if ("${BUILD_MODULE_EXT_COSMETICS_LINKIFY}" == "ENABLED") {
            linkify();
        }
    }

}


$(document).ready(function () {
    caosdb_modules.register(cosmetics);
});