#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
(C) Copyright IndiScale GmbH 2019
"""

import caosdb

caosdb.get_connection()._login()

# data model
if caosdb.execute_query("COUNT RecordType UserTemplate") == 0:

    datamodel = caosdb.Container()
    datamodel.extend([
        caosdb.Property("Query", datatype=caosdb.TEXT),
        caosdb.Property("templateDescription", datatype=caosdb.TEXT),
        caosdb.RecordType(
            "UserTemplate"
            ).add_property("Query", importance=caosdb.OBLIGATORY
            ).add_property("templateDescription", importance=caosdb.OBLIGATORY),
    ])

    datamodel.insert()


# test data
testdata = caosdb.Container()

if caosdb.execute_query("COUNT Record 'Test Template (Delete with Error)'") == 0:
    testdata.append(
        caosdb.Record(
            "Test Template (Delete with Error)"
            ).add_parent("UserTemplate"
            ).add_property("Query", "FIND Error"
            ).add_property("templateDescription",
                           "Test Template (Delete with Error)")
    )

if caosdb.execute_query("COUNT Record 'Test Template (Referencing)'") == 0:
    testdata.append(
        caosdb.Record(
            "Test Template (Referencing)"
            ).add_parent("UserTemplate"
            ).add_property("UserTemplate", "Test Template (Delete with Error)")
    )

for i in range(2):
    testdata.append(
        caosdb.Record(
            "Test Template (User {})".format(i)
            ).add_parent("UserTemplate"
            ).add_property("Query", "FIND Thing{}".format(i)
            ).add_property("templateDescription",
                           "Test Template (User {})".format(i))
    )

testdata.insert();



