#!/bin/bash
#
# ** header v3.0
# This file is a part of the CaosDB Project.
#
# Copyright (C) 2021 IndiScale GmbH
# Copyright (C) 2021 Timm Fitschen <t.fitschen@indiscale.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program. If not, see <https://www.gnu.org/licenses/>.
#
# ** end header

# This file can be used to merge js files together.
#
# call: `./merge_js.sh [JS_FILE]*`
#     where the JS_FILE are the files which will be merged into the resulting
#     `public/webcaosdb.dist.js` in the order they appear in the command line
#     call. See `Makefile` for an example.
#
# All other files in `public/js` are appended to the resulting file in no
# particular order.


CORE_MODULES=$@
PUBLIC_JS_DIR=public/js/
DIST_BUNDLE=webcaosdb.dist.js
DIST_BUNDLE_TARGET=public/${DIST_BUNDLE}
JSHEADER_TARGET=public/xsl/jsheader.xsl
ALL_SOURCES=()

_create_jsheader () {
    _JS_INCLUDE=
    if [ "$JS_DIST_BUNDLE" == "TRUE" ] ; then
        _SIZE=$(( $(wc -c ${DIST_BUNDLE_TARGET} | awk '{print $1}')/1024))
        echo "including ${DIST_BUNDLE} (${_SIZE}kB) into ${JSHEADER_TARGET}"
        _JS_INCLUDE="
    <xsl:element name=\"script\">
      <xsl:attribute name=\"src\">
        <xsl:value-of select=\"concat(\$basepath,'webinterface/\${BUILD_NUMBER}/${DIST_BUNDLE}')\"/>
      </xsl:attribute>
    </xsl:element>
    "
        [[ -f "public/index.html" ]] && sed -i "s|^\(.*JS_INCLUDE.*\)$|    <script src=\"${DIST_BUNDLE}\"><\/script>\n\1|g" public/index.html ;
    else
        _ALL_SOURCES=$@
        echo "${_ALL_SOURCES}"
        for _SOURCE in ${_ALL_SOURCES[@]} ; do
            _SIZE=$(( $(wc -c ${_SOURCE} | awk '{print $1}')/1024))
            _SOURCE=js/${_SOURCE/${PUBLIC_JS_DIR}/}
            echo "including ${_SOURCE} (${_SIZE}kB) into ${JSHEADER_TARGET}"
            _JS_INCLUDE="${_JS_INCLUDE}
    <xsl:element name=\"script\">
      <xsl:attribute name=\"src\">
        <xsl:value-of select=\"concat(\$basepath,'webinterface/\${BUILD_NUMBER}/${_SOURCE}')\"/>
      </xsl:attribute>
    </xsl:element>
    "
            sed -i "s|^\(.*JS_INCLUDE.*\)$|    <script src=\"${_SOURCE}\"><\/script>\n\1|g" public/index.html ;
        done
    fi


    echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<!-- THIS FILE IS AUTO-GENERATED BY THE merge_js.sh SCRIPT -->
<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">
  <xsl:output method=\"html\"/>
  <xsl:template name=\"caosdb-head-js\">
    <script>
        window.sessionStorage.caosdbBasePath = \"<xsl:value-of select=\"\$basepath\"/>\";
    </script>
    ${_JS_INCLUDE}
  </xsl:template>
</xsl:stylesheet>" > ${JSHEADER_TARGET}
}

function _merge () {
    if [ "$JS_DIST_BUNDLE" != "TRUE" ] ; then
        return 0
    fi
    _SOURCE=$2
    _TARGET=$3

    echo "merging $1 module ${_SOURCE} into ${_TARGET}"


    echo "//COPIED FROM ${_SOURCE} (START)" >> ${_TARGET}
    cat ${_SOURCE} >> ${_TARGET}
    echo "//COPIED FROM ${_SOURCE} (END)" >> ${_TARGET}

    rm ${_SOURCE}
}

# clean up old
rm $DIST_BUNDLE_TARGET || true
touch $DIST_BUNDLE_TARGET

for _SOURCE in ${CORE_MODULES[@]} ; do
    [[ ! " ${ALL_SOURCES[@]} " =~ " ${_SOURCE} " ]] && ALL_SOURCES+=(${PUBLIC_JS_DIR}${_SOURCE})
    _merge "core" "${PUBLIC_JS_DIR}${_SOURCE}" $DIST_BUNDLE_TARGET
done

if [ "$AUTO_DISCOVER_MODULES" == "TRUE" ] ; then
    # load other js files but exclude any subdirectory
    for _SOURCE in $(find ${PUBLIC_JS_DIR}* -prune -iname "*.js") ; do
        [[ ! " ${ALL_SOURCES[@]} " =~ " ${_SOURCE} " ]] && ALL_SOURCES+=(${_SOURCE})
        _merge "extension" ${_SOURCE} $DIST_BUNDLE_TARGET
    done
fi

# for `make test`
for _SOURCE in $(find ${PUBLIC_JS_DIR} -ipath "${PUBLIC_JS_DIR}modules/*.js") ; do
    [[ ! " ${ALL_SOURCES[@]} " =~ " ${_SOURCE} " ]] && ALL_SOURCES+=(${_SOURCE})
    _merge "extension" ${_SOURCE} $DIST_BUNDLE_TARGET
done

_create_jsheader ${ALL_SOURCES[@]}
