#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
(C) Copyright IndiScale GmbH 2019
"""

import caosdb
import random

caosdb.get_connection()._login()

# data model
datamodel = caosdb.Container()
datamodel.extend([
    caosdb.Property("longitude", datatype=caosdb.DOUBLE, unit="°"),
    caosdb.Property("latitude", datatype=caosdb.DOUBLE, unit="°"),
    caosdb.RecordType(
        "MapObject"
        ).add_property("longitude", importance=caosdb.OBLIGATORY
        ).add_property("latitude", importance=caosdb.OBLIGATORY),
    caosdb.RecordType(
        "PathObject"
        ).add_property("MapObject", datatype=caosdb.LIST("MapObject")),
])

datamodel.insert()


# test data

testdata = caosdb.Container()

path = caosdb.Record()
path.add_parent("PathObject")
path.add_property("MapObject", datatype=caosdb.LIST("MapObject"), value=[])
testdata.append(path)

for i in range(100):
    loc = caosdb.Record(
        "Object-{}".format(i)
        ).add_parent("MapObject"
        ).add_property("longitude", random.gauss(-42.0, 5)
        ).add_property("latitude", random.gauss(77.0, 5))
    testdata.append(loc)
    path.get_property("MapObject").value.append(loc)



testdata.insert();



