#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
(C) Copyright 2019-2020 IndiScale GmbH <info@indiscale.com>
(C) Copyright 2019-2020 Timm Fitschen <t.fitschen@indiscale.com>

Test entities for the ext_references module.
"""

import caosdb
import random

d = caosdb.execute_query("FIND TestReferenc*")
if len(d) > 0:
    d.delete()

# data model
datamodel = caosdb.Container()
datamodel.extend([
    caosdb.RecordType("TestReferenced"),
    caosdb.RecordType(
        "TestReferencing"
        ).add_property("TestReferenced", datatype=caosdb.LIST("TestReferenced")),
])

datamodel.insert()


# test data
testdata = caosdb.Container()

for i in range(100):
    testdata.append(
        caosdb.Record("TestReferenceObject-{}".format(i)
            ).add_parent("TestReferenced")
    )

testdata.insert();
caosdb.Record().add_parent(
    "TestReferencing"
    ).add_property("TestReferenced",
                   datatype=caosdb.LIST("TestReferenced"),
                   value=testdata
    ).insert()

