# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.10.0] - 2022-12-19
(Florian Spreckelsen)

### Added

* [#191](https://gitlab.com/caosdb/caosdb-webui/-/issues/191) - "Configure the
  RecordType which is searched by the simple search."
  A list of entity roles and names can be specified via the newly added
  `BUILD_FREE_SEARCH_ROLE_NAME_FACET_OPTIONS` build variable. See the docstring
  of `queryForm.initFreeSearch` for more information.
* [#188](https://gitlab.com/caosdb/caosdb-webui/-/issues/188) Properties can be
  hidden/shown only for certain users/roles.
* [#189](https://gitlab.com/caosdb/caosdb-webui/-/issues/189) The order in which
  the properties of (Records of) a RecordType are displayed can be configured.

### Changed (for changes in existing functionality)

* Version bump of caosdb_map module (0.5.0):
  * Added configurable entityLayers
  * Changed name of the icon option to icon_options, because that name better
    distiguished the options from the result icon object.
* New behavior of the "Enter" key in the query input text field: When pressed
  when the autocompletion drop-down is open, the enter key selects an option
  from the autocompletion (this is as it was before). But when the "Enter" key
  is pressed, when the autocompletion drop-down is not open, the query is being
  submitted.

## [0.9.0] - 2022-11-02
(Florian Spreckelsen)

### Changed (for changes in existing functionality)

* ext_references: names will be shown instead of file names if they exist

### Fixed

* Uncaught exception in dropdown menus of the edit mode when pressing arrow
  down or arrow up.
* [#182](https://gitlab.com/caosdb/caosdb-webui/-/issues/182) - Quotes breake
  "googly" search
* Hidden boolean select in edit mode.
* Missing latitude or longitude does no longer cause a problem when the element
  is on the current page

## [0.8.0] - 2022-07-12
(Timm Fitschen)

### Added

* Cache for queries in the edit_mode.

### Changed

* The "google query" now splits the given string at the spaces and creates an
  AND query (e.g., `john gibson` will result in `FIND ENTITY WHICH HAS A
  PROPERTY LIKE '*john*' AND A PROPERTY LIKE '*gibson*'`, not in `FIND ENTITY
  WHICH HAS A PROPERTY LIKE '*john gibson*'` as before).

### Deprecated

### Removed

### Fixed

* Styling of the selects in the edit_mode.

### Security

### Documentation

## [0.7.0] - 2022-05-31
(Florian Spreckelsen)

### Added

* [#172](https://gitlab.com/caosdb/caosdb-webui/-/issues/172) - Map can handle
  geo locations in list of references.

### Fixed

* [#276](https://gitlab.indiscale.com/caosdb/src/caosdb-webui/-/issues/276)
  documentation couldn't be built because of a too long module name.

## [0.6.0] - 2022-05-03
(Daniel Hornung)

### Changed

* Renamed the person reference resolver.

### Fixed

* [webui#170](https://gitlab.com/caosdb/caosdb-webui/-/issues/170)
  Autocompletion for "IS REFERENCED BY" leads to query syntax error

## [0.5.0] - 2022-03-25
(Timm Fitschen)

### Added

* entity_acl module which adds a button to each entity which links to the
  webui-acm module. Enable via BUILD_MODULE_EXT_ENTITY_ACL=ENABLED.
* A `#version_history` URI fragment which can be used to directly open the modal
  with the full version history of the first entity on the page.
* `BUILD_MODULE_SHOW_ID_IN_LABEL` build variable with which the showing of
  entity ids together with their names if it is enabled (disabled by default).
* Introduced `caosdb-f-form-required-marker` and `caosdb-f-form-required-label`
  css classes for the markers of required fields in CaosDB form elements.
* The navbar has now an html id `caosdb-navbar-full`

### Changed

* Added `show` option to caosdb_map.MapConfig for showing the map initially and
  storing the state accross page reloads. Defaults to `false`. This also bumps
  the version of the map to 0.4.1 as it changes the behavior but the change is
  backwards-compatible for the map config. Clients need to update their
  version string in their config file, tho.

### Deprecated

### Removed

* globla `setNameID` function (replaced by `_setDescriptionNameID` which should
  only be used be the non-public XML-serialization functions.)

### Fixed

* Fixed saving of text properties that were changed in the Source-Editing mode
  of the WYSIWYG editor.
* [#266](https://gitlab.indiscale.com/caosdb/src/caosdb-webui/-/issues/266)
  Fixed an issue whereby missing property descriptions in the edit mode would
  lead to wrongly detected entity updates in the server

### Security

### Documentation

## [0.4.2] - 2021-12-06

### Added (for new features, dependecies etc.)

* Documentation link in standard footer
* Build properties for footer elements:
  * `BUILD_FOOTER_CONTACT_HREF`
  * `BUILD_FOOTER_IMPRINT_HREF`
  * `BUILD_FOOTER_DOCS_HREF`
  * `BUILD_FOOTER_SOURCES_HREF`
  * `BUILD_FOOTER_LICENCE_HREF`
  See `build.properties.d/00_default.properties` for more information
* Start editing an entity/creating a new record directly by adding an `#edit` or
  `#new_record` URI fragment, respectively.
* Optional WYSIWYG editor with markdown output for text properties. Controled by
  the `BUILD_MODULE_EXT_EDITMODE_WYSIWYG_TEXT` build variable which is set do
  `DISABLED` by default.
* Added button to version history panel that allows restoring old versions

### Changed (for changes in existing functionality)

* Default footer elements contain invalid links for imprint, contact, and data-policy now

### Deprecated (for soon-to-be removed features)

### Removed (for now removed features)

* Build property `BUILD_CUSTOM_IMPRINT`. Please use BUILD_FOOTER_IMPRINT_HREF
  and link a document instead. You can always put a html page to
  `src/ext/html/` and link to that.

### Fixed (for any bug fixes)
- #156
- #251

### Security (in case of vulnerabilities)

### Documentation (for notable additions or changes of the documentation)


## [0.4.1] - 2021-11-04

### Added (for new features, dependecies etc.)

* `form_panel` module for conveniently creating a panel for web forms.
* `restore_old_version` function to base functionality (caosdb.js)
* buttons to the version history modal that allow restoring older versions

### Changed (for changes in existing functionality)

* Default footer elements contain invalid links for imprint, contact, and data-policy now

### Deprecated (for soon-to-be removed features)

### Removed (for now removed features)

* Build property `BUILD_CUSTOM_IMPRINT`. Please use BUILD_FOOTER_IMPRINT_HREF
  and link a document instead. You can always put a html page to
  `src/ext/html/` and link to that.

### Fixed (for any bug fixes)

* Auto-completion and edit_mode can handle entity names with empty spaces better now
* [#251](https://gitlab.indiscale.com/caosdb/src/caosdb-webui/-/issues/251) - Data loss when editing Entities with URL-like properties

### Security (in case of vulnerabilities)

### Documentation (for notable additions or changes of the documentation)

## [0.4.0] - 2021-10-28

### Added (for new features, dependecies etc.)

* Module `ext_qrcode` which generates a QR Code for an entity (pointing to the
  the head or the exact version).
* Optional functionality to bookmark all query results. Note that too many
  bookmarks will result in the URI being too lang and bookmarks will have to be
  cleared manually.

### Changed (for changes in existing functionality)

### Deprecated (for soon-to-be removed features)

### Removed (for now removed features)

* `getEntityId`, a former duplicate of `getEntityID` which must be used instead.

### Fixed (for any bug fixes)

### Security (in case of vulnerabilities)

### Documentation (for notable additions or changes of the documentation)

## [v0.4.0-rc1] - 2021-06-16

### Added (for new features, dependecies etc.)

- `ext_applicable` module for building fancy features which append
  functionality to entities (EXPERIMENTAL).
- `ext_cosmetics` module which converts http(s) uris in property values into
  clickable links (with tests)
- Added a menu/toc for the tour
- Added a previous and next buttons for pages in the tour
- Added warnings to inform about minimum width when accessing tour and
  edit mode on small screens.
- Added a tutorial for the edit mode to the documentation
- Documentation on how to customize reference resolving

### Changed (for changes in existing functionality)

- Updated from bootstrap 3 to bootstrap 5. This is a major change which will
  possibly break existing custom implementations (e.g. a custom welcome page)
  since a lot of classes where renamed by bootstrap an other classes have been
  dropped entirely (e.g. "jumbotron"). Please have a look at
    * https://getbootstrap.com/docs/5.0/migration/
    * https://getbootstrap.com/docs/4.6/migration/
- Moved the resolving of references to Person Records to separate
  example which can be disabled

### Deprecated (for soon-to-be removed features)

- css-class `.caosdb-property-text-value`. Please use
  `.caosdb-f-property-text-value` or `.caosdb-v-property-text-value` instead.

### Removed (for now removed features)

* `#subnav` element from navbar which was previously used for spacing
* `caosdb.form.ready` event

### Fixed

- #212 - form_elements: Drop-down menu shows wrong value after clicking "None"
- #202 - Make filter fields in edit mode toolbox visible
- #117 - Reload data model after adding an RT or a Property
- #214 - Paging panel is hidden.
- Displaying issues with long lists in property values
- An issue whereby a grey container would appear above the map when
  changing the map view.
- #200 - Re-enabled the file-upload button

### Security (in case of vulnerabilities)

## [v0.3.1] - 2021-06-15

This is the last Bootstrap-3 compatible release.

### Added (for new features, dependecies etc.)

* Displaying and interacting with the entity state.
* Change password functionality for users of the internal user source. Disable
  with `BUILD_MODULE_USER_MANAGEMENT=DISABLED` and set the user realm with
  `BUILD_MODULE_USER_MANAGEMENT_CHANGE_OWN_PASSWORD_REALM=CaosDB`.
* Visually highlighted drop zones for properties and parents in the edit_mode.
* two new field types for the form_elements module, `file` and `select`. See
  the module documentation for more information.

### Changed (for changes in existing functionality)
- The heading attributes datatype, path, checksum and size are now placed
  in a `details` html element.

### Deprecated (for soon-to-be removed features)

* Any bootstrap-3 dependencies. Please prepare upgrading to bootstrap-5 with the next release.

### Removed (for now removed features)

* `ext_revisions` module. This module was only a work-around which had been
  used for versioning functionality before the native versioning was
  implemented. Also, the `BUILD_MODULE_EXT_REVISIONS` is no longer used and can
  be removed from the config files in `build.properties.d/`

### Fixed

* #156 - Edit mode for Safari 11
* #160 - Entity preview for Safari 11
* Several minor cosmetic flaws
* Fixed edit mode for Safari 11.

### Security (in case of vulnerabilities)

## [v0.3.0] - 2021-02-10

### Added (for new features, dependecies etc.)

- The versioning model has a new styling and can show and tsv-export the full
  version history now.
- Module `ext_bookmarks` which allows users to bookmark entities, store them in
  a link or export them to TSV.
- table previews in the bottom line module
- added preview for tif images
* new function `form_elements.make_alert` which generates a proceed/cancel
  dialog which intercepts a function call and asks the user for confirmation.
* Deleting entities prompts for user confirmation after hitting the "Delete"
  button (edit_mode).
* Plotly preview has an additional parameter for a config object,
  e.g., for disabling the plotly logo
- The map can now show entities that have no geo location but are related to
  entities that have one. This also effects the search from the map.
* `getPropertyValues` function which generates a table of property values from
  a xml representation of entities.
* After a SELECT statement now also all referenced files can be downloaded.
* Automated documentation builds: `make doc`
- documentation on queries

### Changed (for changes in existing functionality)

* ext_map version bumped to 0.4
- enabled and enhanced autocompletion
* Login form is hidden behind another button.

### Deprecated (for soon-to-be removed features)

### Removed (for now removed features)

### Fixed

- #144 (Select with ANY VERSION OF).
- #136 (adding reference properties to entities in edit mode)
- exclude configuration files when reading files from build.properties.d
- summaries when opening preview
- #125 special characters like "\t", \"n", "#" are replaced in table
  download
- #158 show preview if the entity is too large for the viewport if
  bottom line is in view.

### Security (in case of vulnerabilities)

## [v0.2.1] - 2020-09-07

### Added (for new features, dependecies etc.)

* `ext_jupyterdrag` (v0.1) module for dragging entities into jupyter notebooks.

### Changed (for changes in existing functionality)

### Deprecated (for soon-to-be removed features)

### Removed (for now removed features)

### Fixed

### Security (in case of vulnerabilities)

## [v0.2] - 2020-09-02

### Added (for new features, dependecies etc.)

* Build variable `EXT_REFERENCES_CUSTOM_REFERENCE_RESOLVER`. The value of this
  variable must be module which has at least a `resolve(id)` function, which
  returns a `reference_info` object for further processing by the
  `resolve_references` module.
* `ext_sss_markdown` module for pretty display of server-side scripting stdout.
  See module docstring for more information.
* `ext_trigger_crawler_form` module which generates a form for triggering the
  crawler. See module docstring for more info.
* Support for deeply nested selectors in SELECT queries.
* edit_mode supports reference properties when inserting/updating properties
  (See [#83](https://gitlab.com/caosdb/caosdb-webui/-/issues/83) and
  [#55](https://gitlab.com/caosdb/caosdb-webui/-/issues/55)).
* new `navbar.add_tool` method which adds a button to submenu of the navbar.
* new CSS classes for the styling of the default image and video preview of the
  `ext_bottom_line` module: `caosdb-v-bottom-line-image-preview` and
  `caosdb-v-bottom-line-video-preview`.
* basic support for entity versioning:
    * entity.xsl generates a versioning button which opens a versioning info modal.
    * `preview` also works for versioned references
    * `edit_mode` prevents the user from editing old versions of an entity.

### Changed (for changes in existing functionality)
- The `navbar.add_button` signatur changed to `add_button(button, options)`.
  See the doc string of that method for more information.
- added a layout argument to the create_plot function of ext_bottom_line

### Deprecated (for soon-to-be removed features)

* css class `caosdb-property-text-value` is deprecated because different
  functionality interpreted it differently and most of the uses of this class
  have already been removed and replaced by specialized classes.

### Removed (for now removed features)

### Fixed

* #101 - loading of A LOT of references in `ext_references` slows down the
  webui or even freezes the brower.
* Fixed a bug where the Tour would lose its state upon page reload.

### Security (in case of vulnerabilities)

## [v0.2-rc.1] - 2020-04-10

### Added (for new features, dependecies etc.)

* ext_bottom_line module (v0.1 - Experimental)
    * A module which adds a preview section where any kind of summarizing
      information (like plots, video players, thumbnails...) can be shown.
    * Enable with build property `BUILD_MODULE_EXT_BOTTOM_LINE=ENABLED`.
    * More documentation in `src/core/js/ext_bottom_line.js`.
* ext_revisions (v0.1 - EXPERIMENTAL)
    * Creates a backup copy of each entity which is updated via the edit_mode.
    * Enable via the build property `BUILD_MODULE_EXT_REVISIONS=ENABLED`.
    * Needs two special entities. A RecordType "Obsolete" and a reference
      property "revisionOf" with data type "Obsolete".
* Map (v0.3)
    * Adds a button to the navbar which toggles a map in the top of the main
      panel. The map currently shows all known entities which have geolocation
      properties and highlights those which are on the current page. Users can
      select an area in the map and generate a query filter for this area which
      is can be openend in the query panel.
    * See the caosdb_map module in  [ext_map.js](./src/core/js/ext_map.js)
    * The default configuration is located in the module itself.
    * The module needs an additional [ext_map.json](./conf/ext/json/ext_map.json)
      which defines at least the tiling server. The tiling server is not
      configured in the default config because this would require the caosdb
      maintainers to enforce the respective usage policies of the tiling server
      providers.
    * Test data for your server can be generated with
      [map_test_data.py](./misc/map_test_data.py).
    * The map module supports different map projections, e.g. Spherical
      Mercartor and projections for the polar regions. The active projection
      can changed by the user with a button.
* navbar module (v0.1)
    * A collection of helper functions for adding stuff to the navbar.
* caosdb_utils module (v0.1)
    * A collection of helper functions for multiple purposes, especially for
      checking a functions parameters (to mimic type savety).
* New Dependency: leaflet-1.5-1
    * for the map
* New Dependency: loglevel-1.6.4
    * Our new logging framework. Any new logging should be done with this
      framework.
* File Upload (v0.1 - EXPERIMENTAL)
    Works only for non-LIST properties
* Edit Mode - switch the LISTishness of entity properties back and forth.

### Changed (for changes in existing functionality)

* The old `caosdb-property-row` CSS class has been replaced by
  `caosdb-v-property-row` for styling and `caosdb-f-property` for functional
  needs.
* The old `caosdb-property-value` and `caosdb-property-edit-value` CSS classes
  have been merged into a new `caosdb-f-property-value` class.
* In [ext_xls_download.js](./src/core/js/ext_xls_download.js): Complete rewrite
  of the module. The generation of the TSV table is done in this module now,
  instead of generating it with xsl (in [query.xsl](./src/core/xsl/query.xsl)).
  Also it is generated on demand.
* In [ext_references.js](./src/core/js/ext_references.js): Updated
  ext_references to v0.2. The new version can also generate and show summaries
  of `LIST` properties.
* In [entity.xsl](./src/core/xsl/entity.xsl): an emtpy property value (a `NULL`
  property) did not produce any `<span>` element with class
  `caosdb-property-text-value`. This caused the current implementation of
  `getPropertyFromElement` in [caosdb.js](./src/core/js/caosdb.js) to return
  the unit of the property as the value. The new implementation produces an
  empty `<span>` (no child text node) which is more appropriate and also fixes
  the buggy `getPropertyFromElement` without touching it.
* In [webcaosdb.js](./src/core/js/webcaosdb.js), `markdown` module: The
  markdown module is very generell and small now. The logic for converting
  comments (aka CommentAnnotations) to markdown is implemented in the
  `annotation` module now (which uses the `markdown` module as back-end, tho).
* updated QUnit test framework to 2.9.2


### Deprecated (for soon-to-be removed features)

* Image Preview in the FileSystem. The functionality is to be replaced by real
  thumbnails, which cover also non-image data-formats. The thumbnails resource
  is part of the new file system API of the CaosDB Server which is currently
  under development.

### Removed (for now removed features)

* Removed non-informative tests for webcaosdb.css
* Hard-coded image and video preview in the entity panel. The preview of images
  and videos is controlled by the `ext_bottom_line` module now.

### Fixed (for any bug fixes)

* #95 - Edit Mode removes property values of reference properties when server
  response for possible reference targets is empty.
* Bug in `getPropertyFromElement` (see above) which returned the unit as the
  property value if the actual value was an empty string.

### Security (in case of vulnerabilities)
