#!/usr/bin/env python3
# encoding: utf-8
#
# ** header v3.0
# This file is a part of the CaosDB Project.
#
# Copyright (C) 2021 Indiscale GmbH <info@indiscale.com>
# Copyright (C) 2021 Henrik tom Wörden <h.tomwoerden@indiscale.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program. If not, see <https://www.gnu.org/licenses/>.
#
# ** end header
#

"""
test identified_cache module
"""

from caoscrawler.identified_cache import _create_hashable_string, IdentifiedCache
import caosdb as db


def test_create_hash():
    assert _create_hashable_string(
        db.Record("A").add_parent("B")) == "P<B>N<A>"
    assert _create_hashable_string(db.Record("A")
                                   .add_parent("B").add_property('a', 5)) == "P<B>N<A>a:5"
    assert (_create_hashable_string(
        db.Record("A").add_parent("B")
        .add_property('a', 4).add_property('b', 5)) == _create_hashable_string(
            db.Record("A").add_parent("B")
            .add_property('b', 5).add_property('a', 4)))
    assert (_create_hashable_string(db.Record("A")
                                    .add_parent("B")
                                    .add_property('a', db.Record(id=12))) == "P<B>N<A>a:12")
    assert (_create_hashable_string(db.Record("A")
                                    .add_parent("B")
                                    .add_property('a', [db.Record(id=12)])) == "P<B>N<A>a:[12]")
    assert (_create_hashable_string(db.Record("A")
                                    .add_parent("B").add_property('a', [12])) == "P<B>N<A>a:[12]")
    assert (_create_hashable_string(
        db.Record("A")
        .add_parent("B")
        .add_property('a', [db.Record(id=12), 11])) == "P<B>N<A>a:[12, 11]")
    assert (_create_hashable_string(
            db.Record().add_parent("B").add_property('a', [db.Record()]))
            != _create_hashable_string(
            db.Record().add_parent("B").add_property('a', [db.Record()])))


def test_IdentifiedCache():
    ident = db.Record("A").add_parent("B")
    record = db.Record("A").add_parent("B").add_property('b', 5)
    cache = IdentifiedCache()
    assert ident not in cache
    cache.add(record=record, identifiable=ident)
    assert ident in cache
    assert record not in cache
    assert cache[ident] is record
