# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.2.0] - 2022-11-18 ##
(Florian Spreckelsen)

### Added ###
- the -c/--add-cwd-to-path option allows to plays for example custom converter
  modules into the current working directory(cwd) since the cwd is added to
  the Python path.

### Changed ###

- Converters often used in dicts (DictFloatElementConverter,
  DictIntegerElementConverter, ...) do now accept other StructureElements by
  default. For example a DictIntegerElement is accepted by default instead of a
  DictFloatElement. This behavior can be changed (see converter documentation).
  **Note** This might lead to additional matches compared to previous versions.
- `_AbstractDictElementConverter` uses `re.DOTALL` for `match_value`
- The "fallback" parent, the name of the element in the cfood, is only used 
  when the object is created and only if there are no parents given.

### Deprecated ###

### Removed ###

### Fixed ###

* [#31](https://gitlab.com/caosdb/caosdb-crawler/-/issues/31) Identified cache:
  Hash is the same for Records without IDs
* [#30](https://gitlab.com/caosdb/caosdb-crawler/-/issues/30)
* [#23](https://gitlab.com/caosdb/caosdb-crawler/-/issues/23) Crawler may
  overwrite and delete existing data in case of manually added properties
* [#10](https://gitlab.com/caosdb/caosdb-crawler/-/issues/10) floats can be
  interpreted as integers and vice versa, there are defaults for allowing other
  types and this can be changed per converter

### Security ###

## [0.1.0] - 2022-10-11
(Florian Spreckelsen)

### Added

* Everything
* Added new converters for tables: CSVTableConverter and XLSXTableConverter
* Possibility to authorize updates as in the old crawler
* Allow authorization of inserts
* Allow splitting cfoods into multiple yaml documents
* Implemented macros
* Converters can now filter the list of children
* You can now crawl data with name conflicts: `synchronize(unique_names=False)`

### Changed

* MAINT: Renamed module from `newcrawler` to `caoscrawler`
* MAINT: Removed global converters from `crawl.py`

### Fixed

* FIX: #12
* FIX: #14
* FIX: Variables are now also replaced when the value is given as a list.
* FIX: #35 Parent cannot be set from value
* [#6](https://gitlab.com/caosdb/caosdb-crawler/-/issues/6): Fixed many type
  hints to be compatible to python 3.8
* [#9](https://gitlab.com/caosdb/caosdb-crawler/-/issues/9): Sclaras of types
  different than string can now be given in cfood definitions
