/*
 * ** header v3.0
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2018 Research Group Biomedical Physics,
 * Max-Planck-Institute for Dynamics and Self-Organization Göttingen
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * ** end header
 */
package org.caosdb.server.jobs.core;

import java.util.List;
import java.util.Objects;
import org.caosdb.server.database.backend.transaction.GetDependentEntities;
import org.caosdb.server.entity.EntityID;
import org.caosdb.server.entity.EntityInterface;
import org.caosdb.server.jobs.EntityJob;
import org.caosdb.server.utils.EntityStatus;
import org.caosdb.server.utils.ServerMessages;

/**
 * Check whether an entity is referenced by other entities. In the event that someone wants to
 * delete this entity, this entity must not be referenced by any other entity which is not deleted
 * along with this entity.
 *
 * @author tf
 */
public class CheckReferenceDependencyExistent extends EntityJob {
  @Override
  public final void run() {
    if (getEntity().getDomain() == null
        || Objects.equals(getEntity().getDomain(), EntityID.DEFAULT_DOMAIN)) {
      // if (getContainer().contains(getEntity())) {

      // retrieve dependent entities
      final List<EntityID> depends =
          execute(new GetDependentEntities(getEntity().getId())).getList();

      // loop:
      for (final EntityID id : depends) {
        final EntityInterface foreign = getEntityById(id);
        if (foreign == null) {
          // dependent entity is not in the container and will not be
          // deleted. Therefore, this entity cannot be deleted either.
          getEntity().addError(ServerMessages.REQUIRED_BY_PERSISTENT_ENTITY);
          getEntity().addInfo("Required by entity " + id + ".");
          getEntity().setEntityStatus(EntityStatus.UNQUALIFIED);
        }
        // for (final EntityInterface e : getContainer()) {
        // if (e.getId().equals(id)) {
        // // entity is in the container.
        // if (e.getEntityStatus() == EntityStatus.UNQUALIFIED) {
        // getEntity().addError(ServerMessages.REQUIRED_BY_UNQUALIFIED);
        // getEntity().addInfo("Required by entity " + id + ".");
        // getEntity().setEntityStatus(EntityStatus.UNQUALIFIED);
        // } else {
        // e.acceptObserver(new Observer() {
        // @Override
        // public boolean notifyObserver(final String evt,
        // final Observable o) {
        // if (e == o && evt == Entity.ENTITY_STATUS_CHANGED_EVENT) {
        // if (e.getEntityStatus() == EntityStatus.UNQUALIFIED) {
        // getEntity().addError(
        // ServerMessages.REQUIRED_BY_UNQUALIFIED);
        // getEntity().addInfo("Required by entity " + id + ".");
        // getEntity().setEntityStatus(EntityStatus.UNQUALIFIED);
        // return false;
        // }
        // }
        // return true;
        // }
        // });
        // }
        //
        // continue loop;
        // }
        // }

        // // dependent entity is not in the container. That is, it will
        // // not be deleted. Therefore, this entity cannot be deleted
        // // either.
        // getEntity().addError(ServerMessages.REQUIRED_BY_PERSISTENT_ENTITY);
        // getEntity().addInfo("Required by entity " + id + ".");
        // getEntity().setEntityStatus(EntityStatus.UNQUALIFIED);
      }
    }
  }
}
