package org.caosdb.server.grpc;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCall.Listener;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor implements ServerInterceptor {

  private static final Logger logger = LoggerFactory.getLogger(LoggingInterceptor.class.getName());

  @Override
  public <ReqT, RespT> Listener<ReqT> interceptCall(
      ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {

    logger.info(call.getMethodDescriptor().getFullMethodName() + " - " + call.getAttributes());
    return Contexts.interceptCall(Context.current(), call, headers, next);
  }
}
