package org.caosdb.server.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * EntityID
 *
 * <p>This class is an abstraction layer for the entity id.
 *
 * <p>It also allows to link entities together, e.g. an Entity's Property with the corresponding
 * abstract Property, even when the abstract Property does not have a valid ID yet (during bulk
 * inserts).
 */
public class EntityID implements Serializable {

  private static final long serialVersionUID = -9092133023135548179L;

  public static final EntityID DEFAULT_DOMAIN = new EntityID(0);
  private Integer i = null;
  private EntityID link = null;

  public EntityID() {}

  public EntityID(final Integer id) {
    this.i = id;
  }

  public void setId(final Integer i) {
    this.i = i;
  }

  public Integer toInteger() {
    if (this.link != null) {
      return this.link.toInteger();
    }
    return this.i;
  }

  @Override
  public String toString() {
    return toInteger().toString();
  }

  boolean hasId() {
    return this.i != null || this.link != null && this.link.hasId();
  }

  public void link(final EntityInterface entity) {
    this.link = entity.getId();
  }

  public void link(final EntityID entityId) {
    this.link = entityId;
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj instanceof EntityID) {
      return Objects.equals(((EntityID) obj).toInteger(), this.toInteger());
    }
    return false;
  }

  @Override
  public int hashCode() {
    if (this.hasId()) {
      return toInteger();
    }
    return super.hashCode();
  }

  public boolean isTemporary() {
    return toInteger() < 0;
  }

  public static boolean isReserved(final EntityID id) {
    return id.toInteger() < 100;
  }
}
