# Note #

>   This document has not been updated for a long time. Although it is concerned with the mostly
>   stable API, its content may no longer reflect the actual CaosDB behavior.

# AbstractProperty Specification

**Warning:** This specification is outdated. It is included to serve as a starting point for a more up-to-date description of the `Property` entity.

## Introduction
An `AbstractProperty` is one of the basal objects of CaosDB.
An `AbstractProperty` MUST have the following _qualities_ (shortcut in brackets):
* a persistent id (`id`)
* an unique name (`name`)
* a description (`description`)
* a type (`type`)
* a generator `generator`)
* a creator (`creator`) 
* a timestamp of it's date of creation (`created`) 
* a set of owners and owning groups (`owner`)
* a set rules which controls the access to that `AbstractProperty` (`permission`)
Depending on the `AbstractProperty's` type it MUST have one of the following _qualities_: 
* a unit (`unit`)
* a RecordType which is referenced by any instantiating ConcreteProperty. (`reference`)
This is described below. 

## Property Types
An `AbstractProperty` MUST have one of the following 7 types:
* `text`
* `integer`
* `double`
* `datetime`
* `reference`
* `file`

An `AbstractProperty` of type `text`, `datetime`, or `file` MUST NOT have any unit or referenced RecordType. A `double`, `integer` AbstractProperty MUST have a unit but MUST NOT have a referenced RecordType. A `reference` `AbstractProperty` MUST have referenced RecordType und MUST NOT have a unit.

## XML Representation of AbstractProperty Objects

An `AbstractProperty` is represented in xml by a `<Property/>` tag. It's _qualities_ except for `owner` and `permission` are represented by an xml attribute of the same name. E.g `<Property name="length"/> denotes an AbstractProperty which {{{name` is _length_. The `owner` and `permission` qualities are not in use, yet.
Depending on the purpose of the xml document (shall it represent an object in the database or an object _to be posted _to the database?) the `<Property/>` tag may actually have just a few of the mentioned "quality-attributes".

### GET AbstractProperty
Any xml representation of an `AbstractProperty` that is retrieved from the CaosDB Server MUST have exactly ONE of the following forms, depending on the `AbstractProperty's` type:
#### text

        <Property id="$id" name="$name" description="$description" generator="$generator" creator="$creator" created="$created" type="text" />
#### integer

        <Property id="$id" name="$name" description="$description" generator="$generator" creator="$creator" created="$created" type="integer" unit="$unit" />
#### double

        <Property id="$id" name="$name" description="$description" generator="$generator" creator="$creator" created="$created" type="double" unit="$unit" />
#### datetime

        <Property id="$id" name="$name" description="$description" generator="$generator" creator="$creator" created="$created" type="datetime" />
#### reference

        <Property id="$id" name="$name" description="$description" generator="$generator" creator="$creator" created="$created" type="reference" reference="$reference" />
#### file

        <Property id="$id" name="$name" description="$description" generator="$generator" creator="$creator" created="$created" type="file" />
'''General Notes:
* If the called Property does not exist or if the Property called without permission, the CaosDB Server will return an Error.

### POST AbstractProperty
Any xml representation of an `AbstractProperty` that is to be posted to the CaosDB server MUST have exactly ONE of the following forms, depending on the `AbstractProperty's` type:
#### text

        <Property name="$name" description="$description" generator="$generator" type="text" />
#### integer

        <Property name="$name" description="$description" generator="$generator" type="integer" unit="$unit" />
#### double

        <Property name="$name" description="$description" generator="$generator" type="double" unit="$unit" />
#### datetime

        <Property name="$name" description="$description" generator="$generator" type="datetime" />
#### reference

        <Property name="$name" description="$description" generator="$generator" type="reference" reference="$reference" />
#### file

        <Property name="$name" description="$description" generator="$generator" type="file" />
*General Notes:*
* The `AbstractProperty's` `id` and timestamp (`created`) will be generated by the CaosDB Server.
* The `AbstractProperty's` creator will be determined by the CaosDB Server depending on it's policy configuration.
* Any given attribute beyond these will be *ignored*.
* If the `<Property/>` tag isn't compliant with these the CaosDB Server will return an Error.

----
## Examples
### GET Requests
#### Single-Get
*Request:*

        GET http://localhost:8122/mpidsserver/AbstractProperty/1

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property id="1" name="explanation" type="text" description="explains the thing" generator="Timm (manually)"/>
        </Response>
----
*Request:*

        GET http://localhost:8122/mpidsserver/AbstractProperty/explanation

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property id="1" name="explanation" type="text" description="explains the thing" />
        </Response>
----
#### Multi-Get
*Request:*

        GET http://localhost:8122/mpidsserver/AbstractProperty/explanation&2&3

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property id="1" name="explanation" type="text" description="explains the thing" />
          <Property id="2" name="comment" type="text" description="A comment" generator="Timm (manually)"/>
          <Property id="3" name="name" type="text" description="Name" generator="Timm (manually)" />
        </Response>
----
#### Get all
*Request:*

        GET http://localhost:8122/server/AbstractProperty/
        GET http://localhost:8122/server/AbstractProperty

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response />
#### Erroneous Requests
##### Non-existing
*Request:*

        GET http://localhost:8122/mpidsserver/AbstractProperty/123456
*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property id="123456">
            <Error code="201" description="Property does not exist. " />
          </Property>
        </Response>
----
### POST Requests

*Request is to be sent to:*

        POST http://localhost:8122/mpidsserver/AbstractProperty/
        POST http://localhost:8122/mpidsserver/AbstractProperty
----
#### Single-Post
*Request body:*

        <Post>
          <Property name="TimmsIntegerProperty1" type="integer" description="This is TimmsIntegerProperty1" unit="kg" generator="Timm (manually)"/>
        </Post>

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property id="39" name="TimmsIntegerProperty1" type="integer" unit="kg" description="This is TimmsIntegerProperty1" generator="Timm (manually)"/>
        </Response>
----
*Request body (with a reference to Property 12345):*

        <Post>
          <Property name="Timms reference property 1" type="reference" reference="12345" description="This is Timms reference property 1"/>
        </Post>
----
#### Multi-Post
*Request body:*

        <Post>
          <Property name="TimmsIntegerProperty7" type="integer" description="This is TimmsIntegerProperty7" unit="kg" generator="Timm (manually)"/>
          <Property name="TimmsIntegerProperty8" type="integer" description="This is TimmsIntegerProperty8" unit="kg" generator="Timm (manually)"/>
          <Property name="TimmsIntegerProperty9" type="integer" description="This is TimmsIntegerProperty9" unit="kg" generator="Timm (manually)"/>
        </Post>

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          ...
          <Property id="41" name="TimmsIntegerProperty9" type="integer" unit="kg" description="This is TimmsIntegerProperty9" generator="Timm (manually)"/>
        </Response>

----
#### Erroneous Requests
##### No Description
*Request body:*

        <Post>
          <Property name="TimmsIntegerProperty3" type="integer" unit="kg" generator="Timm (manually)"/>
        </Post>
*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property name="TimmsIntegerProperty3" type="integer" unit="kg">
            <Error code="202" description="Property has no Description. " />
          </Property>
        </Response>
----
##### No generator
*Request body:*

        <Post>
          <Property name="TimmsIntegerProperty3" type="integer" unit="kg" description="This is TimmsIntegerProperty4" />
        </Post>
*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property name="TimmsIntegerProperty3" type="integer" unit="kg" >
            <Error code="202" description="Property has no generator. " />
          </Property>
        </Response>
----
##### No Type
*Request body:*

        <Post>
          <Property name="TimmsIntegerProperty4" description="This is TimmsIntegerProperty4" unit="kg" generator="Timm (manually)"/>
        </Post>
*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property name="TimmsIntegerProperty4" unit="kg" description="This is TimmsIntegerProperty4" generator="Timm (manually)" >
            <Error code="252" description="Property has no PropertyType" />
          </Property>
        </Response>
----
##### No Unit
*Request body:*

        <Post>
          <Property name="TimmsIntegerProperty5" type="integer" description="This is TimmsIntegerProperty5" generator="Timm (manually)"/>
        </Post>
*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property name="TimmsIntegerProperty5" type="integer" description="This is TimmsIntegerProperty5" generator="Timm (manually)">
            <Error code="202" description="Property has no Unit. " />
          </Property>
        </Response>
----
##### No Name
*Request body:*

        <Post>
          <Property type="integer" description="This is TimmsIntegerProperty6" unit="kg" generator="Timm (manually)"/>
        </Post>

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property type="integer" unit="kg" description="This is TimmsIntegerProperty6" generator="Timm (manually)">
            <Error code="202" description="Property has no Name. " />
          </Property>
        </Response>
----
##### Invalid Name
*Request body:*

        <Post>
          <Property id="39" name="TimmsIntegerProperty7" type="integer" description="This is TimmsIntegerProperty7" unit="kg" generator="Timm (manually)"/>
        </Post>

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property id="39" name="TimmsIntegerProperty7" type="integer" unit="kg" description="This is TimmsIntegerProperty7" generator="Timm (manually)">
            <Error code="204" description="Property has an invalid Name. " />
          </Property>
        </Response>
----
##### Mixed
*Request body:*

        <Post>
          <Property name="TimmsIntegerProperty2" type="integer" description="This is TimmsIntegerProperty2" unit="kg" generator="Timm (manually)"/>
          <Property name="TimmsIntegerProperty3" type="integer" unit="kg" generator="Timm (manually)"/>
          <Property name="TimmsIntegerProperty4" description="This is TimmsIntegerProperty4" unit="kg" generator="Timm (manually)"/>
          <Property name="TimmsIntegerProperty5" type="integer" description="This is TimmsIntegerProperty5" generator="Timm (manually)"/>
          <Property type="integer" description="This is TimmsIntegerProperty6" unit="kg" generator="Timm (manually)"/>
          <Property id="39" name="TimmsIntegerProperty7" type="integer" description="This is TimmsIntegerProperty7" unit="kg" generator="Timm (manually)"/>
        </Post>

*Response:*

        <?xml version="1.0" encoding="UTF-8"?>
        <Response>
          <Property type="integer" unit="kg" description="This is TimmsIntegerProperty6" generator="Timm (manually)">
            <Error code="202" description="Property has no Name. " />
          </Property>
          <Property id="39" name="TimmsIntegerProperty7" type="integer" unit="kg" description="This is TimmsIntegerProperty7" generator="Timm (manually)">
            <Error code="204" description="Property has an invalid Name. " />
          </Property>
        ...
        </Response>

= DELETE AbstractProperties = 

HTTP-DELETE-requests are to be send to `http://${host}:${port}/mpidsserver/AbstractProperty/...`. Default port is 8123.

*Example*
{{{ 
DELETE http://${host}:${port}/mpidsserver/AbstractProperty/1&2&3&4
}}}


## TODO
### UPDATE AbstractProperties
Notes:
* ids are persistent. They cannot be changed.
* Maybe we should take the PropertyTypes as persistent, too or just allow a few changes: Double <-> Integer?
Roadmap:
1) Specify and implement changing the name, description and unit of AbstractProperties.
2) Specify and implement changing the reference of an abstract reference property.
3) Anything else...
