/**
 * ** header v3.0
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2020 IndiScale GmbH <info@indiscale.com>
 * Copyright (C) 2020 Daniel Hornung <d.hornung@indiscale.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * ** end header
 */

USE _caosdb_schema_unit_tests;
BEGIN;
CALL tap.no_plan();


-- ########################################################################
-- TEST Issues from https://gitlab.com/caosdb/caosdb-mysqlbackend/-/issues
-- ########################################################################

-------------------------------------------------------------------------------
--                                  Issue 21                                 --
-- Deleting a child with 3 levels of ancestors.                              --
-------------------------------------------------------------------------------

-- Setup
SET @SRID = "SRID_issue_21";
INSERT INTO transactions (srid,seconds,nanos,username,realm) VALUES
(@SRID, 1234, 2345, "me", "home");
CALL entityACL(@ACLID1, "{acl1}");

-- Insert entities and obtain IDs
CALL insertEntity("A", "Desc A", "RECORDTYPE", "{acl1}");
CALL insertEntity("B", "Desc B", "RECORDTYPE", "{acl1}");
CALL insertEntity("C", "Desc C", "RECORDTYPE", "{acl1}");
CALL insertEntity("rec", "Desc rec", "RECORD", "{acl1}");

SELECT entity_id INTO @ID_A FROM name_data WHERE value="A";
SELECT entity_id INTO @ID_B FROM name_data WHERE value="B";
SELECT entity_id INTO @ID_C FROM name_data WHERE value="C";
SELECT entity_id INTO @ID_rec FROM name_data WHERE value="rec";

-- Insert is-a relationships
CALL insertIsA(@ID_A, @ID_B);
CALL insertIsA(@ID_B, @ID_C);
CALL insertIsA(@ID_rec, @ID_A);

-- Try to delete last child
-- leads to failure in issue #21
CALL deleteIsa(@ID_rec);

ROLLBACK;
