USE _caosdb_schema_unit_tests;
BEGIN;
CALL tap.no_plan();

-- SETUP

-- Disable versioning and only test the non-versioning behavior
DELETE FROM feature_config WHERE _key = "ENTITY_VERSIONING";

CALL entityACL(@ACLID1, "{acl1}");
CALL entityACL(@ACLID2, "{acl2}");
SELECT entity_id into @TextDatatypeID FROM name_data WHERE value ="TEXT";

-- TESTS

-- TEST insertEntity
SELECT tap.eq(COUNT(id), 0, "No entities")
    FROM entities WHERE id>=100;
CALL insertEntity("EntityName", "EntityDesc", "RECORDTYPE", "{acl1}");

SELECT tap.eq(COUNT(entity_id), 1, "Entity has been inserted")
    FROM name_data WHERE value="EntityName";

SELECT entity_id INTO @EntityID FROM name_data WHERE value="EntityName";
SELECT tap.ok(@EntityID >= 100, "EntityID greater 99");

SELECT tap.eq(acl, @ACLID1, "correct acl id had been assigned")
    FROM entities WHERE id=@EntityID;


-- TEST insertEntityProperty
CALL insertEntity("AProperty", "APropDesc", "PROPERTY", "{acl1}");
SELECT entity_id INTO @PropID FROM name_data WHERE value="AProperty";
INSERT INTO data_type (domain_id, entity_id, property_id, datatype) VALUES (0, 0, @PropID, @TextDatatypeID);

SELECT COUNT(*) INTO @x FROM null_data;
SELECT tap.eq(@x, 0, "No data in null_data table");
CALL insertEntityProperty(0, @EntityID, @PropID, "null_data", NULL, NULL, "RECOMMENDED", NULL, NULL, NULL, NULL, 0);
SELECT COUNT(*) INTO @x FROM null_data;
SELECT tap.eq(@x, 1, "One row in null_data table");

-- TEST updateEntity
CALL updateEntity(@EntityID, "NewEntityName", "NewEntityDesc", "RECORD", NULL, NULL, "{acl2}");

SELECT tap.eq(COUNT(entity_id), 0, "Old Entity name not present")
    FROM name_data WHERE value="EntityName";
SELECT tap.eq(COUNT(entity_id), 1, "Entity name has been updated")
    FROM name_data WHERE value="NewEntityName";

SELECT tap.eq(acl, @ACLID2, "acl has been updated")
    FROM entities WHERE id=@EntityID;

-- CALL updateEntity again an update the Name
CALL updateEntity(@EntityID, "NewerEntityName", "NewerEntityDesc", "RECORD", NULL, NULL, "{acl2}");
CALL updateEntity(@EntityID, "NewEntityName", "NewEntityDesc", "RECORD", NULL, NULL, "{acl2}");


-- TEST deleteEntityProperties
CALL deleteEntityProperties(@EntityID);
SELECT COUNT(*) INTO @x FROM null_data;
SELECT tap.eq(@x, 0, "data removed from null_data table");

-- TEST deleteEntity
CALL deleteEntity(@EntityID);
CALL deleteEntity(@PropID);
SELECT COUNT(id) INTO @x FROM entities WHERE id>100;
SELECT tap.eq(@x, 0, "entity deleted");


-- TESTS END

CALL tap.finish();
ROLLBACK;

