-- MySQL dump 10.17  Distrib 10.3.22-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: sqldb    Database: caosdb
-- ------------------------------------------------------
-- Server version	10.4.12-MariaDB-1:10.4.12+maria~bionic

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `collection_type`
--

DROP TABLE IF EXISTS `collection_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `collection_type` (
  `domain_id` int(10) unsigned NOT NULL,
  `entity_id` int(10) unsigned NOT NULL,
  `property_id` int(10) unsigned NOT NULL,
  `collection` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  KEY `domain_id` (`domain_id`,`entity_id`),
  KEY `entity_id` (`entity_id`),
  KEY `property_id` (`property_id`),
  CONSTRAINT `collection_type_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `collection_type_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `collection_type_property_id_entity` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `collection_type`
--

LOCK TABLES `collection_type` WRITE;
/*!40000 ALTER TABLE `collection_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `collection_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_type`
--

DROP TABLE IF EXISTS `data_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_type` (
  `domain_id` int(10) unsigned NOT NULL,
  `entity_id` int(10) unsigned NOT NULL,
  `property_id` int(10) unsigned NOT NULL,
  `datatype` int(10) unsigned NOT NULL,
  UNIQUE KEY `datatype_ukey` (`domain_id`,`entity_id`,`property_id`),
  KEY `name_ov_dom_ent_idx` (`domain_id`,`entity_id`),
  KEY `datatype_forkey_ent` (`entity_id`),
  KEY `datatype_forkey_pro` (`property_id`),
  KEY `datatype_forkey_type` (`datatype`),
  CONSTRAINT `datatype_forkey_dom` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `datatype_forkey_ent` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `datatype_forkey_pro` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `datatype_forkey_type` FOREIGN KEY (`datatype`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_type`
--

LOCK TABLES `data_type` WRITE;
/*!40000 ALTER TABLE `data_type` DISABLE KEYS */;
INSERT INTO `data_type` VALUES (0,0,267,3),(0,0,222,11),(0,0,235,12),(0,0,236,12),(0,0,237,13),(0,0,258,13),(0,0,20,14),(0,0,21,14),(0,0,24,14),(0,0,213,14),(0,0,214,14),(0,0,217,14),(0,0,223,14),(0,0,239,14),(0,0,261,14),(0,0,216,15),(0,0,238,18),(0,0,255,215),(0,230,121,218),(0,230,122,219),(0,230,120,220),(0,230,119,221),(0,0,256,231),(0,243,120,232),(0,243,119,233),(0,243,121,234),(0,265,119,257),(0,270,119,257),(0,271,119,257),(0,265,121,259),(0,265,120,260),(0,270,120,260),(0,271,120,260);
/*!40000 ALTER TABLE `data_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `date_data`
--

DROP TABLE IF EXISTS `date_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `date_data` (
  `domain_id` int(10) unsigned DEFAULT NULL,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `property_id` int(10) unsigned DEFAULT NULL,
  `value` int(11) NOT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX') COLLATE utf8_unicode_ci DEFAULT NULL,
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  KEY `date_data_dom_ent_idx` (`domain_id`,`entity_id`),
  KEY `date_ov_forkey_ent` (`entity_id`),
  KEY `date_ov_forkey_pro` (`property_id`),
  CONSTRAINT `date_ov_forkey_dom` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `date_ov_forkey_ent` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `date_ov_forkey_pro` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `date_data`
--

LOCK TABLES `date_data` WRITE;
/*!40000 ALTER TABLE `date_data` DISABLE KEYS */;
INSERT INTO `date_data` VALUES (0,243,216,20251011,'FIX',0),(0,244,216,20181219,'FIX',0),(0,245,216,20181219,'FIX',0),(0,246,216,20181219,'FIX',0),(0,247,216,20181219,'FIX',0),(0,248,216,20181219,'FIX',0),(0,249,216,20181219,'FIX',0),(0,250,216,20181219,'FIX',0),(0,251,216,20181219,'FIX',0),(0,252,216,20181219,'FIX',0),(0,253,216,20181219,'FIX',0),(0,265,216,20251011,'FIX',0),(0,230,216,20251011,'FIX',0);
/*!40000 ALTER TABLE `date_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `datetime_data`
--

DROP TABLE IF EXISTS `datetime_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `datetime_data` (
  `domain_id` int(10) unsigned NOT NULL COMMENT 'Domain.',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity.',
  `property_id` int(10) unsigned NOT NULL COMMENT 'Property.',
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX','REPLACEMENT') COLLATE utf8_unicode_ci NOT NULL COMMENT 'Status of this statement.',
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  `value_ns` int(10) unsigned DEFAULT NULL,
  `value` bigint(20) NOT NULL,
  KEY `domain_id` (`domain_id`,`entity_id`),
  KEY `dat_entity_id_entity` (`entity_id`),
  KEY `dat_property_id_entity` (`property_id`),
  CONSTRAINT `dat_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `dat_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `dat_property_id_entity` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `datetime_data`
--

LOCK TABLES `datetime_data` WRITE;
/*!40000 ALTER TABLE `datetime_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `datetime_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `desc_overrides`
--

DROP TABLE IF EXISTS `desc_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `desc_overrides` (
  `domain_id` int(10) unsigned DEFAULT NULL,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `property_id` int(10) unsigned DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci DEFAULT NULL,
  UNIQUE KEY `desc_ov_ukey` (`domain_id`,`entity_id`,`property_id`),
  KEY `desc_ov_dom_ent_idx` (`domain_id`,`entity_id`),
  KEY `desc_ov_forkey_ent` (`entity_id`),
  KEY `desc_ov_forkey_pro` (`property_id`),
  CONSTRAINT `desc_ov_forkey_dom` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `desc_ov_forkey_ent` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `desc_ov_forkey_pro` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `desc_overrides`
--

LOCK TABLES `desc_overrides` WRITE;
/*!40000 ALTER TABLE `desc_overrides` DISABLE KEYS */;
/*!40000 ALTER TABLE `desc_overrides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `double_data`
--

DROP TABLE IF EXISTS `double_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `double_data` (
  `domain_id` int(10) unsigned NOT NULL COMMENT 'Domain.',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity.',
  `property_id` int(10) unsigned NOT NULL COMMENT 'Property.',
  `value` double NOT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX','REPLACEMENT') COLLATE utf8_unicode_ci NOT NULL COMMENT 'Status of this statement.',
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  `unit_sig` bigint(20) DEFAULT NULL,
  KEY `domain_id` (`domain_id`,`entity_id`),
  KEY `dou_entity_id_entity` (`entity_id`),
  KEY `dou_property_id_entity` (`property_id`),
  CONSTRAINT `dou_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `dou_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `dou_property_id_entity` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `double_data`
--

LOCK TABLES `double_data` WRITE;
/*!40000 ALTER TABLE `double_data` DISABLE KEYS */;
INSERT INTO `double_data` VALUES (0,243,237,1.25,'FIX',3,NULL),(0,244,237,10,'FIX',3,NULL),(0,245,237,6,'FIX',3,NULL),(0,246,237,4,'FIX',3,NULL),(0,247,237,4,'FIX',3,NULL),(0,248,237,6,'FIX',3,NULL),(0,249,237,10,'FIX',3,NULL),(0,250,237,16,'FIX',3,NULL),(0,251,237,24,'FIX',3,NULL),(0,252,237,34,'FIX',3,NULL),(0,253,237,46,'FIX',3,NULL),(0,265,258,0.01,'FIX',1,NULL);
/*!40000 ALTER TABLE `double_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entities`
--

DROP TABLE IF EXISTS `entities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Unique identifier.',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Name of the entity.',
  `description` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `role` enum('RECORDTYPE','RECORD','FILE','DOMAIN','PROPERTY','DATATYPE','ROLE','QUERYTEMPLATE') COLLATE utf8_unicode_ci NOT NULL,
  `acl` int(10) unsigned DEFAULT NULL COMMENT 'Access Control List for the entity.',
  PRIMARY KEY (`id`),
  KEY `entity_entity_acl` (`acl`),
  CONSTRAINT `entity_entity_acl` FOREIGN KEY (`acl`) REFERENCES `entity_acl` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=281 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entities`
--

LOCK TABLES `entities` WRITE;
/*!40000 ALTER TABLE `entities` DISABLE KEYS */;
INSERT INTO `entities` VALUES (0,'DOMAIN','The default domain.','ROLE',0),(1,'RECORDTYPE','The default recordtype.','ROLE',0),(2,'RECORD','The default record.','ROLE',0),(3,'FILE','The default file.','ROLE',0),(4,'PROPERTY','The default property.','ROLE',0),(7,'DATATYPE','The default datatype.','ROLE',0),(8,'QUERYTEMPLATE','The QueryTemplate role.','ROLE',0),(11,'REFERENCE','The default reference data type.','DATATYPE',0),(12,'INTEGER','The default integer data type.','DATATYPE',0),(13,'DOUBLE','The default double data type.','DATATYPE',0),(14,'TEXT','The default text data type.','DATATYPE',0),(15,'DATETIME','The default datetime data type.','DATATYPE',0),(16,'TIMESPAN','The default timespan data type.','DATATYPE',0),(17,'FILE','The default file reference data type.','DATATYPE',0),(18,'BOOLEAN','The defaulf boolean data type','DATATYPE',0),(20,'name','Name of an entity','PROPERTY',0),(21,'unit','Unit of an entity.','PROPERTY',0),(24,'description','Description of an entity.','PROPERTY',0),(50,'SQLITE','The SQLite file data type.','DATATYPE',0),(99,NULL,NULL,'RECORDTYPE',0),(119,NULL,'Multipurpose subdomain','DOMAIN',0),(120,NULL,'Multipurpose subdomain','DOMAIN',0),(121,NULL,'Multipurpose subdomain','DOMAIN',0),(122,NULL,'Multipurpose subdomain','DOMAIN',0),(212,'Experiment',NULL,'RECORDTYPE',4),(213,'Person',NULL,'PROPERTY',4),(214,'Conductor',NULL,'PROPERTY',4),(215,'UnicornExperiment',NULL,'RECORDTYPE',4),(216,'date',NULL,'PROPERTY',4),(217,'species',NULL,'PROPERTY',4),(218,'UnicornVideo',NULL,'RECORDTYPE',4),(219,'UnicornECG',NULL,'RECORDTYPE',4),(220,'LabNotes',NULL,'RECORDTYPE',4),(221,'Photo',NULL,'RECORDTYPE',4),(222,'annotationOf','The core property of the [Annotation] denoting which entity the annotation is annotating.','PROPERTY',4),(223,'comment','A comment on something.','PROPERTY',4),(224,'Annotation','Annotations annotate other entities in order to represent information about these entities without changing them. Mostly this will be comments by users on these entities or flags used by third party programs.','RECORDTYPE',4),(225,'CommentAnnotation','CommentAnnotations represent user comments on other entities. As they are entities themselves they can be \'responded\' by just annotating them with another CommentAnnotation.','RECORDTYPE',4),(226,'Unicorn.jpg',NULL,'FILE',4),(227,'LabNotes.pdf',NULL,'FILE',4),(228,'Video.data',NULL,'FILE',4),(229,'ECG.data',NULL,'FILE',4),(230,NULL,NULL,'RECORD',4),(231,'MySimulation',NULL,'RECORDTYPE',4),(232,'ParamFile',NULL,'RECORDTYPE',4),(233,'Code',NULL,'RECORDTYPE',4),(234,'Results',NULL,'RECORDTYPE',4),(235,'Width',NULL,'PROPERTY',4),(236,'Height',NULL,'PROPERTY',4),(237,'Result',NULL,'PROPERTY',4),(238,'Success',NULL,'PROPERTY',4),(239,'Author',NULL,'PROPERTY',4),(240,'MyCode.py',NULL,'FILE',4),(241,'MyParameters.tsv',NULL,'FILE',4),(242,'TheResults.tsv',NULL,'FILE',4),(243,NULL,'Parameter scan of the Tri-Domain-Model','RECORD',4),(244,'Simple Simulation 1','A very simple simulation.','RECORD',4),(245,'Simple Simulation 2','A very simple simulation.','RECORD',4),(246,'Simple Simulation 3','A very simple simulation.','RECORD',4),(247,'Simple Simulation 4','A very simple simulation.','RECORD',4),(248,'Simple Simulation 5','A very simple simulation.','RECORD',4),(249,'Simple Simulation 6','A very simple simulation.','RECORD',4),(250,'Simple Simulation 7','A very simple simulation.','RECORD',4),(251,'Simple Simulation 8','A very simple simulation.','RECORD',4),(252,'Simple Simulation 9','A very simple simulation.','RECORD',4),(253,'Simple Simulation 10','A very simple simulation.','RECORD',4),(254,'MyAnalysis',NULL,'RECORDTYPE',4),(255,'InputExperiment',NULL,'PROPERTY',4),(256,'InputSimulation',NULL,'PROPERTY',4),(257,'AnalysisScript',NULL,'RECORDTYPE',4),(258,'Resolution',NULL,'PROPERTY',4),(259,'OutputPlot',NULL,'RECORDTYPE',4),(260,'OutputNPY',NULL,'RECORDTYPE',4),(261,'TextOutput',NULL,'PROPERTY',4),(262,'analysis.py',NULL,'FILE',4),(263,'results.npy',NULL,'FILE',4),(264,'plot.png',NULL,'FILE',4),(265,NULL,NULL,'RECORD',4),(266,'data_gol.webm',NULL,'FILE',4),(267,'Video',NULL,'PROPERTY',4),(268,'analyse_gol.py',NULL,'FILE',4),(269,'gol.npy',NULL,'FILE',4),(270,'InternalPublication',NULL,'RECORDTYPE',4),(271,NULL,'I have created a nice example of a smoothed game of life simulation.Just have a look at the analysis.','RECORD',4),(273,NULL,NULL,'RECORD',4),(276,NULL,NULL,'RECORD',4),(277,NULL,NULL,'RECORD',4),(278,NULL,NULL,'RECORD',4),(279,NULL,NULL,'RECORD',4),(280,NULL,NULL,'FILE',5);
/*!40000 ALTER TABLE `entities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entity_acl`
--

DROP TABLE IF EXISTS `entity_acl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entity_acl` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `acl` varbinary(65525) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entity_acl_acl` (`acl`(767))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entity_acl`
--

LOCK TABLES `entity_acl` WRITE;
/*!40000 ALTER TABLE `entity_acl` DISABLE KEYS */;
INSERT INTO `entity_acl` VALUES (0,''),(4,'[{\"realm\":\"PAM\",\"bitSet\":536608371,\"username\":\"caosdb\"}]'),(5,'[{\"realm\":\"PAM\",\"bitSet\":536608371,\"username\":\"admin\"}]');
/*!40000 ALTER TABLE `entity_acl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `enum_data`
--

DROP TABLE IF EXISTS `enum_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `enum_data` (
  `domain_id` int(10) unsigned DEFAULT NULL,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `property_id` int(10) unsigned DEFAULT NULL,
  `value` varbinary(255) NOT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX') COLLATE utf8_unicode_ci DEFAULT NULL,
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  KEY `enum_ov_dom_ent_idx` (`domain_id`,`entity_id`),
  KEY `enum_ov_forkey_ent` (`entity_id`),
  KEY `enum_ov_forkey_pro` (`property_id`),
  CONSTRAINT `enum_ov_forkey_dom` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `enum_ov_forkey_ent` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `enum_ov_forkey_pro` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `enum_data`
--

LOCK TABLES `enum_data` WRITE;
/*!40000 ALTER TABLE `enum_data` DISABLE KEYS */;
INSERT INTO `enum_data` VALUES (0,243,238,'TRUE','FIX',4),(0,244,238,'FALSE','FIX',4),(0,245,238,'FALSE','FIX',4),(0,246,238,'TRUE','FIX',4),(0,247,238,'TRUE','FIX',4),(0,248,238,'FALSE','FIX',4),(0,249,238,'TRUE','FIX',4),(0,250,238,'FALSE','FIX',4),(0,251,238,'TRUE','FIX',4),(0,252,238,'FALSE','FIX',4),(0,253,238,'FALSE','FIX',4);
/*!40000 ALTER TABLE `enum_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `files` (
  `file_id` int(10) unsigned NOT NULL COMMENT 'The file''s ID.',
  `path` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Directory of the file.',
  `size` bigint(20) unsigned NOT NULL COMMENT 'Size in kB (oktet bytes).',
  `hash` binary(64) DEFAULT NULL,
  `checked_timestamp` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`file_id`),
  CONSTRAINT `fil_file_id_entity` FOREIGN KEY (`file_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `files`
--

LOCK TABLES `files` WRITE;
/*!40000 ALTER TABLE `files` DISABLE KEYS */;
INSERT INTO `files` VALUES (226,'ExperimentalData/Unicorn/2025-10-11/Unicorn.jpg',41553,'|3s$J8},-5X\\a\'Њ\nHt76Mznȹɍ<',0),(227,'ExperimentalData/Unicorn/2025-10-11/LabNotes.pdf',21,'KhtzFX7% J̕zS@ MqeWM@s6W:W(}7P@',0),(228,'ExperimentalData/Unicorn/2025-10-11/data/Video.data',24,'	\"@U8Tiu0pQlH-?{P4%#-vl5;l',0),(229,'ExperimentalData/Unicorn/2025-10-11/data/ECG.data',22,'tY{(ZA6b:/uX.3-|^\\{a}ou',0),(240,'SimulationData/MySimulation/2025-10-11/MyCode.py',18,'U{V6\'Fl\"\ZT=l8mpoʌpߴbdGC]K1',0),(241,'SimulationData/MySimulation/2025-10-11/MyParameters.tsv',25,'vf	E&^x\'FfGVQY hOQ(פq5VJH)Z&0l',0),(242,'SimulationData/MySimulation/2025-10-11/TheResults.tsv',23,'Mce!&\n2t1Sql-yaZr]y>,<$p]=%Pz{\rč',0),(262,'Analysis/MyAnalysis/2025-10-11/analysis.py',1946,'%!td?;M:k3<触MfK-9tezV/',0),(263,'Analysis/MyAnalysis/2025-10-11/results.npy',19,'5ukTReFWG99na.,$B4Sf\"f4u}',0),(264,'Analysis/MyAnalysis/2025-10-11/plot.png',11941,'\"k 7r/<QU2ugu?hsmҽ</OM*rsk3Yns݇',0),(266,'SimulationData/GameOfLife/data_gol.webm',1440766,'WǄ=Tq9Мg.QV18N?\nҔ3pKK4\\,,/bzsﭪ',0),(268,'Analysis/GameOfLife/analyse_gol.py',991,'gY݀%$73i+cp/âﯩnyrz4G\"Sogܝ}/2ݚ=;M',0),(269,'SimulationData/GameOfLife/gol.npy',5120128,'_<Lr06;\Z>7	RDxV̘S^Y0ٖz\"a%M6O\'4(^',0),(280,'test/linkahead.sh',28686,'R9=$hWp/BC9n葰{e)zb\Z\Zf°%',0);
/*!40000 ALTER TABLE `files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `integer_data`
--

DROP TABLE IF EXISTS `integer_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `integer_data` (
  `domain_id` int(10) unsigned NOT NULL COMMENT 'Domain.',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity.',
  `property_id` int(10) unsigned NOT NULL COMMENT 'Property.',
  `value` bigint(20) NOT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX','REPLACEMENT') COLLATE utf8_unicode_ci NOT NULL COMMENT 'Status of this statement.',
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  `unit_sig` bigint(20) DEFAULT NULL,
  KEY `domain_id` (`domain_id`,`entity_id`),
  KEY `int_entity_id_entity` (`entity_id`),
  KEY `int_property_id_entity` (`property_id`),
  CONSTRAINT `int_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `int_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `int_property_id_entity` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `integer_data`
--

LOCK TABLES `integer_data` WRITE;
/*!40000 ALTER TABLE `integer_data` DISABLE KEYS */;
INSERT INTO `integer_data` VALUES (0,243,235,200,'FIX',1,-42701283),(0,243,236,225,'FIX',2,-42701283),(0,244,235,100,'FIX',1,-42701283),(0,244,236,200,'FIX',2,-42701283),(0,245,235,110,'FIX',1,-42701283),(0,245,236,185,'FIX',2,-42701283),(0,246,235,120,'FIX',1,-42701283),(0,246,236,170,'FIX',2,-42701283),(0,247,235,130,'FIX',1,-42701283),(0,247,236,155,'FIX',2,-42701283),(0,248,235,140,'FIX',1,-42701283),(0,248,236,140,'FIX',2,-42701283),(0,249,235,150,'FIX',1,-42701283),(0,249,236,125,'FIX',2,-42701283),(0,250,235,160,'FIX',1,-42701283),(0,250,236,110,'FIX',2,-42701283),(0,251,235,170,'FIX',1,-42701283),(0,251,236,95,'FIX',2,-42701283),(0,252,235,180,'FIX',1,-42701283),(0,252,236,80,'FIX',2,-42701283),(0,253,235,190,'FIX',1,-42701283),(0,253,236,65,'FIX',2,-42701283);
/*!40000 ALTER TABLE `integer_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `isa`
--

DROP TABLE IF EXISTS `isa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isa` (
  `child` int(10) unsigned NOT NULL COMMENT 'Child',
  `parent` int(10) unsigned NOT NULL COMMENT 'Parent',
  `type` enum('INHERITANCE','SUBTYPING') COLLATE utf8_unicode_ci NOT NULL COMMENT 'Type of is-a relation.',
  UNIQUE KEY `child` (`child`,`parent`),
  KEY `parent_entity` (`parent`),
  CONSTRAINT `child_entity` FOREIGN KEY (`child`) REFERENCES `entities` (`id`),
  CONSTRAINT `parent_entity` FOREIGN KEY (`parent`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `isa`
--

LOCK TABLES `isa` WRITE;
/*!40000 ALTER TABLE `isa` DISABLE KEYS */;
/*!40000 ALTER TABLE `isa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `isa_cache`
--

DROP TABLE IF EXISTS `isa_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isa_cache` (
  `child` int(10) unsigned NOT NULL,
  `parent` int(10) unsigned NOT NULL,
  `rpath` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`child`,`parent`,`rpath`),
  KEY `isa_cache_parent_entity` (`parent`),
  CONSTRAINT `isa_cache_child_entity` FOREIGN KEY (`child`) REFERENCES `entities` (`id`),
  CONSTRAINT `isa_cache_parent_entity` FOREIGN KEY (`parent`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `isa_cache`
--

LOCK TABLES `isa_cache` WRITE;
/*!40000 ALTER TABLE `isa_cache` DISABLE KEYS */;
INSERT INTO `isa_cache` VALUES (214,213,'214'),(215,212,'215'),(225,224,'225'),(226,221,'226'),(227,220,'227'),(228,218,'228'),(229,219,'229'),(230,212,'215'),(230,215,'230'),(239,213,'239'),(240,233,'240'),(241,232,'241'),(242,234,'242'),(243,231,'243'),(244,231,'244'),(245,231,'245'),(246,231,'246'),(247,231,'247'),(248,231,'248'),(249,231,'249'),(250,231,'250'),(251,231,'251'),(252,231,'252'),(253,231,'253'),(262,257,'262'),(263,260,'263'),(264,259,'264'),(265,254,'265'),(268,257,'268'),(269,260,'269'),(271,270,'271'),(273,224,'225'),(273,225,'273'),(276,224,'225'),(276,225,'276'),(277,224,'225'),(277,225,'277'),(278,224,'225'),(278,225,'278'),(279,224,'225'),(279,225,'279');
/*!40000 ALTER TABLE `isa_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `logging`
--

DROP TABLE IF EXISTS `logging`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `logging` (
  `level` int(11) NOT NULL,
  `logger` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `message` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `millis` bigint(20) NOT NULL,
  `logRecord` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `logging`
--

LOCK TABLES `logging` WRITE;
/*!40000 ALTER TABLE `logging` DISABLE KEYS */;
INSERT INTO `logging` VALUES (1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:a0882b227ce70a95b4432cc529ae2fc8',1545303396129,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gB!\0\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:a0882b227ce70a95b4432cc529ae2fc8pq\0~\0	t\0logsr\04caosdb.server.database.exceptions.IntegrityException(7$\0\0xr\06caosdb.server.database.exceptions.TransactionExceptionR̓\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpsr\01java.sql.SQLIntegrityConstraintViolationExceptiono|cr76\0\0xr\0!java.sql.SQLNonTransientException\nw}\0\0xr\0java.sql.SQLException0>u\0I\0\nvendorCodeL\0SQLStateq\0~\0L\0nextt\0Ljava/sql/SQLException;xq\0~\0q\0~\0t\0Cannot delete or update a parent row: a foreign key constraint fails (`caosdb_demo`.`data_type`, CONSTRAINT `datatype_forkey_type` FOREIGN KEY (`datatype`) REFERENCES `entities` (`id`))ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Qsr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0t\0appt\0%com.mysql.cj.jdbc.exceptions.SQLErrort\0\rSQLError.javat\0createSQLExceptionppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0 q\0~\0!ppsq\0~\0\0\0\0sq\0~\0t\01com.mysql.cj.jdbc.exceptions.SQLExceptionsMappingt\0SQLExceptionsMapping.javat\0translateExceptionppsq\0~\0\0\0q\0~\0t\0 com.mysql.cj.jdbc.ConnectionImplt\0ConnectionImpl.javat\0execSQLppsq\0~\0\0\0\"q\0~\0t\0#com.mysql.cj.jdbc.PreparedStatementt\0PreparedStatement.javat\0executeInternalppsq\0~\0\0\0q\0~\0q\0~\0,q\0~\0-t\0executeppsq\0~\0\0\0Hq\0~\0t\0snaq.db.CachedPreparedStatementt\0CachedPreparedStatement.javaq\0~\00ppsq\0~\0\0\0\0/q\0~\0t\0Kcaosdb.server.database.backend.implementation.MySQL.MySQLDeleteSparseEntityt\0MySQLDeleteSparseEntity.javaq\0~\00ppsq\0~\0\0\0\01q\0~\0t\0=caosdb.server.database.backend.transaction.DeleteSparseEntityt\0DeleteSparseEntity.javaq\0~\00ppsq\0~\0\0\0\0q\0~\0t\0)caosdb.server.database.BackendTransactiont\0BackendTransaction.javaq\0~\00ppsq\0~\0\0\0\0,q\0~\0t\07caosdb.server.database.backend.transaction.DeleteEntityt\0DeleteEntity.javaq\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0;q\0~\0<t\0executeTransactionppsq\0~\0\0\0\0$q\0~\0t\0caosdb.server.database.Databaset\0\rDatabase.javaq\0~\00ppsq\0~\0\0\0\0nq\0~\0t\0 caosdb.server.transaction.Deletet\0Delete.javat\0deleteppsq\0~\0\0\0\0hq\0~\0q\0~\0Fq\0~\0Gt\0transactionppsq\0~\0\0\0\0q\0~\0t\0%caosdb.server.transaction.Transactiont\0Transaction.javaq\0~\00ppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpDeleteInChildClassppsq\0~\0\0\0q\0~\0t\03caosdb.server.resource.AbstractCaosDBServerResourcet\0!AbstractCaosDBServerResource.javat\0\nhttpDeleteppsq\0~\0pt\0-jdk.internal.reflect.NativeMethodAccessorImplt\0NativeMethodAccessorImpl.javat\0invoke0t\0	java.baset\010.0.2sq\0~\0\0\0\0>pq\0~\0Wq\0~\0Xt\0invokeq\0~\0Zq\0~\0[sq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0Hppsq\0~\0\0\0`q\0~\0q\0~\0eq\0~\0fq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0ft\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\0eq\0~\0ft\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0ft\0handleppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0}q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0oppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0oppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0}q\0~\0oppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0oppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0oppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0oppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0Zq\0~\0[sr\0java.util.Collections$EmptyListz<\0\0xpx\0\0t\023000pt\0java.sql.SQLIntegrityConstraintViolationException: Cannot delete or update a parent row: a foreign key constraint fails (`caosdb_demo`.`data_type`, CONSTRAINT `datatype_forkey_type` FOREIGN KEY (`datatype`) REFERENCES `entities` (`id`))uq\0~\0\Z\0\0\0Jsq\0~\0\0\0\01q\0~\0q\0~\05q\0~\06q\0~\00ppsq\0~\0\0\0\01q\0~\0q\0~\08q\0~\09q\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0;q\0~\0<q\0~\00ppsq\0~\0\0\0\0,q\0~\0q\0~\0>q\0~\0?q\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0;q\0~\0<q\0~\0Appsq\0~\0\0\0\0$q\0~\0q\0~\0Cq\0~\0Dq\0~\00ppsq\0~\0\0\0\0nq\0~\0q\0~\0Fq\0~\0Gq\0~\0Hppsq\0~\0\0\0\0hq\0~\0q\0~\0Fq\0~\0Gq\0~\0Jppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0Oq\0~\0Pq\0~\0Qppsq\0~\0\0\0q\0~\0q\0~\0Sq\0~\0Tq\0~\0Uppsq\0~\0pq\0~\0Wq\0~\0Xq\0~\0Yq\0~\0Zq\0~\0[sq\0~\0\0\0\0>pq\0~\0Wq\0~\0Xq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\0\0+pq\0~\0_q\0~\0`q\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\04pq\0~\0bq\0~\0cq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0Hppsq\0~\0\0\0`q\0~\0q\0~\0eq\0~\0fq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0kppsq\0~\0\0\0\\q\0~\0q\0~\0eq\0~\0fq\0~\0mppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0qq\0~\0rq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0|q\0~\0}q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0}q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0Mq\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0}q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0?q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\07q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0 q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0{q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0+q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0Lpq\0~\0q\0~\0q\0~\0q\0~\0Zq\0~\0[q\0~\0xw\0\0\0\0t\nREQUEST: DELETE https://localhost:44301/Entity/123%26135%26136%26137%26138%26139%26140%26141%26142%26143%26144%26145 HTTPS/1.1\nREQUEST HEADERS: [Cookie: SessionToken=[\"PAM\",\"caosdb\",1545303395204,43200000,\"099db9fc-38c5-481e-8a0b-8cf7dbe64d02\",\"7d61cc3ed09076985b26d98da67b38f1b77acf0124318a4017d931bfa0148269edc51f5dc38968ef14195868e137b17912ed4bdce28e5dc8324f8f314ef47624\"];][Host: localhost:44301][Accept-Encoding: identity]\nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost:44301/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"a0882b227ce70a95b4432cc529ae2fc8\" timestamp=\"1545303395242\" baseuri=\"https://localhost:44301\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"500\" description=\"An unexpected server error has occurred.\">SRID = a0882b227ce70a95b4432cc529ae2fc8\r\n\r\nPlease report this server error to  and include the SRID into your report.</Error>\r\n</Response>\r\nx'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:d49a85e3fcd13e6fd19467c5ee932033',1545303672980,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gFȔ\0x\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:d49a85e3fcd13e6fd19467c5ee932033pq\0~\0	t\0logsr\04caosdb.server.database.exceptions.IntegrityException(7$\0\0xr\06caosdb.server.database.exceptions.TransactionExceptionR̓\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpsr\01java.sql.SQLIntegrityConstraintViolationExceptiono|cr76\0\0xr\0!java.sql.SQLNonTransientException\nw}\0\0xr\0java.sql.SQLException0>u\0I\0\nvendorCodeL\0SQLStateq\0~\0L\0nextt\0Ljava/sql/SQLException;xq\0~\0q\0~\0t\0Cannot delete or update a parent row: a foreign key constraint fails (`caosdb_demo`.`data_type`, CONSTRAINT `datatype_forkey_type` FOREIGN KEY (`datatype`) REFERENCES `entities` (`id`))ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Qsr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0t\0appt\0%com.mysql.cj.jdbc.exceptions.SQLErrort\0\rSQLError.javat\0createSQLExceptionppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0 q\0~\0!ppsq\0~\0\0\0\0sq\0~\0t\01com.mysql.cj.jdbc.exceptions.SQLExceptionsMappingt\0SQLExceptionsMapping.javat\0translateExceptionppsq\0~\0\0\0q\0~\0t\0 com.mysql.cj.jdbc.ConnectionImplt\0ConnectionImpl.javat\0execSQLppsq\0~\0\0\0\"q\0~\0t\0#com.mysql.cj.jdbc.PreparedStatementt\0PreparedStatement.javat\0executeInternalppsq\0~\0\0\0q\0~\0q\0~\0,q\0~\0-t\0executeppsq\0~\0\0\0Hq\0~\0t\0snaq.db.CachedPreparedStatementt\0CachedPreparedStatement.javaq\0~\00ppsq\0~\0\0\0\0/q\0~\0t\0Kcaosdb.server.database.backend.implementation.MySQL.MySQLDeleteSparseEntityt\0MySQLDeleteSparseEntity.javaq\0~\00ppsq\0~\0\0\0\01q\0~\0t\0=caosdb.server.database.backend.transaction.DeleteSparseEntityt\0DeleteSparseEntity.javaq\0~\00ppsq\0~\0\0\0\0q\0~\0t\0)caosdb.server.database.BackendTransactiont\0BackendTransaction.javaq\0~\00ppsq\0~\0\0\0\0,q\0~\0t\07caosdb.server.database.backend.transaction.DeleteEntityt\0DeleteEntity.javaq\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0;q\0~\0<t\0executeTransactionppsq\0~\0\0\0\0$q\0~\0t\0caosdb.server.database.Databaset\0\rDatabase.javaq\0~\00ppsq\0~\0\0\0\0nq\0~\0t\0 caosdb.server.transaction.Deletet\0Delete.javat\0deleteppsq\0~\0\0\0\0hq\0~\0q\0~\0Fq\0~\0Gt\0transactionppsq\0~\0\0\0\0q\0~\0t\0%caosdb.server.transaction.Transactiont\0Transaction.javaq\0~\00ppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpDeleteInChildClassppsq\0~\0\0\0q\0~\0t\03caosdb.server.resource.AbstractCaosDBServerResourcet\0!AbstractCaosDBServerResource.javat\0\nhttpDeleteppsq\0~\0pt\0-jdk.internal.reflect.NativeMethodAccessorImplt\0NativeMethodAccessorImpl.javat\0invoke0t\0	java.baset\010.0.2sq\0~\0\0\0\0>pq\0~\0Wq\0~\0Xt\0invokeq\0~\0Zq\0~\0[sq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0Hppsq\0~\0\0\0`q\0~\0q\0~\0eq\0~\0fq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0ft\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\0eq\0~\0ft\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0ft\0handleppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0}q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0oppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0oppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0}q\0~\0oppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0oppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0oppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0oppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0oppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0Zq\0~\0[sr\0java.util.Collections$EmptyListz<\0\0xpx\0\0t\023000pt\0java.sql.SQLIntegrityConstraintViolationException: Cannot delete or update a parent row: a foreign key constraint fails (`caosdb_demo`.`data_type`, CONSTRAINT `datatype_forkey_type` FOREIGN KEY (`datatype`) REFERENCES `entities` (`id`))uq\0~\0\Z\0\0\0Jsq\0~\0\0\0\01q\0~\0q\0~\05q\0~\06q\0~\00ppsq\0~\0\0\0\01q\0~\0q\0~\08q\0~\09q\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0;q\0~\0<q\0~\00ppsq\0~\0\0\0\0,q\0~\0q\0~\0>q\0~\0?q\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0;q\0~\0<q\0~\0Appsq\0~\0\0\0\0$q\0~\0q\0~\0Cq\0~\0Dq\0~\00ppsq\0~\0\0\0\0nq\0~\0q\0~\0Fq\0~\0Gq\0~\0Hppsq\0~\0\0\0\0hq\0~\0q\0~\0Fq\0~\0Gq\0~\0Jppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\00ppsq\0~\0\0\0\0q\0~\0q\0~\0Oq\0~\0Pq\0~\0Qppsq\0~\0\0\0q\0~\0q\0~\0Sq\0~\0Tq\0~\0Uppsq\0~\0pq\0~\0Wq\0~\0Xq\0~\0Yq\0~\0Zq\0~\0[sq\0~\0\0\0\0>pq\0~\0Wq\0~\0Xq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\0\0+pq\0~\0_q\0~\0`q\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\04pq\0~\0bq\0~\0cq\0~\0]q\0~\0Zq\0~\0[sq\0~\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0Hppsq\0~\0\0\0`q\0~\0q\0~\0eq\0~\0fq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0kppsq\0~\0\0\0\\q\0~\0q\0~\0eq\0~\0fq\0~\0mppsq\0~\0\0\0q\0~\0q\0~\0eq\0~\0fq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0qq\0~\0rq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0|q\0~\0}q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0}q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0Mq\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0gppsq\0~\0\0\0q\0~\0q\0~\0xq\0~\0yq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0gppsq\0~\0\0\0\0q\0~\0q\0~\0tq\0~\0uq\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0}q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0?q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\07q\0~\0q\0~\0q\0~\0q\0~\0oppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0 q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0{q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0+q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0Lpq\0~\0q\0~\0q\0~\0q\0~\0Zq\0~\0[q\0~\0xw\0\0\0\0t\nREQUEST: DELETE https://localhost:44301/Entity/177%26189%26190%26191%26192%26193%26194%26195%26196%26197%26198%26199 HTTPS/1.1\nREQUEST HEADERS: [Cookie: SessionToken=[\"PAM\",\"caosdb\",1545303671986,43200000,\"b561cad0-2fef-4eae-8576-1d392d15be68\",\"e51058a8fb51b7573a97cbba4b1f36403c188e7fcf733b0d79a0cd0725a9810f5d409fd71386c7155eabaa3f37cabbdf06bf6232da4a7215e6cecaad24ecc713\"];][Host: localhost:44301][Accept-Encoding: identity]\nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost:44301/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"d49a85e3fcd13e6fd19467c5ee932033\" timestamp=\"1545303672012\" baseuri=\"https://localhost:44301\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"500\" description=\"An unexpected server error has occurred.\">SRID = d49a85e3fcd13e6fd19467c5ee932033\r\n\r\nPlease report this server error to  and include the SRID into your report.</Error>\r\n</Response>\r\nx'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545303907915,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gJ^K\0	\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545303908548,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gJ`\0	f@\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545303908752,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gJa\00\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545303909153,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gJc!\0	h\0\0\0\0\0\0\0+\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545306999831,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gy\0C\0\0\0\0\0\0\0\03sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545307000632,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gy8\0\0\0\0\0\0\0\0\0\03sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545307000727,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gy\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311634317,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gC\0\r\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311634530,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gDb\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311634729,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gE)\0\rh\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311634903,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gE\0I\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311635403,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gG\0\0u0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311635557,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gHe\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311635756,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gI,\0\n\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311635956,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gI\0\r\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311636166,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gJ\0\r@\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311636366,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gK\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311636581,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gLe\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311636778,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gM*\0/H\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311636992,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gN\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311637190,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gN\0\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311637394,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gO\00\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311637608,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gPh\0Đ\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311637819,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gQ;\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311638022,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gR\04\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311638233,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gR\0\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311638542,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gT\0\nk\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311638746,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gT\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311638949,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gU\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311639195,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gV\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311639463,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gW\0@\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311639614,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gX>\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311639773,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gX\0\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311639984,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gY\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311640186,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gZz\0	\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311640349,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g[\0W\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311640510,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g[\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311643685,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gh%\0А\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311646813,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gt]\0\0 \0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311649945,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311650432,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0X\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311650574,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311650773,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311650973,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311652199,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gg\0	\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311652416,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g@\0;\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311652572,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0	Ӡ\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311652773,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311652970,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gj\0p\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311653169,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g1\0 \0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311653444,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gD\0\n\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311653651,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311653859,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0H\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311654003,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gs\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311654202,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g:\0\r\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311654363,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311654529,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\n\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311654730,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gJ\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311654929,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\n{\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311655127,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0nsr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311656473,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0 \0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311657071,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0go\0Qx\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311659604,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gT\0\r\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311662733,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0=\0\0\0\0\0\0	\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311665961,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g)\0	\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311669085,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g]\0&\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311672237,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g׭\0\rx\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311675359,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0O`\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311675500,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gl\0~@\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311677553,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gq\0Đ\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311677757,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g=\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311677958,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311678157,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0\0\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545311678700,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\08\0\0\0\0\0\0\"\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545313402376,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g>\0x\0\0\0\0\0\0#\0\0,sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:9f6f87355c5ada0d8822d0b1e0da25a8',1545314133858,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0ggb\00\0\0\0\0\0\0&-\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:9f6f87355c5ada0d8822d0b1e0da25a8pq\0~\0	t\0logsr\0Mcaosdb.server.resource.AbstractCaosDBServerResource$xmlNotWellFormedException M6/\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0pur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Esr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0+t\0appt\03caosdb.server.resource.AbstractCaosDBServerResourcet\0!AbstractCaosDBServerResource.javat\0parseEntityppsq\0~\0\0\0#q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\07q\0~\0t\0>caosdb.server.resource.transaction.handlers.SimpleWriteHandlert\0SimpleWriteHandler.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpPutInChildClassppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0t\0httpPutppsq\0~\0pt\0-jdk.internal.reflect.NativeMethodAccessorImplt\0NativeMethodAccessorImpl.javat\0invoke0t\0	java.baset\010.0.2sq\0~\0\0\0\0>pq\0~\0\'q\0~\0(t\0invokeq\0~\0*q\0~\0+sq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0-q\0~\0*q\0~\0+sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0-q\0~\0*q\0~\0+sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0sq\0~\0q\0~\05q\0~\06t\0putppsq\0~\0\0\0Sq\0~\0q\0~\05q\0~\06q\0~\07ppsq\0~\0\0\0q\0~\0q\0~\05q\0~\06t\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\05q\0~\06t\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\05q\0~\06q\0~\0ppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0Mq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0^q\0~\0_q\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0dq\0~\0eq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0Mq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0*q\0~\0+sr\0java.util.Collections$EmptyListz<\0\0xpxw\0\0\0\0t	\nREQUEST: PUT https://localhost/Entity HTTPS/1.1\nREQUEST HEADERS: [Cookie: SessionToken=[\"PAM\",\"caosdb\",1545314133804,43200000,\"854b617c-e68a-4f81-8dd0-d93cf90f40bc\",\"71d2c64237e3105e29060142e79e72d80691ba408e64cccff8247f0afcc09d72c14dcb79e91e226d5c6a77320b772e17b0be0597b770234e9713f59835dddbea\"]][Host: localhost][Accept-Encoding: identity][Content-Length: 1474]\nREQUEST ENTITY: <Entities>\n  <Entity id=\"274\">\n    <Parent id=\"225\" name=\"CommentAnnotation\" description=\"CommentAnnotations represent user comments on other entities. As they are entities themselves they can be \'responded\' by just annotating them with another CommentAnnotation.\"/>\n    <Property id=\"223\" name=\"comment\" description=\"A comment on something.\" datatype=\"TEXT\" importance=\"FIX\" flag=\"inheritance:FIX\"># Welcome to CaosDB! #\nThis web interface allows you to browse through the stored data, look at connections between datasets, preview files, download raw data and save query results.\n\n- For an overview over stored data, have a look at the **Entities** dropdown menu above or [click here](/Entity/?all=Record&P=0L10) to view all stored Records.\n- When a Record is displayed, links to other Records or file objects have a preview button (the *eye* icon).\n- You can browse the [File System](/FileSystem) with the corresponding button above.\n- **Queries** are a very powerful feature of CaosDB.  When you click on the `Query` button above, you are presented with a choice of query examples.  Feel free to modify the queries.  Further help is available in the online documentation or by your friendly CaosDB support team.</Property>\n    <Property id=\"222\" name=\"annotationOf\" description=\"The core property of the [Annotation] denoting which entity the annotation is annotating.\" datatype=\"REFERENCE\" importance=\"FIX\" flag=\"inheritance:FIX\">99</Property>\n  </Entity>\n</Entities>\n\n\nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"9f6f87355c5ada0d8822d0b1e0da25a8\" timestamp=\"1545314133807\" baseuri=\"https://localhost\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"0\" description=\"Request Body was not a well-formed xml.\" />\r\n</Response>\r\nx'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:7d7666b8fa77d883e268c8a7e0286f2f',1545314157229,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g­\0\nw\0\0\0\0\0\0&1\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:7d7666b8fa77d883e268c8a7e0286f2fpq\0~\0	t\0logsr\0!org.eclipse.jetty.io.EofExceptionU\0\0xr\0java.io.EOFExceptionYIkSA\0\0xr\0java.io.IOExceptionlsde%\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0	Early EOFur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Usr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0t\0appt\0$org.eclipse.jetty.server.HttpInput$3t\0HttpInput.javat\0	noContentppsq\0~\0\0\0\0}q\0~\0t\0\"org.eclipse.jetty.server.HttpInputq\0~\0t\0readppsq\0~\0\0\0\0nq\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\0Kq\0~\0t\0Ecaosdb.server.resource.ReReadableRepresentation$ReReadableInputStreamt\0ReReadableRepresentation.javaq\0~\0ppsq\0~\0\0\0pt\0Ncom.sun.org.apache.xerces.internal.impl.XMLEntityManager$RewindableInputStreamt\0XMLEntityManager.javaq\0~\0t\0java.xmlt\010.0.2sq\0~\0\0\0pt\08com.sun.org.apache.xerces.internal.impl.XMLEntityManagerq\0~\0&t\0setupCurrentEntityq\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\0:com.sun.org.apache.xerces.internal.impl.XMLVersionDetectort\0XMLVersionDetector.javat\0determineDocVersionq\0~\0\'q\0~\0(sq\0~\0\0\0\\pt\0=com.sun.org.apache.xerces.internal.parsers.XML11Configurationt\0XML11Configuration.javat\0parseq\0~\0\'q\0~\0(sq\0~\0\0\08pq\0~\01q\0~\02q\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\04com.sun.org.apache.xerces.internal.parsers.XMLParsert\0XMLParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0pt\0<com.sun.org.apache.xerces.internal.parsers.AbstractSAXParsert\0AbstractSAXParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0{pt\0Ccom.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParsert\0SAXParserImpl.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0q\0~\0t\0$org.jdom2.input.sax.SAXBuilderEnginet\0SAXBuilderEngine.javat\0buildppsq\0~\0\0\0\0q\0~\0q\0~\0?q\0~\0@q\0~\0Appsq\0~\0\0\0Cq\0~\0t\0\Zorg.jdom2.input.SAXBuildert\0SAXBuilder.javaq\0~\0Appsq\0~\0\0\0q\0~\0t\0=caosdb.server.resource.AbstractCaosDBServerResource$XMLParsert\0!AbstractCaosDBServerResource.javaq\0~\03ppsq\0~\0\0\0)q\0~\0t\03caosdb.server.resource.AbstractCaosDBServerResourceq\0~\0Ht\0parseEntityppsq\0~\0\0\0#q\0~\0q\0~\0Jq\0~\0Hq\0~\0Kppsq\0~\0\0\0\07q\0~\0t\0>caosdb.server.resource.transaction.handlers.SimpleWriteHandlert\0SimpleWriteHandler.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\0Nq\0~\0Oq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpPutInChildClassppsq\0~\0\0\0\0q\0~\0q\0~\0Jq\0~\0Ht\0httpPutppsq\0~\0pt\0-jdk.internal.reflect.NativeMethodAccessorImplt\0NativeMethodAccessorImpl.javat\0invoke0t\0	java.baseq\0~\0(sq\0~\0\0\0\0>pq\0~\0Yq\0~\0Zt\0invokeq\0~\0\\q\0~\0(sq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0^q\0~\0\\q\0~\0(sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0^q\0~\0\\q\0~\0(sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0sq\0~\0q\0~\0fq\0~\0gt\0putppsq\0~\0\0\0Sq\0~\0q\0~\0fq\0~\0gq\0~\0hppsq\0~\0\0\0q\0~\0q\0~\0fq\0~\0gt\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\0fq\0~\0gt\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\0fq\0~\0gq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0hppsq\0~\0\0\0q\0~\0q\0~\0yq\0~\0zq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0yq\0~\0zq\0~\0hppsq\0~\0\0\0q\0~\0q\0~\0yq\0~\0zq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0~q\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0Pppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0yq\0~\0zq\0~\0hppsq\0~\0\0\0q\0~\0q\0~\0yq\0~\0zq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0yq\0~\0zq\0~\0hppsq\0~\0\0\0q\0~\0q\0~\0yq\0~\0zq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0hppsq\0~\0\0\0\0q\0~\0q\0~\0uq\0~\0vq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0~q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0Pppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0Pppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0\\q\0~\0(sr\0java.util.Collections$EmptyListz<\0\0xpxw\0\0\0\0t\nREQUEST: PUT https://localhost/Entity HTTPS/1.1\nREQUEST HEADERS: [Transfer-Encoding: chunked][Cookie: SessionToken=[\"PAM\",\"caosdb\",1545314157178,43200000,\"85b243df-8a0a-48f3-802a-b44e7982cdb6\",\"a94df2aa20ba90792f257bbcd2d7c7bab63bd69d1e09c119a63c1363a695f33fa486f9fa27b8bb4e721212c0b923626d5fd10f642747e8aa677f672692e35842\"];][Host: localhost][Accept-Encoding: identity]\nREQUEST ENTITY: \nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"7d7666b8fa77d883e268c8a7e0286f2f\" timestamp=\"1545314157180\" baseuri=\"https://localhost\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"500\" description=\"An unexpected server error has occurred.\">SRID = 7d7666b8fa77d883e268c8a7e0286f2f\r\n\r\nPlease report this server error to  and include the SRID into your report.</Error>\r\n</Response>\r\nx'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:a1119051b5450dc26ac9e42754813124',1545314259821,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gSm\0H\0\0\0\0\0\0&G\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:a1119051b5450dc26ac9e42754813124pq\0~\0	t\0logsr\0!org.eclipse.jetty.io.EofExceptionU\0\0xr\0java.io.EOFExceptionYIkSA\0\0xr\0java.io.IOExceptionlsde%\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0	Early EOFur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Tsr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0t\0appt\0$org.eclipse.jetty.server.HttpInput$3t\0HttpInput.javat\0	noContentppsq\0~\0\0\0\0}q\0~\0t\0\"org.eclipse.jetty.server.HttpInputq\0~\0t\0readppsq\0~\0\0\0\0nq\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\0Kq\0~\0t\0Ecaosdb.server.resource.ReReadableRepresentation$ReReadableInputStreamt\0ReReadableRepresentation.javaq\0~\0ppsq\0~\0\0\0pt\0Ncom.sun.org.apache.xerces.internal.impl.XMLEntityManager$RewindableInputStreamt\0XMLEntityManager.javaq\0~\0t\0java.xmlt\010.0.2sq\0~\0\0\0pt\08com.sun.org.apache.xerces.internal.impl.XMLEntityManagerq\0~\0&t\0setupCurrentEntityq\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\0:com.sun.org.apache.xerces.internal.impl.XMLVersionDetectort\0XMLVersionDetector.javat\0determineDocVersionq\0~\0\'q\0~\0(sq\0~\0\0\0\\pt\0=com.sun.org.apache.xerces.internal.parsers.XML11Configurationt\0XML11Configuration.javat\0parseq\0~\0\'q\0~\0(sq\0~\0\0\08pq\0~\01q\0~\02q\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\04com.sun.org.apache.xerces.internal.parsers.XMLParsert\0XMLParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0pt\0<com.sun.org.apache.xerces.internal.parsers.AbstractSAXParsert\0AbstractSAXParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0{pt\0Ccom.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParsert\0SAXParserImpl.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0q\0~\0t\0$org.jdom2.input.sax.SAXBuilderEnginet\0SAXBuilderEngine.javat\0buildppsq\0~\0\0\0\0q\0~\0q\0~\0?q\0~\0@q\0~\0Appsq\0~\0\0\0Cq\0~\0t\0\Zorg.jdom2.input.SAXBuildert\0SAXBuilder.javaq\0~\0Appsq\0~\0\0\0q\0~\0t\0=caosdb.server.resource.AbstractCaosDBServerResource$XMLParsert\0!AbstractCaosDBServerResource.javaq\0~\03ppsq\0~\0\0\0)q\0~\0t\03caosdb.server.resource.AbstractCaosDBServerResourceq\0~\0Ht\0parseEntityppsq\0~\0\0\0#q\0~\0q\0~\0Jq\0~\0Hq\0~\0Kppsq\0~\0\0\0\07q\0~\0t\0>caosdb.server.resource.transaction.handlers.SimpleWriteHandlert\0SimpleWriteHandler.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\0Nq\0~\0Oq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpPostInChildClassppsq\0~\0\0\0\0q\0~\0q\0~\0Jq\0~\0Ht\0httpPostppsq\0~\0\0pt\0-jdk.internal.reflect.GeneratedMethodAccessor5pt\0invokeppsq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0Zt\0	java.baseq\0~\0(sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0Zq\0~\0^q\0~\0(sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0=q\0~\0q\0~\0cq\0~\0dt\0postppsq\0~\0\0\0^q\0~\0q\0~\0cq\0~\0dq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0cq\0~\0dt\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\0cq\0~\0dt\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\0cq\0~\0dq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0{q\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0Pppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0{q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0Pppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0Pppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0^q\0~\0(sr\0java.util.Collections$EmptyListz<\0\0xpxw\0\0\0\0t\nREQUEST: POST https://localhost/Entity? HTTPS/1.1\nREQUEST HEADERS: [Transfer-Encoding: chunked][Cookie: SessionToken=[\"PAM\",\"caosdb\",1545314259763,43200000,\"298c873a-0b90-4613-a5da-fc7bdb0062c6\",\"99bf57f63ec1747d0c5586d971b844e8ae0fdacfaf4a9db66a914d0d5f7bd2123009de9ef9c8ca412383352c5c0b32a3541adfd9a9e2840bb05b87a61afe64ed\"];][Host: localhost][Accept-Encoding: identity]\nREQUEST ENTITY: \nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"a1119051b5450dc26ac9e42754813124\" timestamp=\"1545314259765\" baseuri=\"https://localhost\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"500\" description=\"An unexpected server error has occurred.\">SRID = a1119051b5450dc26ac9e42754813124\r\n\r\nPlease report this server error to  and include the SRID into your report.</Error>\r\n</Response>\r\nx'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:87399a9b7f73de48f3136788ef91335',1545314306323,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g	\0/\0\0\0\0\0\0&M\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0-ERROR:REQUEST:87399a9b7f73de48f3136788ef91335pq\0~\0	t\0logsr\0!org.eclipse.jetty.io.EofExceptionU\0\0xr\0java.io.EOFExceptionYIkSA\0\0xr\0java.io.IOExceptionlsde%\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0	Early EOFur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Tsr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0t\0appt\0$org.eclipse.jetty.server.HttpInput$3t\0HttpInput.javat\0	noContentppsq\0~\0\0\0\0}q\0~\0t\0\"org.eclipse.jetty.server.HttpInputq\0~\0t\0readppsq\0~\0\0\0\0nq\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\0Kq\0~\0t\0Ecaosdb.server.resource.ReReadableRepresentation$ReReadableInputStreamt\0ReReadableRepresentation.javaq\0~\0ppsq\0~\0\0\0pt\0Ncom.sun.org.apache.xerces.internal.impl.XMLEntityManager$RewindableInputStreamt\0XMLEntityManager.javaq\0~\0t\0java.xmlt\010.0.2sq\0~\0\0\0pt\08com.sun.org.apache.xerces.internal.impl.XMLEntityManagerq\0~\0&t\0setupCurrentEntityq\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\0:com.sun.org.apache.xerces.internal.impl.XMLVersionDetectort\0XMLVersionDetector.javat\0determineDocVersionq\0~\0\'q\0~\0(sq\0~\0\0\0\\pt\0=com.sun.org.apache.xerces.internal.parsers.XML11Configurationt\0XML11Configuration.javat\0parseq\0~\0\'q\0~\0(sq\0~\0\0\08pq\0~\01q\0~\02q\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\04com.sun.org.apache.xerces.internal.parsers.XMLParsert\0XMLParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0pt\0<com.sun.org.apache.xerces.internal.parsers.AbstractSAXParsert\0AbstractSAXParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0{pt\0Ccom.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParsert\0SAXParserImpl.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0q\0~\0t\0$org.jdom2.input.sax.SAXBuilderEnginet\0SAXBuilderEngine.javat\0buildppsq\0~\0\0\0\0q\0~\0q\0~\0?q\0~\0@q\0~\0Appsq\0~\0\0\0Cq\0~\0t\0\Zorg.jdom2.input.SAXBuildert\0SAXBuilder.javaq\0~\0Appsq\0~\0\0\0q\0~\0t\0=caosdb.server.resource.AbstractCaosDBServerResource$XMLParsert\0!AbstractCaosDBServerResource.javaq\0~\03ppsq\0~\0\0\0)q\0~\0t\03caosdb.server.resource.AbstractCaosDBServerResourceq\0~\0Ht\0parseEntityppsq\0~\0\0\0#q\0~\0q\0~\0Jq\0~\0Hq\0~\0Kppsq\0~\0\0\0\07q\0~\0t\0>caosdb.server.resource.transaction.handlers.SimpleWriteHandlert\0SimpleWriteHandler.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\0Nq\0~\0Oq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpPostInChildClassppsq\0~\0\0\0\0q\0~\0q\0~\0Jq\0~\0Ht\0httpPostppsq\0~\0\0pt\0-jdk.internal.reflect.GeneratedMethodAccessor5pt\0invokeppsq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0Zt\0	java.baseq\0~\0(sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0Zq\0~\0^q\0~\0(sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0=q\0~\0q\0~\0cq\0~\0dt\0postppsq\0~\0\0\0^q\0~\0q\0~\0cq\0~\0dq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0cq\0~\0dt\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\0cq\0~\0dt\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\0cq\0~\0dq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0{q\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0Pppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0{q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0Pppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0Pppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0^q\0~\0(sr\0java.util.Collections$EmptyListz<\0\0xpxw\0\0\0\0t\nREQUEST: POST https://localhost/Entity? HTTPS/1.1\nREQUEST HEADERS: [Transfer-Encoding: chunked][Cookie: SessionToken=[\"PAM\",\"caosdb\",1545314306266,43200000,\"54da7764-b324-4901-961b-da8fb3bc2385\",\"566a423354e39bbc6483cde33173896d008ab0d5e3ea1c7d471b96da2e197a12cbfe27e8129e90f3a0e31dd5c4eac3ca0350c040678ac46093bf4aaaad10987f\"];][Host: localhost][Accept-Encoding: identity]\nREQUEST ENTITY: \nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"87399a9b7f73de48f3136788ef91335\" timestamp=\"1545314306268\" baseuri=\"https://localhost\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"500\" description=\"An unexpected server error has occurred.\">SRID = 87399a9b7f73de48f3136788ef91335\r\n\r\nPlease report this server error to  and include the SRID into your report.</Error>\r\n</Response>\r\nx'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:52cf6da58944b57c61a3cc992a4d65ae',1545314344268,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gL\0\0\0\0\0\0\0\0&S\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:52cf6da58944b57c61a3cc992a4d65aepq\0~\0	t\0logsr\0!org.eclipse.jetty.io.EofExceptionU\0\0xr\0java.io.EOFExceptionYIkSA\0\0xr\0java.io.IOExceptionlsde%\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0	Early EOFur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Tsr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0t\0appt\0$org.eclipse.jetty.server.HttpInput$3t\0HttpInput.javat\0	noContentppsq\0~\0\0\0\0}q\0~\0t\0\"org.eclipse.jetty.server.HttpInputq\0~\0t\0readppsq\0~\0\0\0\0nq\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\0Kq\0~\0t\0Ecaosdb.server.resource.ReReadableRepresentation$ReReadableInputStreamt\0ReReadableRepresentation.javaq\0~\0ppsq\0~\0\0\0pt\0Ncom.sun.org.apache.xerces.internal.impl.XMLEntityManager$RewindableInputStreamt\0XMLEntityManager.javaq\0~\0t\0java.xmlt\010.0.2sq\0~\0\0\0pt\08com.sun.org.apache.xerces.internal.impl.XMLEntityManagerq\0~\0&t\0setupCurrentEntityq\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\0:com.sun.org.apache.xerces.internal.impl.XMLVersionDetectort\0XMLVersionDetector.javat\0determineDocVersionq\0~\0\'q\0~\0(sq\0~\0\0\0\\pt\0=com.sun.org.apache.xerces.internal.parsers.XML11Configurationt\0XML11Configuration.javat\0parseq\0~\0\'q\0~\0(sq\0~\0\0\08pq\0~\01q\0~\02q\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0pt\04com.sun.org.apache.xerces.internal.parsers.XMLParsert\0XMLParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0pt\0<com.sun.org.apache.xerces.internal.parsers.AbstractSAXParsert\0AbstractSAXParser.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0{pt\0Ccom.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParsert\0SAXParserImpl.javaq\0~\03q\0~\0\'q\0~\0(sq\0~\0\0\0\0q\0~\0t\0$org.jdom2.input.sax.SAXBuilderEnginet\0SAXBuilderEngine.javat\0buildppsq\0~\0\0\0\0q\0~\0q\0~\0?q\0~\0@q\0~\0Appsq\0~\0\0\0Cq\0~\0t\0\Zorg.jdom2.input.SAXBuildert\0SAXBuilder.javaq\0~\0Appsq\0~\0\0\0q\0~\0t\0=caosdb.server.resource.AbstractCaosDBServerResource$XMLParsert\0!AbstractCaosDBServerResource.javaq\0~\03ppsq\0~\0\0\0)q\0~\0t\03caosdb.server.resource.AbstractCaosDBServerResourceq\0~\0Ht\0parseEntityppsq\0~\0\0\0#q\0~\0q\0~\0Jq\0~\0Hq\0~\0Kppsq\0~\0\0\0\07q\0~\0t\0>caosdb.server.resource.transaction.handlers.SimpleWriteHandlert\0SimpleWriteHandler.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\0Nq\0~\0Oq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpPostInChildClassppsq\0~\0\0\0\0q\0~\0q\0~\0Jq\0~\0Ht\0httpPostppsq\0~\0\0pt\0-jdk.internal.reflect.GeneratedMethodAccessor5pt\0invokeppsq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0Zt\0	java.baseq\0~\0(sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0Zq\0~\0^q\0~\0(sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0=q\0~\0q\0~\0cq\0~\0dt\0postppsq\0~\0\0\0^q\0~\0q\0~\0cq\0~\0dq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0cq\0~\0dt\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\0cq\0~\0dt\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\0cq\0~\0dq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0{q\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0Pppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0eppsq\0~\0\0\0q\0~\0q\0~\0vq\0~\0wq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0eppsq\0~\0\0\0\0q\0~\0q\0~\0rq\0~\0sq\0~\0Pppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0Pppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0{q\0~\0Pppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0Pppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0Pppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0Pppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0Pppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0^q\0~\0(sr\0java.util.Collections$EmptyListz<\0\0xpxw\0\0\0\0t\nREQUEST: POST https://localhost/Entity? HTTPS/1.1\nREQUEST HEADERS: [Transfer-Encoding: chunked][Cookie: SessionToken=[\"PAM\",\"caosdb\",1545314344221,43200000,\"aaefa1a4-8849-484e-ba36-56e54c0a0d63\",\"b55dfe6fce9330d67e66e3de3ce76dc8986d2fa578cfeb3a76ed81c2bc72be2595c5525b7e4a5d4aa3471f36c6ed1b819169292dfea60d44cecbe77ad97a67d0\"];][Host: localhost][Accept-Encoding: identity]\nREQUEST ENTITY: \nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"52cf6da58944b57c61a3cc992a4d65ae\" timestamp=\"1545314344223\" baseuri=\"https://localhost\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"500\" description=\"An unexpected server error has occurred.\">SRID = 52cf6da58944b57c61a3cc992a4d65ae\r\n\r\nPlease report this server error to  and include the SRID into your report.</Error>\r\n</Response>\r\nx'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:e4a69ddf90948d8836ff2c55e4e4178e',1545314363834,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0`\0\0\0\0\0\0&Z\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:e4a69ddf90948d8836ff2c55e4e4178epq\0~\0	t\0logsr\0Mcaosdb.server.resource.AbstractCaosDBServerResource$xmlNotWellFormedException M6/\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0pur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Dsr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0+t\0appt\03caosdb.server.resource.AbstractCaosDBServerResourcet\0!AbstractCaosDBServerResource.javat\0parseEntityppsq\0~\0\0\0#q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\07q\0~\0t\0>caosdb.server.resource.transaction.handlers.SimpleWriteHandlert\0SimpleWriteHandler.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpPostInChildClassppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0t\0httpPostppsq\0~\0\0pt\0-jdk.internal.reflect.GeneratedMethodAccessor5pt\0invokeppsq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0(t\0	java.baset\010.0.2sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0(q\0~\0,q\0~\0-sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0=q\0~\0q\0~\02q\0~\03t\0postppsq\0~\0\0\0^q\0~\0q\0~\02q\0~\03q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\02q\0~\03t\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\02q\0~\03t\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\02q\0~\03q\0~\0ppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\0Eq\0~\0Fq\0~\0ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Eq\0~\0Fq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\0Eq\0~\0Fq\0~\0ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0Jq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Eq\0~\0Fq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\0Eq\0~\0Fq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Eq\0~\0Fq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\0Eq\0~\0Fq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0[q\0~\0\\q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Aq\0~\0Bq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0aq\0~\0bq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0Jq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0,q\0~\0-sr\0java.util.Collections$EmptyListz<\0\0xpxw\0\0\0\0t	\nREQUEST: POST https://localhost/Entity? HTTPS/1.1\nREQUEST HEADERS: [Cookie: SessionToken=[\"PAM\",\"caosdb\",1545314363785,43200000,\"73a5cdaf-38f1-4c75-91ad-7224ef8a9519\",\"06a5c08b6f9c017558115e9b60d79eac1c6fcc3b6d72a4fd43cb051aa7b8d0ff84cb7938388eb6b1b3fb2b688e2440448740f68995f08876fca9a4fcfac52dcd\"]][Host: localhost][Accept-Encoding: identity][Content-Length: 1464]\nREQUEST ENTITY: <Entities>\n  <Record>\n    <Parent id=\"225\" name=\"CommentAnnotation\" description=\"CommentAnnotations represent user comments on other entities. As they are entities themselves they can be \'responded\' by just annotating them with another CommentAnnotation.\"/>\n    <Property id=\"223\" name=\"comment\" description=\"A comment on something.\" datatype=\"TEXT\" importance=\"FIX\" flag=\"inheritance:FIX\"># Welcome to CaosDB! #\nThis web interface allows you to browse through the stored data, look at connections between datasets, preview files, download raw data and save query results.\n\n- For an overview over stored data, have a look at the **Entities** dropdown menu above or [click here](/Entity/?all=Record&P=0L10) to view all stored Records.\n- When a Record is displayed, links to other Records or file objects have a preview button (the *eye* icon).\n- You can browse the [File System](/FileSystem) with the corresponding button above.\n- **Queries** are a very powerful feature of CaosDB.  When you click on the `Query` button above, you are presented with a choice of query examples.  Feel free to modify the queries.  Further help is available in the online documentation or by your friendly CaosDB support team.</Property>\n    <Property id=\"222\" name=\"annotationOf\" description=\"The core property of the [Annotation] denoting which entity the annotation is annotating.\" datatype=\"REFERENCE\" importance=\"FIX\" flag=\"inheritance:FIX\">99</Property>\n  </Record>\n</Entities>\n\nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"e4a69ddf90948d8836ff2c55e4e4178e\" timestamp=\"1545314363788\" baseuri=\"https://localhost\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"0\" description=\"Request Body was not a well-formed xml.\" />\r\n</Response>\r\nx'),(1000,'caosdb.server.CaosDBComponent','ERROR:REQUEST:4e546c8b12e831fe6f827cb74f5f9cd2',1545314889494,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g\0x\0\0\0\0\0\0\'X\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0SEVEREt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosDBComponentt\0.ERROR:REQUEST:4e546c8b12e831fe6f827cb74f5f9cd2pq\0~\0	t\0logsr\0Mcaosdb.server.resource.AbstractCaosDBServerResource$xmlNotWellFormedException M6/\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0pur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0Esr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0+t\0appt\03caosdb.server.resource.AbstractCaosDBServerResourcet\0!AbstractCaosDBServerResource.javat\0parseEntityppsq\0~\0\0\0#q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\07q\0~\0t\0>caosdb.server.resource.transaction.handlers.SimpleWriteHandlert\0SimpleWriteHandler.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0\0\0\0q\0~\0t\01caosdb.server.resource.transaction.EntityResourcet\0EntityResource.javat\0httpPutInChildClassppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0t\0httpPutppsq\0~\0pt\0-jdk.internal.reflect.NativeMethodAccessorImplt\0NativeMethodAccessorImpl.javat\0invoke0t\0	java.baset\010.0.2sq\0~\0\0\0\0>pq\0~\0\'q\0~\0(t\0invokeq\0~\0*q\0~\0+sq\0~\0\0\0\0+pt\01jdk.internal.reflect.DelegatingMethodAccessorImplt\0!DelegatingMethodAccessorImpl.javaq\0~\0-q\0~\0*q\0~\0+sq\0~\0\0\04pt\0java.lang.reflect.Methodt\0Method.javaq\0~\0-q\0~\0*q\0~\0+sq\0~\0\0\0q\0~\0t\0#org.restlet.resource.ServerResourcet\0ServerResource.javat\0doHandleppsq\0~\0\0\0sq\0~\0q\0~\05q\0~\06t\0putppsq\0~\0\0\0Sq\0~\0q\0~\05q\0~\06q\0~\07ppsq\0~\0\0\0q\0~\0q\0~\05q\0~\06t\0doNegotiatedHandleppsq\0~\0\0\0\\q\0~\0q\0~\05q\0~\06t\0doConditionalHandleppsq\0~\0\0\0q\0~\0q\0~\05q\0~\06q\0~\0ppsq\0~\0\0\0\0q\0~\0t\0org.restlet.resource.Findert\0Finder.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javaq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$2t\0CaosDBServer.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3q\0~\0Mq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\07ppsq\0~\0\0\0q\0~\0q\0~\0Hq\0~\0Iq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0^q\0~\0_q\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\07ppsq\0~\0\0\0\0q\0~\0q\0~\0Dq\0~\0Eq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0dq\0~\0eq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0ppsq\0~\0\0\0q\0~\0q\0~\0	q\0~\0Mq\0~\0ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0q\0~\0*q\0~\0+sr\0java.util.Collections$EmptyListz<\0\0xpxw\0\0\0\0t	\nREQUEST: PUT https://localhost/Entity HTTPS/1.1\nREQUEST HEADERS: [Cookie: SessionToken=[\"PAM\",\"caosdb\",1545314889445,43200000,\"234ab1cd-71d9-4f23-86d7-18ae27a46c27\",\"c50ac75661c620bafdc815cb9eecacb98e84b1e4066f9acf7ac2dff8dda7d38ee443077c1732f8d0add000bb6ad9496c177783a5ed9eecffa3bfd4deced1c711\"]][Host: localhost][Accept-Encoding: identity][Content-Length: 1485]\nREQUEST ENTITY: <Entities>\n<Record id=\"276\">\n<Parent id=\"225\" name=\"CommentAnnotation\" description=\"CommentAnnotations represent user comments on other entities. As they are entities themselves they can be \'responded\' by just annotating them with another CommentAnnotation.\"/>\n<Property id=\"223\" name=\"comment\" description=\"A comment on something.\" datatype=\"TEXT\" importance=\"FIX\" flag=\"inheritance:FIX\"># Welcome to CaosDB! #\nThis web interface allows you to browse through the stored data, look at connections between datasets, preview files, download raw data and save query results.\n\n- For an overview over stored data, have a look at the **Entities** dropdown menu above.\n- When a Record is displayed, links to other Records or file objects have a preview button (the *eye* icon).\n- You can browse the [File System](/FileSystem/) with the corresponding button above.\n- **Queries** are a very powerful feature of CaosDB.  When you click on the `Query` button above, you are presented with a choice of query examples.  Feel free to modify the queries.  Further help is available in the online documentation or by your friendly CaosDB support team.</Property>\n\n# Start a Tour #\n\n- [A special Experiment](/Entity/?P=0L10&query=Find+Record+UnicornExperiment)\n<Property id=\"222\" name=\"annotationOf\" description=\"The core property of the [Annotation] denoting which entity the annotation is annotating.\" datatype=\"REFERENCE\" importance=\"FIX\" flag=\"inheritance:FIX\">99</Property>\n</Record>\n</Entities>\n\n\nRESPONSE: HTTPS/1.1 - Internal Server Error (500) - The server encountered an unexpected condition which prevented it from fulfilling the request\nRESPONSE ENTITY:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-stylesheet type=\"text/xsl\" href=\"https://localhost/webinterface/webcaosdb.xsl\" ?>\r\n<Response username=\"caosdb\" realm=\"PAM\" srid=\"4e546c8b12e831fe6f827cb74f5f9cd2\" timestamp=\"1545314889448\" baseuri=\"https://localhost\">\r\n  <UserInfo username=\"caosdb\" realm=\"PAM\">\r\n    <Roles>\r\n      <Role>administration</Role>\r\n    </Roles>\r\n  </UserInfo>\r\n  <Error code=\"0\" description=\"Request Body was not a well-formed xml.\" />\r\n</Response>\r\nx'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545316628867,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gy\0	ϸ\0\0\0\0\0\0+\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545318816546,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g-\"\0[`\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545319229243,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g4\';\0X\0\0\0\0\0\0\0D\0\0\01sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545319229350,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g4\'\0\0\0\0\0\0\0\0F\0\0\00sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545319229597,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g4(\07\0\0\0\0\0\0\0H\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545319244549,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g4c\0\r \0\0\0\0\0\0\0J\0\0\00sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545319987256,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g?8\0	\0\0\0\0\0\0\0\0~\0\0\0/sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545319987766,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0g?6\0\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545320343697,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gE(\0\no\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545320343800,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gE(\0p\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(800,'caosdb.server.CaosAuthenticator','LOGIN_FAILED',1545320349181,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gE=\0Lp\0\0\0\0\0\0\0\0\0\0sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0 t\0INFOt\0\"sun.util.logging.resources.loggingt\0caosdb.server.CaosAuthenticatort\0LOGIN_FAILEDpq\0~\0	t\0attemptSessionValidationsr\0.org.apache.shiro.authc.AuthenticationException_f1\0\0xr\0org.apache.shiro.ShiroExceptionYQ/,:M\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0Authentication token of type [class caosdb.server.accessControl.SessionToken] could not be authenticated by any configured realms.  Please ensure that at least one realm can authenticate these tokens.ur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\06sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0\06t\0appt\07org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategyt\0!AtLeastOneSuccessfulStrategy.javat\0afterAllAttemptsppsq\0~\0\0\0\0q\0~\0t\04org.apache.shiro.authc.pam.ModularRealmAuthenticatort\0ModularRealmAuthenticator.javat\0\ZdoMultiRealmAuthenticationppsq\0~\0\0\0\rq\0~\0q\0~\0q\0~\0t\0doAuthenticateppsq\0~\0\0\0\0q\0~\0t\0,org.apache.shiro.authc.AbstractAuthenticatort\0\ZAbstractAuthenticator.javat\0authenticateppsq\0~\0\0\0\0jq\0~\0t\02org.apache.shiro.mgt.AuthenticatingSecurityManagert\0\"AuthenticatingSecurityManager.javaq\0~\0&ppsq\0~\0\0\0q\0~\0t\0+org.apache.shiro.mgt.DefaultSecurityManagert\0DefaultSecurityManager.javat\0loginppsq\0~\0\0\0\0q\0~\0t\02org.apache.shiro.subject.support.DelegatingSubjectt\0DelegatingSubject.javaq\0~\0-ppsq\0~\0\0\0\0=q\0~\0q\0~\0	t\0CaosAuthenticator.javaq\0~\0ppsq\0~\0\0\0\03q\0~\0q\0~\0	q\0~\02q\0~\0&ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\0;ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0=ppsq\0~\0\0\0q\0~\0q\0~\0@q\0~\0Aq\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\0Lq\0~\0Mq\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0=ppsq\0~\0\0\0\0q\0~\0q\0~\09q\0~\0:q\0~\0;ppsq\0~\0\0\0\0q\0~\0q\0~\0Rq\0~\0Sq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0Eq\0~\0;ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\0;ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\0;ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\0;ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\0;ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0q\0~\0ppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0t\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x'),(900,'caosdb.server.accessControl.AuthenticationUtils','AUTHTOKEN_PARSING_FAILED',1545321192484,'\0sr\0java.util.logging.LogRecordJY=iQ\0J\0millisI\0nanoAdjustmentJ\0sequenceNumberI\0threadIDL\0levelt\0Ljava/util/logging/Level;L\0\nloggerNamet\0Ljava/lang/String;L\0messageq\0~\0L\0resourceBundleNameq\0~\0L\0sourceClassNameq\0~\0L\0sourceMethodNameq\0~\0L\0thrownt\0Ljava/lang/Throwable;xp\0\0gR$\0_\0\0\0\0\0\0\0\0\00sr\0java.util.logging.LevelqQs6\0I\0valueL\0nameq\0~\0L\0resourceBundleNameq\0~\0xp\0\0t\0WARNINGt\0\"sun.util.logging.resources.loggingt\0/caosdb.server.accessControl.AuthenticationUtilst\0AUTHTOKEN_PARSING_FAILEDpq\0~\0	t\0parseSessionTokenCookiesr\0java.lang.IllegalStateExceptionWUFH\0\0xr\0\Zjava.lang.RuntimeException_G\n4\0\0xr\0java.lang.Exception>\Z;\0\0xr\0java.lang.Throwable5\'9w\0L\0causeq\0~\0L\0\rdetailMessageq\0~\0[\0\nstackTracet\0[Ljava/lang/StackTraceElement;L\0suppressedExceptionst\0Ljava/util/List;xpq\0~\0t\0#unknown char \'i\'(105) in |||invalidur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\05sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNameq\0~\0L\0declaringClassq\0~\0L\0fileNameq\0~\0L\0\nmethodNameq\0~\0L\0\nmoduleNameq\0~\0L\0\rmoduleVersionq\0~\0xp\0\0vt\0appt\0 org.eclipse.jetty.util.ajax.JSONt\0	JSON.javat\0\rhandleUnknownppsq\0~\0\0\0kq\0~\0q\0~\0q\0~\0\Zt\0parseppsq\0~\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0q\0~\0q\0~\0q\0~\0\Zq\0~\0ppsq\0~\0\0\0\0Vq\0~\0t\0(caosdb.server.accessControl.SessionTokent\0SessionToken.javaq\0~\0ppsq\0~\0\0\0\0oq\0~\0q\0~\0	t\0AuthenticationUtils.javaq\0~\0ppsq\0~\0\0\0\09q\0~\0t\0caosdb.server.CaosAuthenticatort\0CaosAuthenticator.javat\0attemptSessionValidationppsq\0~\0\0\0\03q\0~\0q\0~\0&q\0~\0\'t\0authenticateppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.security.Authenticatort\0Authenticator.javat\0beforeHandleppsq\0~\0\0\0\0q\0~\0t\0\Zorg.restlet.routing.Filtert\0Filter.javat\0handleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01t\0doHandleppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0t\0\Zorg.restlet.routing.Routert\0Router.javaq\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBServer$3t\0CaosDBServer.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.application.StatusFiltert\0StatusFilter.javaq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0t\0\"org.restlet.engine.CompositeHelpert\0CompositeHelper.javaq\0~\02ppsq\0~\0\0\0\0Mq\0~\0t\00org.restlet.engine.application.ApplicationHelpert\0ApplicationHelper.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Applicationt\0Application.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\04ppsq\0~\0\0\0q\0~\0q\0~\07q\0~\08q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\0Cq\0~\0Dq\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\04ppsq\0~\0\0\0\0q\0~\0q\0~\00q\0~\01q\0~\02ppsq\0~\0\0\0\0q\0~\0q\0~\0Iq\0~\0Jq\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Componentt\0Component.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0caosdb.server.CaosDBComponentq\0~\0<q\0~\02ppsq\0~\0\0\0q\0~\0t\0org.restlet.Servert\0Server.javaq\0~\02ppsq\0~\0\0\0\0?q\0~\0t\0)org.restlet.engine.connector.ServerHelpert\0ServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\0+org.restlet.engine.adapter.HttpServerHelpert\0HttpServerHelper.javaq\0~\02ppsq\0~\0\0\0\0q\0~\0t\05org.restlet.ext.jetty.JettyServerHelper$WrappedServert\0JettyServerHelper.javaq\0~\02ppsq\0~\0\0\07q\0~\0t\0$org.eclipse.jetty.server.HttpChannelt\0HttpChannel.javaq\0~\02ppsq\0~\0\0\0q\0~\0t\0\'org.eclipse.jetty.server.HttpConnectiont\0HttpConnection.javat\0\nonFillableppsq\0~\0\0\0 q\0~\0t\0)org.eclipse.jetty.io.AbstractConnection$2t\0AbstractConnection.javat\0runppsq\0~\0\0\0{q\0~\0t\0.org.eclipse.jetty.util.thread.QueuedThreadPoolt\0QueuedThreadPool.javat\0runJobppsq\0~\0\0\0+q\0~\0t\00org.eclipse.jetty.util.thread.QueuedThreadPool$3q\0~\0}q\0~\0zppsq\0~\0\0\0Lpt\0java.lang.Threadt\0Thread.javaq\0~\0zt\0	java.baset\010.0.2sr\0java.util.Collections$EmptyListz<\0\0xpxw\0x');
/*!40000 ALTER TABLE `logging` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `name_data`
--

DROP TABLE IF EXISTS `name_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `name_data` (
  `domain_id` int(10) unsigned NOT NULL,
  `entity_id` int(10) unsigned NOT NULL,
  `property_id` int(10) unsigned NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX','REPLACEMENT') COLLATE utf8_unicode_ci NOT NULL,
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  KEY `domain_id` (`domain_id`,`entity_id`),
  KEY `entity_id` (`entity_id`),
  KEY `property_id` (`property_id`),
  KEY `value` (`value`),
  CONSTRAINT `name_data_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `name_data_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `name_data_property_id_entity` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `name_data`
--

LOCK TABLES `name_data` WRITE;
/*!40000 ALTER TABLE `name_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `name_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `name_overrides`
--

DROP TABLE IF EXISTS `name_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `name_overrides` (
  `domain_id` int(10) unsigned DEFAULT NULL,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `property_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  UNIQUE KEY `name_ov_ukey` (`domain_id`,`entity_id`,`property_id`),
  KEY `name_ov_dom_ent_idx` (`domain_id`,`entity_id`),
  KEY `name_ov_forkey_ent` (`entity_id`),
  KEY `name_ov_forkey_pro` (`property_id`),
  CONSTRAINT `name_ov_forkey_dom` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `name_ov_forkey_ent` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `name_ov_forkey_pro` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `name_overrides`
--

LOCK TABLES `name_overrides` WRITE;
/*!40000 ALTER TABLE `name_overrides` DISABLE KEYS */;
/*!40000 ALTER TABLE `name_overrides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `null_data`
--

DROP TABLE IF EXISTS `null_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `null_data` (
  `domain_id` int(10) unsigned DEFAULT NULL,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `property_id` int(10) unsigned DEFAULT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX') COLLATE utf8_unicode_ci DEFAULT NULL,
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  KEY `null_data_dom_ent_idx` (`domain_id`,`entity_id`),
  KEY `null_forkey_ent` (`entity_id`),
  KEY `null_forkey_pro` (`property_id`),
  CONSTRAINT `null_forkey_dom` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `null_forkey_ent` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `null_forkey_pro` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `null_data`
--

LOCK TABLES `null_data` WRITE;
/*!40000 ALTER TABLE `null_data` DISABLE KEYS */;
INSERT INTO `null_data` VALUES (0,224,222,'OBLIGATORY',0),(0,225,223,'OBLIGATORY',0),(0,270,239,'RECOMMENDED',0),(0,270,119,'RECOMMENDED',0),(0,270,120,'RECOMMENDED',0),(0,270,267,'RECOMMENDED',3);
/*!40000 ALTER TABLE `null_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `passwd`
--

DROP TABLE IF EXISTS `passwd`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `passwd` (
  `principal` varbinary(255) NOT NULL,
  `hash` varbinary(255) NOT NULL,
  `alg` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'SHA-512',
  `it` int(10) unsigned DEFAULT 5000,
  `salt` varbinary(255) NOT NULL,
  PRIMARY KEY (`principal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `passwd`
--

LOCK TABLES `passwd` WRITE;
/*!40000 ALTER TABLE `passwd` DISABLE KEYS */;
INSERT INTO `passwd` VALUES ('guest','3fe82ca86837d4f9ff765d2d4265ded968433149365c4b3e18f424689d4ce40e981732dde5be4a9dd245a142acc12b1fbb65b5578269751178b3b8c118f6864b','SHA-512',6092,'3ft8rl4fe5234jnonfnp6e970n');
/*!40000 ALTER TABLE `passwd` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `passwords`
--

DROP TABLE IF EXISTS `passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `passwords` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'User ID.',
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Password.',
  PRIMARY KEY (`entity_id`),
  CONSTRAINT `use_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `passwords`
--

LOCK TABLES `passwords` WRITE;
/*!40000 ALTER TABLE `passwords` DISABLE KEYS */;
INSERT INTO `passwords` VALUES (98,'37d7bd8a833261b4e4653644ee0a065f522b92b3738ca9ae2cb43a83844bf352c4a59c386a44965997a508c61988c9484c093775027425091d6d3d435c3c0e0c'),(99,'37d7bd8a833261b4e4653644ee0a065f522b92b3738ca9ae2cb43a83844bf352c4a59c386a44965997a508c61988c9484c093775027425091d6d3d435c3c0e0c');
/*!40000 ALTER TABLE `passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `role` varbinary(255) NOT NULL,
  `permissions` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`role`),
  CONSTRAINT `perm_name_roles` FOREIGN KEY (`role`) REFERENCES `roles` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES ('administration','[{\"grant\":\"true\",\"priority\":\"true\",\"permission\":\"*\"}]');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `query_template_def`
--

DROP TABLE IF EXISTS `query_template_def`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `query_template_def` (
  `id` int(10) unsigned NOT NULL,
  `definition` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `query_template_def_ibfk_1` FOREIGN KEY (`id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `query_template_def`
--

LOCK TABLES `query_template_def` WRITE;
/*!40000 ALTER TABLE `query_template_def` DISABLE KEYS */;
/*!40000 ALTER TABLE `query_template_def` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reference_data`
--

DROP TABLE IF EXISTS `reference_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_data` (
  `domain_id` int(10) unsigned NOT NULL COMMENT 'Domain.',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity.',
  `property_id` int(10) unsigned NOT NULL COMMENT 'Property.',
  `value` int(10) unsigned NOT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX','REPLACEMENT') COLLATE utf8_unicode_ci NOT NULL COMMENT 'Status of this statement.',
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  KEY `entity_id` (`entity_id`,`property_id`),
  KEY `ref_domain_id_entity` (`domain_id`),
  KEY `ref_property_id_entity` (`property_id`),
  KEY `ref_value_entity` (`value`),
  CONSTRAINT `ref_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `ref_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `ref_property_id_entity` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `ref_value_entity` FOREIGN KEY (`value`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reference_data`
--

LOCK TABLES `reference_data` WRITE;
/*!40000 ALTER TABLE `reference_data` DISABLE KEYS */;
INSERT INTO `reference_data` VALUES (0,243,233,119,'REPLACEMENT',6),(0,243,119,240,'FIX',0),(0,243,232,120,'REPLACEMENT',7),(0,243,120,241,'FIX',0),(0,243,234,121,'REPLACEMENT',8),(0,243,121,242,'FIX',0),(0,265,255,230,'FIX',3),(0,265,256,243,'FIX',4),(0,265,257,119,'REPLACEMENT',6),(0,265,119,262,'FIX',0),(0,265,260,120,'REPLACEMENT',7),(0,265,120,263,'FIX',0),(0,265,259,121,'REPLACEMENT',8),(0,265,121,264,'FIX',0),(0,270,257,119,'REPLACEMENT',1),(0,270,260,120,'REPLACEMENT',2),(0,271,257,119,'REPLACEMENT',1),(0,271,119,268,'FIX',0),(0,271,260,120,'REPLACEMENT',2),(0,271,120,269,'FIX',0),(0,271,267,266,'FIX',3),(0,273,222,271,'FIX',1),(0,277,222,230,'FIX',1),(0,279,222,243,'FIX',1),(0,278,222,265,'FIX',1),(0,276,222,99,'FIX',1),(0,230,221,119,'REPLACEMENT',3),(0,230,119,226,'FIX',0),(0,230,220,120,'REPLACEMENT',4),(0,230,120,227,'FIX',0),(0,230,218,121,'REPLACEMENT',5),(0,230,121,228,'FIX',0),(0,230,219,122,'REPLACEMENT',6),(0,230,122,229,'FIX',0);
/*!40000 ALTER TABLE `reference_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `name` varbinary(255) NOT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES ('administration','Users with this role have unrestricted permissions.'),('anonymous','Users who did not authenticate themselves.');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rules`
--

DROP TABLE IF EXISTS `rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rules` (
  `domain_id` int(10) unsigned NOT NULL,
  `entity_id` int(10) unsigned NOT NULL,
  `transaction` enum('INSERT','RETRIEVE','UPDATE','DELETE') COLLATE utf8_unicode_ci NOT NULL,
  `criterion` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `modus` enum('MUST','SHOULD','SHOULDNT','MUSTNOT') COLLATE utf8_unicode_ci NOT NULL,
  KEY `rule_entity_id_entity` (`entity_id`),
  KEY `rule_domain_id_entity` (`domain_id`),
  CONSTRAINT `rule_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `rule_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rules`
--

LOCK TABLES `rules` WRITE;
/*!40000 ALTER TABLE `rules` DISABLE KEYS */;
INSERT INTO `rules` VALUES (0,0,'INSERT','CheckPropValid','MUST'),(0,0,'INSERT','CheckParValid','MUST'),(0,0,'INSERT','CheckParOblPropPresent','SHOULD'),(0,0,'INSERT','CheckValueParsable','MUST'),(0,0,'UPDATE','CheckPropValid','MUST'),(0,0,'UPDATE','CheckParValid','MUST'),(0,0,'UPDATE','CheckParOblPropPresent','SHOULD'),(0,0,'UPDATE','CheckValueParsable','MUST'),(0,0,'DELETE','CheckReferenceDependencyExistent','MUST'),(0,0,'DELETE','CheckChildDependencyExistent','MUST'),(0,1,'INSERT','CheckNamePresent','MUST'),(0,1,'INSERT','CheckPropPresent','SHOULD'),(0,1,'INSERT','SetImpToRecByDefault','MUST'),(0,1,'UPDATE','CheckNamePresent','MUST'),(0,1,'UPDATE','CheckPropPresent','SHOULD'),(0,1,'UPDATE','SetImpToRecByDefault','MUST'),(0,2,'INSERT','CheckNamePresent','SHOULD'),(0,2,'INSERT','CheckPropPresent','SHOULD'),(0,2,'INSERT','CheckParPresent','MUST'),(0,2,'INSERT','SetImpToFix','MUST'),(0,2,'UPDATE','CheckNamePresent','SHOULD'),(0,2,'UPDATE','CheckPropPresent','SHOULD'),(0,2,'UPDATE','CheckParPresent','MUST'),(0,2,'UPDATE','SetImpToFix','MUST'),(0,3,'INSERT','CheckNamePresent','SHOULD'),(0,3,'INSERT','MatchFileProp','MUST'),(0,3,'INSERT','CheckTargetPathValid','MUST'),(0,3,'INSERT','SetImpToFix','MUST'),(0,3,'UPDATE','CheckNamePresent','SHOULD'),(0,3,'UPDATE','MatchFileProp','MUST'),(0,3,'UPDATE','CheckTargetPathValid','MUST'),(0,3,'UPDATE','SetImpToFix','MUST'),(0,4,'INSERT','CheckDatatypePresent','MUST'),(0,4,'UPDATE','CheckDatatypePresent','MUST'),(0,4,'INSERT','CheckNamePresent','MUST'),(0,4,'UPDATE','CheckNamePresent','MUST'),(0,4,'INSERT','SetImpToFix','MUST'),(0,4,'UPDATE','SetImpToFix','MUST'),(0,8,'UPDATE','CheckQueryTemplate','MUST'),(0,8,'INSERT','CheckQueryTemplate','MUST'),(0,11,'INSERT','CheckRefidPresent','SHOULD'),(0,11,'INSERT','CheckRefidValid','MUST'),(0,11,'INSERT','CheckRefidIsaParRefid','SHOULD'),(0,11,'UPDATE','CheckRefidPresent','SHOULD'),(0,11,'UPDATE','CheckRefidValid','MUST'),(0,11,'UPDATE','CheckRefidIsaParRefid','SHOULD'),(0,12,'INSERT','CheckUnitPresent','SHOULD'),(0,12,'INSERT','ParseUnit','SHOULD'),(0,12,'UPDATE','CheckUnitPresent','SHOULD'),(0,12,'UPDATE','ParseUnit','SHOULD'),(0,13,'INSERT','CheckUnitPresent','SHOULD'),(0,13,'INSERT','ParseUnit','SHOULD'),(0,13,'UPDATE','CheckUnitPresent','SHOULD'),(0,13,'UPDATE','ParseUnit','SHOULD'),(0,16,'INSERT','CheckUnitPresent','SHOULD'),(0,16,'UPDATE','CheckUnitPresent','SHOULD'),(0,17,'INSERT','CheckRefidValid','MUST'),(0,17,'INSERT','CheckRefidIsaParRefid','MUST'),(0,17,'UPDATE','CheckRefidValid','MUST'),(0,17,'UPDATE','CheckRefidIsaParRefid','MUST'),(0,50,'UPDATE','CheckRefidValid','MUST'),(0,50,'UPDATE','CheckRefidIsaParRefid','SHOULD'),(0,50,'UPDATE','SQLiteTransaction','MUST');
/*!40000 ALTER TABLE `rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stats`
--

DROP TABLE IF EXISTS `stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stats` (
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` blob DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stats`
--

LOCK TABLES `stats` WRITE;
/*!40000 ALTER TABLE `stats` DISABLE KEYS */;
INSERT INTO `stats` VALUES ('RootBenchmark','\0sr\0)caosdb.server.database.misc.RootBenchmarkp\0^3L\0\0xr\00caosdb.server.database.misc.TransactionBenchmarkCl=E\0J\0sinceL\0measurementst\0Ljava/util/Map;[\0stackTraceElementst\0[Ljava/lang/StackTraceElement;L\0\rsubBenchmarksq\0~\0xp\0\0q#b͵sr\0java.util.HashMap`\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0\0w\0\0\0\0\0\0\0xur\0[Ljava.lang.StackTraceElement;F*<<\"9\0\0xp\0\0\0sr\0java.lang.StackTraceElementa	Ś&6݅\0B\0formatI\0\nlineNumberL\0classLoaderNamet\0Ljava/lang/String;L\0declaringClassq\0~\0\nL\0fileNameq\0~\0\nL\0\nmethodNameq\0~\0\nL\0\nmoduleNameq\0~\0\nL\0\rmoduleVersionq\0~\0\nxp\0\0Fpt\0java.lang.Threadt\0Thread.javat\0\rgetStackTracet\0	java.baset\011.0.6sq\0~\0	\0\0!t\0appt\00caosdb.server.database.misc.TransactionBenchmarkt\0TransactionBenchmark.javat\0<init>ppsq\0~\0	\0\0\0q\0~\0t\0)caosdb.server.database.misc.RootBenchmarkq\0~\0q\0~\0ppsq\0~\0	\0\0q\0~\0q\0~\0q\0~\0t\0<clinit>ppsq\0~\0	\0\0q\0~\0t\0\Zcaosdb.server.CaosDBServert\0CaosDBServer.javat\0mainppsq\0~\0?@\0\0\0\0\0w\0\0\0\0\0\0t\0Infosr\0(caosdb.server.database.misc.SubBenchmark|\rQ(\0L\0nameq\0~\0\nxq\0~\0\0\0q#bsq\0~\0?@\0\0\0\0\0\0w\0\0\0\0\0\0\0xuq\0~\0\0\0\0\nsq\0~\0	\0\0Fpq\0~\0q\0~\0\rq\0~\0q\0~\0q\0~\0sq\0~\0	\0\0!q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0	\0\0\0q\0~\0t\0(caosdb.server.database.misc.SubBenchmarkq\0~\0q\0~\0ppsq\0~\0	\0\0q\0~\0q\0~\0q\0~\0t\0getBenchmarkppsq\0~\0	\0\0q\0~\0q\0~\0q\0~\0q\0~\0)ppsq\0~\0	\0\0\0#q\0~\0t\0.caosdb.server.transaction.TransactionInterfacet\0TransactionInterface.javat\0getTransactionBenchmarkppsq\0~\0	\0\0\0+q\0~\0q\0~\0,q\0~\0-t\0executeppsq\0~\0	\0\0\0q\0~\0t\0caosdb.server.utils.Infot\0	Info.javat\0syncDatabaseppsq\0~\0	\0\0\0q\0~\0t\0+caosdb.server.database.misc.RootBenchmark$1q\0~\0t\0runppsq\0~\0	\0\0Bpq\0~\0q\0~\0\rq\0~\07q\0~\0q\0~\0sq\0~\0?@\0\0\0\0\0w\0\0\0\0\0\0t\0	SyncStatssq\0~\0 \0\0q#bsq\0~\0?@\0\0\0\0\0\0w\0\0\0\0\0\0\0xuq\0~\0\0\0\0	sq\0~\0	\0\0Fpq\0~\0q\0~\0\rq\0~\0q\0~\0q\0~\0sq\0~\0	\0\0!q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0	\0\0\0q\0~\0q\0~\0\'q\0~\0q\0~\0ppsq\0~\0	\0\0q\0~\0q\0~\0q\0~\0q\0~\0)ppsq\0~\0	\0\0q\0~\0q\0~\0q\0~\0q\0~\0)ppsq\0~\0	\0\0\0+q\0~\0q\0~\0,q\0~\0-q\0~\00ppsq\0~\0	\0\0\0q\0~\0q\0~\02q\0~\03q\0~\04ppsq\0~\0	\0\0\0q\0~\0q\0~\06q\0~\0q\0~\07ppsq\0~\0	\0\0Bpq\0~\0q\0~\0\rq\0~\07q\0~\0q\0~\0sq\0~\0?@\0\0\0\0\0w\0\0\0\0\0\0t\0MySQLSyncStatssq\0~\0 \0\0q#bsq\0~\0?@\0\0\0\0\0\0w\0\0\0\0\0\0\0xuq\0~\0\0\0\0sq\0~\0	\0\0Fpq\0~\0q\0~\0\rq\0~\0q\0~\0q\0~\0sq\0~\0	\0\0!q\0~\0q\0~\0q\0~\0q\0~\0ppsq\0~\0	\0\0\0q\0~\0q\0~\0\'q\0~\0q\0~\0ppsq\0~\0	\0\0q\0~\0q\0~\0q\0~\0q\0~\0)ppsq\0~\0	\0\0q\0~\0q\0~\0q\0~\0q\0~\0)ppsq\0~\0	\0\0\0q\0~\0t\0)caosdb.server.database.BackendTransactiont\0BackendTransaction.javat\0getImplementationppsq\0~\0	\0\0\0+q\0~\0t\04caosdb.server.database.backend.transaction.SyncStatst\0SyncStats.javaq\0~\00ppsq\0~\0	\0\0\0q\0~\0q\0~\0Rq\0~\0St\0executeTransactionppsq\0~\0	\0\0\0,q\0~\0q\0~\0,q\0~\0-q\0~\00ppsq\0~\0	\0\0\0q\0~\0q\0~\02q\0~\03q\0~\04ppsq\0~\0	\0\0\0q\0~\0q\0~\06q\0~\0q\0~\07ppsq\0~\0	\0\0Bpq\0~\0q\0~\0\rq\0~\07q\0~\0q\0~\0sq\0~\0?@\0\0\0\0\0\0w\0\0\0\0\0\0\0xq\0~\0Hxq\0~\0:xq\0~\0x'),('TransactionBenchmark','\0sr\00caosdb.server.database.misc.TransactionBenchmarkCl=E\0J\0sinceL\0acct\0Ljava/util/HashMap;L\0countsq\0~\0xp\0\0g:>sr\0java.util.HashMap`\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0Retrieve.commitsr\0java.lang.Long;̏#\0J\0valuexr\0java.lang.Number\0\0xp\0\0\0\0\0\0\0t\0Retrieve.checksq\0~\0\0\0\0\0\0\0\0t\0GetUpdateableChecksumssq\0~\0\0\0\0\0\0\0\0t\0RuleLoader (cached=true)sq\0~\0\0\0\0\0\0\0\03t\07RetrieveFullEntity -> RetrieveProperties (cached=false)sq\0~\0\0\0\0\0\0\0t\0\rUpdate.commitsq\0~\0\0\0\0\0\0\0\0t\0*RetrieveSparseEntityByPath.pre_transactionsq\0~\0\0\0\0\0\0\0\0\0t\0CheckDatatypePresentsq\0~\0\0\0\0\0\0\0t\0Inheritancesq\0~\0\0\0\0\0\0\0\0\nt\0CheckParOblPropPresentsq\0~\0\0\0\0\0\0\0\0,t\0CheckRefidValidsq\0~\0\0\0\0\0\0\0\0t\0Retrieve.pre_checksq\0~\0\0\0\0\0\0\0\0t\0CheckParPresentq\0~\0t\0%RetrieveSparseEntityByPath.post_checkq\0~\0t\0Historysq\0~\0\0\0\0\0\0\0?t\0FQuery.SubProperty.POV.initPOVPropertiesTable()#initPropertiesTableByIdsq\0~\0\0\0\0\0\0\0\0t\0#RetrieveSparseEntity (cached=false)sq\0~\0\0\0\0\0\0\0\0t\0!RetrieveSparseEntityByPath.commitq\0~\0t\0\rAccessControlsq\0~\0\0\0\0\0\0\0t\0+RetrieveSparseEntityByPath.post_transactionq\0~\0t\0>Query.SubProperty.POV.initPOVPropertiesTable()#addReplacementssq\0~\0\0\0\0\0\0\0\0t\0Insert.transactionsq\0~\0\0\0\0\0\0\00t\0.Query.POV.initPOVPropertiesTable()#getChildrensq\0~\0\0\0\0\0\0\0t\0Delete.cleanupsq\0~\0\0\0\0\0\0\0\0t\0Insert.checksq\0~\0\0\0\0\0\0\0t\0\ZDeleteEntity -> DeleteFilesq\0~\0\0\0\0\0\0\0\0t\0Insert.post_transactionsq\0~\0\0\0\0\0\0\0\0t\0\ZUpdateEntity -> InsertFileq\0~\0,t\0CheckUnitPresentsq\0~\0\0\0\0\0\0\0\0t\0Query.POV.initPOVRefidsTable()sq\0~\0\0\0\0\0\0t\0\rRetrieve.initsq\0~\0\0\0\0\0\0ht\0RetrieveFullEntitysq\0~\0\0\0\0\0\0\0t\0GetDependentEntitiessq\0~\0\0\0\0\0\0\0%at\0RetrieveSparseEntityByPath.initq\0~\0$t\0\"RetrieveSparseEntityByPath.cleanupsq\0~\0\0\0\0\0\0\0\0t\0)RetrieveTransactionHistory (cached=false)sq\0~\0\0\0\0\0\0\0\0^t\08RetrieveFullEntity -> RetrieveSparseEntity (cached=true)sq\0~\0\0\0\0\0\0\0\0Kt\0&DeleteEntity -> DeleteEntityPropertiessq\0~\0\0\0\0\0\0\0t\0\\RetrieveFullEntity -> RetrieveProperties (cached=true) -> RetrieveSparseEntity (cached=true)q\0~\0\Zt\0Query.IDFiltersq\0~\0\0\0\0\0\0\0\0t\0 CheckReferenceDependencyExistentsq\0~\0\0\0\0\0\0\0%et\0&InsertEntity -> InsertEntityPropertiessq\0~\0\0\0\0\0\0\0;t\0;UpdateEntity -> InsertEntityProperties -> RegisterSubDomainq\0~\0Ot\0?Query.SubProperty.POV.initPOVPropertiesTable()#findReplacementssq\0~\0\0\0\0\0\0\0&t\0HQuery.SubProperty.POV.initPOVPropertiesTable()#initPropertiesTableByNamesq\0~\0\0\0\0\0\0\0t\0RetrieveAllJobq\0~\0Ft\0\nUniqueNamesq\0~\0\0\0\0\0\0\0\0Pt\0;InsertEntity -> InsertEntityProperties -> RegisterSubDomainsq\0~\0\0\0\0\0\0\0\0@t\0RetrieveDatatypessq\0~\0\0\0\0\0\0\0\0t\0Delete.pre_checksq\0~\0\0\0\0\0\0\0\0t\0Delete.checksq\0~\0\0\0\0\0\0\0%t\0Update.post_checksq\0~\0\0\0\0\0\0\0\0t\0*Query.SubProperty.POV.initPOVRefidsTable()sq\0~\0\0\0\0\0\0\0t\0\rMatchFilePropq\0~\0t\0Update.cleanupsq\0~\0\0\0\0\0\0\0\0t\0Retrieve.post_checkq\0~\02t\0Update.pre_transactionsq\0~\0\0\0\0\0\0\0\0t\0CheckPropValidsq\0~\0\0\0\0\0\0\0t\0	Query.POVsq\0~\0\0\0\0\0\0\Zt\0#FileSystemResource.checkPermissionssq\0~\0\0\0\0\0\0\0;t\0\rCheckParValidsq\0~\0\0\0\0\0\0\0\0t\0RetrieveAllq\0~\0\nt\0Insert.cleanupsq\0~\0\0\0\0\0\0\0\0t\0#Query.SubProperty.POV.executeStmt()sq\0~\0\0\0\0\0\0\0t\0\ZRetrieveUser (cached=true)sq\0~\0\0\0\0\0\0\0\04t\0ResolveNamessq\0~\0\0\0\0\0\0\0\0zt\0Retrieve.pre_transactionq\0~\0\nt\0Query.Backreferencesq\0~\0\0\0\0\0\0\0kt\0\rInsert.commitsq\0~\0\0\0\0\0\0\0\0t\0Update.checksq\0~\0\0\0\0\0\0\0t\0RemoveDuplicatessq\0~\0\0\0\0\0\0\0\0t\02Query.POV.initPOVPropertiesTable()#addReplacementsq\0~\0;t\0\ZQuery.SubProperty.IDFiltersq\0~\0\0\0\0\0\0\0t\03RetrieveFullEntity -> RetrieveParents (cached=true)sq\0~\0\0\0\0\0\0\0\0t\0<Query.POV.initPOVPropertiesTable()#initPropertiesTableByNamesq\0~\0\0\0\0\0\0\0t\0Update.initsq\0~\0\0\0\0\0\0\0t\0\"DeleteEntity -> DeleteSparseEntitysq\0~\0\0\0\0\0\0\0\0t\06RetrieveFullEntity -> RetrieveProperties (cached=true)sq\0~\0\0\0\0\0\0\0\0t\0	IsSubTypesq\0~\0\0\0\0\0\0\0\0Dt\0\rDelete.commitsq\0~\0\0\0\0\0\0\0\0Gt\0\ZRetrieveRole (cached=true)sq\0~\0\0\0\0\0\0\0\0 t\0Query.POV.applyQueryTemplates()sq\0~\0\0\0\0\0\0\0t\0Insert.pre_checkq\0~\0t\0\nUpdateUsersq\0~\0\0\0\0\0\0\0\0\Zt\0GetChildrenq\0~\0t\0SetPasswordsq\0~\0\0\0\0\0\0\0\0+t\0InsertEntity -> InsertParentssq\0~\0\0\0\0\0\0\0\0Ht\0Query.RoleFiltersq\0~\0\0\0\0\0\0\0Wt\0Query.SubProperty.POVsq\0~\0\0\0\0\0\0\0	t\0Insert.historysq\0~\0\0\0\0\0\0\0\0:t\0^RetrieveFullEntity -> RetrieveProperties (cached=false) -> RetrieveSparseEntity (cached=false)q\0~\0]t\0$RetrieveSparseEntityByPath.pre_checkq\0~\0$t\0GetIDByNamesq\0~\0\0\0\0\0\0\0\0t\0Delete.initq\0~\0t\0Retrieve.cleanupsq\0~\0\0\0\0\0\0\0\0|t\0CheckPropPresentq\0~\0t\0Insert.initsq\0~\0\0\0\0\0\0\0\0t\0CheckRefidPresentq\0~\0t\0CheckEntityACLRolessq\0~\0\0\0\0\0\0\0t\0UpdateEntity -> InsertParentssq\0~\0\0\0\0\0\0\0\0-t\0&UpdateEntity -> InsertEntityPropertiessq\0~\0\0\0\0\0\0\0\0At\0\"RetrieveSparseEntity (cached=true)sq\0~\0\0\0\0\0\0\0\00t\0FileSystemResourcesq\0~\0\0\0\0\0\0\0\0xt\0Update.historysq\0~\0\0\0\0\0\0\0\09t\09RetrieveFullEntity -> RetrieveSparseEntity (cached=false)sq\0~\0\0\0\0\0\0\0Dt\0UpdateUnitConvertersq\0~\0t\0:Query.SubProperty.POV.initPOVPropertiesTable()#getChildrensq\0~\0\0\0\0\0\0\0ut\0CheckChildDependencyExistentsq\0~\0\0\0\0\0\0\0\06t\0FileSystemResource.getEntitysq\0~\0\0\0\0\0\0\0\0t\0	ParseUnitsq\0~\0\0\0\0\0\0\0\0t\0Delete.post_transactionq\0~\0$t\0CheckValueParsableq\0~\0t\0InsertEntitysq\0~\0\0\0\0\0\0\0.t\0\"GetFileRecordByPath (cached=false)sq\0~\0\0\0\0\0\0\0\0t\0%RetrievePermissionRules (cached=true)q\0~\0t\0UpdateEntitysq\0~\0\0\0\0\0\0\0kt\0]RetrieveFullEntity -> RetrieveProperties (cached=false) -> RetrieveSparseEntity (cached=true)q\0~\0t\0Delete.transactionsq\0~\0\0\0\0\0\0\0t\0Pagingq\0~\0t\03Query.POV.initPOVPropertiesTable()#findReplacementssq\0~\0\0\0\0\0\0\0t\0InsertTransactionHistorysq\0~\0\0\0\0\0\0\0\0t\0Delete.pre_transactionq\0~\0t\0UpdateSparseEntitysq\0~\0\0\0\0\0\0\0\0t\0\"InsertEntity -> InsertSparseEntitysq\0~\0\0\0\0\0\0\0\0t\0CheckTargetPathValidq\0~\0t\0:Query.POV.initPOVPropertiesTable()#initPropertiesTableByIdq\0~\0,t\0CheckRefidIsaParRefidsq\0~\0\0\0\0\0\0\0\0Yt\0 RetrieveSparseEntityByPath.checkq\0~\0,t\0ExecuteQuerysq\0~\0\0\0\0\0\0t\0Delete.historysq\0~\0\0\0\0\0\0\0\0\"t\0.Query.SubProperty.POV.initPOVPropertiesTable()sq\0~\0\0\0\0\0\0\0bt\0ProcessNamePropertiessq\0~\0\0\0\0\0\0\0\02t\0&UpdateEntity -> DeleteEntityPropertiessq\0~\0\0\0\0\0\0\0\0t\0\'Query.Backreference.initBackreference()sq\0~\0\0\0\0\0\0\0Nt\0GetInfosq\0~\0\0\0\0\0\0\02t\0\"Query.POV.initPOVPropertiesTable()sq\0~\0\0\0\0\0\0\0t\09Query.SubProperty.filterEntitiesWithoutRetrievePermissionsq\0~\0\0\0\0\0\0\04t\0LoadContainerFlagJobssq\0~\0\0\0\0\0\0\0\0%t\0Retrieve.post_transactionsq\0~\0\0\0\0\0\0\0t\0SetImpToFixq\0~\0t\0Insert.pre_transactionq\0~\0t\0RetrieveUser (cached=false)sq\0~\0\0\0\0\0\0\0\0jt\0$InsertEntity -> InsertEntityDatatypeq\0~\0\nt\0\ZInsertEntity -> InsertFileq\0~\0;t\0&RetrieveSparseEntityByPath.transactionsq\0~\0\0\0\0\0\0\0\0t\0Update.transactionsq\0~\0\0\0\0\0\0\0nt\0!Query.Backreference.executeStmt()sq\0~\0\0\0\0\0\0\0\0t\0DeleteEntitysq\0~\0\0\0\0\0\0\0\nt\0&RetrievePermissionRules (cached=false)sq\0~\0\0\0\0\0\0\0\0\rt\0Atomicq\0~\0t\0Update.pre_checkq\0~\0,t\0Retrieve.historyq\0~\0t\0SetImpToRecByDefaultq\0~\0t\0RetrieveRole (cached=false)sq\0~\0\0\0\0\0\0\0\0t\0CheckNamePresentq\0~\0mt\0Retrieve.transactionsq\0~\0\0\0\0\0\0\0t\0RetrievePasswordValidatorsq\0~\0\0\0\0\0\0\0t\0Query.SubPropertysq\0~\0\0\0\0\0\02Ft\0	SyncStatssq\0~\0\0\0\0\0\0\0(t\04RetrieveFullEntity -> RetrieveParents (cached=false)sq\0~\0\0\0\0\0\0\0\0t\0!UpdateEntity -> InsertEntityValueq\0~\0$t\0\"RetrieveSparseEntityByPath.historyq\0~\0t\0-Query.filterEntitiesWithoutRetrievePermissionsq\0~\0\0\0\0\0\0\0t\0+Query.SubProperty.POV.applyQueryTemplates()q\0~\0,t\0Query.StoredAtsq\0~\0\0\0\0\0\0\0\0t\0Query.POV.applySubProperty()sq\0~\0\0\0\0\0\02Pt\0Update.post_transactionq\0~\0t\0RuleLoader (cached=false)sq\0~\0\0\0\0\0\0\0\0Mt\0\"UpdateEntity -> UpdateSparseEntitysq\0~\0\0\0\0\0\0\0\0it\0)Query.Backreference.applyQueryTemplates()q\0~\0,t\0InsertLogRecordsq\0~\0\0\0\0\0\0\0t\0Query.Conjunctionsq\0~\0\0\0\0\0\0\0+t\0Query.POV.executeStmt()sq\0~\0\0\0\0\0\0\0.t\0Insert.post_checksq\0~\0\0\0\0\0\0\0\0&t\0Delete.post_checkq\0~\0xsq\0~\0?@\0\0\0\0\0w\0\0\0\0\0\0q\0~\0sr\0java.lang.Integer⠤8\0I\0valuexq\0~\0\0\0	q\0~\0	sq\0~8\0\0	q\0~\0sq\0~8\0\0\0wq\0~\0\rsq\0~8\0\0q\0~\0sq\0~8\0\0Xq\0~\0sq\0~8\0\0\0!q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0q\0~\0sq\0~8\0\0q\0~\0sq\0~8\0\0q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0	q\0~\0sq\0~8\0\0\0Cq\0~\0 sq\0~8\0\0\0q\0~\0!sq\0~8\0\0q\0~\0#sq\0~8\0\0\0q\0~\0%sq\0~8\0\0\0q\0~\0\'sq\0~8\0\0\0q\0~\0(sq\0~8\0\0	q\0~\0*sq\0~8\0\0\0q\0~\0+sq\0~8\0\0\0q\0~\0-sq\0~8\0\0\0,q\0~\0/sq\0~8\0\0\0(q\0~\01sq\0~8\0\0\0q\0~\03q\0~Nq\0~\05sq\0~8\0\0\0q\0~\07q\0~Nq\0~\09sq\0~8\0\0\0q\0~\0:sq\0~8\0\0\0q\0~\0<sq\0~8\0\0q\0~\0>sq\0~8\0\0	q\0~\0@sq\0~8\0\0\nq\0~\0Bsq\0~8\0\0\0q\0~\0Dsq\0~8\0\0\0q\0~\0Esq\0~8\0\0\0q\0~\0Gsq\0~8\0\0\0q\0~\0Isq\0~8\0\0\nq\0~\0Ksq\0~8\0\0\0q\0~\0Msq\0~8\0\0q\0~\0Nq\0~Hq\0~\0Psq\0~8\0\0\'q\0~\0Rsq\0~8\0\0\0q\0~\0Tsq\0~8\0\0\0/q\0~\0Usq\0~8\0\0\0q\0~\0Wsq\0~8\0\0\0	q\0~\0Ysq\0~8\0\0\0q\0~\0Zsq\0~8\0\0\0-q\0~\0\\sq\0~8\0\0\0q\0~\0^sq\0~8\0\0\0q\0~\0`q\0~Pq\0~\0bq\0~Pq\0~\0dq\0~>q\0~\0fq\0~bq\0~\0hsq\0~8\0\0\0?q\0~\0iq\0~>q\0~\0ksq\0~8\0\0	q\0~\0lq\0~>q\0~\0nsq\0~8\0\0q\0~\0psq\0~8\0\0q\0~\0rsq\0~8\0\0\0q\0~\0tsq\0~8\0\0q\0~\0vq\0~cq\0~\0wq\0~Nq\0~\0yq\0~bq\0~\0{sq\0~8\0\0Aq\0~\0}sq\0~8\0\0	q\0~\0sq\0~8\0\0	q\0~\0q\0~fq\0~\0q\0~Nq\0~\0q\0~>q\0~\0sq\0~8\0\0	q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0q\0~\0sq\0~8\0\0	q\0~\0sq\0~8\0\0\0*q\0~\0q\0~>q\0~\0sq\0~8\0\0\0oq\0~\0sq\0~8\0\0	q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0\0\nq\0~\0sq\0~8\0\0(q\0~\0sq\0~8\0\0q\0~\0q\0~Nq\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0\0q\0~\0q\0~Hq\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0\0q\0~\0q\0~bq\0~\0q\0~Nq\0~\0sq\0~8\0\0\0_q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0^q\0~\0q\0~Pq\0~\0sq\0~8\0\0	q\0~\0sq\0~8\0\0\0xq\0~\0q\0~Nq\0~\0sq\0~8\0\0\0:q\0~\0sq\0~8\0\0	q\0~\0q\0~`q\0~\0q\0~`q\0~\0sq\0~8\0\0	q\0~\0q\0~q\0~\0q\0~>q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0\0q\0~\0q\0~aq\0~\0sq\0~8\0\0\'q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0\0q\0~\0q\0~xq\0~\0sq\0~8\0\06q\0~\0sq\0~8\0\0\0$q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0q\0~\0sq\0~8\0\0\0\Zq\0~\0sq\0~8\0\0q\0~\0q\0~xq\0~\0sq\0~8\0\0\0q\0~\0q\0~Oq\0~\0sq\0~8\0\0\0Wq\0~\0q\0~Pq\0~\0q\0~Rq\0~\0sq\0~8\0\0\0q\0~\0q\0~gq\0~\0q\0~Mq\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0q\0~\0q\0~xq\0~\0q\0~bq\0~\0sq\0~8\0\0q\0~\0q\0~`q\0~\0q\0~fq\0~\0sq\0~8\0\0\nq\0~\0sq\0~8\0\0q\0~\0sq\0~8\0\0\0q\0~\0sq\0~8\0\0	q\0~\0sq\0~8\0\0	q\0~\0sq\0~8\0\0 q\0~\0q\0~Nq\0~\0sq\0~8\0\0\0tq\0~sq\0~8\0\0\0.q\0~q\0~>q\0~sq\0~8\0\0\0q\0~q\0~>q\0~q\0~fq\0~\nq\0~fq\0~q\0~aq\0~sq\0~8\0\0\0Yq\0~q\0~>q\0~sq\0~8\0\0	q\0~sq\0~8\0\0\05q\0~sq\0~8\0\0>q\0~sq\0~8\0\0Uq\0~sq\0~8\0\0	q\0~sq\0~8\0\0Bq\0~sq\0~8\0\0q\0~sq\0~8\0\0:q\0~sq\0~8\0\0Xq\0~q\0~`q\0~ sq\0~8\0\0\0q\0~!sq\0~8\0\0q\0~#q\0~aq\0~$sq\0~8\0\0\0q\0~&sq\0~8\0\0q\0~(q\0~>q\0~)q\0~Eq\0~+q\0~`q\0~-sq\0~8\0\0\0q\0~.sq\0~8\0\0\0q\0~0sq\0~8\0\0\0q\0~2sq\0~8\0\0q\0~4q\0~Nq\0~6q\0~Px');
/*!40000 ALTER TABLE `stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `text_data`
--

DROP TABLE IF EXISTS `text_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `text_data` (
  `domain_id` int(10) unsigned NOT NULL COMMENT 'Domain.',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity.',
  `property_id` int(10) unsigned NOT NULL COMMENT 'Property.',
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `status` enum('OBLIGATORY','RECOMMENDED','SUGGESTED','FIX','REPLACEMENT') COLLATE utf8_unicode_ci NOT NULL COMMENT 'Status of this statement.',
  `pidx` int(10) unsigned NOT NULL DEFAULT 0,
  KEY `domain_id` (`domain_id`,`entity_id`),
  KEY `str_entity_id_entity` (`entity_id`),
  KEY `str_property_id_entity` (`property_id`),
  CONSTRAINT `str_domain_id_entity` FOREIGN KEY (`domain_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `str_entity_id_entity` FOREIGN KEY (`entity_id`) REFERENCES `entities` (`id`),
  CONSTRAINT `str_property_id_entity` FOREIGN KEY (`property_id`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `text_data`
--

LOCK TABLES `text_data` WRITE;
/*!40000 ALTER TABLE `text_data` DISABLE KEYS */;
INSERT INTO `text_data` VALUES (0,235,21,'px','FIX',0),(0,236,21,'px','FIX',0),(0,243,239,'Anton Beta','FIX',5),(243,235,21,'px','FIX',0),(243,236,21,'px','FIX',0),(0,244,239,'Cathryn Delta','FIX',5),(244,235,21,'px','FIX',0),(244,236,21,'px','FIX',0),(0,245,239,'Cathryn Delta','FIX',5),(245,235,21,'px','FIX',0),(245,236,21,'px','FIX',0),(0,246,239,'Cathryn Delta','FIX',5),(246,235,21,'px','FIX',0),(246,236,21,'px','FIX',0),(0,247,239,'Cathryn Delta','FIX',5),(247,235,21,'px','FIX',0),(247,236,21,'px','FIX',0),(0,248,239,'Cathryn Delta','FIX',5),(248,235,21,'px','FIX',0),(248,236,21,'px','FIX',0),(0,249,239,'Cathryn Delta','FIX',5),(249,235,21,'px','FIX',0),(249,236,21,'px','FIX',0),(0,250,239,'Cathryn Delta','FIX',5),(250,235,21,'px','FIX',0),(250,236,21,'px','FIX',0),(0,251,239,'Cathryn Delta','FIX',5),(251,235,21,'px','FIX',0),(251,236,21,'px','FIX',0),(0,252,239,'Cathryn Delta','FIX',5),(252,235,21,'px','FIX',0),(252,236,21,'px','FIX',0),(0,253,239,'Cathryn Delta','FIX',5),(253,235,21,'px','FIX',0),(253,236,21,'px','FIX',0),(0,265,239,'Anna Lytik','FIX',2),(0,265,261,'read ecg data\nThis is data/ECG.data\n\nread simulation results\nThis is TheResults.tsv\n\nstart algorithm with --resolution=0.01\n[OK]\ncreate plot\nstore results to results.npy\nwrite configuration to pickle\nFINISHED WITHOUT ERRORS','FIX',5),(0,271,239,'Anna Lytik','FIX',0),(0,273,223,'Click on [data_gol.webm](/Entity/266) to see a fancy video.','FIX',0),(0,277,223,'# Tour #\n\n- Find the analysis of this experiment by clicking on the [backref button](/Entity/?P=0L10&query=FIND+Entity+which+references+230) in the upper right corner.','FIX',0),(0,279,223,'# Tour #\n\nThis is only one simulation! Do you want to compare it to others? Click `Query` at the very top of this page, enter\n```\nSELECT Width, Result, Success FROM MySimulation\n```\ninto the text field and hit the *execute* button.','FIX',0),(0,278,223,'# Tour #\n\nThis analysis compared experiment and simulation.\n\n- Go back to the experiment by clicking on the `230`.\n- Find the simulation by clicking on the `243`.\n- See the preview of the plot by clicking on the *eye* button in the last row.','FIX',0),(0,276,223,'# Welcome to CaosDB! #\nThis web interface allows you to browse through the stored data, look at connections between datasets, preview files, download raw data and save query results.\n\n- For an overview over stored data, have a look at the **Entities** dropdown menu above.\n- When a Record is displayed, links to other Records or file objects have a preview button (the *eye* icon).\n- You can browse the [File System](/FileSystem/) with the corresponding button above.\n- **Queries** are a very powerful feature of CaosDB.  When you click on the `Query` button above, you are presented with a choice of query examples.  Feel free to modify the queries.  Further help is available in the online documentation or by your friendly CaosDB support team.\n\n# Start a Tour #\n\n- [A special Experiment](/Entity/?P=0L10&query=Find+Record+UnicornExperiment)\n- [Example for a publication with media content](/Entity/271)','FIX',0),(0,230,217,'Unicorn','FIX',1),(0,230,214,'Anton Beta','FIX',2);
/*!40000 ALTER TABLE `text_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transaction_log`
--

DROP TABLE IF EXISTS `transaction_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_log` (
  `transaction` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Transaction.',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID.',
  `username` varbinary(255) NOT NULL,
  `seconds` bigint(20) unsigned NOT NULL DEFAULT 0,
  `nanos` int(10) unsigned NOT NULL DEFAULT 0,
  `realm` varbinary(255) NOT NULL,
  KEY `entity_id` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transaction_log`
--

LOCK TABLES `transaction_log` WRITE;
/*!40000 ALTER TABLE `transaction_log` DISABLE KEYS */;
INSERT INTO `transaction_log` VALUES ('Insert',100,'caosdb',1545302948,272000000,'PAM'),('Insert',101,'caosdb',1545302948,272000000,'PAM'),('Insert',102,'caosdb',1545302948,272000000,'PAM'),('Insert',103,'caosdb',1545302948,272000000,'PAM'),('Insert',104,'caosdb',1545302948,272000000,'PAM'),('Insert',105,'caosdb',1545302948,272000000,'PAM'),('Insert',106,'caosdb',1545302948,272000000,'PAM'),('Insert',107,'caosdb',1545302948,272000000,'PAM'),('Insert',108,'caosdb',1545302948,272000000,'PAM'),('Insert',109,'caosdb',1545302948,272000000,'PAM'),('Insert',110,'caosdb',1545302948,272000000,'PAM'),('Insert',111,'caosdb',1545302948,272000000,'PAM'),('Insert',112,'caosdb',1545302948,272000000,'PAM'),('Insert',113,'caosdb',1545302948,272000000,'PAM'),('Insert',114,'caosdb',1545302948,731000000,'PAM'),('Insert',115,'caosdb',1545302948,731000000,'PAM'),('Insert',116,'caosdb',1545302948,731000000,'PAM'),('Insert',117,'caosdb',1545302948,731000000,'PAM'),('Insert',118,'caosdb',1545302949,409000000,'PAM'),('Insert',123,'caosdb',1545302949,787000000,'PAM'),('Insert',124,'caosdb',1545302949,787000000,'PAM'),('Insert',125,'caosdb',1545302949,787000000,'PAM'),('Insert',126,'caosdb',1545302949,787000000,'PAM'),('Insert',127,'caosdb',1545302949,787000000,'PAM'),('Insert',128,'caosdb',1545302949,787000000,'PAM'),('Insert',129,'caosdb',1545302949,787000000,'PAM'),('Insert',130,'caosdb',1545302949,787000000,'PAM'),('Insert',131,'caosdb',1545302949,787000000,'PAM'),('Update',123,'caosdb',1545302949,899000000,'PAM'),('Update',124,'caosdb',1545302949,899000000,'PAM'),('Update',125,'caosdb',1545302949,899000000,'PAM'),('Update',126,'caosdb',1545302949,899000000,'PAM'),('Update',129,'caosdb',1545302949,899000000,'PAM'),('Update',130,'caosdb',1545302949,899000000,'PAM'),('Update',131,'caosdb',1545302949,899000000,'PAM'),('Insert',132,'caosdb',1545302950,177000000,'PAM'),('Insert',133,'caosdb',1545302950,177000000,'PAM'),('Insert',134,'caosdb',1545302950,177000000,'PAM'),('Insert',135,'caosdb',1545302950,737000000,'PAM'),('Insert',136,'caosdb',1545302950,737000000,'PAM'),('Insert',137,'caosdb',1545302950,737000000,'PAM'),('Insert',138,'caosdb',1545302950,737000000,'PAM'),('Insert',139,'caosdb',1545302950,737000000,'PAM'),('Insert',140,'caosdb',1545302950,737000000,'PAM'),('Insert',141,'caosdb',1545302950,737000000,'PAM'),('Insert',142,'caosdb',1545302950,737000000,'PAM'),('Insert',143,'caosdb',1545302950,737000000,'PAM'),('Insert',144,'caosdb',1545302950,737000000,'PAM'),('Insert',145,'caosdb',1545302950,737000000,'PAM'),('Insert',146,'caosdb',1545302953,863000000,'PAM'),('Insert',147,'caosdb',1545302953,863000000,'PAM'),('Insert',148,'caosdb',1545302953,863000000,'PAM'),('Insert',149,'caosdb',1545302953,863000000,'PAM'),('Insert',150,'caosdb',1545302953,863000000,'PAM'),('Insert',151,'caosdb',1545302953,863000000,'PAM'),('Insert',152,'caosdb',1545302953,863000000,'PAM'),('Insert',153,'caosdb',1545302953,863000000,'PAM'),('Update',146,'caosdb',1545302953,923000000,'PAM'),('Update',147,'caosdb',1545302953,923000000,'PAM'),('Update',148,'caosdb',1545302953,923000000,'PAM'),('Update',149,'caosdb',1545302953,923000000,'PAM'),('Update',150,'caosdb',1545302953,923000000,'PAM'),('Update',151,'caosdb',1545302953,923000000,'PAM'),('Update',152,'caosdb',1545302953,923000000,'PAM'),('Update',153,'caosdb',1545302953,923000000,'PAM'),('Insert',154,'caosdb',1545302954,195000000,'PAM'),('Insert',155,'caosdb',1545302954,195000000,'PAM'),('Insert',156,'caosdb',1545302954,195000000,'PAM'),('Insert',157,'caosdb',1545302954,645000000,'PAM'),('Update',100,'caosdb',1545303035,763000000,'PAM'),('Update',101,'caosdb',1545303035,763000000,'PAM'),('Update',104,'caosdb',1545303035,763000000,'PAM'),('Update',105,'caosdb',1545303035,763000000,'PAM'),('Update',106,'caosdb',1545303035,763000000,'PAM'),('Update',107,'caosdb',1545303035,763000000,'PAM'),('Update',108,'caosdb',1545303035,763000000,'PAM'),('Update',109,'caosdb',1545303035,763000000,'PAM'),('Update',110,'caosdb',1545303035,763000000,'PAM'),('Update',111,'caosdb',1545303035,763000000,'PAM'),('Update',100,'caosdb',1545303079,860000000,'PAM'),('Update',101,'caosdb',1545303079,860000000,'PAM'),('Update',104,'caosdb',1545303079,860000000,'PAM'),('Update',105,'caosdb',1545303079,860000000,'PAM'),('Update',106,'caosdb',1545303079,860000000,'PAM'),('Update',107,'caosdb',1545303079,860000000,'PAM'),('Update',108,'caosdb',1545303079,860000000,'PAM'),('Update',109,'caosdb',1545303079,860000000,'PAM'),('Update',110,'caosdb',1545303079,860000000,'PAM'),('Update',111,'caosdb',1545303079,860000000,'PAM'),('Delete',146,'caosdb',1545303421,193000000,'PAM'),('Delete',157,'caosdb',1545303421,193000000,'PAM'),('Delete',154,'caosdb',1545303421,489000000,'PAM'),('Delete',155,'caosdb',1545303421,489000000,'PAM'),('Delete',156,'caosdb',1545303421,489000000,'PAM'),('Delete',100,'caosdb',1545303424,27000000,'PAM'),('Delete',101,'caosdb',1545303424,27000000,'PAM'),('Delete',102,'caosdb',1545303424,27000000,'PAM'),('Delete',103,'caosdb',1545303424,27000000,'PAM'),('Delete',104,'caosdb',1545303424,27000000,'PAM'),('Delete',105,'caosdb',1545303424,27000000,'PAM'),('Delete',106,'caosdb',1545303424,27000000,'PAM'),('Delete',107,'caosdb',1545303424,27000000,'PAM'),('Delete',108,'caosdb',1545303424,27000000,'PAM'),('Delete',109,'caosdb',1545303424,27000000,'PAM'),('Delete',110,'caosdb',1545303424,27000000,'PAM'),('Delete',111,'caosdb',1545303424,27000000,'PAM'),('Delete',112,'caosdb',1545303424,27000000,'PAM'),('Delete',113,'caosdb',1545303424,27000000,'PAM'),('Delete',114,'caosdb',1545303424,27000000,'PAM'),('Delete',115,'caosdb',1545303424,27000000,'PAM'),('Delete',116,'caosdb',1545303424,27000000,'PAM'),('Delete',117,'caosdb',1545303424,27000000,'PAM'),('Delete',118,'caosdb',1545303424,27000000,'PAM'),('Delete',123,'caosdb',1545303424,27000000,'PAM'),('Delete',124,'caosdb',1545303424,27000000,'PAM'),('Delete',125,'caosdb',1545303424,27000000,'PAM'),('Delete',126,'caosdb',1545303424,27000000,'PAM'),('Delete',127,'caosdb',1545303424,27000000,'PAM'),('Delete',128,'caosdb',1545303424,27000000,'PAM'),('Delete',129,'caosdb',1545303424,27000000,'PAM'),('Delete',130,'caosdb',1545303424,27000000,'PAM'),('Delete',131,'caosdb',1545303424,27000000,'PAM'),('Delete',132,'caosdb',1545303424,27000000,'PAM'),('Delete',133,'caosdb',1545303424,27000000,'PAM'),('Delete',134,'caosdb',1545303424,27000000,'PAM'),('Delete',135,'caosdb',1545303424,27000000,'PAM'),('Delete',136,'caosdb',1545303424,27000000,'PAM'),('Delete',137,'caosdb',1545303424,27000000,'PAM'),('Delete',138,'caosdb',1545303424,27000000,'PAM'),('Delete',139,'caosdb',1545303424,27000000,'PAM'),('Delete',140,'caosdb',1545303424,27000000,'PAM'),('Delete',141,'caosdb',1545303424,27000000,'PAM'),('Delete',142,'caosdb',1545303424,27000000,'PAM'),('Delete',143,'caosdb',1545303424,27000000,'PAM'),('Delete',144,'caosdb',1545303424,27000000,'PAM'),('Delete',145,'caosdb',1545303424,27000000,'PAM'),('Delete',147,'caosdb',1545303424,27000000,'PAM'),('Delete',148,'caosdb',1545303424,27000000,'PAM'),('Delete',149,'caosdb',1545303424,27000000,'PAM'),('Delete',150,'caosdb',1545303424,27000000,'PAM'),('Delete',151,'caosdb',1545303424,27000000,'PAM'),('Delete',152,'caosdb',1545303424,27000000,'PAM'),('Delete',153,'caosdb',1545303424,27000000,'PAM'),('Insert',158,'caosdb',1545303437,468000000,'PAM'),('Insert',159,'caosdb',1545303437,468000000,'PAM'),('Insert',160,'caosdb',1545303437,468000000,'PAM'),('Insert',161,'caosdb',1545303437,468000000,'PAM'),('Insert',162,'caosdb',1545303437,468000000,'PAM'),('Insert',163,'caosdb',1545303437,468000000,'PAM'),('Insert',164,'caosdb',1545303437,468000000,'PAM'),('Insert',165,'caosdb',1545303437,468000000,'PAM'),('Insert',166,'caosdb',1545303437,468000000,'PAM'),('Insert',167,'caosdb',1545303437,468000000,'PAM'),('Insert',168,'caosdb',1545303437,468000000,'PAM'),('Insert',169,'caosdb',1545303437,468000000,'PAM'),('Insert',170,'caosdb',1545303437,468000000,'PAM'),('Insert',171,'caosdb',1545303437,468000000,'PAM'),('Insert',172,'caosdb',1545303437,721000000,'PAM'),('Insert',173,'caosdb',1545303437,721000000,'PAM'),('Insert',174,'caosdb',1545303437,721000000,'PAM'),('Insert',175,'caosdb',1545303437,721000000,'PAM'),('Insert',176,'caosdb',1545303438,169000000,'PAM'),('Insert',177,'caosdb',1545303438,459000000,'PAM'),('Insert',178,'caosdb',1545303438,459000000,'PAM'),('Insert',179,'caosdb',1545303438,459000000,'PAM'),('Insert',180,'caosdb',1545303438,459000000,'PAM'),('Insert',181,'caosdb',1545303438,459000000,'PAM'),('Insert',182,'caosdb',1545303438,459000000,'PAM'),('Insert',183,'caosdb',1545303438,459000000,'PAM'),('Insert',184,'caosdb',1545303438,459000000,'PAM'),('Insert',185,'caosdb',1545303438,459000000,'PAM'),('Update',177,'caosdb',1545303438,518000000,'PAM'),('Update',178,'caosdb',1545303438,518000000,'PAM'),('Update',179,'caosdb',1545303438,518000000,'PAM'),('Update',180,'caosdb',1545303438,518000000,'PAM'),('Update',183,'caosdb',1545303438,518000000,'PAM'),('Update',184,'caosdb',1545303438,518000000,'PAM'),('Update',185,'caosdb',1545303438,518000000,'PAM'),('Insert',186,'caosdb',1545303438,772000000,'PAM'),('Insert',187,'caosdb',1545303438,772000000,'PAM'),('Insert',188,'caosdb',1545303438,772000000,'PAM'),('Insert',189,'caosdb',1545303439,215000000,'PAM'),('Insert',190,'caosdb',1545303439,215000000,'PAM'),('Insert',191,'caosdb',1545303439,215000000,'PAM'),('Insert',192,'caosdb',1545303439,215000000,'PAM'),('Insert',193,'caosdb',1545303439,215000000,'PAM'),('Insert',194,'caosdb',1545303439,215000000,'PAM'),('Insert',195,'caosdb',1545303439,215000000,'PAM'),('Insert',196,'caosdb',1545303439,215000000,'PAM'),('Insert',197,'caosdb',1545303439,215000000,'PAM'),('Insert',198,'caosdb',1545303439,215000000,'PAM'),('Insert',199,'caosdb',1545303439,215000000,'PAM'),('Insert',200,'caosdb',1545303441,928000000,'PAM'),('Insert',201,'caosdb',1545303441,928000000,'PAM'),('Insert',202,'caosdb',1545303441,928000000,'PAM'),('Insert',203,'caosdb',1545303441,928000000,'PAM'),('Insert',204,'caosdb',1545303441,928000000,'PAM'),('Insert',205,'caosdb',1545303441,928000000,'PAM'),('Insert',206,'caosdb',1545303441,928000000,'PAM'),('Insert',207,'caosdb',1545303441,928000000,'PAM'),('Update',200,'caosdb',1545303441,978000000,'PAM'),('Update',201,'caosdb',1545303441,978000000,'PAM'),('Update',202,'caosdb',1545303441,978000000,'PAM'),('Update',203,'caosdb',1545303441,978000000,'PAM'),('Update',204,'caosdb',1545303441,978000000,'PAM'),('Update',205,'caosdb',1545303441,978000000,'PAM'),('Update',206,'caosdb',1545303441,978000000,'PAM'),('Update',207,'caosdb',1545303441,978000000,'PAM'),('Insert',208,'caosdb',1545303442,198000000,'PAM'),('Insert',209,'caosdb',1545303442,198000000,'PAM'),('Insert',210,'caosdb',1545303442,198000000,'PAM'),('Insert',211,'caosdb',1545303442,605000000,'PAM'),('Delete',200,'caosdb',1545303697,990000000,'PAM'),('Delete',211,'caosdb',1545303697,990000000,'PAM'),('Delete',208,'caosdb',1545303698,276000000,'PAM'),('Delete',209,'caosdb',1545303698,276000000,'PAM'),('Delete',210,'caosdb',1545303698,276000000,'PAM'),('Delete',158,'caosdb',1545303700,987000000,'PAM'),('Delete',159,'caosdb',1545303700,987000000,'PAM'),('Delete',160,'caosdb',1545303700,987000000,'PAM'),('Delete',161,'caosdb',1545303700,987000000,'PAM'),('Delete',162,'caosdb',1545303700,987000000,'PAM'),('Delete',163,'caosdb',1545303700,987000000,'PAM'),('Delete',164,'caosdb',1545303700,987000000,'PAM'),('Delete',165,'caosdb',1545303700,987000000,'PAM'),('Delete',166,'caosdb',1545303700,987000000,'PAM'),('Delete',167,'caosdb',1545303700,987000000,'PAM'),('Delete',168,'caosdb',1545303700,987000000,'PAM'),('Delete',169,'caosdb',1545303700,987000000,'PAM'),('Delete',170,'caosdb',1545303700,987000000,'PAM'),('Delete',171,'caosdb',1545303700,987000000,'PAM'),('Delete',172,'caosdb',1545303700,987000000,'PAM'),('Delete',173,'caosdb',1545303700,987000000,'PAM'),('Delete',174,'caosdb',1545303700,987000000,'PAM'),('Delete',175,'caosdb',1545303700,987000000,'PAM'),('Delete',176,'caosdb',1545303700,987000000,'PAM'),('Delete',177,'caosdb',1545303700,987000000,'PAM'),('Delete',178,'caosdb',1545303700,987000000,'PAM'),('Delete',179,'caosdb',1545303700,987000000,'PAM'),('Delete',180,'caosdb',1545303700,987000000,'PAM'),('Delete',181,'caosdb',1545303700,987000000,'PAM'),('Delete',182,'caosdb',1545303700,987000000,'PAM'),('Delete',183,'caosdb',1545303700,987000000,'PAM'),('Delete',184,'caosdb',1545303700,987000000,'PAM'),('Delete',185,'caosdb',1545303700,987000000,'PAM'),('Delete',186,'caosdb',1545303700,987000000,'PAM'),('Delete',187,'caosdb',1545303700,987000000,'PAM'),('Delete',188,'caosdb',1545303700,987000000,'PAM'),('Delete',189,'caosdb',1545303700,987000000,'PAM'),('Delete',190,'caosdb',1545303700,987000000,'PAM'),('Delete',191,'caosdb',1545303700,987000000,'PAM'),('Delete',192,'caosdb',1545303700,987000000,'PAM'),('Delete',193,'caosdb',1545303700,987000000,'PAM'),('Delete',194,'caosdb',1545303700,987000000,'PAM'),('Delete',195,'caosdb',1545303700,987000000,'PAM'),('Delete',196,'caosdb',1545303700,987000000,'PAM'),('Delete',197,'caosdb',1545303700,987000000,'PAM'),('Delete',198,'caosdb',1545303700,987000000,'PAM'),('Delete',199,'caosdb',1545303700,987000000,'PAM'),('Delete',201,'caosdb',1545303700,987000000,'PAM'),('Delete',202,'caosdb',1545303700,987000000,'PAM'),('Delete',203,'caosdb',1545303700,987000000,'PAM'),('Delete',204,'caosdb',1545303700,987000000,'PAM'),('Delete',205,'caosdb',1545303700,987000000,'PAM'),('Delete',206,'caosdb',1545303700,987000000,'PAM'),('Delete',207,'caosdb',1545303700,987000000,'PAM'),('Insert',212,'caosdb',1545303711,26000000,'PAM'),('Insert',213,'caosdb',1545303711,26000000,'PAM'),('Insert',214,'caosdb',1545303711,26000000,'PAM'),('Insert',215,'caosdb',1545303711,26000000,'PAM'),('Insert',216,'caosdb',1545303711,26000000,'PAM'),('Insert',217,'caosdb',1545303711,26000000,'PAM'),('Insert',218,'caosdb',1545303711,26000000,'PAM'),('Insert',219,'caosdb',1545303711,26000000,'PAM'),('Insert',220,'caosdb',1545303711,26000000,'PAM'),('Insert',221,'caosdb',1545303711,26000000,'PAM'),('Insert',222,'caosdb',1545303711,26000000,'PAM'),('Insert',223,'caosdb',1545303711,26000000,'PAM'),('Insert',224,'caosdb',1545303711,26000000,'PAM'),('Insert',225,'caosdb',1545303711,26000000,'PAM'),('Insert',226,'caosdb',1545303711,304000000,'PAM'),('Insert',227,'caosdb',1545303711,304000000,'PAM'),('Insert',228,'caosdb',1545303711,304000000,'PAM'),('Insert',229,'caosdb',1545303711,304000000,'PAM'),('Insert',230,'caosdb',1545303711,745000000,'PAM'),('Insert',231,'caosdb',1545303712,33000000,'PAM'),('Insert',232,'caosdb',1545303712,33000000,'PAM'),('Insert',233,'caosdb',1545303712,33000000,'PAM'),('Insert',234,'caosdb',1545303712,33000000,'PAM'),('Insert',235,'caosdb',1545303712,33000000,'PAM'),('Insert',236,'caosdb',1545303712,33000000,'PAM'),('Insert',237,'caosdb',1545303712,33000000,'PAM'),('Insert',238,'caosdb',1545303712,33000000,'PAM'),('Insert',239,'caosdb',1545303712,33000000,'PAM'),('Update',231,'caosdb',1545303712,82000000,'PAM'),('Update',232,'caosdb',1545303712,82000000,'PAM'),('Update',233,'caosdb',1545303712,82000000,'PAM'),('Update',234,'caosdb',1545303712,82000000,'PAM'),('Update',237,'caosdb',1545303712,82000000,'PAM'),('Update',238,'caosdb',1545303712,82000000,'PAM'),('Update',239,'caosdb',1545303712,82000000,'PAM'),('Insert',240,'caosdb',1545303712,314000000,'PAM'),('Insert',241,'caosdb',1545303712,314000000,'PAM'),('Insert',242,'caosdb',1545303712,314000000,'PAM'),('Insert',243,'caosdb',1545303712,742000000,'PAM'),('Insert',244,'caosdb',1545303712,742000000,'PAM'),('Insert',245,'caosdb',1545303712,742000000,'PAM'),('Insert',246,'caosdb',1545303712,742000000,'PAM'),('Insert',247,'caosdb',1545303712,742000000,'PAM'),('Insert',248,'caosdb',1545303712,742000000,'PAM'),('Insert',249,'caosdb',1545303712,742000000,'PAM'),('Insert',250,'caosdb',1545303712,742000000,'PAM'),('Insert',251,'caosdb',1545303712,742000000,'PAM'),('Insert',252,'caosdb',1545303712,742000000,'PAM'),('Insert',253,'caosdb',1545303712,742000000,'PAM'),('Insert',254,'caosdb',1545303715,627000000,'PAM'),('Insert',255,'caosdb',1545303715,627000000,'PAM'),('Insert',256,'caosdb',1545303715,627000000,'PAM'),('Insert',257,'caosdb',1545303715,627000000,'PAM'),('Insert',258,'caosdb',1545303715,627000000,'PAM'),('Insert',259,'caosdb',1545303715,627000000,'PAM'),('Insert',260,'caosdb',1545303715,627000000,'PAM'),('Insert',261,'caosdb',1545303715,627000000,'PAM'),('Update',254,'caosdb',1545303715,682000000,'PAM'),('Update',255,'caosdb',1545303715,682000000,'PAM'),('Update',256,'caosdb',1545303715,682000000,'PAM'),('Update',257,'caosdb',1545303715,682000000,'PAM'),('Update',258,'caosdb',1545303715,682000000,'PAM'),('Update',259,'caosdb',1545303715,682000000,'PAM'),('Update',260,'caosdb',1545303715,682000000,'PAM'),('Update',261,'caosdb',1545303715,682000000,'PAM'),('Insert',262,'caosdb',1545303715,926000000,'PAM'),('Insert',263,'caosdb',1545303715,926000000,'PAM'),('Insert',264,'caosdb',1545303715,926000000,'PAM'),('Insert',265,'caosdb',1545303716,334000000,'PAM'),('Insert',266,'caosdb',1545303785,512000000,'PAM'),('Insert',267,'caosdb',1545303785,512000000,'PAM'),('Insert',268,'caosdb',1545303785,512000000,'PAM'),('Insert',269,'caosdb',1545303785,512000000,'PAM'),('Insert',270,'caosdb',1545303785,512000000,'PAM'),('Insert',271,'caosdb',1545303785,512000000,'PAM'),('Insert',272,'caosdb',1545305089,100000000,'PAM'),('Insert',273,'caosdb',1545306191,994000000,'PAM'),('Delete',272,'caosdb',1545310730,505000000,'PAM'),('Insert',274,'caosdb',1545310934,708000000,'PAM'),('Insert',275,'caosdb',1545314381,734000000,'PAM'),('Insert',276,'caosdb',1545314449,734000000,'PAM'),('Delete',274,'caosdb',1545314572,415000000,'PAM'),('Delete',275,'caosdb',1545314572,415000000,'PAM'),('Insert',277,'caosdb',1545315351,562000000,'PAM'),('Insert',278,'caosdb',1545315836,660000000,'PAM'),('Insert',279,'caosdb',1545316140,501000000,'PAM'),('Insert',280,'admin',1585436898,95000000,'PAM');
/*!40000 ALTER TABLE `transaction_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `units_lin_con`
--

DROP TABLE IF EXISTS `units_lin_con`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units_lin_con` (
  `signature_from` bigint(20) NOT NULL,
  `signature_to` bigint(20) NOT NULL,
  `a` decimal(65,30) NOT NULL,
  `b_dividend` int(11) NOT NULL,
  `b_divisor` int(11) NOT NULL,
  `c` decimal(65,30) NOT NULL,
  PRIMARY KEY (`signature_from`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `units_lin_con`
--

LOCK TABLES `units_lin_con` WRITE;
/*!40000 ALTER TABLE `units_lin_con` DISABLE KEYS */;
/*!40000 ALTER TABLE `units_lin_con` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_info`
--

DROP TABLE IF EXISTS `user_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_info` (
  `realm` varbinary(255) NOT NULL,
  `name` varbinary(255) NOT NULL,
  `email` varbinary(255) DEFAULT NULL,
  `status` enum('ACTIVE','INACTIVE') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'INACTIVE',
  `entity` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`realm`,`name`),
  KEY `subject_entity` (`entity`),
  CONSTRAINT `subjects_ibfk_1` FOREIGN KEY (`entity`) REFERENCES `entities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_info`
--

LOCK TABLES `user_info` WRITE;
/*!40000 ALTER TABLE `user_info` DISABLE KEYS */;
INSERT INTO `user_info` VALUES ('CaosDB','guest','test@example.com','ACTIVE',NULL);
/*!40000 ALTER TABLE `user_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_roles`
--

DROP TABLE IF EXISTS `user_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_roles` (
  `realm` varbinary(255) NOT NULL,
  `user` varbinary(255) NOT NULL,
  `role` varbinary(255) NOT NULL,
  PRIMARY KEY (`realm`,`user`,`role`),
  KEY `user_roles_ibfk_1` (`role`),
  CONSTRAINT `user_roles_ibfk_1` FOREIGN KEY (`role`) REFERENCES `roles` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_roles`
--

LOCK TABLES `user_roles` WRITE;
/*!40000 ALTER TABLE `user_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'caosdb'
--
/*!50003 DROP FUNCTION IF EXISTS `CaosDBVersion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `CaosDBVersion`() RETURNS varchar(255) CHARSET utf8 COLLATE utf8_unicode_ci
    DETERMINISTIC
RETURN 'v2.1.1' ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `constructDateTimeWhereClauseForColumn` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `constructDateTimeWhereClauseForColumn`(seconds_col VARCHAR(255), nanos_col VARCHAR(255), vDateTimeSecLow VARCHAR(255), vDateTimeNSLow VARCHAR(255), vDateTimeSecUpp VARCHAR(255), vDateTimeNSUpp VARCHAR(255), operator CHAR(4)) RETURNS varchar(20000) CHARSET utf8 COLLATE utf8_unicode_ci
    DETERMINISTIC
BEGIN

	DECLARE isInterval BOOLEAN DEFAULT vDateTimeSecUpp IS NOT NULL or vDateTimeNSUpp IS NOT NULL; 
    DECLARE operator_prefix CHAR(1) DEFAULT LEFT(operator,1);

	IF isInterval THEN
		IF operator = '=' THEN
			RETURN " 0=1";
        ELSEIF operator = '!=' THEN
			RETURN " 0=1";
        ELSEIF operator = '>' or operator = '<=' THEN 
            RETURN CONCAT(" ", seconds_col, operator_prefix, vDateTimeSecUpp);
        ELSEIF operator = '<' or operator = '>=' THEN 
            RETURN CONCAT(" ", seconds_col, operator_prefix, vDateTimeSecLow);
		ELSEIF operator = "(" THEN
            RETURN CONCAT(" ", seconds_col, ">=", vDateTimeSecLow, " AND ",seconds_col, "<", vDateTimeSecUpp);
		ELSEIF operator = "!(" THEN
            RETURN CONCAT(" ", seconds_col, "<", vDateTimeSecLow, " OR ", seconds_col, ">=", vDateTimeSecUpp);
		END IF;
    ELSE
        IF operator = '=' THEN
            RETURN CONCAT(" ",
				seconds_col,
				"=", vDateTimeSecLow, IF(vDateTimeNSLow IS NULL, CONCAT(' AND ', nanos_col, ' IS NULL'), CONCAT(' AND ',
					nanos_col,
				'=', vDateTimeNSLow)));
        ELSEIF operator = '!=' THEN
            RETURN CONCAT(" ",
				seconds_col,
				"!=", vDateTimeSecLow, IF(vDateTimeNSLow IS NULL, '', CONCAT(' OR ',
						nanos_col,
						'!=', vDateTimeNSLow)));
        ELSEIF operator = '>' or operator = '<' THEN
            RETURN CONCAT(" ",
				seconds_col, operator, vDateTimeSecLow, IF(vDateTimeNSLow IS NULL, '', CONCAT(' OR (',seconds_col,'=', vDateTimeSecLow, ' AND ',nanos_col, operator, vDateTimeNSLow, ')')));
        ELSEIF operator = '>=' or operator = '<=' THEN
            RETURN CONCAT(" ",seconds_col, operator, vDateTimeSecLow, IF(vDateTimeNSLow IS NULL, '', CONCAT(' AND (',seconds_col, operator_prefix, vDateTimeSecLow, ' OR ',nanos_col, operator, vDateTimeNSLow, ')')));
		ELSEIF operator = "(" THEN
            RETURN IF(vDateTimeNSLow IS NULL,CONCAT(" ",seconds_col,"=", vDateTimeSecLow),CONCAT(" ",seconds_col,"=",vDateTimeSecLow," AND ",nanos_col,"=",vDateTimeNSLow));
		ELSEIF operator = "!(" THEN
            RETURN IF(vDateTimeNSLow IS NULL,CONCAT(" ",seconds_col,"!=",vDateTimeSecLow, ""),CONCAT(" ",seconds_col,"!=",vDateTimeSecLow," OR ",nanos_col, " IS NULL OR ", nanos_col, "!=",vDateTimeNSLow));
        END IF;
    END IF;
    return ' 0=1';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `convert_unit` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `convert_unit`(unit_sig BIGINT, value DECIMAL(65,30)) RETURNS decimal(65,30)
    DETERMINISTIC
BEGIN
    DECLARE ret DECIMAL(65,30) DEFAULT value;

    SELECT (((value+a)*b_dividend)/b_divisor+c) INTO ret FROM units_lin_con WHERE signature_from=unit_sig;
    RETURN ret;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `getAggValueWhereClause` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `getAggValueWhereClause`(entities VARCHAR(255), properties VARCHAR(255)) RETURNS varchar(20000) CHARSET utf8 COLLATE utf8_unicode_ci
    DETERMINISTIC
BEGIN
        RETURN CONCAT(" EXISTS (SELECT 1 FROM `", entities, "` AS ent WHERE ent.id = subdata.entity_id LIMIT 1)", IF(properties IS NOT NULL AND properties != '', CONCAT(" AND EXISTS (SELECT 1 FROM `", properties, "` as props WHERE props.id = subdata.property_id LIMIT 1)"),''));
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `getDateTimeWhereClause` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `getDateTimeWhereClause`(vDateTime VARCHAR(255), operator CHAR(4)) RETURNS varchar(20000) CHARSET utf8 COLLATE utf8_unicode_ci
    DETERMINISTIC
BEGIN
	DECLARE sep_loc INTEGER DEFAULT LOCATE('--',vDateTime);
    DECLARE vDateTimeLow VARCHAR(255) DEFAULT IF(sep_loc != 0, SUBSTRING_INDEX(vDateTime, '--',1), vDateTime);
    DECLARE vDateTimeUpp VARCHAR(255) DEFAULT IF(sep_loc != 0, SUBSTRING_INDEX(vDateTime, '--',-1), NULL);
	
    DECLARE vDateTimeSecLow VARCHAR(255) DEFAULT SUBSTRING_INDEX(vDateTimeLow, 'UTC', 1);
    DECLARE vDateTimeNSLow VARCHAR(255) DEFAULT IF(SUBSTRING_INDEX(vDateTimeLow, 'UTC', -1)='',NULL,SUBSTRING_INDEX(vDateTimeLow, 'UTC', -1));
	
    DECLARE vDateTimeSecUpp VARCHAR(255) DEFAULT IF(sep_loc != 0, SUBSTRING_INDEX(vDateTimeUpp, 'UTC', 1), NULL);
    DECLARE vDateTimeNSUpp VARCHAR(255) DEFAULT IF(sep_loc != 0 AND SUBSTRING_INDEX(vDateTimeUpp, 'UTC', -1)!='',SUBSTRING_INDEX(vDateTimeUpp, 'UTC', -1),NULL);
    
	
	RETURN constructDateTimeWhereClauseForColumn("subdata.value", "subdata.value_ns", vDateTimeSecLow, vDateTimeNSLow, vDateTimeSecUpp, vDateTimeNSUpp, operator);
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `getDateWhereClause` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `getDateWhereClause`(vDateTimeDotNotation VARCHAR(255), operator CHAR(4)) RETURNS varchar(20000) CHARSET utf8 COLLATE utf8_unicode_ci
    DETERMINISTIC
BEGIN
	DECLARE isInterval INTEGER DEFAULT LOCATE('--',vDateTimeDotNotation);
	DECLARE vILB VARCHAR(255) DEFAULT IF(isInterval != 0, SUBSTRING_INDEX(vDateTimeDotNotation, '--', 1), vDateTimeDotNotation);
	DECLARE vEUB VARCHAR(255) DEFAULT IF(isInterval != 0, SUBSTRING_INDEX(vDateTimeDotNotation, '--', -1), NULL);
	DECLARE vILB_Date INTEGER DEFAULT SUBSTRING_INDEX(vILB, '.', 1);
	DECLARE vEUB_Date INTEGER DEFAULT SUBSTRING_INDEX(vEUB, '.', 1);
    DECLARE hasTime INTEGER DEFAULT LOCATE('.NULL.NULL',vILB);
    DECLARE dom INTEGER DEFAULT vILB_Date % 100;
    DECLARE mon INTEGER DEFAULT ((vILB_Date % 10000) - dom) / 100;    
    DECLARE yea INTEGER DEFAULT (vILB_Date - (vILB_Date%10000)) / 10000;
    SELECT vILB_Date != vEUB_Date INTO isInterval;

    IF operator = '=' and hasTime != 0 THEN
        RETURN CONCAT(" subdata.value=", vILB_Date);
    ELSEIF operator = "!=" and hasTime != 0 THEN
        IF mon != 0  and dom != 0 THEN
            RETURN CONCAT(" subdata.value!=", vILB_Date, " and subdata.value%100!=0"); 
        ELSEIF mon != 0 THEN
            RETURN CONCAT(" subdata.value!=", vILB_Date, " and subdata.value%100=0 and subdata.value%10000!=0");
        ELSE
            RETURN CONCAT(" subdata.value!=", vILB_Date, " and subdata.value%10000=0");
        END IF;
    ELSEIF operator = "(" and hasTime != 0 THEN
        IF mon != 0 and dom != 0 THEN
            RETURN CONCAT(" subdata.value=", vILB_Date);
        ELSEIF mon != 0 THEN
            RETURN CONCAT(" subdata.value=",vILB_Date," OR (subdata.value>", vILB_Date, " and subdata.value<", vEUB_Date, " and subdata.value%10000!=0)");
        ELSE
            RETURN CONCAT(" subdata.value=",vILB_Date," OR (subdata.value>", vILB_Date, " and subdata.value<", vEUB_Date,")");
        END IF;
    ELSEIF operator = "!(" THEN
        IF hasTime = 0 THEN
            RETURN " 0=0";
        END IF;
        IF mon != 0 and dom != 0 THEN
            RETURN CONCAT(" subdata.value!=",vILB_Date);
        ELSEIF mon != 0 THEN
            RETURN CONCAT(" (subdata.value!=",vILB_Date, " AND subdata.value%100=0) OR ((subdata.value<", vILB_Date, " or subdata.value>", vEUB_Date, ") and subdata.value%100!=0)");
        ELSE
            RETURN CONCAT(" (subdata.value!=",vILB_Date, " AND subdata.value%10000=0) OR ((subdata.value<", vILB_Date, " or subdata.value>=", vEUB_Date, ") and subdata.value%10000!=0)");
        END IF;
    ELSEIF operator = "<" THEN
        IF mon != 0 and dom != 0 THEN
            RETURN CONCAT(" subdata.value<", vILB_Date, " and (subdata.value%100!=0 or (subdata.value<", yea*10000+mon*100, " and subdata.value%10000!=0) or (subdata.value<", yea*10000, " and subdata.value%10000=0))");
        ELSEIF mon != 0 THEN
            RETURN CONCAT(" subdata.value<", vILB_Date, " and (subdata.value%10000!=0 or (subdata.value<", yea*10000, "))");
        ELSE
            RETURN CONCAT(" subdata.value<", vILB_Date);
        END IF;
    ELSEIF operator = ">" THEN
        IF mon != 0 and dom != 0 THEN
            RETURN CONCAT(" subdata.value>", vILB_Date);
        ELSEIF mon != 0 THEN
            RETURN CONCAT(" subdata.value>=",vEUB_Date);
        ELSE
            RETURN CONCAT(" subdata.value>=",vEUB_Date);
        END IF;
    END IF;

    return ' 0=1';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `getDoubleWhereClause` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `getDoubleWhereClause`(value DOUBLE, unit_sig BIGINT, valueStdUnit DECIMAL(65,30), stdUnit_sig BIGINT, o CHAR(4)) RETURNS varchar(20000) CHARSET utf8 COLLATE utf8_unicode_ci
    DETERMINISTIC
BEGIN
    RETURN IF(unit_sig IS NULL AND value IS NOT NULL, 
        CONCAT('subdata.value ', o, ' \'', value, '\''), 
        CONCAT(
            IF(value IS NULL, '', 
                CONCAT('(subdata.unit_sig=', unit_sig, ' AND subdata.value ', o, ' \'', value, '\') OR ')), 
        	IF(unit_sig = stdUnit_sig,'',CONCAT('(subdata.unit_sig=', stdUnit_sig,' AND subdata.value ', o, ' \'', valueStdUnit, '\') OR ')),'(standard_unit(subdata.unit_sig)=', stdUnit_sig,' AND convert_unit(subdata.unit_sig,subdata.value) ', o, ' ', valueStdUnit, ')')); 
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `makeStmt` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `makeStmt`(sourceSet VARCHAR(255), targetSet VARCHAR(255), data VARCHAR(20000), properties VARCHAR(20000)) RETURNS varchar(20000) CHARSET utf8 COLLATE utf8_unicode_ci
    NO SQL
BEGIN		

        RETURN CONCAT(
            IF(targetSet IS NULL,
                CONCAT('DELETE FROM `',sourceSet,'` WHERE NOT EXISTS (SELECT 1 FROM '), 
                CONCAT('INSERT IGNORE INTO `',targetSet,'` (id) SELECT id FROM `',sourceSet,'` WHERE EXISTS (SELECT 1 FROM ')),
            IF(properties IS NULL,
                CONCAT(data,' as data WHERE '),
                CONCAT('`',properties,'` as prop JOIN ',data,' as data ON (data.property_id=prop.id) WHERE (data.entity_id=prop.id2 OR prop.id2=0) AND ')),
            'data.entity_id=`', sourceSet, '`.`id` LIMIT 1)'
        );

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `standard_unit` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` FUNCTION `standard_unit`(unit_sig BIGINT) RETURNS bigint(20)
    DETERMINISTIC
BEGIN
    DECLARE ret BIGINT DEFAULT unit_sig;

    SELECT signature_to INTO ret FROM units_lin_con WHERE signature_from=unit_sig;
    RETURN ret;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `applyBackReference` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `applyBackReference`(in sourceSet VARCHAR(255), targetSet VARCHAR(255), in propertiesTable VARCHAR(255), in entitiesTable VARCHAR(255), in subQuery BOOLEAN)
BEGIN
	DECLARE newTableName VARCHAR(255) DEFAULT NULL;


	IF subQuery IS TRUE THEN
		call registerTempTableName(newTableName);

		SET @createBackRefSubQueryTableStr = CONCAT('CREATE TEMPORARY TABLE `',newTableName,'` ( entity_id INT UNSIGNED NOT NULL, id INT UNSIGNED NOT NULL, CONSTRAINT `',newTableName,'PK` PRIMARY KEY (id, entity_id))');

		PREPARE createBackRefSubQueryTable FROM @createBackRefSubQueryTableStr;
		EXECUTE createBackRefSubQueryTable;
		DEALLOCATE PREPARE createBackRefSubQueryTable;

		SET @backRefSubResultSetStmtStr = CONCAT('INSERT IGNORE INTO `',newTableName,'` (id,entity_id) SELECT entity_id AS id, value AS entity_id FROM `reference_data` AS data WHERE EXISTS (SELECT 1 FROM `',sourceSet,'` AS source WHERE source.id=data.value LIMIT 1)', IF(propertiesTable IS NULL,'',CONCAT(' AND EXISTS (SELECT 1 FROM `',propertiesTable,'` AS p WHERE p.id=data.property_id LIMIT 1)')), IF(entitiesTable IS NULL,'',CONCAT(' AND EXISTS (SELECT 1 FROM `',entitiesTable,'` AS e WHERE e.id=data.entity_id LIMIT 1)')));

		PREPARE backRefSubResultSetStmt FROM @backRefSubResultSetStmtStr;
		EXECUTE backRefSubResultSetStmt;
		DEALLOCATE PREPARE backRefSubResultSetStmt;

		SELECT newTableName as list;	
	ELSE 
	    IF targetSet IS NULL OR sourceSet = targetSet THEN
        	SET @stmtBackRefStr = CONCAT('DELETE FROM `', sourceSet, '` WHERE NOT EXISTS (SELECT 1 FROM `reference_data` AS data WHERE data.value=`', sourceSet, '`.`id`', IF(entitiesTable IS NULL, '', CONCAT(' AND EXISTS (SELECT 1 FROM `', entitiesTable, '` AS e WHERE e.id=data.entity_id LIMIT 1)')), IF(propertiesTable IS NULL, '', CONCAT(' AND EXISTS (SELECT 1 FROM `', propertiesTable, '` AS p WHERE p.id=data.property_id LIMIT 1)')), ')');
    	ELSE
        	SET @stmtBackRefStr = CONCAT('INSERT IGNORE INTO `', targetSet, '` (id) SELECT id FROM `',sourceSet,'` AS source WHERE EXISTS (SELECT 1 FROM `reference_data` AS data WHERE data.value=source.id', IF(entitiesTable IS NULL, '', CONCAT(' AND EXISTS (SELECT 1 FROM `', entitiesTable, '` AS e WHERE e.id=data.entity_id LIMIT 1)')), IF(propertiesTable IS NULL, '', CONCAT(' AND EXISTS (SELECT 1 FROM `', propertiesTable, '` AS p WHERE p.id=data.property_id LIMIT 1)')), ')');
    	END IF;
    
    	PREPARE stmtBackRef FROM @stmtBackRefStr;
    	EXECUTE stmtBackRef;
    	DEALLOCATE PREPARE stmtBackRef;
	END IF;
	
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `applyIDFilter` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `applyIDFilter`(in sourceSet VARCHAR(255), in targetSet VARCHAR(255), in o CHAR(2), in vInt BIGINT, in agg CHAR(3))
IDFILTER_LABEL: BEGIN
DECLARE data VARCHAR(20000) DEFAULT NULL;
DECLARE aggVal VARCHAR(255) DEFAULT NULL;


IF agg IS NOT NULL THEN
	SET @stmtIDAggValStr = CONCAT("SELECT ", agg, "(id) INTO @sAggVal FROM `", sourceSet, "`");
	PREPARE stmtIDAggVal FROM @stmtIDAggValStr;
	EXECUTE stmtIDAggVal;
    DEALLOCATE PREPARE stmtIDAggVal;
    SET aggVal = @sAggVal;
END IF;


IF targetSet IS NULL OR targetSet = sourceSet THEN
    SET data = CONCAT("DELETE FROM `",sourceSet,"` WHERE ",IF(o IS NULL OR vInt IS NULL,"1=1",CONCAT("NOT id",o,vInt)),IF(aggVal IS NULL, "", CONCAT(" AND id!=",aggVal)));
ELSE
    SET data = CONCAT("INSERT IGNORE INTO `",targetSet,"` SELECT data.id as id FROM `",sourceSet,"` AS data WHERE ",IF(o IS NULL OR vInt IS NULL,"1=1",CONCAT("data.id",o,vInt)),IF(aggVal IS NULL, "", CONCAT(" AND data.id=", aggVal)));
END IF;

Set @stmtIDFilterStr = data;
PREPARE stmtIDFilter FROM @stmtIDFilterStr;
EXECUTE stmtIDFilter;
DEALLOCATE PREPARE stmtIDFilter;
	
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `applyPOV` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `applyPOV`(in sourceSet VARCHAR(255), 
                                 in targetSet VARCHAR(255), 
                                 in propertiesTable VARCHAR(255),
                                 in refIdsTable VARCHAR(255),
                                 in o CHAR(4), 
                                 in vText VARCHAR(255),  
                                 in vInt INT,  
                                 in vDouble DOUBLE,  
                                 in unit_sig BIGINT,
                                 in vDoubleStdUnit DOUBLE,
                                 in stdUnit_sig BIGINT,
                                 in vDateTime VARCHAR(255),
                                 in vDateTimeDotNotation VARCHAR(255),
                                 in agg CHAR(3), 
                                 in pname VARCHAR(255))
POV_LABEL: BEGIN
    DECLARE data TEXT DEFAULT NULL; 
    DECLARE sTextData VARCHAR(20000) DEFAULT NULL; 
    DECLARE sEnumData VARCHAR(20000) DEFAULT NULL; 
    DECLARE sIntData VARCHAR(20000) DEFAULT NULL; 
    DECLARE sDoubleData VARCHAR(20000) DEFAULT NULL; 
    DECLARE sDatetimeData VARCHAR(20000) DEFAULT NULL; 
    DECLARE sNullData VARCHAR(20000) DEFAULT NULL; 
    DECLARE sDateData VARCHAR(20000) DEFAULT NULL; 
    DECLARE sRefData VARCHAR(20000) DEFAULT NULL; 
    DECLARE aggValue VARCHAR(255) DEFAULT NULL;
    DECLARE aggValueWhereClause VARCHAR(20000) DEFAULT NULL;
    DECLARE distinctUnits INT DEFAULT 0;
    DECLARE usedStdUnit BIGINT DEFAULT NULL;
    DECLARE keepTabl VARCHAR(255) DEFAULT NULL;

    IF o = '->' THEN
        
        call applyRefPOV(sourceSet,targetSet, propertiesTable, refIdsTable);
        LEAVE POV_LABEL;
    ELSEIF o = '0' THEN
        
        
        SET vText = NULL;
        SET sTextData = 'SELECT domain_id, entity_id, property_id FROM `null_data` AS subdata';

        

    ELSEIF o = '!0' THEN
        
        
        SET vText = NULL;
        
        SET sTextData = 'SELECT DISTINCT domain_id, entity_id, property_id FROM `text_data` AS subdata WHERE subdata.value IS NOT NULL UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `enum_data` AS subdata WHERE subdata.value IS NOT NULL UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `integer_data` AS subdata WHERE subdata.value IS NOT NULL UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `double_data` AS subdata WHERE subdata.value IS NOT NULL UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `date_data` AS subdata WHERE subdata.value IS NOT NULL UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `datetime_data` AS subdata WHERE subdata.value IS NOT NULL UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `reference_data` AS subdata WHERE subdata.value IS NOT NULL';

    ELSEIF o = "(" or o = "!(" THEN
        SET sTextData = IF(vText IS NULL, ' SELECT DISTINCT domain_id, entity_id, property_id FROM `date_data`',
                                          IF(vDateTimeDotNotation IS NULL, NULL,
                                                                           CONCAT(' SELECT DISTINCT domain_id, entity_id, property_id FROM `date_data` AS subdata WHERE ', getDateWhereClause(vDateTimeDotNotation, o))));
        SET sDatetimeData = IF(vText IS NULL, ' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `datetime_data`',
                                              IF(vDateTime IS NULL, NULL,
                                                                    CONCAT(' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `datetime_data` AS subdata WHERE ', getDateTimeWhereClause(vDateTime, o))));
        SET vText = NULL;
    ELSEIF agg IS NOT NULL THEN
        

        
        SET aggValueWhereClause = CONCAT(getDoubleWhereClause(vDouble, unit_sig, vDoubleStdUnit, stdUnit_sig, o), ' AND ');
        SET aggValueWhereClause = CONCAT(IF(aggValueWhereClause IS NULL, '', aggValueWhereClause), getAggValueWhereClause(sourceSet, propertiesTable));

        
        SET @aggValueStmtStr = CONCAT('SELECT ',agg,'(subdata.value), ', agg, '(convert_unit(subdata.unit_sig,subdata.value)), COUNT(DISTINCT standard_unit(subdata.unit_sig)), max(standard_unit(subdata.unit_sig)) INTO @sAggValue, @sAggValueConvert, @distinctUnits, @StdUnitSig FROM (SELECT entity_id, property_id, value, unit_sig FROM `integer_data` UNION SELECT entity_id, property_id, value, unit_sig FROM `double_data`) AS subdata WHERE ', aggValueWhereClause);

        
        PREPARE stmtAggValueStmt FROM @aggValueStmtStr;
        EXECUTE stmtAggValueStmt;
        DEALLOCATE PREPARE stmtAggValueStmt;

        SET distinctUnits = @distinctUnits;
        SET aggValue = @sAggValue;

        
        IF distinctUnits = 1 THEN
            SET aggValue = @sAggValueConvert;
            SET usedStdUnit = @StdUnitSig;
        ELSE
            call raiseWarning(CONCAT("The filter POV(",IF(pname IS NULL, 'NULL', pname),",",IF(o IS NULL, 'NULL', o),",",IF(vText IS NULL, 'NULL', vText),") with the aggregate function '", agg, "' could not match the values against each other with their units. The values had different base units. Only their numric value had been taken into account." ));
        END IF;

        IF aggValue IS NULL THEN
            SET sTextData = 'SELECT NULL as domain_id, NULL as entity_id, NULL as property_id';
        ELSE
            SET sTextData = '';
            SET sIntData = CONCAT(' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `integer_data` as subdata WHERE ', getDoubleWhereClause(aggValue, usedStdUnit, aggValue, usedStdUnit, '='));
            SET sDoubleData = CONCAT(' SELECT DISTINCT domain_id, entity_id, property_id FROM `double_data` as subdata WHERE ', getDoubleWhereClause(aggValue, usedStdUnit, aggValue, usedStdUnit, '='));
        END IF;

        SET vText = NULL;
    ELSE
        
        SET sTextData = IF(vText IS NULL, 'SELECT DISTINCT domain_id, entity_id, property_id FROM `text_data`', CONCAT('SELECT DISTINCT domain_id, entity_id, property_id FROM `text_data` AS subdata WHERE subdata.value ',o,' ?'));
        SET sEnumData = IF(vText IS NULL, ' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `enum_data`', CONCAT(' UNION SELECT DISTINCT domain_id, entity_id, property_id FROM `enum_data` AS subdata WHERE subdata.value ', o, ' ?'));
        SET sIntData = IF(vText IS NULL, ' UNION ALL SELECT DISTINCT subdata.domain_id, subdata.entity_id, subdata.property_id FROM `integer_data` AS subdata', IF(vInt IS NULL AND vDoubleStdUnit IS NULL, NULL, CONCAT(' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `integer_data` AS subdata WHERE ', getDoubleWhereClause(vInt, unit_sig, vDoubleStdUnit, stdUnit_sig, o))));
        SET sDoubleData = IF(vText IS NULL, ' UNION ALL SELECT DISTINCT subdata.domain_id, subdata.entity_id, subdata.property_id FROM `double_data` AS subdata', IF(vDouble IS NULL, NULL, CONCAT(' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `double_data` AS subdata WHERE ', getDoubleWhereClause(vDouble,unit_sig,vDoubleStdUnit,stdUnit_sig,o))));
        SET sDatetimeData = IF(vText IS NULL,' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `datetime_data`', IF(vDateTime IS NULL, NULL, CONCAT(' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `datetime_data` AS subdata WHERE ',getDateTimeWhereClause(vDateTime,o))));
        SET sDateData = IF(vText IS NULL,' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `date_data`', IF(vDateTimeDotNotation IS NULL, NULL, CONCAT(' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `date_data` AS subdata WHERE ',getDateWhereClause(vDateTimeDotNotation,o))));
        SET sRefData = IF(vText IS NULL, ' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `reference_data`', IF(refIdsTable IS NULL, NULL, CONCAT(' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `reference_data` AS subdata WHERE EXISTS (SELECT 1 FROM `', refIdsTable, '` AS refIdsTable WHERE subdata.value=refIdsTable.id LIMIT 1)')));
        SET sNullData = IF(vText IS NULL, ' UNION ALL SELECT DISTINCT domain_id, entity_id, property_id FROM `null_data`', NULL);

    END IF;

    SET data = CONCAT('(',sTextData,
                IF(sEnumData IS NULL, '', sEnumData),
                IF(sDoubleData IS NULL, '', sDoubleData),
                IF(sIntData IS NULL, '', sIntData),
                IF(sDatetimeData IS NULL, '', sDatetimeData),
                IF(sDateData IS NULL, '', sDateData),
                IF(sRefData IS NULL, '', sRefData),
                IF(sNullData IS NULL, '', sNullData),
                ')'
            );


    call createTmpTable(keepTabl);

    
    SET @stmtPOVkeepTblStr = CONCAT("INSERT IGNORE INTO `", keepTabl, "` (id) SELECT DISTINCT entity_id AS id FROM ", data, " as data", IF(propertiesTable IS NULL, '', CONCAT(' WHERE EXISTS (Select 1 from `', propertiesTable, '` AS prop WHERE prop.id = data.property_id AND (prop.id2=data.entity_id OR prop.id2=0))')));

    SET @stmtPOVStr = CONCAT(
            IF(targetSet IS NULL,
                CONCAT('DELETE FROM `',sourceSet,'` WHERE NOT EXISTS (SELECT 1 FROM `'),
                CONCAT('INSERT IGNORE INTO `',targetSet,'` (id) SELECT id FROM `',sourceSet,'` WHERE EXISTS (SELECT 1 FROM `')),
            keepTabl,
            '` AS data WHERE data.id=`', sourceSet, '`.`id` LIMIT 1)'
        );


    
    PREPARE stmt3 FROM @stmtPOVStr;
    PREPARE stmtPOVkeepTbl FROM @stmtPOVkeepTblStr;
    IF vText IS NULL THEN
        EXECUTE stmtPOVkeepTbl;
    ELSE
        SET @vText = vText;
        EXECUTE stmtPOVkeepTbl USING @vText, @vText;
    END IF;
    EXECUTE stmt3;
    DEALLOCATE PREPARE stmt3;
    DEALLOCATE PREPARE stmtPOVkeepTbl;

    

    SELECT @stmtPOVkeepTblStr as applyPOVStmt1, @stmtPOVStr as applyPOVStmt2, keepTabl as applyPOVIntermediateResultSet;


END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `applyRefPOV` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `applyRefPOV`(in sourceSet VARCHAR(255), in targetSet VARCHAR(255), in properties VARCHAR(255), in refs VARCHAR(255))
BEGIN
    DECLARE data VARCHAR(20000) DEFAULT CONCAT('(SELECT domain_id, entity_id, property_id FROM `reference_data` AS subdata WHERE EXISTS (SELECT 1 FROM `', refs, '` AS refs WHERE subdata.value=refs.id LIMIT 1))');
    SET @stmtRefPOVStr = makeStmt(sourceSet,targetSet,data,properties);

    PREPARE stmt4 FROM @stmtRefPOVStr;
    EXECUTE stmt4;
		
    SELECT @stmtRefPOVstr as applyRefPOVStmt;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `applySAT` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `applySAT`(in sourceSet VARCHAR(255), in targetSet VARCHAR(255), in loc MEDIUMTEXT, in op CHAR(5))
BEGIN

    IF targetSet IS NULL OR sourceSet = targetSet THEN
        SET @stmtSATString = CONCAT('DELETE FROM `', sourceSet, '` WHERE id NOT IN (SELECT file_id FROM files WHERE path ', op, ' ?)');  
    ELSE
        SET @stmtSATString = CONCAT('INSERT INTO `', targetSet, '` (id) SELECT data.id FROM `',sourceSet,'` as data WHERE EXISTS (SELECT 1 FROM `files` as f WHERE f.file_id=data.id AND f.path ', op, ' ?)');
    END IF;
    PREPARE stmtSAT FROM @stmtSATString;
	SET @loc = loc;
    EXECUTE stmtSAT USING @loc;
    DEALLOCATE PREPARE stmtSAT;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `applyTransactionFilter` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `applyTransactionFilter`(in sourceSet VARCHAR(255), targetSet VARCHAR(255), in transaction VARCHAR(255), in operator_u CHAR(2), in realm VARCHAR(255), in userName VARCHAR(255), in ilb BIGINT, in ilb_nanos INT UNSIGNED, in eub BIGINT, in eub_nanos INT UNSIGNED, in operator_t CHAR(2))
BEGIN
	DECLARE data TEXT default CONCAT('(SELECT entity_id FROM transaction_log AS t WHERE t.transaction=\'', 
		transaction, 
		'\'',
		IF(userName IS NOT NULL, 
			CONCAT(' AND t.realm', operator_u, '? AND t.username', operator_u, '?'),
			'' 
		),
		IF(ilb IS NOT NULL, 
			CONCAT(" AND", constructDateTimeWhereClauseForColumn("t.seconds", "t.nanos", ilb, ilb_nanos, eub, eub_nanos, operator_t)),
			""
		),
		')'
	);

	SET @stmtTransactionStr = makeStmt(sourceSet,targetSet,data,NULL);
	PREPARE stmtTransactionFilter from @stmtTransactionStr;
	IF userName IS NOT NULL THEN
		SET @userName = userName;
		SET @realm = realm;
		EXECUTE stmtTransactionFilter USING @realm, @userName;
	ELSE
		EXECUTE stmtTransactionFilter;
	END IF;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `calcComplementUnion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `calcComplementUnion`(in targetSet VARCHAR(255), in subResultSet VARCHAR(255), in universe VARCHAR(255))
BEGIN
    SET @stmtComplementUnionStr = CONCAT('INSERT IGNORE INTO `', targetSet, '` SELECT id FROM `',universe, '` AS universe WHERE NOT EXISTS ( SELECT 1 FROM `', subResultSet,'` AS diff WHERE diff.id=universe.id)');
    PREPARE stmtComplementUnion FROM @stmtComplementUnionStr;
    EXECUTE stmtComplementUnion;
    DEALLOCATE PREPARE stmtComplementUnion;
    
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `calcDifference` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `calcDifference`(in resultSetTable VARCHAR(255), in diff VARCHAR(255))
BEGIN
    SET @diffStmtStr = CONCAT('DELETE FROM `', resultSetTable, '` WHERE EXISTS ( SELECT 1 FROM `', diff,'` AS diff WHERE diff.id=`',resultSetTable,'`.`id`)');
    PREPARE diffStmt FROM @diffStmtStr;
    EXECUTE diffStmt;
    DEALLOCATE PREPARE diffStmt;
    
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `calcIntersection` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `calcIntersection`(in resultSetTable VARCHAR(255), in intersectWith VARCHAR(255))
BEGIN
    SET @diffStmtStr = CONCAT('DELETE FROM `', resultSetTable, '` WHERE NOT EXISTS ( SELECT 1 FROM `', intersectWith,'` AS diff WHERE diff.id=`',resultSetTable,'`.`id`)');
    PREPARE diffStmt FROM @diffStmtStr;
    EXECUTE diffStmt;

    
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `calcUnion` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `calcUnion`(in targetSet VARCHAR(255), in sourceSet VARCHAR(255))
BEGIN
    SET @diffStmtStr = CONCAT('INSERT IGNORE INTO `', targetSet, '` (id) SELECT id FROM `',sourceSet,'`');
    PREPARE diffStmt FROM @diffStmtStr;
    EXECUTE diffStmt;
    DEALLOCATE PREPARE diffStmt;
    
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `cleanUpLinCon` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `cleanUpLinCon`()
BEGIN

    DELETE FROM units_lin_con WHERE NOT EXISTS (SELECT '1' FROM double_data WHERE unit_sig=signature_from) AND NOT EXISTS (SELECT '1' FROM integer_data WHERE unit_sig=signature_from);

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `cleanUpQuery` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `cleanUpQuery`()
BEGIN
   SELECT * from warnings;

   SET @pstmtstr = CONCAT('DROP TEMPORARY TABLE IF EXISTS `warnings`', IF(@tempTableList IS NULL, '', CONCAT(',',@tempTableList)));
   PREPARE pstmt FROM @pstmtstr;
   EXECUTE pstmt;

   SET @tempTableList = NULL;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `copyTable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `copyTable`(in fromTable VARCHAR(255), in toTable VARCHAR(255))
BEGIN
    SET @copyTableStmtStr = CONCAT('INSERT IGNORE INTO `', toTable, '` (id) SELECT id FROM `', fromTable, '`');
    PREPARE copyTableStmt FROM @copyTableStmtStr;
    EXECUTE copyTableStmt;
    DEALLOCATE PREPARE copyTableStmt;
    
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `createTmpTable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `createTmpTable`(out newTableName VARCHAR(255))
BEGIN
    call registerTempTableName(newTableName);
    
    SET @createTableStmtStr = CONCAT('CREATE TEMPORARY TABLE `', newTableName,'` ( id INT UNSIGNED PRIMARY KEY)' );
    
    PREPARE createTableStmt FROM @createTableStmtStr; 
    EXECUTE createTableStmt;
    DEALLOCATE PREPARE createTableStmt;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `createTmpTable2` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `createTmpTable2`(out newTableName VARCHAR(255))
BEGIN
    call registerTempTableName(newTableName);
	SET @createTableStmtStr = CONCAT('CREATE TEMPORARY TABLE `', newTableName,'` ( id INT UNSIGNED, id2 INT UNSIGNED, domain INT UNSIGNED, CONSTRAINT `', newTableName,'PK` PRIMARY KEY (id,id2,domain) )' );
    
    PREPARE createTableStmt FROM @createTableStmtStr; 
    EXECUTE createTableStmt;
    DEALLOCATE PREPARE createTableStmt;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `deleteEntity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `deleteEntity`(in EntityID INT UNSIGNED)
BEGIN


	DELETE FROM files where file_id=EntityID;
	DELETE FROM data_type WHERE domain_id=0 and (entity_id=0 and property_id=EntityID) or entity_id=EntityID; 
	DELETE FROM collection_type WHERE domain_id=0 and (entity_id=0 and property_id=EntityID) or entity_id=EntityID; 
	DELETE FROM entities where id=EntityID;
	DELETE FROM entity_acl WHERE NOT EXISTS (SELECT 1 FROM entities WHERE entities.acl = entity_acl.id LIMIT 1);

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `deleteEntityProperties` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `deleteEntityProperties`(in EntityID INT UNSIGNED)
BEGIN

CALL deleteIsa(EntityID);

DELETE FROM reference_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM null_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM text_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM name_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM enum_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM integer_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM double_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM datetime_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM date_data 
where (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM name_overrides
WHERE (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM desc_overrides
WHERE (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID;
DELETE FROM data_type 
WHERE (domain_id=0 AND entity_id=EntityID) OR domain_id=EntityID OR (domain_id=0 AND entity_id=0 AND property_id=EntityID);

DELETE FROM query_template_def WHERE id=EntityID;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `deleteIsa` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `deleteIsa`(IN EntityID INT UNSIGNED)
BEGIN
	
	DELETE FROM isa_cache WHERE child=EntityID or rpath=EntityID or rpath LIKE concat('%>',EntityID) or rpath LIKE concat('%>', EntityID, '>%');

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `deleteLinCon` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `deleteLinCon`(in sig BIGINT)
BEGIN

    DELETE FROM units_lin_con WHERE signature_from=sig;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `entityACL` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `entityACL`(out ACLID INT UNSIGNED, in ACLSTR VARBINARY(65525))
BEGIN
   SELECT id INTO ACLID FROM entity_acl as t WHERE t.acl=ACLSTR LIMIT 1;
   IF ACLID IS NULL THEN
		INSERT INTO entity_acl (acl) VALUES (ACLSTR);
		SET ACLID = LAST_INSERT_ID();
   END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `finishNegationFilter` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `finishNegationFilter`(in sourceSet VARCHAR(255), in targetSet VARCHAR(255), in subResultSet VARCHAR(255))
BEGIN
    IF targetSet IS NULL OR sourceSet = targetSet THEN
        call calcDifference(sourceSet, subResultSet);
    ELSE
        call calcComplementUnion(targetSet,subResultSet,sourceSet);
    END IF;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `finishSubProperty` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `finishSubProperty`(in sourceSet VARCHAR(255),in targetSet VARCHAR(255), in list VARCHAR(255))
BEGIN
    DECLARE data VARCHAR(20000) DEFAULT CONCAT('`',list,'`');
    SET @finishSubPropertyStmtStr = makeStmt(sourceSet, targetSet, data, NULL);

	PREPARE finishSubPropertyStmt FROM @finishSubPropertyStmtStr;
	EXECUTE finishSubPropertyStmt;
    DEALLOCATE PREPARE finishSubPropertyStmt;
        
    SELECT @finishSubPropertyStmtStr AS finishSubPropertyStmt;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getChildren` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `getChildren`(in tableName varchar(255))
BEGIN

    CREATE TEMPORARY TABLE dependTemp (id INT UNSIGNED PRIMARY KEY);



    SET @initDepend = CONCAT('INSERT IGNORE INTO dependTemp (id) SELECT i.child FROM isa_cache AS i INNER JOIN `', tableName, '` AS t ON (i.parent=t.id);');
    PREPARE initDependStmt FROM @initDepend;

	EXECUTE initDependStmt;
	IF ROW_COUNT() != 0 THEN
    	SET @transfer = CONCAT('INSERT IGNORE INTO `', tableName, '` (id) SELECT id FROM dependTemp');
        PREPARE transferstmt FROM @transfer;
		EXECUTE transferstmt;
		DEALLOCATE PREPARE transferstmt;
	END IF;


	DEALLOCATE PREPARE initDependStmt;
	DROP TEMPORARY TABLE dependTemp;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getDependentEntities` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `getDependentEntities`(in EntityID INT UNSIGNED)
BEGIN

DROP TEMPORARY TABLE IF EXISTS refering;		
CREATE TEMPORARY TABLE refering (
id INT UNSIGNED UNIQUE
);

INSERT IGNORE INTO refering (id) SELECT entity_id FROM reference_data WHERE (value=EntityID OR property_id=EntityID) AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM reference_data WHERE (value=EntityID OR property_id=EntityID) AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM text_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM text_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM enum_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM enum_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM name_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM name_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM integer_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM integer_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM double_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM double_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM datetime_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM datetime_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM date_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM date_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id FROM null_data WHERE property_id=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id FROM null_data WHERE property_id=EntityID AND domain_id!=EntityID AND entity_id!=EntityID AND domain_id!=0; 

INSERT IGNORE INTO refering (id) SELECT entity_id from data_type WHERE datatype=EntityID AND domain_id=0 AND entity_id!=EntityID;
INSERT IGNORE INTO refering (id) SELECT domain_id from data_type WHERE datatype=EntityID;


Select id from refering WHERE id!=0 and id!=EntityID;

DROP TEMPORARY TABLE refering;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getFile` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `getFile`(in FileID INT)
BEGIN 

Select name, description, role into @name, @description, @role from entities where id=FileID LIMIT 1;

IF @role = 'file' Then
		Select path, hash, size into @FilePath, @FileHash, @FileSize from files where file_id=FileID LIMIT 1;
		Select timestamp, user_id, user_agent into @FileCreated, @FileCreator, @FileGenerator from history where entity_id=FileID AND event='insertion' LIMIT 1;

Select 
FileID as FileID,
@FilePath as FilePath,
@FileSize as FileSize,
@FileHash as FileHash,
@FileDescription as FileDescription,
@FileCreated as FileCreated,
@FileCreator as FileCreator,
@FileGenerator as FileGenerator,
NULL	as FileOwner,
NULL as FilePermission,
NULL as FileChecksum;

END IF;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getFileIdByPath` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `getFileIdByPath`(in FilePath VARCHAR(255))
BEGIN 

Select file_id as FileID from files where path=FilePath LIMIT 1;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getRole` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `getRole`(in RoleName VARCHAR(255))
BEGIN

Select e.id INTO @RoleID from entities e where e.name=RoleName AND e.role=RoleName LIMIT 1;

call retrieveEntity(@RoleID);




END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `getRules` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `getRules`(in DomainID INT UNSIGNED, in EntityID INT UNSIGNED, in TransType VARCHAR(255))
BEGIN

		
		
		
SELECT rules.transaction, rules.criterion, rules.modus from rules where if(DomainID is null, rules.domain_id=0,rules.domain_id=DomainID) AND if(EntityID is null, rules.entity_id=0,rules.entity_id=EntityID) AND if(TransType is null,true=true,rules.transaction=TransType);




END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initAutoIncrement` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initAutoIncrement`()
BEGIN

    SELECT @max := MAX(entity_id)+ 1 FROM transaction_log; 
    IF @max IS NOT NULL THEN
        SET @stmtStr = CONCAT('ALTER TABLE entities AUTO_INCREMENT=',@max);
        PREPARE stmt FROM @stmtStr;
        EXECUTE stmt;
        DEALLOCATE PREPARE stmt;
    END IF;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initBackReference` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initBackReference`(in pid INT UNSIGNED, in pname VARCHAR(255), in entity_id INT UNSIGNED, in ename VARCHAR(255))
BEGIN
	DECLARE propertiesTable VARCHAR(255) DEFAULT NULL;
	DECLARE entitiesTable VARCHAR(255) DEFAULT NULL;

    IF pname IS NOT NULL THEN
        call createTmpTable(propertiesTable);
        call initSubEntity(pid, pname, propertiesTable);
    END IF;

    IF ename IS NOT NULL THEN
        call createTmpTable(entitiesTable);
        call initSubEntity(entity_id, ename, entitiesTable);
    END IF;

	SELECT propertiesTable, entitiesTable;


END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initConjunctionFilter` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initConjunctionFilter`(in sourceSet VARCHAR(255))
BEGIN
    DECLARE newTableName VARCHAR(255) DEFAULT NULL;
    call createTmpTable(newTableName);
    call copyTable(sourceSet, newTableName);
    SELECT newTableName AS newTableName;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initDisjunctionFilter` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initDisjunctionFilter`()
BEGIN
    call initEmptyTargetSet(NULL);
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initEmptyTargetSet` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initEmptyTargetSet`(in targetSet VARCHAR(255))
BEGIN
    DECLARE newTableName VARCHAR(255) DEFAULT targetSet;
    IF targetSet IS NOT NULL THEN
        SET @isNotEmptyVar = NULL; 
        SET @isEmptyStmtStr = CONCAT("SELECT 1 INTO @isNotEmptyVar FROM `",targetSet,"` LIMIT 1");
        PREPARE stmtIsNotEmpty FROM @isEmptyStmtStr;
        EXECUTE stmtIsNotEmpty;
        DEALLOCATE PREPARE stmtIsNotEmpty;
        IF @isNotEmptyVar IS NOT NULL THEN 
            call createTmpTable(newTableName);
        END IF;
    ELSE
        call createTmpTable(newTableName);
    END IF;
    SELECT newTableName AS newTableName;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initEntity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initEntity`(in eid INT UNSIGNED, in ename VARCHAR(255), in enameLike VARCHAR(255), in enameRegexp VARCHAR(255), in resultset VARCHAR(255))
initEntityLabel: BEGIN
	SET @initEntityStmtStr = NULL;

	IF ename IS NOT NULL THEN
		SET @initEntityStmtStr = CONCAT('INSERT IGNORE INTO `',resultset,'` (id) SELECT id FROM entities WHERE name=? and id>=100 UNION ALL SELECT entity_id FROM name_data WHERE value=?;');
		SET @query_param = ename;
	ELSEIF enameLike IS NOT NULL THEN
		SET @initEntityStmtStr = CONCAT('INSERT IGNORE INTO `',resultset,'` (id) SELECT id FROM entities WHERE name LIKE ? and id>=100 UNION ALL SELECT entity_id FROM name_data WHERE value LIKE ?;');
		SET @query_param = enameLike;
	ELSEIF enameRegexp IS NOT NULL THEN 
		SET @initEntityStmtStr = CONCAT('INSERT IGNORE INTO `',resultset,'` (id) SELECT id FROM entities WHERE name REGEXP ? and id>=100 UNION ALL SELECT entity_id FROM name_data WHERE value REGEXP ?;');
		SET @query_param = enameRegexp;
    END IF;

	IF @initEntityStmtStr IS NOT NULL THEN
		PREPARE initEntityStmt FROM @initEntityStmtStr;
		EXECUTE initEntityStmt USING @query_param, @query_param;
		DEALLOCATE PREPARE initEntityStmt;
    END IF;
	
    IF eid IS NOT NULL THEN
		SET @initEntityStmtStr = CONCAT('INSERT IGNORE INTO `',resultset,'` (id) SELECT id FROM entities WHERE id=',eid,';');
		PREPARE initEntityStmt FROM @initEntityStmtStr;
		EXECUTE initEntityStmt;
		DEALLOCATE PREPARE initEntityStmt;
    END IF;

	
	IF @initEntityStmtStr IS NOT NULL THEN
    	call getChildren(resultset);
	END IF;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initNegationFilter` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initNegationFilter`(in sourceSet VARCHAR(255))
BEGIN
    DECLARE newTableName VARCHAR(255) DEFAULT NULL;
    call createTmpTable(newTableName);
    call copyTable(sourceSet, newTableName);
    SELECT newTableName AS newTableName;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initPOVPropertiesTable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initPOVPropertiesTable`(in pid INT UNSIGNED, in pname VARCHAR(255), in sourceSet VARCHAR(255))
BEGIN
    DECLARE propertiesTable VARCHAR(255) DEFAULT NULL; 
    DECLARE replTbl VARCHAR(255) DEFAULT NULL;
   	DECLARE ecount INT DEFAULT 0;
    DECLARE t1 BIGINT DEFAULT 0;
    DECLARE t2 BIGINT DEFAULT 0;
    DECLARE t3 BIGINT DEFAULT 0;
    DECLARE t4 BIGINT DEFAULT 0;
    DECLARE t5 BIGINT DEFAULT 0;
    DECLARE t6 BIGINT DEFAULT 0;


    IF pname is NOT NULL THEN 
        SELECT conv( concat( substring(uid,16,3), substring(uid,10,4), substring(uid,1,8)),16,10) div 10000 - (141427 * 24 * 60 * 60 * 1000) as current_mills INTO t1 from (select uuid() uid) as alias;
        call createTmpTable2(propertiesTable);
        
        
        SET @initPOVPropertiesTableStmt1 = CONCAT('INSERT IGNORE INTO `', propertiesTable, '` (id, id2, domain) SELECT id, 0, 0 FROM entities WHERE name = ? UNION ALL SELECT property_id, entity_id, domain_id from name_overrides WHERE name = ? UNION ALL SELECT entity_id, domain_id, 0 FROM name_data WHERE value = ?;');
        PREPARE stmt FROM @initPOVPropertiesTableStmt1;
        SET @pname = pname;
        EXECUTE stmt USING @pname, @pname, @pname;
        SET ecount = ROW_COUNT();

        
        SELECT conv( concat( substring(uid,16,3), substring(uid,10,4), substring(uid,1,8)),16,10) div 10000 - (141427 * 24 * 60 * 60 * 1000) as current_mills INTO t2 from (select uuid() uid) as alias;
        IF pid IS NOT NULL THEN
            SET @initPOVPropertiesTableStmt2 = CONCAT('INSERT IGNORE INTO `', propertiesTable, '` (id, id2, domain) VALUES (?, 0, 0)');
            PREPARE stmt FROM @initPOVPropertiesTableStmt2;
            SET @pid = pid;
            EXECUTE stmt USING @pid;
            SET ecount = ecount + ROW_COUNT();
        END IF;

        
        SELECT conv( concat( substring(uid,16,3), substring(uid,10,4), substring(uid,1,8)),16,10) div 10000 - (141427 * 24 * 60 * 60 * 1000) as current_mills INTO t3 from (select uuid() uid) as alias;
        IF ecount > 0 THEN
            call getChildren(propertiesTable);
        END IF;
        
        
        SELECT conv( concat( substring(uid,16,3), substring(uid,10,4), substring(uid,1,8)),16,10) div 10000 - (141427 * 24 * 60 * 60 * 1000) as current_mills INTO t4 from (select uuid() uid) as alias;
        IF ecount > 0 THEN
            call createTmpTable2(replTbl);
            SET @replTblStmt1 := CONCAT('INSERT IGNORE INTO `',replTbl, '` (id, id2, domain) SELECT r.value as id, r.entity_id as id2, 0 as domain_id FROM reference_data AS r WHERE status="REPLACEMENT" AND domain_id=0 AND EXISTS (SELECT * FROM `', sourceSet, '` AS s WHERE s.id=r.entity_id) AND EXISTS (SELECT * FROM `', propertiesTable, '` AS p WHERE p.domain = 0 AND p.id2=0 AND p.id=r.property_id);');
            PREPARE replStmt1 FROM @replTblStmt1;
            EXECUTE replStmt1;
            DEALLOCATE PREPARE replStmt1;
            SELECT conv( concat( substring(uid,16,3), substring(uid,10,4), substring(uid,1,8)),16,10) div 10000 - (141427 * 24 * 60 * 60 * 1000) as current_mills INTO t5 from (select uuid() uid) as alias;

            SET @replTblStmt2 := CONCAT('INSERT IGNORE INTO `', propertiesTable, '` SELECT id, id2, domain FROM `', replTbl, '`;');
            PREPARE replStmt2 FROM @replTblStmt2;
            EXECUTE replStmt2;
            DEALLOCATE PREPARE replStmt2;
            SELECT conv( concat( substring(uid,16,3), substring(uid,10,4), substring(uid,1,8)),16,10) div 10000 - (141427 * 24 * 60 * 60 * 1000) as current_mills INTO t6 from (select uuid() uid) as alias;
        END IF;
    END IF;
    SELECT propertiesTable, t1, t2, t3, t4, t5, t6, @initPOVPropertiesTableStmt1 as initPOVPropertiesTableStmt1, @initPOVPropertiesTableStmt2 as initPOVPropertiesTableStmt2, @replTblStmt1 as replTblStmt1, @replTblStmt2 as replTblStmt2;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initPOVRefidsTable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initPOVRefidsTable`(in vInt INT UNSIGNED, in vText VARCHAR(255))
BEGIN
    DECLARE refIdsTable VARCHAR(255) DEFAULT NULL; 
	
    
    IF vText IS NOT NULL THEN
        call createTmpTable(refIdsTable);
        call initSubEntity(vInt, vText, refIdsTable);
        
    END IF;
    SELECT refIdsTable;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initQuery` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initQuery`()
BEGIN
    CREATE TEMPORARY TABLE IF NOT EXISTS warnings (warning TEXT NOT NULL);
	
	call createTmpTable(@resultSet);
    SELECT @resultSet as tablename;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initSubEntity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initSubEntity`(in e_id INT UNSIGNED, in ename VARCHAR(255), in tableName VARCHAR(255))
BEGIN
    DECLARE ecount INT DEFAULT 0;
    DECLARE op VARCHAR(255) DEFAULT '=';

    IF LOCATE("%", ename) > 0 THEN
        SET op = "LIKE";
    END IF;

    SET @stmtStr = CONCAT('INSERT IGNORE INTO `',
        tableName,
        '` (id) SELECT id FROM entities WHERE name ',
        op,
        ' ? UNION ALL SELECT entity_id FROM name_data WHERE value ',
        op,
        ' ? AND domain_id=0;');

    PREPARE stmt FROM @stmtStr;
    SET @ename = ename;
    EXECUTE stmt USING @ename, @ename;
    SET ecount = ROW_COUNT();
    DEALLOCATE PREPARE stmt;

    IF e_id IS NOT NULL THEN
        SET @stmtStr = CONCAT('INSERT IGNORE INTO `', tableName, '` (id) VALUES (', e_id, ')');
        PREPARE stmt FROM @stmtStr;
        EXECUTE stmt;
        SET ecount = ecount + ROW_COUNT();
        DEALLOCATE PREPARE stmt;
    END IF;

    IF ecount > 0 THEN
        call getChildren(tableName);
    END IF;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `initSubProperty` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `initSubProperty`(in sourceSet VARCHAR(255), in propertiesTable VARCHAR(255), in refIdsTable VARCHAR(255))
BEGIN
DECLARE newTableName VARCHAR(255) DEFAULT NULL;
    call registerTempTableName(newTableName);	
    
    SET @createSubPropertyListTableStr = CONCAT('CREATE TEMPORARY TABLE `', newTableName,'` ( entity_id INT UNSIGNED NOT NULL, id INT UNSIGNED NOT NULL, domain INT UNSIGNED NOT NULL, CONSTRAINT `',newTableName,'PK` PRIMARY KEY (entity_id, id, domain)) ' );
    
    PREPARE createSubPropertyListTable FROM @createSubPropertyListTableStr; 
    EXECUTE createSubPropertyListTable;
    DEALLOCATE PREPARE createSubPropertyListTable;

	SET @subResultSetStmtStr = CONCAT('INSERT IGNORE INTO `', newTableName, '` (domain, entity_id, id) 
            SELECT data1.domain_id as domain, data1.entity_id as entity_id, data1.value as id 
                FROM reference_data as data1 JOIN reference_data as data2 
                    ON (data1.domain_id=0 
                        AND data1.domain_id=data2.domain_id 
                        AND data2.entity_id=data1.entity_id 
                        AND (
                            (data1.property_id=data2.value AND data2.status="REPLACEMENT")
                            OR
                            (data1.property_id!=data2.value AND data2.status!="REPLACEMENT" AND data1.status!="REPLACEMENT" AND data1.property_id=data2.property_id)
                        )
                        AND EXISTS (SELECT 1 FROM `', sourceSet, '` as source WHERE source.id=data1.entity_id LIMIT 1)',
                        IF(propertiesTable IS NULL, '', CONCAT(' AND EXISTS (SELECT 1 FROM `', propertiesTable, '` as props WHERE props.id=data2.property_id LIMIT 1)')),
                        IF(refIdsTable IS NULL, '', CONCAT(' AND EXISTS (SELECT 1 FROM `', refIdsTable, '` as refs WHERE refs.id=data1.value LIMIT 1)')),	
		')'
        );


	PREPARE subResultSetStmt FROM @subResultSetStmtStr;
	EXECUTE subResultSetStmt;
    DEALLOCATE PREPARE subResultSetStmt;

	SELECT newTableName as list;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `insertEntity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `insertEntity`(in EntityName VARCHAR(255), in EntityDesc TEXT, in EntityRole VARCHAR(255), in ACL VARBINARY(65525))
BEGIN
    DECLARE NewEntityID INT UNSIGNED DEFAULT NULL;
    DECLARE NewACLID INT UNSIGNED DEFAULT NULL;

    call entityACL(NewACLID, ACL);

    INSERT INTO entities (name, description, role, acl) VALUES (EntityName, EntityDesc, EntityRole, NewACLID);
    SET NewEntityID = LAST_INSERT_ID();

    Select NewEntityID as EntityID;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `insertEntityProperty` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `insertEntityProperty`(in DomainID INT UNSIGNED, in EntityID INT UNSIGNED, in PropertyID INT UNSIGNED, in Datatable VARCHAR(255), in PropertyValue TEXT, in PropertyUnitSig BIGINT, in PropertyStatus VARCHAR(255), in NameOverride VARCHAR(255), in DescOverride TEXT, in datatypeOverride INT UNSIGNED, in Collection VARCHAR(255), in PropertyIndex INT UNSIGNED)
BEGIN

	CASE Datatable
	WHEN 'double_data' THEN
		INSERT INTO double_data 
		(domain_id, entity_id, property_id, value, unit_sig, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, PropertyValue, PropertyUnitSig, PropertyStatus, PropertyIndex);
	WHEN 'integer_data' THEN
		INSERT INTO integer_data 
		(domain_id, entity_id, property_id, value, unit_sig, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, PropertyValue, PropertyUnitSig, PropertyStatus, PropertyIndex);
	WHEN 'datetime_data' THEN
		INSERT INTO datetime_data 
		(domain_id, entity_id, property_id, value, value_ns, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, SUBSTRING_INDEX(PropertyValue, 'UTC', 1), IF(SUBSTRING_INDEX(PropertyValue, 'UTC', -1)='',NULL,SUBSTRING_INDEX(PropertyValue, 'UTC', -1)), PropertyStatus, PropertyIndex);
	WHEN 'reference_data' THEN
		INSERT INTO reference_data 
		(domain_id, entity_id, property_id, value, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, PropertyValue, PropertyStatus, PropertyIndex);
	WHEN 'enum_data' THEN	
		INSERT INTO enum_data 
		(domain_id, entity_id, property_id, value, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, PropertyValue, PropertyStatus, PropertyIndex);
	WHEN 'date_data' THEN	
		INSERT INTO date_data 
		(domain_id, entity_id, property_id, value, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, SUBSTRING_INDEX(PropertyValue, '.', 1), PropertyStatus, PropertyIndex);
	WHEN 'text_data' THEN
		INSERT INTO text_data 
		(domain_id, entity_id, property_id, value, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, PropertyValue, PropertyStatus, PropertyIndex);
	WHEN 'null_data' THEN
		INSERT INTO null_data
		(domain_id, entity_id, property_id, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, PropertyStatus, PropertyIndex);
	WHEN 'name_data' THEN
		INSERT INTO name_data
		(domain_id, entity_id, property_id, value, status, pidx) 
		VALUES 
		(DomainID, EntityID, PropertyID, PropertyValue, PropertyStatus, PropertyIndex);

	ELSE	
		SELECT * FROM table_does_not_exist;
	END CASE;

	IF DatatypeOverride IS NOT NULL THEN
		call overrideType(DomainID, EntityID, PropertyID, DatatypeOverride);
		IF Collection IS NOT NULL THEN
			INSERT INTO collection_type (domain_id, entity_id, property_id, collection) VALUES (DomainID, EntityID, PropertyID, Collection);
		END IF;
	END IF;

	IF NameOverride IS NOT NULL THEN
		call overrideName(DomainID, EntityID, PropertyID, NameOverride);	
	END IF;

	IF DescOverride IS NOT NULL THEN
		call overrideDesc(DomainID, EntityID, PropertyID, DescOverride);
	END IF;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `insertIsa` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `insertIsa`(IN c INT UNSIGNED, IN p INT UNSIGNED)
BEGIN

    INSERT INTO isa_cache (child, parent, rpath) VALUES (c,p,c);
	
    
    
    INSERT IGNORE INTO isa_cache SELECT
        c
            AS child,
        i.parent
            AS parent,
        IF(p=i.rpath or i.rpath=parent,
           p,
           concat(p, ">", i.rpath))
            AS rpath
        FROM isa_cache AS i WHERE i.child = p;
    
    
    
    INSERT IGNORE INTO isa_cache SELECT
        l.child,
        r.parent,
        if(l.rpath=l.child and r.rpath=c,
           c,
           concat(if(l.rpath=l.child,
                     c,
                     concat(l.rpath, '>', c)),
                  if(r.rpath=c,
                     '',
                     concat('>', r.rpath))))
            AS rpath
        FROM isa_cache as l
            INNER JOIN isa_cache as r ON (l.parent = r.child AND l.parent=c);


	
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `insertLinCon` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `insertLinCon`(in signature_from BIGINT, in signature_to BIGINT, in a DECIMAL(65,30), in b_dividend BIGINT, in b_divisor BIGINT, in c DECIMAL(65,30))
BEGIN

    INSERT IGNORE INTO units_lin_con (signature_from, signature_to, a, b_dividend, b_divisor, c) VALUES (signature_from, signature_to, a, b_dividend, b_divisor, c);

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `insertUser` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `insertUser`(in Name VARCHAR(255), in Password VARCHAR(255))
BEGIN 


INSERT INTO entities (name, role, acl) VALUES (Name, 'USER', 0);

SET @LAST_UserID = LAST_INSERT_ID();

INSERT INTO passwords VALUES (@LAST_UserID, Password);

Select @LAST_UserID as UserID; 

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `intersectTable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `intersectTable`(in resultSetTable VARCHAR(255), in diff VARCHAR(255))
BEGIN
    SET @diffStmtStr = CONCAT('DELETE FROM `', resultSetTable, '` WHERE id NOT IN ( SELECT id FROM `', diff,'`)');
    PREPARE diffStmt FROM @diffStmtStr;
    EXECUTE diffStmt;

    
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `isSubtype` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `isSubtype`(in c INT UNSIGNED, in p INT UNSIGNED)
BEGIN
	DECLARE ret BOOLEAN DEFAULT FALSE;
	SELECT TRUE INTO ret FROM isa_cache AS i WHERE i.child=c AND i.parent=p LIMIT 1;
    SELECT ret as ISA;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `overrideDesc` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `overrideDesc`(in DomainID INT UNSIGNED, in EntityID INT UNSIGNED, in PropertyID INT UNSIGNED, in Description TEXT)
BEGIN
	INSERT INTO desc_overrides (domain_id, entity_id, property_id, description) VALUES (DomainID, EntityID, PropertyID, Description);
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `overrideName` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `overrideName`(in DomainID INT UNSIGNED, in EntityID INT UNSIGNED, in PropertyID INT UNSIGNED, in Name VARCHAR(255))
BEGIN
	INSERT INTO name_overrides (domain_id, entity_id, property_id, name) VALUES (DomainID, EntityID, PropertyID, Name);
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `overrideType` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `overrideType`(in DomainID INT UNSIGNED, in EntityID INT UNSIGNED, in PropertyID INT UNSIGNED, in Datatype INT UNSIGNED)
BEGIN
	INSERT INTO data_type (domain_id, entity_id, property_id, datatype) VALUES (DomainID, EntityID, PropertyID, Datatype);
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `raiseWarning` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `raiseWarning`(in str VARCHAR(20000))
BEGIN
    INSERT INTO warnings VALUES (str);
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `registerSubdomain` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `registerSubdomain`(in Count INT UNSIGNED)
BEGIN
    DECLARE ED INTEGER DEFAULT NULL;

Select COUNT(id) INTO ED FROM entities WHERE Role='DOMAIN' AND id!=0;
WHILE ED < Count DO
		INSERT INTO entities (name, description, role, acl) VALUES (NULL, "Multipurpose subdomain", 'DOMAIN', 0);
		SET ED = ED + 1;
END WHILE;

SELECT id as DomainID FROM entities WHERE Role='DOMAIN' and id!=0;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `registerTempTableName` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `registerTempTableName`(out newTableName VARCHAR(255))
BEGIN
    SET newTableName = md5(CONCAT(RAND(),CURRENT_TIMESTAMP()));
    SET @tempTableList = IF(@tempTableList IS NULL, CONCAT('`',newTableName,'`'), CONCAT(@tempTableList, ',`', newTableName, '`'));
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `retrieveDatatype` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `retrieveDatatype`(in DatatypeName VARCHAR(255))
BEGIN

Select e.id INTO @DatatypeID from entities e where e.name=DatatypeName AND e.role='DATATYPE' LIMIT 1;

call retrieveEntity(@DatatypeID);




END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `retrieveEntity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `retrieveEntity`(in EntityID INT UNSIGNED)
BEGIN
	DECLARE FilePath VARCHAR(255) DEFAULT NULL;
	DECLARE FileSize VARCHAR(255) DEFAULT NULL;
	DECLARE FileHash VARCHAR(255) DEFAULT NULL;
	DECLARE DatatypeID INT UNSIGNED DEFAULT NULL;
    DECLARE CollectionName VARCHAR(255) DEFAULT NULL;
	
	Select path, size, hex(hash) into FilePath, FileSize, FileHash from files where file_id = EntityID LIMIT 1;
	Select datatype into DatatypeID from data_type where domain_id=0 and entity_id=0 and property_id=EntityID LIMIT 1;

	SELECT collection into CollectionName from collection_type where domain_id=0 and entity_id=0 and property_id=EntityID LIMIT 1;

	Select 
		(Select name from entities where id=DatatypeID) as Datatype, 
		CollectionName as Collection,
		EntityID as EntityID, 
		e.name as EntityName, 
		e.description as EntityDesc, 
		e.role as EntityRole, 
		FileSize as FileSize, 
		FilePath as FilePath, 
		FileHash as FileHash,
		(SELECT acl FROM entity_acl as a WHERE a.id = e.acl) as ACL
	from entities e where id = EntityID LIMIT 1;
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `retrieveEntityParents` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `retrieveEntityParents`(in EntityID INT UNSIGNED)
BEGIN

SELECT parent AS ParentID, name AS ParentName, description AS ParentDescription, role AS ParentRole, (SELECT acl from entity_acl as a WHERE a.id=e.acl) AS ACL FROM isa_cache AS i JOIN entities AS e ON (i.parent=e.id AND i.child=EntityID and i.rpath=EntityID); 




END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `retrieveEntityProperties` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `retrieveEntityProperties`(in DomainID INT UNSIGNED, in EntityID INT UNSIGNED)
BEGIN

		
		Select 
		property_id as PropertyID, value as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from double_data where domain_id = DomainID and entity_id = EntityID

		UNION ALL
		
		
		Select 
		property_id as PropertyID, value as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from integer_data where domain_id = DomainID and entity_id = EntityID

		UNION ALL

		
		Select 
		property_id as PropertyID, CONCAT(value, '.NULL.NULL') as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from date_data where domain_id = DomainID and entity_id = EntityID

		UNION ALL

		
		Select 
		property_id as PropertyID, CONCAT(value, 'UTC', IF(value_ns IS NULL, '', value_ns)) as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from datetime_data where domain_id = DomainID and entity_id = EntityID

		UNION ALL

		
		Select 
		property_id as PropertyID, value as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from text_data where domain_id = DomainID and entity_id = EntityID

		UNION ALL

		
		Select 
		property_id as PropertyID, value as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from enum_data where domain_id = DomainID and entity_id = EntityID

		UNION ALL

		
		Select 
		property_id as PropertyID, value as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from reference_data where domain_id = DomainID and entity_id = EntityID

		UNION ALL

		
		Select
		property_id as PropertyID, NULL AS PropertyValue, status as PropertyStatus, pidx as PropertyIndex from null_data WHERE domain_id = DomainID and entity_id = EntityID
		
		UNION ALL

		
		Select 
		property_id as PropertyID, value as PropertyValue, status as PropertyStatus, pidx as PropertyIndex from name_data where domain_id = DomainID and entity_id = EntityID;



END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `retrieveOverrides` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `retrieveOverrides`(in DomainID INT UNSIGNED, in EntityID INT UNSIGNED)
BEGIN

	SELECT NULL as collection_override, name as name_override, NULL as desc_override, NULL as type_override, entity_id, property_id from name_overrides where domain_id=DomainID and entity_id=EntityID UNION ALL
	SELECT NULL as collection_override, NULL as name_override, description as desc_override, NULL as type_override, entity_id, property_id from desc_overrides where domain_id=DomainID and entity_id=EntityID UNION ALL
	SELECT NULL as collection_override, NULL as name_override, NULL as desc_override, (Select name from entities where id=datatype LIMIT 1) as type_override, entity_id, property_id from data_type where domain_id=DomainID and entity_id=EntityID UNION ALL
	SELECT collection as collection_override, NULL as name_override, NULL as desc_override, NULL as type_override, entity_id, property_id from collection_type where domain_id=DomainID and entity_id=EntityID;
	

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `setPassword` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `setPassword`(in EntityID INT UNSIGNED, in NewPassword VARCHAR(255))
BEGIN


	DELETE FROM passwords where entity_id=EntityID;
	INSERT INTO passwords (entity_id, password) VALUES (EntityID, NewPassword);

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `showEntityAutoIncr` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `showEntityAutoIncr`()
BEGIN
SELECT `AUTO_INCREMENT`
FROM  INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA = 'caosdb'
AND   TABLE_NAME   = 'entities';


END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateEntity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `updateEntity`(in EntityID INT UNSIGNED, in EntityName VARCHAR(255), in EntityDescription TEXT, in EntityRole VARCHAR(255), in Datatype VARCHAR(255), in Collection VARCHAR(255), in ACL VARBINARY(65525))
BEGIN 
	DECLARE ACLID INT UNSIGNED DEFAULT NULL;
	call entityACL(ACLID, ACL);

	UPDATE entities e SET e.name = EntityName, e.description = EntityDescription, e.role=EntityRole, e.acl = ACLID where e.id = EntityID;

	DELETE from data_type where domain_id=0 AND entity_id=0 AND property_id=EntityID;
    DELETE from collection_type where domain_id=0 AND entity_id=0 AND property_id=EntityID;

    IF Datatype IS NOT NULL THEN
        INSERT INTO data_type (domain_id, entity_id, property_id, datatype) SELECT 0, 0, EntityID, ( SELECT id from entities where name = Datatype LIMIT 1);
		IF Collection IS NOT NULL THEN
        	INSERT INTO collection_type (domain_id, entity_id, property_id, collection) SELECT 0, 0, EntityID, Collection;
		END IF;
    END IF;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `updateLinCon` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`caosdb`@`%` PROCEDURE `updateLinCon`(in sig_from BIGINT, in sig_to BIGINT, in new_a DECIMAL(65,30), in new_b_dividend BIGINT, in new_b_divisor BIGINT, in new_c DECIMAL(65,30))
BEGIN
    UPDATE units_lin_con SET signature_to=sig_to, a=new_a, b_dividend=new_b_dividend, b_divisor=new_b_divisor, c=new_c where signature_from=sig_from;

END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2020-03-28 23:08:49
