/*
 * ** header v3.0
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2018 Research Group Biomedical Physics,
 * Max-Planck-Institute for Dynamics and Self-Organization Göttingen
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * ** end header
 */


DROP PROCEDURE IF EXISTS db_5_0.calcIntersection;
DELIMITER //

/**
 * Drop rows in `resultSetTable` which do not have a matching ID (and version) in `intersectWith`.
 */
CREATE PROCEDURE db_5_0.calcIntersection(in resultSetTable VARCHAR(255), in intersectWith VARCHAR(255), in versioned BOOLEAN)
BEGIN
    IF versioned THEN
        SET @diffStmtStr = CONCAT('DELETE FROM `',
            resultSetTable,
            '` WHERE NOT EXISTS ( SELECT 1 FROM `',
            intersectWith,
            '` AS diff WHERE diff.id=`',
            resultSetTable,
            '`.`id` AND diff._iversion=`',
            resultSetTable,
            '`.`_iversion`)');
    ELSE
        SET @diffStmtStr = CONCAT('DELETE FROM `', resultSetTable, '` WHERE NOT EXISTS ( SELECT 1 FROM `', intersectWith,'` AS diff WHERE diff.id=`',resultSetTable,'`.`id`)');
    END IF;
    PREPARE diffStmt FROM @diffStmtStr;
    EXECUTE diffStmt;

    
END;
//

DELIMITER ;
