/*
 * ** header v3.0
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2018 Research Group Biomedical Physics,
 * Max-Planck-Institute for Dynamics and Self-Organization Göttingen
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * ** end header
 */
DROP PROCEDURE IF EXISTS db_5_0.applyRefPOV;
DELIMITER //

CREATE PROCEDURE db_5_0.applyRefPOV(in sourceSet VARCHAR(255), in targetSet VARCHAR(255),
                                    in properties VARCHAR(255), in refs VARCHAR(255),
                                    in versioned BOOLEAN)
BEGIN
    DECLARE data VARCHAR(20000) DEFAULT CONCAT(
        '(SELECT domain_id, entity_id, property_id FROM `reference_data` AS subdata ',
        'WHERE EXISTS (SELECT 1 FROM `', refs, '` AS refs WHERE subdata.value=refs.id LIMIT 1))');

    IF versioned THEN
        SET data = CONCAT(
            '(SELECT domain_id, entity_id, _get_head_iversion(entity_id) AS _iversion, property_id ',
                'FROM `reference_data` AS subdata WHERE EXISTS (',
                    'SELECT 1 FROM `', refs, '` AS refs WHERE subdata.value=refs.id LIMIT 1) ',
            'UNION ALL SELECT domain_id, entity_id, _iversion, property_id ',
                'FROM `archive_reference_data` AS subdata WHERE EXISTS (',
                    'SELECT 1 FROM `', refs, '` AS refs WHERE subdata.value=refs.id LIMIT 1))');
    END IF;
    SET @stmtRefPOVStr = makeStmt(sourceSet,targetSet,data,properties, versioned);

    PREPARE stmt4 FROM @stmtRefPOVStr;
    EXECUTE stmt4;

    SELECT @stmtRefPOVstr as applyRefPOVStmt;

END;
//
DELIMITER ;
