# Changelog #

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [5.0.0] - 2021-10-28 ##

### Added ###

* #33 CI pipeline for MySQL (was only MariaDB before).

### Changed ###

### Deprecated ###

### Removed ###

* `getRules` procedure and the `rules` table. The jobs rules are being
  configured in the server repository now.

### Fixed ###

* Bug in applyPOV which led to caosdb-server#154: Queries with "!=" returned
  the same results as "=" (for references).
* #32 Removed unused `groups` table from installation routines which prevented
  the installation with MySQL 8.

### Security ###

## [4.1.0] - 2021-06-11 ##

### Added ###

- `utils/make_db` has new `grant-permission` command.

## [4.0.0] - 2021-02-10 ##

### Added ###

* Added a `_get_head_iversion` for non-api usage.
* Automated documentation builds: `make doc`

### Changed ###

* `retrieveEntity` does not return the columns `VersionSeconds` and
  `VersionNanos` anymore.
* `get_version_history` returns two additional columns, `child_username` and
  `child_realm`.
* Added a `versioned` flag to the following procedures:
    * `applyBackReference`
    * `applyIDFilter`
    * `applyPOV`
    * `applyRefPOV`
    * `makeStmt`
    * `calcComplementUnion`
    * `calcDifference`
    * `calcIntersection`
    * `finishSubProperty`
    * `getChildren`
    * `initEmptyTargetSet`
    * `initDisjunctionFilter`
    * `initEntity`
    * `initQuery`
    * `createTmpTable`
* Added a `direct` column to `archive_isa` table

### Deprecated ###

### Removed ###

* unused procedures:
    * `initNegationFilter`
    * `initConjunctionFilter`
    * `finishNegationFilter`

### Fixed ###

* #23 Incompatibility with MariaDB 10.3
* Fixed the `>=` and `<=` operators for comparisons in POV query filters with
  stored DATE values. The fix makes the implementation consistent
  However, the current definition and implementation of the
  `>=` and `<=` operators for date and datetime is unintuitive and the operators
  should have another name. Something like "overlap with or smaller/greater
  than".
* Semi-fix in `retrieveEntityParents`. The old implementation was buggy and
  would return no parent name or even a wrong one for old entity versions in
  some cases. The semi-fix will allways return the current name of the parent
  (even if this is historically not always correct). A real fix awaits the
  implementation of versioned isa-relations which is already planned.
* Bug in `retrieveOverrides` function where selecting the datatype of an old
  version resultet in an error. See corresponding test in `caosdb-pyinttest`
  `tests/test_versioning.py::test_datatype_without_name`

### Security ###

## [3.0.0] - 2020-09-01 ##

### Added ###

* New `feature_config` table for storing configuration of features as key-value
  pairs. Currently only used by the ENTITY_VERSIONING feature for switching
  versioning on or off. Convenient function `is_feature_config` for checking
  whether the `feature_config` table has a particular value.
* New `transactions` table. This is necessary for the ENTITY_VERSIONING feature
  and will replace the `transaction_log` table in the future.
* Feature ENTITY_VERSIONING (experimental)
  Switch off this feature with `DELETE FROM feature_config WHERE
  _key="ENTITY_VERSIONING"` and switch on with `INSERT INTO feature_config
  (_key, _value) VALUES ("ENTITY_VERSIONING", "ENABLED")`. This feature comes
  with a lot of additions to the API. E.g.
  * New `entity_version`.
  * All `*_data` tables have a new twin, the `archive_*_data` table, where all
    old versions of entities are stored. The `*_data` tables only contain the
    data of the latest version.
  * Additional `archive_isa` for the history entities' parents.
  * Additional `_iversion` column for the `reference_data` table for storing
    references to particular versions of an entity.
  * New `setFileProperties` and `retrieveQueryTemplateDef` procedures which reduce server code and let the
    backend decide which tables to use. Also, this is necessary for the
    versioning, because these procedures behave differently depending on the
    ENTITY_VERSIONING feature being enabled or disabled.
  * Several functions and procedures for the interaction with the
    `entity_version` table and the `transactions` table. E.g.
    `insert_single_child_version`, `delete_all_entity_versions`,
    `get_iversion`, `get_primary_parent_version`, `get_version_timestamp`,
    `get_head_version`, `get_head_relative`, `get_version_history`.
  The versions are tracked internally by the `_iversion` field which is an
  integer and which should not be used outside of the backend.
* New makefile targets for testing with MariaDB instance from Docker image: call
  `make test-docker` to temporarily start a Docker container with MariaDB which
  will be used for the unit tests.

### Changed ###

* Removed `getFile` procedure.

### Deprecated ###

* Table `transaction_log` is deprecated. The functionality is being replaced by the `transactions` table.

### Fixed ###

* POV with the 'name' property, e.g. `FIND ENTITY WITH name = something`
  [caosdb-server#51](https://gitlab.com/caosdb/caosdb-server/-/issues/51)
* Fixed several bugs when an Entity inherits from itself (#18, caosdb-server #85).
* Bug in `updateEntity.sql` (when updating the primary name without a prior call
  to `deleteEntityProperties`). Same thing for `deleteEntity`.
* #21 Bug which prevented deletion of deeply inheriting entities, if versioning was enabled.

### Security ###
