

Constants
====================================================================

```C
#include "Spirit/Constants.h"
```

Physical constants in units compatible to what is used in Spirit.



### Constants_mu_B

```C
scalar Constants_mu_B()
```

The Bohr Magneton [meV / T]



### Constants_mu_0

```C
scalar Constants_mu_0()
```

The vacuum permeability [T^2 m^3 / meV]



### Constants_k_B

```C
scalar Constants_k_B()
```

The Boltzmann constant [meV / K]



### Constants_hbar

```C
scalar Constants_hbar()
```

Planck constant [meV*ps / rad]



### Constants_mRy

```C
scalar Constants_mRy()
```

Millirydberg [mRy / meV]



### Constants_gamma

```C
scalar Constants_gamma()
```

Gyromagnetic ratio of electron [rad / (s*T)]



### Constants_g_e

```C
scalar Constants_g_e()
```

Electron g-factor [unitless]



### Constants_Pi

```C
scalar Constants_Pi()
```

Pi [rad]

