# -*- coding: utf-8 -*-
#
# Spirit documentation build configuration file, created by
# sphinx-quickstart on Thu Jul 13 16:49:07 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
import sys, os
sys.path.insert( 0, os.path.join( os.path.dirname( __file__ ), "core", "python", "spirit" ) )
sys.path.insert( 0, os.path.join( os.path.dirname( __file__ ), "core", "python" ) )


# At top on conf.py (with other import statements)
# import recommonmark
# from recommonmark.transform import AutoStructify

# # At the bottom of conf.py
# def setup(app):
#     app.add_config_value('recommonmark_config', {
#             'url_resolver': lambda url: github_doc_root + url,
#             'auto_toc_tree_section': 'Contents',
#             }, True)
#     app.add_transform(AutoStructify)


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx_markdown_tables', 'sphinx.ext.intersphinx',
                'sphinx.ext.coverage', 'sphinx.ext.autodoc']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
# source_suffix = '.md'

source_parsers = {'.md': 'recommonmark.parser.CommonMarkParser'}


# from recommonmark.parser import CommonMarkParser

# The suffix of source filenames.

# source_suffix = ['.rst', '.md']

# parsers = {
#     '.md': CommonMarkParser,
# }

# from sphinxcontrib.pandoc_markdown import MarkdownParser

source_suffix = ['.rst', '.md']
# source_parsers = {
#    '.md': MarkdownParser,
# }


# The master toctree document.
master_doc = 'docs/index'


# man_pages = [ master_doc, ("docs/BUILD", "build", "building", "authors", "sectionbuild") ]

# General information about the project.
project = u'Spirit'
copyright = u'2017, Gideon Mueller and contributors'
author = u'Gideon Mueller and contributors'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
# version = u'1.6.1'
# The full version, including alpha/beta/rc tags.
# release = u'1.6.1'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['.github', '_build', '../core/docs/python-api/spirit.rst', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    "collapse_navigation" : False
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    '**': [
        'about.html',
        'navigation.html',
        'relations.html',  # needs 'show_related': True theme option to display
        'searchbox.html',
        'donate.html',
    ]
}


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'Spiritdoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'Spirit.tex', u'Spirit Documentation',
     u'Gideon Mueller and contributors', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'spirit', u'Spirit Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'Spirit', u'Spirit Documentation',
     author, 'Spirit', 'One line description of project.',
     'Miscellaneous'),
]


# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/': None}


def run_apidoc(_):
    """Runs sphinx-apidoc when building the documentation.
    Needs to be done in conf.py in order to include the APIdoc in the
    build on readthedocs.
    See also https://github.com/rtfd/readthedocs.org/issues/1139
    """
    source_dir = os.path.abspath(os.path.dirname(__file__))
    apidoc_dir = os.path.join(source_dir, 'core', 'docs', 'python-api')
    package_dir = os.path.join(source_dir, 'core', 'python', 'spirit')

    import subprocess
    cmd_path = 'sphinx-apidoc'
    if hasattr(sys, 'real_prefix'):  # Check to see if we are in a virtualenv
        # If we are, assemble the path manually
        cmd_path = os.path.abspath(os.path.join(sys.prefix, 'bin', 'sphinx-apidoc'))

    options = [
        '-o', apidoc_dir, package_dir,
        '--force',
        '--no-headings',
        '--module-first',
        '--separate',
        '--no-toc',
        '--maxdepth', '4',
    ]

    build_dir = os.path.join(source_dir, 'build')
    if not os.path.exists(build_dir):
        os.mkdir(build_dir)
    subprocess.check_call(['cmake', '..', '-DSPIRIT_BUILD_FOR_CXX=OFF', '-DSPIRIT_SKIP_HTST=ON'], cwd=build_dir)
    subprocess.check_call(['make'], cwd=build_dir)

    # See https://stackoverflow.com/a/30144019
    env = os.environ.copy()
    env["SPHINX_APIDOC_OPTIONS"] = 'members,special-members,private-members,undoc-members,show-inheritance'
    subprocess.check_call([cmd_path] + options, env=env)

    #####################
    with open(os.path.join(apidoc_dir, 'parameters.rst'), "w") as parameters_file:
        parameters_file.write("spirit.parameters\n==================================\n\n")
        with open(os.path.join(apidoc_dir, 'spirit.parameters.mc.rst'), 'r') as generated_file:
            parameters_file.write(generated_file.read())
        with open(os.path.join(apidoc_dir, 'spirit.parameters.llg.rst'), 'r') as generated_file:
            parameters_file.write(generated_file.read())
        with open(os.path.join(apidoc_dir, 'spirit.parameters.gneb.rst'), 'r') as generated_file:
            parameters_file.write(generated_file.read())
        with open(os.path.join(apidoc_dir, 'spirit.parameters.ema.rst'), 'r') as generated_file:
            parameters_file.write(generated_file.read())
        with open(os.path.join(apidoc_dir, 'spirit.parameters.mmf.rst'), 'r') as generated_file:
            parameters_file.write(generated_file.read())

    print("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    print("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    testfile = os.path.join(apidoc_dir, 'spirit.log.rst')
    with open(testfile, 'r') as f:
        print(f.read())
    print("yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy")
    print("yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy")
    testfile = os.path.join(apidoc_dir, 'spirit.geometry.rst')
    with open(testfile, 'r') as f:
        print(f.read())
    print("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz")
    print("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz")

    if not os.path.exists(apidoc_dir):
        os.mkdir(apidoc_dir)

def setup(app):
    app.connect('builder-inited', run_apidoc)