#include "cppdefs.h"
module ice

use parameters_ice
use glacial_ice
use domain, only: imin, imax, jmin, jmax

IMPLICIT NONE
private

public init_ice
public do_ice
public register_ice_variables

logical, public  :: have_ice = .false.

REALTYPE, dimension(:,:), allocatable, public :: icep
REALTYPE, dimension(:,:), allocatable, public :: svf_ice
REALTYPE, dimension(:,:), allocatable, public :: shf_ice
REALTYPE, dimension(:,:), allocatable, public :: ssf_ice

contains

   subroutine init_ice(runtype)

   IMPLICIT NONE

   integer, intent(in) :: runtype
   character(len=PATH_MAX) :: ice_file = 'ice.nc'

   namelist /ice/ have_glacial_ice, ice_file, rho_ice, z0_ice

   LEVEL1 'init_ice'

   read(NAMLST, ice)

   have_ice = have_glacial_ice
   if (.not. have_ice) return

   allocate(icep(E2DFIELD))

   if (runtype .gt. 2) then
      allocate(svf_ice(E2DFIELD))
      svf_ice = _ZERO_
      allocate(shf_ice(E2DFIELD))
      shf_ice = _ZERO_
      allocate(ssf_ice(E2DFIELD))
      ssf_ice = _ZERO_
   end if

   if (have_glacial_ice) call init_glacial_ice(runtype, trim(ice_file), icep)

   end subroutine init_ice


   subroutine do_ice(runtype, ustar, T, S, h, z0, zb)

   use domain, only: sdom

   IMPLICIT NONE

   integer, intent(in)                       :: runtype
   REALTYPE, dimension(E2DFIELD), intent(in) :: ustar
   REALTYPE, dimension(E2DFIELD), intent(in) :: T
   REALTYPE, dimension(E2DFIELD), intent(in) :: S
   REALTYPE, dimension(E2DFIELD), intent(in) :: h
   REALTYPE, dimension(E2DFIELD), intent(in) :: z0
   REALTYPE, dimension(E2DFIELD), intent(in) :: zb

#ifdef DEBUG
   integer, save :: Ncall = 0
   Ncall = Ncall+1
   write(debug,*) 'do_ice() # ',Ncall
#endif

   if ( have_glacial_ice ) then
      call do_glacial_ice(runtype, ustar, T, S, h, z0, zb)
      if (runtype .gt. 2) then
         where( sdom .eq. 3 )
            svf_ice =  vm       ! positive downwards
            shf_ice = -bmf_heat ! positive downwards
            ssf_ice = -bmf_salt ! positive downwards
         end where
      end if
   end if

#ifdef DEBUG
   write(debug,*) 'Leaving do_ice()'
   write(debug,*)
#endif

   end subroutine do_ice


   subroutine register_ice_variables(fm, runtype)

   use field_manager
   IMPLICIT NONE

   type (type_field_manager) :: fm
   integer, intent(in)       :: runtype

   LEVEL2 'register_ice_variables'

   if (have_glacial_ice) call register_glacial_ice_variables(fm, runtype)

   end subroutine register_ice_variables

end module
