#include "cppdefs.h"
!-----------------------------------------------------------------------
!BOP
!
! !ROUTINE: remap1 -
! \label{sec-remap1}
!
! !INTERFACE:
   subroutine remap1(nlev,zilev,nbins,zibins,dzlk,lmin,lmax)
!
! !DESCRIPTION:
!
! !USES:
   IMPLICIT NONE
!
! !INPUT PARAMETERS:
   integer, intent(in)                          :: nlev,nbins
   REALTYPE, dimension(0:nlev), intent(in)      :: zilev
   REALTYPE, dimension(0:nbins), intent(in)     :: zibins
!
! !INPUT/OUTPUT PARAMETERS:
!
! !OUTPUT PARAMETERS:
   REALTYPE, dimension(0:nbins,1:nlev), intent(out) :: dzlk
   integer, dimension(1:nlev), intent(out)      :: lmin
   integer, dimension(1:nlev), intent(out)      :: lmax
!
! !REVISION HISTORY:
!  Original author(s): Knut Klingbeil
!
! !LOCAL VARIABLES:
   integer :: k,l,k0,l0
!EOP
!-----------------------------------------------------------------------
!BOC
#ifdef DEBUG
   integer, save :: Ncall = 0
   Ncall = Ncall+1
   write(debug,*) 'remap1() # ',Ncall
#endif

   lmin(:) = -1
   lmax(:) = -2
   dzlk(:,:) = _ZERO_

!  zibins strictly monotonically increasing with l

!  Return if uppermost bin interface is not above bottom (e.g. shallow areas).
   if ( zibins(nbins) .le. zilev(0) ) return

!  Return if lowermost bin interface is not below surface (e.g. ebb).
   if ( zibins(0) .ge. zilev(nlev) ) return

!  Find highest layer with lower interface below upper bin interface
   do k = nlev,1,-1
      if ( zibins(nbins) .gt. zilev(k-1) ) exit
   end do
   k0 = k

#if 1
!  equidistant bins
   l0 = min( int( ceiling( (zilev(k0)-zibins(0))/(zibins(nbins)-zibins(0))*nbins ) ) , nbins )

   do k = k0,1,-1
      lmax(k) = l0
      l0 = int( ceiling( (zilev(k-1)-zibins(0))/(zibins(nbins)-zibins(0))*nbins ) )
      if ( l0 .lt. 1 ) then
!        lower layer interface below lowermost bin interface
         lmin(k) = 1
         exit
      end if
      lmin(k) = l0
   end do
#else
!  Find highest bin with lower interface below present layer upper interface
   do l = nbins,1,-1
      if ( zibins(l-1) .le. zilev(k0) ) exit
   end do
   l0 = l

   do k = k0,1,-1
      lmax(k) = l0
!     Find next bin below with lower interface below present layer lower interface
      do l = l0,1,-1
         if ( zibins(l-1) .le. zilev(k-1) ) exit
      end do
      l0 = l
      if ( l0 .eq. 0 ) then
!        lower layer interface below lowermost bin interface
         lmin(k) = 1
         exit
      end if
      lmin(k) = l0
   end do
#endif

!  calculate weights
   do k = 1,nlev
      do l = lmin(k),lmax(k)
         dzlk(l,k) = max( _ZERO_ , min( zibins(l) , zilev(k) ) - max( zibins(l-1) , zilev(k-1) ) )
      end do
   end do

#ifdef DEBUG
   write(debug,*) 'Leaving remap1()'
   write(debug,*)
#endif
   return
   end subroutine remap1
!EOC
!-----------------------------------------------------------------------
! Copyright (C) 2019 - Knut Klingbeil                                  !
!-----------------------------------------------------------------------
