#include "cppdefs.h"
!-----------------------------------------------------------------------
!BOP
!
! !ROUTINE: rebin -
! \label{sec-rebin}
!
! !INTERFACE:
   subroutine rebin(nlev,flev,nbins,fibins,binidx)
!
! !DESCRIPTION:
!
! !USES:
   IMPLICIT NONE
!
! !INPUT PARAMETERS:
   integer, intent(in)                          :: nlev,nbins
   REALTYPE, dimension(1:nlev), intent(in)      :: flev
   REALTYPE, dimension(0:nbins), intent(in)     :: fibins
!
! !INPUT/OUTPUT PARAMETERS:
!
! !OUTPUT PARAMETERS:
   integer, dimension(1:nlev), intent(out)      :: binidx
!
! !REVISION HISTORY:
!  Original author(s): Knut Klingbeil
!
! !LOCAL VARIABLES:
   integer :: k,l,l0
!EOP
!-----------------------------------------------------------------------
!BOC
#ifdef DEBUG
   integer, save :: Ncall = 0
   Ncall = Ncall+1
   write(debug,*) 'rebin() # ',Ncall
#endif

   l0 = nbins
   do k=1,nlev
!     fibins strictly monotonically increasing with l
      if (flev(k) .gt. fibins(nbins)) then
         binidx(k) = -1
         cycle
      end if
#if 1
!     equidistant bins
      l = max( 0 , int( ceiling( (flev(k)-fibins(0))/(fibins(nbins)-fibins(0))*nbins ) ) )
      ! this version has less truncation errors for flev=fibins(nbins)
      !l = max( 0 , nbins - int( floor( (fibins(nbins)-flev(k)))/(fibins(nbins)-fibins(0))*nbins ) ) )
#else
      if (flev(k) .gt. fibins(  l0 )) l0 = nbins ! reset to start from highest bin again
      do l = l0,1,-1
         if (flev(k) .gt. fibins(l-1)) then
            l0 = l
            exit
         end if
      end do
#endif
      binidx(k) = l ! here we also map to index 0
   end do

#ifdef DEBUG
   write(debug,*) 'Leaving rebin()'
   write(debug,*)
#endif
   return
   end subroutine rebin
!EOC
!-----------------------------------------------------------------------
! Copyright (C) 2019 - Knut Klingbeil                                  !
!-----------------------------------------------------------------------
