#include "cppdefs.h"
!-----------------------------------------------------------------------
!BOP
!
! !MODULE:  friction
!
! !INTERFACE:
   module friction
!
! !DESCRIPTION:
!
! !USES:
   use parameters, only: kappa, avmmol
   use domain, only: cd_min, z0d_iters
   IMPLICIT NONE

   private
!
! !PUBLIC DATA MEMBERS:
   public calc_rdrag
!
! !LOCAL VARIABLES:
!
! !REVISION HISTORY:
!  Original author(s): Knut Klingbeil
!EOP
!-----------------------------------------------------------------------

   contains

!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE:  calc_rdrag()
!
! !INTERFACE:
   elemental function calc_rdrag(z0, vel, Dvel) result(rd)
!
! !DESCRIPTION:
!
! !USES:
   IMPLICIT NONE

! !INPUT PARAMETERS:
   REALTYPE, intent(in) :: z0, vel, Dvel
!
! !OUTPUT PARAMETERS:
   REALTYPE :: rd
!
! !LOCAL VARIABLES:
   REALTYPE                                 :: cd, sqrtcd, z0d
   integer                                  :: it
!EOP
!-------------------------------------------------------------------------
!BOC
#ifdef DEBUG
   integer, save :: Ncall = 0
   Ncall = Ncall+1
   write(debug,*) 'calc_rdrag() # ',Ncall
#endif
            if (z0 .le. _ZERO_) return
            z0d = z0
!           Note (KK): note shifting of log profile so that U(-H)=0
            sqrtcd = kappa / log( _ONE_ + _HALF_*Dvel/z0d )
            if (avmmol.gt._ZERO_ .and. vel.gt._ZERO_) then
               do it=1,z0d_iters
                  z0d = z0 + _TENTH_*avmmol/(sqrtcd*vel)
!                 KK-TODO: clipping of z0d at Dvel as in the old code?
                  sqrtcd = kappa / log( _ONE_ + _HALF_*Dvel/z0d )
               end do
            end if
            cd = max( cd_min , sqrtcd*sqrtcd ) ! see Blumberg and Mellor (1987)
            rd = cd * vel
            !p_zub = z0d

#ifdef DEBUG
   write(debug,*) 'Leaving calc_rdrag()'
   write(debug,*)
#endif
   return
   end function calc_rdrag
!EOC

!-----------------------------------------------------------------------

   end module friction

!-----------------------------------------------------------------------
! Copyright (C) 2020 - Knut Klingbeil (IOW)                            !
!-----------------------------------------------------------------------
