# DataKnots.jl

DataKnots is a Julia library for representing and querying
complex structured data. It is designed for data analysts and
domain experts (e.g. accountants, engineers, researchers) who
need to build and share domain-specific queries. DataKnots
also provides an extensible, coherent, and composable
programmatic interface to assist software developers create
sophisticated yet custom query interfaces for their users.

*At this time, while we welcome feedback and contributions,
DataKnots is not yet usable for general audiences.*

### Overview
---

To get a high-level view of what DataKnots is capable of, there is
an overview.

```@contents
Pages = [
    "overview.md",
]
Depth=2
```

### Tutorials
---

To help you get started with DataKnots we open with
goal-oriented tutorials. They explain all of the basic and
some of the more advanced features of the system, without
going into all of the details.

```@contents
Pages = [
    "highlypaid.md"
]
Depth=2
```

### Reference Manual
---

These documents provide conceptual topics and reference
materials for users.

```@contents
Pages = [
    "primer.md",
    "tutorial.md",
    "reference.md",
]
Depth=2
```

### Implementer's Guide
---

The following documents include implementation details for
contributors and for those who are building extensions. These
documents serve as regression suites in documentation form.

```@contents
Pages = [
    "vectors.md",
    "pipelines.md",
    "shapes.md",
    "knots.md",
    "queries.md",
]
Depth=2
```
