---
title: 'RingsPy: A Python package for Voronoi mesh generation of cellular solids with radial growth pattern'
tags:
  - Python 
  - Voronoi tessellation 
  - Cellular materials
  - Radial growth 
  - Irregular geometry
authors:
  - name: Hao Yin
    orcid: 0000-0003-4921-9786
    affiliation: "1"
  - name: Gianluca Cusatis
    orcid: 0000-0001-7436-3910
    affiliation: "1"
affiliations:
 - name: Department of Civil and Environmental Engineering, Northwestern University, Evanston, Illinois, United States of America
   index: 1
date: October 2022
bibliography: paper.bib
---

# Summary

``RingsPy`` is an open-source package entirely written in Python that generates 3D meshes of prismatic cellular solids with tunable radial growth rules featured by many natural or architectured cellular solids with a radial, differential cell growth pattern. Typical examples of this type of materials are microstructures of wood [@tonn2017radial], skeletal muscle fibers [@jorgenson2020identifying], and anisotropic polymeric foams [@martinez2016procedural]. The 2D geometry of the cellular structure of the solid is first constructed with a 2D Voronoi tessellation, and then the 2D Voronoi cells are extruded in the longitudinal (parallel-to-grain) direction with a certain grain angle around the longitudinal axis. This process is supposed to mimic the morphology and dynamic growth of natural or additively manufactured cellular materials.
The package is dependent only on ``numpy`` [@harris2020array] and ``scipy`` [@virtanen2020scipy] for core implementation, however, regular cells (e.g., hexagonal honeycomb structures) option is also provided, with the help of Python package ``hexalattice``. The visualization of the generated geometry is implemented using Python package ``matplotlib`` for 2D cross-sectional images, and for 3D models using the ``VTK`` or ``STL`` format files (which can be then used in scientific visualization tools such as ``Paraview`` and for 3D printing).

# Statement of need

Natural and bioinspired materials are often characterized by irregular and heterogeneous cellular microstructures, they include materials such as wood, nacre, trabecular bone, or 3D printed biomimetic composites [@gibson_ashby_1997;@tekog2011size;@bhate2019classification].

Cellular yet irregular morphology of materials is a natural outcome of local cell growth that follows simple intrinsic physical rules, among these, the Voronoi diagram, has been proposed to be one of the best approximations of cell interfaces at the steady-state by the equilibrium of intracellular pressures and the intercellular surface tension [@saye2011voronoi;@sanchez2016fundamental]. Besides, there is also an underlying process, which governs the global growth of cells to form the radial pattern in plane and the growth of either straight or helical grains in the perpendicular direction to the plane [@hartmann2017modelling;@sozio2019nonlinear]. Understanding the role of locally irregular and globally radial morphology in determining material properties offers a new path to unveil the behavior of natural materials and engineer materials with superior functionalities, such as anisotropic programmable material properties, stress redirection, and oriented impact energy dissipation. 

While the laboratory and in-situ imaging approaches (e.g., 3D X-ray tomography) can be reliable for reproducing the most geometrically accurate material morphology, however, these approaches are still costly and time-consuming in some highly repetitive scenarios, such as prototyping and probabilistic analyses. Given that, an algorithm-based, stochastic generator of cellular geometries is at a new level of need. 

We propose a fundamental, growth-inspired program that evokes the formation of cellular architectures with radial and longitudinal growth patterns in natural systems. This virtual growth program imposes both local and global generation rules on a limited category of basic elements. It generates meshes that exhibit stochastic geometrical properties, starting from very limited initial constraints, which echoes the diversity of biological and biomimetic systems. 

# RingsPy workflow

RingsPy has a basic workflow illustrated as follows (\autoref{fig1}):

1. The users first assign a radial growth pattern of the cellular solid with a couple of input parameters. This process will create 2D concentric ring-like regions for Voronoi cell nuclei placement. Each placement region has a specific generation rule (for example, for wood, the cell nuclei will be assigned larger cell sizes in earlywood regions and smaller ones in latewood regions; this pattern is called ``binary wood``). These nuclei with given cell sizes will be used to pack many non-overlapping circles in each region.

2. Once the nuclei are properly placed, an associated Voronoi diagram is then generated by calling ``scipy.spatial.Voronoi``. The Voronoi diagram automatically tessellates the region into Voronoi cells. The ridges of Voronoi cells will be treated as the cell walls/interfaces. A user-defined clipping box will constrain the Voronoi mesh into the desired shape, and the data structure of the Voronoi mesh is correspondingly rebuilt.

3. The 2D Voronoi cells are then extruded in the longitudinal (or parallel-to-grain) direction with a pre-twisting angle. Fibrils (a.k.a., grains or beams) will be formed during the extrusion process at Voronoi vertices (joints of Voronoi ridges). The connectivity of 2D Voronoi ridges will remain at every extrusion layer. A 3D prismatic cellular mesh is constructed, accompanied by data files.

![Pipeline of RingsPy - an example of the microstructure generation of a cubic spruce wood specimen: a) cell nuclei of a spruce wood log are firstly generated by a ``binary wood`` (abrupt earlywood-latewood transition) radial growth rule, b) cell nuclei are used as Voronoi sites to the generate the Voronoi diagram, and the geometric boundaries (clipping box) for a cubic specimen then cut and trim Voronoi diagram into the desired shape, c) 2D Voronoi cells are then extruded in the longitudinal direction to form the 3D prismatic cellular geometry, 3D meshes are constructed, they can be used for volumetric rendering of the cubic specimen in ``Paraview``, the color map shows the thicknesses of cell walls/interfaces, and d) the 3D meshes can be used for other purposes, such as mechanical strength analysis, the color map shows the simulation results of cell wall crack openings associated with the mechanical tensile tests of the specimen\label{fig1}](fig1.pdf)

# Acknowledgments

The presented work was supported in part by the US National
Science Foundation through grant CMMI–1762757. Any opinions,
findings, conclusions, and recommendations expressed in this
paper are those of the authors and do not necessarily reflect the views of the sponsors.

# References
