# Data used for rtrees: an R package to assemble phylogenetic trees from megatrees

---

This dataset includes simulated data used in the published paper to demonstrate the effects of different grafting options on the estimations of phylogenetic diversity of communities and phylogenetic signals of traits.


## Description of the data and file structure

- `x_pd.rds` contains simulated results of phylogenetic diversity of communities. It is a list with 1000 data frames. Each data frame has the following columns:
    - `type`: different type of simulation (grafting of species)
    - `sr`: species richness of the community
    - `pd`: Faith's phylogenetic diversity of the community
    - `mpd`: mean pairwise phylogenetic distance of the community
    - `mntd`: mean nearest taxonomic distances of the community
- `x_ps_1_1000.rds` contains simulated results of phylogenetic signals of functional traits. It is a list with 1000 data frames. Each data frame has the following columns:
    - `method`: methods to test phylogenetic signal of functional traits, 'K' or 'lambda'
    - `true`: true value of phylogenetic signal
    - `diff_at_basal_node_true`: differences between the estimated phylogenetic signal based on phylogenies derived with the 'at_basal_node" approach and that estimated based on the 'true' phylogeny
    - `diff_at_or_above_basal_true`: differences between the estimated phylogenetic signal based on phylogenies derived with the 'at_or_above_basal" approach and that estimated based on the 'true' phylogeny
    - `diff_random_below_basal_ave_true`: differences between the estimated phylogenetic signal based on phylogenies derived with the 'diff_random_below_basal_ave_true" approach and that estimated based on the 'true' phylogeny
- `grafting_scenarios_simulations.R` contains the R code to generate the above files. 

## Sharing/Access information


## Code/Software

All code were written with R. The datasets were also R specific files.
