#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Feb  1 11:09:41 2023
This script calculates the fraction of undefined surface per city and per dataset
from the file called "rsu_indicators.geojson"

@author: Jérémy Bernard, University of Gothenburg, University Savoie Mont-Blanc
"""
import pandas as pd
import geopandas as gpd
from pathlib import Path
import os


input_data_directory = os.path.join(Path(os.path.abspath(os.curdir)).parents[0], "Data")
filename = "rsu_indicators.geojson"
osm_name = os.path.join("osm", "2022")
bdt_name = "bdtopo_2_2"
datasets = [osm_name, bdt_name]

# Store fraction of undefined per Dataset and per city
df_fraction = pd.DataFrame(columns = datasets)
df_area = pd.DataFrame(columns = datasets)

# For each dataset (BDT or OSM)
for dt in datasets:
    # For each city
    for c in os.listdir(os.path.join(input_data_directory, dt)):
        gdf = gpd.read_file(os.path.join(input_data_directory, dt, c, filename))
        if gdf.columns.isin(["AREA"]).sum() == 1:
            df_fraction.loc[c, dt] = (gdf.UNDEFINED_FRACTION * gdf.AREA).sum() / gdf.AREA.sum()
            df_area.loc[c, dt] = gdf.AREA.sum()
        else:
            df_fraction.loc[c, dt] = (gdf.UNDEFINED_FRACTION * gdf.geometry.area).sum() / gdf.geometry.area.sum()
            df_area.loc[c, dt] = gdf.geometry.area.sum()           

results = (df_area * df_fraction).sum() / df_area.sum() 
print("Mean city undefined fraction is {0} % and {1} % for OSM and BDT respectively".format(results[osm_name]*100, 
                                                                                          results[bdt_name]*100))
