import sqlite3

import pandas as pd
from nltk import pos_tag
from nltk.tokenize import word_tokenize
from tqdm.auto import tqdm

db_connection = sqlite3.connect("C:\\Users\\sheha\\Downloads\\_Output_AssertData.sqlite")
input_data = pd.read_sql_query(
    "select AssertMethodId,Category,message, tokens from readability_score",
    db_connection)
output_data = pd.DataFrame()

for index, row in tqdm(input_data.iterrows(), desc="Text Preprocessing rows", total=len(input_data)):
    # tokenized = word_tokenize(row['message'])
    tokenized = row['tokens'].split(',')
    tags = pos_tag(tokenized)
    pattern = []
    for tag in tags:
        pattern.append(tag[1])

    first_pos = ' '.join(pattern[0:1])
    first2_pos = ' '.join(pattern[0:2]) if len(pattern) >= 2 else None
    first3_pos = ' '.join(pattern[0:3]) if len(pattern) >= 3 else None
    first4_pos = ' '.join(pattern[0:4])if len(pattern) >= 4 else None

    output_data = output_data.append({
        'AssertMethodId': row['AssertMethodId'],
        'Message': row['message'],
        'Category': row['Category'],
        'GrammarPattern': ' '.join(pattern),
        'First_POS': first_pos,
        'First2_POS': first2_pos,
        'First3_POS': first3_pos,
        'First4_POS': first4_pos}, ignore_index=True)

output_data.to_sql('grammar_pattern', db_connection, if_exists='replace', index=False)
