package org.example.assertmessageanalysis.actions;
import java.sql.*;
import java.text.MessageFormat;
import java.util.Calendar;

public class AssertMethodEntityService {
    private final Connection connection;

    private AssertMethodEntityService(String projectName, String projectLocation) throws SQLException {
        String time =  String.valueOf(Calendar.getInstance().getTimeInMillis());
        String outputFile = MessageFormat.format("jdbc:sqlite:{0}/{1}_{2}_{3}_{4}.{5}", projectLocation,"Output", projectName, "AssertData", time, "sqlite");

        try {
            Class.forName("org.sqlite.JDBC");
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        connection = DriverManager.getConnection(outputFile);
        if (connection != null) {
            createTables();
            System.out.printf("A new output database has been created: %s%n", outputFile);
        }
    }

    public static AssertMethodEntityService getInstance(String projectName, String projectLocation) throws SQLException {
        return new AssertMethodEntityService(projectName, projectLocation);
    }

    public void writeAsertMethodData(AssertMethodEntity assertMethod) throws SQLException {
        String sql_insertAssertMethod = "INSERT INTO " +
                "assert_method(ProjectName,FilePath,ParentClassName,ParentMethodName,IsTestMethod,AssertMethodName,AssertMessage,AssertMethodText,AssertMethodLineNumber) " +
                "VALUES(?,?,?,?,?,?,?,?,?)";


        PreparedStatement preparedStatement = connection.prepareStatement(sql_insertAssertMethod);
        preparedStatement.setString(1, assertMethod.getProjectName());
        preparedStatement.setString(2, assertMethod.getParentFilePath());
        preparedStatement.setString(3, assertMethod.getParentClassName());
        preparedStatement.setString(4, assertMethod.getParentMethodName());
        preparedStatement.setBoolean(5, assertMethod.isTestMethod());
        preparedStatement.setString(6, assertMethod.getAssertMethodName());
        preparedStatement.setString(7, assertMethod.getAssertMessage());
        preparedStatement.setString(8, assertMethod.getAssertMethodText());
        preparedStatement.setInt(9, assertMethod.getAssertMethodLineNumber());
        preparedStatement.executeUpdate();
    }

    public void closeConnection() throws SQLException {
        connection.close();
    }

    private void createTables() throws SQLException {

        String sqlAssertMethod = "CREATE TABLE IF NOT EXISTS assert_method (\n"
                + " Id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,\n"
                + " ProjectName TEXT,\n"
                + " FilePath TEXT,\n"
                + " ParentClassName TEXT,\n"
                + " ParentMethodName TEXT,\n"
                + " IsTestMethod TEXT,\n"
                + " AssertMethodName TEXT,\n"
                + " AssertMessage TEXT,\n"
                + " AssertMethodText TEXT,\n"
                + " AssertMethodLineNumber INTEGER\n"
                + ");";

        Statement statement = connection.createStatement();
        statement.execute(sqlAssertMethod);
    }


}
