import express from 'express';
import mailchimpConnector from './mailchimp';
const router = express.Router();

// @router   GET /api/v1/mailchimp/:subscriptionId/sync
// @desc     Performs a two-way sync of opt in preferences between MailChimp and the Gateway database
// @access   Public (key required)
router.post('/sync', async (req, res) => {
	try {
		// Check to see if header is in json format
		let parsedBody = {};
		if (req.header('content-type') === 'application/json') {
			parsedBody = req.body;
		} else {
			parsedBody = JSON.parse(req.body);
		}
		// Check for key
		if (parsedBody.key !== process.env.MAILCHIMP_SYNC_KEY) {
			return res.status(400).json({ success: false, error: 'Sync could not be started' });
		}
		// Throw error if parsing failed
		if (parsedBody.error === true) {
			throw new Error('Sync parsing error');
		}
		let { subscriptionIds = [] } = parsedBody;
		// Run sync job
		for(const subscriptionId of subscriptionIds) {
			mailchimpConnector.syncSubscriptionMembers(subscriptionId);
		}
		// Return response indicating job has started (do not await async import)
		return res.status(200).json({ success: true, message: 'Sync started' });
	} catch (err) {
		process.stdout.write(`MAILCHIP - sync : ${err.message}\n`);
		return res.status(500).json({ success: false, message: 'Sync failed' });
	}
});

module.exports = router;
