const mongoose = require('mongoose');
const { MongoMemoryServer } = require('mongodb-memory-server');
const mongod = new MongoMemoryServer();

/**
 * Connect to the in-memory database.
 */
module.exports.connect = async () => {
	const uri = await mongod.getUri();

	const mongooseOpts = {
		useNewUrlParser: true,
		useUnifiedTopology: true,
		useCreateIndex: true,
	};

	await mongoose.connect(uri, mongooseOpts);
};

/**
 * Load data into the database.
 */
module.exports.loadData = async data => {
	const queries = Object.keys(data).map(col => {
		const collection = mongoose.connection.collection(col);
		return collection.insertMany(data[col]);
	});
	return Promise.all(queries);
};

/**
 * Drop database, close the connection and stop mongod.
 */
module.exports.closeDatabase = async () => {
	await mongoose.connection.dropDatabase();
	await mongoose.connection.close(true);
	await mongod.stop();
};

/**
 * Remove all the data for all db collections.
 */
module.exports.clearDatabase = async () => {
	const collections = mongoose.connection.collections;

	for (const key in collections) {
		const collection = collections[key];
		await collection.deleteMany();
	}
};
