# General information

  - This is a repository for transistors that were modelled using the VENDES software. Information about this 3D device simulator and its developers can be found [here](./DOCS/VENDES.pdf).

  - The devices are two gate-all-around (GAA) silicon nanowire (NW) FETs classified by gate length.

  - A basic scheme of the device structure is as follows:

    <img src="./DOCS/device_scheme.png" alt="Device scheme" style="width:100%;"/>

  - For each gate length, the dimensions and doping parameters are:

    <img src="./DOCS/device_dimensions.png" alt="Device dimensions" style="width:100%;"/>

  - The [datasets](./DATASETS/) contain the off-current, threshold voltage, sub-threshold slope and on-current values for the two silicon GAA NW FETs affected by line edge roughness (LER) variability, a 22 nm gate length device and a 10 nm gate length one. The LER profile that characterizes the roughness deformation is also included in the dataset. Different correlation length (CL) and root mean square (RMS) heights values are characterized. The naming convention and the units of the different figures of merit is as follows:

    <img src="./DOCS/labels_and_units.png" alt="Naming and units" style="width:100%;"/>

  - The [MLFoMPy](https://gitlab.citius.usc.es/modev/mlfompy) tool has been used to extract all the figures of merit that compose the dataset.

  - [nano_predict](./SRC/nano_predict.py) is a Python tool that provides several regression techniques (Multi-layer Perceptron, Linear Regression, Decision Trees, Random Forest, Support Vector Machines) with the aim of predicting different figures of merit from the datasets. Its arguments are:

        -h, --help
            shows this help message and exits
        -r REGRESSOR, --regressor REGRESSOR
            MLP (0), LinearRegression (1), DTree (2), RForest (3) and SVM (4)
        -f, --finetuning
            fine-tuning (transfer learning) an existent model
        -i TRAIN_FOLDER, --train_folder TRAIN_FOLDER
            folder with train json files
        -t TEST_FOLDER, --test_folder TEST_FOLDER
            folder with test json files
        -ts TEST_SIZE, --test_size TEST_SIZE
            percentage of test examples (from 0 to 1)
        -trs TRAIN_SIZE, --train_size TRAIN_SIZE
            percentage of train examples (from 0 to 1)
        -y RESPONSE, --response RESPONSE
            name of the response variable in json files
        -nit ITERATIONS, --iterations ITERATIONS
            max. number of iterations
        -a ACTIVATION, --activation ACTIVATION
            activation function
        -s SEED, --seed SEED
            random seed
        -p PLOT, --plot PLOT
            plot true-predicted graph
