---
sidebar_position: 1
title: Add your code metadata
image: https://og.fairdataihub.org/api/ogimage?app=fairshare&title=Add%20your%20code%20metadata&description=Curate%20and%20Share%20%7C%20Research%20software
---

## Background

In order to make your research software FAIR, we will need to create a `codemeta.json` file in either your local folder or on your GitHub repository. This is a mandatory step in the FAIRifying process. This step has been divided into seven different sections that you can complete. Not every field is required but all fields are mandatory if available.

:::info
The data you provide in this step will also be used to generate a `CITATION.CFF` file. This file is used to allow other researchers to easily cite your research software.
:::

## How to

:::info
If you are using a GitHub repository as the source of your data, most of the fields in this section will be automatically filled in for you. Please verify that the fields you see are correct.
:::

### Basic information

In this section you will be asked to provide the basic information about your research software. Fields marked with an asterisk are required.

- **Software name** \*
  - This is the name of your research software.
- **Software description** \*
  - This is a short description of your research software.
- Creation date
  - This is the date that your research software was created.
- First release date
  - This is the date that your research software was first released.

![](./images/codemetaStep1.png)

### Authors and contributors

In this section you will be asked to provide the information about the authors and contributors of your research software. Fields marked with an asterisk are required.

- **Authors** \*

  - **Given name(s)** \*
    - This is the given name(s) of the author(s) of your research software.
  - Family name(s)
    - This is the family name(s) of the author(s) of your research software.
  - **Affiliation** \*
    - This is the affiliation of the author(s) of your research software.
  - E-mail address
    - This is the e-mail address of the author(s) of your research software.
  - ORCID
    - This is the ORCID of the author(s) of your research software.

- **Contributors**
  - **Contributor type** \*
    - This is the type of contributor.
  - **Given name(s)**
    - This is the given name(s) of the contributor(s) of your research software.
  - Family name(s)
    - This is the family name(s) of the contributor(s) of your research software.
  - **Affiliation**
    - This is the affiliation of the contributor(s) of your research software.
  - E-mail address
    - This is the e-mail address of the contributor(s) of your research software.
  - ORCID
    - This is the ORCID of the contributor(s) of your research software.

![](./images/codemetaStep2.png)

### Discoverability

In this section you will be asked to provide the information about the discoverability of your research software. Fields marked with an asterisk are required.

- Application category
  - This is the category of your research software.
- **Keywords** \*
  - This is the keywords of your research software.
- Funding code
  - This is the funding code of your research software.
- Funding organization
  - This is the funding organization of your research software.

![](./images/codemetaStep3.png)

### Development tools

In this section you will be asked to provide the information about the development tools used to create your research software. Fields marked with an asterisk are required.

- Code repository
  - This is the code repository of your research software.
- Continuous integration
  - This is the continuous integration of your research software.
- Issue tracker
  - This is the issue tracker of your research software.
- Related links
  - This is the related links of your research software.

![](./images/codemetaStep4.png)

### Run-time environment

In this section you will be asked to provide the information about the run-time environment of your research software. Fields marked with an asterisk are required.

- **Programming language** \*
  - This is the programming language of your research software.
- Runtime platform
  - This is the runtime platform of your research software.
- Operating system
  - This is the operating system of your research software.
- Other software requirements
  - This is the other software requirements of your research software.

![](./images/codemetaStep5.png)

### Current version of the software

In this section you will be asked to provide the information about the current version of your research software. Fields marked with an asterisk are required.

- Current version
  - This is the current version of your research software.
- Current version release date
  - This is the current version release date of your research software.
- Current version download URL
  - This is the current version download URL of your research software.
- Current version release notes
  - This is the current version release notes of your research software.

![](./images/codemetaStep6.png)

### Additional information

In this section you will be asked to provide the additional information about your research software. Fields marked with an asterisk are required.

- Reference publication
  - This is the reference publication of your research software.
- Development status
  - This is the development status of your research software.
- Is part of
  - This is the part of a larger software project of your research software.

![](./images/codemetaStep7.png)

After filling all the relevant data in the above sections, you can click on the `continue` button to move on to the next step.

import PageFeedback from "@site/src/components/PageFeedback";

<PageFeedback />
