---
sidebar_position: 1
title: How to make research software FAIR
description: How to make research software FAIR
pagination_prev: null
---

## Overview

The [Findable, Accessible, Interoperable, and Reusable (FAIR) guiding principles](https://doi.org/10.1038/sdata.2016.18) published in 2016 constitute the foundation for data management practices adopted by researchers, government agencies, private funders, and scholarly publishers to ensure optimal reusability of data by humans and machines. While postulated for all digital research objects, they fail to capture the specific traits of software such as dependencies and versioning. Consequently, reformulated FAIR guiding principles tailored for software have been proposed. Work from the [Research Data Alliance (RDA) FAIR for Research Software (FAIR4RS) Working Group](https://doi.org/10.15497/RDA00065) is the most extensive on the topic. Just like the original FAIR guiding principles, the FAIR4RS guiding principles are aspirational and do not provide practical instructions and actionable items to the researchers. To fill this gap, we derived the first minimal and actionable step-by-step guidelines for biomedical researchers to make their research software compliant with the FAIR4RS principles. We designate these guidelines as the **FAIR Biomedical Research Software (FAIR-BioRS) guidelines**. Our process for developing these guidelines, based on a thorough review of current practices in the field, is available in our associated manuscript. We refer to the [FAIR-BioRS Hub repository](https://github.com/fairdataihub/FAIR-BioRS-Hub) for a link to the manuscript and the latest version of the FAIR-BioRS guidelines.
