---
sidebar_position: 8
pagination_prev: null
pagination_next: null
title: Privacy Policy
---

In this privacy notice, we seek to explain to you in the clearest way possible what information we collect, how we use it, and what rights you have in relation to it. If you have any questions or concerns about this privacy notice or our practices with regards to your personal information, please contact us at [bPatel@fairdataihub.org](mailto:bpatel@fairdataihub.org) or https://fairdataihub.org/contact-us.

#### Last revised date

This privacy policy was last updated on 01/10/2022

<!-- ### Why do we collect information?

Tracking is implemented as part of our agreement with the SPARC program to report usage statistics for our application and related documentation. Tracking is also used to spot errors and subsequently improve user experience. -->

### What information do we collect?

We automatically collect certain information when you launch, use, or navigate FAIRshare (the `App` or `Application`). This information is collected **anonymously** and does not reveal your specific identity (like your name or contact information) but may include device and usage information, operating system, information about how you use FAIRshare, and other technical information.

For a detailed list regarding what information is tracked within FAIRshare please refer to [What do we track?](#what-do-we-track).

We employ the use of Google Analytics to track and log user events within FAIRshare. To learn more, please visit their [Terms of service](https://marketingplatform.google.com/about/analytics/terms/us/).

### How do we use the collected information?

We use the information we collect in various ways, including to:

- Provide, operate, and maintain our website and application
- Improve, personalize, and expand our website and application
- Understand and analyze how you use our website and application
- Develop new products, services, features, and functionality
- Communicate with you, either directly or through one of our partners, including for customer service, to provide you with updates and other information relating to the website, and for marketing and promotional purposes
- Generate usage analytics (number of users, features being used, etc.) for our reporting purposes.
- Find and prevent fraud

<!-- ### Will the collected information be shared with anyone?

Collected information will be shared with the SPARC management team. It may also be shared with other SPARC-funded groups as well as displayed on our [website](https://fairdataihub.org/fairshare). -->

### Do we use cookies and other tracking technologies?

We use Google's Universal Analytics program to track anonymized user interactions within FAIRshare. To learn more about the technologies used please refer to [Security and privacy in Universal Analytics](https://support.google.com/analytics/answer/2838718?hl=en).

On this documentation platform, Fair Data Innovations Hub uses cookies. These cookies are used to store information including visitors' preferences, and the pages on the website that the visitor accessed or visited. The information is used to optimize the users' experience by customizing our web page content based on visitors' browser type and/or other information.

### Log files

Fair Data Innovations Hub follows a standard procedure of using log files. These files log visitors when they visit websites. All hosting companies do this and a part of hosting services' analytics. The information collected by log files include internet protocol (IP) addresses, browser type, Internet Service Provider (ISP), date and time stamp, referring/exit pages, and possibly the number of clicks. These are not linked to any information that is personally identifiable. The purpose of the information is for analyzing trends, administering the site, tracking users' movement on the website, and gathering demographic information.

### Advertising Partners Privacy Policies

You may consult this list to find the Privacy Policy for each of the advertising partners of Fair Data Innovations Hub.

Third-party ad servers or ad networks uses technologies like cookies, JavaScript, or Web Beacons that are used in their respective advertisements and links that appear on Fair Data Innovations Hub, which are sent directly to users' browser. They automatically receive your IP address when this occurs. These technologies are used to measure the effectiveness of their advertising campaigns and/or to personalize the advertising content that you see on websites that you visit.

Note that Fair Data Innovations Hub has no access to or control over these cookies that are used by third-party advertisers.

### Third Party Privacy Policies

Fair Data Innovations Hub's Privacy Policy does not apply to other advertisers or websites. Thus, we are advising you to consult the respective Privacy Policies of these third-party ad servers for more detailed information. It may include their practices and instructions about how to opt-out of certain options.

You can choose to disable cookies through your individual browser options. To know more detailed information about cookie management with specific web browsers, it can be found at the browsers' respective websites.

### How long do we keep the collected information?

We will only keep collected usage data for as long as it is necessary for the purposes set out in this privacy notice unless a longer retention period is required or permitted by law.

### How do we keep the collected data safe?

Collected information is completely anonymized. However, despite our safeguards and efforts to secure your information, no electronic transmission over the Internet or information storage technology can be guaranteed to be 100% secure, so we cannot promise or guarantee that hackers, cyber-criminals, or other unauthorized third parties will not be able to defeat our security, and improperly collect, access, steal, or modify your information. Although we will do our best to protect your information, the transmission of personal information to and from FAIRshare is always a possible risk. You should only access FAIRshare within a secure environment.

### CCPA Privacy Rights

Under the CCPA, among other rights, California consumers have the right to:

- Request that a business that collects a consumer's personal data disclose the categories and specific pieces of personal data that a business has collected about consumers.
- Request that a business delete any personal data about the consumer that a business has collected.
- Request that a business that sells a consumer's personal data, not sell the consumer's personal data.
- If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.

### GDPR Data Protection Rights

We would like to make sure you are fully aware of all of your data protection rights. Every user is entitled to the following:

- _The right to access_ – You have the right to request copies of your personal data. We may charge you a small fee for this service.
- _The right to rectification_ – You have the right to request that we correct any information you believe is inaccurate. You also have the right to request that we complete the information you believe is incomplete.
- _The right to erasure_ – You have the right to request that we erase your personal data, under certain conditions.
- _The right to restrict processing_ – You have the right to request that we restrict the processing of your personal data, under certain conditions.
- _The right to object to processing_ – You have the right to object to our processing of your personal data, under certain conditions.
- _The right to data portability_ – You have the right to request that we transfer the data that we have collected to another organization, or directly to you, under certain conditions.

If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.

### Children's Information

Another part of our priority is adding protection for children while using the internet. We encourage parents and guardians to observe, participate in, and/or monitor and guide their online activity.

Fair Data Innovations Hub does not knowingly collect any Personal Identifiable Information from children under the age of 13. If you think that your child provided this kind of information on our website, we strongly encourage you to contact us immediately and we will do our best efforts to promptly remove such information from our records.

### What are your privacy rights?

If you are a resident in the European Economic Area and you believe we are unlawfully processing your personal information, you also have the right to complain to your local data protection supervisory authority. You can find their contact details here: http://ec.europa.eu/justice/data-protection/bodies/authorities/index_en.htm.

If you are a resident of Switzerland, the contact details for the data protection authorities are available here: https://www.edoeb.admin.ch/edoeb/en/home.html.

### Controls for do-not-track features

Most operating systems include a Do-Not-Track ("DNT") feature or setting you can activate to signal your privacy preference not to have data about your activities monitored and collected. At this stage, no uniform technology standard for recognizing and implementing DNT signals has been finalized. As such, we do not currently respond to DNT signals or any other mechanism that automatically communicates your choice not to be tracked online. If a standard for online tracking is adopted that we must follow in the future, we will inform you about that practice in a revised version of this privacy notice.

### Do California residents have specific privacy rights?

_In Short: Yes, if you are a resident of California, you are granted specific rights regarding access to your personal information._

California Civil Code Section 1798.83, also known as the "Shine The Light" law, permits our users who are California residents to request and obtain from us, once a year and free of charge, information about categories of personal information (if any) we disclosed to third parties for direct marketing purposes and the names and addresses of all third parties with which we shared personal information in the immediately preceding calendar year. If you are a California resident and would like to make such a request, please submit your request in writing to us using the contact information provided below.

If you are under 18 years of age, reside in California, you have the right to request the removal of unwanted data. To request the removal of such data, please contact us using the contact information provided below, and include a statement that you reside in California. We will make sure the data is not tracked by FAIRshare, but please be aware that the data may not be completely or comprehensively removed from all our systems (e.g. backups, etc.).

### Do we make updates to this notice?

We may update this privacy notice from time to time. The updated version will be indicated by an updated [revised date](#last-revised-date) and the updated version will be effective as soon as it is accessible. If we make material changes to this privacy notice, we may notify you either by prominently posting a notice of such changes or by directly sending you a notification. We encourage you to review this privacy notice frequently to be informed of how we are protecting your information.

### How can you review, update, or delete the data we collect from you?

Based on your country's applicable laws, you may have the right to request access to the information we collect from you, change that information, or delete it in some circumstances. To request to review, update, or delete your personal information, please submit a request to [bPatel@fairdataihub.org](mailto:bpatel@fairdataihub.org). Alternatively, you can also use [our feedback form](https://fairdataihub.org/contact-us). We will respond to your request within 30 days.

<!-- ### What do we track?

All the information that is tracked within FAIRshare is anonymized with privacy in mind. We do not track any passwords, personal details, or other identifying information. The following items are tracked within FAIRshare:

- When SODA is opened:
  - Operating system version
  - App version
  - Success/Errors when connecting to the back-end system
- When you add/connect to your Pennsieve account:
  - Success/Errors with the connection
- When you create an empty dataset:
  - Success/Errors with the creation
  - The name of the dataset as well as the dataset ID
- When you rename an existing dataset:
  - Success/Errors with the renaming
  - The dataset's ID as well as the old and new names of the dataset
- When you upload a local dataset or organize and generate a dataset using SODA:
  - Success/Errors with the upload
  - The name of the dataset
  - The size of the dataset
  - The number of files in the dataset
  - The number of folders in the dataset
  - The point of origin of the dataset
  - The destination of the dataset
  - The merge details when uploading onto an existing Pennsieve dataset
  - The number and name of the metadata files imported
  - The amount of imported files and/or folders
  - The amount of folders created in SODA
  - The point of origin of the imported metadata files
- When you organize or generate or upload a dataset using SODA:
  - Success/Errors with the upload
  - The size of the dataset
  - The number of files in the dataset
  - The point of origin of the dataset
  - The number and name of the metadata files imported
  - The dataset ID and/or name
  - The destination of the dataset
  - The merge details when uploading onto an existing Pennsieve dataset
  - The number and name of the metadata files imported
  - The point of origin of the imported metadata files
  - The amount of imported files and/or folders
  - The amount of folders created in SODA
- When you make a PI the owner of your dataset:
  - Success/Errors with the change in permission
  - The name and/or ID of the dataset
- When you modify a user's or team's permissions to your dataset:
  - Success/Errors with the change in permission
  - The name and/or ID of the dataset
- When you add/edit a dataset's subtitle:
  - Success/Errors with the change in the subtitle
  - Success/Errors with getting the subtitle
  - The name and/or ID of the dataset
- When you add/edit a dataset's description:
  - Success/Errors with the change in the description
  - Success/Errors with getting the description
  - Success/Errors with parsing the description
  - The name and/or ID of the dataset
- When you import a banner image from Pennsieve :
  - Success/Errors with the import
  - The name and/or ID of the dataset
- When you upload a banner image for the dataset:
  - Success/Errors with the upload
  - The name and/or ID of the dataset
  - The file size of the banner image
- When you assign a license to the dataset:
  - Success/Errors with the assignment
  - Success/Errors with getting the license
  - The name and/or ID of the dataset
- When you add/edit a dataset's tags:
  - Success/Error with the change in tags
  - Success/Errors with getting the tags
  - The name and/or ID of the dataset
- When you change a dataset's curation status:
  - Success/Errors with the change in status
  - Success/Errors in getting the dataset status
  - The name and/or ID of the dataset
- When you create submission.xlsx metadata file:
  - Success/Errors with the creation
  - Success/Errors with using an existing submission.xlsx file
  - The point of origin of an existing submission.xlsx file
  - The destination of a created submission.xlsx file
  - The name and/or ID of the dataset
- When you create dataset_description.xlsx metadata file:
  - Success/Errors with the creation
  - Success/Errors with using an existing dataset_description.xlsx file
  - The point of origin of an existing dataset_description.xlsx file
  - The destination of a created dataset_description.xlsx file
  - The name and/or ID of the dataset
- When you create subjects.xlsx metadata file:
  - Success/Errors with the creation
  - Success/Errors with using an existing subjects.xlsx file
  - The point of origin of an existing subjects.xlsx file
  - The destination of a created subjects.xlsx file
  - The name and/or ID of the dataset
- When you create samples.xlsx metadata file:
  - Success/Errors with the creation
  - Success/Errors with using an existing samples.xlsx file
  - The point of origin of an existing samples.xlsx file
  - The destination of a created samples.xlsx file
  - The name and/or ID of the dataset
- When you create README.xlsx metadata file:
  - Success/Errors with the creation
  - Success/Errors with using an existing README.xlsx file
  - The point of origin of an existing README.xlsx file
  - The destination of a created README.xlsx file
  - The name and/or ID of the dataset
- When you create CHANGES.xlsx metadata file:
  - Success/Errors with the creation
  - Success/Errors with using an existing CHANGES.xlsx file
  - The point of origin of an existing CHANGES.xlsx file
  - The destination of a created CHANGES.xlsx file
  - The name and/or ID of the dataset
- When you create manifest files with SODA:
  - Success/Errors with the creation
  - Success/Errors with using an existing manifest file
  - The point of origin of an existing manifest file
  - The destination of a created manifest file
  - The name and/or ID of the dataset
- When you import a Data Deliverable document:
  - Success/Errors with the import process
- When you create dataset_description.xlsx metadata file:
  - Success/Errors with the creation
  - The name of the dataset
- When you download a metadata file template:
  - Success/Errors with the download
  - The name of the metadata file
- When you share a dataset with the Curation Team:
  - Success/Errors with the process required to share a dataset with the Curation Team
  - The dataset's status
  - The Consortium's dataset permission
  - The name and/or ID of the dataset
- When a dataset is unshared with the Curation Team:
  - Success/Errors with the process required to make the dataset unshared with the Curation Team
  - The dataset's status
  - The Consortium's dataset permission
  - The name and/or ID of the dataset
- When you share a dataset with the SPARC Consortium:
  - Success/Errors with the process required to share a dataset with the SPARC Consortium
  - The dataset's status
  - The Consortium's dataset permission
- When a dataset is unshared with the SPARC Consortium:
  - Success/Errors with the process required to make the dataset unshared with the SPARC Consortium
  - The dataset's status
  - The Consortium's dataset permission
- When you submit a dataset for Pre-Publishing Review:
  - Success/Errors with the submission
  - Success/Errors with getting a list of excluded files
  - Success/Errors with updating your list of excluded files
  - Success/Errors with determining a user's dataset role
  - Success/Errors with validating the dataset's description, tags, subtitle, banner image, license.
  - Success/Errors with getting the dataset owner's ORCID iD.
  - Errors with getting the dataset's updated publishing status
  - The name and/or ID of the dataset
- When you withdraw a dataset from Pre-publishing Review:
  - Success/Errors with withdrawing the dataset
  - Errors with getting the dataset's updated publishing status
  - The dataset name and/or ID
- When you update SODA
  - Operating system version
  - SODA version
- When you change a dataset in SODA:
  - Success/Errors with getting the dataset's Review status
  - Success/Errors with getting the dataset's tags
  - Success/Errors with getting the dataset's description
  - Success/Errors with getting the dataset's banner image
  - Success/Errors with getting the dataset's license
  - Success/Errors with getting the dataset's subtitle
  - Success/Errors with getting the dataset's permissions
  - Success/Errors with getting the dataset's owner
  - Success/Errors with getting the dataset's statuses
  - The dataset name and/or ID
- When you integrate your Pennsieve account with ORCID iD:
  - Success/Errors with integrating
  - The dataset name and/or ID -->

import PageFeedback from '@site/src/components/PageFeedback';

<PageFeedback />
