---
sidebar_position: 10
pagination_prev: null
pagination_next: null
title: Cookie Policy
---

## What Are Cookies?

As is common practice with almost all professional websites this site uses cookies, which are tiny files that are downloaded to your computer, to improve your experience. This page describes what information they gather, how we use it and why we sometimes need to store these cookies. We will also share how you can prevent these cookies from being stored however this may downgrade or 'break' certain elements of the sites functionality.

For more information, please visit [AllAboutCookies.org](https://www.allaboutcookies.org/).

## How We Use Cookies

We use cookies for a variety of reasons detailed below. Unfortunately in most cases there are no industry standard options for disabling cookies without completely disabling the functionality and features they add to this site. It is recommended that you leave on all cookies if you are not sure whether you need them or not in case they are used to provide a service that you use.

## Disabling Cookies

At the moment we do not have the functionality to disable cookies from the website. In order to prevent any tracking by third party analysis and measurement tools we use, please follow the steps provided below for your specific browser.

## Find out how to manage cookies on popular browsers

- [Google Chrome](https://support.google.com/accounts/answer/61416)
- [Mozilla Firefox](https://support.mozilla.org/en-US/kb/enable-and-disable-cookies-website-preferences)
- [Apple Safari](https://support.apple.com/en-gb/guide/safari/sfri11471/mac)
- [Microsoft Edge](https://support.microsoft.com/sr-latn-rs/help/4468242/microsoft-edge-browsing-data-and-privacy-microsoft-privacy)
- [Microsoft Internet Explorer](https://support.microsoft.com/en-gb/help/17442/windows-internet-explorer-delete-manage-cookies)
- [Opera](https://help.opera.com/en/latest/web-preferences/#cookies)

To find information relating to other browsers, visit the browser developer's website.

To opt-out of being tracked by Google Analytics across all websites, visit http://tools.google.com/dlpage/gaoptout

You can also visit the trade body representing these advertising platforms for more information: [Network Advertising Initiative](https://www.networkadvertising.org/choices/;).

When you access third party sites on our Sites, or when you are reading integration or social media links, cookies can be created by the companies disseminating these links. These third parties may be able to use cookies in the context of Fair Data Innovations Hub's Services (partners or other third parties supplying content or services available on the Fair Data Innovations Hub site) and are responsible for the cookies they install, and it is their conditions on cookies which apply. For more information, you are advised to check the cookie policy directly on these third-party sites concerning their use of cookies.

## The Cookies We Set

Site preferences cookies - In order to provide you with a great experience on this site we provide the functionality to set your preferences for how this site runs when you use it. In order to remember your preferences we need to set cookies so that this information can be called whenever you interact with a page is affected by your preferences.
##Third Party Cookies
In some special cases we also use cookies provided by trusted third parties. The following section details which third party cookies you might encounter through this site.

- This site uses Google Analytics which is one of the most widespread and trusted analytics solution on the web for helping us to understand how you use the site and ways that we can improve - your experience. These cookies may track things such as how long you spend on the site and the pages that you visit so we can continue to produce engaging content. For more information on Google Analytics cookies, see the official [Google Analytics](https://policies.google.com/privacy?hl=en-US) page.
- Third party analytics are used to track and measure usage of this site so that we can continue to produce engaging content. These cookies may track things such as how long you spend on the - site or pages you visit which helps us to understand how we can improve the site for you.
- From time to time we test new features and make subtle changes to the way that the site is delivered. When we are still testing new features these cookies may be used to ensure that you - receive a consistent experience whilst on the site whilst ensuring we understand which optimisations our users appreciate the most.
- As we sell products it's important for us to understand statistics about how many of the visitors to our site actually make a purchase and as such this is the kind of data that these cookies - will track. This is important to you as it means that we can accurately make business predictions that allow us to monitor our advertising and product costs to ensure the best possible price.
- We also use social media buttons and/or plugins on this site that allow you to connect with your social network in various ways. For these to work the following social media sites including - Twitter, Facebook, Instagram, etc., will set cookies through our site which may be used to enhance your profile on their site or contribute to the data they hold for various purposes outlined in their respective privacy policies.

## Questions and complaints

Please feel free to contact us if you have any questions or complaints about Fair Data Innovation Hub's Cookie Policy.

**Address**: 11107 Roselle St. Ste #211 San Diego, CA 92121

**Contact form**: https://fairdataihub.org/contact-us

**Email**: info@fairdataihub.org

import PageFeedback from '@site/src/components/PageFeedback';

<PageFeedback />
