!dirac_copyright_start
!      Copyright (c) by the authors of DIRAC.
!
!      This program is free software; you can redistribute it and/or
!      modify it under the terms of the GNU Lesser General Public
!      License version 2.1 as published by the Free Software Foundation.
!
!      This program is distributed in the hope that it will be useful,
!      but WITHOUT ANY WARRANTY; without even the implied warranty of
!      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!      Lesser General Public License for more details.
!
!      If a copy of the GNU LGPL v2.1 was not distributed with this
!      code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
!dirac_copyright_end

! define task symbols for CALL DIRAC_PARCTL( task )
#include "dirac_partask.h"
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck TRDR6T */
      SUBROUTINE TRDR6T(WORK,KFREE,LFREE,IPRINT,INTFLG,KGAB,KDRIJ,
     &                  NSTR,ANTIS,LMP2,KINDX,KQ,KE,KIBE,DINTSKP)
C***********************************************************************
C
C     Driver for scheme 6: (pq|rs) --> (ij|kl)
C     Loop over distributions (**|rs), transform 2 indices 
C     (**|rs) --> (kl|rs) and write half-transformed integrals 
C     (kl|rs) to disk in (l)-batches. Read the (l) batches and
C     transform the remaining indices (rs|kl) --> (ij|kl).
C
C     Parallelization is done in the first half-transformation by
C     distributing the shell pairs (pq) and (after synchronization)
C     in the second half transformation by distributing the last
C     index (l). 
C
C     * VECTORS:  
C       Qi             - coefficients for index i
C       NSTR(ifrp,0,i) - total number of orbitals for index i
C       NSTR(ifrp,1,i) - number of electronic orbitals for index i
C       NSTR(ifrp,2,i) - number of positronic orbitals for index i
C     * AO-INTEGRALS:
C     Distributions (pq|**) are fetched by CALDIS and are packed on
C     boson irreps. The information necessary for symmetry packing
C     is provided by the integer array INDX (generated by NINSH):
C       INDX(1,INDA)   - Position of function in block
C       INDX(2,INDA)   - Irreducible representation of function
C       INDX(3,INDA)   - Position of function within this particular irrep
C                        and block
C                        (INDA refers to index of SO-orbital)
C     * CONTROL INFORMATION:
C       LMP2  = .TRUE. - evaluate MP2 energy
C       EIG            - eigenvalues (for  MP2 calculation)
C       ANTIS = .TRUE. - anti-symmetrize integrals
C       INTFLG - flag of what integral types to transform
C
C     
C     Written by Luuk Visscher, August 2004
C
C***********************************************************************
      use interface_to_mpi
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0=0.0D0)
#include "maxorb.h"
#include "aovec.h"
#include "infpar.h"
#if defined (VAR_MPI)
      DIMENSION IBUFMPI(5)
#endif
#include "dcbgen.h"
#include "dcborb.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbbas.h"
#include "dgroup.h"

#include "blocks.h"
      LOGICAL ANTIS,LMP2,TRIAN(2)
      DIMENSION NSTR(2,0:2,4),
     &          KQ(2,4),KE(2,4),KIBE(2,4),WORK(*),DINTSKP(*)
#if defined (VAR_MPI)
      REAL*8 XINTSTAT(8)
      INTEGER ILEN_STAT
#endif
      Integer, Allocatable :: LSORT(:,:,:)
      Integer, Allocatable :: INDXB12(:,:),INDXB34(:,:),INDXKR12(:,:)
C
      CALL QENTER('TRDR6T')
      KFRSAV = KFREE
C     Initialize the timing
      CALL XTIME(0,-1,'                              ')
C
C     Define the packing of the 4-index transformed integrals
C
      TRIAN(1) = .FALSE.
      TRIAN(2) = .FALSE.
C     TRIAN(2) = ISAME(3).EQ.ISAME(4)
      CALL PCK2IN(NSTR,TRIAN,IPRINT)
C 
C     For parallel calculations :
C
C     Define the distribution of the final integrals over the nodes,
C     each node will transform and store a subset of the second index.
C     This will also define the sorting step for the halftransformed
C     integrals.
C
C     For serial calculations :
C    
C     The subsets of the second index are only used to sort the halftransformed
C     integrals. All integrals are stored in one file.
C
      NSTR1T = 0
      NSTR2T = 0
      DO IREPI = 1, NFSYM
         NSTR1T = NSTR1T + NSTR(IREPI,0,1)
         NSTR2T = NSTR2T + NSTR(IREPI,0,2)
      ENDDO

      Allocate (LSORT(3,NFPCK12T,0:7),stat=istat)
      If (istat.ne.0) then
         Write(LUPRI,*) 
     &  'Integer allocation LSORT(3,NFPCK12T,0:7) failed, where'//
     &       ' NFPCK12T=',NFPCK12T
         call quit('Integer allocation LSORT(3,NFPCK12T,0:7) failed')
      endif
      CALL DEFINE_SORT (NSTR,NSTR1T,NSTR2T,TRIAN,MEM,KL_IN_BUF,
     &                  LSORT,IPRINT)
C
C     Initialize the buffer files for the halftransformed integrals
C
      CALL BUFFER_FILE_INIT (1)
C
C     Perform the first half transformation
C
      CALL XTIME(5,1,' First halftransformation      ')
#if defined (VAR_MPI)
      IF (.NOT.PARCAL) THEN
#endif
         CALL FIRST_HALFTR_SERIAL (WORK,KFREE,LFREE,IPRINT,INTFLG,
     &                     NSTR,ANTIS,LMP2,KINDX,KQ,KE,KIBE,DINTSKP,
     &                     KGAB,KDRIJ,MEM,LSORT)
#if defined (VAR_MPI)
      ELSE
         CALL FIRST_HALFTR_PARALLEL (WORK,KFREE,LFREE,IPRINT,INTFLG,
     &                     NSTR,ANTIS,LMP2,KINDX,KQ,KE,KIBE,DINTSKP,
     &                     KGAB,KDRIJ,MEM,LSORT)
      ENDIF
#endif
      CALL XTIME(5,2,' First halftransformation      ')
C
C     Initialize MOLFDIR integral file
C
      IF (NOMDCINT) THEN
         CALL QUIT('ERROR:'//
     &   ' .NOMDCINT not valid for strategy 6 integral transformation')
      END IF
      CALL MDINTI(NSTR,IPRINT)

C
C     Make index arrays to translate pair index to individual indices
C
      Allocate (INDXKR12(NFPCK12T,2),stat=istat)
      If (istat.ne.0) then
          Write(LUPRI,*) 
     &    'Integer allocation INDXKR12(NFPCK12T,2) failed, where'//
     &   ' NFPCK12T=',NFPCK12T
          call quit('Integer allocation INDXKR12(NFPCK12T,2) failed!')
      endif
      Allocate (INDXB12 (NFPCK12T,2),stat=istat)
      If (istat.ne.0) then
        Write(LUPRI,*) 
     &  'Integer allocation INDXB12(NFPCK12T,2) failed, where'//
     &     ' NFPCK12T=',NFPCK12T
        call quit('Integer allocation INDXB12(NFPCK12T,2) failed!')
      endif
      Allocate (INDXB34 (NFPCK34T,2),stat=istat)
      If (istat.ne.0) then
        Write(LUPRI,*) 
     &  'Integer allocation INDXB34(NFPCK12T,2) failed, where'//
     &     ' NFPCK12T=',NFPCK12T
        call quit('Integer allocation INDXB34(NFPCK12T,2) failed!')
      endif

      CALL MKINDXKR (NSTR,.FALSE.,INDXKR12)
 
!     FIXME: out-of-bounds access possible when no inversion symmetry present
!    &              WORK(KIBE(1,2)),WORK(KIBE(2,2)),
!    miro: easy fix
      I_KIBE11=KIBE(1,1)
      IF (KIBE(1,1).LE.0) I_KIBE11=1
      I_KIBE21=KIBE(2,1)
      IF (KIBE(2,1).LE.0) I_KIBE21=1
      I_KIBE12=KIBE(1,2)
      IF (KIBE(1,2).LE.0) I_KIBE12=1
      I_KIBE22=KIBE(2,2)
      IF (KIBE(2,2).LE.0) I_KIBE22=1
      CALL MKINDXB (NSTR,WORK(I_KIBE11),WORK(I_KIBE21),
     &              WORK(I_KIBE12),WORK(I_KIBE22),
     &              .FALSE.,INDXB12)
!     FIXME: out-of-bounds access possible when no inversion symmetry present
!    &              WORK(KIBE(1,4)),WORK(KIBE(2,4)),
!    miro: easy fix
      I_KIBE13=KIBE(1,3)
      IF (KIBE(1,3).LE.0) I_KIBE13=1
      I_KIBE23=KIBE(2,3)
      IF (KIBE(2,3).LE.0) I_KIBE23=1
      I_KIBE14=KIBE(1,4)
      IF (KIBE(1,4).LE.0) I_KIBE14=1
      I_KIBE24=KIBE(2,4)
      IF (KIBE(2,4).LE.0) I_KIBE24=1
      CALL MKINDXB (NSTR,WORK(I_KIBE13),WORK(I_KIBE23),
     &              WORK(I_KIBE14),WORK(I_KIBE24),
     &              .FALSE.,INDXB34)
C
C     Perform the second half transformation
C
      CALL XTIME(5,1,' Second halftransformation     ')
      ICS = 1
      ICF = 2
      CALL MS6IN2 (WORK,KFREE,LFREE,IPRINT,ICS,ICF,
     &             NSTR,NDMOQR(1,1,3),ICMOQR(1,3),
     &             NFPCK12,WORK(KQ(1,3)),WORK(KQ(1,4)),
     &             LSORT,INDXKR12,
     &             INDXB12,INDXB34)
C
      DeAllocate (INDXKR12)
      DeAllocate (INDXB12)
      DeAllocate (INDXB34)
      CALL XTIME(5,2,' Second halftransformation     ')
C     
C     Close integral file
C     
      CALL MDINTF  
C
C     Remove buffer file
C
      CALL BUFFER_FILE_REMOVE (1)
      DeAllocate (LSORT)
C
C     Screening statistics
C     Note : it would be more logical to have the call to MPI_REDUCE inside
C     ST4SCR, but this would create a conflict with the other transformation schemes.
C
#if defined (VAR_MPI)
CSK   ... safe implementation
      IF (PARCAL) THEN
         ILEN_STAT = 8
         CALL DZERO(XINTSTAT,ILEN_STAT)
         CALL DCOPY(ILEN_STAT,DINTSKP,1,XINTSTAT,1)
         call interface_mpi_reduce_r1_work_f77(XINTSTAT,DINTSKP,
     &           ILEN_STAT,op_MPI_SUM,MPARID,global_communicator)
      END IF
#endif
      IF(SCRTRA.GT.D0.AND.MYTID.EQ.0) CALL ST4SCR(DINTSKP)
C
C     Print timing report
C
      CALL XTIME(0,4,' integral transformation      ')
C
C     It is the masters duty to release the slaves
C
      IF (PARCAL.AND.MYTID.EQ.MPARID) CALL DIRAC_PARCTL( EXIT_NODEMENU )
C
      CALL MEMREL('TRDR6T',WORK,KFRSAV,KFRSAV,KFREE,LFREE)
      CALL QEXIT('TRDR6T')
C
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck First_HalfTr_Serial */
      SUBROUTINE FIRST_HALFTR_SERIAL (WORK,KFREE,LFREE,IPRINT,INTFLG,
     &                  NSTR,ANTIS,LMP2,KINDX,KQ,KE,KIBE,DINTSKP,
     &                  KGAB,KDRIJ,MEM,LSORT)
C***********************************************************************
C
C     Loop over distributions (**|rs), transform 2 indices 
C     (**|rs) --> (kl|rs) and write half-transformed integrals 
C     (kl|rs) to disk in (l)-batches.
C
C     * VECTORS:  
C       Qi             - coefficients for index i
C       NSTR(ifrp,0,i) - total number of orbitals for index i
C       NSTR(ifrp,1,i) - number of electronic orbitals for index i
C       NSTR(ifrp,2,i) - number of positronic orbitals for index i
C     * AO-INTEGRALS:
C     Distributions (pq|**) are fetched by CALDIS and are packed on
C     boson irreps. The information necessary for symmetry packing
C     is provided by the integer array INDX (generated by NINSH):
C       INDX(1,INDA)   - Position of function in block
C       INDX(2,INDA)   - Irreducible representation of function
C       INDX(3,INDA)   - Position of function within this particular irrep
C                        and block
C                        (INDA refers to index of SO-orbital)
C       INTFLG - flag of what integral types to transform
C
C     
C     Written by Luuk Visscher, August 2004
C
C***********************************************************************
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0=0.0D0)
#include "maxorb.h"
#include "aovec.h"
#include "dcbgen.h"
#include "dcborb.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbbas.h"
#include "dgroup.h"

#include "blocks.h"
      DIMENSION LSORT(3,NFPCK12T,0:7)
      Real(8), Allocatable :: RGBUF(:)
      Integer, Allocatable :: IGBUF(:,:)
      LOGICAL ANTIS,LMP2,TRIAN(2)
      DIMENSION NSTR(2,0:2,4),
     &          KQ(2,4),KE(2,4),KIBE(2,4),WORK(*),DINTSKP(*)
      CHARACTER*7 CIC(3)
      DATA CIC/'(LL|??)', '(SS|??)', '(LS|??)'/
C
      Allocate (RGBUF(MEM),stat=istat)
      If (istat.ne.0) then
         Write(LUPRI,*)
     &      "Real*8 allocation of RGBUF(MEM) failed,MEM=",MEM
         Call Quit('Real*8 allocation of RGBUF(MEM) failed')
      EndIf
      Allocate (IGBUF(2,MEM),stat=istat)
      If (istat.ne.0) then
         Write(LUPRI,*)
     &      "Integer allocation of IGBUF(MEM) failed,MEM=",MEM
         Call Quit('Integer allocation of IGBUF(MEM) failed')
      EndIf
      CALL GETTIM(CPUBEF,WALLBEF)
      DO IC = 1, 2
CLV:Gaunt       DO IC = 1, 3
          WRITE(LUPRI,'(A,I2,2A)') ' - Integral class',IC,' : ',CIC(IC)
          CALL SHRNGE (IC,INTFLG,I2TYP,IASTRT,IBSTRT,IASMAX,IBSMAX)
          DO ISHLA = IASTRT, IASMAX
             CALL GETTIM(CPUST,WALLST)
             IF (IC.LE.2) THEN
                IBEND = ISHLA
                WRITE(LUPRI,'(3X,2(A,I4),A,F8.0,A,F8.0,A)') 
     &             '- Beginning task',ISHLA,' of',IASMAX,
     &             ' after',WALLST-WALLBEF,' seconds and',
     &             CPUST-CPUBEF,' CPU-seconds'
             ELSE
                IBEND = IBSMAX
                WRITE(LUPRI,'(3X,2(A,I4),A,F8.0,A,F8.0,A)') 
     &             '- Beginning Gaunt task',ISHLA-IASTRT+1,
     &             ' of',IASMAX-IASTRT+1,
     &             ' after',WALLST-WALLBEF,' seconds and',
     &             CPUST-CPUBEF,' CPU-seconds'
             ENDIF
             CALL FLSHFO(LUPRI)
             CALL TRDRV6(WORK,KFREE,LFREE,IPRINT,INTFLG,
     &                  NSTR,WORK(KINDX),TRIAN,
     &                  KQ,KE,KIBE,IC,I2TYP,IBSTRT,IBEND,
     &                  WORK(KGAB),WORK(KDRIJ),DINTSKP,
     &                  LSORT,RGBUF,IGBUF)
          ENDDO
      ENDDO
      CALL BUFFER_FILE_FLUSH (1,RGBUF,IGBUF,LSORT,NFPCK12T*NBSYM)
      DeAllocate (RGBUF)
      DeAllocate (IGBUF)
#if defined (VAR_PFS)
       CALL GLOBAL_FILE_CLOSE_WRITE
#endif
       RETURN
       END
#if defined (VAR_MPI)
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck First_HalfTr_Parallel */
      SUBROUTINE FIRST_HALFTR_PARALLEL (WORK,KFREE,LFREE,IPRINT,INTFLG,
     &                  NSTR,ANTIS,LMP2,KINDX,KQ,KE,KIBE,DINTSKP,
     &                  KGAB,KDRIJ,MEM,LSORT)
C***********************************************************************
C
C     Loop over distributions (**|rs), transform 2 indices 
C     (**|rs) --> (kl|rs) and write half-transformed integrals 
C     (kl|rs) to disk in (l)-batches.
C
C     * VECTORS:  
C       Qi             - coefficients for index i
C       NSTR(ifrp,0,i) - total number of orbitals for index i
C       NSTR(ifrp,1,i) - number of electronic orbitals for index i
C       NSTR(ifrp,2,i) - number of positronic orbitals for index i
C     * AO-INTEGRALS:
C     Distributions (pq|**) are fetched by CALDIS and are packed on
C     boson irreps. The information necessary for symmetry packing
C     is provided by the integer array INDX (generated by NINSH):
C       INDX(1,INDA)   - Position of function in block
C       INDX(2,INDA)   - Irreducible representation of function
C       INDX(3,INDA)   - Position of function within this particular irrep
C                        and block
C                        (INDA refers to index of SO-orbital)
C       INTFLG - flag of what integral types to transform
C
C     
C     Written by Luuk Visscher, August 2004
C
C***********************************************************************
      use interface_to_mpi
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0=0.0D0)
#include "maxorb.h"
#include "aovec.h"
#include "infpar.h"
      INTEGER ISTAT(df_MPI_STATUS_SIZE), IBUFMPI(5)
#include "dcbgen.h"
#include "dcborb.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbbas.h"
#include "dgroup.h"

#include "blocks.h"
      DIMENSION LSORT(3,NFPCK12T,0:7)
      Real(8), Allocatable :: RGBUF(:)
      Integer, Allocatable :: IGBUF(:,:)
      LOGICAL ANTIS,LMP2,TRIAN(2)
      DIMENSION NSTR(2,0:2,4),
     &          KQ(2,4),KE(2,4),KIBE(2,4),WORK(*),DINTSKP(*)
      CHARACTER*7 CIC(3)
      DATA CIC/'(LL|??)', '(SS|??)', '(LS|??)'/
C
C
      IF (MYTID.EQ.0) THEN
C
C       Get hold of the slaves
C       ( MOLTRA_PAR from dirac_partask.h is code for parallel integral transformation )
C
        CALL DIRAC_PARCTL( MOLTRA_PAR )
C       
C       Initialize (for the slave this is done in TRANOD)
C
        CALL TRAPARI(WORK,KFREE,LFREE,KQ,KE,KIBE,
     &               KINDX,KGAB,KDRIJ,INTFLG,NSTR,ANTIS,LMP2)
C
C     We send out all the tasks (shell pairs in this case) to the slaves
C     - reverse order of IC and ISHLA to get better load balancing
C       - S blocks are generally bigger than L blocks
C       - if IBSTEP is big the load is generally larger for bigger ISHLA
C         because ISHLB loop in TRDRV4 must end at ISHLA
C         
C       FIXME: calculate IBSTEP dynamically based on number of nodes
C       and size of shells.
C       (currently, it is just an input parameter for the wizards)
        MXIBSTEP = IPAR4BS
        IF (MXIBSTEP .LE. 0) THEN
C           ... determine MXIBSTEP based on number of nodes and
C               number of shell pairs to give optimal load balancing
C               (minimize N**5*nbstep in second half transformation
C                while having work for all nodes) /LV+HJAaJ Aug 2001
C
           MXIBSTEP = NTR4BSTEP(INTFLG,I2TYP,NODES)
           WRITE(LUPRI,'(/A,I4)')
     &     ' * Max no. of B shells in a task determined to be',
     &     MXIBSTEP
        END IF
C
        CALL GETTIM(CPUBEF,WALLBEF)
        DO IC = 2, 1, -1
CLV: Gaunt        DO IC = 3, 1, -1
           WRITE(LUPRI,'(A,I2,2A)') ' - Integral class',IC,' : ',CIC(IC)
           CALL SHRNGE (IC,INTFLG,I2TYP,IASTRT,IBSTRT,IASMAX,IBSMAX)
           IBUFMPI(1) = IC
           IBUFMPI(2) = I2TYP
           DO ISHLA = IASMAX, IASTRT, -1
              IBUFMPI(3) = ISHLA
              CALL GETTIM(CPUST,WALLST)
              WRITE(LUPRI,'(3X,A,I4,A,F14.2,A)')
     &           '- Starting shell A no. ',ISHLA,' after ',
     &           WALLST - WALLBEF,' seconds.'
              CALL FLSHFO(LUPRI)
              IF (IC.LE.2) THEN
                 IBLAST = ISHLA
              ELSE
                 IBLAST = IBSMAX
              ENDIF
C             Distribute number of B's evenly
              NBSTEP = (IBLAST-IBSTRT)/MXIBSTEP + 1
              IBSTEP = -(IBLAST-IBSTRT)/NBSTEP - 1
           DO IBEND = IBLAST, IBSTRT, IBSTEP
C
              ISHLB = MAX(IBEND+IBSTEP+1,IBSTRT)
              IBUFMPI(4) = ISHLB
              IBUFMPI(5) = IBEND
C
              CALL XTIME(2,1,' Slave requesting task from master')
   10         CONTINUE
              CALL interface_MPI_PROBE(df_MPI_ANY_SOURCE,df_MPI_ANY_TAG,
     &                                 global_communicator,ISTAT)
              NWHO = ISTAT(df_MPI_SOURCE)
              IF (ISTAT(df_MPI_TAG).EQ.20) THEN
                 CALL interface_MPI_RECV(ITEST,1,NWHO,20,
     &                                   global_communicator)
              ELSE
                 CALL BUFFER_FILE_RECV ()
                 GOTO 10
              ENDIF
              CALL XTIME(2,2,' Slave requesting task from master')
              IF (ITEST .EQ. 0) THEN
C                ... slave wants new set of A,B shells
                 CALL GETTIM(CPUST,WALLST)
                 IF (IPRINT .GE. 1) THEN
                    WRITE(LUPRI,'(3X,4(A,I4),A,F10.2,A)') 
     &                 '- Sending shells (',ISHLA,',',ISHLB,
     &                 '-',IBEND,') to node',NWHO,
     &                 ' after',WALLST-WALLBEF,' seconds'
                    CALL FLSHFO(LUPRI)
                 END IF
                 CALL XTIME(3,1,' Master and slave negotiating task')
                 CALL interface_MPI_SEND(IBUFMPI,5,NWHO,30,
     &                      global_communicator)
                 CALL XTIME(3,2,' Master and slave negotiating task')
              ELSE
                 CALL QUIT('Illegal ITEST')
              END IF
           ENDDO
           ENDDO
        ENDDO
C
      ELSE
C
C     This is a slave process. Wait for tasks until we receive the end message.
C
         Allocate (RGBUF(MEM))
         Allocate (IGBUF(2,MEM))
  100    CONTINUE
         ITEST = 0
C        ... ask for new set of A,B shells
         CALL XTIME(2,1,' Slave requesting task from master')
         CALL interface_MPI_SEND(ITEST,1,MPARID,20,
     &                           global_communicator)
         CALL interface_MPI_RECV(IBUFMPI,5,MPARID,30,
     &                           global_communicator)
         IC     = IBUFMPI(1)
         I2TYP  = IBUFMPI(2)
         ISHLA  = IBUFMPI(3)
         ISHLBS = IBUFMPI(4)
         ISHLBE = IBUFMPI(5)
         CALL XTIME(2,2,' Slave requesting task from master')
         IF (ISHLA.EQ.-1) GOTO 200
C
C        ISHLB range: ISHLBS to ISHLBE
C
         CALL TRDRV6(WORK,KFREE,LFREE,IPRINT,INTFLG,
     &               NSTR(1,0,1),WORK(KINDX),TRIAN,
     &               KQ,KE,KIBE,IC,I2TYP,ISHLBS,ISHLBE,
     &               WORK(KGAB),WORK(KDRIJ),DINTSKP,
     &               LSORT,RGBUF,IGBUF)
         GOTO 100
  200    CONTINUE
      ENDIF
C
C     Flush the buffers and end the communication
C
      IF (MYTID.EQ.0) THEN
         CALL BUFFER_FILE_END ()
      ELSE
         CALL BUFFER_FILE_FLUSH (1,RGBUF,IGBUF,LSORT,NFPCK12T*NBSYM)
         CALL BUFFER_FILE_END ()
         DeAllocate (RGBUF)
         DeAllocate (IGBUF)
      ENDIF
#if defined (VAR_PFS)
      CALL GLOBAL_FILE_CLOSE_WRITE
#endif
C
      RETURN
      END
#endif
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck define_sort */
      SUBROUTINE DEFINE_SORT (NSTR,NSTR1T,NSTR2T,TRIAN,MEM,KL_IN_BUF,
     &                        LSORT,IPRINT)
C***********************************************************************
C
C     Define the distribution and sorting of the 2-index transformed integrals
C
C     Input : NSTRXT (total number of spinors for index X)
C             TRIAN (work with square or triangular packing)
C             IPRINT (print level)
C
C     Output : MEM (Memory required for the buffers)
C              KL_IN_BUF (Maximum number of iz,ireprs,k,l combis in one buffer)
C              LSORT (for each spinor pair the buffer to which it should go)
C
C     Written by L.Visscher
C
C***********************************************************************
      use memory_allocator
#include "implicit.h"
#include "priunit.h"
C
#include "dcbtra.h"
#include "dgroup.h"
#include "infpar.h"
      LOGICAL TRIAN(2)
      DIMENSION NSTR(2,0:2,4)
      DIMENSION LDIST(NSTR2T),LSORT(3,NFPCK12T,0:7)
      integer, allocatable :: node_for_buffer(:)
C
C     Make sure that the caller writes correct code
C
      IF (TRIAN(1)) CALL QUIT ('Sorting requires square packing')
C    
C     Distribute the spinors over the nodes, we will also employ the master (node 0)
C     in the second halftransformation, so add one to NUMNOD
C
      NMPROC = NUMNOD + 1
      L_ON_NODE = NSTR2T / NMPROC
      L_REMAIN = MOD(NSTR2T,NMPROC)
      NODE = -1
      N_L = 0
C
C     We now know how many (L_ON_NODE) L's should be put on each node,
C     start to distribute and give the first L_REMAIN nodes one extra.
C     N_L keeps track of the number of Ls that still can be stored on this node
C
      DO L = 1, NSTR2T
         IF (N_L.EQ.0) THEN
            IF (L_REMAIN.GT.0) THEN
               N_L = L_ON_NODE + 1
               L_REMAIN = L_REMAIN - 1
            ELSE
               N_L = L_ON_NODE 
            ENDIF
            NODE = NODE + 1
         ENDIF
         LDIST(L) = NODE
         N_L = N_L - 1
      ENDDO
C
C     With the distribution of the last index over the nodes prepared we
C     can now also define the buffers used in the sort. The minimum
C     requirement would be one buffer for each l, but it is better to make
C     it more fine grained to make the secondary sorting step more efficient.
C
      CALL BUFFER_FILE_INFO (N_BUFFER,N_SIZE)
      IF (N_BUFFER.LT.NSTR2T) CALL QUIT ('Increase dim. of N_BUFFER') 
C
C     Start by calculating the number of buffers that can be given to each L
C
      NBUF_L = N_BUFFER / NSTR2T
C
C     For each L we have NSTR1T K's that need be buffered, but we also keep track of the
C     boson symmetry of the index pair. This makes the total number of unique combinations
C     that need be sorted NSTR1T * NSTR2T * NBSYMP where NBSYMP is the number of boson
C     symmetry per parity.
C
C     Determine how many of them should go in one buffer.
C     
      NBSYMP = NBSYM / NFSYM
      KL_IN_BUF = (NBSYMP * NSTR1T) / NBUF_L
      IF (MOD(NBSYMP*NSTR1T,NBUF_L).GT.0) KL_IN_BUF = KL_IN_BUF + 1

c temporarty storage for 1HT fine-sorting 
      call alloc(node_for_buffer,N_BUFFER, id="node_for_buffer")

C
C     Assign each (ireprs,k,l) combination to a buffer
C     The incoming integrals are ordered as (k,l,iz ; r,s,ireprs,ic), we later want to read 
C     them back in the order (r,s,ic,iz; ireprs,k,l). This defines the loop
C     order, the offsets are used to find the place in the incoming set.
C
      IBUF = 1
      IN_BUF = 0
C
      CALL IZERO(LSORT,3*NFPCK12T*NBSYM)
C
      L = 0
      DO IREPL = 1, NFSYM
        DO LL = 1, NSTR(IREPL,0,2)
           L = L + 1
C          Make sure that with each new l we start with a new buf
           IF (IN_BUF.NE.0) THEN
               IBUF = IBUF + 1
               IN_BUF = 0
           ENDIF
           DO IREPKL = 1, NFSYM
              IREPK = MOD(IREPL+IREPKL,2) + 1
              KL = IFPCK12(IREPK,IREPL) + (LL-1) * NSTR(IREPK,0,1)
              DO KK = 1, NSTR(IREPK,0,1)
                 KL = KL + 1
                 DO IREPRS = 0, NBSYM-1
                 IF (IREPKL.EQ.JBTOF(IREPRS,1)) THEN
C                    Check whether the maximum number of kl's in a buffer was reached
                     IF (IN_BUF.GE.KL_IN_BUF) THEN
                        IBUF = IBUF + 1
                        IN_BUF = 1
                     ELSE
                        IN_BUF = IN_BUF + 1
                     ENDIF
C                    We need to know the buffer for (k,l,ireprs)
                     LSORT(1,KL,IREPRS) = IBUF
C                    .. and its relative position therein
                     LSORT(2,KL,IREPRS) = IN_BUF    
C                    .. and the node to which it is assigned
                     LSORT(3,KL,IREPRS) = LDIST(L)
c                    .. also store information for the fine-sort of 1HT integrals, if required
                     node_for_buffer(ibuf) = ldist(l) 
                 ENDIF
                 ENDDO
              ENDDO
           ENDDO
        ENDDO
      ENDDO
C
#ifndef VAR_PFS
c aspg, for 1HT fine-sort
      call init_finesort_commons(kl_in_buf,n_buffer,node_for_buffer)
      call dealloc(node_for_buffer)
c aspg, for 1HT fine-sort
#endif

      IF(IPRINT.GE.3) THEN
         CALL HEADER('Arrays for sort of halftr. integrals ',-1)
         DO L = 1, NSTR2T
            WRITE(LUPRI,'(2(A,I6))') 'Orbital',L,' goes to node',
     &      LDIST(L)
         ENDDO
      ENDIF
C
C     Final check on the total number of buffers, it should not exceed the maximum
C     Calculate also the memory that will be needed to allocate the buffers
C
      IF (IBUF.LE.N_BUFFER) THEN
         MEM = IBUF * N_SIZE
      ELSE
         CALL QUIT ('Error in routine DEFINE_SORT')
      ENDIF
C
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck TRDRV6 */
      SUBROUTINE TRDRV6(WORK,KFREE,LFREE,IPRINT,INTFLG,
     &                  NSTR,INDX,TRIAN,KQ,KE,KIBE,
     &                  IC,I2TYP,IBSTRT,IBEND,GABRAO,DRIJ,
     &                  DINTSKP,LSORT,RGBUF,IGBUF)
C
C     Do first half transformation and write integrals to file.
C
C     Written by Luuk Visscher, august 2004
C
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "maxaqn.h"
#include "priunit.h"
#include "iratdef.h"
#include "maxorb.h"
#include "dcbgen.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbbas.h"
#include "dcborb.h"
#include "dgroup.h"
#include "twosta.h"
      LOGICAL NOPV, NODV, TRIAN(2)
      DIMENSION NSTR(2,0:2,4),INDX(3,*)
      DIMENSION KQ(2,4),KE(2,4),KIBE(2,4)
      DIMENSION IJP12(0:7)
      DIMENSION IHM(0:7)
      DIMENSION LSORT(3,NFPCK12T,0:7)
      DIMENSION RGBUF(*)
      DIMENSION IGBUF(2,*)
      DIMENSION WORK(*),GABRAO(*),DRIJ(*),DINTSKP(*)
C
      CALL QENTER('TRDRV6')
      KFRSAV = KFREE
C
C     We transform all shells in the first halftransformation
C
      CALL ICOPY ( 32,NSPCK,1,NSPCK12,1)
      CALL ICOPY (196,ISPCK,1,ISPCK12,1)
      CALL ICOPY ( 24,NBBAS,1,NBBAS1, 1)
      CALL ICOPY ( 24,NBBAS,1,NBBAS2, 1)
      CALL ICOPY ( 24,IBBAS,1,IBBAS1, 1)
      CALL ICOPY ( 24,IBBAS,1,IBBAS2, 1)
      CALL ICOPY (  2,IBAS, 1,IBAS1,  1)
      CALL ICOPY (  2,IBAS, 1,IBAS2,  1)
C
      IF (I2TYP.LT.0) THEN
         GOTO 999
      ELSEIF (I2TYP.EQ.1) THEN
         ICS12 = 1
         ICF12 = 1
      ELSEIF (I2TYP.EQ.2) THEN
         ICS12 = 2
         ICF12 = 2
      ELSEIF (I2TYP.EQ.4) THEN
         ICS12 = 3
         ICF12 = 3
      ELSE
         ICS12 = 1
         ICF12 = 2
      ENDIF
C
C     Memory requirements for HERMIT:
C
      MWHER = MXMEMHER(IC,I2TYP)
C     
C     Loop over the shells
C     
      DO ISHLB = IBSTRT, IBEND
         IF (IPRINT .GT. 10) THEN
            write(lupri,*) 'TR6DRV: ISHLA, ISHLB',ISHLA,ISHLB
            call flshfo(lupri)
         END IF
C
C
            KFRSAV3 = KFREE
            NINSHA = NINSH(ISHLA,-1,INDX,IPRINT)
            NINSHB = NINSH(ISHLB,-1,INDX,IPRINT)
C
C           Set up gather array for distributions,
C           calculate memory requirements for this batch.
C
C
C           First a dummy run to calculate the memory requirements
C           for GMAT. Max size of GMAT is chosen based on MWHER.
C
            NSIZG = LFREE - MIN(LFREE/10, 1 000 000) - MWHER
C           subtract max mem needed in Hermit and 10%/1Mw for anything else
C
            NUMDIS = NDISTRN(I2TYP,IPRINT,.FALSE.,.FALSE.,.FALSE.,
     &           .TRUE.,INDX,IDUM,IJP12,IDUM,NSIZG,IDUM)
            IF (NPASS .GT. 1) THEN
               ! we cannot fit all integrals in memory,
               ! instead we use memory for buffering of integrals.
               ! Filled buffers are saved on direct access file SCLIN (LGFIL),
               ! opened in subroutine INITGBF. We limit NSIZG to 10 mio words,
               ! in order not to get too long records on SCLIN.
               ! /hjaaj Aug. 2018
               NSIZG = MIN(10000000,NSIZG)
               NUMDIS = NDISTRN(I2TYP,IPRINT,.FALSE.,.FALSE.,.FALSE.,
     &           .TRUE.,INDX,IDUM,IJP12,IDUM,NSIZG,IDUM)
            END IF
C
            LDXAB = 5*NINSHA*NINSHB
            CALL MEMGET2('INTE','DXAB',KDXAB,LDXAB,WORK,KFREE,LFREE)
            CALL MEMGET2('INTE','IJPASS',KIJPASS,8*NPASS,
     &         WORK,KFREE,LFREE)
            CALL MEMGET2('INTE','IAB',KIAB,NUMDIS,WORK,KFREE,LFREE)
C
C           Set INDXAB, INDPASS and IABIND
C
            NUMDIS = NDISTRN(I2TYP,IPRINT,.TRUE.,.TRUE.,.TRUE.,.TRUE.,
     &                       INDX,WORK(KDXAB),IJP12,WORK(KIAB),
     &                       NSIZG,WORK(KIJPASS))
C
            IF (IPRINT .GE. 3) THEN
               WRITE (LUPRI,
     &              '(//A,2I16/,2(A,I16/),2(A,I16,F10.3/))')
     &         ' Calculation of integral distribution set:',
     &              ISHLA,ISHLB,
     &         ' Number of distributions in this set:     ',NUMDIS,
     &         ' Number of passes :                       ',NPASS,
     &         ' Size of scalar integral batch:           ',NSIZG,
     &              NSIZG*8./(1024.*1024.)
               CALL FLSHFO(LUPRI)
            END IF
C
         IF (NPASS.GT.1) THEN
C
C           Initialize scalar integral buffer file and arrays
C           Use the space reserved for GMAT now as buffer storage
C
            LGFIL = LUTRA2
            NGBFSZ = (IRAT*NSIZG)/((1+IRAT)*NPASS)
C
C           Allocate the buffer arrays in WORK and set KGMAT to the
C           start of this allocation section. We now only need to
C           send down GMAT into HERMIT to find this section.
C
            CALL MEMGET2('INTE','ALGREC',KALGREC,NPASS,WORK,KFREE,LFREE)
            CALL MEMGET2('INTE','ALGBUF',KALGBUF,NPASS,WORK,KFREE,LFREE)
            CALL MEMGET2('INTE','AIGBUF',KAIGBUF,NPASS*NGBFSZ,
     &         WORK,KFREE,LFREE)
            CALL MEMGET2('REAL','ARGBUF',KARGBUF,NPASS*NGBFSZ,
     &         WORK,KFREE,LFREE)
C
C           As we refer to the places inside the section we need
C           to subtract KGMAT.
C
            KGMAT  = KALGREC
            KLGREC = KALGREC - KGMAT + 1
            KLGBUF = KALGBUF - KGMAT + 1
            KIGBUF = KAIGBUF - KGMAT + 1
            KRGBUF = KARGBUF - KGMAT + 1
         ELSE
C
C           Write directly into the array GMAT
C           
            CALL MEMGET2('REAL','GMAT',KGMAT,NSIZG,WORK,KFREE,LFREE)
            CALL DZERO(WORK(KGMAT),NSIZG)
            KLGBUF = 1
            KALGREC = KFREE
         ENDIF 
C    
C        Get distributions 
C    
         NODV = NASHT.EQ.0
         NOPV = NASHT.LT.2
         CALL CALDIS(I2TYP,WORK(KGMAT),INDX,WORK(KDXAB),
     &               NODV,NOPV,GABRAO,DRIJ,DINTSKP,SCRTRA,
     &               WORK(KFREE),LFREE,IPRINT)
C           
C        Do the transformation of the first index pair and continue
C        by writing the half-transformed integrals to file
C           
C        De-allocate buffers and allocate GMAT if we had multiple passes.
C           
         IF (NPASS.GT.1) THEN
            CALL MEMREL('TRDRV6.1',WORK,1,KALGBUF,KFREE,LFREE)
            CALL MEMGET2('REAL','GMAT',KGMAT,NSIZG,WORK,KFREE,LFREE) 
            CALL DZERO(WORK(KGMAT),NSIZG)
         ENDIF
C
C     +-----------------------------------------------+
C     |                                               |
C     |      Transformation of the first 2 indices    |
C     |                                               | 
C     +-----------------------------------------------+
C           
         CALL MS6IN1(WORK,KFREE,LFREE,IPRINT,
     &               WORK(KALGREC),ICS12,ICF12,IC,
     &               TRIAN(1),NSTR(1,0,1),NSTR(1,0,2),
     &               WORK(KIJPASS),WORK(KQ(1,1)),WORK(KQ(1,2)),
     &               WORK(KGMAT),NSIZG,
     &               INDX,WORK(KIAB),LSORT,
     &               RGBUF,IGBUF)
C
         CALL FLSHFO(LUPRI)
         CALL MEMREL('TRDRV6.2',WORK,1,KGMAT,KFREE,LFREE)
C
C        Delete scalar integral buffer file
C
         IF (NPASS.GT.1) THEN
            CALL DELGBUF(LGFIL)
         ENDIF
C
      ENDDO ! ishlb
C        
C     Release all memory and exit
C     
 999  CONTINUE
      CALL MEMREL('TRDRV6.4',WORK,1,KFRSAV,KFREE,LFREE)
      CALL QEXIT('TRDRV6')
C      
      RETURN                                             
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck ms6in1*/  
      SUBROUTINE MS6IN1(WORK,KFREE,LFREE,IPRINT,LGREC,
     &                   ICS,ICF,IC34,
     &                   TRIAN,NSTR1,NSTR2,
     &                   IJPASS,Q1,Q2,
     &                   GMAT,NSIZG,INDX,IABIND,LSORT,
     &                   RGBUF,IGBUF)
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C
C     Written by Luuk Visscher august 2004.
C
C     PURPOSE : Driver of the transformation of the first pair of
C               indices. Loop over batches for a given shell
C               combination and put the halftransformed integrals
C               on direct access file with record labeled by l.
C     
C     Input :
C
C     - IPRINT       Print flag
C     - NPASS        Number of passes through the scalar integrals
C     - ICS          First class of integrals 1 : (LL|XX), 2 : (SS|XX)
C     - ICL          Last class of integrals
C     - IC34         Component of the right hand : (XX|LL) or (XX|SS)
C     - NSTR1        Number of active spinors for index 1
C     - NSTR2        Number of active spinors for index 2
C     - IJPASS       Number of blocks for each boson symmetry
C     - Q1           Coefficients for index 1
C     - Q2           Coefficients for index 2
C     - GMAT         Symmetry packed scalar integrals
C     - NSIZG        Size of GMAT array
C     - INDX         For each boson function the boson irrep and the
C                    position in the shell
C     - INDXAB       Information for a pair of boson function belonging
C                    to the current shell pair,
C     - LSORT        Array with information how to sort the halftransformed integrals
C     - RGBUF        Buffers with values of halftransformed integrals
C     - IGBUF        Buffers with labels of halftransformed integrals
C
C
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0= 0.0D0, D1 = 1.0D0)
C     
      INTEGER   NSTR1(2),NSTR2(2)
      DIMENSION WORK(*)
      DIMENSION Q1(*),Q2(*),GMAT(NSIZG)
      DIMENSION IJPASS(0:7,NPASS),INDX(3,*),IABIND(*)
      DIMENSION LSORT(3,NFPCK12T,0:7)
      DIMENSION RGBUF(*)
      DIMENSION IGBUF(2,*)
      LOGICAL   TRIAN
      DIMENSION IND(2)
      Real(8), Allocatable :: HTMP(:),HMAT(:)
C
C     For the buffered input
C
      DIMENSION LGREC(NPASS)
C
#include "dgroup.h"
#include "mxcent.h"
#include "maxorb.h"
#include "maxaqn.h"
#include "symmet.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbbas.h"
#include "dcbibt.h"
C
      CALL QENTER('MS6IN1')
      KFRSAV = KFREE
      IXYZ = IBTXOR(ISYMAX(1,1),ISYMAX(1,2))
      TRESHOLD = 1.E-14
      CALL ICTYPES (IC34,IC3,IC4)
C
C     Allocate memory for (gg,iz),(uu,iz),.. -> (gg+uu,iz),(gu+ug,iz) sort
C 
      IF (NFSYM .GT. 1) THEN
         LHMAT = MAX(NFPCK12(1),NFPCK12(2))*NZ
         Allocate (HTMP(LHMAT))
       ELSE
         LHMAT = NFPCK12(1)*NZ
      END IF

C
C     Allocate memory for half-transformed integral block
C 
      Allocate (HMAT(LHMAT))
C
      IRS = 0
      DO IPASS = 1, NPASS
C
C        Get the scalar integrals that are processed in this pass
C        The integral are already in GMAT when NPASS = 1
C
          IF (NPASS.GT.1) THEN
             CALL DZERO(GMAT,NSIZG)
             IREC = LGREC(IPASS)
             CALL READGBF(LGFIL,IREC,NGBFSZ,GMAT)
          ENDIF
C
C        Do first step of index transformation :
C        Transform lefthand indices to molecular spinor basis
C
         IOFF = 1
C
C        Loop over the boson symmetries of the densities
C
         DO IREPPQ = 0, NBSYM-1
C
C           The parity of the spinor product to which this density
C           contributes need to be established. Since the large and
C           small component have opposite parity the assignment is
C           different in case of Gaunt integrals.
C
            IREPIJ = JBTOF(IREPPQ,1)
            IF (ICS.EQ.3) IREPIJ = JBTOF(IREPPQ,2)
C
C           Loop over the distributions with this boson symmetry in this
C           shell-block batch
C
            DO IRS_PASS = 1, IJPASS(IREPPQ,IPASS)
               IRS = IRS + 1
C
C              Initialize the halftransformed block of integrals
C
               CALL DZERO (HMAT,NFPCK12(IREPIJ)*NZ)
C
C              Loop over the compound component (LL, SS, SL) of the lefthand
C              densities
C
               IF (ICS.EQ.2) IOFF = IOFF + NSPCK(IREPPQ,1)
               DO IC12 = ICS, ICF
                  CALL ICTYPES (IC12,IC1,IC2)
C
C                 Loop over the boson symmetries of the second
C                 (untransformed) index. Get the fermion symmetry (parity)
C                 of that index and get the boson and fermion symmetry
C                 of the first index.
C
                  DO IREPQ = 0, NBSYM-1
                     IREPP = IBTXOR(IREPPQ,IREPQ)
                     IREPI =  JBTOF(IREPP,IC1)
                     IREPJ =  JBTOF(IREPQ,IC2)
                     KOFF = ICMOQR(IREPI,1) + IBBAS(IREPP,IC1) 
     &                    - IBAS(IREPI)
                     LOFF = ICMOQR(IREPJ,2) + IBBAS(IREPQ,IC2) 
     &                    - IBAS(IREPJ)
                     NP = NBBAS(IREPP,IC1)
                     NQ = NBBAS(IREPQ,IC2)
                     NI = NSTR1(IREPI)
                     NJ = NSTR2(IREPJ)
                     NRQ1 = NDMOQR(1,IREPI,1)
                     NCQ1 = NDMOQR(2,IREPI,1)
                     NRQ2 = NDMOQR(1,IREPJ,2)
                     NCQ2 = NDMOQR(2,IREPJ,2)
                     IF (IC1.EQ.1) THEN
                        IREPPI = IREPP
                     ELSE
                        IREPPI = IBTXOR(IXYZ,IREPP)
                     ENDIF
                     IF (IC2.EQ.1) THEN
                        IREPQI = IREPQ
                     ELSE
                        IREPQI = IBTXOR(IXYZ,IREPQ)
                     ENDIF
C
C                    Do the transformation.
C
                     IF ((NP*NQ.NE.0).AND.(NI*NJ.NE.0)) THEN
                     IF (IPRINT .GE. 11) THEN
                        WRITE(LUPRI,*)
     &                  'AO to MO 2-el. transformation, IRS=',IRS
                     END IF
                     IF (NFSYM.GT.1) THEN
                       CALL QTRANS('AOMO','S',D0,NP,NQ,NI,NJ,
     &                    GMAT(IOFF),NP,NQ,1,IPQTOQ(1,0),
     &                    HTMP,NI,NJ,NZ,IPQTOQ(1,IREPPQ),
     &                    Q1(KOFF),NRQ1,NCQ1,NZ,IPQTOQ(1,IREPPI),
     &                    Q2(LOFF),NRQ2,NCQ2,NZ,IPQTOQ(1,IREPQI),
     &                    WORK(KFREE),LFREE,IPRINT)
C
C                      Order the integrals with NKL as first and IZ
C                      as second index
C              
                       DO IZ = 1, NZ
                          JOFF1 = 1 + (IZ-1)*NFPCK12(IREPIJ) +
     &                                   IFPCK12(IREPI,IREPJ)
                          JOFF2 = 1 + (IZ-1)*NI*NJ
                          CALL DAXPY(NI*NJ,D1,HTMP(JOFF2),1,
     &                               HMAT(JOFF1),1)
                       ENDDO
                     ELSE
                       CALL QTRANS('AOMO','S',D1,NP,NQ,NI,NJ,
     &                    GMAT(IOFF),NP,NQ,1,IPQTOQ(1,0),
     &                    HMAT,NI,NJ,NZ,IPQTOQ(1,IREPPQ),
     &                    Q1(KOFF),NRQ1,NCQ1,NZ,IPQTOQ(1,IREPPI),
     &                    Q2(LOFF),NRQ2,NCQ2,NZ,IPQTOQ(1,IREPQI),
     &                    WORK(KFREE),LFREE,IPRINT)
                     ENDIF
                     ENDIF
                     IOFF = IOFF + NP * NQ
                  ENDDO
C                 ... END DO IREPQ
               ENDDO
C              ... END DO IC12
C
C              Find the position of this pair in the full matrix
C
               INDRS = IABIND(IRS)
               CALL IUNPCK(INDRS,2,IND)
               INDR = IND(1)
               INDS = IND(2)
               IREPR = INDX(2,INDR)
               IREPS = INDX(2,INDS)
               INDR1 = INDR - ICOS(IREPR+1,IC3) ! Absolute position
               INDS1 = INDS - ICOS(IREPS+1,IC4) ! Absolute position
C
               IRS_IZ = ISPCK(IREPR,IREPS,IC34)
     &                + (INDS1-1)*NBBAS(IREPR,IC3)+INDR1
C
C              Write the block of transformed integrals to disk
C
               JOFF = 1
               DO IZ = 1, NZ
                  CALL BUFFER_FILE_OUT (1,RGBUF,IGBUF,
     &                 LSORT(1,1,IREPPQ),
     &                 HMAT(JOFF),NFPCK12(IREPIJ),
     &                 IRS_IZ,TRESHOLD)
                  JOFF = JOFF + NFPCK12(IREPIJ)
                  IRS_IZ = IRS_IZ + NSPCK(IREPPQ,0)
               ENDDO
C
            ENDDO
C           ... END DO IRS
         ENDDO
C        ... END DO IREPPQ
      ENDDO
C     ... END DO IPASS
C
      IF (NFSYM .GT. 1) DeAllocate (HTMP)
      DeAllocate (HMAT)

      CALL QEXIT('MS6IN1')
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C/* Deck MS6IN2 */
      SUBROUTINE MS6IN2 (WORK,KFREE,LFREE,IPRINT,ICS,ICF,NSTR,
     & NDMOQR,ICMOQR,IJPAIRS,Q1,Q2,LSORT,INDXKR,INDXB12,INDXB34)
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C
C     Written by Luuk Visscher August 2004.
C
C     PURPOSE : Do 4-index transformation to molecular spinor basis
C               Second index-pair transformation.
C   
C
C     Input :
C
C     - IPRINT       Print flag
C     - ICS          First class of integrals 1 : (XX|LL), 2 : (XX|SS)
C     - ICL          Last class of integrals
C     - NSTR1        Number of active spinors for index 1
C     - NSTR2        Number of active spinors for index 2
C     - NFPCK        Number of spinor pairs for each compound symmetry
C     - IFPCK        Pointers to spinor pairs
C     - NDMOQR       Dimensions of the coefficient array
C     - ICMOQR       Pointers to coefficients
C     - IJPAIRS      Number of blocks for each boson symmetry
C     - Q1           Coefficients for index 1
C     - Q2           Coefficients for index 2
C     - LSORT        Array with information about the stored HT integrals
C
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0 = 0.0D0, D1 = 1.0D0)
C
      DIMENSION NSTR(2,0:2,4)
      DIMENSION LSORT(3,NFPCK12T,0:7)
      DIMENSION WORK(*)
      DIMENSION Q1(*),Q2(*)
      DIMENSION IJPAIRS(2)
      DIMENSION NDMOQR(2,2,2),ICMOQR(2,2)
      DIMENSION INDXKR(2,*),INDXB12(2,*),INDXB34(2,*)
      LOGICAL INIT
      Real(8), Allocatable :: HTMP(:),HMAT(:),GMAT(:)
#include "maxorb.h"
#include "mxcent.h"
#include "maxaqn.h"
#include "symmet.h"
#include "dcbbas.h"
#include "dgroup.h"
#include "dcbtra.h"
#include "infpar.h"
#include "dcbibt.h"
C
      CALL QENTER('MS6IN2')
#if defined (VAR_PFS)
      CALL XTIME(5,1,' File transformation           ')
      CALL SELECT_LOCAL_FROM_GLOBAL
      CALL XTIME(5,2,' File transformation           ')

      CALL LOCAL_FILE_OPEN_READ
#endif
      KFRSAV = KFREE
C
      IXYZ = IBTXOR(ISYMAX(1,1),ISYMAX(1,2))
C
C     Transform righthand indices to molecular spinor basis
C
      call timer('START ',TIMSTR,TIMEND)
 
#ifndef VAR_PFS                                                                       
      if (do_finesort) call sort_buffers(mytid,1)
#endif        

      if (iprint .gt. 0) write (*,*) '<<< Starting 2HT on node ',mytid
c
      Allocate (GMAT(maxval(NSPCK(:,0))*NZ))
      NIJOFF = 0
      NKLOFF = 0
      DO IREPIJ = 1, NFSYM
C       Allocate space for sorted and unsorted fully transformed integrals
        Allocate (HMAT(NFPCK34(IREPIJ)*NZ*4))
        Allocate (HTMP(NFPCK34(IREPIJ)*NZ))
C       Loop over index pairs in the MO-basis
        DO 100 IJ = 1, IJPAIRS(IREPIJ)
          JOFF = 1
          INIT = .FALSE.
          DO IREPPQ = 0, NBSYM-1
            IF (IREPIJ.EQ.JBTOF(IREPPQ,1)) THEN
            IBUF = LSORT(1,IJ,IREPPQ)
            INOD = LSORT(3,IJ,IREPPQ)
            IF (INOD.EQ.MYTID) THEN
C           Initialize the array for the fully transformed integrals
            IF (.NOT.INIT) THEN
               CALL DZERO (HMAT,NFPCK34(IREPIJ)*NZ*4)
               INIT = .TRUE.
            ENDIF
C           Allocate space to read halftransformed integrals
            ICOL = LSORT(2,IJ,IREPPQ)
#if defined (VAR_PFS)
            CALL GLOBAL_FILE_READ (GMAT,NZ*NSPCK(IREPPQ,0),ICOL,IBUF)
#else
            CALL BUFFER_FILE_READ (1,IBUF,GMAT,
     &                             NZ*NSPCK(IREPPQ,0),ICOL,do_finesort)
#endif
            CALL GMAT_SYM (IREPPQ,GMAT,NSPCK(IREPPQ,0),ICS,ICF)
            IOFF = 1
            DO IZ = 1, NZ
               DO IC = ICS, ICF
                  IF (ICS.EQ.2) IOFF = IOFF + NSPCK(IREPPQ,1)
                  DO IREPQ = 0, NBSYM-1
                     IREPP = IBTXOR(IREPPQ,IREPQ)
                     IREPI =  JBTOF(IREPP,IC)
                     IREPJ =  JBTOF(IREPQ,IC)
                     KOFF = ICMOQR(IREPI,1) + IBBAS(IREPP,IC) 
     &                    - IBAS(IREPI)
                     LOFF = ICMOQR(IREPJ,2) + IBBAS(IREPQ,IC) 
     &                    - IBAS(IREPJ)
                     NP = NBBAS(IREPP,IC)
                     NQ = NBBAS(IREPQ,IC)
                     NI = NSTR(IREPI,0,3)
                     NJ = NSTR(IREPJ,0,4)
                     NRQ1 = NDMOQR(1,IREPI,1)
                     NCQ1 = NDMOQR(2,IREPI,1)
                     NRQ2 = NDMOQR(1,IREPJ,2)
                     NCQ2 = NDMOQR(2,IREPJ,2)
                     IF (IC.EQ.1) THEN
                        IREPPI = IREPP
                        IREPQI = IREPQ
                     ELSE
                        IREPPI = IBTXOR(IXYZ,IREPP)
                        IREPQI = IBTXOR(IXYZ,IREPQ)
                     ENDIF
                     IF ((NP*NQ.NE.0).AND.(NI*NJ.NE.0)) THEN
                       CALL QTRANS('AOMO','S',D0,NP,NQ,NI,NJ,
     &                      GMAT(IOFF),NP,NQ,1,IPQTOQ(1,0),
     &                      HTMP,NI,NJ,NZ,IPQTOQ(1,IREPPQ),
     &                      Q1(KOFF),NRQ1,NCQ1,NZ,IPQTOQ(1,IREPPI),
     &                      Q2(LOFF),NRQ2,NCQ2,NZ,IPQTOQ(1,IREPQI),
     &                      WORK(KFREE),LFREE,IPRINT)
C
C                      Order the integrals with NKL as first and IZ2
C                      as second index
C
                       DO IZ2 = 1, NZ
                          JOFF1 = JOFF + (IZ2-1)*NFPCK34(IREPIJ) +
     &                                   IFPCK34(IREPI,IREPJ)
                          JOFF2 = 1 + (IZ2-1)*NI*NJ
                          CALL DAXPY(NI*NJ,D1,HTMP(JOFF2),1,
     &                               HMAT(JOFF1),1)
                        ENDDO
                     ENDIF
                     IOFF = IOFF + NP * NQ
                  ENDDO
               ENDDO
               JOFF = JOFF + NFPCK34(IREPIJ) * NZ
C...........End of loop over IZ (for the first transformed density)
            ENDDO
C.........End of if clause for task on node
          ENDIF
C.........End of if clause for parity
          ENDIF
C.........End of loop over IREPPQ
          ENDDO
          NKL = NFPCK34(IREPIJ)
          IKR = INDXKR(1,IJ+NIJOFF)
          JKR = INDXKR(2,IJ+NIJOFF)
C         Only call SYMFINT if this matrix was formed
          IF (INIT) CALL SYMFINT(IPRINT,IREPIJ,
     &                 INDXB12(1,IJ+NIJOFF),INDXB34(1,1+NKLOFF),
     &                 IJ,IKR,JKR,NSTR(1,0,3),NSTR(1,0,4),NKL,
     &                 HMAT)
 100    CONTINUE
        NIJOFF = NIJOFF + NFPCK12(IREPIJ)
        NKLOFF = NKLOFF + NFPCK34(IREPIJ)
        DeAllocate (HMAT)
        DeAllocate (HTMP)
      ENDDO

      DeAllocate (GMAT)
C
      CALL MEMREL('MS6IN2',WORK,KFRSAV,KFRSAV,KFREE,LFREE)
#if defined (VAR_PFS)
      CALL LOCAL_FILE_CLOSE_READ
#endif
        if (iprint .gt.0) write (*,*) '>>> Finished 2HT on node ',mytid
        call timer('2HT_all',TIMSTR,TIMEND)

      CALL QEXIT('MS6IN2')
C
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
C
      SUBROUTINE GMAT_SYM (IREPPQ,GMAT,NDG,ICS,ICF)
C  
C     Written by Luuk Visscher August 2004.
C
C     PURPOSE : Make G = G + G(Transposed)
C
#include "implicit.h"
#include "maxorb.h"
#include "mxcent.h"
#include "maxaqn.h"
#include "symmet.h"
#include "dcbbas.h"
#include "dgroup.h"
#include "dcbtra.h"
      DIMENSION GMAT(NDG,NZ)
#include "dcbibt.h"
C
      DO IZ = 1, NZ
         DO IC = ICS, ICF
            DO IREPQ = 0, NBSYM-1
               IREPP = IBTXOR(IREPPQ,IREPQ)
               NP = NBBAS(IREPP,IC)
               NQ = NBBAS(IREPQ,IC)
               IPQ = ISPCK(IREPP,IREPQ,IC)
               DO IQ = 1, NQ
                  DO IP = 1, NP
                     IPQ = IPQ + 1
                     IQP = ISPCK(IREPQ,IREPP,IC) + (IP-1)*NQ + IQ
                     IF (IPQ.GT.IQP) THEN
                        GMAT(IPQ,IZ) = GMAT(IPQ,IZ) + GMAT(IQP,IZ)
                        GMAT(IQP,IZ) = GMAT(IPQ,IZ)
                     ENDIF
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
      ENDDO
C
      RETURN
      END
