!dirac_copyright_start
!      Copyright (c) by the authors of DIRAC.
!
!      This program is free software; you can redistribute it and/or
!      modify it under the terms of the GNU Lesser General Public
!      License version 2.1 as published by the Free Software Foundation.
!
!      This program is distributed in the hope that it will be useful,
!      but WITHOUT ANY WARRANTY; without even the implied warranty of
!      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!      Lesser General Public License for more details.
!
!      If a copy of the GNU LGPL v2.1 was not distributed with this
!      code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
!dirac_copyright_end

!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck tr5ini */
      SUBROUTINE TR5INI(XMO,TMATRX1,TMATRX2,WORK,LWORK)
!
!     Because we come from RELCCSD we have to call PAMTRA again
!
!     Written by Joost van Stralen -  march 2003
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
#include "dcbtra.h"
      DIMENSION TMATRX1(*),TMATRX2(*)
      DIMENSION WORK(*)
      DIMENSION XMO(*)
!
      CALL QENTER('TR5INI')
#include "memint.h"
!
      CALL LAGTAU(XMO,TMATRX1,TMATRX2,WORK,LWORK)
!
!MI   ... memm check works...
      CALL MEMCHK('TR5INI 1',WORK,1)
 
      CALL QEXIT('TR5INI')
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck trdr5t */
      SUBROUTINE TRDR5T(XMO,TMATRX1,TMATRX2,WORK,KFREE,LFREE,IPRINT,    &
     &                  INTFLG,NSTR,ANTIS,LMP2,KINDX,KQ,KE,KIBE,DINTSKP)
!***********************************************************************
!
!     Driver for scheme 5: Based on scheme 4
!     1)  Loop over distributions (pq|**), transform 2 indices
!        (pq|**) --> (ij|pq)
!     2)  transform 3rd index (ij|**) --> (ij|k*)
!     3)  contract 3/4 transformed integrals with T matrix to form
!         one index transformed Lagrangian
!         L_(*n)=(ij|k*)*T_(ijkn)
!     4)  transform 2nd Lagrangian index
!         L_(*n) --> L_(mn)
!
!     Parallel scheme.
!
!     * VECTORS:
!       Qi             - coefficients for index i
!       NSTR(ifrp,0,i) - total number of orbitals for index i
!       NSTR(ifrp,1,i) - number of electronic orbitals for index i
!       NSTR(ifrp,2,i) - number of positronic orbitals for index i
!     * AO-INTEGRALS:
!     Distributions (pq|**) are fetched by CALDIS and are packed on
!     boson irreps. The information necessary for symmetry packing
!     is provided by the integer array INDX (generated by NINSH):
!       INDX(1,INDA)   - Position of function in block 
!       INDX(2,INDA)   - Irreducible representation of function
!       INDX(3,INDA)   - Position of function within this particular irrep
!                        and block
!                        (INDA refers to index of SO-orbital)
!     * CONTROL INFORMATION:
!       MSOUT = .TRUE. - write transformed integrals to file
!       EIGN           - eigenvalues (for  MP2 calculation)
!       INTFLG - flag of what integral types to transform
!
!     
!     Written by Joost van Stralen - march 2003
!
!***********************************************************************
      use interface_to_mpi
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0=0.0D0,D1=1.0D0)
#include "maxorb.h"
#include "aovec.h"
#if defined (VAR_MPI)
      INTEGER   ISTAT(df_MPI_STATUS_SIZE), IBUFMPI(5)
#endif
#include "infpar.h"
#include "dcbgen.h"
#include "dcborb.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbbas.h"
#include "dgroup.h"
#include "mp1stpr.h"
#include "blocks.h"
      LOGICAL ANTIS,LMP2,TRIAN(2)
      DIMENSION TMATRX1(*),TMATRX2(*)
      DIMENSION XMO(*)
      DIMENSION NSTR(2,0:2,4),                                          &
     &          KQ(2,4),KE(2,4),KIBE(2,4),WORK(*),DINTSKP(*)
!     
      CALL QENTER('TRDR5T')
      KFRSAV = KFREE
!
      CALL TITLER('Amplitude dependent part Lagrangian','*',118)
!     
!     Define the packing of the 4-index transformed integrals
!
      TRIAN(1) = ISAME(1).EQ.ISAME(2)
      TRIAN(2) = .FALSE.
      CALL PCK2IN(NSTR,TRIAN,IPRINT)
!
!     Prepare for screening
!
      IF(SCRTRA.GT.D0) THEN
        CALL PR4SCR(KGAB,KDRIJ,WORK,KFREE,LFREE,DINTSKP,                &
     &              WORK(KQ(1,1)),WORK(KQ(1,2)),                        &
     &              WORK(KQ(1,3)),WORK(KQ(1,4)),                        &
     &              NDMOQR,ICMOQR,NSTR,ISAME,IPRINT)
      ELSE
        KDRIJ = KFREE
        KGAB  = KFREE
      ENDIF
!
!     *************************************
!     ****** S E R I A L    C O D E  ******
!     *************************************
!
!
!       Allocate memory for the XAOMO and ZAOMO
!       =======================================
!
        CALL MEMGET('REAL',KXAOMO,NCMOTQ,WORK,KFREE,LFREE)
        CALL MEMGET('REAL',KZAOMO,NCMOTQ,WORK,KFREE,LFREE)
!
        CALL DZERO(WORK(KXAOMO),NCMOTQ)
        CALL DZERO(WORK(KZAOMO),NCMOTQ)
!
        CALL GETTIM(CPUBEF,WALLBEF)
        DO IC = 1, 2
           WRITE(LUPRI,'(1X,A,I1)') '- Integral class ',IC
           CALL SHRNGE (IC,INTFLG,I2TYP,IASTRT,IBSTRT,IASMAX,IBSMAX)
           DO ISHLA = IASTRT, IASMAX
              CALL GETTIM(CPUST,WALLST)
              WRITE(LUPRI,'(3X,2(A,I4),A,F8.0,A,F8.0,A)')               &
     &           '- Beginning task',ISHLA,' of',IASMAX,                 &
     &           ' after',WALLST-WALLBEF,' seconds and',                &
     &           CPUST-CPUBEF,' CPU-seconds'
              CALL FLSHFO(LUPRI)
              CALL TRDRV5(WORK,KFREE,LFREE,IPRINT,INTFLG,               &
     &                   NSTR,WORK(KINDX),TRIAN,                        &
     &                   KQ,KE,KIBE,IC,I2TYP,IBSTRT,ISHLA,              &
     &                   WORK(KDRIJ),WORK(KGAB),DINTSKP,                &
     &                   TMATRX1,TMATRX2,WORK(KXAOMO),WORK(KZAOMO))
           ENDDO            
        ENDDO               
!             
!     +-----------------------------------------------------------+ 
!     |                                                           |
!     |   Transform the AO index of the 1st and 2nd part of the   |
!     |   Lagrangian                                              |
!     |                                                           |
!     +-----------------------------------------------------------+
!
!          
!     Allocate memory for the 1st part of the MO Lagrangian
!     -----------------------------------------------------
      CALL MEMGET('REAL',KXMO1,NORBT*NAOCCT*NZ,WORK,KFREE,LFREE)
      CALL DZERO(WORK(KXMO1),NORBT*NAOCCT*NZ)
!
!     Allocate memory for the 2nd part of the MO Lagrangian
!     -----------------------------------------------------
      CALL MEMGET('REAL',KXMO2,NAVIRT*NORBT*NZ,WORK,KFREE,LFREE)
      CALL DZERO(WORK(KXMO2),NAVIRT*NORBT*NZ)
!
!     Transform the 1st and the 2nd part of the Lagrangian:
!     1:     L = (C+)(X)
!     2:     L = (Z+)(C)
!     -----------------------------------------
      CALL LAGTRA(WORK(KXAOMO),WORK(KXMO1),WORK(KZAOMO),WORK(KXMO2),    &
     &            WORK,KFREE,LFREE)
!
!     Put the two tau dependent parts of the Lagrangian together to
!     the final Lagrangian
!     -------------------------------------------------------------
      CALL DZERO(XMO,NORBT*NORBT*NZ)
      CALL ADDTAUL(WORK(KXMO1),WORK(KXMO2),XMO)
!
!     Screening statistics
!
      IF(SCRTRA.GT.D0) THEN
        CALL ST4SCR(DINTSKP)
      ENDIF
!
      CALL MEMREL('TRDR5T2',WORK,KFRSAV,KFRSAV,KFREE,LFREE)
      CALL QEXIT('TRDR5T')
!          
      RETURN
!          
      END  
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck TRDRV5 */
      SUBROUTINE TRDRV5(WORK,KFREE,LFREE,IPRINT,INTFLG,                 &
     &                  NSTR,INDX,TRIAN,KQ,KE,KIBE,                     &
     &                  IC,I2TYP,IBSTRT,IBEND,DRIJ,GABRAO,              &
     &                  DINTSKP,TMATRX1,TMATRX2,XAOMO,ZAOMO)
!
!     This is a modified version of TRDRV4 that makes the
!     Lagrangian in a mixed AO,MO form.
!
!     Formulas :
!
!     xxxx
!
!     Written by Joost van Stralen & Luuk Visscher, march 2003
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "maxaqn.h"
#include "priunit.h"
#include "iratdef.h"
#include "maxorb.h"
#include "dcbgen.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbbas.h"
#include "dcborb.h"
#include "dgroup.h"
#include "twosta.h"
      LOGICAL NOPV, NODV, TRIAN(2)
      DIMENSION NSTR(2,0:2,4),INDX(3,*)
      DIMENSION KQ(2,4),KE(2,4),KIBE(2,4)
      DIMENSION IJP12(0:7)
      DIMENSION IHM(0:7)
      DIMENSION WORK(*),GABRAO(*),DRIJ(*),DINTSKP(*)
      DIMENSION TMATRX1(*),TMATRX2(*),XAOMO(*),ZAOMO(*)
!
      CALL QENTER('TRDRV5')
      KFRSAV = KFREE
!
!     We transform all shells in the first halftransformation
!
      CALL ICOPY ( 32,NSPCK,1,NSPCK12,1)
      CALL ICOPY (196,ISPCK,1,ISPCK12,1)
      CALL ICOPY ( 24,NBBAS,1,NBBAS1, 1)
      CALL ICOPY ( 24,NBBAS,1,NBBAS2, 1)
      CALL ICOPY ( 24,IBBAS,1,IBBAS1, 1)
      CALL ICOPY ( 24,IBBAS,1,IBBAS2, 1)
      CALL ICOPY (  2,IBAS, 1,IBAS1,  1)
      CALL ICOPY (  2,IBAS, 1,IBAS2,  1)
!
      IF (I2TYP.LT.0) THEN
         GOTO 999
      ELSEIF (I2TYP.EQ.1) THEN
         ICS12 = 1
         ICF12 = 1
      ELSEIF (I2TYP.EQ.2) THEN
         ICS12 = 2
         ICF12 = 2
      ELSE
         ICS12 = 1
         ICF12 = 2
      ENDIF
!
!     Memory requirements for HERMIT:
!
      MWHER = MXMEMHER(IC,I2TYP)
!     
!     Loop over the shells
!     
      DO ISHLB = IBSTRT, IBEND
!
!
            KFRSAV3 = KFREE
            NINSHA = NINSH(ISHLA,-1,INDX,IPRINT)
            NINSHB = NINSH(ISHLB,-1,INDX,IPRINT)
!
!           Set up gather array for distributions,
!           calculate memory requirements for this batch.
!
!           NOTE : The actual dimension of INDXAB is kept in the
!           common block dcbtra.h. When we want to parallelize it may
!           be better to allocate it always as MXINSH*MXINSH*4,
!           or (even better) to send it also down to HERMIT.
!           Luuk. TODO
!
!           First a dummy run to calculate the memory requirements
!           for GMAT. Max size of GMAT is set in MAXSCL from
!           .SCLMEM in input or chosen based on MWHER.
!
!
               MWHER = MXMEMHER(IC,I2TYP)
               NSIZG = LFREE - MIN(LFREE/10,1000000) - MWHER
!              subtract max mem needed in Hermit and 10%/1Mw for anything else
!
            NUMDIS = NDISTRN(I2TYP,IPRINT,.FALSE.,.FALSE.,.FALSE.,      &
     &           .TRUE.,INDX,IDUM,IJP12,IDUM,NSIZG,IDUM)
!
            LDXAB = 5*NINSHA*NINSHB
            CALL MEMGET('INTE',KDXAB,LDXAB,WORK,KFREE,LFREE)
            CALL MEMGET('INTE',KIJPASS,8*NPASS,WORK,KFREE,LFREE)
!
!           Set INDXAB and INDPASS
!
            NUMDIS = NDISTRN(I2TYP,IPRINT,.TRUE.,.TRUE.,.FALSE.,.TRUE., &
     &                       INDX,WORK(KDXAB),IJP12,IDUM,               &
     &                       NSIZG,WORK(KIJPASS))
!
            NSIZH = 0
            DO IREPAB = 0, NBSYM-1
               IHM(IREPAB) = NSIZH
               IREPIJ      = JBTOF(IREPAB,1)
               NSIZH       = NSIZH + IJP12(IREPAB)*NFPCK12(IREPIJ)
            ENDDO
!
            CALL MEMGET('REAL',KHMAT,NSIZH*NZ,WORK,KFREE,LFREE)
            CALL DZERO (WORK(KHMAT),NSIZH*NZ)
!
            IF (IPRINT .GE. 3) THEN
               WRITE (LUPRI,                                            &
     &              '(//,1X,A,2I16/,2(1X,A,I16/),2(1X,A,I16,F10.3/))')  &
     &         ' Calculation of integral distribution set:',            &
     &              ISHLA,ISHLB,                                        &
     &         ' Number of distributions in this set:     ',NUMDIS,     &
     &         ' Number of passes :                       ',NPASS,      &
     &         ' Size of scalar integral batch:           ',NSIZG,      &
     &              NSIZG*8./(1024.*1024.),                             &
     &         ' Size of half-transformed integral batch: ',NSIZH,      &
     &              NSIZH*8./(1024.*1024.)
               CALL FLSHFO(LUPRI)
            END IF
!
         IF (NPASS.GT.1) THEN
!
!           Initialize scalar integral buffer file and arrays
!           Use the space reserved for GMAT now as buffer storage
!
            LGFIL = LUTRA2
            NGBFSZ = (IRAT*NSIZG)/((1+IRAT)*NPASS)
!
!           Allocate the buffer arrays in WORK and set KGMAT to the
!           start of this allocation section. We now only need to
!           send down GMAT into HERMIT to find this section.
!
            CALL MEMGET('INTE',KALGREC,NPASS,WORK,KFREE,LFREE)
            CALL MEMGET('INTE',KALGBUF,NPASS,WORK,KFREE,LFREE)
            CALL MEMGET('INTE',KAIGBUF,NPASS*NGBFSZ,WORK,KFREE,LFREE)
            CALL MEMGET('REAL',KARGBUF,NPASS*NGBFSZ,WORK,KFREE,LFREE)
!
!           As we refer to the places inside the section we need
!           to subtract KGMAT.
!
            KGMAT  = KALGREC
            KLGREC = KALGREC - KGMAT + 1
            KLGBUF = KALGBUF - KGMAT + 1
            KIGBUF = KAIGBUF - KGMAT + 1
            KRGBUF = KARGBUF - KGMAT + 1
         ELSE
!
!           Write directly into the array GMAT
!           
            CALL MEMGET('REAL',KGMAT,NSIZG,WORK,KFREE,LFREE)
            CALL DZERO(WORK(KGMAT),NSIZG)
            KLGBUF = 1
            KALGREC = KFREE
         ENDIF 
!    
!        Get distributions 
!    
         NODV = NASHT.EQ.0
         NOPV = NASHT.LT.2
         CALL CALDIS(I2TYP,WORK(KGMAT),INDX,WORK(KDXAB),                &
     &               NODV,NOPV,GABRAO,DRIJ,DINTSKP,SCRTRA,              &
     &               WORK(KFREE),LFREE,IPRINT)
!           
!        Do the transformation of the first index pair and continue
!        by contracting these integrals with the T-amplitudes to obtain
!        the Lagrangian contributions.
!        Half-transformed integrals NOT to file.
!           
!        De-allocate buffers and allocate GMAT if we had multiple passes.
!           
         IF (NPASS.GT.1) THEN
            CALL MEMREL('TRDRV5.1',WORK,1,KALGBUF,KFREE,LFREE)
            CALL MEMGET('REAL',KGMAT,NSIZG,WORK,KFREE,LFREE) 
            CALL DZERO(WORK(KGMAT),NSIZG)
         ENDIF
!
!     +-----------------------------------------------+
!     |                                               |
!     |      Transformation of the first 2 indices    |
!     |                                               | 
!     +-----------------------------------------------+
!           
         CALL MS3IN1(WORK,KFREE,LFREE,IPRINT,                           &
     &               WORK(KALGREC),ICS12,ICF12,IC,                      &
     &               TRIAN(1),NSTR(1,0,1),NSTR(1,0,2),                  &
     &               WORK(KIJPASS),WORK(KQ(1,1)),WORK(KQ(1,2)),         &
     &               WORK(KGMAT),NSIZG,                                 &
     &               INDX,WORK(KDXAB),WORK(KHMAT))
!
         CALL FLSHFO(LUPRI)
         CALL MEMREL('TRDRV5.2',WORK,1,KGMAT,KFREE,LFREE)
!
!     We want to contract with the T's for each 4th AO index seperately
!     thats why the loop over the 4th AO index runs slower than the 3rd
!     mo index of the Ts.
!
!      +-------------------------------------------------------------+
!      |                                                             |
!      |    Transformation of 3rd index to create 3/4 transformed    |
!      |    integrals and contraction of them with the T amplitudes  |
!      |                                                             |
!      +-------------------------------------------------------------+
!
!      first allocation of index array, needed for going from relative
!      to absolute AO nr.
!
         CALL MEMGET('INTE',KINDXL,NTBAS(IC),WORK,KFREE,LFREE)
!
!      Because we only have the upper triangle of the (ij|rs) integrals
!      (wrt rs) we have to apply the multiplication with T twice, first
!      we do really need it as the upper triangle (ITRIANG=1), in the 
!      2nd call we need it as a lower triangle (ITRIANG=2).
!
!
!      Create the 1st tau dependent part of the Lagrangian
!      -----------------------------------------------------
!
        DO ITRIANG = 1, 2
           CALL MS3IN2(WORK,KFREE,LFREE,IPRINT,IC,IHM,NSTR(1,0,3),      &
     &                 WORK(KQ(1,3)),IBEND,ISHLB,                       &
     &                 INDX,WORK(KDXAB),WORK(KHMAT),TMATRX1,XAOMO,      &
     &                 WORK(KINDXL),ITRIANG,1)
        ENDDO
!
!      Create the 2nd tau dependent part of the Lagrangian
!      -----------------------------------------------------
!
        DO ITRIANG = 1, 2
           CALL MS3IN2(WORK,KFREE,LFREE,IPRINT,IC,IHM,NSTR(1,0,4),      &
     &                 WORK(KQ(1,4)),IBEND,ISHLB,                       &
     &                 INDX,WORK(KDXAB),WORK(KHMAT),TMATRX2,ZAOMO,      &
     &                 WORK(KINDXL),ITRIANG,2)
        ENDDO
!
         CALL MEMREL('TRDRV5.3',WORK,1,KFRSAV3,KFREE,LFREE)
!
!        Delete scalar integral buffer file
!
         IF (NPASS.GT.1) THEN
            CALL DELGBUF(LGFIL)
         ENDIF
!
      ENDDO ! ishlb
!        
!     Release all memory and exit
!     
 999  CONTINUE
      CALL MEMREL('TRDRV5.4',WORK,1,KFRSAV,KFREE,LFREE)
      CALL QEXIT('TRDRV5')
!      
      RETURN                                             
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck ms3in1*/  
      SUBROUTINE MS3IN1(WORK,KFREE,LFREE,IPRINT,LGREC,                  &
     &                   ICS,ICF,IC,                                    &
     &                   TRIAN,NSTR1,NSTR2,                             &
     &                   IJPASS,Q1,Q2,                                  &
     &                   GMAT,NSIZG,INDX,INDXAB,HMAT)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen & Luuk Visscher march 2003.
!
!     BASED ON : MS4IN1D
!
!     PURPOSE : Driver of the transformation of the first pair of
!               indices. Loop over batches for a given shell
!               combination and put the halftransformed integrals
!               in HMAT.
!     
!     Input :
!
!     - IPRINT       Print flag
!     - NPASS        Number of passes through the scalar integrals
!     - ICS          First class of integrals 1 : (LL|XX), 2 : (SS|XX)
!     - ICL          Last class of integrals
!     - IC           Component of the right hand : (XX|LL) or (XX|SS)
!     - NSTR1        Number of active spinors for index 1
!     - NSTR2        Number of active spinors for index 2
!     - IJPASS       Number of blocks for each boson symmetry
!     - Q1           Coefficients for index 1
!     - Q2           Coefficients for index 2
!     - GMAT         Symmetry packed scalar integrals
!     - NSIZG        Size of GMAT array
!     - INDX         For each boson function the boson irrep and the
!                    position in the shell
!     - INDXAB       Information for a pair of boson function belonging
!                    to the current shell pair,
!     - HMAT         Zero matrix
!
!     Output :
!
!     - HMAT         Symmetry packed half-transformed integrals
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D1 = 1.0D0)
!     
      INTEGER   NSTR1(2),NSTR2(2)
      DIMENSION WORK(*)
      DIMENSION Q1(*),Q2(*),GMAT(NSIZG),HMAT(*)
      DIMENSION IJPASS(0:7,NPASS),INDX(3,*),INDXAB(NINSHA,NINSHB,5)
      LOGICAL   TRIAN
!
!     For the buffered input
!
      DIMENSION LGREC(NPASS)
!
      DIMENSION IHM(0:7)
!
#include "dgroup.h"
#include "dcbtra.h"
#include "dcbtr3.h"
#include "dcbibt.h"
!
      CALL QENTER('MS3IN1')
      KFRSAV = KFREE
!
      IHOFF = 1
      DO IPASS = 1, NPASS
!
!        Get the scalar integrals that are processed in this pass
!        The integral are already in GMAT when NPASS = 1
!
          IF (NPASS.GT.1) THEN
              CALL DZERO(GMAT,NSIZG)
              IREC = LGREC(IPASS)
              CALL READGBF(LGFIL,IREC,NGBFSZ,GMAT)
          ENDIF
!
!        Calculate the offset of the H-matrix for this pass
!
         NSIZH = 0
         DO IREPAB = 0, NBSYM-1
            IHM(IREPAB) = NSIZH
            IREPIJ = JBTOF(IREPAB,1)
            NSIZH = NSIZH + IJPASS(IREPAB,IPASS)*NFPCK12(IREPIJ)
         ENDDO
!
!        Do first step of index transformation :
!        Transform first pair of indices
!
         CALL MS4IN1 (WORK,KFREE,LFREE,IPRINT,ICS,ICF,                  &
     &                TRIAN,NSTR1,NSTR2,NDMOQR,                         &
     &                ICMOQR,IJPASS(0,IPASS),Q1,Q2,                     &
     &                GMAT,HMAT(IHOFF))
!
!        Offset of the H-matrix
!
         IHOFF = IHOFF + NSIZH*NZ
!
      ENDDO
!
      CALL QEXIT('MS3IN1')
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck ms3in2*/ 
      SUBROUTINE MS3IN2(WORK,KFREE,LFREE,IPRINT,IC,IHM,                 &
     &                  NSTR3,Q3,ISHEL1,ISHEL2,INDX,                    &
     &                  INDXAB,HMAT,TMATRX,XAOMO,INDXL,ITRIANG,IFLGTAU)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!     
!     Written by Joost van Stralen march 2003.
!     
!     
!     PURPOSE : Perform the 3rd index transformation and contract
!               the 3/4 transformed integrals with the T amplitudes
!               and add to the Lagrangian which has one index in
!               AO basis.
!
!               the 3/4 transformation is inspired by TQTRNS
!
!     Input :
!
!     - IPRINT       Print flag
!     - IC           Component of the right hand : (XX|LL) or (XX|SS)
!     - Q3           Coefficients for index 3 (active AOs only)
!     - INDX         For each boson function the boson irrep and the
!                    position in the shell
!     - INDXAB       Information for a pair of boson function belonging
!                    to the current shell pair
!     - HMAT         Symmetry packed half-transformed integrals
!     - ITRIANG      1: We are dealing with the upper triangle of
!                       the halftransformed integrals (we are talking
!                       about the AO part)
!                    2: We are dealing ... lower triangle of ... 
!     - IFLGTAU      1: We calculate the 1st tau dependent part of
!                       the Lagrangian
!                    L = (i^t)*T
!
!                    2: We calculate the 2nd ... the Lagrangian
!                    L = (i^t)*T^*
!
!     Output :
!
!     - XAOMO        The Lagrangian with one index in AO basis
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
#include "dgroup.h"
#include "mxcent.h"
#include "maxorb.h"
#include "maxaqn.h"
#include "dcbtra.h"
#include "dcborb.h"
#include "dcbbas.h"
#include "symmet.h"
#include "dcbtr3.h"
#include "mp1stpr.h"
!
      PARAMETER (D0 = 0.0D00, D1=1.0D00)
      DIMENSION NSTR3(2)
      DIMENSION INDX(3,*),INDXAB(NINSHA,NINSHB,5)
      DIMENSION IPTQLAG(2,0:7,0:7,2), IHM(0:7)
      DIMENSION HMAT(*),Q3(*),QCOF(4)
      DIMENSION WORK(*)
      DIMENSION IND(2)
      DIMENSION INDXAS(0:7), INDXBS(0:7)
      DIMENSION TMATRX(*), XAOMO(*)
      DIMENSION ILOFF(0:7), ILTMOFF(0:7,2)
      DIMENSION NBBASA(0:7,0:2), NBBASB(0:7,0:2)
      DIMENSION INDXL(*)
      DIMENSION NTQINT(2,0:7,0:7,2)
!
#include "ibtfun.h"
!
      CALL QENTER('MS3IN2')
      KFRSAV1 = KFREE
      IXYZ = IBTXOR(ISYMAX(1,1),ISYMAX(1,2))
!
!     Allocate memory for a temporary Lagrangian in AO-MO basis
!     =========================================================
!
      CALL MEMGET('REAL',KTMPLAM,NCMOTQ,WORK,KFREE,LFREE)
      CALL DZERO(WORK(KTMPLAM),NCMOTQ)
!
!     determine the number of functions per boson irrep of shell A and B
!     ==================================================================
!
      CALL NRBASBI(ISHEL2,NBBASB,NBBAS4T,IC)
      CALL NRBASBI(ISHEL1,NBBASA,NBBAS3T,IC)
!
!     initialisation of offset for the final Laomo
!     ============================================
!
      CALL IZERO(ILOFF,8)
      IF(ITRIANG.EQ.1) THEN
        CALL IZERO(INDXL,NBBAS4T)
        CALL LOFFSET(NBBASB,ILOFF,IC)
      ELSE
        CALL IZERO(INDXL,NBBAS3T)
        CALL LOFFSET(NBBASA,ILOFF,IC)
      ENDIF
!
!     determine the packing of the 3/4 transformed integrals
!     ======================================================
!
      IF(ITRIANG.EQ.1) THEN
        CALL PK3INLA(NBBASA,NBBASB,IPTQLAG,NPTQLAG,NTQINT,NSTR3,IC)
      ELSE
        CALL PK3INLA(NBBASB,NBBASA,IPTQLAG,NPTQLAG,NTQINT,NSTR3,IC)
      ENDIF
!
!     allocate memory for the 3/4 transformed integrals
!     -------------------------------------------------
!
      CALL MEMGET('REAL',KTQMAT,NPTQLAG,WORK,KFREE,LFREE)
      CALL DZERO(WORK(KTQMAT),NPTQLAG)
!
!     do the transformation (loop)
!     ============================
!
      CALL IZERO(INDXAS,8)
      CALL IZERO(INDXBS,8)
!     
!     TQMAT is stored as (ij,iz1,k,s,iz2,Gs,Grs,Gij).
!     For real groups this is identical to
!     (ij,iz1,k,iz2,s,Gs,Grs,Gij) which is generated
!     directly in QAXPY. For non-real groups we first
!     generate (ij,iz1,k,iz2* which is accumulated in TQMAT.
!     
      NIJMAX = 0
      IF(NZ.GT.1) THEN
        DO IFRP=1,NFSYM
           IF(NFPCK12(IFRP)*NZ**2.GT.NIJMAX)                            &
     &          NIJMAX = NFPCK12(IFRP)*NZ**2
        ENDDO
        CALL MEMGET('REAL',KT3MAT,NIJMAX,WORK,KFREE,LFREE)
        CALL DZERO(WORK(KT3MAT),NIJMAX)
      ENDIF
!     
      INDAR1 = 0
!
      DO 20 INDAR = 1, NINSHA
         CALL IZERO(INDXBS,8)
         DO 10 INDBR = 1, NINSHB
            INDAB  = INDXAB(INDAR,INDBR,1)
            IF (INDAB.EQ.0) GOTO 10
            IREPAB = INDXAB(INDAR,INDBR,3)
!     Pointer AP   
            IPAB   = INDXAB(INDAR,INDBR,4)
            IREPIJ = JBTOF(IREPAB,1)
            NIJNZ1 = NFPCK12(IREPIJ)*NZ
            NIJNZ2 = NFPCK12(IREPIJ)*NZ**2                             
!     IOFF for HMAT
            IOFF = (IHM(IREPAB)+(IPAB-1)*NFPCK12(IREPIJ))*NZ+1         
            CALL IUNPCK(INDAB,2,IND)
            INDA = IND(1)
            INDB = IND(2)
            IREPA = INDX(2,INDA)
            IREPB = INDX(2,INDB)
            IF(INDAR.GT.INDAR1) INDXAS(IREPA) = INDXAS(IREPA) + 1
            INDXBS(IREPB) = INDXBS(IREPB) + 1
!           to check if indar changes
            INDAR1 = INDAR
!     This is actual index R and S in this irrep and IC.
            INDA1 = INDA - ICOS(IREPA+1,IC)
            INDB1 = INDB - ICOS(IREPB+1,IC)
!     Indexing from relative to absolute AO nr, needed for Laomo     
            IF(ITRIANG.EQ.1) THEN
              INDXL(ILOFF(IREPB) + INDXBS(IREPB)) = INDB1
            ELSE
              INDXL(ILOFF(IREPA) + INDXAS(IREPA)) = INDA1
            ENDIF
!     From the lower triangle we don't want the diagonal part to avoid
!     double counting
            IF(ITRIANG.EQ.2) THEN
              IF (INDA.EQ.INDB) GOTO 10
            ENDIF
!
            IF(ITRIANG.EQ.1) THEN
              INDR = INDXAS(IREPA)
              INDS = INDXBS(IREPB)
              IREPR = IREPA
              IREPS = IREPB
              NS = NBBASB(IREPS,IC)
            ELSE
              INDR = INDXBS(IREPB)
              INDS = INDXAS(IREPA)
              IREPR = IREPB
              IREPS = IREPA
              NS = NBBASA(IREPS,IC)
            ENDIF
!
            IREPK = JBTOF(IREPR,IC)
            NK = NSTR3(IREPK)
            NIJKS = NK*NS*NIJNZ1
!
!     Offset for TQMAT.
!
            JOFF1 = IPTQLAG(IREPIJ,IREPAB,IREPS,IC)                     &
     &            + (INDS-1)*NK*NIJNZ1
!
!     Offset for Coeffs
!
            IF(IFLGTAU.EQ.1) THEN
              IF(ITRIANG.EQ.1) THEN
                KOFF1 = ICMOQR(IREPK,3) + IBBAS(IREPR,IC)               &
     &                - IBAS(IREPK) + INDA1 - 1
              ELSE
                KOFF1 = ICMOQR(IREPK,3) + IBBAS(IREPR,IC)               &
     &                - IBAS(IREPK) + INDB1 - 1
              ENDIF
            ELSE
              IF(ITRIANG.EQ.1) THEN
                KOFF1 = ICMOQR(IREPK,4) + IBBAS(IREPR,IC)               &
     &                - IBAS(IREPK) + INDA1 - 1
              ELSE
                KOFF1 = ICMOQR(IREPK,4) + IBBAS(IREPR,IC)               &
     &                - IBAS(IREPK) + INDB1 - 1
              ENDIF
            ENDIF
!
!     Dimensions of Q3
!
            IF(IFLGTAU.EQ.1) THEN
              NRQ1 = NDMOQR(1,IREPK,3)
              NCQ1 = NDMOQR(2,IREPK,3)
            ELSE
              NRQ1 = NDMOQR(1,IREPK,4)
              NCQ1 = NDMOQR(2,IREPK,4)
            ENDIF
!
            IF (IC.EQ.1) THEN
               IREPR2 = IREPR
            ELSE
               IREPR2 = IBTXOR(IXYZ,IREPR)
            ENDIF
!
!     Start looping over K index
!
            DO K = 1,NK
!
               JOFF2 = JOFF1 + (K-1)*NIJNZ1
               KOFF = KOFF1 + (K-1)*NRQ1
               DO I = 1,NZ
                  QCOF(I) = Q3(KOFF+(I-1)*NRQ1*NCQ1)
               ENDDO
!
!     Non-real groups
!
               IF (NZ.GT.1) THEN
                  CALL DZERO(WORK(KT3MAT),NIJNZ2)
                  CALL QAXPY(NIJNZ1,'N','N',QCOF,IPQTOQ(1,IREPR2),      &
     &                 NZ,HMAT(IOFF),NIJNZ1,1,IPQTOQ(1,0),1,            &
     &                 WORK(KT3MAT),NIJNZ1,1,IPQTOQ(1,IREPR2),          &
     &                 NZ)
!
                  DO IZ = 1,NZ
                     JOFF = JOFF2 + (IZ-1)*NIJKS
                     CALL DAXPY(NIJNZ1,D1,                              &
     &                    WORK(KT3MAT+NIJNZ1*(IZ-1)),                   &
     &                    1,WORK(KTQMAT+JOFF),1)
                  ENDDO
!
!     Real groups 
!                 
               ELSE
                  CALL QAXPY(NIJNZ1,'N','N',QCOF,IPQTOQ(1,IREPR2),      &
     &                 NZ,HMAT(IOFF),NIJNZ1,1,IPQTOQ(1,0),NZ,           &
     &                 WORK(KTQMAT+JOFF2),NIJNZ1,1,IPQTOQ(1,IREPR2),NZ)
               ENDIF
            ENDDO
 10      CONTINUE 
 20   CONTINUE
!           
!     contract the integrals with the T's
!     ===================================
!              
!     First determine the offset for the temp Laomo
!
      CALL IZERO(ILTMOFF,16)
!
      IF(ITRIANG.EQ.1) THEN
        CALL LTMPOFF(NBBASB,ILTMOFF,IC,IFLGTAU)
      ELSE
        CALL LTMPOFF(NBBASA,ILTMOFF,IC,IFLGTAU)
      ENDIF
!
!     The 1st tau dependent part of the Lagrangian
!     --------------------------------------------
      IF(IFLGTAU.EQ.1) THEN
      DO IREPCI = 1, NFSYM
        DO IREPRS = 0, NBSYM -1     
          IF(IREPCI.EQ.JBTOF(IREPRS,1)) THEN
            DO IREPI = 1, NFSYM
              DO IREPS = 0, NBSYM -1
              IF(IREPI.EQ.JBTOF(IREPS,IC)) THEN
                IF(NTQINT(IREPCI,IREPRS,IREPS,IC).NE.0) THEN
!
!  Determine the irreps, for the small component we need to
!  account for the difference in parity relative to the L.C.
!
                  IREPR = IBTXOR(IREPRS,IREPS)
                  IREPC = JBTOF(IREPR,IC)
                  IF (IC.EQ.1) THEN
                     IREPR2 = IREPR
                     IREPS2 = IREPS
                  ELSE
                     IREPR2 = IBTXOR(IXYZ,IREPR)
                     IREPS2 = IBTXOR(IXYZ,IREPS)
                  ENDIF
!
! Determine the size of the matrices that need be transformed
!
                  K = NFPCK12(IREPCI)*NZ*NSTR3(IREPC)
                  IF(ITRIANG.EQ.1) THEN
                    M = NBBASB(IREPS,IC)
                  ELSE
                    M = NBBASA(IREPS,IC)
                  ENDIF
                  N = NAOCC(IREPI)
                  IOFFA = IPTQLAG(IREPCI,IREPRS,IREPS,IC)
                  IOFFB = IOFFTM1(IREPI,IREPRS,IREPCI) + 1
                  IOFFC = ILTMOFF(IREPS,IREPI)
!
                  IF((M.NE.0).AND.(N.NE.0).AND.(K.NE.0)) THEN
                  CALL QGEMM(M,N,K,D1,'T','N',IPQTOQ(1,IREPR2),         &
     &                 WORK(KTQMAT+IOFFA),K,M,NZ,                       &
     &                 'N','N',IPQTOQ(1,IREPRS),TMATRX(IOFFB),K,N,NZ,   &
     &                  D1,IPQTOQ(1,IREPS2),WORK(KTMPLAM+IOFFC),M,N,NZ)
                  ENDIF
                ENDIF
              ENDIF
              ENDDO ! ireps
            ENDDO !irepi
          ENDIF
        ENDDO !ireprs
      ENDDO !irepci
!
      CALL MEMCHK('voor ltmptofinal',WORK,1)
      ELSE
!
!     The 2nd tau dependent part of the Lagrangian
!     --------------------------------------------
      DO IREPLA = 1, NFSYM
        DO IREPRS = 0, NBSYM -1
          IF(IREPLA.EQ.JBTOF(IREPRS,1)) THEN
            DO IREPA = 1, NFSYM
              DO IREPS = 0, NBSYM -1
              IF(IREPA.EQ.JBTOF(IREPS,IC)) THEN
                IF(NTQINT(IREPLA,IREPRS,IREPS,IC).NE.0) THEN
!
!  Determine the irreps, for the small component we need to
!  account for the difference in parity relative to the L.C.
!
                  IREPR = IBTXOR(IREPRS,IREPS)
                  IREPL = JBTOF(IREPR,IC)
                  IF (IC.EQ.1) THEN
                     IREPR2 = IREPR
                     IREPS2 = IREPS
                  ELSE
                     IREPR2 = IBTXOR(IXYZ,IREPR)
                     IREPS2 = IBTXOR(IXYZ,IREPS)
                  ENDIF
!
! Determine the size of the matrices that need be transformed
!
                  K = NFPCK12(IREPLA)*NZ*NSTR3(IREPL)
                  IF(ITRIANG.EQ.1) THEN
                    M = NBBASB(IREPS,IC)
                  ELSE
                    M = NBBASA(IREPS,IC)
                  ENDIF
                  N = NAVIR(IREPA)
                  IOFFA = IPTQLAG(IREPLA,IREPRS,IREPS,IC)
                  IOFFB = IOFFTM2(IREPA,IREPRS,IREPLA) + 1
                  IOFFC = ILTMOFF(IREPS,IREPA)
!
                  IF((M.NE.0).AND.(N.NE.0).AND.(K.NE.0)) THEN
                  CALL QGEMM(M,N,K,-D1,'T','N',IPQTOQ(1,IREPR2),        &
     &                 WORK(KTQMAT+IOFFA),K,M,NZ,                       &
     &                 'C','N',IPQTOQ(1,IREPRS),TMATRX(IOFFB),K,N,NZ,   &
     &                 D1,IPQTOQ(1,IREPS2),WORK(KTMPLAM+IOFFC),M,N,NZ)
                  ENDIF      
                ENDIF
              ENDIF
              ENDDO ! ireps
            ENDDO !irepa
          ENDIF
        ENDDO !ireprs
      ENDDO !irepla
!
      ENDIF ! iflgtau
!
!
!     put data from temp Laomo to final Laomo
!     =======================================
!
      IF(ITRIANG.EQ.1) THEN 
        CALL LTMPTOLFINAL(WORK(KTMPLAM),XAOMO,NBBASB,ILTMOFF,INDXL,     &
     &                  ILOFF,IC,IFLGTAU)
      ELSE
        CALL LTMPTOLFINAL(WORK(KTMPLAM),XAOMO,NBBASA,ILTMOFF,INDXL,     &
     &                    ILOFF,IC,IFLGTAU)
      ENDIF
!           
!     release memory
!     ==============
!
      CALL MEMREL('MS3IN2',WORK,1,KFRSAV1,KFREE,LFREE)
!
      CALL QEXIT('MS3IN2')
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck nrbasbi*/
      SUBROUTINE NRBASBI(ISHELX,NBBASA,NBBASAT,IC)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen june 2003.
!     
!
!     PURPOSE : determine the number of basis functions per boson irrep
!               for shell X
!               
!     Input :
!     
!     Output : NBBASA(IREPA,IC) - number of basis functions per boson
!                                 irrep for IC component for shell X
!              NBBASAT          - total nr of basis functions of shell
!                                 X
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "dcbbas.h"
#include "dgroup.h"
#include "maxorb.h"
#include "aovec.h"
#include "blocks.h"
!
      DIMENSION NBBASA(0:7,0:2)
!
#include "ibtfun.h"
!
      NBBASAT = 0
!
      DO IFSYM = 1, NFSYM
        DO IREPA = 0, NBSYM -1
          IF (IFSYM.EQ.JBTOF(IREPA,IC)) THEN
            NBA = NINSH(ISHELX,IREPA,INDX,0)
            NBBASA(IREPA,0) = NBA
            NBBASA(IREPA,IC) = NBA
            NBBASA(IREPA,3 - IC) = 0
            NBBASAT = NBBASAT + NBBASA(IREPA,IC)
          ENDIF
        ENDDO
      ENDDO
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck tauinfo*/
      SUBROUTINE TAUINFO(INFOT)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen june 2003.
!
!     PURPOSE :
!
!     Input :   -
!
!     Output :
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "dgroup.h"
!
      INTEGER INFOT(6,4,4,2)
!
      CALL IZERO (INFOT,192)
!
      IF(NZ.LT.4) THEN
!
!     Real classes
!
      INFOT(1,1,1,1) = 0 ! no bar for 1st index of first term of T^00
      INFOT(2,1,1,1) = 0 !                ...
      INFOT(3,1,1,1) = 0 !                ...
      INFOT(4,1,1,1) = 0 ! no bar for 4rd index of first term of T^00
      INFOT(5,1,1,1) = 0 ! we need the real part of tau for T^00
      INFOT(6,1,1,1) = 0 ! the sign is +
!
      INFOT(1,1,1,2) = 0 ! no bar for 1st index of second term of T^00
      INFOT(2,1,1,2) = 0 !                ...
      INFOT(3,1,1,2) = 1 ! a bar for 3rd index of second term of T^00
      INFOT(4,1,1,2) = 1 !                ...
      INFOT(5,1,1,2) = 0 ! we need the real part of tau for T^00
      INFOT(6,1,1,2) = 0 ! the sign is +
!        
      INFOT(1,2,2,1) = 0 ! no bar for 1st index of first term of T^11
      INFOT(2,2,2,1) = 0
      INFOT(3,2,2,1) = 0
      INFOT(4,2,2,1) = 0
      INFOT(5,2,2,1) = 0
      INFOT(6,2,2,1) = 0
!
      INFOT(1,2,2,2) = 0 ! no bar for 1st index of second term of T^11
      INFOT(2,2,2,2) = 0
      INFOT(3,2,2,2) = 1
      INFOT(4,2,2,2) = 1
      INFOT(5,2,2,2) = 0
      INFOT(6,2,2,2) = 1  ! the sign is -
!
      INFOT(1,3,3,1) = 1
      INFOT(2,3,3,1) = 0
      INFOT(3,3,3,1) = 1
      INFOT(4,3,3,1) = 0
      INFOT(5,3,3,1) = 0
      INFOT(6,3,3,1) = 1
!
      INFOT(1,3,3,2) = 1
      INFOT(2,3,3,2) = 0
      INFOT(3,3,3,2) = 0
      INFOT(4,3,3,2) = 1
      INFOT(5,3,3,2) = 0
      INFOT(6,3,3,2) = 0
!
      INFOT(1,4,4,1) = 1
      INFOT(2,4,4,1) = 0
      INFOT(3,4,4,1) = 1
      INFOT(4,4,4,1) = 0
      INFOT(5,4,4,1) = 0
      INFOT(6,4,4,1) = 0
!
      INFOT(1,4,4,2) = 1
      INFOT(2,4,4,2) = 0 
      INFOT(3,4,4,2) = 0
      INFOT(4,4,4,2) = 1 
      INFOT(5,4,4,2) = 0
      INFOT(6,4,4,2) = 0
!
      IF(NZ.EQ.1) RETURN
!
!     Imaginary classes
!
      INFOT(1,2,1,1) = 0 ! no bar for 1st index of first term of T^10
      INFOT(2,2,1,1) = 0 !                ...
      INFOT(3,2,1,1) = 0 !                ...
      INFOT(4,2,1,1) = 0 ! no bar for 4rd index of first term of T^10
      INFOT(5,2,1,1) = 1 ! we need the imaginary part of tau for T^10
      INFOT(6,2,1,1) = 1 ! the sign is -
!
      INFOT(1,2,1,2) = 0 ! no bar for 1st index of second term of T^10
      INFOT(2,2,1,2) = 0 !                ...
      INFOT(3,2,1,2) = 1 ! a bar for 3rd index of second term of T^10
      INFOT(4,2,1,2) = 1 !                ...
      INFOT(5,2,1,2) = 1 ! we need the imaginary part of tau for T^00
      INFOT(6,2,1,2) = 0 ! the sign is +
!
      INFOT(1,1,2,1) = 0
      INFOT(2,1,2,1) = 0
      INFOT(3,1,2,1) = 0
      INFOT(4,1,2,1) = 0
      INFOT(5,1,2,1) = 1
      INFOT(6,1,2,1) = 0
!
      INFOT(1,1,2,2) = 0
      INFOT(2,1,2,2) = 0
      INFOT(3,1,2,2) = 1
      INFOT(4,1,2,2) = 1
      INFOT(5,1,2,2) = 1
      INFOT(6,1,2,2) = 0
!
      INFOT(1,4,3,1) = 1
      INFOT(2,4,3,1) = 0
      INFOT(3,4,3,1) = 1
      INFOT(4,4,3,1) = 0
      INFOT(5,4,3,1) = 1
      INFOT(6,4,3,1) = 0
!
      INFOT(1,4,3,2) = 1
      INFOT(2,4,3,2) = 0
      INFOT(3,4,3,2) = 0
      INFOT(4,4,3,2) = 1
      INFOT(5,4,3,2) = 1
      INFOT(6,4,3,2) = 0
!     
      INFOT(1,3,4,1) = 1
      INFOT(2,3,4,1) = 0
      INFOT(3,3,4,1) = 1
      INFOT(4,3,4,1) = 0 
      INFOT(5,3,4,1) = 1 
      INFOT(6,3,4,1) = 0 
!     
      INFOT(1,3,4,2) = 1 
      INFOT(2,3,4,2) = 0 
      INFOT(3,3,4,2) = 0
      INFOT(4,3,4,2) = 1 
      INFOT(5,3,4,2) = 1 
      INFOT(6,3,4,2) = 1 
!
      ENDIF
!     
      IF(NZ.EQ.2) RETURN 
!         
!     Quaternion classes
!     
      INFOT(1,1,1,1) = 0 ! no bar for 1st index of first term of T^00
      INFOT(2,1,1,1) = 0 !                ...
      INFOT(3,1,1,1) = 0 !                ...
      INFOT(4,1,1,1) = 0 ! no bar for 4rd index of first term of T^00
      INFOT(5,1,1,1) = 0 ! we need the real part of tau for T^00
      INFOT(6,1,1,1) = 0 ! the sign is +
!     
      INFOT(1,1,1,2) = 0 ! no bar for 1st index of second term of T^00
      INFOT(2,1,1,2) = 0 !                ...
      INFOT(3,1,1,2) = 1 ! a bar for 3rd index of second term of T^00
      INFOT(4,1,1,2) = 1 !                ...
      INFOT(5,1,1,2) = 0 ! we need the real part of tau for T^00
      INFOT(6,1,1,2) = 0 ! the sign is +
!        
      INFOT(1,2,2,1) = 0 ! no bar for 1st index of first term of T^11
      INFOT(2,2,2,1) = 0 
      INFOT(3,2,2,1) = 0 
      INFOT(4,2,2,1) = 0 
      INFOT(5,2,2,1) = 0 
      INFOT(6,2,2,1) = 0 
!     
      INFOT(1,2,2,2) = 0 ! no bar for 1st index of second term of T^11
      INFOT(2,2,2,2) = 0 
      INFOT(3,2,2,2) = 1 
      INFOT(4,2,2,2) = 1 
      INFOT(5,2,2,2) = 0 
      INFOT(6,2,2,2) = 1  ! the sign is -
!     
      INFOT(1,3,3,1) = 1
      INFOT(2,3,3,1) = 0
      INFOT(3,3,3,1) = 1
      INFOT(4,3,3,1) = 0
      INFOT(5,3,3,1) = 0
      INFOT(6,3,3,1) = 1
!     
      INFOT(1,3,3,2) = 1
      INFOT(2,3,3,2) = 0
      INFOT(3,3,3,2) = 0
      INFOT(4,3,3,2) = 1
      INFOT(5,3,3,2) = 0
      INFOT(6,3,3,2) = 0
!
      INFOT(1,4,4,1) = 1
      INFOT(2,4,4,1) = 0
      INFOT(3,4,4,1) = 1
      INFOT(4,4,4,1) = 0
      INFOT(5,4,4,1) = 0
      INFOT(6,4,4,1) = 0
!
      INFOT(1,4,4,2) = 1
      INFOT(2,4,4,2) = 0
      INFOT(3,4,4,2) = 0
      INFOT(4,4,4,2) = 1
      INFOT(5,4,4,2) = 0
      INFOT(6,4,4,2) = 0
!
      INFOT(1,2,1,1) = 0 ! no bar for 1st index of first term of T^10
      INFOT(2,2,1,1) = 0 !                ...
      INFOT(3,2,1,1) = 0 !                ...
      INFOT(4,2,1,1) = 0 ! no bar for 4rd index of first term of T^10
      INFOT(5,2,1,1) = 1 ! we need the imaginary part of tau for T^10
      INFOT(6,2,1,1) = 1 ! the sign is -
!
      INFOT(1,2,1,2) = 0 ! no bar for 1st index of second term of T^10
      INFOT(2,2,1,2) = 0 !                ...
      INFOT(3,2,1,2) = 1 ! a bar for 3rd index of second term of T^10
      INFOT(4,2,1,2) = 1 !                ...
      INFOT(5,2,1,2) = 1 ! we need the imaginary part of tau for T^00
      INFOT(6,2,1,2) = 0 ! the sign is +
!
      INFOT(1,1,2,1) = 0
      INFOT(2,1,2,1) = 0
      INFOT(3,1,2,1) = 0
      INFOT(4,1,2,1) = 0
      INFOT(5,1,2,1) = 1
      INFOT(6,1,2,1) = 0
!
      INFOT(1,1,2,2) = 0
      INFOT(2,1,2,2) = 0
      INFOT(3,1,2,2) = 1
      INFOT(4,1,2,2) = 1
      INFOT(5,1,2,2) = 1
      INFOT(6,1,2,2) = 0
!
      INFOT(1,4,3,1) = 1
      INFOT(2,4,3,1) = 0
      INFOT(3,4,3,1) = 1
      INFOT(4,4,3,1) = 0
      INFOT(5,4,3,1) = 1
      INFOT(6,4,3,1) = 0
!
      INFOT(1,4,3,2) = 1
      INFOT(2,4,3,2) = 0
      INFOT(3,4,3,2) = 0
      INFOT(4,4,3,2) = 1
      INFOT(5,4,3,2) = 1
      INFOT(6,4,3,2) = 0
!
      INFOT(1,3,4,1) = 1
      INFOT(2,3,4,1) = 0
      INFOT(3,3,4,1) = 1
      INFOT(4,3,4,1) = 0
      INFOT(5,3,4,1) = 1
      INFOT(6,3,4,1) = 0
!
      INFOT(1,3,4,2) = 1
      INFOT(2,3,4,2) = 0
      INFOT(3,3,4,2) = 0
      INFOT(4,3,4,2) = 1
      INFOT(5,3,4,2) = 1
      INFOT(6,3,4,2) = 1
!
      INFOT(1,3,1,1) = 0 ! no bar for 1st index of first term of T^20
      INFOT(2,3,1,1) = 0 !                ...
      INFOT(3,3,1,1) = 1 ! a bar for 3rd index of first term of T^20
      INFOT(4,3,1,1) = 0 ! no bar for 4st index of first term of T^20
      INFOT(5,3,1,1) = 0 ! we need the real part of tau for T^20
      INFOT(6,3,1,1) = 0 ! the sign is +
!     
      INFOT(1,3,1,2) = 0 ! no bar for 1st index of second term of T^20
      INFOT(2,3,1,2) = 0 !                ...
      INFOT(3,3,1,2) = 0 !                ...
      INFOT(4,3,1,2) = 1 ! a bar for 4rd index of second term of T^20
      INFOT(5,3,1,2) = 0 ! we need the real part of tau for T^20
      INFOT(6,3,1,2) = 1 ! the sign is -
!     
      INFOT(1,4,1,1) = 0
      INFOT(2,4,1,1) = 0
      INFOT(3,4,1,1) = 1
      INFOT(4,4,1,1) = 0
      INFOT(5,4,1,1) = 1
      INFOT(6,4,1,1) = 1
!     
      INFOT(1,4,1,2) = 0
      INFOT(2,4,1,2) = 0
      INFOT(3,4,1,2) = 0
      INFOT(4,4,1,2) = 1
      INFOT(5,4,1,2) = 1
      INFOT(6,4,1,2) = 1
!
      INFOT(1,3,2,1) = 0
      INFOT(2,3,2,1) = 0
      INFOT(3,3,2,1) = 1
      INFOT(4,3,2,1) = 0
      INFOT(5,3,2,1) = 1
      INFOT(6,3,2,1) = 0
!
      INFOT(1,3,2,2) = 0
      INFOT(2,3,2,2) = 0
      INFOT(3,3,2,2) = 0
      INFOT(4,3,2,2) = 1
      INFOT(5,3,2,2) = 1
      INFOT(6,3,2,2) = 1
!
      INFOT(1,4,2,1) = 0
      INFOT(2,4,2,1) = 0
      INFOT(3,4,2,1) = 1
      INFOT(4,4,2,1) = 0
      INFOT(5,4,2,1) = 0
      INFOT(6,4,2,1) = 0
!
      INFOT(1,4,2,2) = 0
      INFOT(2,4,2,2) = 0
      INFOT(3,4,2,2) = 0
      INFOT(4,4,2,2) = 1
      INFOT(5,4,2,2) = 0
      INFOT(6,4,2,2) = 0
!
      INFOT(1,1,3,1) = 1
      INFOT(2,1,3,1) = 0
      INFOT(3,1,3,1) = 0
      INFOT(4,1,3,1) = 0
      INFOT(5,1,3,1) = 0
      INFOT(6,1,3,1) = 1
!
      INFOT(1,1,3,2) = 1
      INFOT(2,1,3,2) = 0
      INFOT(3,1,3,2) = 1
      INFOT(4,1,3,2) = 1
      INFOT(5,1,3,2) = 0
      INFOT(6,1,3,2) = 1
!     
      INFOT(1,2,3,1) = 1
      INFOT(2,2,3,1) = 0
      INFOT(3,2,3,1) = 0
      INFOT(4,2,3,1) = 0
      INFOT(5,2,3,1) = 1
      INFOT(6,2,3,1) = 0
!     
      INFOT(1,2,3,2) = 1
      INFOT(2,2,3,2) = 0
      INFOT(3,2,3,2) = 1
      INFOT(4,2,3,2) = 1
      INFOT(5,2,3,2) = 1
      INFOT(6,2,3,2) = 1
!     
      INFOT(1,1,4,1) = 1
      INFOT(2,1,4,1) = 0
      INFOT(3,1,4,1) = 0
      INFOT(4,1,4,1) = 0
      INFOT(5,1,4,1) = 1
      INFOT(6,1,4,1) = 0
!     
      INFOT(1,1,4,2) = 1
      INFOT(2,1,4,2) = 0
      INFOT(3,1,4,2) = 1
      INFOT(4,1,4,2) = 1
      INFOT(5,1,4,2) = 1
      INFOT(6,1,4,2) = 0
!     
      INFOT(1,2,4,1) = 1
      INFOT(2,2,4,1) = 0
      INFOT(3,2,4,1) = 0
      INFOT(4,2,4,1) = 0
      INFOT(5,2,4,1) = 0
      INFOT(6,2,4,1) = 0
!     
      INFOT(1,2,4,2) = 1
      INFOT(2,2,4,2) = 0
      INFOT(3,2,4,2) = 1
      INFOT(4,2,4,2) = 1
      INFOT(5,2,4,2) = 0
      INFOT(6,2,4,2) = 1
!     
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck init_t1*/
      SUBROUTINE INIT_T1(TMATRX1,DO_ZERO)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen june 2003.
!
!     PURPOSE : initialize the T matrix
!
!     Input :   -
!
!     Output :
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "dgroup.h"
#include "dcborb.h"
#include "mp1stpr.h"
!
      DIMENSION TMATRX1(*)
      LOGICAL DO_ZERO
!
      NTMATR1 = 0
      CALL IZERO(IOFFTM1,32)
!
      DO IREPCI = 1, NFSYM
        DO IREPRS = 0, NBSYM -1
          IF(IREPCI.EQ.JBTOF(IREPRS,1)) THEN
            DO IREPI = 1, NFSYM
              IOFFTM1(IREPI,IREPRS,IREPCI) = NTMATR1
              NI = NAOCC(IREPI)
              IREPC = MOD(IREPI + IREPCI,2) + 1
              NC = NAVIR(IREPC)
              DO IREPD = 1, NFSYM
                ND = NAVIR(IREPD)
                IREPK = MOD(IREPD + IREPCI,2) + 1
                NK = NAOCC(IREPK)
                NTMATR1 = NTMATR1 + NK*ND*NC*NI*NZ*NZ
              ENDDO !irepd
            ENDDO !irepi
          ENDIF
        ENDDO !ireprs
      ENDDO !irepci
!
!     put the T matrix to zero
!
      IF (DO_ZERO) CALL DZERO(TMATRX1,NTMATR1)  
! 
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck init_t2*/
      SUBROUTINE INIT_T2(TMATRX2,DO_ZERO)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen September 2003.
!     
!     PURPOSE : initialize the 2nd T matrix
!     
!     Input :   -
!     
!     Output :
!     
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "dgroup.h"
#include "dcborb.h"
#include "mp1stpr.h"
!
      DIMENSION TMATRX2(*)
      LOGICAL DO_ZERO
!
      NTMATR2 = 0
      CALL IZERO(IOFFTM2,32)
!
      DO IREPLA = 1, NFSYM
        DO IREPRS = 0, NBSYM -1
          IF(IREPLA.EQ.JBTOF(IREPRS,1)) THEN
            DO IREPA = 1, NFSYM
              IOFFTM2(IREPA,IREPRS,IREPLA) = NTMATR2
              NA = NAVIR(IREPA)
              IREPL = MOD(IREPA + IREPLA,2) + 1
              NL = NAOCC(IREPL)
              DO IREPC = 1, NFSYM
                NC = NAVIR(IREPC)
                IREPK = MOD(IREPC + IREPLA,2) + 1
                NK = NAOCC(IREPK)
                NTMATR2 = NTMATR2 + NK*NC*NL*NA*NZ*NZ
              ENDDO !irepc
            ENDDO !irepa
          ENDIF
        ENDDO !ireprs
      ENDDO !irepla
!
!     put the T matrix to zero
!
      IF (DO_ZERO) CALL DZERO(TMATRX2,NTMATR2)
!     
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck writetau*/
      SUBROUTINE WRITETAU(TMATRIX)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!     
!     Written by Joost van Stralen june 2003.
!     
!     PURPOSE : Write the T matrix to file
!     
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "mp1stpr.h"
!     
      DIMENSION TMATRIX(*)
!
      CALL QENTER('WRITETAU')
!
      OPEN (LUMPPR,FILE='MP2PRP',FORM='UNFORMATTED',STATUS='NEW')
      WRITE (LUMPPR) (TMATRIX(I),I=1,NTMATR1)
      CLOSE (LUMPPR,STATUS='KEEP')
!
      CALL QEXIT('WRITETAU')
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck readtau*/
      SUBROUTINE READTAU(TMATRIX)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen june 2003.
!
!     PURPOSE : Read the T matrix from file
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "mp1stpr.h"
!
      DIMENSION TMATRIX(*)
!
      CALL QENTER('READTAU')
!
      OPEN (LUMPPR,FILE='MP2PRP',FORM='UNFORMATTED',STATUS='OLD')
      REWIND (LUMPPR)
      READ (LUMPPR) (TMATRIX(I),I=1,NTMATR1)
      CLOSE (LUMPPR,STATUS='DELETE')
!
      CALL QEXIT('READTAU')
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck srtt1t2*/
      SUBROUTINE SRTT1T2(TMATRX1,TMATRX2)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen september 2003.
!     
!     PURPOSE : Reorder the indices for the T matrix
!               T_kcal -> T_kcla
!               The results will be put in TMATRX2, which is needed to
!               generate the 2nd T dependent part of the Lagrangian
!
!     Input :  TMATRX1 - T matrix, order kcal, stays unchanged
!
!     Output:  TMATRX2 - T matrix, order kcla
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "dgroup.h"
#include "dcborb.h"
#include "mp1stpr.h"
!
      DIMENSION TMATRX1(*), TMATRX2(*)

!
!     initialize the 2nd T matrix
!
      CALL INIT_T2(TMATRX2,.TRUE.)
!
!     Reorder the stuff
!
      DO IREPAL = 1, NFSYM
        DO IREPRS = 0, NBSYM -1
          IF(IREPAL.EQ.JBTOF(IREPRS,1)) THEN
            DO IREPL = 1, NFSYM
              IREPA = MOD(IREPL + IREPAL,2) + 1
              IOFFT1A = IOFFTM1(IREPL,IREPRS,IREPAL) + 1
              IOFFT2A = IOFFTM2(IREPA,IREPRS,IREPAL) + 1
              NL = NAOCC(IREPL)
              NA = NAVIR(IREPA)
              NKC = 0
              DO IREPC = 1, NFSYM
                NC = NAVIR(IREPC)
                IREPK = MOD(IREPC + IREPAL,2) + 1
                NK = NAOCC(IREPK)
                NKC = NKC + NK*NC*NZ
              ENDDO !irepc
              DO IZ = 1, NZ
                IOFFT1B = IOFFT1A + (IZ-1)*NKC*NA*NL
                IOFFT2B = IOFFT2A + (IZ-1)*NKC*NA*NL
                IOFFT1C = IOFFT1B
                IOFFT2C = IOFFT2B
                DO L = 1, NL
                  IOFFT2D = IOFFT2C
                  DO IA = 1, NA
                   CALL DCOPY(NKC,TMATRX1(IOFFT1C),1,TMATRX2(IOFFT2D),1)
                   IOFFT1C = IOFFT1C + NKC
                   IOFFT2D = IOFFT2D + NKC*NL
                  ENDDO ! ia
                  IOFFT2C = IOFFT2C + NKC
                ENDDO ! l
              ENDDO ! iz
            ENDDO !irepl
          ENDIF
        ENDDO !ireprs
      ENDDO !irepal
!
!
      RETURN 
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck pk3inla*/ 
      SUBROUTINE PK3INLA(NBBASR,NBBASS,IPTQLAG,NPTQLAG,NTQINT,NSTR3,IC)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!       
!     Written by Joost van Stralen march 2003.
!
!     PURPOSE : Define the packing of the 3/4 transformed integrals.
!     
!     Input :   NSTR3 - # of active spinors
!               IC   - Component of the right hand : (XX|LL) or (XX|SS)
!               NBBAS* - # of basis functions per boson irrep
!     
!     Output :  IPTQLAG - pointers for the symmetry packing 
!               NPTQLAG - total # of 3/4 transf integrals
!           
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
!     
#include "dcbtra.h"
#include "dgroup.h"
#include "dcbbas.h"
      DIMENSION IPTQLAG(2,0:7,0:7,2),NSTR3(2)
      DIMENSION NBBASR(0:7,0:2),NBBASS(0:7,0:2)
      DIMENSION NTQINT(2,0:7,0:7,2)
!
#include "ibtfun.h"
!     
      CALL QENTER('PK3INLA')
!     
!     Initialize
!
      NPTQLAG = 0
      CALL IZERO(IPTQLAG,256)
      CALL IZERO(NTQINT,256)
!
      DO IREPIJ = 1, NFSYM
        NIJ = NFPCK12(IREPIJ)
        DO IREPRS = 0, NBSYM - 1         ! boson symmetry of rs
          IF (IREPIJ.EQ.JBTOF(IREPRS,1)) THEN
            DO 11 IREPS = 0, NBSYM - 1
              IREPR = IBTXOR(IREPRS,IREPS)
              IREPK = JBTOF(IREPR,IC)    ! parity that r contributes to
              IPTQLAG(IREPIJ,IREPRS,IREPS,IC) = NPTQLAG
              NS = NBBASS(IREPS,IC)
              NR = NBBASR(IREPR,IC)
              IF (NR.EQ.0) GOTO 11
              NPTQLAG = NPTQLAG + NIJ*NSTR3(IREPK)*NS*NZ*NZ
              NTQINT(IREPIJ,IREPRS,IREPS,IC) = NIJ*NSTR3(IREPK)*NS*NZ*NZ
11          CONTINUE !ireps
          ENDIF
        ENDDO ! ireprs
      ENDDO ! irepij
!
      CALL QEXIT('PK3INLA')
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck loffset*/ 
      SUBROUTINE LOFFSET(NBBASA,ILOFF,IC)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!       
!     Written by Joost van Stralen june 2003.
!
!     PURPOSE : 
!     
!     Input :  
!     
!     Output : 
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
#include "dgroup.h"
!
      DIMENSION NBBASA(0:7,0:2)
      DIMENSION ILOFF(0:7)
!
      NBBASAT = 0
!
      DO IBSYM = 0, NBSYM - 1
        ILOFF(IBSYM) = ILOFF(IBSYM) + NBBASAT
        NBBASAT = NBBASAT + NBBASA(IBSYM,IC)
      ENDDO
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck ltmpoff*/
      SUBROUTINE LTMPOFF(NBBASA,ILTMOFF,IC,IFLGTAU)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen june 2003.
!
!     PURPOSE : Determine the offset for the temp Laomo
!
!     Input :   -
!
!     Output :
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
#include "dgroup.h"
#include "dcborb.h"
!
      DIMENSION NBBASA(0:7,0:2)
      DIMENSION ILTMOFF(0:7,2)
!
      NTMPLAM = 0
!
      DO IFSYM = 1, NFSYM
        DO IREPS = 0, NBSYM -1
          IF(IFSYM.EQ.JBTOF(IREPS,IC)) THEN      
            ILTMOFF(IREPS,IFSYM) = ILTMOFF(IREPS,IFSYM) + NTMPLAM
            IF(IFLGTAU.EQ.1) THEN
              NTMPLAM = NTMPLAM + NBBASA(IREPS,IC)*NAOCC(IFSYM)*NZ
            ELSE
              NTMPLAM = NTMPLAM + NBBASA(IREPS,IC)*NAVIR(IFSYM)*NZ
            ENDIF
          ENDIF
        ENDDO
      ENDDO
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck ltmptolfinal*/
      SUBROUTINE LTMPTOLFINAL(TMPLAM,XAOMO,NBBASA,ILTMOFF,INDXL,ILOFF,  &
     &                        IC,IFLGTAU)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen june 2003.
!
!     PURPOSE : put data from temp Laomo to final Laomo
!
!     Input :   -
!
!     Output :
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
#include "dgroup.h"
#include "dcborb.h"
#include "dcbbas.h"
!
      DIMENSION NBBASA(0:7,0:2)
      DIMENSION ILTMOFF(0:7,2)
      DIMENSION ILOFF(0:7)
      DIMENSION IOFT1(4,0:7,2)
      DIMENSION TMPLAM(*), XAOMO(*)
      DIMENSION INDXL(*)
!
!     Offsets
!     -------
      DO IFSYM = 1, NFSYM
        DO IREPS = 0, NBSYM -1
          IF(IFSYM.EQ.JBTOF(IREPS,IC)) THEN
            DO IZ = 1, NZ
              IF(IFLGTAU.EQ.1) THEN
                IOFT1(IZ,IREPS,IFSYM) = (IZ-1)*NBBASA(IREPS,IC)         &
     &                                   *NAOCC(IFSYM)
              ELSE
                IOFT1(IZ,IREPS,IFSYM) = (IZ-1)*NBBASA(IREPS,IC)         &
     &                                   *NAVIR(IFSYM)
              ENDIF
            ENDDO !iz
          ENDIF
        ENDDO
      ENDDO
      IOFFLF = 0
      IOFFLT = 0
!
      IOFF1 = 0
      IOFF4 = 0
!
      IF(IFLGTAU.EQ.1) THEN ! the 1st tau dependent part of the Lagr.
!
      DO IFSYM = 1, NFSYM
        DO IZ = 1, NZ
          IOFF2 = (IZ-1)*NAOCC(IFSYM)*NFBAS(IFSYM,0)
          DO I = 1, NAOCC(IFSYM)
            IOFF3 = (I-1)*NFBAS(IFSYM,0)
            IF (IC.EQ.2) IOFF4 = NFBAS(IFSYM,1)
            IOFF5 = 0
            DO IREPS = 0, NBSYM -1
              IOFT2 = (I-1)*NBBASA(IREPS,IC)
              IF(IFSYM.EQ.JBTOF(IREPS,IC)) THEN
                DO INDS = 1, NBBASA(IREPS,IC)
                  IOFF6 = INDXL(INDS+ILOFF(IREPS))
                  IOFFLF = IOFF1 + IOFF2 + IOFF3 + IOFF4 + IOFF5 + IOFF6
                  IOFFLT = ILTMOFF(IREPS,IFSYM)                         &
     &                   + IOFT1(IZ,IREPS,IFSYM) + IOFT2 + INDS
                  XAOMO(IOFFLF) = XAOMO(IOFFLF) + TMPLAM(IOFFLT)
                ENDDO !inds
                IOFF5 = IOFF5 + NBBAS(IREPS,IC)
              ENDIF
            ENDDO !ireps
          ENDDO !i
        ENDDO !iz
        IOFF1 = IOFF1 + NZ*NAOCC(IFSYM)*NFBAS(IFSYM,0)
      ENDDO !ifsym
!
      ELSE ! the 2nd tau dependent part of the Lagrangian
!
      DO IFSYM = 1, NFSYM
        DO IZ = 1, NZ
          IOFF2 = (IZ-1)*NAVIR(IFSYM)*NFBAS(IFSYM,0)
          DO IA = 1, NAVIR(IFSYM)
            IOFF3 = (IA-1)*NFBAS(IFSYM,0)
            IF (IC.EQ.2) IOFF4 = NFBAS(IFSYM,1)
            IOFF5 = 0
            DO IREPS = 0, NBSYM -1
              IOFT2 = (IA-1)*NBBASA(IREPS,IC)
              IF(IFSYM.EQ.JBTOF(IREPS,IC)) THEN
                DO INDS = 1, NBBASA(IREPS,IC)
                  IOFF6 = INDXL(INDS+ILOFF(IREPS))
                  IOFFLF = IOFF1 + IOFF2 + IOFF3 + IOFF4 + IOFF5 + IOFF6
                  IOFFLT = ILTMOFF(IREPS,IFSYM)                         &
     &                   + IOFT1(IZ,IREPS,IFSYM) + IOFT2 + INDS
                  XAOMO(IOFFLF) = XAOMO(IOFFLF) + TMPLAM(IOFFLT)
                ENDDO !inds
                IOFF5 = IOFF5 + NBBAS(IREPS,IC)
              ENDIF
            ENDDO !ireps
          ENDDO !i
        ENDDO !iz
        IOFF1 = IOFF1 + NZ*NAVIR(IFSYM)*NFBAS(IFSYM,0)
      ENDDO !ifsym
!
      ENDIF ! iflgtau
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck lagtra*/
      SUBROUTINE LAGTRA(XAOMO,XMO1,ZAOMO,XMO2,WORK,KFREE,LFREE)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen april 2003.
!
!     PURPOSE : Transfrom the 1st and the 2nd part of the Lagrangian
!               1:       L=(C+)X
!               2:       L=(Z+)C
!
!     Output :
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
!
      LOGICAL FILEX
      DIMENSION WORK(*)
      DIMENSION XAOMO(*)
      DIMENSION XMO1(*)
      DIMENSION ZAOMO(*)
      DIMENSION XMO2(*)
!
#include "dcbbas.h"
#include "dcborb.h"
#include "dgroup.h"
#include "dcbgen.h"
!
      CALL QENTER('LAGTRA')
!
      KFRSAV=KFREE
!
!     Memory allocation
!     -----------------
      CALL MEMGET('REAL',KCMO,NCMOTQ,WORK,KFREE,LFREE)
!
!     Open the coefficient file
!     =========================
!
      CALL REACMO(LUCOEF,'DFCOEF',WORK(KCMO),DUM,IDUM,DUM,2)
!
!     ---------------------
!     Do the transformation
!     ---------------------
!
      CALL LAGTR1(WORK(KCMO),XAOMO,XMO1)
      CALL LAGTR2(WORK(KCMO),ZAOMO,XMO2)
!
!     Memory deallocation
!     -------------------
      CALL MEMREL('LAGTRA',WORK,KFRSAV,KFRSAV,KFREE,LFREE)
!
      CALL QEXIT('LAGTRA')
      RETURN
 1000 CONTINUE
      WRITE(LUPRI,'(A)') 'LAGTRA: Coefficient file not found !'
      CALL QUIT('LAGTRA: Coefficients not found !')
!
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck lagtr1*/
      SUBROUTINE LAGTR1(CMO,XAOMO,XMO1)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen may 2003.
!
!     PURPOSE : Transform the AO index of the 1st part of the Lagrangian
!
!               L=(C+)X
!
!     Input :   -
!
!     Output :  XMO1 - The 1st tau dependent part of the Lagrangian in
!                      spinor basis
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0=0.0D0,D1=1.0D0, D4 = 4.0D0)
!
#include "dcbbas.h"
#include "dcborb.h"
#include "dgroup.h"
!
      DIMENSION CMO(*)
      DIMENSION XAOMO(*)
      DIMENSION XMO1(*)
!
!     +------------------+
!     |  form L_qj       |
!     +------------------+
!
      IOFF = 1 ! offset for the MO-Lagrangian
      IOFF1 = 0
!
      DO IFSYM = 1, NFSYM
        CALL QGEMM(NORB(IFSYM),NAOCC(IFSYM),NFBAS(IFSYM,0),D1,          &
     &             'H','N',IPQTOQ(1,0),CMO(ICMOQ(IFSYM)+1),             &
     &             NFBAS(IFSYM,0),NORB(IFSYM),NZ,                       &
     &             'N','N',IPQTOQ(1,0),XAOMO(IOFF1+1),                  &
     &             NFBAS(IFSYM,0),NAOCC(IFSYM),NZ,                      &
     &             D1,IPQTOQ(1,0),XMO1(IOFF),NORBT,NAOCCT,NZ)
        IOFF = IOFF + NORBT*NAOCC(IFSYM)+NORB(IFSYM)
        IOFF1 = IOFF1 + NZ*NAOCC(IFSYM)*NFBAS(IFSYM,0)
      ENDDO ! IFSYM
!
!     +----------------------------------+
!     | The L_ij part has to be put to 0 |
!     +----------------------------------+
!
      DO IZ = 1, NZ
        IOFFSYM = (IZ-1)*NORBT*NAOCCT + 1
        DO IFSYM = 1, NFSYM
          DO J = 1, NAOCC(IFSYM)
            IOFF = IOFFSYM + (J-1)*NORBT + NPSH(IFSYM) + NIOCC(IFSYM)
            CALL DZERO(XMO1(IOFF),NAOCC(IFSYM))
          ENDDO   ! j
          IOFFSYM = IOFFSYM + NORBT*NAOCC(IFSYM) + NORB(IFSYM)
        ENDDO     ! ifsym
      ENDDO       ! iz   
!     
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck lagtr2*/
      SUBROUTINE LAGTR2(CMO,ZAOMO,XMO2)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!     Written by Joost van Stralen september 2003.
!
!     PURPOSE : Transform the AO index of the 2nd part of the Lagrangian
!
!               L=(Z+)C
!
!     Input :   -
!
!     Output :  XMO2 - The 2nd tau dependent part of the Lagrangian in
!                      spinor basis
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D0=0.0D0,D1=1.0D0, D4 = 4.0D0)
!
#include "dcbbas.h"
#include "dcborb.h"
#include "dgroup.h"
!
      DIMENSION CMO(*)
      DIMENSION ZAOMO(*)
      DIMENSION XMO2(*)
!
!     
!     +------------------+
!     |  form L_aq       |
!     +------------------+
!     
      IOFF = 1 ! offset for the MO-Lagrangian
      IOFF1 = 0
!     
      DO IFSYM = 1, NFSYM
        CALL QGEMM(NAVIR(IFSYM),NORB(IFSYM),NFBAS(IFSYM,0),D1,          &
     &             'H','N',IPQTOQ(1,0),ZAOMO(IOFF1+1),                  &
     &             NFBAS(IFSYM,0),NAVIR(IFSYM),NZ,                      &
     &             'N','N',IPQTOQ(1,0),CMO(ICMOQ(IFSYM)+1),             &
     &             NFBAS(IFSYM,0),NORB(IFSYM),NZ,                       &
     &             D1,IPQTOQ(1,0),XMO2(IOFF),NAVIRT,NORBT,NZ)
        IOFF = IOFF + NAVIRT*NORB(IFSYM) + NAVIR(IFSYM)
        IOFF1 = IOFF1 + NZ*NAVIR(IFSYM)*NFBAS(IFSYM,0)
      ENDDO ! IFSYM
!
!     +----------------------------------+
!     | The L_ab part has to be put to 0 |
!     +----------------------------------+
!
      DO IZ = 1, NZ
        IOFFSYM = (IZ-1)*NAVIRT*NORBT + 1
        DO IFSYM = 1, NFSYM
          DO IB = 1, NAVIR(IFSYM)
            IOFF = IOFFSYM + (IB-1)*NAVIRT                              &
     &           + (NOCC(IFSYM) + NPSH(IFSYM))*NAVIRT
            CALL DZERO(XMO2(IOFF),NAVIR(IFSYM))
          ENDDO   ! ib
          IOFFSYM = IOFFSYM + NAVIRT*NORB(IFSYM) + NAVIR(IFSYM)
        ENDDO     ! ifsym
      ENDDO       ! iz
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!/* Deck addtaul*/
      SUBROUTINE ADDTAUL(XMO1,XMO2,XMO)
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!       
!     Written by Joost van Stralen september 2003.
!         
!     PURPOSE : Put the two tau dependent parts of the Lagrangian
!               together to the final Lagrangian
!           
!     Input :   XMO1 - The 1st tau dependent part of the Lagrangian in
!                      spinor basis 
!               XMO2 - The 2nd tau dependent part of the Lagrangian in
!                      spinor basis
!     Output :  XMO -  The sum of the 1st and 2nd tau dependent parts
!
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#include "implicit.h"
#include "priunit.h"
      PARAMETER(D1=1.0D0)
!     
#include "dcborb.h"
#include "dgroup.h"
!
      DIMENSION XMO1(*), XMO2(*), XMO(*)
!
!     Put the XMO1 in XMO
!     -------------------
!
      DO IZ = 1, NZ
        IOFF1A = (IZ-1)*NORBT*NAOCCT + 1
        IOFFA = (IZ-1)*NORBT*NORBT + 1
        DO IFSYM = 1, NFSYM
          DO I = 1, NAOCC(IFSYM)
            IOFF1B = IOFF1A + (I-1)*NORBT
            IOFFB = IOFFA + (I-1)*NORBT                                 &
     &            + (NPSH(IFSYM) + NIOCC(IFSYM))*NORBT
            CALL DAXPY(NORB(IFSYM),D1,XMO1(IOFF1B),1,XMO(IOFFB),1)
          ENDDO   ! i
          IOFF1A = IOFF1A + NORBT*NAOCC(IFSYM) + NORB(IFSYM)
          IOFFA = IOFFA + NORBT*NORB(IFSYM) + NORB(IFSYM)
        ENDDO     ! ifsym
      ENDDO       ! iz
!
!     Put the XMO2 in XMO
!     -------------------
!
      DO IZ = 1, NZ
        IOFF2A = (IZ-1)*NAVIRT*NORBT + 1
        IOFFA = (IZ-1)*NORBT*NORBT + 1
        DO IFSYM = 1, NFSYM
          DO I = 1, NORB(IFSYM)
            IOFF2B = IOFF2A + (I-1)*NAVIRT
            IOFFB = IOFFA + (I-1)*NORBT + NOCC(IFSYM) + NPSH(IFSYM)
            CALL DAXPY(NAVIR(IFSYM),D1,XMO2(IOFF2B),1,XMO(IOFFB),1)
          ENDDO   ! i
          IOFF2A = IOFF2A + NAVIRT*NORB(IFSYM) + NAVIR(IFSYM)
          IOFFA = IOFFA + NORBT*NORB(IFSYM) + NORB(IFSYM)
        ENDDO     ! ifsym
      ENDDO       ! iz
!
      RETURN
      END
!&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

