!dirac_copyright_start
!      Copyright (c) by the authors of DIRAC.
!
!      This program is free software; you can redistribute it and/or
!      modify it under the terms of the GNU Lesser General Public
!      License version 2.1 as published by the Free Software Foundation.
!
!      This program is distributed in the hope that it will be useful,
!      but WITHOUT ANY WARRANTY; without even the implied warranty of
!      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!      Lesser General Public License for more details.
!
!      If a copy of the GNU LGPL v2.1 was not distributed with this
!      code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
!dirac_copyright_end

subroutine printlogo
print *, '%}ZS)S?$=$)]S?$%%>SS$%S$ZZ6cHHMHHHHHHHHMHHM&MHbHH6$L/:<S///</:|/:|:/::!:.::--:%'
print *, '$?S$$%$$$$?%?$(SSS$SSSHMMMMMMMMMMMMMMMMMM6H&6S&SH&&k?6$r~::://///::::::.:::-::$'
print *, '(%?)Z??$$$(S%$>$)S6HMMMMMMMMMMMMMMMMMMMMMMR6M]&&$6HR$&6(i::::::|i|:::::::-:-::('
print *, '$S?$$)$?$%?))?S/]#MMMMMMMMMMMMMMMMMMMMMMMMMMHM1HRH9R&$$$|):?:/://|:/::/:/.::.:$'
print *, 'SS$%%?$%((S)?Z[6MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM&HF$$&/)S?<~::!!:::::::/:-:|.S'
print *, 'SS%%%%S$%%%$$MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMHHHHHHM>?/S/:/:::`:/://:/::-::S'
print *, '?$SSSS?%SS$)MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM/4?:S:/:::/:::/:/:::.::?'
print *, 'S$(S?S$%(?$HMMMMMMMMMMMMMMMMM#&7RH99MMMMMMMMMMMMMMMMMMHHHd$/:::::/::::::-//.:.S'
print *, '(?SS(%)S&HMMMMMMMMMMMMMMMMM#S|///???$9HHMMMMMMMMMDSZ&1S/?</>?~:///::|/!:/-:-:.('
print *, '$S?%?<H(MMMMMMMMMMMMMMMMR?`. :.:`::<>:``?/*?##*)$:/>       `((%://::/:::::/::/$'
print *, 'S$($$)HdMMMMMMMMMMMMMMMP: . `   `  `    `      `-            `Z<:>?::/:::::|:iS'
print *, 'c%%%&HMMMMMMMMMMMMMMMM6:                                      `$%)>%%</>!:::::c'
print *, 'S?%/MMMMMMMMMMMMMMMMMMH-                                        /ZSS>?:?~:;/::S'
print *, '$SZ?MMMMMMMMMMMMMMMMMH?.                                        \"&((/?//?|:::$'
print *, '$%$%&MMMMMMMMMMMMMMMMM:.                                          ?%/S:</::/::$'
print *, '($?}&HMMMMMMMMMMMMMMMM>:                                          $%%<?/i:|i::('
print *, 'Z$($&MMMMMMMMMMMMMMMMHk(:.  . -                                   .S/\?\?/!:/:Z'
print *, '(??$<HMMMMMMMMMMMMMMMFk|:   -.-.                                  :%/%/(:/:ii|('
print *, 'SZ(S?]MMMMMMMMMMMMMMHS?:- -  ::.:                                  |/S:</::?||S'
print *, '$%)$$(MMMMMMMMMMMMMMR):`:. :.:::`,,/bcokb/_                       :S?%?|~:/:/:$'
print *, '%$$%$)[[?$?MMMMMMMMMM: :.:-.::::$7?<&7&MMMMMMM#/           _ .. ..:</?:(:/::::%'
print *, '$$$?Z?HHH~|/MMMMMMMMM/`.-.:.:/:%%%%?dHMMMMMMMMMMH?,-   .,bMMMM6//./i~/~:<:::/:$'
print *, '$($S$M//::S?ZHMMMMMH/:.`:::.:/%S/&MMHMMMMMMMMRM&><   ,HMMMMMMMF  :::?:///:|:::$'
print *, ')[$S$S($|_i:#>::*H&?/::.::/:\"://:?>>`:&HMHSMMMM$:`-   MMHMMMMHHT .)i/?////::/)'
print *, '$$[$$>$}:dHH&$$--?S::-:.:::--/-:``./::>%Zi?)&/?`:.`   `H?$T*\" `  /%?>%:)://ii$'
print *, '$&=&/ZS}$RF<:?/-.|%r/:::/:/:`.-.-..|::S//!`\"``          >??:    `SS<S:)!/////$'
print *, 'Z&]>b[Z(Z?&%:::../S$$:>:::i`.`. `-.`  `                         ,>%%%:>/>/!|:/Z'
print *, '$$&/F&1$c$?>:>?/,>?$$ZS/::/:-: ...                              |S?S)S?<~:::::$'
print *, '&$&$&$k&>>|?<:<?((/$[/?)i~/:/. - -                              S?:%%%?/:::/::&'
print *, '=[/Z[[Fp[MMH$>?Z&S$$$/$S///||..-           -.-                  /((S$:%<:///:/='
print *, '$&>1MHHMMMM6M9MMMM$Z$}$S%/:::.`.            .:/,,,dcb>/:.       ((SSSS%:)!//i|$'
print *, 'MMMMMMMMMMMR&&RRRHR&&($(?:|i::-             .:%&S&$[&H&``     ../>%;/?>??:<::>M'
print *, 'MMMMMMMMMMMMS/}S$&&H&[$SS//:::.:.   . . .v</Jq1&&D]&M&<,      :/::/?%%)S>?://:M'
print *, 'MMMMMMMMMMMM?}$/$$kMM&&$(%/?//:..`.  .|//1d/`://?*/*/\"` `     .:/(SS$%(S%)):%M'
print *, 'MMMMMMMMMMMM(}$$>&&MMHR#$S%%:?::.:|-.`:;&&b/D/$p=qpv//b/~`   :/~~%%??$=$)Z$S+;M'
print *, 'MMMMMMMMMMMM[|S$$Z1]MMMMD[$?$:>)/::: :/?:``???bD&{b<<-`     .,:/)|SS(}Z/$$?/<SM'
print *, 'MMMMMMMMMMMM||$)&7k&MMMMH9]$$??Z%|!/:i::`  `` .             SS?SS?Z/]1$/&$c/$SM'
print *, 'MMMMMMMMMMMM| -?>[&]HMMMMMMMH1[/7SS(?:/..-` ::/Sc,/_,     _<$?SS%$S/&c&&$&>//<M'
print *, 'MMMMMMMMMMMMR  `$&&&HMM9MMMMMMM&&c$%%:/:/:.:.:/\?\?/\    _MMHk/7S/]dq&1S<&&></M'
print *, 'MMMMMMMMMMMMM?  :&96MHMMMMMMMMMMMHHk[S%(<<:// `         ,MMMMMMM&/Z6H]DkH]1$&&M'
print *, 'MMMMMMMMMMMMMD    99H9HMMMMMMMMMMMMMMMb&%$<:i.:....    .MMMMMMMMM6HHHRH&H&H1SFM'
print *, 'MMMMMMMMMMMMMM|   `?HMMMMMMMMMMMMMMMMMMMHk6k&>$&Z$/?_.bHMMMMMMMMMMM&6HRM9H6]ZkM'
print *, 'MMMMMMMMMMMMMMM/    `TMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMHMH6RH&R6&M'
print *, 'MMMMMMMMMMMMMMMM    -|?HMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMFHH6HMD&&M'
print *, 'MMMMMMMMMMMMMMMMk  ..:~?9MMMMMMMMMMMMM#`:MMMMMMMMMMMMMMMMMMMMMMMMMMMMM9MHkR6&FM'
print *, 'MMMMMMMMMMMMMMMMM/  .-!:%$ZHMMMMMMMMMR` dMMMMMMMMMMMMMMMMMMMMMMMMMMMMM9MRMHH9&M'
print *, 'MMMMMMMMMMMMMMMMMML,:.-|::/?&&MMMMMM` .MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMHRMH&&6M'
print *, 'MMMMMMMMMMMMMMMMMMMc%>/:::i<:SMMMMMMHdMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMHHM&969kM'
print *, 'MMMMMMMMMMMMMMMMMMMMSS/$$/(|HMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMHH&HH&M'
print *, 'MMMMMMMMMMMMMMMMMMMM6S/?/MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMR96H1DR1M'
print *, 'MMMMMMMMMMMMMMMMMMMMM&$MHMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMHMH691&&M'
print *, 'MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMH&R&9ZM'
print *, 'MMMMMMMMMMMMMMMMMMMMMMMMMRHMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMH&96][6M'
print *, 'MMMMMMMMMMMMMMMMMMMMMMMMp?:MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM96HH1][FM'
print *, 'MMMMMMMMMMMMMMMMMMMMMMMM> -HMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMH&1k&$&M'
end


subroutine printtitle
print *, '*******************************************************************************'
print *, '*                                                                             *'
print *, '*                                O U T P U T                                  *'
print *, '*                                   from                                      *'
print *, '*                                                                             *'
print *, '*                   @@@@@    @@   @@@@@     @@@@     @@@@@                    *'
print *, '*                   @@  @@        @@  @@   @@  @@   @@                        *'
print *, '*                   @@  @@   @@   @@@@@    @@@@@@   @@                        *'
print *, '*                   @@  @@   @@   @@ @@    @@  @@   @@                        *'
print *, '*                   @@@@@    @@   @@  @@   @@  @@    @@@@@                    *'
print *, '*                                                                             *'
print *, '*                                                                             *'
end

subroutine printsubtitle
print *, '*******************************************************************************'
print *, '*                                                                             *'
print *, '*         =========================================================           *'
print *, '*                     Program for Atomic and Molecular                        *'
print *, '*          Direct Iterative Relativistic All-electron Calculations            *'
print *, '*         =========================================================           *'
print *, '*                                                                             *'
print *, '*                                                                             *'
print *, '*    Written by:                                                              *'
print *, '*                                                                             *'
print *, '*    Radovan Bast             UiT The Arctic University of      Norway        *'
print *, '*    Andre S. P. Gomes        CNRS/Universite de Lille          France        *'
print *, '*    Trond Saue               Universite Toulouse III           France        *'
print *, '*    Lucas Visscher           Vrije Universiteit Amsterdam      Netherlands   *'
print *, '*    Hans Joergen Aa. Jensen  University of Southern Denmark    Denmark       *'
print *, '*                                                                             *'
print *, '*    with contributions from:                                                 *'
print *, '*                                                                             *'
print *, '*    Ignacio Agustin Aucar    CONICET/Northeastern University   Argentina     *'
print *, '*    Vebjoern Bakken          University of Oslo                Norway        *'
print *, '*    Chima Chibueze           Vrije Universiteit Amsterdam      Netherlands   *'
print *, '*    Joel Creutzberg          University of Southern Denmark    Denmark       *'
print *, '*    Kenneth G. Dyall         Schrodinger, Inc., Portland       USA           *'
print *, '*    Sebastien Dubillard      University of Strasbourg          France        *'
print *, '*    Ulf Ekstroem             University of Oslo                Norway        *'
print *, '*    Ephraim Eliav            University of Tel Aviv            Israel        *'
print *, '*    Thomas Enevoldsen        University of Southern Denmark    Denmark       *'
print *, '*    Elke Fasshauer           University of Tubingen            Germany       *'
print *, '*    Timo Fleig               Universite Toulouse III           France        *'
print *, '*    Olav Fossgaard           UiT The Arctic University of      Norway        *'
print *, '*    Loic Halbert             Universite de Lille               France        *'
print *, '*    Erik D. Hedegaard        University of Southern Denmark    Denmark       *'
print *, '*    Trygve Helgaker          University of Oslo                Norway        *'
print *, '*    Benjamin Helmich-Paris   Max Planck Institute f. Coal Res. Germany       *'
print *, '*    Johan Henriksson         Linkoeping University             Sweden        *'
print *, '*    Martin van Horn          Universite Toulouse III           France        *'
print *, '*    Miroslav Ilias           Matej Bel University              Slovakia      *'
print *, '*    Christoph R. Jacob       TU Braunschweig                   Germany       *'
print *, '*    Stefan Knecht            Algorithmiq Ltd / ETH Zuerich     Finland/CH    *'
print *, '*    Stanislav Komorovsky     Slovak Academy of Sciences        Slovakia      *'
print *, '*    Ossama Kullie            University of Kassel              Germany       *'
print *, '*    Jon K. Laerdahl          University of Oslo                Norway        *'
print *, '*    Christoffer V. Larsen    University of Southern Denmark    Denmark       *'
print *, '*    Yoon Sup Lee             KAIST, Daejeon                    South Korea   *'
print *, '*    Nanna Holmgaard List     Stockholm Inst. of Technology     Sweden        *'
print *, '*    Huliyar S. Nataraj       BME/Budapest Univ. Tech. & Econ.  Hungary       *'
print *, '*    Malaya Kumar Nayak       Bhabha Atomic Research Centre     India         *'
print *, '*    Patrick Norman           Stockholm Inst. of Technology     Sweden        *'
print *, '*    Andreas Nyvang           Aarhus University                 Denmark       *'
print *, '*    Malgorzata Olejniczak    University of Warsaw              Poland        *'
print *, '*    Jeppe Olsen              Aarhus University                 Denmark       *'
print *, '*    Jogvan Magnus H. Olsen   University of Southern Denmark    Denmark       *'
print *, '*    Anastasios Papadopoulos  Max Planck Institute f. Coal Res. Germany       *'
print *, '*    Young Choon Park         KAIST, Daejeon                    South Korea   *'
print *, '*    Jesper K. Pedersen       University of Southern Denmark    Denmark       *'
print *, '*    Markus Pernpointner      University of Heidelberg          Germany       *'
print *, '*    Johann V. Pototschnig    Technical University Graz         Austria       *'
print *, '*    Roberto Di Remigio       EuroCC National Competence Centre Sweden        *'
print *, '*    Michal Repisky           UiT The Arctic University of      Norway        *'
print *, '*    Kenneth Ruud             UiT The Arctic University of      Norway        *'
print *, '*    Pawel Salek              Stockholm Inst. of Technology     Sweden        *'
print *, '*    Bernd Schimmelpfennig    Karlsruhe Institute of Technology Germany       *'
print *, '*    Bruno Senjean            CNRS/Universite de Montpellier    France        *'
print *, '*    Avijit Shee              University of Berkeley            USA           *'
print *, '*    Jetze Sikkema            Vrije Universiteit Amsterdam      Netherlands   *'
print *, '*    Ayaki Sunaga             Kyoto University                  Japan         *'
print *, '*    Andreas J. Thorvaldsen   UiT The Arctic University of      Norway        *'
print *, '*    Joern Thyssen            University of Southern Denmark    Denmark       *'
print *, '*    Joost N. P. van Stralen  Vrije Universiteit Amsterdam      Netherlands   *'
print *, '*    Marta L. Vidal           Cardiff University                UK            *'
print *, '*    Sebastien Villaume       Linkoeping University             Sweden        *'
print *, '*    Olivier Visser           University of Groningen           Netherlands   *'
print *, '*    Toke Winther             University of Southern Denmark    Denmark       *'
print *, '*    Shigeyoshi Yamamoto      Chukyo University                 Japan         *'
print *, '*    Xiang Yuan               Universite de Lille               France        *'
print *, '*                                                                             *'
print *, '*    For more information about the DIRAC code see http://diracprogram.org    *'
print *, '*                                                                             *'
print *, '*    This is an experimental code. The authors accept no responsibility       *'
print *, '*    for the performance of the code or for the correctness of the results.   *'
print *, '*                                                                             *'
print *, '*    This program is free software; you can redistribute it and/or            *'
print *, '*    modify it under the terms of the GNU Lesser General Public               *'
print *, '*    License version 2.1 as published by the Free Software Foundation.        *'
print *, '*                                                                             *'
print *, '*    If results obtained with this code are published, an                     *'
print *, '*    appropriate citation would be:                                           *'
print *, '*                                                                             *'
print *, '*    DIRAC, a relativistic ab initio electronic structure program,            *'
print *, '*    Release DIRAC23 (2023), written by                                       *'
print *, '*    R. Bast, A. S. P. Gomes, T. Saue, L. Visscher, and H. J. Aa. Jensen,     *'
print *, '*    with contributions from I. A. Aucar, V. Bakken, C. Chibueze,             *'
print *, '*    J. Creutzberg, K. G. Dyall, S. Dubillard, U. Ekstroem, E. Eliav,         *'
print *, '*    T. Enevoldsen, E. Fasshauer, T. Fleig, O. Fossgaard, L. Halbert,         *'
print *, '*    E. D. Hedegaard, T. Helgaker, J. Henriksson, M. van Horn, M. Ilias,      *'
print *, '*    Ch. R. Jacob, S. Knecht, S. Komorovsky, O. Kullie, J. K. Laerdahl,       *'
print *, '*    C. V. Larsen, Y. S. Lee, N. H. List, H. S. Nataraj, M. K. Nayak,         *'
print *, '*    P. Norman, A. Nyvang, M. Olejniczak, J. Olsen, J. M. H. Olsen,           *'
print *, '*    A. Papadopoulos, Y. C. Park, J. K. Pedersen, M. Pernpointner,            *'
print *, '*    J. V. Pototschnig, R. Di Remigio, M. Repisky, K. Ruud, P. Salek,         *'
print *, '*    B. Schimmelpfennig, B. Senjean, A. Shee, J. Sikkema, A. Sunaga,          *'
print *, '*    A. J. Thorvaldsen, J. Thyssen, J. N. P. van Stralen, M. L. Vidal,        *'
print *, '*    S. Villaume, O. Visser, T. Winther, S. Yamamoto and X. Yuan              *'
print *, '*    (see http://diracprogram.org).                                           *'
print *, '*                                                                             *'
print *, '*    as well as our reference paper: J. Chem. Phys. 152 (2020) 204104.        *'
print *, '*                                                                             *'
print *, '*******************************************************************************'
end

subroutine print_static_alloc
!
! extracts  the size of all static allocations in dirac.x executable
!
! miro: when dirac.x is compiled with profiling flag, call system(...)
! hangs the run on ! Therefore I prefer to deactivate this routine.
!
!
character(len=10) :: dirac_exec
character(len=150) :: system_commands_string
call getarg(0, dirac_exec)

!write(*,*) dirac_exec

system_commands_string="size "//dirac_exec//" 2> /dev/null | grep "//dirac_exec  &
            //" | awk '{printf $3/(1024*1024)} '; echo ' MB' || echo 'can not be determined'"

!write(*,*)  system_commands_string

write(*,"(A,$)") "Static allocations in DIRAC : "

!call system("size dirac.x 2> /dev/null | grep dirac.x | awk '{print $3/(1024*1024) } ' || echo 'can not be determined'")
call system(system_commands_string)

end
