! ------------------------------------------------------------------------------------
!
! Program:      Dirac 
!
! Library:      InteRest
!
! Module:       module_interest_hrr.f90 
!
! Description:  InteRest library routine 
!
! Contains:     
!
! Licensing:    Copyright (c) by the authors of DIRAC.
!
!               This program is free software; you can redistribute it and/or
!               modify it under the terms of the GNU Lesser General Public
!               License version 2.1 as published by the Free Software Foundation.
!
!               This program is distributed in the hope that it will be useful,
!               but WITHOUT ANY WARRANTY; without even the implied warranty of
!               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
!               Lesser General Public License for more details.
!
!               If a copy of the GNU LGPL v2.1 was not distributed with this
!               code, you can obtain one at https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html.
!
! Author:       Michal Repisky (michal.repisky@uit.no)
!
! Revision:     2.0   
!
! Comments:     
!                            
! ------------------------------------------------------------------------------------
module module_interest_hrr
  implicit none

  public interest_hrr_bra
  public interest_hrr_ket

  private                                                                                                       

  integer :: i,j,ij,m
  !$OMP threadprivate(i,j,ij,m)
  real(8) :: rx,ry,rz
  !$OMP threadprivate(rx,ry,rz)



  !-- 680 --!
  real(8) :: ss(1:1,1),ps(2:4,1),ds(5:10,1),fs(11:20,1),gs(21:35,1),hs(36:56,1),is(57:84,1)
  real(8) :: js(85:120,1),ks(121:165,1),ls(166:220,1),ms(221:286,1)
  !$OMP threadprivate(ss,ps,ds,fs,gs,hs,is,js,ks,ls,ms)
  !-- 1092 --!
  real(8) :: sp(1,2:4),pp(2:4,2:4),dp(5:10,2:4),fp(11:20,2:4),gp(21:35,2:4),hp(36:56,2:4)
  real(8) :: ip(57:84,2:4),jp(85:120,2:4),kp(121:165,2:4),lp(166:220,2:4)
  !$OMP threadprivate(sp,pp,dp,fp,gp,hp,ip,jp,kp,lp)
  !-- 1716 --!
  real(8) :: sd(1,5:10),pd(2:4,5:10),dd(5:10,5:10),fd(11:20,5:10),gd(21:35,5:10),hd(36:56,5:10)
  real(8) :: id(57:84,5:10),jd(85:120,5:10),kd(121:165,5:10)
  !$OMP threadprivate(sd,pd,dd,fd,gd,hd,id,jd,kd)
  !-- 2190 --!
  real(8) :: pf(2:4,11:20),df(5:10,11:20),ff(11:20,11:20),gf(21:35,11:20)
  real(8) :: hf(36:56,11:20),if(57:84,11:20),jf(85:120,11:20)
  !$OMP threadprivate(pf,df,ff,gf,hf,if,jf)
  !-- 2415 --!
  real(8) :: dg(5:10,21:35),fg(11:20,21:35),gg(21:35,21:35)
  real(8) :: hg(36:56,21:35),ig(57:84,21:35)
  !$OMP threadprivate(dg,fg,gg,hg,ig)
  !-- 2310 --!
  real(8) :: fh(11:20,36:56),gh(21:35,36:56),hh(36:56,36:56)
  !$OMP threadprivate(fh,gh,hh)

contains
!--------------------------------------------------------------------
  subroutine interest_hrr_bra(vaux,n1,n2,l1,l2,rxi,ryi,rzi)
    integer, intent(in)    :: l1,l2
    integer, intent(in)    :: n1,n2
    real(8), intent(in)    :: rxi,ryi,rzi
    real(8), intent(inout) :: vaux(n1,n2)

    rx = rxi
    ry = ryi
    rz = rzi

    select case(10*l1+l2)
      ![s|s] subblock
      case(11)
      ![p|s] subblock
      case(21)
      ![d|s] subblock
      case(31)
      ![f|s] subblock
      case(41)
      ![g|s] subblock
      case(51)
      ![h|s] subblock
      case(61)
      ![p|p] subblock
      case(22)
        do m=1,n2
          ps(  2:  4,1)=vaux(  1:  3,m)
          ds(  5: 10,1)=vaux(  4:  9,m)
          call do_pp()
          vaux(1:   9,m)=reshape(pp,(/   9/))
        enddo
      ![d|p] subblock
      case(32)
        do m=1,n2
          ds(  5: 10,1)=vaux(  1:  6,m)
          fs( 11: 20,1)=vaux(  7: 16,m)
          call do_dp()
          vaux(1:  18,m)=reshape(dp,(/  18/))
        enddo
      ![f|p] subblock
      case(42)
        do m=1,n2
          fs( 11: 20,1)=vaux(  1: 10,m)
          gs( 21: 35,1)=vaux( 11: 25,m)
          call do_fp()
          vaux(1:  30,m)=reshape(fp,(/  30/))
        enddo
      ![g|p] subblock
      case(52)
        do m=1,n2
          gs( 21: 35,1)=vaux(  1: 15,m)
          hs( 36: 56,1)=vaux( 16: 36,m)
          call do_gp()
          vaux(1:  45,m)=reshape(gp,(/  45/))
        enddo
      ![h|p] subblock
      case(62)
        do m=1,n2
          hs( 36: 56,1)=vaux(  1: 21,m)
          is( 57: 84,1)=vaux( 22: 49,m)
          call do_hp()
          vaux(1:  63,m)=reshape(hp,(/  63/))
        enddo
      ![d|d] subblock
      case(33)
        do m=1,n2
          ds(  5: 10,1)=vaux(  1:  6,m)
          fs( 11: 20,1)=vaux(  7: 16,m)
          gs( 21: 35,1)=vaux( 17: 31,m)
          call do_dp()
          call do_fp()
          call do_dd()
          vaux(1:  36,m)=reshape(dd,(/  36/))
        enddo
      ![f|d] subblock
      case(43)
        do m=1,n2
          fs( 11: 20,1)=vaux(  1: 10,m)
          gs( 21: 35,1)=vaux( 11: 25,m)
          hs( 36: 56,1)=vaux( 26: 46,m)
          call do_fp()
          call do_gp()
          call do_fd()
          vaux(1:  60,m)=reshape(fd,(/  60/))
        enddo
      ![g|d] subblock
      case(53)
        do m=1,n2
          gs( 21: 35,1)=vaux(  1: 15,m)
          hs( 36: 56,1)=vaux( 16: 36,m)
          is( 57: 84,1)=vaux( 37: 64,m)
          call do_gp()
          call do_hp()
          call do_gd()
          vaux(1:  90,m)=reshape(gd,(/  90/))
        enddo
      ![h|d] subblock
      case(63)
        do m=1,n2
          hs( 36: 56,1)=vaux(  1: 21,m)
          is( 57: 84,1)=vaux( 22: 49,m)
          js( 85:120,1)=vaux( 50: 85,m)
          call do_hp()
          call do_ip()
          call do_hd()
          vaux(1: 126,m)=reshape(hd,(/ 126/))
        enddo
      ![f|f] subblock
      case(44)
        do m=1,n2
          fs( 11: 20,1)=vaux(  1: 10,m)
          gs( 21: 35,1)=vaux( 11: 25,m)
          hs( 36: 56,1)=vaux( 26: 46,m)
          is( 57: 84,1)=vaux( 47: 74,m)
          call do_fp()
          call do_gp()
          call do_hp()
          call do_fd()
          call do_gd()
          call do_ff()
          vaux(1: 100,m)=reshape(ff,(/ 100/))
        enddo
      ![g|f] subblock
      case(54)
        do m=1,n2
          gs( 21: 35,1)=vaux(  1: 15,m)
          hs( 36: 56,1)=vaux( 16: 36,m)
          is( 57: 84,1)=vaux( 37: 64,m)
          js( 85:120,1)=vaux( 65:100,m)
          call do_gp()
          call do_hp()
          call do_ip()
          call do_gd()
          call do_hd()
          call do_gf()
          vaux(1: 150,m)=reshape(gf,(/ 150/))
        enddo
      ![h|f] subblock
      case(64)
        do m=1,n2
          hs( 36: 56,1)=vaux(  1: 21,m)
          is( 57: 84,1)=vaux( 22: 49,m)
          js( 85:120,1)=vaux( 50: 85,m)
          ks(121:165,1)=vaux( 86:130,m)
          call do_hp()
          call do_ip()
          call do_jp()
          call do_hd()
          call do_id()
          call do_hf()
          vaux(1: 210,m)=reshape(hf,(/ 210/))
        enddo
      ![g|g] subblock
      case(55)
        do m=1,n2
          gs( 21: 35,1)=vaux(  1: 15,m)
          hs( 36: 56,1)=vaux( 16: 36,m)
          is( 57: 84,1)=vaux( 37: 64,m)
          js( 85:120,1)=vaux( 65:100,m)
          ks(121:165,1)=vaux(101:145,m)
          call do_gp()
          call do_hp()
          call do_ip()
          call do_jp()
          call do_gd()
          call do_hd()
          call do_id()
          call do_gf()
          call do_hf()
          call do_gg()
          vaux(1: 225,m)=reshape(gg,(/ 225/))
        enddo
      ![h|g] subblock
      case(65)
        do m=1,n2
          hs( 36: 56,1)=vaux(  1: 21,m)
          is( 57: 84,1)=vaux( 22: 49,m)
          js( 85:120,1)=vaux( 50: 85,m)
          ks(121:165,1)=vaux( 86:130,m)
          ls(166:220,1)=vaux(131:185,m)
          call do_hp()
          call do_ip()
          call do_jp()
          call do_kp()
          call do_hd()
          call do_id()
          call do_jd()
          call do_hf()
          call do_if()
          call do_hg()
          vaux(1: 315,m)=reshape(hg,(/ 315/))
        enddo
      ![h|h] subblock
      case(66)
        do m=1,n2
          hs( 36: 56,1)=vaux(  1: 21,m)
          is( 57: 84,1)=vaux( 22: 49,m)
          js( 85:120,1)=vaux( 50: 85,m)
          ks(121:165,1)=vaux( 86:130,m)
          ls(166:220,1)=vaux(131:185,m)
          ms(221:286,1)=vaux(186:251,m)
          call do_hp()
          call do_ip()
          call do_jp()
          call do_kp()
          call do_lp()
          call do_hd()
          call do_id()
          call do_jd()
          call do_kd()
          call do_hf()
          call do_if()
          call do_jf()
          call do_hg()
          call do_ig()
          call do_hh()
          vaux(1: 441,m)=reshape(hh,(/ 441/))
        enddo
      case default
        write(6,*) 'Subblock is out of range in interest_hrr_bra => stop'
        stop
    end select
  end subroutine
!--------------------------------------------------------------------
  subroutine interest_hrr_ket(vaux,n1,n2,l1,l2,rxi,ryi,rzi,n1r)
    integer, intent(in)    :: l1,l2
    integer, intent(in)    :: n1,n2,n1r
    real(8), intent(in)    :: rxi,ryi,rzi
    real(8), intent(inout) :: vaux(n1,n2)

    rx = rxi
    ry = ryi
    rz = rzi

    select case(10*l1+l2)
      ![s|s] subblock
      case(11)
      ![p|s] subblock
      case(21)
      ![d|s] subblock
      case(31)
      ![f|s] subblock
      case(41)
      ![g|s] subblock
      case(51)
      ![h|s] subblock
      case(61)
      ![p|p] subblock
      case(22)
        do m=1,n1r
          ps(  2:  4,1)=vaux(m,  1:  3)
          ds(  5: 10,1)=vaux(m,  4:  9)
          call do_pp()
          vaux(m,1:   9)=reshape(pp,(/   9/))
        enddo
      ![d|p] subblock
      case(32)
        do m=1,n1r
          ds(  5: 10,1)=vaux(m,  1:  6)
          fs( 11: 20,1)=vaux(m,  7: 16)
          call do_dp()
          vaux(m,1:  18)=reshape(dp,(/  18/))
        enddo
      ![f|p] subblock
      case(42)
        do m=1,n1r
          fs( 11: 20,1)=vaux(m,  1: 10)
          gs( 21: 35,1)=vaux(m, 11: 25)
          call do_fp()
          vaux(m,1:  30)=reshape(fp,(/  30/))
        enddo
      ![g|p] subblock
      case(52)
        do m=1,n1r
          gs( 21: 35,1)=vaux(m,  1: 15)
          hs( 36: 56,1)=vaux(m, 16: 36)
          call do_gp()
          vaux(m,1:  45)=reshape(gp,(/  45/))
        enddo
      ![h|p] subblock
      case(62)
        do m=1,n1r
          hs( 36: 56,1)=vaux(m,  1: 21)
          is( 57: 84,1)=vaux(m, 22: 49)
          call do_hp()
          vaux(m,1:  63)=reshape(hp,(/  63/))
        enddo
      ![d|d] subblock
      case(33)
        do m=1,n1r
          ds(  5: 10,1)=vaux(m,  1:  6)
          fs( 11: 20,1)=vaux(m,  7: 16)
          gs( 21: 35,1)=vaux(m, 17: 31)
          call do_dp()
          call do_fp()
          call do_dd()
          vaux(m,1:  36)=reshape(dd,(/  36/))
        enddo
      ![f|d] subblock
      case(43)
        do m=1,n1r
          fs( 11: 20,1)=vaux(m,  1: 10)
          gs( 21: 35,1)=vaux(m, 11: 25)
          hs( 36: 56,1)=vaux(m, 26: 46)
          call do_fp()
          call do_gp()
          call do_fd()
          vaux(m,1:  60)=reshape(fd,(/  60/))
        enddo
      ![g|d] subblock
      case(53)
        do m=1,n1r
          gs( 21: 35,1)=vaux(m,  1: 15)
          hs( 36: 56,1)=vaux(m, 16: 36)
          is( 57: 84,1)=vaux(m, 37: 64)
          call do_gp()
          call do_hp()
          call do_gd()
          vaux(m,1:  90)=reshape(gd,(/  90/))
        enddo
      ![h|d] subblock
      case(63)
        do m=1,n1r
          hs( 36: 56,1)=vaux(m,  1: 21)
          is( 57: 84,1)=vaux(m, 22: 49)
          js( 85:120,1)=vaux(m, 50: 85)
          call do_hp()
          call do_ip()
          call do_hd()
          vaux(m,1: 126)=reshape(hd,(/ 126/))
        enddo
      ![f|f] subblock
      case(44)
        do m=1,n1r
          fs( 11: 20,1)=vaux(m,  1: 10)
          gs( 21: 35,1)=vaux(m, 11: 25)
          hs( 36: 56,1)=vaux(m, 26: 46)
          is( 57: 84,1)=vaux(m, 47: 74)
          call do_fp()
          call do_gp()
          call do_hp()
          call do_fd()
          call do_gd()
          call do_ff()
          vaux(m,1: 100)=reshape(ff,(/ 100/))
        enddo
      ![g|f] subblock
      case(54)
        do m=1,n1r
          gs( 21: 35,1)=vaux(m,  1: 15)
          hs( 36: 56,1)=vaux(m, 16: 36)
          is( 57: 84,1)=vaux(m, 37: 64)
          js( 85:120,1)=vaux(m, 65:100)
          call do_gp()
          call do_hp()
          call do_ip()
          call do_gd()
          call do_hd()
          call do_gf()
          vaux(m,1: 150)=reshape(gf,(/ 150/))
        enddo
      ![h|f] subblock
      case(64)
        do m=1,n1r
          hs( 36: 56,1)=vaux(m,  1: 21)
          is( 57: 84,1)=vaux(m, 22: 49)
          js( 85:120,1)=vaux(m, 50: 85)
          ks(121:165,1)=vaux(m, 86:130)
          call do_hp()
          call do_ip()
          call do_jp()
          call do_hd()
          call do_id()
          call do_hf()
          vaux(m,1: 210)=reshape(hf,(/ 210/))
        enddo
      ![g|g] subblock
      case(55)
        do m=1,n1r
          gs( 21: 35,1)=vaux(m,  1: 15)
          hs( 36: 56,1)=vaux(m, 16: 36)
          is( 57: 84,1)=vaux(m, 37: 64)
          js( 85:120,1)=vaux(m, 65:100)
          ks(121:165,1)=vaux(m,101:145)
          call do_gp()
          call do_hp()
          call do_ip()
          call do_jp()
          call do_gd()
          call do_hd()
          call do_id()
          call do_gf()
          call do_hf()
          call do_gg()
          vaux(m,1: 225)=reshape(gg,(/ 225/))
        enddo
      ![h|g] subblock
      case(65)
        do m=1,n1r
          hs( 36: 56,1)=vaux(m,  1: 21)
          is( 57: 84,1)=vaux(m, 22: 49)
          js( 85:120,1)=vaux(m, 50: 85)
          ks(121:165,1)=vaux(m, 86:130)
          ls(166:220,1)=vaux(m,131:185)
          call do_hp()
          call do_ip()
          call do_jp()
          call do_kp()
          call do_hd()
          call do_id()
          call do_jd()
          call do_hf()
          call do_if()
          call do_hg()
          vaux(m,1: 315)=reshape(hg,(/ 315/))
        enddo
      ![h|h] subblock
      case(66)
        do m=1,n1r
          hs( 36: 56,1)=vaux(m,  1: 21)
          is( 57: 84,1)=vaux(m, 22: 49)
          js( 85:120,1)=vaux(m, 50: 85)
          ks(121:165,1)=vaux(m, 86:130)
          ls(166:220,1)=vaux(m,131:185)
          ms(221:286,1)=vaux(m,186:251)
          call do_hp()
          call do_ip()
          call do_jp()
          call do_kp()
          call do_lp()
          call do_hd()
          call do_id()
          call do_jd()
          call do_kd()
          call do_hf()
          call do_if()
          call do_jf()
          call do_hg()
          call do_ig()
          call do_hh()
          vaux(m,1: 441)=reshape(hh,(/ 441/))
        enddo
      case default
        write(6,*) 'Subblock is out of range in interest_hrr_ket => stop'
        stop
    end select
  end subroutine
!--------------------------------------------------------------------
  subroutine do_sp( )
    sp(  1,  2)=ps(  2,  1)+rx*ss(  1,  1)
    sp(  1,  3)=ps(  3,  1)+ry*ss(  1,  1)
    sp(  1,  4)=ps(  4,  1)+rz*ss(  1,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_pp( )
    pp(  2,  2)=ds(  5,  1)+rx*ps(  2,  1)
    pp(  3,  2)=ds(  6,  1)+rx*ps(  3,  1)
    pp(  4,  2)=ds(  7,  1)+rx*ps(  4,  1)
    pp(  2,  3)=ds(  6,  1)+ry*ps(  2,  1)
    pp(  3,  3)=ds(  8,  1)+ry*ps(  3,  1)
    pp(  4,  3)=ds(  9,  1)+ry*ps(  4,  1)
    pp(  2,  4)=ds(  7,  1)+rz*ps(  2,  1)
    pp(  3,  4)=ds(  9,  1)+rz*ps(  3,  1)
    pp(  4,  4)=ds( 10,  1)+rz*ps(  4,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_dp( )
    dp(  5,  2)=fs( 11,  1)+rx*ds(  5,  1)
    dp(  6,  2)=fs( 12,  1)+rx*ds(  6,  1)
    dp(  7,  2)=fs( 13,  1)+rx*ds(  7,  1)
    dp(  8,  2)=fs( 14,  1)+rx*ds(  8,  1)
    dp(  9,  2)=fs( 15,  1)+rx*ds(  9,  1)
    dp( 10,  2)=fs( 16,  1)+rx*ds( 10,  1)
    dp(  5,  3)=fs( 12,  1)+ry*ds(  5,  1)
    dp(  6,  3)=fs( 14,  1)+ry*ds(  6,  1)
    dp(  7,  3)=fs( 15,  1)+ry*ds(  7,  1)
    dp(  8,  3)=fs( 17,  1)+ry*ds(  8,  1)
    dp(  9,  3)=fs( 18,  1)+ry*ds(  9,  1)
    dp( 10,  3)=fs( 19,  1)+ry*ds( 10,  1)
    dp(  5,  4)=fs( 13,  1)+rz*ds(  5,  1)
    dp(  6,  4)=fs( 15,  1)+rz*ds(  6,  1)
    dp(  7,  4)=fs( 16,  1)+rz*ds(  7,  1)
    dp(  8,  4)=fs( 18,  1)+rz*ds(  8,  1)
    dp(  9,  4)=fs( 19,  1)+rz*ds(  9,  1)
    dp( 10,  4)=fs( 20,  1)+rz*ds( 10,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_fp( )
    fp( 11,  2)=gs( 21,  1)+rx*fs( 11,  1)
    fp( 12,  2)=gs( 22,  1)+rx*fs( 12,  1)
    fp( 13,  2)=gs( 23,  1)+rx*fs( 13,  1)
    fp( 14,  2)=gs( 24,  1)+rx*fs( 14,  1)
    fp( 15,  2)=gs( 25,  1)+rx*fs( 15,  1)
    fp( 16,  2)=gs( 26,  1)+rx*fs( 16,  1)
    fp( 17,  2)=gs( 27,  1)+rx*fs( 17,  1)
    fp( 18,  2)=gs( 28,  1)+rx*fs( 18,  1)
    fp( 19,  2)=gs( 29,  1)+rx*fs( 19,  1)
    fp( 20,  2)=gs( 30,  1)+rx*fs( 20,  1)
    fp( 11,  3)=gs( 22,  1)+ry*fs( 11,  1)
    fp( 12,  3)=gs( 24,  1)+ry*fs( 12,  1)
    fp( 13,  3)=gs( 25,  1)+ry*fs( 13,  1)
    fp( 14,  3)=gs( 27,  1)+ry*fs( 14,  1)
    fp( 15,  3)=gs( 28,  1)+ry*fs( 15,  1)
    fp( 16,  3)=gs( 29,  1)+ry*fs( 16,  1)
    fp( 17,  3)=gs( 31,  1)+ry*fs( 17,  1)
    fp( 18,  3)=gs( 32,  1)+ry*fs( 18,  1)
    fp( 19,  3)=gs( 33,  1)+ry*fs( 19,  1)
    fp( 20,  3)=gs( 34,  1)+ry*fs( 20,  1)
    fp( 11,  4)=gs( 23,  1)+rz*fs( 11,  1)
    fp( 12,  4)=gs( 25,  1)+rz*fs( 12,  1)
    fp( 13,  4)=gs( 26,  1)+rz*fs( 13,  1)
    fp( 14,  4)=gs( 28,  1)+rz*fs( 14,  1)
    fp( 15,  4)=gs( 29,  1)+rz*fs( 15,  1)
    fp( 16,  4)=gs( 30,  1)+rz*fs( 16,  1)
    fp( 17,  4)=gs( 32,  1)+rz*fs( 17,  1)
    fp( 18,  4)=gs( 33,  1)+rz*fs( 18,  1)
    fp( 19,  4)=gs( 34,  1)+rz*fs( 19,  1)
    fp( 20,  4)=gs( 35,  1)+rz*fs( 20,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_gp( )
    gp( 21,  2)=hs( 36,  1)+rx*gs( 21,  1)
    gp( 22,  2)=hs( 37,  1)+rx*gs( 22,  1)
    gp( 23,  2)=hs( 38,  1)+rx*gs( 23,  1)
    gp( 24,  2)=hs( 39,  1)+rx*gs( 24,  1)
    gp( 25,  2)=hs( 40,  1)+rx*gs( 25,  1)
    gp( 26,  2)=hs( 41,  1)+rx*gs( 26,  1)
    gp( 27,  2)=hs( 42,  1)+rx*gs( 27,  1)
    gp( 28,  2)=hs( 43,  1)+rx*gs( 28,  1)
    gp( 29,  2)=hs( 44,  1)+rx*gs( 29,  1)
    gp( 30,  2)=hs( 45,  1)+rx*gs( 30,  1)
    gp( 31,  2)=hs( 46,  1)+rx*gs( 31,  1)
    gp( 32,  2)=hs( 47,  1)+rx*gs( 32,  1)
    gp( 33,  2)=hs( 48,  1)+rx*gs( 33,  1)
    gp( 34,  2)=hs( 49,  1)+rx*gs( 34,  1)
    gp( 35,  2)=hs( 50,  1)+rx*gs( 35,  1)
    gp( 21,  3)=hs( 37,  1)+ry*gs( 21,  1)
    gp( 22,  3)=hs( 39,  1)+ry*gs( 22,  1)
    gp( 23,  3)=hs( 40,  1)+ry*gs( 23,  1)
    gp( 24,  3)=hs( 42,  1)+ry*gs( 24,  1)
    gp( 25,  3)=hs( 43,  1)+ry*gs( 25,  1)
    gp( 26,  3)=hs( 44,  1)+ry*gs( 26,  1)
    gp( 27,  3)=hs( 46,  1)+ry*gs( 27,  1)
    gp( 28,  3)=hs( 47,  1)+ry*gs( 28,  1)
    gp( 29,  3)=hs( 48,  1)+ry*gs( 29,  1)
    gp( 30,  3)=hs( 49,  1)+ry*gs( 30,  1)
    gp( 31,  3)=hs( 51,  1)+ry*gs( 31,  1)
    gp( 32,  3)=hs( 52,  1)+ry*gs( 32,  1)
    gp( 33,  3)=hs( 53,  1)+ry*gs( 33,  1)
    gp( 34,  3)=hs( 54,  1)+ry*gs( 34,  1)
    gp( 35,  3)=hs( 55,  1)+ry*gs( 35,  1)
    gp( 21,  4)=hs( 38,  1)+rz*gs( 21,  1)
    gp( 22,  4)=hs( 40,  1)+rz*gs( 22,  1)
    gp( 23,  4)=hs( 41,  1)+rz*gs( 23,  1)
    gp( 24,  4)=hs( 43,  1)+rz*gs( 24,  1)
    gp( 25,  4)=hs( 44,  1)+rz*gs( 25,  1)
    gp( 26,  4)=hs( 45,  1)+rz*gs( 26,  1)
    gp( 27,  4)=hs( 47,  1)+rz*gs( 27,  1)
    gp( 28,  4)=hs( 48,  1)+rz*gs( 28,  1)
    gp( 29,  4)=hs( 49,  1)+rz*gs( 29,  1)
    gp( 30,  4)=hs( 50,  1)+rz*gs( 30,  1)
    gp( 31,  4)=hs( 52,  1)+rz*gs( 31,  1)
    gp( 32,  4)=hs( 53,  1)+rz*gs( 32,  1)
    gp( 33,  4)=hs( 54,  1)+rz*gs( 33,  1)
    gp( 34,  4)=hs( 55,  1)+rz*gs( 34,  1)
    gp( 35,  4)=hs( 56,  1)+rz*gs( 35,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_hp( )
    hp( 36,  2)=is( 57,  1)+rx*hs( 36,  1)
    hp( 37,  2)=is( 58,  1)+rx*hs( 37,  1)
    hp( 38,  2)=is( 59,  1)+rx*hs( 38,  1)
    hp( 39,  2)=is( 60,  1)+rx*hs( 39,  1)
    hp( 40,  2)=is( 61,  1)+rx*hs( 40,  1)
    hp( 41,  2)=is( 62,  1)+rx*hs( 41,  1)
    hp( 42,  2)=is( 63,  1)+rx*hs( 42,  1)
    hp( 43,  2)=is( 64,  1)+rx*hs( 43,  1)
    hp( 44,  2)=is( 65,  1)+rx*hs( 44,  1)
    hp( 45,  2)=is( 66,  1)+rx*hs( 45,  1)
    hp( 46,  2)=is( 67,  1)+rx*hs( 46,  1)
    hp( 47,  2)=is( 68,  1)+rx*hs( 47,  1)
    hp( 48,  2)=is( 69,  1)+rx*hs( 48,  1)
    hp( 49,  2)=is( 70,  1)+rx*hs( 49,  1)
    hp( 50,  2)=is( 71,  1)+rx*hs( 50,  1)
    hp( 51,  2)=is( 72,  1)+rx*hs( 51,  1)
    hp( 52,  2)=is( 73,  1)+rx*hs( 52,  1)
    hp( 53,  2)=is( 74,  1)+rx*hs( 53,  1)
    hp( 54,  2)=is( 75,  1)+rx*hs( 54,  1)
    hp( 55,  2)=is( 76,  1)+rx*hs( 55,  1)
    hp( 56,  2)=is( 77,  1)+rx*hs( 56,  1)
    hp( 36,  3)=is( 58,  1)+ry*hs( 36,  1)
    hp( 37,  3)=is( 60,  1)+ry*hs( 37,  1)
    hp( 38,  3)=is( 61,  1)+ry*hs( 38,  1)
    hp( 39,  3)=is( 63,  1)+ry*hs( 39,  1)
    hp( 40,  3)=is( 64,  1)+ry*hs( 40,  1)
    hp( 41,  3)=is( 65,  1)+ry*hs( 41,  1)
    hp( 42,  3)=is( 67,  1)+ry*hs( 42,  1)
    hp( 43,  3)=is( 68,  1)+ry*hs( 43,  1)
    hp( 44,  3)=is( 69,  1)+ry*hs( 44,  1)
    hp( 45,  3)=is( 70,  1)+ry*hs( 45,  1)
    hp( 46,  3)=is( 72,  1)+ry*hs( 46,  1)
    hp( 47,  3)=is( 73,  1)+ry*hs( 47,  1)
    hp( 48,  3)=is( 74,  1)+ry*hs( 48,  1)
    hp( 49,  3)=is( 75,  1)+ry*hs( 49,  1)
    hp( 50,  3)=is( 76,  1)+ry*hs( 50,  1)
    hp( 51,  3)=is( 78,  1)+ry*hs( 51,  1)
    hp( 52,  3)=is( 79,  1)+ry*hs( 52,  1)
    hp( 53,  3)=is( 80,  1)+ry*hs( 53,  1)
    hp( 54,  3)=is( 81,  1)+ry*hs( 54,  1)
    hp( 55,  3)=is( 82,  1)+ry*hs( 55,  1)
    hp( 56,  3)=is( 83,  1)+ry*hs( 56,  1)
    hp( 36,  4)=is( 59,  1)+rz*hs( 36,  1)
    hp( 37,  4)=is( 61,  1)+rz*hs( 37,  1)
    hp( 38,  4)=is( 62,  1)+rz*hs( 38,  1)
    hp( 39,  4)=is( 64,  1)+rz*hs( 39,  1)
    hp( 40,  4)=is( 65,  1)+rz*hs( 40,  1)
    hp( 41,  4)=is( 66,  1)+rz*hs( 41,  1)
    hp( 42,  4)=is( 68,  1)+rz*hs( 42,  1)
    hp( 43,  4)=is( 69,  1)+rz*hs( 43,  1)
    hp( 44,  4)=is( 70,  1)+rz*hs( 44,  1)
    hp( 45,  4)=is( 71,  1)+rz*hs( 45,  1)
    hp( 46,  4)=is( 73,  1)+rz*hs( 46,  1)
    hp( 47,  4)=is( 74,  1)+rz*hs( 47,  1)
    hp( 48,  4)=is( 75,  1)+rz*hs( 48,  1)
    hp( 49,  4)=is( 76,  1)+rz*hs( 49,  1)
    hp( 50,  4)=is( 77,  1)+rz*hs( 50,  1)
    hp( 51,  4)=is( 79,  1)+rz*hs( 51,  1)
    hp( 52,  4)=is( 80,  1)+rz*hs( 52,  1)
    hp( 53,  4)=is( 81,  1)+rz*hs( 53,  1)
    hp( 54,  4)=is( 82,  1)+rz*hs( 54,  1)
    hp( 55,  4)=is( 83,  1)+rz*hs( 55,  1)
    hp( 56,  4)=is( 84,  1)+rz*hs( 56,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_ip( )
    ip( 57,  2)=js( 85,  1)+rx*is( 57,  1)
    ip( 58,  2)=js( 86,  1)+rx*is( 58,  1)
    ip( 59,  2)=js( 87,  1)+rx*is( 59,  1)
    ip( 60,  2)=js( 88,  1)+rx*is( 60,  1)
    ip( 61,  2)=js( 89,  1)+rx*is( 61,  1)
    ip( 62,  2)=js( 90,  1)+rx*is( 62,  1)
    ip( 63,  2)=js( 91,  1)+rx*is( 63,  1)
    ip( 64,  2)=js( 92,  1)+rx*is( 64,  1)
    ip( 65,  2)=js( 93,  1)+rx*is( 65,  1)
    ip( 66,  2)=js( 94,  1)+rx*is( 66,  1)
    ip( 67,  2)=js( 95,  1)+rx*is( 67,  1)
    ip( 68,  2)=js( 96,  1)+rx*is( 68,  1)
    ip( 69,  2)=js( 97,  1)+rx*is( 69,  1)
    ip( 70,  2)=js( 98,  1)+rx*is( 70,  1)
    ip( 71,  2)=js( 99,  1)+rx*is( 71,  1)
    ip( 72,  2)=js(100,  1)+rx*is( 72,  1)
    ip( 73,  2)=js(101,  1)+rx*is( 73,  1)
    ip( 74,  2)=js(102,  1)+rx*is( 74,  1)
    ip( 75,  2)=js(103,  1)+rx*is( 75,  1)
    ip( 76,  2)=js(104,  1)+rx*is( 76,  1)
    ip( 77,  2)=js(105,  1)+rx*is( 77,  1)
    ip( 78,  2)=js(106,  1)+rx*is( 78,  1)
    ip( 79,  2)=js(107,  1)+rx*is( 79,  1)
    ip( 80,  2)=js(108,  1)+rx*is( 80,  1)
    ip( 81,  2)=js(109,  1)+rx*is( 81,  1)
    ip( 82,  2)=js(110,  1)+rx*is( 82,  1)
    ip( 83,  2)=js(111,  1)+rx*is( 83,  1)
    ip( 84,  2)=js(112,  1)+rx*is( 84,  1)
    ip( 57,  3)=js( 86,  1)+ry*is( 57,  1)
    ip( 58,  3)=js( 88,  1)+ry*is( 58,  1)
    ip( 59,  3)=js( 89,  1)+ry*is( 59,  1)
    ip( 60,  3)=js( 91,  1)+ry*is( 60,  1)
    ip( 61,  3)=js( 92,  1)+ry*is( 61,  1)
    ip( 62,  3)=js( 93,  1)+ry*is( 62,  1)
    ip( 63,  3)=js( 95,  1)+ry*is( 63,  1)
    ip( 64,  3)=js( 96,  1)+ry*is( 64,  1)
    ip( 65,  3)=js( 97,  1)+ry*is( 65,  1)
    ip( 66,  3)=js( 98,  1)+ry*is( 66,  1)
    ip( 67,  3)=js(100,  1)+ry*is( 67,  1)
    ip( 68,  3)=js(101,  1)+ry*is( 68,  1)
    ip( 69,  3)=js(102,  1)+ry*is( 69,  1)
    ip( 70,  3)=js(103,  1)+ry*is( 70,  1)
    ip( 71,  3)=js(104,  1)+ry*is( 71,  1)
    ip( 72,  3)=js(106,  1)+ry*is( 72,  1)
    ip( 73,  3)=js(107,  1)+ry*is( 73,  1)
    ip( 74,  3)=js(108,  1)+ry*is( 74,  1)
    ip( 75,  3)=js(109,  1)+ry*is( 75,  1)
    ip( 76,  3)=js(110,  1)+ry*is( 76,  1)
    ip( 77,  3)=js(111,  1)+ry*is( 77,  1)
    ip( 78,  3)=js(113,  1)+ry*is( 78,  1)
    ip( 79,  3)=js(114,  1)+ry*is( 79,  1)
    ip( 80,  3)=js(115,  1)+ry*is( 80,  1)
    ip( 81,  3)=js(116,  1)+ry*is( 81,  1)
    ip( 82,  3)=js(117,  1)+ry*is( 82,  1)
    ip( 83,  3)=js(118,  1)+ry*is( 83,  1)
    ip( 84,  3)=js(119,  1)+ry*is( 84,  1)
    ip( 57,  4)=js( 87,  1)+rz*is( 57,  1)
    ip( 58,  4)=js( 89,  1)+rz*is( 58,  1)
    ip( 59,  4)=js( 90,  1)+rz*is( 59,  1)
    ip( 60,  4)=js( 92,  1)+rz*is( 60,  1)
    ip( 61,  4)=js( 93,  1)+rz*is( 61,  1)
    ip( 62,  4)=js( 94,  1)+rz*is( 62,  1)
    ip( 63,  4)=js( 96,  1)+rz*is( 63,  1)
    ip( 64,  4)=js( 97,  1)+rz*is( 64,  1)
    ip( 65,  4)=js( 98,  1)+rz*is( 65,  1)
    ip( 66,  4)=js( 99,  1)+rz*is( 66,  1)
    ip( 67,  4)=js(101,  1)+rz*is( 67,  1)
    ip( 68,  4)=js(102,  1)+rz*is( 68,  1)
    ip( 69,  4)=js(103,  1)+rz*is( 69,  1)
    ip( 70,  4)=js(104,  1)+rz*is( 70,  1)
    ip( 71,  4)=js(105,  1)+rz*is( 71,  1)
    ip( 72,  4)=js(107,  1)+rz*is( 72,  1)
    ip( 73,  4)=js(108,  1)+rz*is( 73,  1)
    ip( 74,  4)=js(109,  1)+rz*is( 74,  1)
    ip( 75,  4)=js(110,  1)+rz*is( 75,  1)
    ip( 76,  4)=js(111,  1)+rz*is( 76,  1)
    ip( 77,  4)=js(112,  1)+rz*is( 77,  1)
    ip( 78,  4)=js(114,  1)+rz*is( 78,  1)
    ip( 79,  4)=js(115,  1)+rz*is( 79,  1)
    ip( 80,  4)=js(116,  1)+rz*is( 80,  1)
    ip( 81,  4)=js(117,  1)+rz*is( 81,  1)
    ip( 82,  4)=js(118,  1)+rz*is( 82,  1)
    ip( 83,  4)=js(119,  1)+rz*is( 83,  1)
    ip( 84,  4)=js(120,  1)+rz*is( 84,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_jp( )
    jp( 85,  2)=ks(121,  1)+rx*js( 85,  1)
    jp( 86,  2)=ks(122,  1)+rx*js( 86,  1)
    jp( 87,  2)=ks(123,  1)+rx*js( 87,  1)
    jp( 88,  2)=ks(124,  1)+rx*js( 88,  1)
    jp( 89,  2)=ks(125,  1)+rx*js( 89,  1)
    jp( 90,  2)=ks(126,  1)+rx*js( 90,  1)
    jp( 91,  2)=ks(127,  1)+rx*js( 91,  1)
    jp( 92,  2)=ks(128,  1)+rx*js( 92,  1)
    jp( 93,  2)=ks(129,  1)+rx*js( 93,  1)
    jp( 94,  2)=ks(130,  1)+rx*js( 94,  1)
    jp( 95,  2)=ks(131,  1)+rx*js( 95,  1)
    jp( 96,  2)=ks(132,  1)+rx*js( 96,  1)
    jp( 97,  2)=ks(133,  1)+rx*js( 97,  1)
    jp( 98,  2)=ks(134,  1)+rx*js( 98,  1)
    jp( 99,  2)=ks(135,  1)+rx*js( 99,  1)
    jp(100,  2)=ks(136,  1)+rx*js(100,  1)
    jp(101,  2)=ks(137,  1)+rx*js(101,  1)
    jp(102,  2)=ks(138,  1)+rx*js(102,  1)
    jp(103,  2)=ks(139,  1)+rx*js(103,  1)
    jp(104,  2)=ks(140,  1)+rx*js(104,  1)
    jp(105,  2)=ks(141,  1)+rx*js(105,  1)
    jp(106,  2)=ks(142,  1)+rx*js(106,  1)
    jp(107,  2)=ks(143,  1)+rx*js(107,  1)
    jp(108,  2)=ks(144,  1)+rx*js(108,  1)
    jp(109,  2)=ks(145,  1)+rx*js(109,  1)
    jp(110,  2)=ks(146,  1)+rx*js(110,  1)
    jp(111,  2)=ks(147,  1)+rx*js(111,  1)
    jp(112,  2)=ks(148,  1)+rx*js(112,  1)
    jp(113,  2)=ks(149,  1)+rx*js(113,  1)
    jp(114,  2)=ks(150,  1)+rx*js(114,  1)
    jp(115,  2)=ks(151,  1)+rx*js(115,  1)
    jp(116,  2)=ks(152,  1)+rx*js(116,  1)
    jp(117,  2)=ks(153,  1)+rx*js(117,  1)
    jp(118,  2)=ks(154,  1)+rx*js(118,  1)
    jp(119,  2)=ks(155,  1)+rx*js(119,  1)
    jp(120,  2)=ks(156,  1)+rx*js(120,  1)
    jp( 85,  3)=ks(122,  1)+ry*js( 85,  1)
    jp( 86,  3)=ks(124,  1)+ry*js( 86,  1)
    jp( 87,  3)=ks(125,  1)+ry*js( 87,  1)
    jp( 88,  3)=ks(127,  1)+ry*js( 88,  1)
    jp( 89,  3)=ks(128,  1)+ry*js( 89,  1)
    jp( 90,  3)=ks(129,  1)+ry*js( 90,  1)
    jp( 91,  3)=ks(131,  1)+ry*js( 91,  1)
    jp( 92,  3)=ks(132,  1)+ry*js( 92,  1)
    jp( 93,  3)=ks(133,  1)+ry*js( 93,  1)
    jp( 94,  3)=ks(134,  1)+ry*js( 94,  1)
    jp( 95,  3)=ks(136,  1)+ry*js( 95,  1)
    jp( 96,  3)=ks(137,  1)+ry*js( 96,  1)
    jp( 97,  3)=ks(138,  1)+ry*js( 97,  1)
    jp( 98,  3)=ks(139,  1)+ry*js( 98,  1)
    jp( 99,  3)=ks(140,  1)+ry*js( 99,  1)
    jp(100,  3)=ks(142,  1)+ry*js(100,  1)
    jp(101,  3)=ks(143,  1)+ry*js(101,  1)
    jp(102,  3)=ks(144,  1)+ry*js(102,  1)
    jp(103,  3)=ks(145,  1)+ry*js(103,  1)
    jp(104,  3)=ks(146,  1)+ry*js(104,  1)
    jp(105,  3)=ks(147,  1)+ry*js(105,  1)
    jp(106,  3)=ks(149,  1)+ry*js(106,  1)
    jp(107,  3)=ks(150,  1)+ry*js(107,  1)
    jp(108,  3)=ks(151,  1)+ry*js(108,  1)
    jp(109,  3)=ks(152,  1)+ry*js(109,  1)
    jp(110,  3)=ks(153,  1)+ry*js(110,  1)
    jp(111,  3)=ks(154,  1)+ry*js(111,  1)
    jp(112,  3)=ks(155,  1)+ry*js(112,  1)
    jp(113,  3)=ks(157,  1)+ry*js(113,  1)
    jp(114,  3)=ks(158,  1)+ry*js(114,  1)
    jp(115,  3)=ks(159,  1)+ry*js(115,  1)
    jp(116,  3)=ks(160,  1)+ry*js(116,  1)
    jp(117,  3)=ks(161,  1)+ry*js(117,  1)
    jp(118,  3)=ks(162,  1)+ry*js(118,  1)
    jp(119,  3)=ks(163,  1)+ry*js(119,  1)
    jp(120,  3)=ks(164,  1)+ry*js(120,  1)
    jp( 85,  4)=ks(123,  1)+rz*js( 85,  1)
    jp( 86,  4)=ks(125,  1)+rz*js( 86,  1)
    jp( 87,  4)=ks(126,  1)+rz*js( 87,  1)
    jp( 88,  4)=ks(128,  1)+rz*js( 88,  1)
    jp( 89,  4)=ks(129,  1)+rz*js( 89,  1)
    jp( 90,  4)=ks(130,  1)+rz*js( 90,  1)
    jp( 91,  4)=ks(132,  1)+rz*js( 91,  1)
    jp( 92,  4)=ks(133,  1)+rz*js( 92,  1)
    jp( 93,  4)=ks(134,  1)+rz*js( 93,  1)
    jp( 94,  4)=ks(135,  1)+rz*js( 94,  1)
    jp( 95,  4)=ks(137,  1)+rz*js( 95,  1)
    jp( 96,  4)=ks(138,  1)+rz*js( 96,  1)
    jp( 97,  4)=ks(139,  1)+rz*js( 97,  1)
    jp( 98,  4)=ks(140,  1)+rz*js( 98,  1)
    jp( 99,  4)=ks(141,  1)+rz*js( 99,  1)
    jp(100,  4)=ks(143,  1)+rz*js(100,  1)
    jp(101,  4)=ks(144,  1)+rz*js(101,  1)
    jp(102,  4)=ks(145,  1)+rz*js(102,  1)
    jp(103,  4)=ks(146,  1)+rz*js(103,  1)
    jp(104,  4)=ks(147,  1)+rz*js(104,  1)
    jp(105,  4)=ks(148,  1)+rz*js(105,  1)
    jp(106,  4)=ks(150,  1)+rz*js(106,  1)
    jp(107,  4)=ks(151,  1)+rz*js(107,  1)
    jp(108,  4)=ks(152,  1)+rz*js(108,  1)
    jp(109,  4)=ks(153,  1)+rz*js(109,  1)
    jp(110,  4)=ks(154,  1)+rz*js(110,  1)
    jp(111,  4)=ks(155,  1)+rz*js(111,  1)
    jp(112,  4)=ks(156,  1)+rz*js(112,  1)
    jp(113,  4)=ks(158,  1)+rz*js(113,  1)
    jp(114,  4)=ks(159,  1)+rz*js(114,  1)
    jp(115,  4)=ks(160,  1)+rz*js(115,  1)
    jp(116,  4)=ks(161,  1)+rz*js(116,  1)
    jp(117,  4)=ks(162,  1)+rz*js(117,  1)
    jp(118,  4)=ks(163,  1)+rz*js(118,  1)
    jp(119,  4)=ks(164,  1)+rz*js(119,  1)
    jp(120,  4)=ks(165,  1)+rz*js(120,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_kp( )
    kp(121,  2)=ls(166,  1)+rx*ks(121,  1)
    kp(122,  2)=ls(167,  1)+rx*ks(122,  1)
    kp(123,  2)=ls(168,  1)+rx*ks(123,  1)
    kp(124,  2)=ls(169,  1)+rx*ks(124,  1)
    kp(125,  2)=ls(170,  1)+rx*ks(125,  1)
    kp(126,  2)=ls(171,  1)+rx*ks(126,  1)
    kp(127,  2)=ls(172,  1)+rx*ks(127,  1)
    kp(128,  2)=ls(173,  1)+rx*ks(128,  1)
    kp(129,  2)=ls(174,  1)+rx*ks(129,  1)
    kp(130,  2)=ls(175,  1)+rx*ks(130,  1)
    kp(131,  2)=ls(176,  1)+rx*ks(131,  1)
    kp(132,  2)=ls(177,  1)+rx*ks(132,  1)
    kp(133,  2)=ls(178,  1)+rx*ks(133,  1)
    kp(134,  2)=ls(179,  1)+rx*ks(134,  1)
    kp(135,  2)=ls(180,  1)+rx*ks(135,  1)
    kp(136,  2)=ls(181,  1)+rx*ks(136,  1)
    kp(137,  2)=ls(182,  1)+rx*ks(137,  1)
    kp(138,  2)=ls(183,  1)+rx*ks(138,  1)
    kp(139,  2)=ls(184,  1)+rx*ks(139,  1)
    kp(140,  2)=ls(185,  1)+rx*ks(140,  1)
    kp(141,  2)=ls(186,  1)+rx*ks(141,  1)
    kp(142,  2)=ls(187,  1)+rx*ks(142,  1)
    kp(143,  2)=ls(188,  1)+rx*ks(143,  1)
    kp(144,  2)=ls(189,  1)+rx*ks(144,  1)
    kp(145,  2)=ls(190,  1)+rx*ks(145,  1)
    kp(146,  2)=ls(191,  1)+rx*ks(146,  1)
    kp(147,  2)=ls(192,  1)+rx*ks(147,  1)
    kp(148,  2)=ls(193,  1)+rx*ks(148,  1)
    kp(149,  2)=ls(194,  1)+rx*ks(149,  1)
    kp(150,  2)=ls(195,  1)+rx*ks(150,  1)
    kp(151,  2)=ls(196,  1)+rx*ks(151,  1)
    kp(152,  2)=ls(197,  1)+rx*ks(152,  1)
    kp(153,  2)=ls(198,  1)+rx*ks(153,  1)
    kp(154,  2)=ls(199,  1)+rx*ks(154,  1)
    kp(155,  2)=ls(200,  1)+rx*ks(155,  1)
    kp(156,  2)=ls(201,  1)+rx*ks(156,  1)
    kp(157,  2)=ls(202,  1)+rx*ks(157,  1)
    kp(158,  2)=ls(203,  1)+rx*ks(158,  1)
    kp(159,  2)=ls(204,  1)+rx*ks(159,  1)
    kp(160,  2)=ls(205,  1)+rx*ks(160,  1)
    kp(161,  2)=ls(206,  1)+rx*ks(161,  1)
    kp(162,  2)=ls(207,  1)+rx*ks(162,  1)
    kp(163,  2)=ls(208,  1)+rx*ks(163,  1)
    kp(164,  2)=ls(209,  1)+rx*ks(164,  1)
    kp(165,  2)=ls(210,  1)+rx*ks(165,  1)
    kp(121,  3)=ls(167,  1)+ry*ks(121,  1)
    kp(122,  3)=ls(169,  1)+ry*ks(122,  1)
    kp(123,  3)=ls(170,  1)+ry*ks(123,  1)
    kp(124,  3)=ls(172,  1)+ry*ks(124,  1)
    kp(125,  3)=ls(173,  1)+ry*ks(125,  1)
    kp(126,  3)=ls(174,  1)+ry*ks(126,  1)
    kp(127,  3)=ls(176,  1)+ry*ks(127,  1)
    kp(128,  3)=ls(177,  1)+ry*ks(128,  1)
    kp(129,  3)=ls(178,  1)+ry*ks(129,  1)
    kp(130,  3)=ls(179,  1)+ry*ks(130,  1)
    kp(131,  3)=ls(181,  1)+ry*ks(131,  1)
    kp(132,  3)=ls(182,  1)+ry*ks(132,  1)
    kp(133,  3)=ls(183,  1)+ry*ks(133,  1)
    kp(134,  3)=ls(184,  1)+ry*ks(134,  1)
    kp(135,  3)=ls(185,  1)+ry*ks(135,  1)
    kp(136,  3)=ls(187,  1)+ry*ks(136,  1)
    kp(137,  3)=ls(188,  1)+ry*ks(137,  1)
    kp(138,  3)=ls(189,  1)+ry*ks(138,  1)
    kp(139,  3)=ls(190,  1)+ry*ks(139,  1)
    kp(140,  3)=ls(191,  1)+ry*ks(140,  1)
    kp(141,  3)=ls(192,  1)+ry*ks(141,  1)
    kp(142,  3)=ls(194,  1)+ry*ks(142,  1)
    kp(143,  3)=ls(195,  1)+ry*ks(143,  1)
    kp(144,  3)=ls(196,  1)+ry*ks(144,  1)
    kp(145,  3)=ls(197,  1)+ry*ks(145,  1)
    kp(146,  3)=ls(198,  1)+ry*ks(146,  1)
    kp(147,  3)=ls(199,  1)+ry*ks(147,  1)
    kp(148,  3)=ls(200,  1)+ry*ks(148,  1)
    kp(149,  3)=ls(202,  1)+ry*ks(149,  1)
    kp(150,  3)=ls(203,  1)+ry*ks(150,  1)
    kp(151,  3)=ls(204,  1)+ry*ks(151,  1)
    kp(152,  3)=ls(205,  1)+ry*ks(152,  1)
    kp(153,  3)=ls(206,  1)+ry*ks(153,  1)
    kp(154,  3)=ls(207,  1)+ry*ks(154,  1)
    kp(155,  3)=ls(208,  1)+ry*ks(155,  1)
    kp(156,  3)=ls(209,  1)+ry*ks(156,  1)
    kp(157,  3)=ls(211,  1)+ry*ks(157,  1)
    kp(158,  3)=ls(212,  1)+ry*ks(158,  1)
    kp(159,  3)=ls(213,  1)+ry*ks(159,  1)
    kp(160,  3)=ls(214,  1)+ry*ks(160,  1)
    kp(161,  3)=ls(215,  1)+ry*ks(161,  1)
    kp(162,  3)=ls(216,  1)+ry*ks(162,  1)
    kp(163,  3)=ls(217,  1)+ry*ks(163,  1)
    kp(164,  3)=ls(218,  1)+ry*ks(164,  1)
    kp(165,  3)=ls(219,  1)+ry*ks(165,  1)
    kp(121,  4)=ls(168,  1)+rz*ks(121,  1)
    kp(122,  4)=ls(170,  1)+rz*ks(122,  1)
    kp(123,  4)=ls(171,  1)+rz*ks(123,  1)
    kp(124,  4)=ls(173,  1)+rz*ks(124,  1)
    kp(125,  4)=ls(174,  1)+rz*ks(125,  1)
    kp(126,  4)=ls(175,  1)+rz*ks(126,  1)
    kp(127,  4)=ls(177,  1)+rz*ks(127,  1)
    kp(128,  4)=ls(178,  1)+rz*ks(128,  1)
    kp(129,  4)=ls(179,  1)+rz*ks(129,  1)
    kp(130,  4)=ls(180,  1)+rz*ks(130,  1)
    kp(131,  4)=ls(182,  1)+rz*ks(131,  1)
    kp(132,  4)=ls(183,  1)+rz*ks(132,  1)
    kp(133,  4)=ls(184,  1)+rz*ks(133,  1)
    kp(134,  4)=ls(185,  1)+rz*ks(134,  1)
    kp(135,  4)=ls(186,  1)+rz*ks(135,  1)
    kp(136,  4)=ls(188,  1)+rz*ks(136,  1)
    kp(137,  4)=ls(189,  1)+rz*ks(137,  1)
    kp(138,  4)=ls(190,  1)+rz*ks(138,  1)
    kp(139,  4)=ls(191,  1)+rz*ks(139,  1)
    kp(140,  4)=ls(192,  1)+rz*ks(140,  1)
    kp(141,  4)=ls(193,  1)+rz*ks(141,  1)
    kp(142,  4)=ls(195,  1)+rz*ks(142,  1)
    kp(143,  4)=ls(196,  1)+rz*ks(143,  1)
    kp(144,  4)=ls(197,  1)+rz*ks(144,  1)
    kp(145,  4)=ls(198,  1)+rz*ks(145,  1)
    kp(146,  4)=ls(199,  1)+rz*ks(146,  1)
    kp(147,  4)=ls(200,  1)+rz*ks(147,  1)
    kp(148,  4)=ls(201,  1)+rz*ks(148,  1)
    kp(149,  4)=ls(203,  1)+rz*ks(149,  1)
    kp(150,  4)=ls(204,  1)+rz*ks(150,  1)
    kp(151,  4)=ls(205,  1)+rz*ks(151,  1)
    kp(152,  4)=ls(206,  1)+rz*ks(152,  1)
    kp(153,  4)=ls(207,  1)+rz*ks(153,  1)
    kp(154,  4)=ls(208,  1)+rz*ks(154,  1)
    kp(155,  4)=ls(209,  1)+rz*ks(155,  1)
    kp(156,  4)=ls(210,  1)+rz*ks(156,  1)
    kp(157,  4)=ls(212,  1)+rz*ks(157,  1)
    kp(158,  4)=ls(213,  1)+rz*ks(158,  1)
    kp(159,  4)=ls(214,  1)+rz*ks(159,  1)
    kp(160,  4)=ls(215,  1)+rz*ks(160,  1)
    kp(161,  4)=ls(216,  1)+rz*ks(161,  1)
    kp(162,  4)=ls(217,  1)+rz*ks(162,  1)
    kp(163,  4)=ls(218,  1)+rz*ks(163,  1)
    kp(164,  4)=ls(219,  1)+rz*ks(164,  1)
    kp(165,  4)=ls(220,  1)+rz*ks(165,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_lp( )
    lp(166,  2)=ms(221,  1)+rx*ls(166,  1)
    lp(167,  2)=ms(222,  1)+rx*ls(167,  1)
    lp(168,  2)=ms(223,  1)+rx*ls(168,  1)
    lp(169,  2)=ms(224,  1)+rx*ls(169,  1)
    lp(170,  2)=ms(225,  1)+rx*ls(170,  1)
    lp(171,  2)=ms(226,  1)+rx*ls(171,  1)
    lp(172,  2)=ms(227,  1)+rx*ls(172,  1)
    lp(173,  2)=ms(228,  1)+rx*ls(173,  1)
    lp(174,  2)=ms(229,  1)+rx*ls(174,  1)
    lp(175,  2)=ms(230,  1)+rx*ls(175,  1)
    lp(176,  2)=ms(231,  1)+rx*ls(176,  1)
    lp(177,  2)=ms(232,  1)+rx*ls(177,  1)
    lp(178,  2)=ms(233,  1)+rx*ls(178,  1)
    lp(179,  2)=ms(234,  1)+rx*ls(179,  1)
    lp(180,  2)=ms(235,  1)+rx*ls(180,  1)
    lp(181,  2)=ms(236,  1)+rx*ls(181,  1)
    lp(182,  2)=ms(237,  1)+rx*ls(182,  1)
    lp(183,  2)=ms(238,  1)+rx*ls(183,  1)
    lp(184,  2)=ms(239,  1)+rx*ls(184,  1)
    lp(185,  2)=ms(240,  1)+rx*ls(185,  1)
    lp(186,  2)=ms(241,  1)+rx*ls(186,  1)
    lp(187,  2)=ms(242,  1)+rx*ls(187,  1)
    lp(188,  2)=ms(243,  1)+rx*ls(188,  1)
    lp(189,  2)=ms(244,  1)+rx*ls(189,  1)
    lp(190,  2)=ms(245,  1)+rx*ls(190,  1)
    lp(191,  2)=ms(246,  1)+rx*ls(191,  1)
    lp(192,  2)=ms(247,  1)+rx*ls(192,  1)
    lp(193,  2)=ms(248,  1)+rx*ls(193,  1)
    lp(194,  2)=ms(249,  1)+rx*ls(194,  1)
    lp(195,  2)=ms(250,  1)+rx*ls(195,  1)
    lp(196,  2)=ms(251,  1)+rx*ls(196,  1)
    lp(197,  2)=ms(252,  1)+rx*ls(197,  1)
    lp(198,  2)=ms(253,  1)+rx*ls(198,  1)
    lp(199,  2)=ms(254,  1)+rx*ls(199,  1)
    lp(200,  2)=ms(255,  1)+rx*ls(200,  1)
    lp(201,  2)=ms(256,  1)+rx*ls(201,  1)
    lp(202,  2)=ms(257,  1)+rx*ls(202,  1)
    lp(203,  2)=ms(258,  1)+rx*ls(203,  1)
    lp(204,  2)=ms(259,  1)+rx*ls(204,  1)
    lp(205,  2)=ms(260,  1)+rx*ls(205,  1)
    lp(206,  2)=ms(261,  1)+rx*ls(206,  1)
    lp(207,  2)=ms(262,  1)+rx*ls(207,  1)
    lp(208,  2)=ms(263,  1)+rx*ls(208,  1)
    lp(209,  2)=ms(264,  1)+rx*ls(209,  1)
    lp(210,  2)=ms(265,  1)+rx*ls(210,  1)
    lp(211,  2)=ms(266,  1)+rx*ls(211,  1)
    lp(212,  2)=ms(267,  1)+rx*ls(212,  1)
    lp(213,  2)=ms(268,  1)+rx*ls(213,  1)
    lp(214,  2)=ms(269,  1)+rx*ls(214,  1)
    lp(215,  2)=ms(270,  1)+rx*ls(215,  1)
    lp(216,  2)=ms(271,  1)+rx*ls(216,  1)
    lp(217,  2)=ms(272,  1)+rx*ls(217,  1)
    lp(218,  2)=ms(273,  1)+rx*ls(218,  1)
    lp(219,  2)=ms(274,  1)+rx*ls(219,  1)
    lp(220,  2)=ms(275,  1)+rx*ls(220,  1)
    lp(166,  3)=ms(222,  1)+ry*ls(166,  1)
    lp(167,  3)=ms(224,  1)+ry*ls(167,  1)
    lp(168,  3)=ms(225,  1)+ry*ls(168,  1)
    lp(169,  3)=ms(227,  1)+ry*ls(169,  1)
    lp(170,  3)=ms(228,  1)+ry*ls(170,  1)
    lp(171,  3)=ms(229,  1)+ry*ls(171,  1)
    lp(172,  3)=ms(231,  1)+ry*ls(172,  1)
    lp(173,  3)=ms(232,  1)+ry*ls(173,  1)
    lp(174,  3)=ms(233,  1)+ry*ls(174,  1)
    lp(175,  3)=ms(234,  1)+ry*ls(175,  1)
    lp(176,  3)=ms(236,  1)+ry*ls(176,  1)
    lp(177,  3)=ms(237,  1)+ry*ls(177,  1)
    lp(178,  3)=ms(238,  1)+ry*ls(178,  1)
    lp(179,  3)=ms(239,  1)+ry*ls(179,  1)
    lp(180,  3)=ms(240,  1)+ry*ls(180,  1)
    lp(181,  3)=ms(242,  1)+ry*ls(181,  1)
    lp(182,  3)=ms(243,  1)+ry*ls(182,  1)
    lp(183,  3)=ms(244,  1)+ry*ls(183,  1)
    lp(184,  3)=ms(245,  1)+ry*ls(184,  1)
    lp(185,  3)=ms(246,  1)+ry*ls(185,  1)
    lp(186,  3)=ms(247,  1)+ry*ls(186,  1)
    lp(187,  3)=ms(249,  1)+ry*ls(187,  1)
    lp(188,  3)=ms(250,  1)+ry*ls(188,  1)
    lp(189,  3)=ms(251,  1)+ry*ls(189,  1)
    lp(190,  3)=ms(252,  1)+ry*ls(190,  1)
    lp(191,  3)=ms(253,  1)+ry*ls(191,  1)
    lp(192,  3)=ms(254,  1)+ry*ls(192,  1)
    lp(193,  3)=ms(255,  1)+ry*ls(193,  1)
    lp(194,  3)=ms(257,  1)+ry*ls(194,  1)
    lp(195,  3)=ms(258,  1)+ry*ls(195,  1)
    lp(196,  3)=ms(259,  1)+ry*ls(196,  1)
    lp(197,  3)=ms(260,  1)+ry*ls(197,  1)
    lp(198,  3)=ms(261,  1)+ry*ls(198,  1)
    lp(199,  3)=ms(262,  1)+ry*ls(199,  1)
    lp(200,  3)=ms(263,  1)+ry*ls(200,  1)
    lp(201,  3)=ms(264,  1)+ry*ls(201,  1)
    lp(202,  3)=ms(266,  1)+ry*ls(202,  1)
    lp(203,  3)=ms(267,  1)+ry*ls(203,  1)
    lp(204,  3)=ms(268,  1)+ry*ls(204,  1)
    lp(205,  3)=ms(269,  1)+ry*ls(205,  1)
    lp(206,  3)=ms(270,  1)+ry*ls(206,  1)
    lp(207,  3)=ms(271,  1)+ry*ls(207,  1)
    lp(208,  3)=ms(272,  1)+ry*ls(208,  1)
    lp(209,  3)=ms(273,  1)+ry*ls(209,  1)
    lp(210,  3)=ms(274,  1)+ry*ls(210,  1)
    lp(211,  3)=ms(276,  1)+ry*ls(211,  1)
    lp(212,  3)=ms(277,  1)+ry*ls(212,  1)
    lp(213,  3)=ms(278,  1)+ry*ls(213,  1)
    lp(214,  3)=ms(279,  1)+ry*ls(214,  1)
    lp(215,  3)=ms(280,  1)+ry*ls(215,  1)
    lp(216,  3)=ms(281,  1)+ry*ls(216,  1)
    lp(217,  3)=ms(282,  1)+ry*ls(217,  1)
    lp(218,  3)=ms(283,  1)+ry*ls(218,  1)
    lp(219,  3)=ms(284,  1)+ry*ls(219,  1)
    lp(220,  3)=ms(285,  1)+ry*ls(220,  1)
    lp(166,  4)=ms(223,  1)+rz*ls(166,  1)
    lp(167,  4)=ms(225,  1)+rz*ls(167,  1)
    lp(168,  4)=ms(226,  1)+rz*ls(168,  1)
    lp(169,  4)=ms(228,  1)+rz*ls(169,  1)
    lp(170,  4)=ms(229,  1)+rz*ls(170,  1)
    lp(171,  4)=ms(230,  1)+rz*ls(171,  1)
    lp(172,  4)=ms(232,  1)+rz*ls(172,  1)
    lp(173,  4)=ms(233,  1)+rz*ls(173,  1)
    lp(174,  4)=ms(234,  1)+rz*ls(174,  1)
    lp(175,  4)=ms(235,  1)+rz*ls(175,  1)
    lp(176,  4)=ms(237,  1)+rz*ls(176,  1)
    lp(177,  4)=ms(238,  1)+rz*ls(177,  1)
    lp(178,  4)=ms(239,  1)+rz*ls(178,  1)
    lp(179,  4)=ms(240,  1)+rz*ls(179,  1)
    lp(180,  4)=ms(241,  1)+rz*ls(180,  1)
    lp(181,  4)=ms(243,  1)+rz*ls(181,  1)
    lp(182,  4)=ms(244,  1)+rz*ls(182,  1)
    lp(183,  4)=ms(245,  1)+rz*ls(183,  1)
    lp(184,  4)=ms(246,  1)+rz*ls(184,  1)
    lp(185,  4)=ms(247,  1)+rz*ls(185,  1)
    lp(186,  4)=ms(248,  1)+rz*ls(186,  1)
    lp(187,  4)=ms(250,  1)+rz*ls(187,  1)
    lp(188,  4)=ms(251,  1)+rz*ls(188,  1)
    lp(189,  4)=ms(252,  1)+rz*ls(189,  1)
    lp(190,  4)=ms(253,  1)+rz*ls(190,  1)
    lp(191,  4)=ms(254,  1)+rz*ls(191,  1)
    lp(192,  4)=ms(255,  1)+rz*ls(192,  1)
    lp(193,  4)=ms(256,  1)+rz*ls(193,  1)
    lp(194,  4)=ms(258,  1)+rz*ls(194,  1)
    lp(195,  4)=ms(259,  1)+rz*ls(195,  1)
    lp(196,  4)=ms(260,  1)+rz*ls(196,  1)
    lp(197,  4)=ms(261,  1)+rz*ls(197,  1)
    lp(198,  4)=ms(262,  1)+rz*ls(198,  1)
    lp(199,  4)=ms(263,  1)+rz*ls(199,  1)
    lp(200,  4)=ms(264,  1)+rz*ls(200,  1)
    lp(201,  4)=ms(265,  1)+rz*ls(201,  1)
    lp(202,  4)=ms(267,  1)+rz*ls(202,  1)
    lp(203,  4)=ms(268,  1)+rz*ls(203,  1)
    lp(204,  4)=ms(269,  1)+rz*ls(204,  1)
    lp(205,  4)=ms(270,  1)+rz*ls(205,  1)
    lp(206,  4)=ms(271,  1)+rz*ls(206,  1)
    lp(207,  4)=ms(272,  1)+rz*ls(207,  1)
    lp(208,  4)=ms(273,  1)+rz*ls(208,  1)
    lp(209,  4)=ms(274,  1)+rz*ls(209,  1)
    lp(210,  4)=ms(275,  1)+rz*ls(210,  1)
    lp(211,  4)=ms(277,  1)+rz*ls(211,  1)
    lp(212,  4)=ms(278,  1)+rz*ls(212,  1)
    lp(213,  4)=ms(279,  1)+rz*ls(213,  1)
    lp(214,  4)=ms(280,  1)+rz*ls(214,  1)
    lp(215,  4)=ms(281,  1)+rz*ls(215,  1)
    lp(216,  4)=ms(282,  1)+rz*ls(216,  1)
    lp(217,  4)=ms(283,  1)+rz*ls(217,  1)
    lp(218,  4)=ms(284,  1)+rz*ls(218,  1)
    lp(219,  4)=ms(285,  1)+rz*ls(219,  1)
    lp(220,  4)=ms(286,  1)+rz*ls(220,  1)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_sd( )
    sd(  1,  5)=pp(  2,  2)+rx*sp(  1,  2)
    sd(  1,  6)=pp(  2,  3)+rx*sp(  1,  3)
    sd(  1,  7)=pp(  2,  4)+rx*sp(  1,  4)
    sd(  1,  8)=pp(  3,  3)+ry*sp(  1,  3)
    sd(  1,  9)=pp(  3,  4)+ry*sp(  1,  4)
    sd(  1, 10)=pp(  4,  4)+rz*sp(  1,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_pd( )
    pd(  2,  5)=dp(  5,  2)+rx*pp(  2,  2)
    pd(  3,  5)=dp(  6,  2)+rx*pp(  3,  2)
    pd(  4,  5)=dp(  7,  2)+rx*pp(  4,  2)
    pd(  2,  6)=dp(  5,  3)+rx*pp(  2,  3)
    pd(  3,  6)=dp(  6,  3)+rx*pp(  3,  3)
    pd(  4,  6)=dp(  7,  3)+rx*pp(  4,  3)
    pd(  2,  7)=dp(  5,  4)+rx*pp(  2,  4)
    pd(  3,  7)=dp(  6,  4)+rx*pp(  3,  4)
    pd(  4,  7)=dp(  7,  4)+rx*pp(  4,  4)
    pd(  2,  8)=dp(  6,  3)+ry*pp(  2,  3)
    pd(  3,  8)=dp(  8,  3)+ry*pp(  3,  3)
    pd(  4,  8)=dp(  9,  3)+ry*pp(  4,  3)
    pd(  2,  9)=dp(  6,  4)+ry*pp(  2,  4)
    pd(  3,  9)=dp(  8,  4)+ry*pp(  3,  4)
    pd(  4,  9)=dp(  9,  4)+ry*pp(  4,  4)
    pd(  2, 10)=dp(  7,  4)+rz*pp(  2,  4)
    pd(  3, 10)=dp(  9,  4)+rz*pp(  3,  4)
    pd(  4, 10)=dp( 10,  4)+rz*pp(  4,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_dd( )
    dd(  5,  5)=fp( 11,  2)+rx*dp(  5,  2)
    dd(  6,  5)=fp( 12,  2)+rx*dp(  6,  2)
    dd(  7,  5)=fp( 13,  2)+rx*dp(  7,  2)
    dd(  8,  5)=fp( 14,  2)+rx*dp(  8,  2)
    dd(  9,  5)=fp( 15,  2)+rx*dp(  9,  2)
    dd( 10,  5)=fp( 16,  2)+rx*dp( 10,  2)
    dd(  5,  6)=fp( 11,  3)+rx*dp(  5,  3)
    dd(  6,  6)=fp( 12,  3)+rx*dp(  6,  3)
    dd(  7,  6)=fp( 13,  3)+rx*dp(  7,  3)
    dd(  8,  6)=fp( 14,  3)+rx*dp(  8,  3)
    dd(  9,  6)=fp( 15,  3)+rx*dp(  9,  3)
    dd( 10,  6)=fp( 16,  3)+rx*dp( 10,  3)
    dd(  5,  7)=fp( 11,  4)+rx*dp(  5,  4)
    dd(  6,  7)=fp( 12,  4)+rx*dp(  6,  4)
    dd(  7,  7)=fp( 13,  4)+rx*dp(  7,  4)
    dd(  8,  7)=fp( 14,  4)+rx*dp(  8,  4)
    dd(  9,  7)=fp( 15,  4)+rx*dp(  9,  4)
    dd( 10,  7)=fp( 16,  4)+rx*dp( 10,  4)
    dd(  5,  8)=fp( 12,  3)+ry*dp(  5,  3)
    dd(  6,  8)=fp( 14,  3)+ry*dp(  6,  3)
    dd(  7,  8)=fp( 15,  3)+ry*dp(  7,  3)
    dd(  8,  8)=fp( 17,  3)+ry*dp(  8,  3)
    dd(  9,  8)=fp( 18,  3)+ry*dp(  9,  3)
    dd( 10,  8)=fp( 19,  3)+ry*dp( 10,  3)
    dd(  5,  9)=fp( 12,  4)+ry*dp(  5,  4)
    dd(  6,  9)=fp( 14,  4)+ry*dp(  6,  4)
    dd(  7,  9)=fp( 15,  4)+ry*dp(  7,  4)
    dd(  8,  9)=fp( 17,  4)+ry*dp(  8,  4)
    dd(  9,  9)=fp( 18,  4)+ry*dp(  9,  4)
    dd( 10,  9)=fp( 19,  4)+ry*dp( 10,  4)
    dd(  5, 10)=fp( 13,  4)+rz*dp(  5,  4)
    dd(  6, 10)=fp( 15,  4)+rz*dp(  6,  4)
    dd(  7, 10)=fp( 16,  4)+rz*dp(  7,  4)
    dd(  8, 10)=fp( 18,  4)+rz*dp(  8,  4)
    dd(  9, 10)=fp( 19,  4)+rz*dp(  9,  4)
    dd( 10, 10)=fp( 20,  4)+rz*dp( 10,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_fd( )
    fd( 11,  5)=gp( 21,  2)+rx*fp( 11,  2)
    fd( 12,  5)=gp( 22,  2)+rx*fp( 12,  2)
    fd( 13,  5)=gp( 23,  2)+rx*fp( 13,  2)
    fd( 14,  5)=gp( 24,  2)+rx*fp( 14,  2)
    fd( 15,  5)=gp( 25,  2)+rx*fp( 15,  2)
    fd( 16,  5)=gp( 26,  2)+rx*fp( 16,  2)
    fd( 17,  5)=gp( 27,  2)+rx*fp( 17,  2)
    fd( 18,  5)=gp( 28,  2)+rx*fp( 18,  2)
    fd( 19,  5)=gp( 29,  2)+rx*fp( 19,  2)
    fd( 20,  5)=gp( 30,  2)+rx*fp( 20,  2)
    fd( 11,  6)=gp( 21,  3)+rx*fp( 11,  3)
    fd( 12,  6)=gp( 22,  3)+rx*fp( 12,  3)
    fd( 13,  6)=gp( 23,  3)+rx*fp( 13,  3)
    fd( 14,  6)=gp( 24,  3)+rx*fp( 14,  3)
    fd( 15,  6)=gp( 25,  3)+rx*fp( 15,  3)
    fd( 16,  6)=gp( 26,  3)+rx*fp( 16,  3)
    fd( 17,  6)=gp( 27,  3)+rx*fp( 17,  3)
    fd( 18,  6)=gp( 28,  3)+rx*fp( 18,  3)
    fd( 19,  6)=gp( 29,  3)+rx*fp( 19,  3)
    fd( 20,  6)=gp( 30,  3)+rx*fp( 20,  3)
    fd( 11,  7)=gp( 21,  4)+rx*fp( 11,  4)
    fd( 12,  7)=gp( 22,  4)+rx*fp( 12,  4)
    fd( 13,  7)=gp( 23,  4)+rx*fp( 13,  4)
    fd( 14,  7)=gp( 24,  4)+rx*fp( 14,  4)
    fd( 15,  7)=gp( 25,  4)+rx*fp( 15,  4)
    fd( 16,  7)=gp( 26,  4)+rx*fp( 16,  4)
    fd( 17,  7)=gp( 27,  4)+rx*fp( 17,  4)
    fd( 18,  7)=gp( 28,  4)+rx*fp( 18,  4)
    fd( 19,  7)=gp( 29,  4)+rx*fp( 19,  4)
    fd( 20,  7)=gp( 30,  4)+rx*fp( 20,  4)
    fd( 11,  8)=gp( 22,  3)+ry*fp( 11,  3)
    fd( 12,  8)=gp( 24,  3)+ry*fp( 12,  3)
    fd( 13,  8)=gp( 25,  3)+ry*fp( 13,  3)
    fd( 14,  8)=gp( 27,  3)+ry*fp( 14,  3)
    fd( 15,  8)=gp( 28,  3)+ry*fp( 15,  3)
    fd( 16,  8)=gp( 29,  3)+ry*fp( 16,  3)
    fd( 17,  8)=gp( 31,  3)+ry*fp( 17,  3)
    fd( 18,  8)=gp( 32,  3)+ry*fp( 18,  3)
    fd( 19,  8)=gp( 33,  3)+ry*fp( 19,  3)
    fd( 20,  8)=gp( 34,  3)+ry*fp( 20,  3)
    fd( 11,  9)=gp( 22,  4)+ry*fp( 11,  4)
    fd( 12,  9)=gp( 24,  4)+ry*fp( 12,  4)
    fd( 13,  9)=gp( 25,  4)+ry*fp( 13,  4)
    fd( 14,  9)=gp( 27,  4)+ry*fp( 14,  4)
    fd( 15,  9)=gp( 28,  4)+ry*fp( 15,  4)
    fd( 16,  9)=gp( 29,  4)+ry*fp( 16,  4)
    fd( 17,  9)=gp( 31,  4)+ry*fp( 17,  4)
    fd( 18,  9)=gp( 32,  4)+ry*fp( 18,  4)
    fd( 19,  9)=gp( 33,  4)+ry*fp( 19,  4)
    fd( 20,  9)=gp( 34,  4)+ry*fp( 20,  4)
    fd( 11, 10)=gp( 23,  4)+rz*fp( 11,  4)
    fd( 12, 10)=gp( 25,  4)+rz*fp( 12,  4)
    fd( 13, 10)=gp( 26,  4)+rz*fp( 13,  4)
    fd( 14, 10)=gp( 28,  4)+rz*fp( 14,  4)
    fd( 15, 10)=gp( 29,  4)+rz*fp( 15,  4)
    fd( 16, 10)=gp( 30,  4)+rz*fp( 16,  4)
    fd( 17, 10)=gp( 32,  4)+rz*fp( 17,  4)
    fd( 18, 10)=gp( 33,  4)+rz*fp( 18,  4)
    fd( 19, 10)=gp( 34,  4)+rz*fp( 19,  4)
    fd( 20, 10)=gp( 35,  4)+rz*fp( 20,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_gd( )
    gd( 21,  5)=hp( 36,  2)+rx*gp( 21,  2)
    gd( 22,  5)=hp( 37,  2)+rx*gp( 22,  2)
    gd( 23,  5)=hp( 38,  2)+rx*gp( 23,  2)
    gd( 24,  5)=hp( 39,  2)+rx*gp( 24,  2)
    gd( 25,  5)=hp( 40,  2)+rx*gp( 25,  2)
    gd( 26,  5)=hp( 41,  2)+rx*gp( 26,  2)
    gd( 27,  5)=hp( 42,  2)+rx*gp( 27,  2)
    gd( 28,  5)=hp( 43,  2)+rx*gp( 28,  2)
    gd( 29,  5)=hp( 44,  2)+rx*gp( 29,  2)
    gd( 30,  5)=hp( 45,  2)+rx*gp( 30,  2)
    gd( 31,  5)=hp( 46,  2)+rx*gp( 31,  2)
    gd( 32,  5)=hp( 47,  2)+rx*gp( 32,  2)
    gd( 33,  5)=hp( 48,  2)+rx*gp( 33,  2)
    gd( 34,  5)=hp( 49,  2)+rx*gp( 34,  2)
    gd( 35,  5)=hp( 50,  2)+rx*gp( 35,  2)
    gd( 21,  6)=hp( 36,  3)+rx*gp( 21,  3)
    gd( 22,  6)=hp( 37,  3)+rx*gp( 22,  3)
    gd( 23,  6)=hp( 38,  3)+rx*gp( 23,  3)
    gd( 24,  6)=hp( 39,  3)+rx*gp( 24,  3)
    gd( 25,  6)=hp( 40,  3)+rx*gp( 25,  3)
    gd( 26,  6)=hp( 41,  3)+rx*gp( 26,  3)
    gd( 27,  6)=hp( 42,  3)+rx*gp( 27,  3)
    gd( 28,  6)=hp( 43,  3)+rx*gp( 28,  3)
    gd( 29,  6)=hp( 44,  3)+rx*gp( 29,  3)
    gd( 30,  6)=hp( 45,  3)+rx*gp( 30,  3)
    gd( 31,  6)=hp( 46,  3)+rx*gp( 31,  3)
    gd( 32,  6)=hp( 47,  3)+rx*gp( 32,  3)
    gd( 33,  6)=hp( 48,  3)+rx*gp( 33,  3)
    gd( 34,  6)=hp( 49,  3)+rx*gp( 34,  3)
    gd( 35,  6)=hp( 50,  3)+rx*gp( 35,  3)
    gd( 21,  7)=hp( 36,  4)+rx*gp( 21,  4)
    gd( 22,  7)=hp( 37,  4)+rx*gp( 22,  4)
    gd( 23,  7)=hp( 38,  4)+rx*gp( 23,  4)
    gd( 24,  7)=hp( 39,  4)+rx*gp( 24,  4)
    gd( 25,  7)=hp( 40,  4)+rx*gp( 25,  4)
    gd( 26,  7)=hp( 41,  4)+rx*gp( 26,  4)
    gd( 27,  7)=hp( 42,  4)+rx*gp( 27,  4)
    gd( 28,  7)=hp( 43,  4)+rx*gp( 28,  4)
    gd( 29,  7)=hp( 44,  4)+rx*gp( 29,  4)
    gd( 30,  7)=hp( 45,  4)+rx*gp( 30,  4)
    gd( 31,  7)=hp( 46,  4)+rx*gp( 31,  4)
    gd( 32,  7)=hp( 47,  4)+rx*gp( 32,  4)
    gd( 33,  7)=hp( 48,  4)+rx*gp( 33,  4)
    gd( 34,  7)=hp( 49,  4)+rx*gp( 34,  4)
    gd( 35,  7)=hp( 50,  4)+rx*gp( 35,  4)
    gd( 21,  8)=hp( 37,  3)+ry*gp( 21,  3)
    gd( 22,  8)=hp( 39,  3)+ry*gp( 22,  3)
    gd( 23,  8)=hp( 40,  3)+ry*gp( 23,  3)
    gd( 24,  8)=hp( 42,  3)+ry*gp( 24,  3)
    gd( 25,  8)=hp( 43,  3)+ry*gp( 25,  3)
    gd( 26,  8)=hp( 44,  3)+ry*gp( 26,  3)
    gd( 27,  8)=hp( 46,  3)+ry*gp( 27,  3)
    gd( 28,  8)=hp( 47,  3)+ry*gp( 28,  3)
    gd( 29,  8)=hp( 48,  3)+ry*gp( 29,  3)
    gd( 30,  8)=hp( 49,  3)+ry*gp( 30,  3)
    gd( 31,  8)=hp( 51,  3)+ry*gp( 31,  3)
    gd( 32,  8)=hp( 52,  3)+ry*gp( 32,  3)
    gd( 33,  8)=hp( 53,  3)+ry*gp( 33,  3)
    gd( 34,  8)=hp( 54,  3)+ry*gp( 34,  3)
    gd( 35,  8)=hp( 55,  3)+ry*gp( 35,  3)
    gd( 21,  9)=hp( 37,  4)+ry*gp( 21,  4)
    gd( 22,  9)=hp( 39,  4)+ry*gp( 22,  4)
    gd( 23,  9)=hp( 40,  4)+ry*gp( 23,  4)
    gd( 24,  9)=hp( 42,  4)+ry*gp( 24,  4)
    gd( 25,  9)=hp( 43,  4)+ry*gp( 25,  4)
    gd( 26,  9)=hp( 44,  4)+ry*gp( 26,  4)
    gd( 27,  9)=hp( 46,  4)+ry*gp( 27,  4)
    gd( 28,  9)=hp( 47,  4)+ry*gp( 28,  4)
    gd( 29,  9)=hp( 48,  4)+ry*gp( 29,  4)
    gd( 30,  9)=hp( 49,  4)+ry*gp( 30,  4)
    gd( 31,  9)=hp( 51,  4)+ry*gp( 31,  4)
    gd( 32,  9)=hp( 52,  4)+ry*gp( 32,  4)
    gd( 33,  9)=hp( 53,  4)+ry*gp( 33,  4)
    gd( 34,  9)=hp( 54,  4)+ry*gp( 34,  4)
    gd( 35,  9)=hp( 55,  4)+ry*gp( 35,  4)
    gd( 21, 10)=hp( 38,  4)+rz*gp( 21,  4)
    gd( 22, 10)=hp( 40,  4)+rz*gp( 22,  4)
    gd( 23, 10)=hp( 41,  4)+rz*gp( 23,  4)
    gd( 24, 10)=hp( 43,  4)+rz*gp( 24,  4)
    gd( 25, 10)=hp( 44,  4)+rz*gp( 25,  4)
    gd( 26, 10)=hp( 45,  4)+rz*gp( 26,  4)
    gd( 27, 10)=hp( 47,  4)+rz*gp( 27,  4)
    gd( 28, 10)=hp( 48,  4)+rz*gp( 28,  4)
    gd( 29, 10)=hp( 49,  4)+rz*gp( 29,  4)
    gd( 30, 10)=hp( 50,  4)+rz*gp( 30,  4)
    gd( 31, 10)=hp( 52,  4)+rz*gp( 31,  4)
    gd( 32, 10)=hp( 53,  4)+rz*gp( 32,  4)
    gd( 33, 10)=hp( 54,  4)+rz*gp( 33,  4)
    gd( 34, 10)=hp( 55,  4)+rz*gp( 34,  4)
    gd( 35, 10)=hp( 56,  4)+rz*gp( 35,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_hd( )
    hd( 36,  5)=ip( 57,  2)+rx*hp( 36,  2)
    hd( 37,  5)=ip( 58,  2)+rx*hp( 37,  2)
    hd( 38,  5)=ip( 59,  2)+rx*hp( 38,  2)
    hd( 39,  5)=ip( 60,  2)+rx*hp( 39,  2)
    hd( 40,  5)=ip( 61,  2)+rx*hp( 40,  2)
    hd( 41,  5)=ip( 62,  2)+rx*hp( 41,  2)
    hd( 42,  5)=ip( 63,  2)+rx*hp( 42,  2)
    hd( 43,  5)=ip( 64,  2)+rx*hp( 43,  2)
    hd( 44,  5)=ip( 65,  2)+rx*hp( 44,  2)
    hd( 45,  5)=ip( 66,  2)+rx*hp( 45,  2)
    hd( 46,  5)=ip( 67,  2)+rx*hp( 46,  2)
    hd( 47,  5)=ip( 68,  2)+rx*hp( 47,  2)
    hd( 48,  5)=ip( 69,  2)+rx*hp( 48,  2)
    hd( 49,  5)=ip( 70,  2)+rx*hp( 49,  2)
    hd( 50,  5)=ip( 71,  2)+rx*hp( 50,  2)
    hd( 51,  5)=ip( 72,  2)+rx*hp( 51,  2)
    hd( 52,  5)=ip( 73,  2)+rx*hp( 52,  2)
    hd( 53,  5)=ip( 74,  2)+rx*hp( 53,  2)
    hd( 54,  5)=ip( 75,  2)+rx*hp( 54,  2)
    hd( 55,  5)=ip( 76,  2)+rx*hp( 55,  2)
    hd( 56,  5)=ip( 77,  2)+rx*hp( 56,  2)
    hd( 36,  6)=ip( 57,  3)+rx*hp( 36,  3)
    hd( 37,  6)=ip( 58,  3)+rx*hp( 37,  3)
    hd( 38,  6)=ip( 59,  3)+rx*hp( 38,  3)
    hd( 39,  6)=ip( 60,  3)+rx*hp( 39,  3)
    hd( 40,  6)=ip( 61,  3)+rx*hp( 40,  3)
    hd( 41,  6)=ip( 62,  3)+rx*hp( 41,  3)
    hd( 42,  6)=ip( 63,  3)+rx*hp( 42,  3)
    hd( 43,  6)=ip( 64,  3)+rx*hp( 43,  3)
    hd( 44,  6)=ip( 65,  3)+rx*hp( 44,  3)
    hd( 45,  6)=ip( 66,  3)+rx*hp( 45,  3)
    hd( 46,  6)=ip( 67,  3)+rx*hp( 46,  3)
    hd( 47,  6)=ip( 68,  3)+rx*hp( 47,  3)
    hd( 48,  6)=ip( 69,  3)+rx*hp( 48,  3)
    hd( 49,  6)=ip( 70,  3)+rx*hp( 49,  3)
    hd( 50,  6)=ip( 71,  3)+rx*hp( 50,  3)
    hd( 51,  6)=ip( 72,  3)+rx*hp( 51,  3)
    hd( 52,  6)=ip( 73,  3)+rx*hp( 52,  3)
    hd( 53,  6)=ip( 74,  3)+rx*hp( 53,  3)
    hd( 54,  6)=ip( 75,  3)+rx*hp( 54,  3)
    hd( 55,  6)=ip( 76,  3)+rx*hp( 55,  3)
    hd( 56,  6)=ip( 77,  3)+rx*hp( 56,  3)
    hd( 36,  7)=ip( 57,  4)+rx*hp( 36,  4)
    hd( 37,  7)=ip( 58,  4)+rx*hp( 37,  4)
    hd( 38,  7)=ip( 59,  4)+rx*hp( 38,  4)
    hd( 39,  7)=ip( 60,  4)+rx*hp( 39,  4)
    hd( 40,  7)=ip( 61,  4)+rx*hp( 40,  4)
    hd( 41,  7)=ip( 62,  4)+rx*hp( 41,  4)
    hd( 42,  7)=ip( 63,  4)+rx*hp( 42,  4)
    hd( 43,  7)=ip( 64,  4)+rx*hp( 43,  4)
    hd( 44,  7)=ip( 65,  4)+rx*hp( 44,  4)
    hd( 45,  7)=ip( 66,  4)+rx*hp( 45,  4)
    hd( 46,  7)=ip( 67,  4)+rx*hp( 46,  4)
    hd( 47,  7)=ip( 68,  4)+rx*hp( 47,  4)
    hd( 48,  7)=ip( 69,  4)+rx*hp( 48,  4)
    hd( 49,  7)=ip( 70,  4)+rx*hp( 49,  4)
    hd( 50,  7)=ip( 71,  4)+rx*hp( 50,  4)
    hd( 51,  7)=ip( 72,  4)+rx*hp( 51,  4)
    hd( 52,  7)=ip( 73,  4)+rx*hp( 52,  4)
    hd( 53,  7)=ip( 74,  4)+rx*hp( 53,  4)
    hd( 54,  7)=ip( 75,  4)+rx*hp( 54,  4)
    hd( 55,  7)=ip( 76,  4)+rx*hp( 55,  4)
    hd( 56,  7)=ip( 77,  4)+rx*hp( 56,  4)
    hd( 36,  8)=ip( 58,  3)+ry*hp( 36,  3)
    hd( 37,  8)=ip( 60,  3)+ry*hp( 37,  3)
    hd( 38,  8)=ip( 61,  3)+ry*hp( 38,  3)
    hd( 39,  8)=ip( 63,  3)+ry*hp( 39,  3)
    hd( 40,  8)=ip( 64,  3)+ry*hp( 40,  3)
    hd( 41,  8)=ip( 65,  3)+ry*hp( 41,  3)
    hd( 42,  8)=ip( 67,  3)+ry*hp( 42,  3)
    hd( 43,  8)=ip( 68,  3)+ry*hp( 43,  3)
    hd( 44,  8)=ip( 69,  3)+ry*hp( 44,  3)
    hd( 45,  8)=ip( 70,  3)+ry*hp( 45,  3)
    hd( 46,  8)=ip( 72,  3)+ry*hp( 46,  3)
    hd( 47,  8)=ip( 73,  3)+ry*hp( 47,  3)
    hd( 48,  8)=ip( 74,  3)+ry*hp( 48,  3)
    hd( 49,  8)=ip( 75,  3)+ry*hp( 49,  3)
    hd( 50,  8)=ip( 76,  3)+ry*hp( 50,  3)
    hd( 51,  8)=ip( 78,  3)+ry*hp( 51,  3)
    hd( 52,  8)=ip( 79,  3)+ry*hp( 52,  3)
    hd( 53,  8)=ip( 80,  3)+ry*hp( 53,  3)
    hd( 54,  8)=ip( 81,  3)+ry*hp( 54,  3)
    hd( 55,  8)=ip( 82,  3)+ry*hp( 55,  3)
    hd( 56,  8)=ip( 83,  3)+ry*hp( 56,  3)
    hd( 36,  9)=ip( 58,  4)+ry*hp( 36,  4)
    hd( 37,  9)=ip( 60,  4)+ry*hp( 37,  4)
    hd( 38,  9)=ip( 61,  4)+ry*hp( 38,  4)
    hd( 39,  9)=ip( 63,  4)+ry*hp( 39,  4)
    hd( 40,  9)=ip( 64,  4)+ry*hp( 40,  4)
    hd( 41,  9)=ip( 65,  4)+ry*hp( 41,  4)
    hd( 42,  9)=ip( 67,  4)+ry*hp( 42,  4)
    hd( 43,  9)=ip( 68,  4)+ry*hp( 43,  4)
    hd( 44,  9)=ip( 69,  4)+ry*hp( 44,  4)
    hd( 45,  9)=ip( 70,  4)+ry*hp( 45,  4)
    hd( 46,  9)=ip( 72,  4)+ry*hp( 46,  4)
    hd( 47,  9)=ip( 73,  4)+ry*hp( 47,  4)
    hd( 48,  9)=ip( 74,  4)+ry*hp( 48,  4)
    hd( 49,  9)=ip( 75,  4)+ry*hp( 49,  4)
    hd( 50,  9)=ip( 76,  4)+ry*hp( 50,  4)
    hd( 51,  9)=ip( 78,  4)+ry*hp( 51,  4)
    hd( 52,  9)=ip( 79,  4)+ry*hp( 52,  4)
    hd( 53,  9)=ip( 80,  4)+ry*hp( 53,  4)
    hd( 54,  9)=ip( 81,  4)+ry*hp( 54,  4)
    hd( 55,  9)=ip( 82,  4)+ry*hp( 55,  4)
    hd( 56,  9)=ip( 83,  4)+ry*hp( 56,  4)
    hd( 36, 10)=ip( 59,  4)+rz*hp( 36,  4)
    hd( 37, 10)=ip( 61,  4)+rz*hp( 37,  4)
    hd( 38, 10)=ip( 62,  4)+rz*hp( 38,  4)
    hd( 39, 10)=ip( 64,  4)+rz*hp( 39,  4)
    hd( 40, 10)=ip( 65,  4)+rz*hp( 40,  4)
    hd( 41, 10)=ip( 66,  4)+rz*hp( 41,  4)
    hd( 42, 10)=ip( 68,  4)+rz*hp( 42,  4)
    hd( 43, 10)=ip( 69,  4)+rz*hp( 43,  4)
    hd( 44, 10)=ip( 70,  4)+rz*hp( 44,  4)
    hd( 45, 10)=ip( 71,  4)+rz*hp( 45,  4)
    hd( 46, 10)=ip( 73,  4)+rz*hp( 46,  4)
    hd( 47, 10)=ip( 74,  4)+rz*hp( 47,  4)
    hd( 48, 10)=ip( 75,  4)+rz*hp( 48,  4)
    hd( 49, 10)=ip( 76,  4)+rz*hp( 49,  4)
    hd( 50, 10)=ip( 77,  4)+rz*hp( 50,  4)
    hd( 51, 10)=ip( 79,  4)+rz*hp( 51,  4)
    hd( 52, 10)=ip( 80,  4)+rz*hp( 52,  4)
    hd( 53, 10)=ip( 81,  4)+rz*hp( 53,  4)
    hd( 54, 10)=ip( 82,  4)+rz*hp( 54,  4)
    hd( 55, 10)=ip( 83,  4)+rz*hp( 55,  4)
    hd( 56, 10)=ip( 84,  4)+rz*hp( 56,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_id( )
    id( 57,  5)=jp( 85,  2)+rx*ip( 57,  2)
    id( 58,  5)=jp( 86,  2)+rx*ip( 58,  2)
    id( 59,  5)=jp( 87,  2)+rx*ip( 59,  2)
    id( 60,  5)=jp( 88,  2)+rx*ip( 60,  2)
    id( 61,  5)=jp( 89,  2)+rx*ip( 61,  2)
    id( 62,  5)=jp( 90,  2)+rx*ip( 62,  2)
    id( 63,  5)=jp( 91,  2)+rx*ip( 63,  2)
    id( 64,  5)=jp( 92,  2)+rx*ip( 64,  2)
    id( 65,  5)=jp( 93,  2)+rx*ip( 65,  2)
    id( 66,  5)=jp( 94,  2)+rx*ip( 66,  2)
    id( 67,  5)=jp( 95,  2)+rx*ip( 67,  2)
    id( 68,  5)=jp( 96,  2)+rx*ip( 68,  2)
    id( 69,  5)=jp( 97,  2)+rx*ip( 69,  2)
    id( 70,  5)=jp( 98,  2)+rx*ip( 70,  2)
    id( 71,  5)=jp( 99,  2)+rx*ip( 71,  2)
    id( 72,  5)=jp(100,  2)+rx*ip( 72,  2)
    id( 73,  5)=jp(101,  2)+rx*ip( 73,  2)
    id( 74,  5)=jp(102,  2)+rx*ip( 74,  2)
    id( 75,  5)=jp(103,  2)+rx*ip( 75,  2)
    id( 76,  5)=jp(104,  2)+rx*ip( 76,  2)
    id( 77,  5)=jp(105,  2)+rx*ip( 77,  2)
    id( 78,  5)=jp(106,  2)+rx*ip( 78,  2)
    id( 79,  5)=jp(107,  2)+rx*ip( 79,  2)
    id( 80,  5)=jp(108,  2)+rx*ip( 80,  2)
    id( 81,  5)=jp(109,  2)+rx*ip( 81,  2)
    id( 82,  5)=jp(110,  2)+rx*ip( 82,  2)
    id( 83,  5)=jp(111,  2)+rx*ip( 83,  2)
    id( 84,  5)=jp(112,  2)+rx*ip( 84,  2)
    id( 57,  6)=jp( 85,  3)+rx*ip( 57,  3)
    id( 58,  6)=jp( 86,  3)+rx*ip( 58,  3)
    id( 59,  6)=jp( 87,  3)+rx*ip( 59,  3)
    id( 60,  6)=jp( 88,  3)+rx*ip( 60,  3)
    id( 61,  6)=jp( 89,  3)+rx*ip( 61,  3)
    id( 62,  6)=jp( 90,  3)+rx*ip( 62,  3)
    id( 63,  6)=jp( 91,  3)+rx*ip( 63,  3)
    id( 64,  6)=jp( 92,  3)+rx*ip( 64,  3)
    id( 65,  6)=jp( 93,  3)+rx*ip( 65,  3)
    id( 66,  6)=jp( 94,  3)+rx*ip( 66,  3)
    id( 67,  6)=jp( 95,  3)+rx*ip( 67,  3)
    id( 68,  6)=jp( 96,  3)+rx*ip( 68,  3)
    id( 69,  6)=jp( 97,  3)+rx*ip( 69,  3)
    id( 70,  6)=jp( 98,  3)+rx*ip( 70,  3)
    id( 71,  6)=jp( 99,  3)+rx*ip( 71,  3)
    id( 72,  6)=jp(100,  3)+rx*ip( 72,  3)
    id( 73,  6)=jp(101,  3)+rx*ip( 73,  3)
    id( 74,  6)=jp(102,  3)+rx*ip( 74,  3)
    id( 75,  6)=jp(103,  3)+rx*ip( 75,  3)
    id( 76,  6)=jp(104,  3)+rx*ip( 76,  3)
    id( 77,  6)=jp(105,  3)+rx*ip( 77,  3)
    id( 78,  6)=jp(106,  3)+rx*ip( 78,  3)
    id( 79,  6)=jp(107,  3)+rx*ip( 79,  3)
    id( 80,  6)=jp(108,  3)+rx*ip( 80,  3)
    id( 81,  6)=jp(109,  3)+rx*ip( 81,  3)
    id( 82,  6)=jp(110,  3)+rx*ip( 82,  3)
    id( 83,  6)=jp(111,  3)+rx*ip( 83,  3)
    id( 84,  6)=jp(112,  3)+rx*ip( 84,  3)
    id( 57,  7)=jp( 85,  4)+rx*ip( 57,  4)
    id( 58,  7)=jp( 86,  4)+rx*ip( 58,  4)
    id( 59,  7)=jp( 87,  4)+rx*ip( 59,  4)
    id( 60,  7)=jp( 88,  4)+rx*ip( 60,  4)
    id( 61,  7)=jp( 89,  4)+rx*ip( 61,  4)
    id( 62,  7)=jp( 90,  4)+rx*ip( 62,  4)
    id( 63,  7)=jp( 91,  4)+rx*ip( 63,  4)
    id( 64,  7)=jp( 92,  4)+rx*ip( 64,  4)
    id( 65,  7)=jp( 93,  4)+rx*ip( 65,  4)
    id( 66,  7)=jp( 94,  4)+rx*ip( 66,  4)
    id( 67,  7)=jp( 95,  4)+rx*ip( 67,  4)
    id( 68,  7)=jp( 96,  4)+rx*ip( 68,  4)
    id( 69,  7)=jp( 97,  4)+rx*ip( 69,  4)
    id( 70,  7)=jp( 98,  4)+rx*ip( 70,  4)
    id( 71,  7)=jp( 99,  4)+rx*ip( 71,  4)
    id( 72,  7)=jp(100,  4)+rx*ip( 72,  4)
    id( 73,  7)=jp(101,  4)+rx*ip( 73,  4)
    id( 74,  7)=jp(102,  4)+rx*ip( 74,  4)
    id( 75,  7)=jp(103,  4)+rx*ip( 75,  4)
    id( 76,  7)=jp(104,  4)+rx*ip( 76,  4)
    id( 77,  7)=jp(105,  4)+rx*ip( 77,  4)
    id( 78,  7)=jp(106,  4)+rx*ip( 78,  4)
    id( 79,  7)=jp(107,  4)+rx*ip( 79,  4)
    id( 80,  7)=jp(108,  4)+rx*ip( 80,  4)
    id( 81,  7)=jp(109,  4)+rx*ip( 81,  4)
    id( 82,  7)=jp(110,  4)+rx*ip( 82,  4)
    id( 83,  7)=jp(111,  4)+rx*ip( 83,  4)
    id( 84,  7)=jp(112,  4)+rx*ip( 84,  4)
    id( 57,  8)=jp( 86,  3)+ry*ip( 57,  3)
    id( 58,  8)=jp( 88,  3)+ry*ip( 58,  3)
    id( 59,  8)=jp( 89,  3)+ry*ip( 59,  3)
    id( 60,  8)=jp( 91,  3)+ry*ip( 60,  3)
    id( 61,  8)=jp( 92,  3)+ry*ip( 61,  3)
    id( 62,  8)=jp( 93,  3)+ry*ip( 62,  3)
    id( 63,  8)=jp( 95,  3)+ry*ip( 63,  3)
    id( 64,  8)=jp( 96,  3)+ry*ip( 64,  3)
    id( 65,  8)=jp( 97,  3)+ry*ip( 65,  3)
    id( 66,  8)=jp( 98,  3)+ry*ip( 66,  3)
    id( 67,  8)=jp(100,  3)+ry*ip( 67,  3)
    id( 68,  8)=jp(101,  3)+ry*ip( 68,  3)
    id( 69,  8)=jp(102,  3)+ry*ip( 69,  3)
    id( 70,  8)=jp(103,  3)+ry*ip( 70,  3)
    id( 71,  8)=jp(104,  3)+ry*ip( 71,  3)
    id( 72,  8)=jp(106,  3)+ry*ip( 72,  3)
    id( 73,  8)=jp(107,  3)+ry*ip( 73,  3)
    id( 74,  8)=jp(108,  3)+ry*ip( 74,  3)
    id( 75,  8)=jp(109,  3)+ry*ip( 75,  3)
    id( 76,  8)=jp(110,  3)+ry*ip( 76,  3)
    id( 77,  8)=jp(111,  3)+ry*ip( 77,  3)
    id( 78,  8)=jp(113,  3)+ry*ip( 78,  3)
    id( 79,  8)=jp(114,  3)+ry*ip( 79,  3)
    id( 80,  8)=jp(115,  3)+ry*ip( 80,  3)
    id( 81,  8)=jp(116,  3)+ry*ip( 81,  3)
    id( 82,  8)=jp(117,  3)+ry*ip( 82,  3)
    id( 83,  8)=jp(118,  3)+ry*ip( 83,  3)
    id( 84,  8)=jp(119,  3)+ry*ip( 84,  3)
    id( 57,  9)=jp( 86,  4)+ry*ip( 57,  4)
    id( 58,  9)=jp( 88,  4)+ry*ip( 58,  4)
    id( 59,  9)=jp( 89,  4)+ry*ip( 59,  4)
    id( 60,  9)=jp( 91,  4)+ry*ip( 60,  4)
    id( 61,  9)=jp( 92,  4)+ry*ip( 61,  4)
    id( 62,  9)=jp( 93,  4)+ry*ip( 62,  4)
    id( 63,  9)=jp( 95,  4)+ry*ip( 63,  4)
    id( 64,  9)=jp( 96,  4)+ry*ip( 64,  4)
    id( 65,  9)=jp( 97,  4)+ry*ip( 65,  4)
    id( 66,  9)=jp( 98,  4)+ry*ip( 66,  4)
    id( 67,  9)=jp(100,  4)+ry*ip( 67,  4)
    id( 68,  9)=jp(101,  4)+ry*ip( 68,  4)
    id( 69,  9)=jp(102,  4)+ry*ip( 69,  4)
    id( 70,  9)=jp(103,  4)+ry*ip( 70,  4)
    id( 71,  9)=jp(104,  4)+ry*ip( 71,  4)
    id( 72,  9)=jp(106,  4)+ry*ip( 72,  4)
    id( 73,  9)=jp(107,  4)+ry*ip( 73,  4)
    id( 74,  9)=jp(108,  4)+ry*ip( 74,  4)
    id( 75,  9)=jp(109,  4)+ry*ip( 75,  4)
    id( 76,  9)=jp(110,  4)+ry*ip( 76,  4)
    id( 77,  9)=jp(111,  4)+ry*ip( 77,  4)
    id( 78,  9)=jp(113,  4)+ry*ip( 78,  4)
    id( 79,  9)=jp(114,  4)+ry*ip( 79,  4)
    id( 80,  9)=jp(115,  4)+ry*ip( 80,  4)
    id( 81,  9)=jp(116,  4)+ry*ip( 81,  4)
    id( 82,  9)=jp(117,  4)+ry*ip( 82,  4)
    id( 83,  9)=jp(118,  4)+ry*ip( 83,  4)
    id( 84,  9)=jp(119,  4)+ry*ip( 84,  4)
    id( 57, 10)=jp( 87,  4)+rz*ip( 57,  4)
    id( 58, 10)=jp( 89,  4)+rz*ip( 58,  4)
    id( 59, 10)=jp( 90,  4)+rz*ip( 59,  4)
    id( 60, 10)=jp( 92,  4)+rz*ip( 60,  4)
    id( 61, 10)=jp( 93,  4)+rz*ip( 61,  4)
    id( 62, 10)=jp( 94,  4)+rz*ip( 62,  4)
    id( 63, 10)=jp( 96,  4)+rz*ip( 63,  4)
    id( 64, 10)=jp( 97,  4)+rz*ip( 64,  4)
    id( 65, 10)=jp( 98,  4)+rz*ip( 65,  4)
    id( 66, 10)=jp( 99,  4)+rz*ip( 66,  4)
    id( 67, 10)=jp(101,  4)+rz*ip( 67,  4)
    id( 68, 10)=jp(102,  4)+rz*ip( 68,  4)
    id( 69, 10)=jp(103,  4)+rz*ip( 69,  4)
    id( 70, 10)=jp(104,  4)+rz*ip( 70,  4)
    id( 71, 10)=jp(105,  4)+rz*ip( 71,  4)
    id( 72, 10)=jp(107,  4)+rz*ip( 72,  4)
    id( 73, 10)=jp(108,  4)+rz*ip( 73,  4)
    id( 74, 10)=jp(109,  4)+rz*ip( 74,  4)
    id( 75, 10)=jp(110,  4)+rz*ip( 75,  4)
    id( 76, 10)=jp(111,  4)+rz*ip( 76,  4)
    id( 77, 10)=jp(112,  4)+rz*ip( 77,  4)
    id( 78, 10)=jp(114,  4)+rz*ip( 78,  4)
    id( 79, 10)=jp(115,  4)+rz*ip( 79,  4)
    id( 80, 10)=jp(116,  4)+rz*ip( 80,  4)
    id( 81, 10)=jp(117,  4)+rz*ip( 81,  4)
    id( 82, 10)=jp(118,  4)+rz*ip( 82,  4)
    id( 83, 10)=jp(119,  4)+rz*ip( 83,  4)
    id( 84, 10)=jp(120,  4)+rz*ip( 84,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_jd( )
    jd( 85,  5)=kp(121,  2)+rx*jp( 85,  2)
    jd( 86,  5)=kp(122,  2)+rx*jp( 86,  2)
    jd( 87,  5)=kp(123,  2)+rx*jp( 87,  2)
    jd( 88,  5)=kp(124,  2)+rx*jp( 88,  2)
    jd( 89,  5)=kp(125,  2)+rx*jp( 89,  2)
    jd( 90,  5)=kp(126,  2)+rx*jp( 90,  2)
    jd( 91,  5)=kp(127,  2)+rx*jp( 91,  2)
    jd( 92,  5)=kp(128,  2)+rx*jp( 92,  2)
    jd( 93,  5)=kp(129,  2)+rx*jp( 93,  2)
    jd( 94,  5)=kp(130,  2)+rx*jp( 94,  2)
    jd( 95,  5)=kp(131,  2)+rx*jp( 95,  2)
    jd( 96,  5)=kp(132,  2)+rx*jp( 96,  2)
    jd( 97,  5)=kp(133,  2)+rx*jp( 97,  2)
    jd( 98,  5)=kp(134,  2)+rx*jp( 98,  2)
    jd( 99,  5)=kp(135,  2)+rx*jp( 99,  2)
    jd(100,  5)=kp(136,  2)+rx*jp(100,  2)
    jd(101,  5)=kp(137,  2)+rx*jp(101,  2)
    jd(102,  5)=kp(138,  2)+rx*jp(102,  2)
    jd(103,  5)=kp(139,  2)+rx*jp(103,  2)
    jd(104,  5)=kp(140,  2)+rx*jp(104,  2)
    jd(105,  5)=kp(141,  2)+rx*jp(105,  2)
    jd(106,  5)=kp(142,  2)+rx*jp(106,  2)
    jd(107,  5)=kp(143,  2)+rx*jp(107,  2)
    jd(108,  5)=kp(144,  2)+rx*jp(108,  2)
    jd(109,  5)=kp(145,  2)+rx*jp(109,  2)
    jd(110,  5)=kp(146,  2)+rx*jp(110,  2)
    jd(111,  5)=kp(147,  2)+rx*jp(111,  2)
    jd(112,  5)=kp(148,  2)+rx*jp(112,  2)
    jd(113,  5)=kp(149,  2)+rx*jp(113,  2)
    jd(114,  5)=kp(150,  2)+rx*jp(114,  2)
    jd(115,  5)=kp(151,  2)+rx*jp(115,  2)
    jd(116,  5)=kp(152,  2)+rx*jp(116,  2)
    jd(117,  5)=kp(153,  2)+rx*jp(117,  2)
    jd(118,  5)=kp(154,  2)+rx*jp(118,  2)
    jd(119,  5)=kp(155,  2)+rx*jp(119,  2)
    jd(120,  5)=kp(156,  2)+rx*jp(120,  2)
    jd( 85,  6)=kp(121,  3)+rx*jp( 85,  3)
    jd( 86,  6)=kp(122,  3)+rx*jp( 86,  3)
    jd( 87,  6)=kp(123,  3)+rx*jp( 87,  3)
    jd( 88,  6)=kp(124,  3)+rx*jp( 88,  3)
    jd( 89,  6)=kp(125,  3)+rx*jp( 89,  3)
    jd( 90,  6)=kp(126,  3)+rx*jp( 90,  3)
    jd( 91,  6)=kp(127,  3)+rx*jp( 91,  3)
    jd( 92,  6)=kp(128,  3)+rx*jp( 92,  3)
    jd( 93,  6)=kp(129,  3)+rx*jp( 93,  3)
    jd( 94,  6)=kp(130,  3)+rx*jp( 94,  3)
    jd( 95,  6)=kp(131,  3)+rx*jp( 95,  3)
    jd( 96,  6)=kp(132,  3)+rx*jp( 96,  3)
    jd( 97,  6)=kp(133,  3)+rx*jp( 97,  3)
    jd( 98,  6)=kp(134,  3)+rx*jp( 98,  3)
    jd( 99,  6)=kp(135,  3)+rx*jp( 99,  3)
    jd(100,  6)=kp(136,  3)+rx*jp(100,  3)
    jd(101,  6)=kp(137,  3)+rx*jp(101,  3)
    jd(102,  6)=kp(138,  3)+rx*jp(102,  3)
    jd(103,  6)=kp(139,  3)+rx*jp(103,  3)
    jd(104,  6)=kp(140,  3)+rx*jp(104,  3)
    jd(105,  6)=kp(141,  3)+rx*jp(105,  3)
    jd(106,  6)=kp(142,  3)+rx*jp(106,  3)
    jd(107,  6)=kp(143,  3)+rx*jp(107,  3)
    jd(108,  6)=kp(144,  3)+rx*jp(108,  3)
    jd(109,  6)=kp(145,  3)+rx*jp(109,  3)
    jd(110,  6)=kp(146,  3)+rx*jp(110,  3)
    jd(111,  6)=kp(147,  3)+rx*jp(111,  3)
    jd(112,  6)=kp(148,  3)+rx*jp(112,  3)
    jd(113,  6)=kp(149,  3)+rx*jp(113,  3)
    jd(114,  6)=kp(150,  3)+rx*jp(114,  3)
    jd(115,  6)=kp(151,  3)+rx*jp(115,  3)
    jd(116,  6)=kp(152,  3)+rx*jp(116,  3)
    jd(117,  6)=kp(153,  3)+rx*jp(117,  3)
    jd(118,  6)=kp(154,  3)+rx*jp(118,  3)
    jd(119,  6)=kp(155,  3)+rx*jp(119,  3)
    jd(120,  6)=kp(156,  3)+rx*jp(120,  3)
    jd( 85,  7)=kp(121,  4)+rx*jp( 85,  4)
    jd( 86,  7)=kp(122,  4)+rx*jp( 86,  4)
    jd( 87,  7)=kp(123,  4)+rx*jp( 87,  4)
    jd( 88,  7)=kp(124,  4)+rx*jp( 88,  4)
    jd( 89,  7)=kp(125,  4)+rx*jp( 89,  4)
    jd( 90,  7)=kp(126,  4)+rx*jp( 90,  4)
    jd( 91,  7)=kp(127,  4)+rx*jp( 91,  4)
    jd( 92,  7)=kp(128,  4)+rx*jp( 92,  4)
    jd( 93,  7)=kp(129,  4)+rx*jp( 93,  4)
    jd( 94,  7)=kp(130,  4)+rx*jp( 94,  4)
    jd( 95,  7)=kp(131,  4)+rx*jp( 95,  4)
    jd( 96,  7)=kp(132,  4)+rx*jp( 96,  4)
    jd( 97,  7)=kp(133,  4)+rx*jp( 97,  4)
    jd( 98,  7)=kp(134,  4)+rx*jp( 98,  4)
    jd( 99,  7)=kp(135,  4)+rx*jp( 99,  4)
    jd(100,  7)=kp(136,  4)+rx*jp(100,  4)
    jd(101,  7)=kp(137,  4)+rx*jp(101,  4)
    jd(102,  7)=kp(138,  4)+rx*jp(102,  4)
    jd(103,  7)=kp(139,  4)+rx*jp(103,  4)
    jd(104,  7)=kp(140,  4)+rx*jp(104,  4)
    jd(105,  7)=kp(141,  4)+rx*jp(105,  4)
    jd(106,  7)=kp(142,  4)+rx*jp(106,  4)
    jd(107,  7)=kp(143,  4)+rx*jp(107,  4)
    jd(108,  7)=kp(144,  4)+rx*jp(108,  4)
    jd(109,  7)=kp(145,  4)+rx*jp(109,  4)
    jd(110,  7)=kp(146,  4)+rx*jp(110,  4)
    jd(111,  7)=kp(147,  4)+rx*jp(111,  4)
    jd(112,  7)=kp(148,  4)+rx*jp(112,  4)
    jd(113,  7)=kp(149,  4)+rx*jp(113,  4)
    jd(114,  7)=kp(150,  4)+rx*jp(114,  4)
    jd(115,  7)=kp(151,  4)+rx*jp(115,  4)
    jd(116,  7)=kp(152,  4)+rx*jp(116,  4)
    jd(117,  7)=kp(153,  4)+rx*jp(117,  4)
    jd(118,  7)=kp(154,  4)+rx*jp(118,  4)
    jd(119,  7)=kp(155,  4)+rx*jp(119,  4)
    jd(120,  7)=kp(156,  4)+rx*jp(120,  4)
    jd( 85,  8)=kp(122,  3)+ry*jp( 85,  3)
    jd( 86,  8)=kp(124,  3)+ry*jp( 86,  3)
    jd( 87,  8)=kp(125,  3)+ry*jp( 87,  3)
    jd( 88,  8)=kp(127,  3)+ry*jp( 88,  3)
    jd( 89,  8)=kp(128,  3)+ry*jp( 89,  3)
    jd( 90,  8)=kp(129,  3)+ry*jp( 90,  3)
    jd( 91,  8)=kp(131,  3)+ry*jp( 91,  3)
    jd( 92,  8)=kp(132,  3)+ry*jp( 92,  3)
    jd( 93,  8)=kp(133,  3)+ry*jp( 93,  3)
    jd( 94,  8)=kp(134,  3)+ry*jp( 94,  3)
    jd( 95,  8)=kp(136,  3)+ry*jp( 95,  3)
    jd( 96,  8)=kp(137,  3)+ry*jp( 96,  3)
    jd( 97,  8)=kp(138,  3)+ry*jp( 97,  3)
    jd( 98,  8)=kp(139,  3)+ry*jp( 98,  3)
    jd( 99,  8)=kp(140,  3)+ry*jp( 99,  3)
    jd(100,  8)=kp(142,  3)+ry*jp(100,  3)
    jd(101,  8)=kp(143,  3)+ry*jp(101,  3)
    jd(102,  8)=kp(144,  3)+ry*jp(102,  3)
    jd(103,  8)=kp(145,  3)+ry*jp(103,  3)
    jd(104,  8)=kp(146,  3)+ry*jp(104,  3)
    jd(105,  8)=kp(147,  3)+ry*jp(105,  3)
    jd(106,  8)=kp(149,  3)+ry*jp(106,  3)
    jd(107,  8)=kp(150,  3)+ry*jp(107,  3)
    jd(108,  8)=kp(151,  3)+ry*jp(108,  3)
    jd(109,  8)=kp(152,  3)+ry*jp(109,  3)
    jd(110,  8)=kp(153,  3)+ry*jp(110,  3)
    jd(111,  8)=kp(154,  3)+ry*jp(111,  3)
    jd(112,  8)=kp(155,  3)+ry*jp(112,  3)
    jd(113,  8)=kp(157,  3)+ry*jp(113,  3)
    jd(114,  8)=kp(158,  3)+ry*jp(114,  3)
    jd(115,  8)=kp(159,  3)+ry*jp(115,  3)
    jd(116,  8)=kp(160,  3)+ry*jp(116,  3)
    jd(117,  8)=kp(161,  3)+ry*jp(117,  3)
    jd(118,  8)=kp(162,  3)+ry*jp(118,  3)
    jd(119,  8)=kp(163,  3)+ry*jp(119,  3)
    jd(120,  8)=kp(164,  3)+ry*jp(120,  3)
    jd( 85,  9)=kp(122,  4)+ry*jp( 85,  4)
    jd( 86,  9)=kp(124,  4)+ry*jp( 86,  4)
    jd( 87,  9)=kp(125,  4)+ry*jp( 87,  4)
    jd( 88,  9)=kp(127,  4)+ry*jp( 88,  4)
    jd( 89,  9)=kp(128,  4)+ry*jp( 89,  4)
    jd( 90,  9)=kp(129,  4)+ry*jp( 90,  4)
    jd( 91,  9)=kp(131,  4)+ry*jp( 91,  4)
    jd( 92,  9)=kp(132,  4)+ry*jp( 92,  4)
    jd( 93,  9)=kp(133,  4)+ry*jp( 93,  4)
    jd( 94,  9)=kp(134,  4)+ry*jp( 94,  4)
    jd( 95,  9)=kp(136,  4)+ry*jp( 95,  4)
    jd( 96,  9)=kp(137,  4)+ry*jp( 96,  4)
    jd( 97,  9)=kp(138,  4)+ry*jp( 97,  4)
    jd( 98,  9)=kp(139,  4)+ry*jp( 98,  4)
    jd( 99,  9)=kp(140,  4)+ry*jp( 99,  4)
    jd(100,  9)=kp(142,  4)+ry*jp(100,  4)
    jd(101,  9)=kp(143,  4)+ry*jp(101,  4)
    jd(102,  9)=kp(144,  4)+ry*jp(102,  4)
    jd(103,  9)=kp(145,  4)+ry*jp(103,  4)
    jd(104,  9)=kp(146,  4)+ry*jp(104,  4)
    jd(105,  9)=kp(147,  4)+ry*jp(105,  4)
    jd(106,  9)=kp(149,  4)+ry*jp(106,  4)
    jd(107,  9)=kp(150,  4)+ry*jp(107,  4)
    jd(108,  9)=kp(151,  4)+ry*jp(108,  4)
    jd(109,  9)=kp(152,  4)+ry*jp(109,  4)
    jd(110,  9)=kp(153,  4)+ry*jp(110,  4)
    jd(111,  9)=kp(154,  4)+ry*jp(111,  4)
    jd(112,  9)=kp(155,  4)+ry*jp(112,  4)
    jd(113,  9)=kp(157,  4)+ry*jp(113,  4)
    jd(114,  9)=kp(158,  4)+ry*jp(114,  4)
    jd(115,  9)=kp(159,  4)+ry*jp(115,  4)
    jd(116,  9)=kp(160,  4)+ry*jp(116,  4)
    jd(117,  9)=kp(161,  4)+ry*jp(117,  4)
    jd(118,  9)=kp(162,  4)+ry*jp(118,  4)
    jd(119,  9)=kp(163,  4)+ry*jp(119,  4)
    jd(120,  9)=kp(164,  4)+ry*jp(120,  4)
    jd( 85, 10)=kp(123,  4)+rz*jp( 85,  4)
    jd( 86, 10)=kp(125,  4)+rz*jp( 86,  4)
    jd( 87, 10)=kp(126,  4)+rz*jp( 87,  4)
    jd( 88, 10)=kp(128,  4)+rz*jp( 88,  4)
    jd( 89, 10)=kp(129,  4)+rz*jp( 89,  4)
    jd( 90, 10)=kp(130,  4)+rz*jp( 90,  4)
    jd( 91, 10)=kp(132,  4)+rz*jp( 91,  4)
    jd( 92, 10)=kp(133,  4)+rz*jp( 92,  4)
    jd( 93, 10)=kp(134,  4)+rz*jp( 93,  4)
    jd( 94, 10)=kp(135,  4)+rz*jp( 94,  4)
    jd( 95, 10)=kp(137,  4)+rz*jp( 95,  4)
    jd( 96, 10)=kp(138,  4)+rz*jp( 96,  4)
    jd( 97, 10)=kp(139,  4)+rz*jp( 97,  4)
    jd( 98, 10)=kp(140,  4)+rz*jp( 98,  4)
    jd( 99, 10)=kp(141,  4)+rz*jp( 99,  4)
    jd(100, 10)=kp(143,  4)+rz*jp(100,  4)
    jd(101, 10)=kp(144,  4)+rz*jp(101,  4)
    jd(102, 10)=kp(145,  4)+rz*jp(102,  4)
    jd(103, 10)=kp(146,  4)+rz*jp(103,  4)
    jd(104, 10)=kp(147,  4)+rz*jp(104,  4)
    jd(105, 10)=kp(148,  4)+rz*jp(105,  4)
    jd(106, 10)=kp(150,  4)+rz*jp(106,  4)
    jd(107, 10)=kp(151,  4)+rz*jp(107,  4)
    jd(108, 10)=kp(152,  4)+rz*jp(108,  4)
    jd(109, 10)=kp(153,  4)+rz*jp(109,  4)
    jd(110, 10)=kp(154,  4)+rz*jp(110,  4)
    jd(111, 10)=kp(155,  4)+rz*jp(111,  4)
    jd(112, 10)=kp(156,  4)+rz*jp(112,  4)
    jd(113, 10)=kp(158,  4)+rz*jp(113,  4)
    jd(114, 10)=kp(159,  4)+rz*jp(114,  4)
    jd(115, 10)=kp(160,  4)+rz*jp(115,  4)
    jd(116, 10)=kp(161,  4)+rz*jp(116,  4)
    jd(117, 10)=kp(162,  4)+rz*jp(117,  4)
    jd(118, 10)=kp(163,  4)+rz*jp(118,  4)
    jd(119, 10)=kp(164,  4)+rz*jp(119,  4)
    jd(120, 10)=kp(165,  4)+rz*jp(120,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_kd( )
    kd(121,  5)=lp(166,  2)+rx*kp(121,  2)
    kd(122,  5)=lp(167,  2)+rx*kp(122,  2)
    kd(123,  5)=lp(168,  2)+rx*kp(123,  2)
    kd(124,  5)=lp(169,  2)+rx*kp(124,  2)
    kd(125,  5)=lp(170,  2)+rx*kp(125,  2)
    kd(126,  5)=lp(171,  2)+rx*kp(126,  2)
    kd(127,  5)=lp(172,  2)+rx*kp(127,  2)
    kd(128,  5)=lp(173,  2)+rx*kp(128,  2)
    kd(129,  5)=lp(174,  2)+rx*kp(129,  2)
    kd(130,  5)=lp(175,  2)+rx*kp(130,  2)
    kd(131,  5)=lp(176,  2)+rx*kp(131,  2)
    kd(132,  5)=lp(177,  2)+rx*kp(132,  2)
    kd(133,  5)=lp(178,  2)+rx*kp(133,  2)
    kd(134,  5)=lp(179,  2)+rx*kp(134,  2)
    kd(135,  5)=lp(180,  2)+rx*kp(135,  2)
    kd(136,  5)=lp(181,  2)+rx*kp(136,  2)
    kd(137,  5)=lp(182,  2)+rx*kp(137,  2)
    kd(138,  5)=lp(183,  2)+rx*kp(138,  2)
    kd(139,  5)=lp(184,  2)+rx*kp(139,  2)
    kd(140,  5)=lp(185,  2)+rx*kp(140,  2)
    kd(141,  5)=lp(186,  2)+rx*kp(141,  2)
    kd(142,  5)=lp(187,  2)+rx*kp(142,  2)
    kd(143,  5)=lp(188,  2)+rx*kp(143,  2)
    kd(144,  5)=lp(189,  2)+rx*kp(144,  2)
    kd(145,  5)=lp(190,  2)+rx*kp(145,  2)
    kd(146,  5)=lp(191,  2)+rx*kp(146,  2)
    kd(147,  5)=lp(192,  2)+rx*kp(147,  2)
    kd(148,  5)=lp(193,  2)+rx*kp(148,  2)
    kd(149,  5)=lp(194,  2)+rx*kp(149,  2)
    kd(150,  5)=lp(195,  2)+rx*kp(150,  2)
    kd(151,  5)=lp(196,  2)+rx*kp(151,  2)
    kd(152,  5)=lp(197,  2)+rx*kp(152,  2)
    kd(153,  5)=lp(198,  2)+rx*kp(153,  2)
    kd(154,  5)=lp(199,  2)+rx*kp(154,  2)
    kd(155,  5)=lp(200,  2)+rx*kp(155,  2)
    kd(156,  5)=lp(201,  2)+rx*kp(156,  2)
    kd(157,  5)=lp(202,  2)+rx*kp(157,  2)
    kd(158,  5)=lp(203,  2)+rx*kp(158,  2)
    kd(159,  5)=lp(204,  2)+rx*kp(159,  2)
    kd(160,  5)=lp(205,  2)+rx*kp(160,  2)
    kd(161,  5)=lp(206,  2)+rx*kp(161,  2)
    kd(162,  5)=lp(207,  2)+rx*kp(162,  2)
    kd(163,  5)=lp(208,  2)+rx*kp(163,  2)
    kd(164,  5)=lp(209,  2)+rx*kp(164,  2)
    kd(165,  5)=lp(210,  2)+rx*kp(165,  2)
    kd(121,  6)=lp(166,  3)+rx*kp(121,  3)
    kd(122,  6)=lp(167,  3)+rx*kp(122,  3)
    kd(123,  6)=lp(168,  3)+rx*kp(123,  3)
    kd(124,  6)=lp(169,  3)+rx*kp(124,  3)
    kd(125,  6)=lp(170,  3)+rx*kp(125,  3)
    kd(126,  6)=lp(171,  3)+rx*kp(126,  3)
    kd(127,  6)=lp(172,  3)+rx*kp(127,  3)
    kd(128,  6)=lp(173,  3)+rx*kp(128,  3)
    kd(129,  6)=lp(174,  3)+rx*kp(129,  3)
    kd(130,  6)=lp(175,  3)+rx*kp(130,  3)
    kd(131,  6)=lp(176,  3)+rx*kp(131,  3)
    kd(132,  6)=lp(177,  3)+rx*kp(132,  3)
    kd(133,  6)=lp(178,  3)+rx*kp(133,  3)
    kd(134,  6)=lp(179,  3)+rx*kp(134,  3)
    kd(135,  6)=lp(180,  3)+rx*kp(135,  3)
    kd(136,  6)=lp(181,  3)+rx*kp(136,  3)
    kd(137,  6)=lp(182,  3)+rx*kp(137,  3)
    kd(138,  6)=lp(183,  3)+rx*kp(138,  3)
    kd(139,  6)=lp(184,  3)+rx*kp(139,  3)
    kd(140,  6)=lp(185,  3)+rx*kp(140,  3)
    kd(141,  6)=lp(186,  3)+rx*kp(141,  3)
    kd(142,  6)=lp(187,  3)+rx*kp(142,  3)
    kd(143,  6)=lp(188,  3)+rx*kp(143,  3)
    kd(144,  6)=lp(189,  3)+rx*kp(144,  3)
    kd(145,  6)=lp(190,  3)+rx*kp(145,  3)
    kd(146,  6)=lp(191,  3)+rx*kp(146,  3)
    kd(147,  6)=lp(192,  3)+rx*kp(147,  3)
    kd(148,  6)=lp(193,  3)+rx*kp(148,  3)
    kd(149,  6)=lp(194,  3)+rx*kp(149,  3)
    kd(150,  6)=lp(195,  3)+rx*kp(150,  3)
    kd(151,  6)=lp(196,  3)+rx*kp(151,  3)
    kd(152,  6)=lp(197,  3)+rx*kp(152,  3)
    kd(153,  6)=lp(198,  3)+rx*kp(153,  3)
    kd(154,  6)=lp(199,  3)+rx*kp(154,  3)
    kd(155,  6)=lp(200,  3)+rx*kp(155,  3)
    kd(156,  6)=lp(201,  3)+rx*kp(156,  3)
    kd(157,  6)=lp(202,  3)+rx*kp(157,  3)
    kd(158,  6)=lp(203,  3)+rx*kp(158,  3)
    kd(159,  6)=lp(204,  3)+rx*kp(159,  3)
    kd(160,  6)=lp(205,  3)+rx*kp(160,  3)
    kd(161,  6)=lp(206,  3)+rx*kp(161,  3)
    kd(162,  6)=lp(207,  3)+rx*kp(162,  3)
    kd(163,  6)=lp(208,  3)+rx*kp(163,  3)
    kd(164,  6)=lp(209,  3)+rx*kp(164,  3)
    kd(165,  6)=lp(210,  3)+rx*kp(165,  3)
    kd(121,  7)=lp(166,  4)+rx*kp(121,  4)
    kd(122,  7)=lp(167,  4)+rx*kp(122,  4)
    kd(123,  7)=lp(168,  4)+rx*kp(123,  4)
    kd(124,  7)=lp(169,  4)+rx*kp(124,  4)
    kd(125,  7)=lp(170,  4)+rx*kp(125,  4)
    kd(126,  7)=lp(171,  4)+rx*kp(126,  4)
    kd(127,  7)=lp(172,  4)+rx*kp(127,  4)
    kd(128,  7)=lp(173,  4)+rx*kp(128,  4)
    kd(129,  7)=lp(174,  4)+rx*kp(129,  4)
    kd(130,  7)=lp(175,  4)+rx*kp(130,  4)
    kd(131,  7)=lp(176,  4)+rx*kp(131,  4)
    kd(132,  7)=lp(177,  4)+rx*kp(132,  4)
    kd(133,  7)=lp(178,  4)+rx*kp(133,  4)
    kd(134,  7)=lp(179,  4)+rx*kp(134,  4)
    kd(135,  7)=lp(180,  4)+rx*kp(135,  4)
    kd(136,  7)=lp(181,  4)+rx*kp(136,  4)
    kd(137,  7)=lp(182,  4)+rx*kp(137,  4)
    kd(138,  7)=lp(183,  4)+rx*kp(138,  4)
    kd(139,  7)=lp(184,  4)+rx*kp(139,  4)
    kd(140,  7)=lp(185,  4)+rx*kp(140,  4)
    kd(141,  7)=lp(186,  4)+rx*kp(141,  4)
    kd(142,  7)=lp(187,  4)+rx*kp(142,  4)
    kd(143,  7)=lp(188,  4)+rx*kp(143,  4)
    kd(144,  7)=lp(189,  4)+rx*kp(144,  4)
    kd(145,  7)=lp(190,  4)+rx*kp(145,  4)
    kd(146,  7)=lp(191,  4)+rx*kp(146,  4)
    kd(147,  7)=lp(192,  4)+rx*kp(147,  4)
    kd(148,  7)=lp(193,  4)+rx*kp(148,  4)
    kd(149,  7)=lp(194,  4)+rx*kp(149,  4)
    kd(150,  7)=lp(195,  4)+rx*kp(150,  4)
    kd(151,  7)=lp(196,  4)+rx*kp(151,  4)
    kd(152,  7)=lp(197,  4)+rx*kp(152,  4)
    kd(153,  7)=lp(198,  4)+rx*kp(153,  4)
    kd(154,  7)=lp(199,  4)+rx*kp(154,  4)
    kd(155,  7)=lp(200,  4)+rx*kp(155,  4)
    kd(156,  7)=lp(201,  4)+rx*kp(156,  4)
    kd(157,  7)=lp(202,  4)+rx*kp(157,  4)
    kd(158,  7)=lp(203,  4)+rx*kp(158,  4)
    kd(159,  7)=lp(204,  4)+rx*kp(159,  4)
    kd(160,  7)=lp(205,  4)+rx*kp(160,  4)
    kd(161,  7)=lp(206,  4)+rx*kp(161,  4)
    kd(162,  7)=lp(207,  4)+rx*kp(162,  4)
    kd(163,  7)=lp(208,  4)+rx*kp(163,  4)
    kd(164,  7)=lp(209,  4)+rx*kp(164,  4)
    kd(165,  7)=lp(210,  4)+rx*kp(165,  4)
    kd(121,  8)=lp(167,  3)+ry*kp(121,  3)
    kd(122,  8)=lp(169,  3)+ry*kp(122,  3)
    kd(123,  8)=lp(170,  3)+ry*kp(123,  3)
    kd(124,  8)=lp(172,  3)+ry*kp(124,  3)
    kd(125,  8)=lp(173,  3)+ry*kp(125,  3)
    kd(126,  8)=lp(174,  3)+ry*kp(126,  3)
    kd(127,  8)=lp(176,  3)+ry*kp(127,  3)
    kd(128,  8)=lp(177,  3)+ry*kp(128,  3)
    kd(129,  8)=lp(178,  3)+ry*kp(129,  3)
    kd(130,  8)=lp(179,  3)+ry*kp(130,  3)
    kd(131,  8)=lp(181,  3)+ry*kp(131,  3)
    kd(132,  8)=lp(182,  3)+ry*kp(132,  3)
    kd(133,  8)=lp(183,  3)+ry*kp(133,  3)
    kd(134,  8)=lp(184,  3)+ry*kp(134,  3)
    kd(135,  8)=lp(185,  3)+ry*kp(135,  3)
    kd(136,  8)=lp(187,  3)+ry*kp(136,  3)
    kd(137,  8)=lp(188,  3)+ry*kp(137,  3)
    kd(138,  8)=lp(189,  3)+ry*kp(138,  3)
    kd(139,  8)=lp(190,  3)+ry*kp(139,  3)
    kd(140,  8)=lp(191,  3)+ry*kp(140,  3)
    kd(141,  8)=lp(192,  3)+ry*kp(141,  3)
    kd(142,  8)=lp(194,  3)+ry*kp(142,  3)
    kd(143,  8)=lp(195,  3)+ry*kp(143,  3)
    kd(144,  8)=lp(196,  3)+ry*kp(144,  3)
    kd(145,  8)=lp(197,  3)+ry*kp(145,  3)
    kd(146,  8)=lp(198,  3)+ry*kp(146,  3)
    kd(147,  8)=lp(199,  3)+ry*kp(147,  3)
    kd(148,  8)=lp(200,  3)+ry*kp(148,  3)
    kd(149,  8)=lp(202,  3)+ry*kp(149,  3)
    kd(150,  8)=lp(203,  3)+ry*kp(150,  3)
    kd(151,  8)=lp(204,  3)+ry*kp(151,  3)
    kd(152,  8)=lp(205,  3)+ry*kp(152,  3)
    kd(153,  8)=lp(206,  3)+ry*kp(153,  3)
    kd(154,  8)=lp(207,  3)+ry*kp(154,  3)
    kd(155,  8)=lp(208,  3)+ry*kp(155,  3)
    kd(156,  8)=lp(209,  3)+ry*kp(156,  3)
    kd(157,  8)=lp(211,  3)+ry*kp(157,  3)
    kd(158,  8)=lp(212,  3)+ry*kp(158,  3)
    kd(159,  8)=lp(213,  3)+ry*kp(159,  3)
    kd(160,  8)=lp(214,  3)+ry*kp(160,  3)
    kd(161,  8)=lp(215,  3)+ry*kp(161,  3)
    kd(162,  8)=lp(216,  3)+ry*kp(162,  3)
    kd(163,  8)=lp(217,  3)+ry*kp(163,  3)
    kd(164,  8)=lp(218,  3)+ry*kp(164,  3)
    kd(165,  8)=lp(219,  3)+ry*kp(165,  3)
    kd(121,  9)=lp(167,  4)+ry*kp(121,  4)
    kd(122,  9)=lp(169,  4)+ry*kp(122,  4)
    kd(123,  9)=lp(170,  4)+ry*kp(123,  4)
    kd(124,  9)=lp(172,  4)+ry*kp(124,  4)
    kd(125,  9)=lp(173,  4)+ry*kp(125,  4)
    kd(126,  9)=lp(174,  4)+ry*kp(126,  4)
    kd(127,  9)=lp(176,  4)+ry*kp(127,  4)
    kd(128,  9)=lp(177,  4)+ry*kp(128,  4)
    kd(129,  9)=lp(178,  4)+ry*kp(129,  4)
    kd(130,  9)=lp(179,  4)+ry*kp(130,  4)
    kd(131,  9)=lp(181,  4)+ry*kp(131,  4)
    kd(132,  9)=lp(182,  4)+ry*kp(132,  4)
    kd(133,  9)=lp(183,  4)+ry*kp(133,  4)
    kd(134,  9)=lp(184,  4)+ry*kp(134,  4)
    kd(135,  9)=lp(185,  4)+ry*kp(135,  4)
    kd(136,  9)=lp(187,  4)+ry*kp(136,  4)
    kd(137,  9)=lp(188,  4)+ry*kp(137,  4)
    kd(138,  9)=lp(189,  4)+ry*kp(138,  4)
    kd(139,  9)=lp(190,  4)+ry*kp(139,  4)
    kd(140,  9)=lp(191,  4)+ry*kp(140,  4)
    kd(141,  9)=lp(192,  4)+ry*kp(141,  4)
    kd(142,  9)=lp(194,  4)+ry*kp(142,  4)
    kd(143,  9)=lp(195,  4)+ry*kp(143,  4)
    kd(144,  9)=lp(196,  4)+ry*kp(144,  4)
    kd(145,  9)=lp(197,  4)+ry*kp(145,  4)
    kd(146,  9)=lp(198,  4)+ry*kp(146,  4)
    kd(147,  9)=lp(199,  4)+ry*kp(147,  4)
    kd(148,  9)=lp(200,  4)+ry*kp(148,  4)
    kd(149,  9)=lp(202,  4)+ry*kp(149,  4)
    kd(150,  9)=lp(203,  4)+ry*kp(150,  4)
    kd(151,  9)=lp(204,  4)+ry*kp(151,  4)
    kd(152,  9)=lp(205,  4)+ry*kp(152,  4)
    kd(153,  9)=lp(206,  4)+ry*kp(153,  4)
    kd(154,  9)=lp(207,  4)+ry*kp(154,  4)
    kd(155,  9)=lp(208,  4)+ry*kp(155,  4)
    kd(156,  9)=lp(209,  4)+ry*kp(156,  4)
    kd(157,  9)=lp(211,  4)+ry*kp(157,  4)
    kd(158,  9)=lp(212,  4)+ry*kp(158,  4)
    kd(159,  9)=lp(213,  4)+ry*kp(159,  4)
    kd(160,  9)=lp(214,  4)+ry*kp(160,  4)
    kd(161,  9)=lp(215,  4)+ry*kp(161,  4)
    kd(162,  9)=lp(216,  4)+ry*kp(162,  4)
    kd(163,  9)=lp(217,  4)+ry*kp(163,  4)
    kd(164,  9)=lp(218,  4)+ry*kp(164,  4)
    kd(165,  9)=lp(219,  4)+ry*kp(165,  4)
    kd(121, 10)=lp(168,  4)+rz*kp(121,  4)
    kd(122, 10)=lp(170,  4)+rz*kp(122,  4)
    kd(123, 10)=lp(171,  4)+rz*kp(123,  4)
    kd(124, 10)=lp(173,  4)+rz*kp(124,  4)
    kd(125, 10)=lp(174,  4)+rz*kp(125,  4)
    kd(126, 10)=lp(175,  4)+rz*kp(126,  4)
    kd(127, 10)=lp(177,  4)+rz*kp(127,  4)
    kd(128, 10)=lp(178,  4)+rz*kp(128,  4)
    kd(129, 10)=lp(179,  4)+rz*kp(129,  4)
    kd(130, 10)=lp(180,  4)+rz*kp(130,  4)
    kd(131, 10)=lp(182,  4)+rz*kp(131,  4)
    kd(132, 10)=lp(183,  4)+rz*kp(132,  4)
    kd(133, 10)=lp(184,  4)+rz*kp(133,  4)
    kd(134, 10)=lp(185,  4)+rz*kp(134,  4)
    kd(135, 10)=lp(186,  4)+rz*kp(135,  4)
    kd(136, 10)=lp(188,  4)+rz*kp(136,  4)
    kd(137, 10)=lp(189,  4)+rz*kp(137,  4)
    kd(138, 10)=lp(190,  4)+rz*kp(138,  4)
    kd(139, 10)=lp(191,  4)+rz*kp(139,  4)
    kd(140, 10)=lp(192,  4)+rz*kp(140,  4)
    kd(141, 10)=lp(193,  4)+rz*kp(141,  4)
    kd(142, 10)=lp(195,  4)+rz*kp(142,  4)
    kd(143, 10)=lp(196,  4)+rz*kp(143,  4)
    kd(144, 10)=lp(197,  4)+rz*kp(144,  4)
    kd(145, 10)=lp(198,  4)+rz*kp(145,  4)
    kd(146, 10)=lp(199,  4)+rz*kp(146,  4)
    kd(147, 10)=lp(200,  4)+rz*kp(147,  4)
    kd(148, 10)=lp(201,  4)+rz*kp(148,  4)
    kd(149, 10)=lp(203,  4)+rz*kp(149,  4)
    kd(150, 10)=lp(204,  4)+rz*kp(150,  4)
    kd(151, 10)=lp(205,  4)+rz*kp(151,  4)
    kd(152, 10)=lp(206,  4)+rz*kp(152,  4)
    kd(153, 10)=lp(207,  4)+rz*kp(153,  4)
    kd(154, 10)=lp(208,  4)+rz*kp(154,  4)
    kd(155, 10)=lp(209,  4)+rz*kp(155,  4)
    kd(156, 10)=lp(210,  4)+rz*kp(156,  4)
    kd(157, 10)=lp(212,  4)+rz*kp(157,  4)
    kd(158, 10)=lp(213,  4)+rz*kp(158,  4)
    kd(159, 10)=lp(214,  4)+rz*kp(159,  4)
    kd(160, 10)=lp(215,  4)+rz*kp(160,  4)
    kd(161, 10)=lp(216,  4)+rz*kp(161,  4)
    kd(162, 10)=lp(217,  4)+rz*kp(162,  4)
    kd(163, 10)=lp(218,  4)+rz*kp(163,  4)
    kd(164, 10)=lp(219,  4)+rz*kp(164,  4)
    kd(165, 10)=lp(220,  4)+rz*kp(165,  4)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_pf( )
    pf(  2, 11)=dd(  5,  5)+rx*pd(  2,  5)
    pf(  3, 11)=dd(  6,  5)+rx*pd(  3,  5)
    pf(  4, 11)=dd(  7,  5)+rx*pd(  4,  5)
    pf(  2, 12)=dd(  5,  6)+rx*pd(  2,  6)
    pf(  3, 12)=dd(  6,  6)+rx*pd(  3,  6)
    pf(  4, 12)=dd(  7,  6)+rx*pd(  4,  6)
    pf(  2, 13)=dd(  5,  7)+rx*pd(  2,  7)
    pf(  3, 13)=dd(  6,  7)+rx*pd(  3,  7)
    pf(  4, 13)=dd(  7,  7)+rx*pd(  4,  7)
    pf(  2, 14)=dd(  5,  8)+rx*pd(  2,  8)
    pf(  3, 14)=dd(  6,  8)+rx*pd(  3,  8)
    pf(  4, 14)=dd(  7,  8)+rx*pd(  4,  8)
    pf(  2, 15)=dd(  5,  9)+rx*pd(  2,  9)
    pf(  3, 15)=dd(  6,  9)+rx*pd(  3,  9)
    pf(  4, 15)=dd(  7,  9)+rx*pd(  4,  9)
    pf(  2, 16)=dd(  5, 10)+rx*pd(  2, 10)
    pf(  3, 16)=dd(  6, 10)+rx*pd(  3, 10)
    pf(  4, 16)=dd(  7, 10)+rx*pd(  4, 10)
    pf(  2, 17)=dd(  6,  8)+ry*pd(  2,  8)
    pf(  3, 17)=dd(  8,  8)+ry*pd(  3,  8)
    pf(  4, 17)=dd(  9,  8)+ry*pd(  4,  8)
    pf(  2, 18)=dd(  6,  9)+ry*pd(  2,  9)
    pf(  3, 18)=dd(  8,  9)+ry*pd(  3,  9)
    pf(  4, 18)=dd(  9,  9)+ry*pd(  4,  9)
    pf(  2, 19)=dd(  6, 10)+ry*pd(  2, 10)
    pf(  3, 19)=dd(  8, 10)+ry*pd(  3, 10)
    pf(  4, 19)=dd(  9, 10)+ry*pd(  4, 10)
    pf(  2, 20)=dd(  7, 10)+rz*pd(  2, 10)
    pf(  3, 20)=dd(  9, 10)+rz*pd(  3, 10)
    pf(  4, 20)=dd( 10, 10)+rz*pd(  4, 10)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_df( )
    df(  5, 11)=fd( 11,  5)+rx*dd(  5,  5)
    df(  6, 11)=fd( 12,  5)+rx*dd(  6,  5)
    df(  7, 11)=fd( 13,  5)+rx*dd(  7,  5)
    df(  8, 11)=fd( 14,  5)+rx*dd(  8,  5)
    df(  9, 11)=fd( 15,  5)+rx*dd(  9,  5)
    df( 10, 11)=fd( 16,  5)+rx*dd( 10,  5)
    df(  5, 12)=fd( 11,  6)+rx*dd(  5,  6)
    df(  6, 12)=fd( 12,  6)+rx*dd(  6,  6)
    df(  7, 12)=fd( 13,  6)+rx*dd(  7,  6)
    df(  8, 12)=fd( 14,  6)+rx*dd(  8,  6)
    df(  9, 12)=fd( 15,  6)+rx*dd(  9,  6)
    df( 10, 12)=fd( 16,  6)+rx*dd( 10,  6)
    df(  5, 13)=fd( 11,  7)+rx*dd(  5,  7)
    df(  6, 13)=fd( 12,  7)+rx*dd(  6,  7)
    df(  7, 13)=fd( 13,  7)+rx*dd(  7,  7)
    df(  8, 13)=fd( 14,  7)+rx*dd(  8,  7)
    df(  9, 13)=fd( 15,  7)+rx*dd(  9,  7)
    df( 10, 13)=fd( 16,  7)+rx*dd( 10,  7)
    df(  5, 14)=fd( 11,  8)+rx*dd(  5,  8)
    df(  6, 14)=fd( 12,  8)+rx*dd(  6,  8)
    df(  7, 14)=fd( 13,  8)+rx*dd(  7,  8)
    df(  8, 14)=fd( 14,  8)+rx*dd(  8,  8)
    df(  9, 14)=fd( 15,  8)+rx*dd(  9,  8)
    df( 10, 14)=fd( 16,  8)+rx*dd( 10,  8)
    df(  5, 15)=fd( 11,  9)+rx*dd(  5,  9)
    df(  6, 15)=fd( 12,  9)+rx*dd(  6,  9)
    df(  7, 15)=fd( 13,  9)+rx*dd(  7,  9)
    df(  8, 15)=fd( 14,  9)+rx*dd(  8,  9)
    df(  9, 15)=fd( 15,  9)+rx*dd(  9,  9)
    df( 10, 15)=fd( 16,  9)+rx*dd( 10,  9)
    df(  5, 16)=fd( 11, 10)+rx*dd(  5, 10)
    df(  6, 16)=fd( 12, 10)+rx*dd(  6, 10)
    df(  7, 16)=fd( 13, 10)+rx*dd(  7, 10)
    df(  8, 16)=fd( 14, 10)+rx*dd(  8, 10)
    df(  9, 16)=fd( 15, 10)+rx*dd(  9, 10)
    df( 10, 16)=fd( 16, 10)+rx*dd( 10, 10)
    df(  5, 17)=fd( 12,  8)+ry*dd(  5,  8)
    df(  6, 17)=fd( 14,  8)+ry*dd(  6,  8)
    df(  7, 17)=fd( 15,  8)+ry*dd(  7,  8)
    df(  8, 17)=fd( 17,  8)+ry*dd(  8,  8)
    df(  9, 17)=fd( 18,  8)+ry*dd(  9,  8)
    df( 10, 17)=fd( 19,  8)+ry*dd( 10,  8)
    df(  5, 18)=fd( 12,  9)+ry*dd(  5,  9)
    df(  6, 18)=fd( 14,  9)+ry*dd(  6,  9)
    df(  7, 18)=fd( 15,  9)+ry*dd(  7,  9)
    df(  8, 18)=fd( 17,  9)+ry*dd(  8,  9)
    df(  9, 18)=fd( 18,  9)+ry*dd(  9,  9)
    df( 10, 18)=fd( 19,  9)+ry*dd( 10,  9)
    df(  5, 19)=fd( 12, 10)+ry*dd(  5, 10)
    df(  6, 19)=fd( 14, 10)+ry*dd(  6, 10)
    df(  7, 19)=fd( 15, 10)+ry*dd(  7, 10)
    df(  8, 19)=fd( 17, 10)+ry*dd(  8, 10)
    df(  9, 19)=fd( 18, 10)+ry*dd(  9, 10)
    df( 10, 19)=fd( 19, 10)+ry*dd( 10, 10)
    df(  5, 20)=fd( 13, 10)+rz*dd(  5, 10)
    df(  6, 20)=fd( 15, 10)+rz*dd(  6, 10)
    df(  7, 20)=fd( 16, 10)+rz*dd(  7, 10)
    df(  8, 20)=fd( 18, 10)+rz*dd(  8, 10)
    df(  9, 20)=fd( 19, 10)+rz*dd(  9, 10)
    df( 10, 20)=fd( 20, 10)+rz*dd( 10, 10)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_ff( )
    ff( 11, 11)=gd( 21,  5)+rx*fd( 11,  5)
    ff( 12, 11)=gd( 22,  5)+rx*fd( 12,  5)
    ff( 13, 11)=gd( 23,  5)+rx*fd( 13,  5)
    ff( 14, 11)=gd( 24,  5)+rx*fd( 14,  5)
    ff( 15, 11)=gd( 25,  5)+rx*fd( 15,  5)
    ff( 16, 11)=gd( 26,  5)+rx*fd( 16,  5)
    ff( 17, 11)=gd( 27,  5)+rx*fd( 17,  5)
    ff( 18, 11)=gd( 28,  5)+rx*fd( 18,  5)
    ff( 19, 11)=gd( 29,  5)+rx*fd( 19,  5)
    ff( 20, 11)=gd( 30,  5)+rx*fd( 20,  5)
    ff( 11, 12)=gd( 21,  6)+rx*fd( 11,  6)
    ff( 12, 12)=gd( 22,  6)+rx*fd( 12,  6)
    ff( 13, 12)=gd( 23,  6)+rx*fd( 13,  6)
    ff( 14, 12)=gd( 24,  6)+rx*fd( 14,  6)
    ff( 15, 12)=gd( 25,  6)+rx*fd( 15,  6)
    ff( 16, 12)=gd( 26,  6)+rx*fd( 16,  6)
    ff( 17, 12)=gd( 27,  6)+rx*fd( 17,  6)
    ff( 18, 12)=gd( 28,  6)+rx*fd( 18,  6)
    ff( 19, 12)=gd( 29,  6)+rx*fd( 19,  6)
    ff( 20, 12)=gd( 30,  6)+rx*fd( 20,  6)
    ff( 11, 13)=gd( 21,  7)+rx*fd( 11,  7)
    ff( 12, 13)=gd( 22,  7)+rx*fd( 12,  7)
    ff( 13, 13)=gd( 23,  7)+rx*fd( 13,  7)
    ff( 14, 13)=gd( 24,  7)+rx*fd( 14,  7)
    ff( 15, 13)=gd( 25,  7)+rx*fd( 15,  7)
    ff( 16, 13)=gd( 26,  7)+rx*fd( 16,  7)
    ff( 17, 13)=gd( 27,  7)+rx*fd( 17,  7)
    ff( 18, 13)=gd( 28,  7)+rx*fd( 18,  7)
    ff( 19, 13)=gd( 29,  7)+rx*fd( 19,  7)
    ff( 20, 13)=gd( 30,  7)+rx*fd( 20,  7)
    ff( 11, 14)=gd( 21,  8)+rx*fd( 11,  8)
    ff( 12, 14)=gd( 22,  8)+rx*fd( 12,  8)
    ff( 13, 14)=gd( 23,  8)+rx*fd( 13,  8)
    ff( 14, 14)=gd( 24,  8)+rx*fd( 14,  8)
    ff( 15, 14)=gd( 25,  8)+rx*fd( 15,  8)
    ff( 16, 14)=gd( 26,  8)+rx*fd( 16,  8)
    ff( 17, 14)=gd( 27,  8)+rx*fd( 17,  8)
    ff( 18, 14)=gd( 28,  8)+rx*fd( 18,  8)
    ff( 19, 14)=gd( 29,  8)+rx*fd( 19,  8)
    ff( 20, 14)=gd( 30,  8)+rx*fd( 20,  8)
    ff( 11, 15)=gd( 21,  9)+rx*fd( 11,  9)
    ff( 12, 15)=gd( 22,  9)+rx*fd( 12,  9)
    ff( 13, 15)=gd( 23,  9)+rx*fd( 13,  9)
    ff( 14, 15)=gd( 24,  9)+rx*fd( 14,  9)
    ff( 15, 15)=gd( 25,  9)+rx*fd( 15,  9)
    ff( 16, 15)=gd( 26,  9)+rx*fd( 16,  9)
    ff( 17, 15)=gd( 27,  9)+rx*fd( 17,  9)
    ff( 18, 15)=gd( 28,  9)+rx*fd( 18,  9)
    ff( 19, 15)=gd( 29,  9)+rx*fd( 19,  9)
    ff( 20, 15)=gd( 30,  9)+rx*fd( 20,  9)
    ff( 11, 16)=gd( 21, 10)+rx*fd( 11, 10)
    ff( 12, 16)=gd( 22, 10)+rx*fd( 12, 10)
    ff( 13, 16)=gd( 23, 10)+rx*fd( 13, 10)
    ff( 14, 16)=gd( 24, 10)+rx*fd( 14, 10)
    ff( 15, 16)=gd( 25, 10)+rx*fd( 15, 10)
    ff( 16, 16)=gd( 26, 10)+rx*fd( 16, 10)
    ff( 17, 16)=gd( 27, 10)+rx*fd( 17, 10)
    ff( 18, 16)=gd( 28, 10)+rx*fd( 18, 10)
    ff( 19, 16)=gd( 29, 10)+rx*fd( 19, 10)
    ff( 20, 16)=gd( 30, 10)+rx*fd( 20, 10)
    ff( 11, 17)=gd( 22,  8)+ry*fd( 11,  8)
    ff( 12, 17)=gd( 24,  8)+ry*fd( 12,  8)
    ff( 13, 17)=gd( 25,  8)+ry*fd( 13,  8)
    ff( 14, 17)=gd( 27,  8)+ry*fd( 14,  8)
    ff( 15, 17)=gd( 28,  8)+ry*fd( 15,  8)
    ff( 16, 17)=gd( 29,  8)+ry*fd( 16,  8)
    ff( 17, 17)=gd( 31,  8)+ry*fd( 17,  8)
    ff( 18, 17)=gd( 32,  8)+ry*fd( 18,  8)
    ff( 19, 17)=gd( 33,  8)+ry*fd( 19,  8)
    ff( 20, 17)=gd( 34,  8)+ry*fd( 20,  8)
    ff( 11, 18)=gd( 22,  9)+ry*fd( 11,  9)
    ff( 12, 18)=gd( 24,  9)+ry*fd( 12,  9)
    ff( 13, 18)=gd( 25,  9)+ry*fd( 13,  9)
    ff( 14, 18)=gd( 27,  9)+ry*fd( 14,  9)
    ff( 15, 18)=gd( 28,  9)+ry*fd( 15,  9)
    ff( 16, 18)=gd( 29,  9)+ry*fd( 16,  9)
    ff( 17, 18)=gd( 31,  9)+ry*fd( 17,  9)
    ff( 18, 18)=gd( 32,  9)+ry*fd( 18,  9)
    ff( 19, 18)=gd( 33,  9)+ry*fd( 19,  9)
    ff( 20, 18)=gd( 34,  9)+ry*fd( 20,  9)
    ff( 11, 19)=gd( 22, 10)+ry*fd( 11, 10)
    ff( 12, 19)=gd( 24, 10)+ry*fd( 12, 10)
    ff( 13, 19)=gd( 25, 10)+ry*fd( 13, 10)
    ff( 14, 19)=gd( 27, 10)+ry*fd( 14, 10)
    ff( 15, 19)=gd( 28, 10)+ry*fd( 15, 10)
    ff( 16, 19)=gd( 29, 10)+ry*fd( 16, 10)
    ff( 17, 19)=gd( 31, 10)+ry*fd( 17, 10)
    ff( 18, 19)=gd( 32, 10)+ry*fd( 18, 10)
    ff( 19, 19)=gd( 33, 10)+ry*fd( 19, 10)
    ff( 20, 19)=gd( 34, 10)+ry*fd( 20, 10)
    ff( 11, 20)=gd( 23, 10)+rz*fd( 11, 10)
    ff( 12, 20)=gd( 25, 10)+rz*fd( 12, 10)
    ff( 13, 20)=gd( 26, 10)+rz*fd( 13, 10)
    ff( 14, 20)=gd( 28, 10)+rz*fd( 14, 10)
    ff( 15, 20)=gd( 29, 10)+rz*fd( 15, 10)
    ff( 16, 20)=gd( 30, 10)+rz*fd( 16, 10)
    ff( 17, 20)=gd( 32, 10)+rz*fd( 17, 10)
    ff( 18, 20)=gd( 33, 10)+rz*fd( 18, 10)
    ff( 19, 20)=gd( 34, 10)+rz*fd( 19, 10)
    ff( 20, 20)=gd( 35, 10)+rz*fd( 20, 10)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_gf( )
    gf( 21, 11)=hd( 36,  5)+rx*gd( 21,  5)
    gf( 22, 11)=hd( 37,  5)+rx*gd( 22,  5)
    gf( 23, 11)=hd( 38,  5)+rx*gd( 23,  5)
    gf( 24, 11)=hd( 39,  5)+rx*gd( 24,  5)
    gf( 25, 11)=hd( 40,  5)+rx*gd( 25,  5)
    gf( 26, 11)=hd( 41,  5)+rx*gd( 26,  5)
    gf( 27, 11)=hd( 42,  5)+rx*gd( 27,  5)
    gf( 28, 11)=hd( 43,  5)+rx*gd( 28,  5)
    gf( 29, 11)=hd( 44,  5)+rx*gd( 29,  5)
    gf( 30, 11)=hd( 45,  5)+rx*gd( 30,  5)
    gf( 31, 11)=hd( 46,  5)+rx*gd( 31,  5)
    gf( 32, 11)=hd( 47,  5)+rx*gd( 32,  5)
    gf( 33, 11)=hd( 48,  5)+rx*gd( 33,  5)
    gf( 34, 11)=hd( 49,  5)+rx*gd( 34,  5)
    gf( 35, 11)=hd( 50,  5)+rx*gd( 35,  5)
    gf( 21, 12)=hd( 36,  6)+rx*gd( 21,  6)
    gf( 22, 12)=hd( 37,  6)+rx*gd( 22,  6)
    gf( 23, 12)=hd( 38,  6)+rx*gd( 23,  6)
    gf( 24, 12)=hd( 39,  6)+rx*gd( 24,  6)
    gf( 25, 12)=hd( 40,  6)+rx*gd( 25,  6)
    gf( 26, 12)=hd( 41,  6)+rx*gd( 26,  6)
    gf( 27, 12)=hd( 42,  6)+rx*gd( 27,  6)
    gf( 28, 12)=hd( 43,  6)+rx*gd( 28,  6)
    gf( 29, 12)=hd( 44,  6)+rx*gd( 29,  6)
    gf( 30, 12)=hd( 45,  6)+rx*gd( 30,  6)
    gf( 31, 12)=hd( 46,  6)+rx*gd( 31,  6)
    gf( 32, 12)=hd( 47,  6)+rx*gd( 32,  6)
    gf( 33, 12)=hd( 48,  6)+rx*gd( 33,  6)
    gf( 34, 12)=hd( 49,  6)+rx*gd( 34,  6)
    gf( 35, 12)=hd( 50,  6)+rx*gd( 35,  6)
    gf( 21, 13)=hd( 36,  7)+rx*gd( 21,  7)
    gf( 22, 13)=hd( 37,  7)+rx*gd( 22,  7)
    gf( 23, 13)=hd( 38,  7)+rx*gd( 23,  7)
    gf( 24, 13)=hd( 39,  7)+rx*gd( 24,  7)
    gf( 25, 13)=hd( 40,  7)+rx*gd( 25,  7)
    gf( 26, 13)=hd( 41,  7)+rx*gd( 26,  7)
    gf( 27, 13)=hd( 42,  7)+rx*gd( 27,  7)
    gf( 28, 13)=hd( 43,  7)+rx*gd( 28,  7)
    gf( 29, 13)=hd( 44,  7)+rx*gd( 29,  7)
    gf( 30, 13)=hd( 45,  7)+rx*gd( 30,  7)
    gf( 31, 13)=hd( 46,  7)+rx*gd( 31,  7)
    gf( 32, 13)=hd( 47,  7)+rx*gd( 32,  7)
    gf( 33, 13)=hd( 48,  7)+rx*gd( 33,  7)
    gf( 34, 13)=hd( 49,  7)+rx*gd( 34,  7)
    gf( 35, 13)=hd( 50,  7)+rx*gd( 35,  7)
    gf( 21, 14)=hd( 36,  8)+rx*gd( 21,  8)
    gf( 22, 14)=hd( 37,  8)+rx*gd( 22,  8)
    gf( 23, 14)=hd( 38,  8)+rx*gd( 23,  8)
    gf( 24, 14)=hd( 39,  8)+rx*gd( 24,  8)
    gf( 25, 14)=hd( 40,  8)+rx*gd( 25,  8)
    gf( 26, 14)=hd( 41,  8)+rx*gd( 26,  8)
    gf( 27, 14)=hd( 42,  8)+rx*gd( 27,  8)
    gf( 28, 14)=hd( 43,  8)+rx*gd( 28,  8)
    gf( 29, 14)=hd( 44,  8)+rx*gd( 29,  8)
    gf( 30, 14)=hd( 45,  8)+rx*gd( 30,  8)
    gf( 31, 14)=hd( 46,  8)+rx*gd( 31,  8)
    gf( 32, 14)=hd( 47,  8)+rx*gd( 32,  8)
    gf( 33, 14)=hd( 48,  8)+rx*gd( 33,  8)
    gf( 34, 14)=hd( 49,  8)+rx*gd( 34,  8)
    gf( 35, 14)=hd( 50,  8)+rx*gd( 35,  8)
    gf( 21, 15)=hd( 36,  9)+rx*gd( 21,  9)
    gf( 22, 15)=hd( 37,  9)+rx*gd( 22,  9)
    gf( 23, 15)=hd( 38,  9)+rx*gd( 23,  9)
    gf( 24, 15)=hd( 39,  9)+rx*gd( 24,  9)
    gf( 25, 15)=hd( 40,  9)+rx*gd( 25,  9)
    gf( 26, 15)=hd( 41,  9)+rx*gd( 26,  9)
    gf( 27, 15)=hd( 42,  9)+rx*gd( 27,  9)
    gf( 28, 15)=hd( 43,  9)+rx*gd( 28,  9)
    gf( 29, 15)=hd( 44,  9)+rx*gd( 29,  9)
    gf( 30, 15)=hd( 45,  9)+rx*gd( 30,  9)
    gf( 31, 15)=hd( 46,  9)+rx*gd( 31,  9)
    gf( 32, 15)=hd( 47,  9)+rx*gd( 32,  9)
    gf( 33, 15)=hd( 48,  9)+rx*gd( 33,  9)
    gf( 34, 15)=hd( 49,  9)+rx*gd( 34,  9)
    gf( 35, 15)=hd( 50,  9)+rx*gd( 35,  9)
    gf( 21, 16)=hd( 36, 10)+rx*gd( 21, 10)
    gf( 22, 16)=hd( 37, 10)+rx*gd( 22, 10)
    gf( 23, 16)=hd( 38, 10)+rx*gd( 23, 10)
    gf( 24, 16)=hd( 39, 10)+rx*gd( 24, 10)
    gf( 25, 16)=hd( 40, 10)+rx*gd( 25, 10)
    gf( 26, 16)=hd( 41, 10)+rx*gd( 26, 10)
    gf( 27, 16)=hd( 42, 10)+rx*gd( 27, 10)
    gf( 28, 16)=hd( 43, 10)+rx*gd( 28, 10)
    gf( 29, 16)=hd( 44, 10)+rx*gd( 29, 10)
    gf( 30, 16)=hd( 45, 10)+rx*gd( 30, 10)
    gf( 31, 16)=hd( 46, 10)+rx*gd( 31, 10)
    gf( 32, 16)=hd( 47, 10)+rx*gd( 32, 10)
    gf( 33, 16)=hd( 48, 10)+rx*gd( 33, 10)
    gf( 34, 16)=hd( 49, 10)+rx*gd( 34, 10)
    gf( 35, 16)=hd( 50, 10)+rx*gd( 35, 10)
    gf( 21, 17)=hd( 37,  8)+ry*gd( 21,  8)
    gf( 22, 17)=hd( 39,  8)+ry*gd( 22,  8)
    gf( 23, 17)=hd( 40,  8)+ry*gd( 23,  8)
    gf( 24, 17)=hd( 42,  8)+ry*gd( 24,  8)
    gf( 25, 17)=hd( 43,  8)+ry*gd( 25,  8)
    gf( 26, 17)=hd( 44,  8)+ry*gd( 26,  8)
    gf( 27, 17)=hd( 46,  8)+ry*gd( 27,  8)
    gf( 28, 17)=hd( 47,  8)+ry*gd( 28,  8)
    gf( 29, 17)=hd( 48,  8)+ry*gd( 29,  8)
    gf( 30, 17)=hd( 49,  8)+ry*gd( 30,  8)
    gf( 31, 17)=hd( 51,  8)+ry*gd( 31,  8)
    gf( 32, 17)=hd( 52,  8)+ry*gd( 32,  8)
    gf( 33, 17)=hd( 53,  8)+ry*gd( 33,  8)
    gf( 34, 17)=hd( 54,  8)+ry*gd( 34,  8)
    gf( 35, 17)=hd( 55,  8)+ry*gd( 35,  8)
    gf( 21, 18)=hd( 37,  9)+ry*gd( 21,  9)
    gf( 22, 18)=hd( 39,  9)+ry*gd( 22,  9)
    gf( 23, 18)=hd( 40,  9)+ry*gd( 23,  9)
    gf( 24, 18)=hd( 42,  9)+ry*gd( 24,  9)
    gf( 25, 18)=hd( 43,  9)+ry*gd( 25,  9)
    gf( 26, 18)=hd( 44,  9)+ry*gd( 26,  9)
    gf( 27, 18)=hd( 46,  9)+ry*gd( 27,  9)
    gf( 28, 18)=hd( 47,  9)+ry*gd( 28,  9)
    gf( 29, 18)=hd( 48,  9)+ry*gd( 29,  9)
    gf( 30, 18)=hd( 49,  9)+ry*gd( 30,  9)
    gf( 31, 18)=hd( 51,  9)+ry*gd( 31,  9)
    gf( 32, 18)=hd( 52,  9)+ry*gd( 32,  9)
    gf( 33, 18)=hd( 53,  9)+ry*gd( 33,  9)
    gf( 34, 18)=hd( 54,  9)+ry*gd( 34,  9)
    gf( 35, 18)=hd( 55,  9)+ry*gd( 35,  9)
    gf( 21, 19)=hd( 37, 10)+ry*gd( 21, 10)
    gf( 22, 19)=hd( 39, 10)+ry*gd( 22, 10)
    gf( 23, 19)=hd( 40, 10)+ry*gd( 23, 10)
    gf( 24, 19)=hd( 42, 10)+ry*gd( 24, 10)
    gf( 25, 19)=hd( 43, 10)+ry*gd( 25, 10)
    gf( 26, 19)=hd( 44, 10)+ry*gd( 26, 10)
    gf( 27, 19)=hd( 46, 10)+ry*gd( 27, 10)
    gf( 28, 19)=hd( 47, 10)+ry*gd( 28, 10)
    gf( 29, 19)=hd( 48, 10)+ry*gd( 29, 10)
    gf( 30, 19)=hd( 49, 10)+ry*gd( 30, 10)
    gf( 31, 19)=hd( 51, 10)+ry*gd( 31, 10)
    gf( 32, 19)=hd( 52, 10)+ry*gd( 32, 10)
    gf( 33, 19)=hd( 53, 10)+ry*gd( 33, 10)
    gf( 34, 19)=hd( 54, 10)+ry*gd( 34, 10)
    gf( 35, 19)=hd( 55, 10)+ry*gd( 35, 10)
    gf( 21, 20)=hd( 38, 10)+rz*gd( 21, 10)
    gf( 22, 20)=hd( 40, 10)+rz*gd( 22, 10)
    gf( 23, 20)=hd( 41, 10)+rz*gd( 23, 10)
    gf( 24, 20)=hd( 43, 10)+rz*gd( 24, 10)
    gf( 25, 20)=hd( 44, 10)+rz*gd( 25, 10)
    gf( 26, 20)=hd( 45, 10)+rz*gd( 26, 10)
    gf( 27, 20)=hd( 47, 10)+rz*gd( 27, 10)
    gf( 28, 20)=hd( 48, 10)+rz*gd( 28, 10)
    gf( 29, 20)=hd( 49, 10)+rz*gd( 29, 10)
    gf( 30, 20)=hd( 50, 10)+rz*gd( 30, 10)
    gf( 31, 20)=hd( 52, 10)+rz*gd( 31, 10)
    gf( 32, 20)=hd( 53, 10)+rz*gd( 32, 10)
    gf( 33, 20)=hd( 54, 10)+rz*gd( 33, 10)
    gf( 34, 20)=hd( 55, 10)+rz*gd( 34, 10)
    gf( 35, 20)=hd( 56, 10)+rz*gd( 35, 10)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_hf( )
    hf( 36, 11)=id( 57,  5)+rx*hd( 36,  5)
    hf( 37, 11)=id( 58,  5)+rx*hd( 37,  5)
    hf( 38, 11)=id( 59,  5)+rx*hd( 38,  5)
    hf( 39, 11)=id( 60,  5)+rx*hd( 39,  5)
    hf( 40, 11)=id( 61,  5)+rx*hd( 40,  5)
    hf( 41, 11)=id( 62,  5)+rx*hd( 41,  5)
    hf( 42, 11)=id( 63,  5)+rx*hd( 42,  5)
    hf( 43, 11)=id( 64,  5)+rx*hd( 43,  5)
    hf( 44, 11)=id( 65,  5)+rx*hd( 44,  5)
    hf( 45, 11)=id( 66,  5)+rx*hd( 45,  5)
    hf( 46, 11)=id( 67,  5)+rx*hd( 46,  5)
    hf( 47, 11)=id( 68,  5)+rx*hd( 47,  5)
    hf( 48, 11)=id( 69,  5)+rx*hd( 48,  5)
    hf( 49, 11)=id( 70,  5)+rx*hd( 49,  5)
    hf( 50, 11)=id( 71,  5)+rx*hd( 50,  5)
    hf( 51, 11)=id( 72,  5)+rx*hd( 51,  5)
    hf( 52, 11)=id( 73,  5)+rx*hd( 52,  5)
    hf( 53, 11)=id( 74,  5)+rx*hd( 53,  5)
    hf( 54, 11)=id( 75,  5)+rx*hd( 54,  5)
    hf( 55, 11)=id( 76,  5)+rx*hd( 55,  5)
    hf( 56, 11)=id( 77,  5)+rx*hd( 56,  5)
    hf( 36, 12)=id( 57,  6)+rx*hd( 36,  6)
    hf( 37, 12)=id( 58,  6)+rx*hd( 37,  6)
    hf( 38, 12)=id( 59,  6)+rx*hd( 38,  6)
    hf( 39, 12)=id( 60,  6)+rx*hd( 39,  6)
    hf( 40, 12)=id( 61,  6)+rx*hd( 40,  6)
    hf( 41, 12)=id( 62,  6)+rx*hd( 41,  6)
    hf( 42, 12)=id( 63,  6)+rx*hd( 42,  6)
    hf( 43, 12)=id( 64,  6)+rx*hd( 43,  6)
    hf( 44, 12)=id( 65,  6)+rx*hd( 44,  6)
    hf( 45, 12)=id( 66,  6)+rx*hd( 45,  6)
    hf( 46, 12)=id( 67,  6)+rx*hd( 46,  6)
    hf( 47, 12)=id( 68,  6)+rx*hd( 47,  6)
    hf( 48, 12)=id( 69,  6)+rx*hd( 48,  6)
    hf( 49, 12)=id( 70,  6)+rx*hd( 49,  6)
    hf( 50, 12)=id( 71,  6)+rx*hd( 50,  6)
    hf( 51, 12)=id( 72,  6)+rx*hd( 51,  6)
    hf( 52, 12)=id( 73,  6)+rx*hd( 52,  6)
    hf( 53, 12)=id( 74,  6)+rx*hd( 53,  6)
    hf( 54, 12)=id( 75,  6)+rx*hd( 54,  6)
    hf( 55, 12)=id( 76,  6)+rx*hd( 55,  6)
    hf( 56, 12)=id( 77,  6)+rx*hd( 56,  6)
    hf( 36, 13)=id( 57,  7)+rx*hd( 36,  7)
    hf( 37, 13)=id( 58,  7)+rx*hd( 37,  7)
    hf( 38, 13)=id( 59,  7)+rx*hd( 38,  7)
    hf( 39, 13)=id( 60,  7)+rx*hd( 39,  7)
    hf( 40, 13)=id( 61,  7)+rx*hd( 40,  7)
    hf( 41, 13)=id( 62,  7)+rx*hd( 41,  7)
    hf( 42, 13)=id( 63,  7)+rx*hd( 42,  7)
    hf( 43, 13)=id( 64,  7)+rx*hd( 43,  7)
    hf( 44, 13)=id( 65,  7)+rx*hd( 44,  7)
    hf( 45, 13)=id( 66,  7)+rx*hd( 45,  7)
    hf( 46, 13)=id( 67,  7)+rx*hd( 46,  7)
    hf( 47, 13)=id( 68,  7)+rx*hd( 47,  7)
    hf( 48, 13)=id( 69,  7)+rx*hd( 48,  7)
    hf( 49, 13)=id( 70,  7)+rx*hd( 49,  7)
    hf( 50, 13)=id( 71,  7)+rx*hd( 50,  7)
    hf( 51, 13)=id( 72,  7)+rx*hd( 51,  7)
    hf( 52, 13)=id( 73,  7)+rx*hd( 52,  7)
    hf( 53, 13)=id( 74,  7)+rx*hd( 53,  7)
    hf( 54, 13)=id( 75,  7)+rx*hd( 54,  7)
    hf( 55, 13)=id( 76,  7)+rx*hd( 55,  7)
    hf( 56, 13)=id( 77,  7)+rx*hd( 56,  7)
    hf( 36, 14)=id( 57,  8)+rx*hd( 36,  8)
    hf( 37, 14)=id( 58,  8)+rx*hd( 37,  8)
    hf( 38, 14)=id( 59,  8)+rx*hd( 38,  8)
    hf( 39, 14)=id( 60,  8)+rx*hd( 39,  8)
    hf( 40, 14)=id( 61,  8)+rx*hd( 40,  8)
    hf( 41, 14)=id( 62,  8)+rx*hd( 41,  8)
    hf( 42, 14)=id( 63,  8)+rx*hd( 42,  8)
    hf( 43, 14)=id( 64,  8)+rx*hd( 43,  8)
    hf( 44, 14)=id( 65,  8)+rx*hd( 44,  8)
    hf( 45, 14)=id( 66,  8)+rx*hd( 45,  8)
    hf( 46, 14)=id( 67,  8)+rx*hd( 46,  8)
    hf( 47, 14)=id( 68,  8)+rx*hd( 47,  8)
    hf( 48, 14)=id( 69,  8)+rx*hd( 48,  8)
    hf( 49, 14)=id( 70,  8)+rx*hd( 49,  8)
    hf( 50, 14)=id( 71,  8)+rx*hd( 50,  8)
    hf( 51, 14)=id( 72,  8)+rx*hd( 51,  8)
    hf( 52, 14)=id( 73,  8)+rx*hd( 52,  8)
    hf( 53, 14)=id( 74,  8)+rx*hd( 53,  8)
    hf( 54, 14)=id( 75,  8)+rx*hd( 54,  8)
    hf( 55, 14)=id( 76,  8)+rx*hd( 55,  8)
    hf( 56, 14)=id( 77,  8)+rx*hd( 56,  8)
    hf( 36, 15)=id( 57,  9)+rx*hd( 36,  9)
    hf( 37, 15)=id( 58,  9)+rx*hd( 37,  9)
    hf( 38, 15)=id( 59,  9)+rx*hd( 38,  9)
    hf( 39, 15)=id( 60,  9)+rx*hd( 39,  9)
    hf( 40, 15)=id( 61,  9)+rx*hd( 40,  9)
    hf( 41, 15)=id( 62,  9)+rx*hd( 41,  9)
    hf( 42, 15)=id( 63,  9)+rx*hd( 42,  9)
    hf( 43, 15)=id( 64,  9)+rx*hd( 43,  9)
    hf( 44, 15)=id( 65,  9)+rx*hd( 44,  9)
    hf( 45, 15)=id( 66,  9)+rx*hd( 45,  9)
    hf( 46, 15)=id( 67,  9)+rx*hd( 46,  9)
    hf( 47, 15)=id( 68,  9)+rx*hd( 47,  9)
    hf( 48, 15)=id( 69,  9)+rx*hd( 48,  9)
    hf( 49, 15)=id( 70,  9)+rx*hd( 49,  9)
    hf( 50, 15)=id( 71,  9)+rx*hd( 50,  9)
    hf( 51, 15)=id( 72,  9)+rx*hd( 51,  9)
    hf( 52, 15)=id( 73,  9)+rx*hd( 52,  9)
    hf( 53, 15)=id( 74,  9)+rx*hd( 53,  9)
    hf( 54, 15)=id( 75,  9)+rx*hd( 54,  9)
    hf( 55, 15)=id( 76,  9)+rx*hd( 55,  9)
    hf( 56, 15)=id( 77,  9)+rx*hd( 56,  9)
    hf( 36, 16)=id( 57, 10)+rx*hd( 36, 10)
    hf( 37, 16)=id( 58, 10)+rx*hd( 37, 10)
    hf( 38, 16)=id( 59, 10)+rx*hd( 38, 10)
    hf( 39, 16)=id( 60, 10)+rx*hd( 39, 10)
    hf( 40, 16)=id( 61, 10)+rx*hd( 40, 10)
    hf( 41, 16)=id( 62, 10)+rx*hd( 41, 10)
    hf( 42, 16)=id( 63, 10)+rx*hd( 42, 10)
    hf( 43, 16)=id( 64, 10)+rx*hd( 43, 10)
    hf( 44, 16)=id( 65, 10)+rx*hd( 44, 10)
    hf( 45, 16)=id( 66, 10)+rx*hd( 45, 10)
    hf( 46, 16)=id( 67, 10)+rx*hd( 46, 10)
    hf( 47, 16)=id( 68, 10)+rx*hd( 47, 10)
    hf( 48, 16)=id( 69, 10)+rx*hd( 48, 10)
    hf( 49, 16)=id( 70, 10)+rx*hd( 49, 10)
    hf( 50, 16)=id( 71, 10)+rx*hd( 50, 10)
    hf( 51, 16)=id( 72, 10)+rx*hd( 51, 10)
    hf( 52, 16)=id( 73, 10)+rx*hd( 52, 10)
    hf( 53, 16)=id( 74, 10)+rx*hd( 53, 10)
    hf( 54, 16)=id( 75, 10)+rx*hd( 54, 10)
    hf( 55, 16)=id( 76, 10)+rx*hd( 55, 10)
    hf( 56, 16)=id( 77, 10)+rx*hd( 56, 10)
    hf( 36, 17)=id( 58,  8)+ry*hd( 36,  8)
    hf( 37, 17)=id( 60,  8)+ry*hd( 37,  8)
    hf( 38, 17)=id( 61,  8)+ry*hd( 38,  8)
    hf( 39, 17)=id( 63,  8)+ry*hd( 39,  8)
    hf( 40, 17)=id( 64,  8)+ry*hd( 40,  8)
    hf( 41, 17)=id( 65,  8)+ry*hd( 41,  8)
    hf( 42, 17)=id( 67,  8)+ry*hd( 42,  8)
    hf( 43, 17)=id( 68,  8)+ry*hd( 43,  8)
    hf( 44, 17)=id( 69,  8)+ry*hd( 44,  8)
    hf( 45, 17)=id( 70,  8)+ry*hd( 45,  8)
    hf( 46, 17)=id( 72,  8)+ry*hd( 46,  8)
    hf( 47, 17)=id( 73,  8)+ry*hd( 47,  8)
    hf( 48, 17)=id( 74,  8)+ry*hd( 48,  8)
    hf( 49, 17)=id( 75,  8)+ry*hd( 49,  8)
    hf( 50, 17)=id( 76,  8)+ry*hd( 50,  8)
    hf( 51, 17)=id( 78,  8)+ry*hd( 51,  8)
    hf( 52, 17)=id( 79,  8)+ry*hd( 52,  8)
    hf( 53, 17)=id( 80,  8)+ry*hd( 53,  8)
    hf( 54, 17)=id( 81,  8)+ry*hd( 54,  8)
    hf( 55, 17)=id( 82,  8)+ry*hd( 55,  8)
    hf( 56, 17)=id( 83,  8)+ry*hd( 56,  8)
    hf( 36, 18)=id( 58,  9)+ry*hd( 36,  9)
    hf( 37, 18)=id( 60,  9)+ry*hd( 37,  9)
    hf( 38, 18)=id( 61,  9)+ry*hd( 38,  9)
    hf( 39, 18)=id( 63,  9)+ry*hd( 39,  9)
    hf( 40, 18)=id( 64,  9)+ry*hd( 40,  9)
    hf( 41, 18)=id( 65,  9)+ry*hd( 41,  9)
    hf( 42, 18)=id( 67,  9)+ry*hd( 42,  9)
    hf( 43, 18)=id( 68,  9)+ry*hd( 43,  9)
    hf( 44, 18)=id( 69,  9)+ry*hd( 44,  9)
    hf( 45, 18)=id( 70,  9)+ry*hd( 45,  9)
    hf( 46, 18)=id( 72,  9)+ry*hd( 46,  9)
    hf( 47, 18)=id( 73,  9)+ry*hd( 47,  9)
    hf( 48, 18)=id( 74,  9)+ry*hd( 48,  9)
    hf( 49, 18)=id( 75,  9)+ry*hd( 49,  9)
    hf( 50, 18)=id( 76,  9)+ry*hd( 50,  9)
    hf( 51, 18)=id( 78,  9)+ry*hd( 51,  9)
    hf( 52, 18)=id( 79,  9)+ry*hd( 52,  9)
    hf( 53, 18)=id( 80,  9)+ry*hd( 53,  9)
    hf( 54, 18)=id( 81,  9)+ry*hd( 54,  9)
    hf( 55, 18)=id( 82,  9)+ry*hd( 55,  9)
    hf( 56, 18)=id( 83,  9)+ry*hd( 56,  9)
    hf( 36, 19)=id( 58, 10)+ry*hd( 36, 10)
    hf( 37, 19)=id( 60, 10)+ry*hd( 37, 10)
    hf( 38, 19)=id( 61, 10)+ry*hd( 38, 10)
    hf( 39, 19)=id( 63, 10)+ry*hd( 39, 10)
    hf( 40, 19)=id( 64, 10)+ry*hd( 40, 10)
    hf( 41, 19)=id( 65, 10)+ry*hd( 41, 10)
    hf( 42, 19)=id( 67, 10)+ry*hd( 42, 10)
    hf( 43, 19)=id( 68, 10)+ry*hd( 43, 10)
    hf( 44, 19)=id( 69, 10)+ry*hd( 44, 10)
    hf( 45, 19)=id( 70, 10)+ry*hd( 45, 10)
    hf( 46, 19)=id( 72, 10)+ry*hd( 46, 10)
    hf( 47, 19)=id( 73, 10)+ry*hd( 47, 10)
    hf( 48, 19)=id( 74, 10)+ry*hd( 48, 10)
    hf( 49, 19)=id( 75, 10)+ry*hd( 49, 10)
    hf( 50, 19)=id( 76, 10)+ry*hd( 50, 10)
    hf( 51, 19)=id( 78, 10)+ry*hd( 51, 10)
    hf( 52, 19)=id( 79, 10)+ry*hd( 52, 10)
    hf( 53, 19)=id( 80, 10)+ry*hd( 53, 10)
    hf( 54, 19)=id( 81, 10)+ry*hd( 54, 10)
    hf( 55, 19)=id( 82, 10)+ry*hd( 55, 10)
    hf( 56, 19)=id( 83, 10)+ry*hd( 56, 10)
    hf( 36, 20)=id( 59, 10)+rz*hd( 36, 10)
    hf( 37, 20)=id( 61, 10)+rz*hd( 37, 10)
    hf( 38, 20)=id( 62, 10)+rz*hd( 38, 10)
    hf( 39, 20)=id( 64, 10)+rz*hd( 39, 10)
    hf( 40, 20)=id( 65, 10)+rz*hd( 40, 10)
    hf( 41, 20)=id( 66, 10)+rz*hd( 41, 10)
    hf( 42, 20)=id( 68, 10)+rz*hd( 42, 10)
    hf( 43, 20)=id( 69, 10)+rz*hd( 43, 10)
    hf( 44, 20)=id( 70, 10)+rz*hd( 44, 10)
    hf( 45, 20)=id( 71, 10)+rz*hd( 45, 10)
    hf( 46, 20)=id( 73, 10)+rz*hd( 46, 10)
    hf( 47, 20)=id( 74, 10)+rz*hd( 47, 10)
    hf( 48, 20)=id( 75, 10)+rz*hd( 48, 10)
    hf( 49, 20)=id( 76, 10)+rz*hd( 49, 10)
    hf( 50, 20)=id( 77, 10)+rz*hd( 50, 10)
    hf( 51, 20)=id( 79, 10)+rz*hd( 51, 10)
    hf( 52, 20)=id( 80, 10)+rz*hd( 52, 10)
    hf( 53, 20)=id( 81, 10)+rz*hd( 53, 10)
    hf( 54, 20)=id( 82, 10)+rz*hd( 54, 10)
    hf( 55, 20)=id( 83, 10)+rz*hd( 55, 10)
    hf( 56, 20)=id( 84, 10)+rz*hd( 56, 10)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_if( )
    if( 57, 11)=jd( 85,  5)+rx*id( 57,  5)
    if( 58, 11)=jd( 86,  5)+rx*id( 58,  5)
    if( 59, 11)=jd( 87,  5)+rx*id( 59,  5)
    if( 60, 11)=jd( 88,  5)+rx*id( 60,  5)
    if( 61, 11)=jd( 89,  5)+rx*id( 61,  5)
    if( 62, 11)=jd( 90,  5)+rx*id( 62,  5)
    if( 63, 11)=jd( 91,  5)+rx*id( 63,  5)
    if( 64, 11)=jd( 92,  5)+rx*id( 64,  5)
    if( 65, 11)=jd( 93,  5)+rx*id( 65,  5)
    if( 66, 11)=jd( 94,  5)+rx*id( 66,  5)
    if( 67, 11)=jd( 95,  5)+rx*id( 67,  5)
    if( 68, 11)=jd( 96,  5)+rx*id( 68,  5)
    if( 69, 11)=jd( 97,  5)+rx*id( 69,  5)
    if( 70, 11)=jd( 98,  5)+rx*id( 70,  5)
    if( 71, 11)=jd( 99,  5)+rx*id( 71,  5)
    if( 72, 11)=jd(100,  5)+rx*id( 72,  5)
    if( 73, 11)=jd(101,  5)+rx*id( 73,  5)
    if( 74, 11)=jd(102,  5)+rx*id( 74,  5)
    if( 75, 11)=jd(103,  5)+rx*id( 75,  5)
    if( 76, 11)=jd(104,  5)+rx*id( 76,  5)
    if( 77, 11)=jd(105,  5)+rx*id( 77,  5)
    if( 78, 11)=jd(106,  5)+rx*id( 78,  5)
    if( 79, 11)=jd(107,  5)+rx*id( 79,  5)
    if( 80, 11)=jd(108,  5)+rx*id( 80,  5)
    if( 81, 11)=jd(109,  5)+rx*id( 81,  5)
    if( 82, 11)=jd(110,  5)+rx*id( 82,  5)
    if( 83, 11)=jd(111,  5)+rx*id( 83,  5)
    if( 84, 11)=jd(112,  5)+rx*id( 84,  5)
    if( 57, 12)=jd( 85,  6)+rx*id( 57,  6)
    if( 58, 12)=jd( 86,  6)+rx*id( 58,  6)
    if( 59, 12)=jd( 87,  6)+rx*id( 59,  6)
    if( 60, 12)=jd( 88,  6)+rx*id( 60,  6)
    if( 61, 12)=jd( 89,  6)+rx*id( 61,  6)
    if( 62, 12)=jd( 90,  6)+rx*id( 62,  6)
    if( 63, 12)=jd( 91,  6)+rx*id( 63,  6)
    if( 64, 12)=jd( 92,  6)+rx*id( 64,  6)
    if( 65, 12)=jd( 93,  6)+rx*id( 65,  6)
    if( 66, 12)=jd( 94,  6)+rx*id( 66,  6)
    if( 67, 12)=jd( 95,  6)+rx*id( 67,  6)
    if( 68, 12)=jd( 96,  6)+rx*id( 68,  6)
    if( 69, 12)=jd( 97,  6)+rx*id( 69,  6)
    if( 70, 12)=jd( 98,  6)+rx*id( 70,  6)
    if( 71, 12)=jd( 99,  6)+rx*id( 71,  6)
    if( 72, 12)=jd(100,  6)+rx*id( 72,  6)
    if( 73, 12)=jd(101,  6)+rx*id( 73,  6)
    if( 74, 12)=jd(102,  6)+rx*id( 74,  6)
    if( 75, 12)=jd(103,  6)+rx*id( 75,  6)
    if( 76, 12)=jd(104,  6)+rx*id( 76,  6)
    if( 77, 12)=jd(105,  6)+rx*id( 77,  6)
    if( 78, 12)=jd(106,  6)+rx*id( 78,  6)
    if( 79, 12)=jd(107,  6)+rx*id( 79,  6)
    if( 80, 12)=jd(108,  6)+rx*id( 80,  6)
    if( 81, 12)=jd(109,  6)+rx*id( 81,  6)
    if( 82, 12)=jd(110,  6)+rx*id( 82,  6)
    if( 83, 12)=jd(111,  6)+rx*id( 83,  6)
    if( 84, 12)=jd(112,  6)+rx*id( 84,  6)
    if( 57, 13)=jd( 85,  7)+rx*id( 57,  7)
    if( 58, 13)=jd( 86,  7)+rx*id( 58,  7)
    if( 59, 13)=jd( 87,  7)+rx*id( 59,  7)
    if( 60, 13)=jd( 88,  7)+rx*id( 60,  7)
    if( 61, 13)=jd( 89,  7)+rx*id( 61,  7)
    if( 62, 13)=jd( 90,  7)+rx*id( 62,  7)
    if( 63, 13)=jd( 91,  7)+rx*id( 63,  7)
    if( 64, 13)=jd( 92,  7)+rx*id( 64,  7)
    if( 65, 13)=jd( 93,  7)+rx*id( 65,  7)
    if( 66, 13)=jd( 94,  7)+rx*id( 66,  7)
    if( 67, 13)=jd( 95,  7)+rx*id( 67,  7)
    if( 68, 13)=jd( 96,  7)+rx*id( 68,  7)
    if( 69, 13)=jd( 97,  7)+rx*id( 69,  7)
    if( 70, 13)=jd( 98,  7)+rx*id( 70,  7)
    if( 71, 13)=jd( 99,  7)+rx*id( 71,  7)
    if( 72, 13)=jd(100,  7)+rx*id( 72,  7)
    if( 73, 13)=jd(101,  7)+rx*id( 73,  7)
    if( 74, 13)=jd(102,  7)+rx*id( 74,  7)
    if( 75, 13)=jd(103,  7)+rx*id( 75,  7)
    if( 76, 13)=jd(104,  7)+rx*id( 76,  7)
    if( 77, 13)=jd(105,  7)+rx*id( 77,  7)
    if( 78, 13)=jd(106,  7)+rx*id( 78,  7)
    if( 79, 13)=jd(107,  7)+rx*id( 79,  7)
    if( 80, 13)=jd(108,  7)+rx*id( 80,  7)
    if( 81, 13)=jd(109,  7)+rx*id( 81,  7)
    if( 82, 13)=jd(110,  7)+rx*id( 82,  7)
    if( 83, 13)=jd(111,  7)+rx*id( 83,  7)
    if( 84, 13)=jd(112,  7)+rx*id( 84,  7)
    if( 57, 14)=jd( 85,  8)+rx*id( 57,  8)
    if( 58, 14)=jd( 86,  8)+rx*id( 58,  8)
    if( 59, 14)=jd( 87,  8)+rx*id( 59,  8)
    if( 60, 14)=jd( 88,  8)+rx*id( 60,  8)
    if( 61, 14)=jd( 89,  8)+rx*id( 61,  8)
    if( 62, 14)=jd( 90,  8)+rx*id( 62,  8)
    if( 63, 14)=jd( 91,  8)+rx*id( 63,  8)
    if( 64, 14)=jd( 92,  8)+rx*id( 64,  8)
    if( 65, 14)=jd( 93,  8)+rx*id( 65,  8)
    if( 66, 14)=jd( 94,  8)+rx*id( 66,  8)
    if( 67, 14)=jd( 95,  8)+rx*id( 67,  8)
    if( 68, 14)=jd( 96,  8)+rx*id( 68,  8)
    if( 69, 14)=jd( 97,  8)+rx*id( 69,  8)
    if( 70, 14)=jd( 98,  8)+rx*id( 70,  8)
    if( 71, 14)=jd( 99,  8)+rx*id( 71,  8)
    if( 72, 14)=jd(100,  8)+rx*id( 72,  8)
    if( 73, 14)=jd(101,  8)+rx*id( 73,  8)
    if( 74, 14)=jd(102,  8)+rx*id( 74,  8)
    if( 75, 14)=jd(103,  8)+rx*id( 75,  8)
    if( 76, 14)=jd(104,  8)+rx*id( 76,  8)
    if( 77, 14)=jd(105,  8)+rx*id( 77,  8)
    if( 78, 14)=jd(106,  8)+rx*id( 78,  8)
    if( 79, 14)=jd(107,  8)+rx*id( 79,  8)
    if( 80, 14)=jd(108,  8)+rx*id( 80,  8)
    if( 81, 14)=jd(109,  8)+rx*id( 81,  8)
    if( 82, 14)=jd(110,  8)+rx*id( 82,  8)
    if( 83, 14)=jd(111,  8)+rx*id( 83,  8)
    if( 84, 14)=jd(112,  8)+rx*id( 84,  8)
    if( 57, 15)=jd( 85,  9)+rx*id( 57,  9)
    if( 58, 15)=jd( 86,  9)+rx*id( 58,  9)
    if( 59, 15)=jd( 87,  9)+rx*id( 59,  9)
    if( 60, 15)=jd( 88,  9)+rx*id( 60,  9)
    if( 61, 15)=jd( 89,  9)+rx*id( 61,  9)
    if( 62, 15)=jd( 90,  9)+rx*id( 62,  9)
    if( 63, 15)=jd( 91,  9)+rx*id( 63,  9)
    if( 64, 15)=jd( 92,  9)+rx*id( 64,  9)
    if( 65, 15)=jd( 93,  9)+rx*id( 65,  9)
    if( 66, 15)=jd( 94,  9)+rx*id( 66,  9)
    if( 67, 15)=jd( 95,  9)+rx*id( 67,  9)
    if( 68, 15)=jd( 96,  9)+rx*id( 68,  9)
    if( 69, 15)=jd( 97,  9)+rx*id( 69,  9)
    if( 70, 15)=jd( 98,  9)+rx*id( 70,  9)
    if( 71, 15)=jd( 99,  9)+rx*id( 71,  9)
    if( 72, 15)=jd(100,  9)+rx*id( 72,  9)
    if( 73, 15)=jd(101,  9)+rx*id( 73,  9)
    if( 74, 15)=jd(102,  9)+rx*id( 74,  9)
    if( 75, 15)=jd(103,  9)+rx*id( 75,  9)
    if( 76, 15)=jd(104,  9)+rx*id( 76,  9)
    if( 77, 15)=jd(105,  9)+rx*id( 77,  9)
    if( 78, 15)=jd(106,  9)+rx*id( 78,  9)
    if( 79, 15)=jd(107,  9)+rx*id( 79,  9)
    if( 80, 15)=jd(108,  9)+rx*id( 80,  9)
    if( 81, 15)=jd(109,  9)+rx*id( 81,  9)
    if( 82, 15)=jd(110,  9)+rx*id( 82,  9)
    if( 83, 15)=jd(111,  9)+rx*id( 83,  9)
    if( 84, 15)=jd(112,  9)+rx*id( 84,  9)
    if( 57, 16)=jd( 85, 10)+rx*id( 57, 10)
    if( 58, 16)=jd( 86, 10)+rx*id( 58, 10)
    if( 59, 16)=jd( 87, 10)+rx*id( 59, 10)
    if( 60, 16)=jd( 88, 10)+rx*id( 60, 10)
    if( 61, 16)=jd( 89, 10)+rx*id( 61, 10)
    if( 62, 16)=jd( 90, 10)+rx*id( 62, 10)
    if( 63, 16)=jd( 91, 10)+rx*id( 63, 10)
    if( 64, 16)=jd( 92, 10)+rx*id( 64, 10)
    if( 65, 16)=jd( 93, 10)+rx*id( 65, 10)
    if( 66, 16)=jd( 94, 10)+rx*id( 66, 10)
    if( 67, 16)=jd( 95, 10)+rx*id( 67, 10)
    if( 68, 16)=jd( 96, 10)+rx*id( 68, 10)
    if( 69, 16)=jd( 97, 10)+rx*id( 69, 10)
    if( 70, 16)=jd( 98, 10)+rx*id( 70, 10)
    if( 71, 16)=jd( 99, 10)+rx*id( 71, 10)
    if( 72, 16)=jd(100, 10)+rx*id( 72, 10)
    if( 73, 16)=jd(101, 10)+rx*id( 73, 10)
    if( 74, 16)=jd(102, 10)+rx*id( 74, 10)
    if( 75, 16)=jd(103, 10)+rx*id( 75, 10)
    if( 76, 16)=jd(104, 10)+rx*id( 76, 10)
    if( 77, 16)=jd(105, 10)+rx*id( 77, 10)
    if( 78, 16)=jd(106, 10)+rx*id( 78, 10)
    if( 79, 16)=jd(107, 10)+rx*id( 79, 10)
    if( 80, 16)=jd(108, 10)+rx*id( 80, 10)
    if( 81, 16)=jd(109, 10)+rx*id( 81, 10)
    if( 82, 16)=jd(110, 10)+rx*id( 82, 10)
    if( 83, 16)=jd(111, 10)+rx*id( 83, 10)
    if( 84, 16)=jd(112, 10)+rx*id( 84, 10)
    if( 57, 17)=jd( 86,  8)+ry*id( 57,  8)
    if( 58, 17)=jd( 88,  8)+ry*id( 58,  8)
    if( 59, 17)=jd( 89,  8)+ry*id( 59,  8)
    if( 60, 17)=jd( 91,  8)+ry*id( 60,  8)
    if( 61, 17)=jd( 92,  8)+ry*id( 61,  8)
    if( 62, 17)=jd( 93,  8)+ry*id( 62,  8)
    if( 63, 17)=jd( 95,  8)+ry*id( 63,  8)
    if( 64, 17)=jd( 96,  8)+ry*id( 64,  8)
    if( 65, 17)=jd( 97,  8)+ry*id( 65,  8)
    if( 66, 17)=jd( 98,  8)+ry*id( 66,  8)
    if( 67, 17)=jd(100,  8)+ry*id( 67,  8)
    if( 68, 17)=jd(101,  8)+ry*id( 68,  8)
    if( 69, 17)=jd(102,  8)+ry*id( 69,  8)
    if( 70, 17)=jd(103,  8)+ry*id( 70,  8)
    if( 71, 17)=jd(104,  8)+ry*id( 71,  8)
    if( 72, 17)=jd(106,  8)+ry*id( 72,  8)
    if( 73, 17)=jd(107,  8)+ry*id( 73,  8)
    if( 74, 17)=jd(108,  8)+ry*id( 74,  8)
    if( 75, 17)=jd(109,  8)+ry*id( 75,  8)
    if( 76, 17)=jd(110,  8)+ry*id( 76,  8)
    if( 77, 17)=jd(111,  8)+ry*id( 77,  8)
    if( 78, 17)=jd(113,  8)+ry*id( 78,  8)
    if( 79, 17)=jd(114,  8)+ry*id( 79,  8)
    if( 80, 17)=jd(115,  8)+ry*id( 80,  8)
    if( 81, 17)=jd(116,  8)+ry*id( 81,  8)
    if( 82, 17)=jd(117,  8)+ry*id( 82,  8)
    if( 83, 17)=jd(118,  8)+ry*id( 83,  8)
    if( 84, 17)=jd(119,  8)+ry*id( 84,  8)
    if( 57, 18)=jd( 86,  9)+ry*id( 57,  9)
    if( 58, 18)=jd( 88,  9)+ry*id( 58,  9)
    if( 59, 18)=jd( 89,  9)+ry*id( 59,  9)
    if( 60, 18)=jd( 91,  9)+ry*id( 60,  9)
    if( 61, 18)=jd( 92,  9)+ry*id( 61,  9)
    if( 62, 18)=jd( 93,  9)+ry*id( 62,  9)
    if( 63, 18)=jd( 95,  9)+ry*id( 63,  9)
    if( 64, 18)=jd( 96,  9)+ry*id( 64,  9)
    if( 65, 18)=jd( 97,  9)+ry*id( 65,  9)
    if( 66, 18)=jd( 98,  9)+ry*id( 66,  9)
    if( 67, 18)=jd(100,  9)+ry*id( 67,  9)
    if( 68, 18)=jd(101,  9)+ry*id( 68,  9)
    if( 69, 18)=jd(102,  9)+ry*id( 69,  9)
    if( 70, 18)=jd(103,  9)+ry*id( 70,  9)
    if( 71, 18)=jd(104,  9)+ry*id( 71,  9)
    if( 72, 18)=jd(106,  9)+ry*id( 72,  9)
    if( 73, 18)=jd(107,  9)+ry*id( 73,  9)
    if( 74, 18)=jd(108,  9)+ry*id( 74,  9)
    if( 75, 18)=jd(109,  9)+ry*id( 75,  9)
    if( 76, 18)=jd(110,  9)+ry*id( 76,  9)
    if( 77, 18)=jd(111,  9)+ry*id( 77,  9)
    if( 78, 18)=jd(113,  9)+ry*id( 78,  9)
    if( 79, 18)=jd(114,  9)+ry*id( 79,  9)
    if( 80, 18)=jd(115,  9)+ry*id( 80,  9)
    if( 81, 18)=jd(116,  9)+ry*id( 81,  9)
    if( 82, 18)=jd(117,  9)+ry*id( 82,  9)
    if( 83, 18)=jd(118,  9)+ry*id( 83,  9)
    if( 84, 18)=jd(119,  9)+ry*id( 84,  9)
    if( 57, 19)=jd( 86, 10)+ry*id( 57, 10)
    if( 58, 19)=jd( 88, 10)+ry*id( 58, 10)
    if( 59, 19)=jd( 89, 10)+ry*id( 59, 10)
    if( 60, 19)=jd( 91, 10)+ry*id( 60, 10)
    if( 61, 19)=jd( 92, 10)+ry*id( 61, 10)
    if( 62, 19)=jd( 93, 10)+ry*id( 62, 10)
    if( 63, 19)=jd( 95, 10)+ry*id( 63, 10)
    if( 64, 19)=jd( 96, 10)+ry*id( 64, 10)
    if( 65, 19)=jd( 97, 10)+ry*id( 65, 10)
    if( 66, 19)=jd( 98, 10)+ry*id( 66, 10)
    if( 67, 19)=jd(100, 10)+ry*id( 67, 10)
    if( 68, 19)=jd(101, 10)+ry*id( 68, 10)
    if( 69, 19)=jd(102, 10)+ry*id( 69, 10)
    if( 70, 19)=jd(103, 10)+ry*id( 70, 10)
    if( 71, 19)=jd(104, 10)+ry*id( 71, 10)
    if( 72, 19)=jd(106, 10)+ry*id( 72, 10)
    if( 73, 19)=jd(107, 10)+ry*id( 73, 10)
    if( 74, 19)=jd(108, 10)+ry*id( 74, 10)
    if( 75, 19)=jd(109, 10)+ry*id( 75, 10)
    if( 76, 19)=jd(110, 10)+ry*id( 76, 10)
    if( 77, 19)=jd(111, 10)+ry*id( 77, 10)
    if( 78, 19)=jd(113, 10)+ry*id( 78, 10)
    if( 79, 19)=jd(114, 10)+ry*id( 79, 10)
    if( 80, 19)=jd(115, 10)+ry*id( 80, 10)
    if( 81, 19)=jd(116, 10)+ry*id( 81, 10)
    if( 82, 19)=jd(117, 10)+ry*id( 82, 10)
    if( 83, 19)=jd(118, 10)+ry*id( 83, 10)
    if( 84, 19)=jd(119, 10)+ry*id( 84, 10)
    if( 57, 20)=jd( 87, 10)+rz*id( 57, 10)
    if( 58, 20)=jd( 89, 10)+rz*id( 58, 10)
    if( 59, 20)=jd( 90, 10)+rz*id( 59, 10)
    if( 60, 20)=jd( 92, 10)+rz*id( 60, 10)
    if( 61, 20)=jd( 93, 10)+rz*id( 61, 10)
    if( 62, 20)=jd( 94, 10)+rz*id( 62, 10)
    if( 63, 20)=jd( 96, 10)+rz*id( 63, 10)
    if( 64, 20)=jd( 97, 10)+rz*id( 64, 10)
    if( 65, 20)=jd( 98, 10)+rz*id( 65, 10)
    if( 66, 20)=jd( 99, 10)+rz*id( 66, 10)
    if( 67, 20)=jd(101, 10)+rz*id( 67, 10)
    if( 68, 20)=jd(102, 10)+rz*id( 68, 10)
    if( 69, 20)=jd(103, 10)+rz*id( 69, 10)
    if( 70, 20)=jd(104, 10)+rz*id( 70, 10)
    if( 71, 20)=jd(105, 10)+rz*id( 71, 10)
    if( 72, 20)=jd(107, 10)+rz*id( 72, 10)
    if( 73, 20)=jd(108, 10)+rz*id( 73, 10)
    if( 74, 20)=jd(109, 10)+rz*id( 74, 10)
    if( 75, 20)=jd(110, 10)+rz*id( 75, 10)
    if( 76, 20)=jd(111, 10)+rz*id( 76, 10)
    if( 77, 20)=jd(112, 10)+rz*id( 77, 10)
    if( 78, 20)=jd(114, 10)+rz*id( 78, 10)
    if( 79, 20)=jd(115, 10)+rz*id( 79, 10)
    if( 80, 20)=jd(116, 10)+rz*id( 80, 10)
    if( 81, 20)=jd(117, 10)+rz*id( 81, 10)
    if( 82, 20)=jd(118, 10)+rz*id( 82, 10)
    if( 83, 20)=jd(119, 10)+rz*id( 83, 10)
    if( 84, 20)=jd(120, 10)+rz*id( 84, 10)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_jf( )
    jf( 85, 11)=kd(121,  5)+rx*jd( 85,  5)
    jf( 86, 11)=kd(122,  5)+rx*jd( 86,  5)
    jf( 87, 11)=kd(123,  5)+rx*jd( 87,  5)
    jf( 88, 11)=kd(124,  5)+rx*jd( 88,  5)
    jf( 89, 11)=kd(125,  5)+rx*jd( 89,  5)
    jf( 90, 11)=kd(126,  5)+rx*jd( 90,  5)
    jf( 91, 11)=kd(127,  5)+rx*jd( 91,  5)
    jf( 92, 11)=kd(128,  5)+rx*jd( 92,  5)
    jf( 93, 11)=kd(129,  5)+rx*jd( 93,  5)
    jf( 94, 11)=kd(130,  5)+rx*jd( 94,  5)
    jf( 95, 11)=kd(131,  5)+rx*jd( 95,  5)
    jf( 96, 11)=kd(132,  5)+rx*jd( 96,  5)
    jf( 97, 11)=kd(133,  5)+rx*jd( 97,  5)
    jf( 98, 11)=kd(134,  5)+rx*jd( 98,  5)
    jf( 99, 11)=kd(135,  5)+rx*jd( 99,  5)
    jf(100, 11)=kd(136,  5)+rx*jd(100,  5)
    jf(101, 11)=kd(137,  5)+rx*jd(101,  5)
    jf(102, 11)=kd(138,  5)+rx*jd(102,  5)
    jf(103, 11)=kd(139,  5)+rx*jd(103,  5)
    jf(104, 11)=kd(140,  5)+rx*jd(104,  5)
    jf(105, 11)=kd(141,  5)+rx*jd(105,  5)
    jf(106, 11)=kd(142,  5)+rx*jd(106,  5)
    jf(107, 11)=kd(143,  5)+rx*jd(107,  5)
    jf(108, 11)=kd(144,  5)+rx*jd(108,  5)
    jf(109, 11)=kd(145,  5)+rx*jd(109,  5)
    jf(110, 11)=kd(146,  5)+rx*jd(110,  5)
    jf(111, 11)=kd(147,  5)+rx*jd(111,  5)
    jf(112, 11)=kd(148,  5)+rx*jd(112,  5)
    jf(113, 11)=kd(149,  5)+rx*jd(113,  5)
    jf(114, 11)=kd(150,  5)+rx*jd(114,  5)
    jf(115, 11)=kd(151,  5)+rx*jd(115,  5)
    jf(116, 11)=kd(152,  5)+rx*jd(116,  5)
    jf(117, 11)=kd(153,  5)+rx*jd(117,  5)
    jf(118, 11)=kd(154,  5)+rx*jd(118,  5)
    jf(119, 11)=kd(155,  5)+rx*jd(119,  5)
    jf(120, 11)=kd(156,  5)+rx*jd(120,  5)
    jf( 85, 12)=kd(121,  6)+rx*jd( 85,  6)
    jf( 86, 12)=kd(122,  6)+rx*jd( 86,  6)
    jf( 87, 12)=kd(123,  6)+rx*jd( 87,  6)
    jf( 88, 12)=kd(124,  6)+rx*jd( 88,  6)
    jf( 89, 12)=kd(125,  6)+rx*jd( 89,  6)
    jf( 90, 12)=kd(126,  6)+rx*jd( 90,  6)
    jf( 91, 12)=kd(127,  6)+rx*jd( 91,  6)
    jf( 92, 12)=kd(128,  6)+rx*jd( 92,  6)
    jf( 93, 12)=kd(129,  6)+rx*jd( 93,  6)
    jf( 94, 12)=kd(130,  6)+rx*jd( 94,  6)
    jf( 95, 12)=kd(131,  6)+rx*jd( 95,  6)
    jf( 96, 12)=kd(132,  6)+rx*jd( 96,  6)
    jf( 97, 12)=kd(133,  6)+rx*jd( 97,  6)
    jf( 98, 12)=kd(134,  6)+rx*jd( 98,  6)
    jf( 99, 12)=kd(135,  6)+rx*jd( 99,  6)
    jf(100, 12)=kd(136,  6)+rx*jd(100,  6)
    jf(101, 12)=kd(137,  6)+rx*jd(101,  6)
    jf(102, 12)=kd(138,  6)+rx*jd(102,  6)
    jf(103, 12)=kd(139,  6)+rx*jd(103,  6)
    jf(104, 12)=kd(140,  6)+rx*jd(104,  6)
    jf(105, 12)=kd(141,  6)+rx*jd(105,  6)
    jf(106, 12)=kd(142,  6)+rx*jd(106,  6)
    jf(107, 12)=kd(143,  6)+rx*jd(107,  6)
    jf(108, 12)=kd(144,  6)+rx*jd(108,  6)
    jf(109, 12)=kd(145,  6)+rx*jd(109,  6)
    jf(110, 12)=kd(146,  6)+rx*jd(110,  6)
    jf(111, 12)=kd(147,  6)+rx*jd(111,  6)
    jf(112, 12)=kd(148,  6)+rx*jd(112,  6)
    jf(113, 12)=kd(149,  6)+rx*jd(113,  6)
    jf(114, 12)=kd(150,  6)+rx*jd(114,  6)
    jf(115, 12)=kd(151,  6)+rx*jd(115,  6)
    jf(116, 12)=kd(152,  6)+rx*jd(116,  6)
    jf(117, 12)=kd(153,  6)+rx*jd(117,  6)
    jf(118, 12)=kd(154,  6)+rx*jd(118,  6)
    jf(119, 12)=kd(155,  6)+rx*jd(119,  6)
    jf(120, 12)=kd(156,  6)+rx*jd(120,  6)
    jf( 85, 13)=kd(121,  7)+rx*jd( 85,  7)
    jf( 86, 13)=kd(122,  7)+rx*jd( 86,  7)
    jf( 87, 13)=kd(123,  7)+rx*jd( 87,  7)
    jf( 88, 13)=kd(124,  7)+rx*jd( 88,  7)
    jf( 89, 13)=kd(125,  7)+rx*jd( 89,  7)
    jf( 90, 13)=kd(126,  7)+rx*jd( 90,  7)
    jf( 91, 13)=kd(127,  7)+rx*jd( 91,  7)
    jf( 92, 13)=kd(128,  7)+rx*jd( 92,  7)
    jf( 93, 13)=kd(129,  7)+rx*jd( 93,  7)
    jf( 94, 13)=kd(130,  7)+rx*jd( 94,  7)
    jf( 95, 13)=kd(131,  7)+rx*jd( 95,  7)
    jf( 96, 13)=kd(132,  7)+rx*jd( 96,  7)
    jf( 97, 13)=kd(133,  7)+rx*jd( 97,  7)
    jf( 98, 13)=kd(134,  7)+rx*jd( 98,  7)
    jf( 99, 13)=kd(135,  7)+rx*jd( 99,  7)
    jf(100, 13)=kd(136,  7)+rx*jd(100,  7)
    jf(101, 13)=kd(137,  7)+rx*jd(101,  7)
    jf(102, 13)=kd(138,  7)+rx*jd(102,  7)
    jf(103, 13)=kd(139,  7)+rx*jd(103,  7)
    jf(104, 13)=kd(140,  7)+rx*jd(104,  7)
    jf(105, 13)=kd(141,  7)+rx*jd(105,  7)
    jf(106, 13)=kd(142,  7)+rx*jd(106,  7)
    jf(107, 13)=kd(143,  7)+rx*jd(107,  7)
    jf(108, 13)=kd(144,  7)+rx*jd(108,  7)
    jf(109, 13)=kd(145,  7)+rx*jd(109,  7)
    jf(110, 13)=kd(146,  7)+rx*jd(110,  7)
    jf(111, 13)=kd(147,  7)+rx*jd(111,  7)
    jf(112, 13)=kd(148,  7)+rx*jd(112,  7)
    jf(113, 13)=kd(149,  7)+rx*jd(113,  7)
    jf(114, 13)=kd(150,  7)+rx*jd(114,  7)
    jf(115, 13)=kd(151,  7)+rx*jd(115,  7)
    jf(116, 13)=kd(152,  7)+rx*jd(116,  7)
    jf(117, 13)=kd(153,  7)+rx*jd(117,  7)
    jf(118, 13)=kd(154,  7)+rx*jd(118,  7)
    jf(119, 13)=kd(155,  7)+rx*jd(119,  7)
    jf(120, 13)=kd(156,  7)+rx*jd(120,  7)
    jf( 85, 14)=kd(121,  8)+rx*jd( 85,  8)
    jf( 86, 14)=kd(122,  8)+rx*jd( 86,  8)
    jf( 87, 14)=kd(123,  8)+rx*jd( 87,  8)
    jf( 88, 14)=kd(124,  8)+rx*jd( 88,  8)
    jf( 89, 14)=kd(125,  8)+rx*jd( 89,  8)
    jf( 90, 14)=kd(126,  8)+rx*jd( 90,  8)
    jf( 91, 14)=kd(127,  8)+rx*jd( 91,  8)
    jf( 92, 14)=kd(128,  8)+rx*jd( 92,  8)
    jf( 93, 14)=kd(129,  8)+rx*jd( 93,  8)
    jf( 94, 14)=kd(130,  8)+rx*jd( 94,  8)
    jf( 95, 14)=kd(131,  8)+rx*jd( 95,  8)
    jf( 96, 14)=kd(132,  8)+rx*jd( 96,  8)
    jf( 97, 14)=kd(133,  8)+rx*jd( 97,  8)
    jf( 98, 14)=kd(134,  8)+rx*jd( 98,  8)
    jf( 99, 14)=kd(135,  8)+rx*jd( 99,  8)
    jf(100, 14)=kd(136,  8)+rx*jd(100,  8)
    jf(101, 14)=kd(137,  8)+rx*jd(101,  8)
    jf(102, 14)=kd(138,  8)+rx*jd(102,  8)
    jf(103, 14)=kd(139,  8)+rx*jd(103,  8)
    jf(104, 14)=kd(140,  8)+rx*jd(104,  8)
    jf(105, 14)=kd(141,  8)+rx*jd(105,  8)
    jf(106, 14)=kd(142,  8)+rx*jd(106,  8)
    jf(107, 14)=kd(143,  8)+rx*jd(107,  8)
    jf(108, 14)=kd(144,  8)+rx*jd(108,  8)
    jf(109, 14)=kd(145,  8)+rx*jd(109,  8)
    jf(110, 14)=kd(146,  8)+rx*jd(110,  8)
    jf(111, 14)=kd(147,  8)+rx*jd(111,  8)
    jf(112, 14)=kd(148,  8)+rx*jd(112,  8)
    jf(113, 14)=kd(149,  8)+rx*jd(113,  8)
    jf(114, 14)=kd(150,  8)+rx*jd(114,  8)
    jf(115, 14)=kd(151,  8)+rx*jd(115,  8)
    jf(116, 14)=kd(152,  8)+rx*jd(116,  8)
    jf(117, 14)=kd(153,  8)+rx*jd(117,  8)
    jf(118, 14)=kd(154,  8)+rx*jd(118,  8)
    jf(119, 14)=kd(155,  8)+rx*jd(119,  8)
    jf(120, 14)=kd(156,  8)+rx*jd(120,  8)
    jf( 85, 15)=kd(121,  9)+rx*jd( 85,  9)
    jf( 86, 15)=kd(122,  9)+rx*jd( 86,  9)
    jf( 87, 15)=kd(123,  9)+rx*jd( 87,  9)
    jf( 88, 15)=kd(124,  9)+rx*jd( 88,  9)
    jf( 89, 15)=kd(125,  9)+rx*jd( 89,  9)
    jf( 90, 15)=kd(126,  9)+rx*jd( 90,  9)
    jf( 91, 15)=kd(127,  9)+rx*jd( 91,  9)
    jf( 92, 15)=kd(128,  9)+rx*jd( 92,  9)
    jf( 93, 15)=kd(129,  9)+rx*jd( 93,  9)
    jf( 94, 15)=kd(130,  9)+rx*jd( 94,  9)
    jf( 95, 15)=kd(131,  9)+rx*jd( 95,  9)
    jf( 96, 15)=kd(132,  9)+rx*jd( 96,  9)
    jf( 97, 15)=kd(133,  9)+rx*jd( 97,  9)
    jf( 98, 15)=kd(134,  9)+rx*jd( 98,  9)
    jf( 99, 15)=kd(135,  9)+rx*jd( 99,  9)
    jf(100, 15)=kd(136,  9)+rx*jd(100,  9)
    jf(101, 15)=kd(137,  9)+rx*jd(101,  9)
    jf(102, 15)=kd(138,  9)+rx*jd(102,  9)
    jf(103, 15)=kd(139,  9)+rx*jd(103,  9)
    jf(104, 15)=kd(140,  9)+rx*jd(104,  9)
    jf(105, 15)=kd(141,  9)+rx*jd(105,  9)
    jf(106, 15)=kd(142,  9)+rx*jd(106,  9)
    jf(107, 15)=kd(143,  9)+rx*jd(107,  9)
    jf(108, 15)=kd(144,  9)+rx*jd(108,  9)
    jf(109, 15)=kd(145,  9)+rx*jd(109,  9)
    jf(110, 15)=kd(146,  9)+rx*jd(110,  9)
    jf(111, 15)=kd(147,  9)+rx*jd(111,  9)
    jf(112, 15)=kd(148,  9)+rx*jd(112,  9)
    jf(113, 15)=kd(149,  9)+rx*jd(113,  9)
    jf(114, 15)=kd(150,  9)+rx*jd(114,  9)
    jf(115, 15)=kd(151,  9)+rx*jd(115,  9)
    jf(116, 15)=kd(152,  9)+rx*jd(116,  9)
    jf(117, 15)=kd(153,  9)+rx*jd(117,  9)
    jf(118, 15)=kd(154,  9)+rx*jd(118,  9)
    jf(119, 15)=kd(155,  9)+rx*jd(119,  9)
    jf(120, 15)=kd(156,  9)+rx*jd(120,  9)
    jf( 85, 16)=kd(121, 10)+rx*jd( 85, 10)
    jf( 86, 16)=kd(122, 10)+rx*jd( 86, 10)
    jf( 87, 16)=kd(123, 10)+rx*jd( 87, 10)
    jf( 88, 16)=kd(124, 10)+rx*jd( 88, 10)
    jf( 89, 16)=kd(125, 10)+rx*jd( 89, 10)
    jf( 90, 16)=kd(126, 10)+rx*jd( 90, 10)
    jf( 91, 16)=kd(127, 10)+rx*jd( 91, 10)
    jf( 92, 16)=kd(128, 10)+rx*jd( 92, 10)
    jf( 93, 16)=kd(129, 10)+rx*jd( 93, 10)
    jf( 94, 16)=kd(130, 10)+rx*jd( 94, 10)
    jf( 95, 16)=kd(131, 10)+rx*jd( 95, 10)
    jf( 96, 16)=kd(132, 10)+rx*jd( 96, 10)
    jf( 97, 16)=kd(133, 10)+rx*jd( 97, 10)
    jf( 98, 16)=kd(134, 10)+rx*jd( 98, 10)
    jf( 99, 16)=kd(135, 10)+rx*jd( 99, 10)
    jf(100, 16)=kd(136, 10)+rx*jd(100, 10)
    jf(101, 16)=kd(137, 10)+rx*jd(101, 10)
    jf(102, 16)=kd(138, 10)+rx*jd(102, 10)
    jf(103, 16)=kd(139, 10)+rx*jd(103, 10)
    jf(104, 16)=kd(140, 10)+rx*jd(104, 10)
    jf(105, 16)=kd(141, 10)+rx*jd(105, 10)
    jf(106, 16)=kd(142, 10)+rx*jd(106, 10)
    jf(107, 16)=kd(143, 10)+rx*jd(107, 10)
    jf(108, 16)=kd(144, 10)+rx*jd(108, 10)
    jf(109, 16)=kd(145, 10)+rx*jd(109, 10)
    jf(110, 16)=kd(146, 10)+rx*jd(110, 10)
    jf(111, 16)=kd(147, 10)+rx*jd(111, 10)
    jf(112, 16)=kd(148, 10)+rx*jd(112, 10)
    jf(113, 16)=kd(149, 10)+rx*jd(113, 10)
    jf(114, 16)=kd(150, 10)+rx*jd(114, 10)
    jf(115, 16)=kd(151, 10)+rx*jd(115, 10)
    jf(116, 16)=kd(152, 10)+rx*jd(116, 10)
    jf(117, 16)=kd(153, 10)+rx*jd(117, 10)
    jf(118, 16)=kd(154, 10)+rx*jd(118, 10)
    jf(119, 16)=kd(155, 10)+rx*jd(119, 10)
    jf(120, 16)=kd(156, 10)+rx*jd(120, 10)
    jf( 85, 17)=kd(122,  8)+ry*jd( 85,  8)
    jf( 86, 17)=kd(124,  8)+ry*jd( 86,  8)
    jf( 87, 17)=kd(125,  8)+ry*jd( 87,  8)
    jf( 88, 17)=kd(127,  8)+ry*jd( 88,  8)
    jf( 89, 17)=kd(128,  8)+ry*jd( 89,  8)
    jf( 90, 17)=kd(129,  8)+ry*jd( 90,  8)
    jf( 91, 17)=kd(131,  8)+ry*jd( 91,  8)
    jf( 92, 17)=kd(132,  8)+ry*jd( 92,  8)
    jf( 93, 17)=kd(133,  8)+ry*jd( 93,  8)
    jf( 94, 17)=kd(134,  8)+ry*jd( 94,  8)
    jf( 95, 17)=kd(136,  8)+ry*jd( 95,  8)
    jf( 96, 17)=kd(137,  8)+ry*jd( 96,  8)
    jf( 97, 17)=kd(138,  8)+ry*jd( 97,  8)
    jf( 98, 17)=kd(139,  8)+ry*jd( 98,  8)
    jf( 99, 17)=kd(140,  8)+ry*jd( 99,  8)
    jf(100, 17)=kd(142,  8)+ry*jd(100,  8)
    jf(101, 17)=kd(143,  8)+ry*jd(101,  8)
    jf(102, 17)=kd(144,  8)+ry*jd(102,  8)
    jf(103, 17)=kd(145,  8)+ry*jd(103,  8)
    jf(104, 17)=kd(146,  8)+ry*jd(104,  8)
    jf(105, 17)=kd(147,  8)+ry*jd(105,  8)
    jf(106, 17)=kd(149,  8)+ry*jd(106,  8)
    jf(107, 17)=kd(150,  8)+ry*jd(107,  8)
    jf(108, 17)=kd(151,  8)+ry*jd(108,  8)
    jf(109, 17)=kd(152,  8)+ry*jd(109,  8)
    jf(110, 17)=kd(153,  8)+ry*jd(110,  8)
    jf(111, 17)=kd(154,  8)+ry*jd(111,  8)
    jf(112, 17)=kd(155,  8)+ry*jd(112,  8)
    jf(113, 17)=kd(157,  8)+ry*jd(113,  8)
    jf(114, 17)=kd(158,  8)+ry*jd(114,  8)
    jf(115, 17)=kd(159,  8)+ry*jd(115,  8)
    jf(116, 17)=kd(160,  8)+ry*jd(116,  8)
    jf(117, 17)=kd(161,  8)+ry*jd(117,  8)
    jf(118, 17)=kd(162,  8)+ry*jd(118,  8)
    jf(119, 17)=kd(163,  8)+ry*jd(119,  8)
    jf(120, 17)=kd(164,  8)+ry*jd(120,  8)
    jf( 85, 18)=kd(122,  9)+ry*jd( 85,  9)
    jf( 86, 18)=kd(124,  9)+ry*jd( 86,  9)
    jf( 87, 18)=kd(125,  9)+ry*jd( 87,  9)
    jf( 88, 18)=kd(127,  9)+ry*jd( 88,  9)
    jf( 89, 18)=kd(128,  9)+ry*jd( 89,  9)
    jf( 90, 18)=kd(129,  9)+ry*jd( 90,  9)
    jf( 91, 18)=kd(131,  9)+ry*jd( 91,  9)
    jf( 92, 18)=kd(132,  9)+ry*jd( 92,  9)
    jf( 93, 18)=kd(133,  9)+ry*jd( 93,  9)
    jf( 94, 18)=kd(134,  9)+ry*jd( 94,  9)
    jf( 95, 18)=kd(136,  9)+ry*jd( 95,  9)
    jf( 96, 18)=kd(137,  9)+ry*jd( 96,  9)
    jf( 97, 18)=kd(138,  9)+ry*jd( 97,  9)
    jf( 98, 18)=kd(139,  9)+ry*jd( 98,  9)
    jf( 99, 18)=kd(140,  9)+ry*jd( 99,  9)
    jf(100, 18)=kd(142,  9)+ry*jd(100,  9)
    jf(101, 18)=kd(143,  9)+ry*jd(101,  9)
    jf(102, 18)=kd(144,  9)+ry*jd(102,  9)
    jf(103, 18)=kd(145,  9)+ry*jd(103,  9)
    jf(104, 18)=kd(146,  9)+ry*jd(104,  9)
    jf(105, 18)=kd(147,  9)+ry*jd(105,  9)
    jf(106, 18)=kd(149,  9)+ry*jd(106,  9)
    jf(107, 18)=kd(150,  9)+ry*jd(107,  9)
    jf(108, 18)=kd(151,  9)+ry*jd(108,  9)
    jf(109, 18)=kd(152,  9)+ry*jd(109,  9)
    jf(110, 18)=kd(153,  9)+ry*jd(110,  9)
    jf(111, 18)=kd(154,  9)+ry*jd(111,  9)
    jf(112, 18)=kd(155,  9)+ry*jd(112,  9)
    jf(113, 18)=kd(157,  9)+ry*jd(113,  9)
    jf(114, 18)=kd(158,  9)+ry*jd(114,  9)
    jf(115, 18)=kd(159,  9)+ry*jd(115,  9)
    jf(116, 18)=kd(160,  9)+ry*jd(116,  9)
    jf(117, 18)=kd(161,  9)+ry*jd(117,  9)
    jf(118, 18)=kd(162,  9)+ry*jd(118,  9)
    jf(119, 18)=kd(163,  9)+ry*jd(119,  9)
    jf(120, 18)=kd(164,  9)+ry*jd(120,  9)
    jf( 85, 19)=kd(122, 10)+ry*jd( 85, 10)
    jf( 86, 19)=kd(124, 10)+ry*jd( 86, 10)
    jf( 87, 19)=kd(125, 10)+ry*jd( 87, 10)
    jf( 88, 19)=kd(127, 10)+ry*jd( 88, 10)
    jf( 89, 19)=kd(128, 10)+ry*jd( 89, 10)
    jf( 90, 19)=kd(129, 10)+ry*jd( 90, 10)
    jf( 91, 19)=kd(131, 10)+ry*jd( 91, 10)
    jf( 92, 19)=kd(132, 10)+ry*jd( 92, 10)
    jf( 93, 19)=kd(133, 10)+ry*jd( 93, 10)
    jf( 94, 19)=kd(134, 10)+ry*jd( 94, 10)
    jf( 95, 19)=kd(136, 10)+ry*jd( 95, 10)
    jf( 96, 19)=kd(137, 10)+ry*jd( 96, 10)
    jf( 97, 19)=kd(138, 10)+ry*jd( 97, 10)
    jf( 98, 19)=kd(139, 10)+ry*jd( 98, 10)
    jf( 99, 19)=kd(140, 10)+ry*jd( 99, 10)
    jf(100, 19)=kd(142, 10)+ry*jd(100, 10)
    jf(101, 19)=kd(143, 10)+ry*jd(101, 10)
    jf(102, 19)=kd(144, 10)+ry*jd(102, 10)
    jf(103, 19)=kd(145, 10)+ry*jd(103, 10)
    jf(104, 19)=kd(146, 10)+ry*jd(104, 10)
    jf(105, 19)=kd(147, 10)+ry*jd(105, 10)
    jf(106, 19)=kd(149, 10)+ry*jd(106, 10)
    jf(107, 19)=kd(150, 10)+ry*jd(107, 10)
    jf(108, 19)=kd(151, 10)+ry*jd(108, 10)
    jf(109, 19)=kd(152, 10)+ry*jd(109, 10)
    jf(110, 19)=kd(153, 10)+ry*jd(110, 10)
    jf(111, 19)=kd(154, 10)+ry*jd(111, 10)
    jf(112, 19)=kd(155, 10)+ry*jd(112, 10)
    jf(113, 19)=kd(157, 10)+ry*jd(113, 10)
    jf(114, 19)=kd(158, 10)+ry*jd(114, 10)
    jf(115, 19)=kd(159, 10)+ry*jd(115, 10)
    jf(116, 19)=kd(160, 10)+ry*jd(116, 10)
    jf(117, 19)=kd(161, 10)+ry*jd(117, 10)
    jf(118, 19)=kd(162, 10)+ry*jd(118, 10)
    jf(119, 19)=kd(163, 10)+ry*jd(119, 10)
    jf(120, 19)=kd(164, 10)+ry*jd(120, 10)
    jf( 85, 20)=kd(123, 10)+rz*jd( 85, 10)
    jf( 86, 20)=kd(125, 10)+rz*jd( 86, 10)
    jf( 87, 20)=kd(126, 10)+rz*jd( 87, 10)
    jf( 88, 20)=kd(128, 10)+rz*jd( 88, 10)
    jf( 89, 20)=kd(129, 10)+rz*jd( 89, 10)
    jf( 90, 20)=kd(130, 10)+rz*jd( 90, 10)
    jf( 91, 20)=kd(132, 10)+rz*jd( 91, 10)
    jf( 92, 20)=kd(133, 10)+rz*jd( 92, 10)
    jf( 93, 20)=kd(134, 10)+rz*jd( 93, 10)
    jf( 94, 20)=kd(135, 10)+rz*jd( 94, 10)
    jf( 95, 20)=kd(137, 10)+rz*jd( 95, 10)
    jf( 96, 20)=kd(138, 10)+rz*jd( 96, 10)
    jf( 97, 20)=kd(139, 10)+rz*jd( 97, 10)
    jf( 98, 20)=kd(140, 10)+rz*jd( 98, 10)
    jf( 99, 20)=kd(141, 10)+rz*jd( 99, 10)
    jf(100, 20)=kd(143, 10)+rz*jd(100, 10)
    jf(101, 20)=kd(144, 10)+rz*jd(101, 10)
    jf(102, 20)=kd(145, 10)+rz*jd(102, 10)
    jf(103, 20)=kd(146, 10)+rz*jd(103, 10)
    jf(104, 20)=kd(147, 10)+rz*jd(104, 10)
    jf(105, 20)=kd(148, 10)+rz*jd(105, 10)
    jf(106, 20)=kd(150, 10)+rz*jd(106, 10)
    jf(107, 20)=kd(151, 10)+rz*jd(107, 10)
    jf(108, 20)=kd(152, 10)+rz*jd(108, 10)
    jf(109, 20)=kd(153, 10)+rz*jd(109, 10)
    jf(110, 20)=kd(154, 10)+rz*jd(110, 10)
    jf(111, 20)=kd(155, 10)+rz*jd(111, 10)
    jf(112, 20)=kd(156, 10)+rz*jd(112, 10)
    jf(113, 20)=kd(158, 10)+rz*jd(113, 10)
    jf(114, 20)=kd(159, 10)+rz*jd(114, 10)
    jf(115, 20)=kd(160, 10)+rz*jd(115, 10)
    jf(116, 20)=kd(161, 10)+rz*jd(116, 10)
    jf(117, 20)=kd(162, 10)+rz*jd(117, 10)
    jf(118, 20)=kd(163, 10)+rz*jd(118, 10)
    jf(119, 20)=kd(164, 10)+rz*jd(119, 10)
    jf(120, 20)=kd(165, 10)+rz*jd(120, 10)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_dg( )
    dg(  5, 21)=ff( 11, 11)+rx*df(  5, 11)
    dg(  6, 21)=ff( 12, 11)+rx*df(  6, 11)
    dg(  7, 21)=ff( 13, 11)+rx*df(  7, 11)
    dg(  8, 21)=ff( 14, 11)+rx*df(  8, 11)
    dg(  9, 21)=ff( 15, 11)+rx*df(  9, 11)
    dg( 10, 21)=ff( 16, 11)+rx*df( 10, 11)
    dg(  5, 22)=ff( 11, 12)+rx*df(  5, 12)
    dg(  6, 22)=ff( 12, 12)+rx*df(  6, 12)
    dg(  7, 22)=ff( 13, 12)+rx*df(  7, 12)
    dg(  8, 22)=ff( 14, 12)+rx*df(  8, 12)
    dg(  9, 22)=ff( 15, 12)+rx*df(  9, 12)
    dg( 10, 22)=ff( 16, 12)+rx*df( 10, 12)
    dg(  5, 23)=ff( 11, 13)+rx*df(  5, 13)
    dg(  6, 23)=ff( 12, 13)+rx*df(  6, 13)
    dg(  7, 23)=ff( 13, 13)+rx*df(  7, 13)
    dg(  8, 23)=ff( 14, 13)+rx*df(  8, 13)
    dg(  9, 23)=ff( 15, 13)+rx*df(  9, 13)
    dg( 10, 23)=ff( 16, 13)+rx*df( 10, 13)
    dg(  5, 24)=ff( 11, 14)+rx*df(  5, 14)
    dg(  6, 24)=ff( 12, 14)+rx*df(  6, 14)
    dg(  7, 24)=ff( 13, 14)+rx*df(  7, 14)
    dg(  8, 24)=ff( 14, 14)+rx*df(  8, 14)
    dg(  9, 24)=ff( 15, 14)+rx*df(  9, 14)
    dg( 10, 24)=ff( 16, 14)+rx*df( 10, 14)
    dg(  5, 25)=ff( 11, 15)+rx*df(  5, 15)
    dg(  6, 25)=ff( 12, 15)+rx*df(  6, 15)
    dg(  7, 25)=ff( 13, 15)+rx*df(  7, 15)
    dg(  8, 25)=ff( 14, 15)+rx*df(  8, 15)
    dg(  9, 25)=ff( 15, 15)+rx*df(  9, 15)
    dg( 10, 25)=ff( 16, 15)+rx*df( 10, 15)
    dg(  5, 26)=ff( 11, 16)+rx*df(  5, 16)
    dg(  6, 26)=ff( 12, 16)+rx*df(  6, 16)
    dg(  7, 26)=ff( 13, 16)+rx*df(  7, 16)
    dg(  8, 26)=ff( 14, 16)+rx*df(  8, 16)
    dg(  9, 26)=ff( 15, 16)+rx*df(  9, 16)
    dg( 10, 26)=ff( 16, 16)+rx*df( 10, 16)
    dg(  5, 27)=ff( 11, 17)+rx*df(  5, 17)
    dg(  6, 27)=ff( 12, 17)+rx*df(  6, 17)
    dg(  7, 27)=ff( 13, 17)+rx*df(  7, 17)
    dg(  8, 27)=ff( 14, 17)+rx*df(  8, 17)
    dg(  9, 27)=ff( 15, 17)+rx*df(  9, 17)
    dg( 10, 27)=ff( 16, 17)+rx*df( 10, 17)
    dg(  5, 28)=ff( 11, 18)+rx*df(  5, 18)
    dg(  6, 28)=ff( 12, 18)+rx*df(  6, 18)
    dg(  7, 28)=ff( 13, 18)+rx*df(  7, 18)
    dg(  8, 28)=ff( 14, 18)+rx*df(  8, 18)
    dg(  9, 28)=ff( 15, 18)+rx*df(  9, 18)
    dg( 10, 28)=ff( 16, 18)+rx*df( 10, 18)
    dg(  5, 29)=ff( 11, 19)+rx*df(  5, 19)
    dg(  6, 29)=ff( 12, 19)+rx*df(  6, 19)
    dg(  7, 29)=ff( 13, 19)+rx*df(  7, 19)
    dg(  8, 29)=ff( 14, 19)+rx*df(  8, 19)
    dg(  9, 29)=ff( 15, 19)+rx*df(  9, 19)
    dg( 10, 29)=ff( 16, 19)+rx*df( 10, 19)
    dg(  5, 30)=ff( 11, 20)+rx*df(  5, 20)
    dg(  6, 30)=ff( 12, 20)+rx*df(  6, 20)
    dg(  7, 30)=ff( 13, 20)+rx*df(  7, 20)
    dg(  8, 30)=ff( 14, 20)+rx*df(  8, 20)
    dg(  9, 30)=ff( 15, 20)+rx*df(  9, 20)
    dg( 10, 30)=ff( 16, 20)+rx*df( 10, 20)
    dg(  5, 31)=ff( 12, 17)+ry*df(  5, 17)
    dg(  6, 31)=ff( 14, 17)+ry*df(  6, 17)
    dg(  7, 31)=ff( 15, 17)+ry*df(  7, 17)
    dg(  8, 31)=ff( 17, 17)+ry*df(  8, 17)
    dg(  9, 31)=ff( 18, 17)+ry*df(  9, 17)
    dg( 10, 31)=ff( 19, 17)+ry*df( 10, 17)
    dg(  5, 32)=ff( 12, 18)+ry*df(  5, 18)
    dg(  6, 32)=ff( 14, 18)+ry*df(  6, 18)
    dg(  7, 32)=ff( 15, 18)+ry*df(  7, 18)
    dg(  8, 32)=ff( 17, 18)+ry*df(  8, 18)
    dg(  9, 32)=ff( 18, 18)+ry*df(  9, 18)
    dg( 10, 32)=ff( 19, 18)+ry*df( 10, 18)
    dg(  5, 33)=ff( 12, 19)+ry*df(  5, 19)
    dg(  6, 33)=ff( 14, 19)+ry*df(  6, 19)
    dg(  7, 33)=ff( 15, 19)+ry*df(  7, 19)
    dg(  8, 33)=ff( 17, 19)+ry*df(  8, 19)
    dg(  9, 33)=ff( 18, 19)+ry*df(  9, 19)
    dg( 10, 33)=ff( 19, 19)+ry*df( 10, 19)
    dg(  5, 34)=ff( 12, 20)+ry*df(  5, 20)
    dg(  6, 34)=ff( 14, 20)+ry*df(  6, 20)
    dg(  7, 34)=ff( 15, 20)+ry*df(  7, 20)
    dg(  8, 34)=ff( 17, 20)+ry*df(  8, 20)
    dg(  9, 34)=ff( 18, 20)+ry*df(  9, 20)
    dg( 10, 34)=ff( 19, 20)+ry*df( 10, 20)
    dg(  5, 35)=ff( 13, 20)+rz*df(  5, 20)
    dg(  6, 35)=ff( 15, 20)+rz*df(  6, 20)
    dg(  7, 35)=ff( 16, 20)+rz*df(  7, 20)
    dg(  8, 35)=ff( 18, 20)+rz*df(  8, 20)
    dg(  9, 35)=ff( 19, 20)+rz*df(  9, 20)
    dg( 10, 35)=ff( 20, 20)+rz*df( 10, 20)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_fg( )
    fg( 11, 21)=gf( 21, 11)+rx*ff( 11, 11)
    fg( 12, 21)=gf( 22, 11)+rx*ff( 12, 11)
    fg( 13, 21)=gf( 23, 11)+rx*ff( 13, 11)
    fg( 14, 21)=gf( 24, 11)+rx*ff( 14, 11)
    fg( 15, 21)=gf( 25, 11)+rx*ff( 15, 11)
    fg( 16, 21)=gf( 26, 11)+rx*ff( 16, 11)
    fg( 17, 21)=gf( 27, 11)+rx*ff( 17, 11)
    fg( 18, 21)=gf( 28, 11)+rx*ff( 18, 11)
    fg( 19, 21)=gf( 29, 11)+rx*ff( 19, 11)
    fg( 20, 21)=gf( 30, 11)+rx*ff( 20, 11)
    fg( 11, 22)=gf( 21, 12)+rx*ff( 11, 12)
    fg( 12, 22)=gf( 22, 12)+rx*ff( 12, 12)
    fg( 13, 22)=gf( 23, 12)+rx*ff( 13, 12)
    fg( 14, 22)=gf( 24, 12)+rx*ff( 14, 12)
    fg( 15, 22)=gf( 25, 12)+rx*ff( 15, 12)
    fg( 16, 22)=gf( 26, 12)+rx*ff( 16, 12)
    fg( 17, 22)=gf( 27, 12)+rx*ff( 17, 12)
    fg( 18, 22)=gf( 28, 12)+rx*ff( 18, 12)
    fg( 19, 22)=gf( 29, 12)+rx*ff( 19, 12)
    fg( 20, 22)=gf( 30, 12)+rx*ff( 20, 12)
    fg( 11, 23)=gf( 21, 13)+rx*ff( 11, 13)
    fg( 12, 23)=gf( 22, 13)+rx*ff( 12, 13)
    fg( 13, 23)=gf( 23, 13)+rx*ff( 13, 13)
    fg( 14, 23)=gf( 24, 13)+rx*ff( 14, 13)
    fg( 15, 23)=gf( 25, 13)+rx*ff( 15, 13)
    fg( 16, 23)=gf( 26, 13)+rx*ff( 16, 13)
    fg( 17, 23)=gf( 27, 13)+rx*ff( 17, 13)
    fg( 18, 23)=gf( 28, 13)+rx*ff( 18, 13)
    fg( 19, 23)=gf( 29, 13)+rx*ff( 19, 13)
    fg( 20, 23)=gf( 30, 13)+rx*ff( 20, 13)
    fg( 11, 24)=gf( 21, 14)+rx*ff( 11, 14)
    fg( 12, 24)=gf( 22, 14)+rx*ff( 12, 14)
    fg( 13, 24)=gf( 23, 14)+rx*ff( 13, 14)
    fg( 14, 24)=gf( 24, 14)+rx*ff( 14, 14)
    fg( 15, 24)=gf( 25, 14)+rx*ff( 15, 14)
    fg( 16, 24)=gf( 26, 14)+rx*ff( 16, 14)
    fg( 17, 24)=gf( 27, 14)+rx*ff( 17, 14)
    fg( 18, 24)=gf( 28, 14)+rx*ff( 18, 14)
    fg( 19, 24)=gf( 29, 14)+rx*ff( 19, 14)
    fg( 20, 24)=gf( 30, 14)+rx*ff( 20, 14)
    fg( 11, 25)=gf( 21, 15)+rx*ff( 11, 15)
    fg( 12, 25)=gf( 22, 15)+rx*ff( 12, 15)
    fg( 13, 25)=gf( 23, 15)+rx*ff( 13, 15)
    fg( 14, 25)=gf( 24, 15)+rx*ff( 14, 15)
    fg( 15, 25)=gf( 25, 15)+rx*ff( 15, 15)
    fg( 16, 25)=gf( 26, 15)+rx*ff( 16, 15)
    fg( 17, 25)=gf( 27, 15)+rx*ff( 17, 15)
    fg( 18, 25)=gf( 28, 15)+rx*ff( 18, 15)
    fg( 19, 25)=gf( 29, 15)+rx*ff( 19, 15)
    fg( 20, 25)=gf( 30, 15)+rx*ff( 20, 15)
    fg( 11, 26)=gf( 21, 16)+rx*ff( 11, 16)
    fg( 12, 26)=gf( 22, 16)+rx*ff( 12, 16)
    fg( 13, 26)=gf( 23, 16)+rx*ff( 13, 16)
    fg( 14, 26)=gf( 24, 16)+rx*ff( 14, 16)
    fg( 15, 26)=gf( 25, 16)+rx*ff( 15, 16)
    fg( 16, 26)=gf( 26, 16)+rx*ff( 16, 16)
    fg( 17, 26)=gf( 27, 16)+rx*ff( 17, 16)
    fg( 18, 26)=gf( 28, 16)+rx*ff( 18, 16)
    fg( 19, 26)=gf( 29, 16)+rx*ff( 19, 16)
    fg( 20, 26)=gf( 30, 16)+rx*ff( 20, 16)
    fg( 11, 27)=gf( 21, 17)+rx*ff( 11, 17)
    fg( 12, 27)=gf( 22, 17)+rx*ff( 12, 17)
    fg( 13, 27)=gf( 23, 17)+rx*ff( 13, 17)
    fg( 14, 27)=gf( 24, 17)+rx*ff( 14, 17)
    fg( 15, 27)=gf( 25, 17)+rx*ff( 15, 17)
    fg( 16, 27)=gf( 26, 17)+rx*ff( 16, 17)
    fg( 17, 27)=gf( 27, 17)+rx*ff( 17, 17)
    fg( 18, 27)=gf( 28, 17)+rx*ff( 18, 17)
    fg( 19, 27)=gf( 29, 17)+rx*ff( 19, 17)
    fg( 20, 27)=gf( 30, 17)+rx*ff( 20, 17)
    fg( 11, 28)=gf( 21, 18)+rx*ff( 11, 18)
    fg( 12, 28)=gf( 22, 18)+rx*ff( 12, 18)
    fg( 13, 28)=gf( 23, 18)+rx*ff( 13, 18)
    fg( 14, 28)=gf( 24, 18)+rx*ff( 14, 18)
    fg( 15, 28)=gf( 25, 18)+rx*ff( 15, 18)
    fg( 16, 28)=gf( 26, 18)+rx*ff( 16, 18)
    fg( 17, 28)=gf( 27, 18)+rx*ff( 17, 18)
    fg( 18, 28)=gf( 28, 18)+rx*ff( 18, 18)
    fg( 19, 28)=gf( 29, 18)+rx*ff( 19, 18)
    fg( 20, 28)=gf( 30, 18)+rx*ff( 20, 18)
    fg( 11, 29)=gf( 21, 19)+rx*ff( 11, 19)
    fg( 12, 29)=gf( 22, 19)+rx*ff( 12, 19)
    fg( 13, 29)=gf( 23, 19)+rx*ff( 13, 19)
    fg( 14, 29)=gf( 24, 19)+rx*ff( 14, 19)
    fg( 15, 29)=gf( 25, 19)+rx*ff( 15, 19)
    fg( 16, 29)=gf( 26, 19)+rx*ff( 16, 19)
    fg( 17, 29)=gf( 27, 19)+rx*ff( 17, 19)
    fg( 18, 29)=gf( 28, 19)+rx*ff( 18, 19)
    fg( 19, 29)=gf( 29, 19)+rx*ff( 19, 19)
    fg( 20, 29)=gf( 30, 19)+rx*ff( 20, 19)
    fg( 11, 30)=gf( 21, 20)+rx*ff( 11, 20)
    fg( 12, 30)=gf( 22, 20)+rx*ff( 12, 20)
    fg( 13, 30)=gf( 23, 20)+rx*ff( 13, 20)
    fg( 14, 30)=gf( 24, 20)+rx*ff( 14, 20)
    fg( 15, 30)=gf( 25, 20)+rx*ff( 15, 20)
    fg( 16, 30)=gf( 26, 20)+rx*ff( 16, 20)
    fg( 17, 30)=gf( 27, 20)+rx*ff( 17, 20)
    fg( 18, 30)=gf( 28, 20)+rx*ff( 18, 20)
    fg( 19, 30)=gf( 29, 20)+rx*ff( 19, 20)
    fg( 20, 30)=gf( 30, 20)+rx*ff( 20, 20)
    fg( 11, 31)=gf( 22, 17)+ry*ff( 11, 17)
    fg( 12, 31)=gf( 24, 17)+ry*ff( 12, 17)
    fg( 13, 31)=gf( 25, 17)+ry*ff( 13, 17)
    fg( 14, 31)=gf( 27, 17)+ry*ff( 14, 17)
    fg( 15, 31)=gf( 28, 17)+ry*ff( 15, 17)
    fg( 16, 31)=gf( 29, 17)+ry*ff( 16, 17)
    fg( 17, 31)=gf( 31, 17)+ry*ff( 17, 17)
    fg( 18, 31)=gf( 32, 17)+ry*ff( 18, 17)
    fg( 19, 31)=gf( 33, 17)+ry*ff( 19, 17)
    fg( 20, 31)=gf( 34, 17)+ry*ff( 20, 17)
    fg( 11, 32)=gf( 22, 18)+ry*ff( 11, 18)
    fg( 12, 32)=gf( 24, 18)+ry*ff( 12, 18)
    fg( 13, 32)=gf( 25, 18)+ry*ff( 13, 18)
    fg( 14, 32)=gf( 27, 18)+ry*ff( 14, 18)
    fg( 15, 32)=gf( 28, 18)+ry*ff( 15, 18)
    fg( 16, 32)=gf( 29, 18)+ry*ff( 16, 18)
    fg( 17, 32)=gf( 31, 18)+ry*ff( 17, 18)
    fg( 18, 32)=gf( 32, 18)+ry*ff( 18, 18)
    fg( 19, 32)=gf( 33, 18)+ry*ff( 19, 18)
    fg( 20, 32)=gf( 34, 18)+ry*ff( 20, 18)
    fg( 11, 33)=gf( 22, 19)+ry*ff( 11, 19)
    fg( 12, 33)=gf( 24, 19)+ry*ff( 12, 19)
    fg( 13, 33)=gf( 25, 19)+ry*ff( 13, 19)
    fg( 14, 33)=gf( 27, 19)+ry*ff( 14, 19)
    fg( 15, 33)=gf( 28, 19)+ry*ff( 15, 19)
    fg( 16, 33)=gf( 29, 19)+ry*ff( 16, 19)
    fg( 17, 33)=gf( 31, 19)+ry*ff( 17, 19)
    fg( 18, 33)=gf( 32, 19)+ry*ff( 18, 19)
    fg( 19, 33)=gf( 33, 19)+ry*ff( 19, 19)
    fg( 20, 33)=gf( 34, 19)+ry*ff( 20, 19)
    fg( 11, 34)=gf( 22, 20)+ry*ff( 11, 20)
    fg( 12, 34)=gf( 24, 20)+ry*ff( 12, 20)
    fg( 13, 34)=gf( 25, 20)+ry*ff( 13, 20)
    fg( 14, 34)=gf( 27, 20)+ry*ff( 14, 20)
    fg( 15, 34)=gf( 28, 20)+ry*ff( 15, 20)
    fg( 16, 34)=gf( 29, 20)+ry*ff( 16, 20)
    fg( 17, 34)=gf( 31, 20)+ry*ff( 17, 20)
    fg( 18, 34)=gf( 32, 20)+ry*ff( 18, 20)
    fg( 19, 34)=gf( 33, 20)+ry*ff( 19, 20)
    fg( 20, 34)=gf( 34, 20)+ry*ff( 20, 20)
    fg( 11, 35)=gf( 23, 20)+rz*ff( 11, 20)
    fg( 12, 35)=gf( 25, 20)+rz*ff( 12, 20)
    fg( 13, 35)=gf( 26, 20)+rz*ff( 13, 20)
    fg( 14, 35)=gf( 28, 20)+rz*ff( 14, 20)
    fg( 15, 35)=gf( 29, 20)+rz*ff( 15, 20)
    fg( 16, 35)=gf( 30, 20)+rz*ff( 16, 20)
    fg( 17, 35)=gf( 32, 20)+rz*ff( 17, 20)
    fg( 18, 35)=gf( 33, 20)+rz*ff( 18, 20)
    fg( 19, 35)=gf( 34, 20)+rz*ff( 19, 20)
    fg( 20, 35)=gf( 35, 20)+rz*ff( 20, 20)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_gg( )
    gg( 21, 21)=hf( 36, 11)+rx*gf( 21, 11)
    gg( 22, 21)=hf( 37, 11)+rx*gf( 22, 11)
    gg( 23, 21)=hf( 38, 11)+rx*gf( 23, 11)
    gg( 24, 21)=hf( 39, 11)+rx*gf( 24, 11)
    gg( 25, 21)=hf( 40, 11)+rx*gf( 25, 11)
    gg( 26, 21)=hf( 41, 11)+rx*gf( 26, 11)
    gg( 27, 21)=hf( 42, 11)+rx*gf( 27, 11)
    gg( 28, 21)=hf( 43, 11)+rx*gf( 28, 11)
    gg( 29, 21)=hf( 44, 11)+rx*gf( 29, 11)
    gg( 30, 21)=hf( 45, 11)+rx*gf( 30, 11)
    gg( 31, 21)=hf( 46, 11)+rx*gf( 31, 11)
    gg( 32, 21)=hf( 47, 11)+rx*gf( 32, 11)
    gg( 33, 21)=hf( 48, 11)+rx*gf( 33, 11)
    gg( 34, 21)=hf( 49, 11)+rx*gf( 34, 11)
    gg( 35, 21)=hf( 50, 11)+rx*gf( 35, 11)
    gg( 21, 22)=hf( 36, 12)+rx*gf( 21, 12)
    gg( 22, 22)=hf( 37, 12)+rx*gf( 22, 12)
    gg( 23, 22)=hf( 38, 12)+rx*gf( 23, 12)
    gg( 24, 22)=hf( 39, 12)+rx*gf( 24, 12)
    gg( 25, 22)=hf( 40, 12)+rx*gf( 25, 12)
    gg( 26, 22)=hf( 41, 12)+rx*gf( 26, 12)
    gg( 27, 22)=hf( 42, 12)+rx*gf( 27, 12)
    gg( 28, 22)=hf( 43, 12)+rx*gf( 28, 12)
    gg( 29, 22)=hf( 44, 12)+rx*gf( 29, 12)
    gg( 30, 22)=hf( 45, 12)+rx*gf( 30, 12)
    gg( 31, 22)=hf( 46, 12)+rx*gf( 31, 12)
    gg( 32, 22)=hf( 47, 12)+rx*gf( 32, 12)
    gg( 33, 22)=hf( 48, 12)+rx*gf( 33, 12)
    gg( 34, 22)=hf( 49, 12)+rx*gf( 34, 12)
    gg( 35, 22)=hf( 50, 12)+rx*gf( 35, 12)
    gg( 21, 23)=hf( 36, 13)+rx*gf( 21, 13)
    gg( 22, 23)=hf( 37, 13)+rx*gf( 22, 13)
    gg( 23, 23)=hf( 38, 13)+rx*gf( 23, 13)
    gg( 24, 23)=hf( 39, 13)+rx*gf( 24, 13)
    gg( 25, 23)=hf( 40, 13)+rx*gf( 25, 13)
    gg( 26, 23)=hf( 41, 13)+rx*gf( 26, 13)
    gg( 27, 23)=hf( 42, 13)+rx*gf( 27, 13)
    gg( 28, 23)=hf( 43, 13)+rx*gf( 28, 13)
    gg( 29, 23)=hf( 44, 13)+rx*gf( 29, 13)
    gg( 30, 23)=hf( 45, 13)+rx*gf( 30, 13)
    gg( 31, 23)=hf( 46, 13)+rx*gf( 31, 13)
    gg( 32, 23)=hf( 47, 13)+rx*gf( 32, 13)
    gg( 33, 23)=hf( 48, 13)+rx*gf( 33, 13)
    gg( 34, 23)=hf( 49, 13)+rx*gf( 34, 13)
    gg( 35, 23)=hf( 50, 13)+rx*gf( 35, 13)
    gg( 21, 24)=hf( 36, 14)+rx*gf( 21, 14)
    gg( 22, 24)=hf( 37, 14)+rx*gf( 22, 14)
    gg( 23, 24)=hf( 38, 14)+rx*gf( 23, 14)
    gg( 24, 24)=hf( 39, 14)+rx*gf( 24, 14)
    gg( 25, 24)=hf( 40, 14)+rx*gf( 25, 14)
    gg( 26, 24)=hf( 41, 14)+rx*gf( 26, 14)
    gg( 27, 24)=hf( 42, 14)+rx*gf( 27, 14)
    gg( 28, 24)=hf( 43, 14)+rx*gf( 28, 14)
    gg( 29, 24)=hf( 44, 14)+rx*gf( 29, 14)
    gg( 30, 24)=hf( 45, 14)+rx*gf( 30, 14)
    gg( 31, 24)=hf( 46, 14)+rx*gf( 31, 14)
    gg( 32, 24)=hf( 47, 14)+rx*gf( 32, 14)
    gg( 33, 24)=hf( 48, 14)+rx*gf( 33, 14)
    gg( 34, 24)=hf( 49, 14)+rx*gf( 34, 14)
    gg( 35, 24)=hf( 50, 14)+rx*gf( 35, 14)
    gg( 21, 25)=hf( 36, 15)+rx*gf( 21, 15)
    gg( 22, 25)=hf( 37, 15)+rx*gf( 22, 15)
    gg( 23, 25)=hf( 38, 15)+rx*gf( 23, 15)
    gg( 24, 25)=hf( 39, 15)+rx*gf( 24, 15)
    gg( 25, 25)=hf( 40, 15)+rx*gf( 25, 15)
    gg( 26, 25)=hf( 41, 15)+rx*gf( 26, 15)
    gg( 27, 25)=hf( 42, 15)+rx*gf( 27, 15)
    gg( 28, 25)=hf( 43, 15)+rx*gf( 28, 15)
    gg( 29, 25)=hf( 44, 15)+rx*gf( 29, 15)
    gg( 30, 25)=hf( 45, 15)+rx*gf( 30, 15)
    gg( 31, 25)=hf( 46, 15)+rx*gf( 31, 15)
    gg( 32, 25)=hf( 47, 15)+rx*gf( 32, 15)
    gg( 33, 25)=hf( 48, 15)+rx*gf( 33, 15)
    gg( 34, 25)=hf( 49, 15)+rx*gf( 34, 15)
    gg( 35, 25)=hf( 50, 15)+rx*gf( 35, 15)
    gg( 21, 26)=hf( 36, 16)+rx*gf( 21, 16)
    gg( 22, 26)=hf( 37, 16)+rx*gf( 22, 16)
    gg( 23, 26)=hf( 38, 16)+rx*gf( 23, 16)
    gg( 24, 26)=hf( 39, 16)+rx*gf( 24, 16)
    gg( 25, 26)=hf( 40, 16)+rx*gf( 25, 16)
    gg( 26, 26)=hf( 41, 16)+rx*gf( 26, 16)
    gg( 27, 26)=hf( 42, 16)+rx*gf( 27, 16)
    gg( 28, 26)=hf( 43, 16)+rx*gf( 28, 16)
    gg( 29, 26)=hf( 44, 16)+rx*gf( 29, 16)
    gg( 30, 26)=hf( 45, 16)+rx*gf( 30, 16)
    gg( 31, 26)=hf( 46, 16)+rx*gf( 31, 16)
    gg( 32, 26)=hf( 47, 16)+rx*gf( 32, 16)
    gg( 33, 26)=hf( 48, 16)+rx*gf( 33, 16)
    gg( 34, 26)=hf( 49, 16)+rx*gf( 34, 16)
    gg( 35, 26)=hf( 50, 16)+rx*gf( 35, 16)
    gg( 21, 27)=hf( 36, 17)+rx*gf( 21, 17)
    gg( 22, 27)=hf( 37, 17)+rx*gf( 22, 17)
    gg( 23, 27)=hf( 38, 17)+rx*gf( 23, 17)
    gg( 24, 27)=hf( 39, 17)+rx*gf( 24, 17)
    gg( 25, 27)=hf( 40, 17)+rx*gf( 25, 17)
    gg( 26, 27)=hf( 41, 17)+rx*gf( 26, 17)
    gg( 27, 27)=hf( 42, 17)+rx*gf( 27, 17)
    gg( 28, 27)=hf( 43, 17)+rx*gf( 28, 17)
    gg( 29, 27)=hf( 44, 17)+rx*gf( 29, 17)
    gg( 30, 27)=hf( 45, 17)+rx*gf( 30, 17)
    gg( 31, 27)=hf( 46, 17)+rx*gf( 31, 17)
    gg( 32, 27)=hf( 47, 17)+rx*gf( 32, 17)
    gg( 33, 27)=hf( 48, 17)+rx*gf( 33, 17)
    gg( 34, 27)=hf( 49, 17)+rx*gf( 34, 17)
    gg( 35, 27)=hf( 50, 17)+rx*gf( 35, 17)
    gg( 21, 28)=hf( 36, 18)+rx*gf( 21, 18)
    gg( 22, 28)=hf( 37, 18)+rx*gf( 22, 18)
    gg( 23, 28)=hf( 38, 18)+rx*gf( 23, 18)
    gg( 24, 28)=hf( 39, 18)+rx*gf( 24, 18)
    gg( 25, 28)=hf( 40, 18)+rx*gf( 25, 18)
    gg( 26, 28)=hf( 41, 18)+rx*gf( 26, 18)
    gg( 27, 28)=hf( 42, 18)+rx*gf( 27, 18)
    gg( 28, 28)=hf( 43, 18)+rx*gf( 28, 18)
    gg( 29, 28)=hf( 44, 18)+rx*gf( 29, 18)
    gg( 30, 28)=hf( 45, 18)+rx*gf( 30, 18)
    gg( 31, 28)=hf( 46, 18)+rx*gf( 31, 18)
    gg( 32, 28)=hf( 47, 18)+rx*gf( 32, 18)
    gg( 33, 28)=hf( 48, 18)+rx*gf( 33, 18)
    gg( 34, 28)=hf( 49, 18)+rx*gf( 34, 18)
    gg( 35, 28)=hf( 50, 18)+rx*gf( 35, 18)
    gg( 21, 29)=hf( 36, 19)+rx*gf( 21, 19)
    gg( 22, 29)=hf( 37, 19)+rx*gf( 22, 19)
    gg( 23, 29)=hf( 38, 19)+rx*gf( 23, 19)
    gg( 24, 29)=hf( 39, 19)+rx*gf( 24, 19)
    gg( 25, 29)=hf( 40, 19)+rx*gf( 25, 19)
    gg( 26, 29)=hf( 41, 19)+rx*gf( 26, 19)
    gg( 27, 29)=hf( 42, 19)+rx*gf( 27, 19)
    gg( 28, 29)=hf( 43, 19)+rx*gf( 28, 19)
    gg( 29, 29)=hf( 44, 19)+rx*gf( 29, 19)
    gg( 30, 29)=hf( 45, 19)+rx*gf( 30, 19)
    gg( 31, 29)=hf( 46, 19)+rx*gf( 31, 19)
    gg( 32, 29)=hf( 47, 19)+rx*gf( 32, 19)
    gg( 33, 29)=hf( 48, 19)+rx*gf( 33, 19)
    gg( 34, 29)=hf( 49, 19)+rx*gf( 34, 19)
    gg( 35, 29)=hf( 50, 19)+rx*gf( 35, 19)
    gg( 21, 30)=hf( 36, 20)+rx*gf( 21, 20)
    gg( 22, 30)=hf( 37, 20)+rx*gf( 22, 20)
    gg( 23, 30)=hf( 38, 20)+rx*gf( 23, 20)
    gg( 24, 30)=hf( 39, 20)+rx*gf( 24, 20)
    gg( 25, 30)=hf( 40, 20)+rx*gf( 25, 20)
    gg( 26, 30)=hf( 41, 20)+rx*gf( 26, 20)
    gg( 27, 30)=hf( 42, 20)+rx*gf( 27, 20)
    gg( 28, 30)=hf( 43, 20)+rx*gf( 28, 20)
    gg( 29, 30)=hf( 44, 20)+rx*gf( 29, 20)
    gg( 30, 30)=hf( 45, 20)+rx*gf( 30, 20)
    gg( 31, 30)=hf( 46, 20)+rx*gf( 31, 20)
    gg( 32, 30)=hf( 47, 20)+rx*gf( 32, 20)
    gg( 33, 30)=hf( 48, 20)+rx*gf( 33, 20)
    gg( 34, 30)=hf( 49, 20)+rx*gf( 34, 20)
    gg( 35, 30)=hf( 50, 20)+rx*gf( 35, 20)
    gg( 21, 31)=hf( 37, 17)+ry*gf( 21, 17)
    gg( 22, 31)=hf( 39, 17)+ry*gf( 22, 17)
    gg( 23, 31)=hf( 40, 17)+ry*gf( 23, 17)
    gg( 24, 31)=hf( 42, 17)+ry*gf( 24, 17)
    gg( 25, 31)=hf( 43, 17)+ry*gf( 25, 17)
    gg( 26, 31)=hf( 44, 17)+ry*gf( 26, 17)
    gg( 27, 31)=hf( 46, 17)+ry*gf( 27, 17)
    gg( 28, 31)=hf( 47, 17)+ry*gf( 28, 17)
    gg( 29, 31)=hf( 48, 17)+ry*gf( 29, 17)
    gg( 30, 31)=hf( 49, 17)+ry*gf( 30, 17)
    gg( 31, 31)=hf( 51, 17)+ry*gf( 31, 17)
    gg( 32, 31)=hf( 52, 17)+ry*gf( 32, 17)
    gg( 33, 31)=hf( 53, 17)+ry*gf( 33, 17)
    gg( 34, 31)=hf( 54, 17)+ry*gf( 34, 17)
    gg( 35, 31)=hf( 55, 17)+ry*gf( 35, 17)
    gg( 21, 32)=hf( 37, 18)+ry*gf( 21, 18)
    gg( 22, 32)=hf( 39, 18)+ry*gf( 22, 18)
    gg( 23, 32)=hf( 40, 18)+ry*gf( 23, 18)
    gg( 24, 32)=hf( 42, 18)+ry*gf( 24, 18)
    gg( 25, 32)=hf( 43, 18)+ry*gf( 25, 18)
    gg( 26, 32)=hf( 44, 18)+ry*gf( 26, 18)
    gg( 27, 32)=hf( 46, 18)+ry*gf( 27, 18)
    gg( 28, 32)=hf( 47, 18)+ry*gf( 28, 18)
    gg( 29, 32)=hf( 48, 18)+ry*gf( 29, 18)
    gg( 30, 32)=hf( 49, 18)+ry*gf( 30, 18)
    gg( 31, 32)=hf( 51, 18)+ry*gf( 31, 18)
    gg( 32, 32)=hf( 52, 18)+ry*gf( 32, 18)
    gg( 33, 32)=hf( 53, 18)+ry*gf( 33, 18)
    gg( 34, 32)=hf( 54, 18)+ry*gf( 34, 18)
    gg( 35, 32)=hf( 55, 18)+ry*gf( 35, 18)
    gg( 21, 33)=hf( 37, 19)+ry*gf( 21, 19)
    gg( 22, 33)=hf( 39, 19)+ry*gf( 22, 19)
    gg( 23, 33)=hf( 40, 19)+ry*gf( 23, 19)
    gg( 24, 33)=hf( 42, 19)+ry*gf( 24, 19)
    gg( 25, 33)=hf( 43, 19)+ry*gf( 25, 19)
    gg( 26, 33)=hf( 44, 19)+ry*gf( 26, 19)
    gg( 27, 33)=hf( 46, 19)+ry*gf( 27, 19)
    gg( 28, 33)=hf( 47, 19)+ry*gf( 28, 19)
    gg( 29, 33)=hf( 48, 19)+ry*gf( 29, 19)
    gg( 30, 33)=hf( 49, 19)+ry*gf( 30, 19)
    gg( 31, 33)=hf( 51, 19)+ry*gf( 31, 19)
    gg( 32, 33)=hf( 52, 19)+ry*gf( 32, 19)
    gg( 33, 33)=hf( 53, 19)+ry*gf( 33, 19)
    gg( 34, 33)=hf( 54, 19)+ry*gf( 34, 19)
    gg( 35, 33)=hf( 55, 19)+ry*gf( 35, 19)
    gg( 21, 34)=hf( 37, 20)+ry*gf( 21, 20)
    gg( 22, 34)=hf( 39, 20)+ry*gf( 22, 20)
    gg( 23, 34)=hf( 40, 20)+ry*gf( 23, 20)
    gg( 24, 34)=hf( 42, 20)+ry*gf( 24, 20)
    gg( 25, 34)=hf( 43, 20)+ry*gf( 25, 20)
    gg( 26, 34)=hf( 44, 20)+ry*gf( 26, 20)
    gg( 27, 34)=hf( 46, 20)+ry*gf( 27, 20)
    gg( 28, 34)=hf( 47, 20)+ry*gf( 28, 20)
    gg( 29, 34)=hf( 48, 20)+ry*gf( 29, 20)
    gg( 30, 34)=hf( 49, 20)+ry*gf( 30, 20)
    gg( 31, 34)=hf( 51, 20)+ry*gf( 31, 20)
    gg( 32, 34)=hf( 52, 20)+ry*gf( 32, 20)
    gg( 33, 34)=hf( 53, 20)+ry*gf( 33, 20)
    gg( 34, 34)=hf( 54, 20)+ry*gf( 34, 20)
    gg( 35, 34)=hf( 55, 20)+ry*gf( 35, 20)
    gg( 21, 35)=hf( 38, 20)+rz*gf( 21, 20)
    gg( 22, 35)=hf( 40, 20)+rz*gf( 22, 20)
    gg( 23, 35)=hf( 41, 20)+rz*gf( 23, 20)
    gg( 24, 35)=hf( 43, 20)+rz*gf( 24, 20)
    gg( 25, 35)=hf( 44, 20)+rz*gf( 25, 20)
    gg( 26, 35)=hf( 45, 20)+rz*gf( 26, 20)
    gg( 27, 35)=hf( 47, 20)+rz*gf( 27, 20)
    gg( 28, 35)=hf( 48, 20)+rz*gf( 28, 20)
    gg( 29, 35)=hf( 49, 20)+rz*gf( 29, 20)
    gg( 30, 35)=hf( 50, 20)+rz*gf( 30, 20)
    gg( 31, 35)=hf( 52, 20)+rz*gf( 31, 20)
    gg( 32, 35)=hf( 53, 20)+rz*gf( 32, 20)
    gg( 33, 35)=hf( 54, 20)+rz*gf( 33, 20)
    gg( 34, 35)=hf( 55, 20)+rz*gf( 34, 20)
    gg( 35, 35)=hf( 56, 20)+rz*gf( 35, 20)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_hg( )
    hg( 36, 21)=if( 57, 11)+rx*hf( 36, 11)
    hg( 37, 21)=if( 58, 11)+rx*hf( 37, 11)
    hg( 38, 21)=if( 59, 11)+rx*hf( 38, 11)
    hg( 39, 21)=if( 60, 11)+rx*hf( 39, 11)
    hg( 40, 21)=if( 61, 11)+rx*hf( 40, 11)
    hg( 41, 21)=if( 62, 11)+rx*hf( 41, 11)
    hg( 42, 21)=if( 63, 11)+rx*hf( 42, 11)
    hg( 43, 21)=if( 64, 11)+rx*hf( 43, 11)
    hg( 44, 21)=if( 65, 11)+rx*hf( 44, 11)
    hg( 45, 21)=if( 66, 11)+rx*hf( 45, 11)
    hg( 46, 21)=if( 67, 11)+rx*hf( 46, 11)
    hg( 47, 21)=if( 68, 11)+rx*hf( 47, 11)
    hg( 48, 21)=if( 69, 11)+rx*hf( 48, 11)
    hg( 49, 21)=if( 70, 11)+rx*hf( 49, 11)
    hg( 50, 21)=if( 71, 11)+rx*hf( 50, 11)
    hg( 51, 21)=if( 72, 11)+rx*hf( 51, 11)
    hg( 52, 21)=if( 73, 11)+rx*hf( 52, 11)
    hg( 53, 21)=if( 74, 11)+rx*hf( 53, 11)
    hg( 54, 21)=if( 75, 11)+rx*hf( 54, 11)
    hg( 55, 21)=if( 76, 11)+rx*hf( 55, 11)
    hg( 56, 21)=if( 77, 11)+rx*hf( 56, 11)
    hg( 36, 22)=if( 57, 12)+rx*hf( 36, 12)
    hg( 37, 22)=if( 58, 12)+rx*hf( 37, 12)
    hg( 38, 22)=if( 59, 12)+rx*hf( 38, 12)
    hg( 39, 22)=if( 60, 12)+rx*hf( 39, 12)
    hg( 40, 22)=if( 61, 12)+rx*hf( 40, 12)
    hg( 41, 22)=if( 62, 12)+rx*hf( 41, 12)
    hg( 42, 22)=if( 63, 12)+rx*hf( 42, 12)
    hg( 43, 22)=if( 64, 12)+rx*hf( 43, 12)
    hg( 44, 22)=if( 65, 12)+rx*hf( 44, 12)
    hg( 45, 22)=if( 66, 12)+rx*hf( 45, 12)
    hg( 46, 22)=if( 67, 12)+rx*hf( 46, 12)
    hg( 47, 22)=if( 68, 12)+rx*hf( 47, 12)
    hg( 48, 22)=if( 69, 12)+rx*hf( 48, 12)
    hg( 49, 22)=if( 70, 12)+rx*hf( 49, 12)
    hg( 50, 22)=if( 71, 12)+rx*hf( 50, 12)
    hg( 51, 22)=if( 72, 12)+rx*hf( 51, 12)
    hg( 52, 22)=if( 73, 12)+rx*hf( 52, 12)
    hg( 53, 22)=if( 74, 12)+rx*hf( 53, 12)
    hg( 54, 22)=if( 75, 12)+rx*hf( 54, 12)
    hg( 55, 22)=if( 76, 12)+rx*hf( 55, 12)
    hg( 56, 22)=if( 77, 12)+rx*hf( 56, 12)
    hg( 36, 23)=if( 57, 13)+rx*hf( 36, 13)
    hg( 37, 23)=if( 58, 13)+rx*hf( 37, 13)
    hg( 38, 23)=if( 59, 13)+rx*hf( 38, 13)
    hg( 39, 23)=if( 60, 13)+rx*hf( 39, 13)
    hg( 40, 23)=if( 61, 13)+rx*hf( 40, 13)
    hg( 41, 23)=if( 62, 13)+rx*hf( 41, 13)
    hg( 42, 23)=if( 63, 13)+rx*hf( 42, 13)
    hg( 43, 23)=if( 64, 13)+rx*hf( 43, 13)
    hg( 44, 23)=if( 65, 13)+rx*hf( 44, 13)
    hg( 45, 23)=if( 66, 13)+rx*hf( 45, 13)
    hg( 46, 23)=if( 67, 13)+rx*hf( 46, 13)
    hg( 47, 23)=if( 68, 13)+rx*hf( 47, 13)
    hg( 48, 23)=if( 69, 13)+rx*hf( 48, 13)
    hg( 49, 23)=if( 70, 13)+rx*hf( 49, 13)
    hg( 50, 23)=if( 71, 13)+rx*hf( 50, 13)
    hg( 51, 23)=if( 72, 13)+rx*hf( 51, 13)
    hg( 52, 23)=if( 73, 13)+rx*hf( 52, 13)
    hg( 53, 23)=if( 74, 13)+rx*hf( 53, 13)
    hg( 54, 23)=if( 75, 13)+rx*hf( 54, 13)
    hg( 55, 23)=if( 76, 13)+rx*hf( 55, 13)
    hg( 56, 23)=if( 77, 13)+rx*hf( 56, 13)
    hg( 36, 24)=if( 57, 14)+rx*hf( 36, 14)
    hg( 37, 24)=if( 58, 14)+rx*hf( 37, 14)
    hg( 38, 24)=if( 59, 14)+rx*hf( 38, 14)
    hg( 39, 24)=if( 60, 14)+rx*hf( 39, 14)
    hg( 40, 24)=if( 61, 14)+rx*hf( 40, 14)
    hg( 41, 24)=if( 62, 14)+rx*hf( 41, 14)
    hg( 42, 24)=if( 63, 14)+rx*hf( 42, 14)
    hg( 43, 24)=if( 64, 14)+rx*hf( 43, 14)
    hg( 44, 24)=if( 65, 14)+rx*hf( 44, 14)
    hg( 45, 24)=if( 66, 14)+rx*hf( 45, 14)
    hg( 46, 24)=if( 67, 14)+rx*hf( 46, 14)
    hg( 47, 24)=if( 68, 14)+rx*hf( 47, 14)
    hg( 48, 24)=if( 69, 14)+rx*hf( 48, 14)
    hg( 49, 24)=if( 70, 14)+rx*hf( 49, 14)
    hg( 50, 24)=if( 71, 14)+rx*hf( 50, 14)
    hg( 51, 24)=if( 72, 14)+rx*hf( 51, 14)
    hg( 52, 24)=if( 73, 14)+rx*hf( 52, 14)
    hg( 53, 24)=if( 74, 14)+rx*hf( 53, 14)
    hg( 54, 24)=if( 75, 14)+rx*hf( 54, 14)
    hg( 55, 24)=if( 76, 14)+rx*hf( 55, 14)
    hg( 56, 24)=if( 77, 14)+rx*hf( 56, 14)
    hg( 36, 25)=if( 57, 15)+rx*hf( 36, 15)
    hg( 37, 25)=if( 58, 15)+rx*hf( 37, 15)
    hg( 38, 25)=if( 59, 15)+rx*hf( 38, 15)
    hg( 39, 25)=if( 60, 15)+rx*hf( 39, 15)
    hg( 40, 25)=if( 61, 15)+rx*hf( 40, 15)
    hg( 41, 25)=if( 62, 15)+rx*hf( 41, 15)
    hg( 42, 25)=if( 63, 15)+rx*hf( 42, 15)
    hg( 43, 25)=if( 64, 15)+rx*hf( 43, 15)
    hg( 44, 25)=if( 65, 15)+rx*hf( 44, 15)
    hg( 45, 25)=if( 66, 15)+rx*hf( 45, 15)
    hg( 46, 25)=if( 67, 15)+rx*hf( 46, 15)
    hg( 47, 25)=if( 68, 15)+rx*hf( 47, 15)
    hg( 48, 25)=if( 69, 15)+rx*hf( 48, 15)
    hg( 49, 25)=if( 70, 15)+rx*hf( 49, 15)
    hg( 50, 25)=if( 71, 15)+rx*hf( 50, 15)
    hg( 51, 25)=if( 72, 15)+rx*hf( 51, 15)
    hg( 52, 25)=if( 73, 15)+rx*hf( 52, 15)
    hg( 53, 25)=if( 74, 15)+rx*hf( 53, 15)
    hg( 54, 25)=if( 75, 15)+rx*hf( 54, 15)
    hg( 55, 25)=if( 76, 15)+rx*hf( 55, 15)
    hg( 56, 25)=if( 77, 15)+rx*hf( 56, 15)
    hg( 36, 26)=if( 57, 16)+rx*hf( 36, 16)
    hg( 37, 26)=if( 58, 16)+rx*hf( 37, 16)
    hg( 38, 26)=if( 59, 16)+rx*hf( 38, 16)
    hg( 39, 26)=if( 60, 16)+rx*hf( 39, 16)
    hg( 40, 26)=if( 61, 16)+rx*hf( 40, 16)
    hg( 41, 26)=if( 62, 16)+rx*hf( 41, 16)
    hg( 42, 26)=if( 63, 16)+rx*hf( 42, 16)
    hg( 43, 26)=if( 64, 16)+rx*hf( 43, 16)
    hg( 44, 26)=if( 65, 16)+rx*hf( 44, 16)
    hg( 45, 26)=if( 66, 16)+rx*hf( 45, 16)
    hg( 46, 26)=if( 67, 16)+rx*hf( 46, 16)
    hg( 47, 26)=if( 68, 16)+rx*hf( 47, 16)
    hg( 48, 26)=if( 69, 16)+rx*hf( 48, 16)
    hg( 49, 26)=if( 70, 16)+rx*hf( 49, 16)
    hg( 50, 26)=if( 71, 16)+rx*hf( 50, 16)
    hg( 51, 26)=if( 72, 16)+rx*hf( 51, 16)
    hg( 52, 26)=if( 73, 16)+rx*hf( 52, 16)
    hg( 53, 26)=if( 74, 16)+rx*hf( 53, 16)
    hg( 54, 26)=if( 75, 16)+rx*hf( 54, 16)
    hg( 55, 26)=if( 76, 16)+rx*hf( 55, 16)
    hg( 56, 26)=if( 77, 16)+rx*hf( 56, 16)
    hg( 36, 27)=if( 57, 17)+rx*hf( 36, 17)
    hg( 37, 27)=if( 58, 17)+rx*hf( 37, 17)
    hg( 38, 27)=if( 59, 17)+rx*hf( 38, 17)
    hg( 39, 27)=if( 60, 17)+rx*hf( 39, 17)
    hg( 40, 27)=if( 61, 17)+rx*hf( 40, 17)
    hg( 41, 27)=if( 62, 17)+rx*hf( 41, 17)
    hg( 42, 27)=if( 63, 17)+rx*hf( 42, 17)
    hg( 43, 27)=if( 64, 17)+rx*hf( 43, 17)
    hg( 44, 27)=if( 65, 17)+rx*hf( 44, 17)
    hg( 45, 27)=if( 66, 17)+rx*hf( 45, 17)
    hg( 46, 27)=if( 67, 17)+rx*hf( 46, 17)
    hg( 47, 27)=if( 68, 17)+rx*hf( 47, 17)
    hg( 48, 27)=if( 69, 17)+rx*hf( 48, 17)
    hg( 49, 27)=if( 70, 17)+rx*hf( 49, 17)
    hg( 50, 27)=if( 71, 17)+rx*hf( 50, 17)
    hg( 51, 27)=if( 72, 17)+rx*hf( 51, 17)
    hg( 52, 27)=if( 73, 17)+rx*hf( 52, 17)
    hg( 53, 27)=if( 74, 17)+rx*hf( 53, 17)
    hg( 54, 27)=if( 75, 17)+rx*hf( 54, 17)
    hg( 55, 27)=if( 76, 17)+rx*hf( 55, 17)
    hg( 56, 27)=if( 77, 17)+rx*hf( 56, 17)
    hg( 36, 28)=if( 57, 18)+rx*hf( 36, 18)
    hg( 37, 28)=if( 58, 18)+rx*hf( 37, 18)
    hg( 38, 28)=if( 59, 18)+rx*hf( 38, 18)
    hg( 39, 28)=if( 60, 18)+rx*hf( 39, 18)
    hg( 40, 28)=if( 61, 18)+rx*hf( 40, 18)
    hg( 41, 28)=if( 62, 18)+rx*hf( 41, 18)
    hg( 42, 28)=if( 63, 18)+rx*hf( 42, 18)
    hg( 43, 28)=if( 64, 18)+rx*hf( 43, 18)
    hg( 44, 28)=if( 65, 18)+rx*hf( 44, 18)
    hg( 45, 28)=if( 66, 18)+rx*hf( 45, 18)
    hg( 46, 28)=if( 67, 18)+rx*hf( 46, 18)
    hg( 47, 28)=if( 68, 18)+rx*hf( 47, 18)
    hg( 48, 28)=if( 69, 18)+rx*hf( 48, 18)
    hg( 49, 28)=if( 70, 18)+rx*hf( 49, 18)
    hg( 50, 28)=if( 71, 18)+rx*hf( 50, 18)
    hg( 51, 28)=if( 72, 18)+rx*hf( 51, 18)
    hg( 52, 28)=if( 73, 18)+rx*hf( 52, 18)
    hg( 53, 28)=if( 74, 18)+rx*hf( 53, 18)
    hg( 54, 28)=if( 75, 18)+rx*hf( 54, 18)
    hg( 55, 28)=if( 76, 18)+rx*hf( 55, 18)
    hg( 56, 28)=if( 77, 18)+rx*hf( 56, 18)
    hg( 36, 29)=if( 57, 19)+rx*hf( 36, 19)
    hg( 37, 29)=if( 58, 19)+rx*hf( 37, 19)
    hg( 38, 29)=if( 59, 19)+rx*hf( 38, 19)
    hg( 39, 29)=if( 60, 19)+rx*hf( 39, 19)
    hg( 40, 29)=if( 61, 19)+rx*hf( 40, 19)
    hg( 41, 29)=if( 62, 19)+rx*hf( 41, 19)
    hg( 42, 29)=if( 63, 19)+rx*hf( 42, 19)
    hg( 43, 29)=if( 64, 19)+rx*hf( 43, 19)
    hg( 44, 29)=if( 65, 19)+rx*hf( 44, 19)
    hg( 45, 29)=if( 66, 19)+rx*hf( 45, 19)
    hg( 46, 29)=if( 67, 19)+rx*hf( 46, 19)
    hg( 47, 29)=if( 68, 19)+rx*hf( 47, 19)
    hg( 48, 29)=if( 69, 19)+rx*hf( 48, 19)
    hg( 49, 29)=if( 70, 19)+rx*hf( 49, 19)
    hg( 50, 29)=if( 71, 19)+rx*hf( 50, 19)
    hg( 51, 29)=if( 72, 19)+rx*hf( 51, 19)
    hg( 52, 29)=if( 73, 19)+rx*hf( 52, 19)
    hg( 53, 29)=if( 74, 19)+rx*hf( 53, 19)
    hg( 54, 29)=if( 75, 19)+rx*hf( 54, 19)
    hg( 55, 29)=if( 76, 19)+rx*hf( 55, 19)
    hg( 56, 29)=if( 77, 19)+rx*hf( 56, 19)
    hg( 36, 30)=if( 57, 20)+rx*hf( 36, 20)
    hg( 37, 30)=if( 58, 20)+rx*hf( 37, 20)
    hg( 38, 30)=if( 59, 20)+rx*hf( 38, 20)
    hg( 39, 30)=if( 60, 20)+rx*hf( 39, 20)
    hg( 40, 30)=if( 61, 20)+rx*hf( 40, 20)
    hg( 41, 30)=if( 62, 20)+rx*hf( 41, 20)
    hg( 42, 30)=if( 63, 20)+rx*hf( 42, 20)
    hg( 43, 30)=if( 64, 20)+rx*hf( 43, 20)
    hg( 44, 30)=if( 65, 20)+rx*hf( 44, 20)
    hg( 45, 30)=if( 66, 20)+rx*hf( 45, 20)
    hg( 46, 30)=if( 67, 20)+rx*hf( 46, 20)
    hg( 47, 30)=if( 68, 20)+rx*hf( 47, 20)
    hg( 48, 30)=if( 69, 20)+rx*hf( 48, 20)
    hg( 49, 30)=if( 70, 20)+rx*hf( 49, 20)
    hg( 50, 30)=if( 71, 20)+rx*hf( 50, 20)
    hg( 51, 30)=if( 72, 20)+rx*hf( 51, 20)
    hg( 52, 30)=if( 73, 20)+rx*hf( 52, 20)
    hg( 53, 30)=if( 74, 20)+rx*hf( 53, 20)
    hg( 54, 30)=if( 75, 20)+rx*hf( 54, 20)
    hg( 55, 30)=if( 76, 20)+rx*hf( 55, 20)
    hg( 56, 30)=if( 77, 20)+rx*hf( 56, 20)
    hg( 36, 31)=if( 58, 17)+ry*hf( 36, 17)
    hg( 37, 31)=if( 60, 17)+ry*hf( 37, 17)
    hg( 38, 31)=if( 61, 17)+ry*hf( 38, 17)
    hg( 39, 31)=if( 63, 17)+ry*hf( 39, 17)
    hg( 40, 31)=if( 64, 17)+ry*hf( 40, 17)
    hg( 41, 31)=if( 65, 17)+ry*hf( 41, 17)
    hg( 42, 31)=if( 67, 17)+ry*hf( 42, 17)
    hg( 43, 31)=if( 68, 17)+ry*hf( 43, 17)
    hg( 44, 31)=if( 69, 17)+ry*hf( 44, 17)
    hg( 45, 31)=if( 70, 17)+ry*hf( 45, 17)
    hg( 46, 31)=if( 72, 17)+ry*hf( 46, 17)
    hg( 47, 31)=if( 73, 17)+ry*hf( 47, 17)
    hg( 48, 31)=if( 74, 17)+ry*hf( 48, 17)
    hg( 49, 31)=if( 75, 17)+ry*hf( 49, 17)
    hg( 50, 31)=if( 76, 17)+ry*hf( 50, 17)
    hg( 51, 31)=if( 78, 17)+ry*hf( 51, 17)
    hg( 52, 31)=if( 79, 17)+ry*hf( 52, 17)
    hg( 53, 31)=if( 80, 17)+ry*hf( 53, 17)
    hg( 54, 31)=if( 81, 17)+ry*hf( 54, 17)
    hg( 55, 31)=if( 82, 17)+ry*hf( 55, 17)
    hg( 56, 31)=if( 83, 17)+ry*hf( 56, 17)
    hg( 36, 32)=if( 58, 18)+ry*hf( 36, 18)
    hg( 37, 32)=if( 60, 18)+ry*hf( 37, 18)
    hg( 38, 32)=if( 61, 18)+ry*hf( 38, 18)
    hg( 39, 32)=if( 63, 18)+ry*hf( 39, 18)
    hg( 40, 32)=if( 64, 18)+ry*hf( 40, 18)
    hg( 41, 32)=if( 65, 18)+ry*hf( 41, 18)
    hg( 42, 32)=if( 67, 18)+ry*hf( 42, 18)
    hg( 43, 32)=if( 68, 18)+ry*hf( 43, 18)
    hg( 44, 32)=if( 69, 18)+ry*hf( 44, 18)
    hg( 45, 32)=if( 70, 18)+ry*hf( 45, 18)
    hg( 46, 32)=if( 72, 18)+ry*hf( 46, 18)
    hg( 47, 32)=if( 73, 18)+ry*hf( 47, 18)
    hg( 48, 32)=if( 74, 18)+ry*hf( 48, 18)
    hg( 49, 32)=if( 75, 18)+ry*hf( 49, 18)
    hg( 50, 32)=if( 76, 18)+ry*hf( 50, 18)
    hg( 51, 32)=if( 78, 18)+ry*hf( 51, 18)
    hg( 52, 32)=if( 79, 18)+ry*hf( 52, 18)
    hg( 53, 32)=if( 80, 18)+ry*hf( 53, 18)
    hg( 54, 32)=if( 81, 18)+ry*hf( 54, 18)
    hg( 55, 32)=if( 82, 18)+ry*hf( 55, 18)
    hg( 56, 32)=if( 83, 18)+ry*hf( 56, 18)
    hg( 36, 33)=if( 58, 19)+ry*hf( 36, 19)
    hg( 37, 33)=if( 60, 19)+ry*hf( 37, 19)
    hg( 38, 33)=if( 61, 19)+ry*hf( 38, 19)
    hg( 39, 33)=if( 63, 19)+ry*hf( 39, 19)
    hg( 40, 33)=if( 64, 19)+ry*hf( 40, 19)
    hg( 41, 33)=if( 65, 19)+ry*hf( 41, 19)
    hg( 42, 33)=if( 67, 19)+ry*hf( 42, 19)
    hg( 43, 33)=if( 68, 19)+ry*hf( 43, 19)
    hg( 44, 33)=if( 69, 19)+ry*hf( 44, 19)
    hg( 45, 33)=if( 70, 19)+ry*hf( 45, 19)
    hg( 46, 33)=if( 72, 19)+ry*hf( 46, 19)
    hg( 47, 33)=if( 73, 19)+ry*hf( 47, 19)
    hg( 48, 33)=if( 74, 19)+ry*hf( 48, 19)
    hg( 49, 33)=if( 75, 19)+ry*hf( 49, 19)
    hg( 50, 33)=if( 76, 19)+ry*hf( 50, 19)
    hg( 51, 33)=if( 78, 19)+ry*hf( 51, 19)
    hg( 52, 33)=if( 79, 19)+ry*hf( 52, 19)
    hg( 53, 33)=if( 80, 19)+ry*hf( 53, 19)
    hg( 54, 33)=if( 81, 19)+ry*hf( 54, 19)
    hg( 55, 33)=if( 82, 19)+ry*hf( 55, 19)
    hg( 56, 33)=if( 83, 19)+ry*hf( 56, 19)
    hg( 36, 34)=if( 58, 20)+ry*hf( 36, 20)
    hg( 37, 34)=if( 60, 20)+ry*hf( 37, 20)
    hg( 38, 34)=if( 61, 20)+ry*hf( 38, 20)
    hg( 39, 34)=if( 63, 20)+ry*hf( 39, 20)
    hg( 40, 34)=if( 64, 20)+ry*hf( 40, 20)
    hg( 41, 34)=if( 65, 20)+ry*hf( 41, 20)
    hg( 42, 34)=if( 67, 20)+ry*hf( 42, 20)
    hg( 43, 34)=if( 68, 20)+ry*hf( 43, 20)
    hg( 44, 34)=if( 69, 20)+ry*hf( 44, 20)
    hg( 45, 34)=if( 70, 20)+ry*hf( 45, 20)
    hg( 46, 34)=if( 72, 20)+ry*hf( 46, 20)
    hg( 47, 34)=if( 73, 20)+ry*hf( 47, 20)
    hg( 48, 34)=if( 74, 20)+ry*hf( 48, 20)
    hg( 49, 34)=if( 75, 20)+ry*hf( 49, 20)
    hg( 50, 34)=if( 76, 20)+ry*hf( 50, 20)
    hg( 51, 34)=if( 78, 20)+ry*hf( 51, 20)
    hg( 52, 34)=if( 79, 20)+ry*hf( 52, 20)
    hg( 53, 34)=if( 80, 20)+ry*hf( 53, 20)
    hg( 54, 34)=if( 81, 20)+ry*hf( 54, 20)
    hg( 55, 34)=if( 82, 20)+ry*hf( 55, 20)
    hg( 56, 34)=if( 83, 20)+ry*hf( 56, 20)
    hg( 36, 35)=if( 59, 20)+rz*hf( 36, 20)
    hg( 37, 35)=if( 61, 20)+rz*hf( 37, 20)
    hg( 38, 35)=if( 62, 20)+rz*hf( 38, 20)
    hg( 39, 35)=if( 64, 20)+rz*hf( 39, 20)
    hg( 40, 35)=if( 65, 20)+rz*hf( 40, 20)
    hg( 41, 35)=if( 66, 20)+rz*hf( 41, 20)
    hg( 42, 35)=if( 68, 20)+rz*hf( 42, 20)
    hg( 43, 35)=if( 69, 20)+rz*hf( 43, 20)
    hg( 44, 35)=if( 70, 20)+rz*hf( 44, 20)
    hg( 45, 35)=if( 71, 20)+rz*hf( 45, 20)
    hg( 46, 35)=if( 73, 20)+rz*hf( 46, 20)
    hg( 47, 35)=if( 74, 20)+rz*hf( 47, 20)
    hg( 48, 35)=if( 75, 20)+rz*hf( 48, 20)
    hg( 49, 35)=if( 76, 20)+rz*hf( 49, 20)
    hg( 50, 35)=if( 77, 20)+rz*hf( 50, 20)
    hg( 51, 35)=if( 79, 20)+rz*hf( 51, 20)
    hg( 52, 35)=if( 80, 20)+rz*hf( 52, 20)
    hg( 53, 35)=if( 81, 20)+rz*hf( 53, 20)
    hg( 54, 35)=if( 82, 20)+rz*hf( 54, 20)
    hg( 55, 35)=if( 83, 20)+rz*hf( 55, 20)
    hg( 56, 35)=if( 84, 20)+rz*hf( 56, 20)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_ig( )
    ig( 57, 21)=jf( 85, 11)+rx*if( 57, 11)
    ig( 58, 21)=jf( 86, 11)+rx*if( 58, 11)
    ig( 59, 21)=jf( 87, 11)+rx*if( 59, 11)
    ig( 60, 21)=jf( 88, 11)+rx*if( 60, 11)
    ig( 61, 21)=jf( 89, 11)+rx*if( 61, 11)
    ig( 62, 21)=jf( 90, 11)+rx*if( 62, 11)
    ig( 63, 21)=jf( 91, 11)+rx*if( 63, 11)
    ig( 64, 21)=jf( 92, 11)+rx*if( 64, 11)
    ig( 65, 21)=jf( 93, 11)+rx*if( 65, 11)
    ig( 66, 21)=jf( 94, 11)+rx*if( 66, 11)
    ig( 67, 21)=jf( 95, 11)+rx*if( 67, 11)
    ig( 68, 21)=jf( 96, 11)+rx*if( 68, 11)
    ig( 69, 21)=jf( 97, 11)+rx*if( 69, 11)
    ig( 70, 21)=jf( 98, 11)+rx*if( 70, 11)
    ig( 71, 21)=jf( 99, 11)+rx*if( 71, 11)
    ig( 72, 21)=jf(100, 11)+rx*if( 72, 11)
    ig( 73, 21)=jf(101, 11)+rx*if( 73, 11)
    ig( 74, 21)=jf(102, 11)+rx*if( 74, 11)
    ig( 75, 21)=jf(103, 11)+rx*if( 75, 11)
    ig( 76, 21)=jf(104, 11)+rx*if( 76, 11)
    ig( 77, 21)=jf(105, 11)+rx*if( 77, 11)
    ig( 78, 21)=jf(106, 11)+rx*if( 78, 11)
    ig( 79, 21)=jf(107, 11)+rx*if( 79, 11)
    ig( 80, 21)=jf(108, 11)+rx*if( 80, 11)
    ig( 81, 21)=jf(109, 11)+rx*if( 81, 11)
    ig( 82, 21)=jf(110, 11)+rx*if( 82, 11)
    ig( 83, 21)=jf(111, 11)+rx*if( 83, 11)
    ig( 84, 21)=jf(112, 11)+rx*if( 84, 11)
    ig( 57, 22)=jf( 85, 12)+rx*if( 57, 12)
    ig( 58, 22)=jf( 86, 12)+rx*if( 58, 12)
    ig( 59, 22)=jf( 87, 12)+rx*if( 59, 12)
    ig( 60, 22)=jf( 88, 12)+rx*if( 60, 12)
    ig( 61, 22)=jf( 89, 12)+rx*if( 61, 12)
    ig( 62, 22)=jf( 90, 12)+rx*if( 62, 12)
    ig( 63, 22)=jf( 91, 12)+rx*if( 63, 12)
    ig( 64, 22)=jf( 92, 12)+rx*if( 64, 12)
    ig( 65, 22)=jf( 93, 12)+rx*if( 65, 12)
    ig( 66, 22)=jf( 94, 12)+rx*if( 66, 12)
    ig( 67, 22)=jf( 95, 12)+rx*if( 67, 12)
    ig( 68, 22)=jf( 96, 12)+rx*if( 68, 12)
    ig( 69, 22)=jf( 97, 12)+rx*if( 69, 12)
    ig( 70, 22)=jf( 98, 12)+rx*if( 70, 12)
    ig( 71, 22)=jf( 99, 12)+rx*if( 71, 12)
    ig( 72, 22)=jf(100, 12)+rx*if( 72, 12)
    ig( 73, 22)=jf(101, 12)+rx*if( 73, 12)
    ig( 74, 22)=jf(102, 12)+rx*if( 74, 12)
    ig( 75, 22)=jf(103, 12)+rx*if( 75, 12)
    ig( 76, 22)=jf(104, 12)+rx*if( 76, 12)
    ig( 77, 22)=jf(105, 12)+rx*if( 77, 12)
    ig( 78, 22)=jf(106, 12)+rx*if( 78, 12)
    ig( 79, 22)=jf(107, 12)+rx*if( 79, 12)
    ig( 80, 22)=jf(108, 12)+rx*if( 80, 12)
    ig( 81, 22)=jf(109, 12)+rx*if( 81, 12)
    ig( 82, 22)=jf(110, 12)+rx*if( 82, 12)
    ig( 83, 22)=jf(111, 12)+rx*if( 83, 12)
    ig( 84, 22)=jf(112, 12)+rx*if( 84, 12)
    ig( 57, 23)=jf( 85, 13)+rx*if( 57, 13)
    ig( 58, 23)=jf( 86, 13)+rx*if( 58, 13)
    ig( 59, 23)=jf( 87, 13)+rx*if( 59, 13)
    ig( 60, 23)=jf( 88, 13)+rx*if( 60, 13)
    ig( 61, 23)=jf( 89, 13)+rx*if( 61, 13)
    ig( 62, 23)=jf( 90, 13)+rx*if( 62, 13)
    ig( 63, 23)=jf( 91, 13)+rx*if( 63, 13)
    ig( 64, 23)=jf( 92, 13)+rx*if( 64, 13)
    ig( 65, 23)=jf( 93, 13)+rx*if( 65, 13)
    ig( 66, 23)=jf( 94, 13)+rx*if( 66, 13)
    ig( 67, 23)=jf( 95, 13)+rx*if( 67, 13)
    ig( 68, 23)=jf( 96, 13)+rx*if( 68, 13)
    ig( 69, 23)=jf( 97, 13)+rx*if( 69, 13)
    ig( 70, 23)=jf( 98, 13)+rx*if( 70, 13)
    ig( 71, 23)=jf( 99, 13)+rx*if( 71, 13)
    ig( 72, 23)=jf(100, 13)+rx*if( 72, 13)
    ig( 73, 23)=jf(101, 13)+rx*if( 73, 13)
    ig( 74, 23)=jf(102, 13)+rx*if( 74, 13)
    ig( 75, 23)=jf(103, 13)+rx*if( 75, 13)
    ig( 76, 23)=jf(104, 13)+rx*if( 76, 13)
    ig( 77, 23)=jf(105, 13)+rx*if( 77, 13)
    ig( 78, 23)=jf(106, 13)+rx*if( 78, 13)
    ig( 79, 23)=jf(107, 13)+rx*if( 79, 13)
    ig( 80, 23)=jf(108, 13)+rx*if( 80, 13)
    ig( 81, 23)=jf(109, 13)+rx*if( 81, 13)
    ig( 82, 23)=jf(110, 13)+rx*if( 82, 13)
    ig( 83, 23)=jf(111, 13)+rx*if( 83, 13)
    ig( 84, 23)=jf(112, 13)+rx*if( 84, 13)
    ig( 57, 24)=jf( 85, 14)+rx*if( 57, 14)
    ig( 58, 24)=jf( 86, 14)+rx*if( 58, 14)
    ig( 59, 24)=jf( 87, 14)+rx*if( 59, 14)
    ig( 60, 24)=jf( 88, 14)+rx*if( 60, 14)
    ig( 61, 24)=jf( 89, 14)+rx*if( 61, 14)
    ig( 62, 24)=jf( 90, 14)+rx*if( 62, 14)
    ig( 63, 24)=jf( 91, 14)+rx*if( 63, 14)
    ig( 64, 24)=jf( 92, 14)+rx*if( 64, 14)
    ig( 65, 24)=jf( 93, 14)+rx*if( 65, 14)
    ig( 66, 24)=jf( 94, 14)+rx*if( 66, 14)
    ig( 67, 24)=jf( 95, 14)+rx*if( 67, 14)
    ig( 68, 24)=jf( 96, 14)+rx*if( 68, 14)
    ig( 69, 24)=jf( 97, 14)+rx*if( 69, 14)
    ig( 70, 24)=jf( 98, 14)+rx*if( 70, 14)
    ig( 71, 24)=jf( 99, 14)+rx*if( 71, 14)
    ig( 72, 24)=jf(100, 14)+rx*if( 72, 14)
    ig( 73, 24)=jf(101, 14)+rx*if( 73, 14)
    ig( 74, 24)=jf(102, 14)+rx*if( 74, 14)
    ig( 75, 24)=jf(103, 14)+rx*if( 75, 14)
    ig( 76, 24)=jf(104, 14)+rx*if( 76, 14)
    ig( 77, 24)=jf(105, 14)+rx*if( 77, 14)
    ig( 78, 24)=jf(106, 14)+rx*if( 78, 14)
    ig( 79, 24)=jf(107, 14)+rx*if( 79, 14)
    ig( 80, 24)=jf(108, 14)+rx*if( 80, 14)
    ig( 81, 24)=jf(109, 14)+rx*if( 81, 14)
    ig( 82, 24)=jf(110, 14)+rx*if( 82, 14)
    ig( 83, 24)=jf(111, 14)+rx*if( 83, 14)
    ig( 84, 24)=jf(112, 14)+rx*if( 84, 14)
    ig( 57, 25)=jf( 85, 15)+rx*if( 57, 15)
    ig( 58, 25)=jf( 86, 15)+rx*if( 58, 15)
    ig( 59, 25)=jf( 87, 15)+rx*if( 59, 15)
    ig( 60, 25)=jf( 88, 15)+rx*if( 60, 15)
    ig( 61, 25)=jf( 89, 15)+rx*if( 61, 15)
    ig( 62, 25)=jf( 90, 15)+rx*if( 62, 15)
    ig( 63, 25)=jf( 91, 15)+rx*if( 63, 15)
    ig( 64, 25)=jf( 92, 15)+rx*if( 64, 15)
    ig( 65, 25)=jf( 93, 15)+rx*if( 65, 15)
    ig( 66, 25)=jf( 94, 15)+rx*if( 66, 15)
    ig( 67, 25)=jf( 95, 15)+rx*if( 67, 15)
    ig( 68, 25)=jf( 96, 15)+rx*if( 68, 15)
    ig( 69, 25)=jf( 97, 15)+rx*if( 69, 15)
    ig( 70, 25)=jf( 98, 15)+rx*if( 70, 15)
    ig( 71, 25)=jf( 99, 15)+rx*if( 71, 15)
    ig( 72, 25)=jf(100, 15)+rx*if( 72, 15)
    ig( 73, 25)=jf(101, 15)+rx*if( 73, 15)
    ig( 74, 25)=jf(102, 15)+rx*if( 74, 15)
    ig( 75, 25)=jf(103, 15)+rx*if( 75, 15)
    ig( 76, 25)=jf(104, 15)+rx*if( 76, 15)
    ig( 77, 25)=jf(105, 15)+rx*if( 77, 15)
    ig( 78, 25)=jf(106, 15)+rx*if( 78, 15)
    ig( 79, 25)=jf(107, 15)+rx*if( 79, 15)
    ig( 80, 25)=jf(108, 15)+rx*if( 80, 15)
    ig( 81, 25)=jf(109, 15)+rx*if( 81, 15)
    ig( 82, 25)=jf(110, 15)+rx*if( 82, 15)
    ig( 83, 25)=jf(111, 15)+rx*if( 83, 15)
    ig( 84, 25)=jf(112, 15)+rx*if( 84, 15)
    ig( 57, 26)=jf( 85, 16)+rx*if( 57, 16)
    ig( 58, 26)=jf( 86, 16)+rx*if( 58, 16)
    ig( 59, 26)=jf( 87, 16)+rx*if( 59, 16)
    ig( 60, 26)=jf( 88, 16)+rx*if( 60, 16)
    ig( 61, 26)=jf( 89, 16)+rx*if( 61, 16)
    ig( 62, 26)=jf( 90, 16)+rx*if( 62, 16)
    ig( 63, 26)=jf( 91, 16)+rx*if( 63, 16)
    ig( 64, 26)=jf( 92, 16)+rx*if( 64, 16)
    ig( 65, 26)=jf( 93, 16)+rx*if( 65, 16)
    ig( 66, 26)=jf( 94, 16)+rx*if( 66, 16)
    ig( 67, 26)=jf( 95, 16)+rx*if( 67, 16)
    ig( 68, 26)=jf( 96, 16)+rx*if( 68, 16)
    ig( 69, 26)=jf( 97, 16)+rx*if( 69, 16)
    ig( 70, 26)=jf( 98, 16)+rx*if( 70, 16)
    ig( 71, 26)=jf( 99, 16)+rx*if( 71, 16)
    ig( 72, 26)=jf(100, 16)+rx*if( 72, 16)
    ig( 73, 26)=jf(101, 16)+rx*if( 73, 16)
    ig( 74, 26)=jf(102, 16)+rx*if( 74, 16)
    ig( 75, 26)=jf(103, 16)+rx*if( 75, 16)
    ig( 76, 26)=jf(104, 16)+rx*if( 76, 16)
    ig( 77, 26)=jf(105, 16)+rx*if( 77, 16)
    ig( 78, 26)=jf(106, 16)+rx*if( 78, 16)
    ig( 79, 26)=jf(107, 16)+rx*if( 79, 16)
    ig( 80, 26)=jf(108, 16)+rx*if( 80, 16)
    ig( 81, 26)=jf(109, 16)+rx*if( 81, 16)
    ig( 82, 26)=jf(110, 16)+rx*if( 82, 16)
    ig( 83, 26)=jf(111, 16)+rx*if( 83, 16)
    ig( 84, 26)=jf(112, 16)+rx*if( 84, 16)
    ig( 57, 27)=jf( 85, 17)+rx*if( 57, 17)
    ig( 58, 27)=jf( 86, 17)+rx*if( 58, 17)
    ig( 59, 27)=jf( 87, 17)+rx*if( 59, 17)
    ig( 60, 27)=jf( 88, 17)+rx*if( 60, 17)
    ig( 61, 27)=jf( 89, 17)+rx*if( 61, 17)
    ig( 62, 27)=jf( 90, 17)+rx*if( 62, 17)
    ig( 63, 27)=jf( 91, 17)+rx*if( 63, 17)
    ig( 64, 27)=jf( 92, 17)+rx*if( 64, 17)
    ig( 65, 27)=jf( 93, 17)+rx*if( 65, 17)
    ig( 66, 27)=jf( 94, 17)+rx*if( 66, 17)
    ig( 67, 27)=jf( 95, 17)+rx*if( 67, 17)
    ig( 68, 27)=jf( 96, 17)+rx*if( 68, 17)
    ig( 69, 27)=jf( 97, 17)+rx*if( 69, 17)
    ig( 70, 27)=jf( 98, 17)+rx*if( 70, 17)
    ig( 71, 27)=jf( 99, 17)+rx*if( 71, 17)
    ig( 72, 27)=jf(100, 17)+rx*if( 72, 17)
    ig( 73, 27)=jf(101, 17)+rx*if( 73, 17)
    ig( 74, 27)=jf(102, 17)+rx*if( 74, 17)
    ig( 75, 27)=jf(103, 17)+rx*if( 75, 17)
    ig( 76, 27)=jf(104, 17)+rx*if( 76, 17)
    ig( 77, 27)=jf(105, 17)+rx*if( 77, 17)
    ig( 78, 27)=jf(106, 17)+rx*if( 78, 17)
    ig( 79, 27)=jf(107, 17)+rx*if( 79, 17)
    ig( 80, 27)=jf(108, 17)+rx*if( 80, 17)
    ig( 81, 27)=jf(109, 17)+rx*if( 81, 17)
    ig( 82, 27)=jf(110, 17)+rx*if( 82, 17)
    ig( 83, 27)=jf(111, 17)+rx*if( 83, 17)
    ig( 84, 27)=jf(112, 17)+rx*if( 84, 17)
    ig( 57, 28)=jf( 85, 18)+rx*if( 57, 18)
    ig( 58, 28)=jf( 86, 18)+rx*if( 58, 18)
    ig( 59, 28)=jf( 87, 18)+rx*if( 59, 18)
    ig( 60, 28)=jf( 88, 18)+rx*if( 60, 18)
    ig( 61, 28)=jf( 89, 18)+rx*if( 61, 18)
    ig( 62, 28)=jf( 90, 18)+rx*if( 62, 18)
    ig( 63, 28)=jf( 91, 18)+rx*if( 63, 18)
    ig( 64, 28)=jf( 92, 18)+rx*if( 64, 18)
    ig( 65, 28)=jf( 93, 18)+rx*if( 65, 18)
    ig( 66, 28)=jf( 94, 18)+rx*if( 66, 18)
    ig( 67, 28)=jf( 95, 18)+rx*if( 67, 18)
    ig( 68, 28)=jf( 96, 18)+rx*if( 68, 18)
    ig( 69, 28)=jf( 97, 18)+rx*if( 69, 18)
    ig( 70, 28)=jf( 98, 18)+rx*if( 70, 18)
    ig( 71, 28)=jf( 99, 18)+rx*if( 71, 18)
    ig( 72, 28)=jf(100, 18)+rx*if( 72, 18)
    ig( 73, 28)=jf(101, 18)+rx*if( 73, 18)
    ig( 74, 28)=jf(102, 18)+rx*if( 74, 18)
    ig( 75, 28)=jf(103, 18)+rx*if( 75, 18)
    ig( 76, 28)=jf(104, 18)+rx*if( 76, 18)
    ig( 77, 28)=jf(105, 18)+rx*if( 77, 18)
    ig( 78, 28)=jf(106, 18)+rx*if( 78, 18)
    ig( 79, 28)=jf(107, 18)+rx*if( 79, 18)
    ig( 80, 28)=jf(108, 18)+rx*if( 80, 18)
    ig( 81, 28)=jf(109, 18)+rx*if( 81, 18)
    ig( 82, 28)=jf(110, 18)+rx*if( 82, 18)
    ig( 83, 28)=jf(111, 18)+rx*if( 83, 18)
    ig( 84, 28)=jf(112, 18)+rx*if( 84, 18)
    ig( 57, 29)=jf( 85, 19)+rx*if( 57, 19)
    ig( 58, 29)=jf( 86, 19)+rx*if( 58, 19)
    ig( 59, 29)=jf( 87, 19)+rx*if( 59, 19)
    ig( 60, 29)=jf( 88, 19)+rx*if( 60, 19)
    ig( 61, 29)=jf( 89, 19)+rx*if( 61, 19)
    ig( 62, 29)=jf( 90, 19)+rx*if( 62, 19)
    ig( 63, 29)=jf( 91, 19)+rx*if( 63, 19)
    ig( 64, 29)=jf( 92, 19)+rx*if( 64, 19)
    ig( 65, 29)=jf( 93, 19)+rx*if( 65, 19)
    ig( 66, 29)=jf( 94, 19)+rx*if( 66, 19)
    ig( 67, 29)=jf( 95, 19)+rx*if( 67, 19)
    ig( 68, 29)=jf( 96, 19)+rx*if( 68, 19)
    ig( 69, 29)=jf( 97, 19)+rx*if( 69, 19)
    ig( 70, 29)=jf( 98, 19)+rx*if( 70, 19)
    ig( 71, 29)=jf( 99, 19)+rx*if( 71, 19)
    ig( 72, 29)=jf(100, 19)+rx*if( 72, 19)
    ig( 73, 29)=jf(101, 19)+rx*if( 73, 19)
    ig( 74, 29)=jf(102, 19)+rx*if( 74, 19)
    ig( 75, 29)=jf(103, 19)+rx*if( 75, 19)
    ig( 76, 29)=jf(104, 19)+rx*if( 76, 19)
    ig( 77, 29)=jf(105, 19)+rx*if( 77, 19)
    ig( 78, 29)=jf(106, 19)+rx*if( 78, 19)
    ig( 79, 29)=jf(107, 19)+rx*if( 79, 19)
    ig( 80, 29)=jf(108, 19)+rx*if( 80, 19)
    ig( 81, 29)=jf(109, 19)+rx*if( 81, 19)
    ig( 82, 29)=jf(110, 19)+rx*if( 82, 19)
    ig( 83, 29)=jf(111, 19)+rx*if( 83, 19)
    ig( 84, 29)=jf(112, 19)+rx*if( 84, 19)
    ig( 57, 30)=jf( 85, 20)+rx*if( 57, 20)
    ig( 58, 30)=jf( 86, 20)+rx*if( 58, 20)
    ig( 59, 30)=jf( 87, 20)+rx*if( 59, 20)
    ig( 60, 30)=jf( 88, 20)+rx*if( 60, 20)
    ig( 61, 30)=jf( 89, 20)+rx*if( 61, 20)
    ig( 62, 30)=jf( 90, 20)+rx*if( 62, 20)
    ig( 63, 30)=jf( 91, 20)+rx*if( 63, 20)
    ig( 64, 30)=jf( 92, 20)+rx*if( 64, 20)
    ig( 65, 30)=jf( 93, 20)+rx*if( 65, 20)
    ig( 66, 30)=jf( 94, 20)+rx*if( 66, 20)
    ig( 67, 30)=jf( 95, 20)+rx*if( 67, 20)
    ig( 68, 30)=jf( 96, 20)+rx*if( 68, 20)
    ig( 69, 30)=jf( 97, 20)+rx*if( 69, 20)
    ig( 70, 30)=jf( 98, 20)+rx*if( 70, 20)
    ig( 71, 30)=jf( 99, 20)+rx*if( 71, 20)
    ig( 72, 30)=jf(100, 20)+rx*if( 72, 20)
    ig( 73, 30)=jf(101, 20)+rx*if( 73, 20)
    ig( 74, 30)=jf(102, 20)+rx*if( 74, 20)
    ig( 75, 30)=jf(103, 20)+rx*if( 75, 20)
    ig( 76, 30)=jf(104, 20)+rx*if( 76, 20)
    ig( 77, 30)=jf(105, 20)+rx*if( 77, 20)
    ig( 78, 30)=jf(106, 20)+rx*if( 78, 20)
    ig( 79, 30)=jf(107, 20)+rx*if( 79, 20)
    ig( 80, 30)=jf(108, 20)+rx*if( 80, 20)
    ig( 81, 30)=jf(109, 20)+rx*if( 81, 20)
    ig( 82, 30)=jf(110, 20)+rx*if( 82, 20)
    ig( 83, 30)=jf(111, 20)+rx*if( 83, 20)
    ig( 84, 30)=jf(112, 20)+rx*if( 84, 20)
    ig( 57, 31)=jf( 86, 17)+ry*if( 57, 17)
    ig( 58, 31)=jf( 88, 17)+ry*if( 58, 17)
    ig( 59, 31)=jf( 89, 17)+ry*if( 59, 17)
    ig( 60, 31)=jf( 91, 17)+ry*if( 60, 17)
    ig( 61, 31)=jf( 92, 17)+ry*if( 61, 17)
    ig( 62, 31)=jf( 93, 17)+ry*if( 62, 17)
    ig( 63, 31)=jf( 95, 17)+ry*if( 63, 17)
    ig( 64, 31)=jf( 96, 17)+ry*if( 64, 17)
    ig( 65, 31)=jf( 97, 17)+ry*if( 65, 17)
    ig( 66, 31)=jf( 98, 17)+ry*if( 66, 17)
    ig( 67, 31)=jf(100, 17)+ry*if( 67, 17)
    ig( 68, 31)=jf(101, 17)+ry*if( 68, 17)
    ig( 69, 31)=jf(102, 17)+ry*if( 69, 17)
    ig( 70, 31)=jf(103, 17)+ry*if( 70, 17)
    ig( 71, 31)=jf(104, 17)+ry*if( 71, 17)
    ig( 72, 31)=jf(106, 17)+ry*if( 72, 17)
    ig( 73, 31)=jf(107, 17)+ry*if( 73, 17)
    ig( 74, 31)=jf(108, 17)+ry*if( 74, 17)
    ig( 75, 31)=jf(109, 17)+ry*if( 75, 17)
    ig( 76, 31)=jf(110, 17)+ry*if( 76, 17)
    ig( 77, 31)=jf(111, 17)+ry*if( 77, 17)
    ig( 78, 31)=jf(113, 17)+ry*if( 78, 17)
    ig( 79, 31)=jf(114, 17)+ry*if( 79, 17)
    ig( 80, 31)=jf(115, 17)+ry*if( 80, 17)
    ig( 81, 31)=jf(116, 17)+ry*if( 81, 17)
    ig( 82, 31)=jf(117, 17)+ry*if( 82, 17)
    ig( 83, 31)=jf(118, 17)+ry*if( 83, 17)
    ig( 84, 31)=jf(119, 17)+ry*if( 84, 17)
    ig( 57, 32)=jf( 86, 18)+ry*if( 57, 18)
    ig( 58, 32)=jf( 88, 18)+ry*if( 58, 18)
    ig( 59, 32)=jf( 89, 18)+ry*if( 59, 18)
    ig( 60, 32)=jf( 91, 18)+ry*if( 60, 18)
    ig( 61, 32)=jf( 92, 18)+ry*if( 61, 18)
    ig( 62, 32)=jf( 93, 18)+ry*if( 62, 18)
    ig( 63, 32)=jf( 95, 18)+ry*if( 63, 18)
    ig( 64, 32)=jf( 96, 18)+ry*if( 64, 18)
    ig( 65, 32)=jf( 97, 18)+ry*if( 65, 18)
    ig( 66, 32)=jf( 98, 18)+ry*if( 66, 18)
    ig( 67, 32)=jf(100, 18)+ry*if( 67, 18)
    ig( 68, 32)=jf(101, 18)+ry*if( 68, 18)
    ig( 69, 32)=jf(102, 18)+ry*if( 69, 18)
    ig( 70, 32)=jf(103, 18)+ry*if( 70, 18)
    ig( 71, 32)=jf(104, 18)+ry*if( 71, 18)
    ig( 72, 32)=jf(106, 18)+ry*if( 72, 18)
    ig( 73, 32)=jf(107, 18)+ry*if( 73, 18)
    ig( 74, 32)=jf(108, 18)+ry*if( 74, 18)
    ig( 75, 32)=jf(109, 18)+ry*if( 75, 18)
    ig( 76, 32)=jf(110, 18)+ry*if( 76, 18)
    ig( 77, 32)=jf(111, 18)+ry*if( 77, 18)
    ig( 78, 32)=jf(113, 18)+ry*if( 78, 18)
    ig( 79, 32)=jf(114, 18)+ry*if( 79, 18)
    ig( 80, 32)=jf(115, 18)+ry*if( 80, 18)
    ig( 81, 32)=jf(116, 18)+ry*if( 81, 18)
    ig( 82, 32)=jf(117, 18)+ry*if( 82, 18)
    ig( 83, 32)=jf(118, 18)+ry*if( 83, 18)
    ig( 84, 32)=jf(119, 18)+ry*if( 84, 18)
    ig( 57, 33)=jf( 86, 19)+ry*if( 57, 19)
    ig( 58, 33)=jf( 88, 19)+ry*if( 58, 19)
    ig( 59, 33)=jf( 89, 19)+ry*if( 59, 19)
    ig( 60, 33)=jf( 91, 19)+ry*if( 60, 19)
    ig( 61, 33)=jf( 92, 19)+ry*if( 61, 19)
    ig( 62, 33)=jf( 93, 19)+ry*if( 62, 19)
    ig( 63, 33)=jf( 95, 19)+ry*if( 63, 19)
    ig( 64, 33)=jf( 96, 19)+ry*if( 64, 19)
    ig( 65, 33)=jf( 97, 19)+ry*if( 65, 19)
    ig( 66, 33)=jf( 98, 19)+ry*if( 66, 19)
    ig( 67, 33)=jf(100, 19)+ry*if( 67, 19)
    ig( 68, 33)=jf(101, 19)+ry*if( 68, 19)
    ig( 69, 33)=jf(102, 19)+ry*if( 69, 19)
    ig( 70, 33)=jf(103, 19)+ry*if( 70, 19)
    ig( 71, 33)=jf(104, 19)+ry*if( 71, 19)
    ig( 72, 33)=jf(106, 19)+ry*if( 72, 19)
    ig( 73, 33)=jf(107, 19)+ry*if( 73, 19)
    ig( 74, 33)=jf(108, 19)+ry*if( 74, 19)
    ig( 75, 33)=jf(109, 19)+ry*if( 75, 19)
    ig( 76, 33)=jf(110, 19)+ry*if( 76, 19)
    ig( 77, 33)=jf(111, 19)+ry*if( 77, 19)
    ig( 78, 33)=jf(113, 19)+ry*if( 78, 19)
    ig( 79, 33)=jf(114, 19)+ry*if( 79, 19)
    ig( 80, 33)=jf(115, 19)+ry*if( 80, 19)
    ig( 81, 33)=jf(116, 19)+ry*if( 81, 19)
    ig( 82, 33)=jf(117, 19)+ry*if( 82, 19)
    ig( 83, 33)=jf(118, 19)+ry*if( 83, 19)
    ig( 84, 33)=jf(119, 19)+ry*if( 84, 19)
    ig( 57, 34)=jf( 86, 20)+ry*if( 57, 20)
    ig( 58, 34)=jf( 88, 20)+ry*if( 58, 20)
    ig( 59, 34)=jf( 89, 20)+ry*if( 59, 20)
    ig( 60, 34)=jf( 91, 20)+ry*if( 60, 20)
    ig( 61, 34)=jf( 92, 20)+ry*if( 61, 20)
    ig( 62, 34)=jf( 93, 20)+ry*if( 62, 20)
    ig( 63, 34)=jf( 95, 20)+ry*if( 63, 20)
    ig( 64, 34)=jf( 96, 20)+ry*if( 64, 20)
    ig( 65, 34)=jf( 97, 20)+ry*if( 65, 20)
    ig( 66, 34)=jf( 98, 20)+ry*if( 66, 20)
    ig( 67, 34)=jf(100, 20)+ry*if( 67, 20)
    ig( 68, 34)=jf(101, 20)+ry*if( 68, 20)
    ig( 69, 34)=jf(102, 20)+ry*if( 69, 20)
    ig( 70, 34)=jf(103, 20)+ry*if( 70, 20)
    ig( 71, 34)=jf(104, 20)+ry*if( 71, 20)
    ig( 72, 34)=jf(106, 20)+ry*if( 72, 20)
    ig( 73, 34)=jf(107, 20)+ry*if( 73, 20)
    ig( 74, 34)=jf(108, 20)+ry*if( 74, 20)
    ig( 75, 34)=jf(109, 20)+ry*if( 75, 20)
    ig( 76, 34)=jf(110, 20)+ry*if( 76, 20)
    ig( 77, 34)=jf(111, 20)+ry*if( 77, 20)
    ig( 78, 34)=jf(113, 20)+ry*if( 78, 20)
    ig( 79, 34)=jf(114, 20)+ry*if( 79, 20)
    ig( 80, 34)=jf(115, 20)+ry*if( 80, 20)
    ig( 81, 34)=jf(116, 20)+ry*if( 81, 20)
    ig( 82, 34)=jf(117, 20)+ry*if( 82, 20)
    ig( 83, 34)=jf(118, 20)+ry*if( 83, 20)
    ig( 84, 34)=jf(119, 20)+ry*if( 84, 20)
    ig( 57, 35)=jf( 87, 20)+rz*if( 57, 20)
    ig( 58, 35)=jf( 89, 20)+rz*if( 58, 20)
    ig( 59, 35)=jf( 90, 20)+rz*if( 59, 20)
    ig( 60, 35)=jf( 92, 20)+rz*if( 60, 20)
    ig( 61, 35)=jf( 93, 20)+rz*if( 61, 20)
    ig( 62, 35)=jf( 94, 20)+rz*if( 62, 20)
    ig( 63, 35)=jf( 96, 20)+rz*if( 63, 20)
    ig( 64, 35)=jf( 97, 20)+rz*if( 64, 20)
    ig( 65, 35)=jf( 98, 20)+rz*if( 65, 20)
    ig( 66, 35)=jf( 99, 20)+rz*if( 66, 20)
    ig( 67, 35)=jf(101, 20)+rz*if( 67, 20)
    ig( 68, 35)=jf(102, 20)+rz*if( 68, 20)
    ig( 69, 35)=jf(103, 20)+rz*if( 69, 20)
    ig( 70, 35)=jf(104, 20)+rz*if( 70, 20)
    ig( 71, 35)=jf(105, 20)+rz*if( 71, 20)
    ig( 72, 35)=jf(107, 20)+rz*if( 72, 20)
    ig( 73, 35)=jf(108, 20)+rz*if( 73, 20)
    ig( 74, 35)=jf(109, 20)+rz*if( 74, 20)
    ig( 75, 35)=jf(110, 20)+rz*if( 75, 20)
    ig( 76, 35)=jf(111, 20)+rz*if( 76, 20)
    ig( 77, 35)=jf(112, 20)+rz*if( 77, 20)
    ig( 78, 35)=jf(114, 20)+rz*if( 78, 20)
    ig( 79, 35)=jf(115, 20)+rz*if( 79, 20)
    ig( 80, 35)=jf(116, 20)+rz*if( 80, 20)
    ig( 81, 35)=jf(117, 20)+rz*if( 81, 20)
    ig( 82, 35)=jf(118, 20)+rz*if( 82, 20)
    ig( 83, 35)=jf(119, 20)+rz*if( 83, 20)
    ig( 84, 35)=jf(120, 20)+rz*if( 84, 20)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_fh( )
    fh( 11, 36)=gg( 21, 21)+rx*fg( 11, 21)
    fh( 12, 36)=gg( 22, 21)+rx*fg( 12, 21)
    fh( 13, 36)=gg( 23, 21)+rx*fg( 13, 21)
    fh( 14, 36)=gg( 24, 21)+rx*fg( 14, 21)
    fh( 15, 36)=gg( 25, 21)+rx*fg( 15, 21)
    fh( 16, 36)=gg( 26, 21)+rx*fg( 16, 21)
    fh( 17, 36)=gg( 27, 21)+rx*fg( 17, 21)
    fh( 18, 36)=gg( 28, 21)+rx*fg( 18, 21)
    fh( 19, 36)=gg( 29, 21)+rx*fg( 19, 21)
    fh( 20, 36)=gg( 30, 21)+rx*fg( 20, 21)
    fh( 11, 37)=gg( 21, 22)+rx*fg( 11, 22)
    fh( 12, 37)=gg( 22, 22)+rx*fg( 12, 22)
    fh( 13, 37)=gg( 23, 22)+rx*fg( 13, 22)
    fh( 14, 37)=gg( 24, 22)+rx*fg( 14, 22)
    fh( 15, 37)=gg( 25, 22)+rx*fg( 15, 22)
    fh( 16, 37)=gg( 26, 22)+rx*fg( 16, 22)
    fh( 17, 37)=gg( 27, 22)+rx*fg( 17, 22)
    fh( 18, 37)=gg( 28, 22)+rx*fg( 18, 22)
    fh( 19, 37)=gg( 29, 22)+rx*fg( 19, 22)
    fh( 20, 37)=gg( 30, 22)+rx*fg( 20, 22)
    fh( 11, 38)=gg( 21, 23)+rx*fg( 11, 23)
    fh( 12, 38)=gg( 22, 23)+rx*fg( 12, 23)
    fh( 13, 38)=gg( 23, 23)+rx*fg( 13, 23)
    fh( 14, 38)=gg( 24, 23)+rx*fg( 14, 23)
    fh( 15, 38)=gg( 25, 23)+rx*fg( 15, 23)
    fh( 16, 38)=gg( 26, 23)+rx*fg( 16, 23)
    fh( 17, 38)=gg( 27, 23)+rx*fg( 17, 23)
    fh( 18, 38)=gg( 28, 23)+rx*fg( 18, 23)
    fh( 19, 38)=gg( 29, 23)+rx*fg( 19, 23)
    fh( 20, 38)=gg( 30, 23)+rx*fg( 20, 23)
    fh( 11, 39)=gg( 21, 24)+rx*fg( 11, 24)
    fh( 12, 39)=gg( 22, 24)+rx*fg( 12, 24)
    fh( 13, 39)=gg( 23, 24)+rx*fg( 13, 24)
    fh( 14, 39)=gg( 24, 24)+rx*fg( 14, 24)
    fh( 15, 39)=gg( 25, 24)+rx*fg( 15, 24)
    fh( 16, 39)=gg( 26, 24)+rx*fg( 16, 24)
    fh( 17, 39)=gg( 27, 24)+rx*fg( 17, 24)
    fh( 18, 39)=gg( 28, 24)+rx*fg( 18, 24)
    fh( 19, 39)=gg( 29, 24)+rx*fg( 19, 24)
    fh( 20, 39)=gg( 30, 24)+rx*fg( 20, 24)
    fh( 11, 40)=gg( 21, 25)+rx*fg( 11, 25)
    fh( 12, 40)=gg( 22, 25)+rx*fg( 12, 25)
    fh( 13, 40)=gg( 23, 25)+rx*fg( 13, 25)
    fh( 14, 40)=gg( 24, 25)+rx*fg( 14, 25)
    fh( 15, 40)=gg( 25, 25)+rx*fg( 15, 25)
    fh( 16, 40)=gg( 26, 25)+rx*fg( 16, 25)
    fh( 17, 40)=gg( 27, 25)+rx*fg( 17, 25)
    fh( 18, 40)=gg( 28, 25)+rx*fg( 18, 25)
    fh( 19, 40)=gg( 29, 25)+rx*fg( 19, 25)
    fh( 20, 40)=gg( 30, 25)+rx*fg( 20, 25)
    fh( 11, 41)=gg( 21, 26)+rx*fg( 11, 26)
    fh( 12, 41)=gg( 22, 26)+rx*fg( 12, 26)
    fh( 13, 41)=gg( 23, 26)+rx*fg( 13, 26)
    fh( 14, 41)=gg( 24, 26)+rx*fg( 14, 26)
    fh( 15, 41)=gg( 25, 26)+rx*fg( 15, 26)
    fh( 16, 41)=gg( 26, 26)+rx*fg( 16, 26)
    fh( 17, 41)=gg( 27, 26)+rx*fg( 17, 26)
    fh( 18, 41)=gg( 28, 26)+rx*fg( 18, 26)
    fh( 19, 41)=gg( 29, 26)+rx*fg( 19, 26)
    fh( 20, 41)=gg( 30, 26)+rx*fg( 20, 26)
    fh( 11, 42)=gg( 21, 27)+rx*fg( 11, 27)
    fh( 12, 42)=gg( 22, 27)+rx*fg( 12, 27)
    fh( 13, 42)=gg( 23, 27)+rx*fg( 13, 27)
    fh( 14, 42)=gg( 24, 27)+rx*fg( 14, 27)
    fh( 15, 42)=gg( 25, 27)+rx*fg( 15, 27)
    fh( 16, 42)=gg( 26, 27)+rx*fg( 16, 27)
    fh( 17, 42)=gg( 27, 27)+rx*fg( 17, 27)
    fh( 18, 42)=gg( 28, 27)+rx*fg( 18, 27)
    fh( 19, 42)=gg( 29, 27)+rx*fg( 19, 27)
    fh( 20, 42)=gg( 30, 27)+rx*fg( 20, 27)
    fh( 11, 43)=gg( 21, 28)+rx*fg( 11, 28)
    fh( 12, 43)=gg( 22, 28)+rx*fg( 12, 28)
    fh( 13, 43)=gg( 23, 28)+rx*fg( 13, 28)
    fh( 14, 43)=gg( 24, 28)+rx*fg( 14, 28)
    fh( 15, 43)=gg( 25, 28)+rx*fg( 15, 28)
    fh( 16, 43)=gg( 26, 28)+rx*fg( 16, 28)
    fh( 17, 43)=gg( 27, 28)+rx*fg( 17, 28)
    fh( 18, 43)=gg( 28, 28)+rx*fg( 18, 28)
    fh( 19, 43)=gg( 29, 28)+rx*fg( 19, 28)
    fh( 20, 43)=gg( 30, 28)+rx*fg( 20, 28)
    fh( 11, 44)=gg( 21, 29)+rx*fg( 11, 29)
    fh( 12, 44)=gg( 22, 29)+rx*fg( 12, 29)
    fh( 13, 44)=gg( 23, 29)+rx*fg( 13, 29)
    fh( 14, 44)=gg( 24, 29)+rx*fg( 14, 29)
    fh( 15, 44)=gg( 25, 29)+rx*fg( 15, 29)
    fh( 16, 44)=gg( 26, 29)+rx*fg( 16, 29)
    fh( 17, 44)=gg( 27, 29)+rx*fg( 17, 29)
    fh( 18, 44)=gg( 28, 29)+rx*fg( 18, 29)
    fh( 19, 44)=gg( 29, 29)+rx*fg( 19, 29)
    fh( 20, 44)=gg( 30, 29)+rx*fg( 20, 29)
    fh( 11, 45)=gg( 21, 30)+rx*fg( 11, 30)
    fh( 12, 45)=gg( 22, 30)+rx*fg( 12, 30)
    fh( 13, 45)=gg( 23, 30)+rx*fg( 13, 30)
    fh( 14, 45)=gg( 24, 30)+rx*fg( 14, 30)
    fh( 15, 45)=gg( 25, 30)+rx*fg( 15, 30)
    fh( 16, 45)=gg( 26, 30)+rx*fg( 16, 30)
    fh( 17, 45)=gg( 27, 30)+rx*fg( 17, 30)
    fh( 18, 45)=gg( 28, 30)+rx*fg( 18, 30)
    fh( 19, 45)=gg( 29, 30)+rx*fg( 19, 30)
    fh( 20, 45)=gg( 30, 30)+rx*fg( 20, 30)
    fh( 11, 46)=gg( 21, 31)+rx*fg( 11, 31)
    fh( 12, 46)=gg( 22, 31)+rx*fg( 12, 31)
    fh( 13, 46)=gg( 23, 31)+rx*fg( 13, 31)
    fh( 14, 46)=gg( 24, 31)+rx*fg( 14, 31)
    fh( 15, 46)=gg( 25, 31)+rx*fg( 15, 31)
    fh( 16, 46)=gg( 26, 31)+rx*fg( 16, 31)
    fh( 17, 46)=gg( 27, 31)+rx*fg( 17, 31)
    fh( 18, 46)=gg( 28, 31)+rx*fg( 18, 31)
    fh( 19, 46)=gg( 29, 31)+rx*fg( 19, 31)
    fh( 20, 46)=gg( 30, 31)+rx*fg( 20, 31)
    fh( 11, 47)=gg( 21, 32)+rx*fg( 11, 32)
    fh( 12, 47)=gg( 22, 32)+rx*fg( 12, 32)
    fh( 13, 47)=gg( 23, 32)+rx*fg( 13, 32)
    fh( 14, 47)=gg( 24, 32)+rx*fg( 14, 32)
    fh( 15, 47)=gg( 25, 32)+rx*fg( 15, 32)
    fh( 16, 47)=gg( 26, 32)+rx*fg( 16, 32)
    fh( 17, 47)=gg( 27, 32)+rx*fg( 17, 32)
    fh( 18, 47)=gg( 28, 32)+rx*fg( 18, 32)
    fh( 19, 47)=gg( 29, 32)+rx*fg( 19, 32)
    fh( 20, 47)=gg( 30, 32)+rx*fg( 20, 32)
    fh( 11, 48)=gg( 21, 33)+rx*fg( 11, 33)
    fh( 12, 48)=gg( 22, 33)+rx*fg( 12, 33)
    fh( 13, 48)=gg( 23, 33)+rx*fg( 13, 33)
    fh( 14, 48)=gg( 24, 33)+rx*fg( 14, 33)
    fh( 15, 48)=gg( 25, 33)+rx*fg( 15, 33)
    fh( 16, 48)=gg( 26, 33)+rx*fg( 16, 33)
    fh( 17, 48)=gg( 27, 33)+rx*fg( 17, 33)
    fh( 18, 48)=gg( 28, 33)+rx*fg( 18, 33)
    fh( 19, 48)=gg( 29, 33)+rx*fg( 19, 33)
    fh( 20, 48)=gg( 30, 33)+rx*fg( 20, 33)
    fh( 11, 49)=gg( 21, 34)+rx*fg( 11, 34)
    fh( 12, 49)=gg( 22, 34)+rx*fg( 12, 34)
    fh( 13, 49)=gg( 23, 34)+rx*fg( 13, 34)
    fh( 14, 49)=gg( 24, 34)+rx*fg( 14, 34)
    fh( 15, 49)=gg( 25, 34)+rx*fg( 15, 34)
    fh( 16, 49)=gg( 26, 34)+rx*fg( 16, 34)
    fh( 17, 49)=gg( 27, 34)+rx*fg( 17, 34)
    fh( 18, 49)=gg( 28, 34)+rx*fg( 18, 34)
    fh( 19, 49)=gg( 29, 34)+rx*fg( 19, 34)
    fh( 20, 49)=gg( 30, 34)+rx*fg( 20, 34)
    fh( 11, 50)=gg( 21, 35)+rx*fg( 11, 35)
    fh( 12, 50)=gg( 22, 35)+rx*fg( 12, 35)
    fh( 13, 50)=gg( 23, 35)+rx*fg( 13, 35)
    fh( 14, 50)=gg( 24, 35)+rx*fg( 14, 35)
    fh( 15, 50)=gg( 25, 35)+rx*fg( 15, 35)
    fh( 16, 50)=gg( 26, 35)+rx*fg( 16, 35)
    fh( 17, 50)=gg( 27, 35)+rx*fg( 17, 35)
    fh( 18, 50)=gg( 28, 35)+rx*fg( 18, 35)
    fh( 19, 50)=gg( 29, 35)+rx*fg( 19, 35)
    fh( 20, 50)=gg( 30, 35)+rx*fg( 20, 35)
    fh( 11, 51)=gg( 22, 31)+ry*fg( 11, 31)
    fh( 12, 51)=gg( 24, 31)+ry*fg( 12, 31)
    fh( 13, 51)=gg( 25, 31)+ry*fg( 13, 31)
    fh( 14, 51)=gg( 27, 31)+ry*fg( 14, 31)
    fh( 15, 51)=gg( 28, 31)+ry*fg( 15, 31)
    fh( 16, 51)=gg( 29, 31)+ry*fg( 16, 31)
    fh( 17, 51)=gg( 31, 31)+ry*fg( 17, 31)
    fh( 18, 51)=gg( 32, 31)+ry*fg( 18, 31)
    fh( 19, 51)=gg( 33, 31)+ry*fg( 19, 31)
    fh( 20, 51)=gg( 34, 31)+ry*fg( 20, 31)
    fh( 11, 52)=gg( 22, 32)+ry*fg( 11, 32)
    fh( 12, 52)=gg( 24, 32)+ry*fg( 12, 32)
    fh( 13, 52)=gg( 25, 32)+ry*fg( 13, 32)
    fh( 14, 52)=gg( 27, 32)+ry*fg( 14, 32)
    fh( 15, 52)=gg( 28, 32)+ry*fg( 15, 32)
    fh( 16, 52)=gg( 29, 32)+ry*fg( 16, 32)
    fh( 17, 52)=gg( 31, 32)+ry*fg( 17, 32)
    fh( 18, 52)=gg( 32, 32)+ry*fg( 18, 32)
    fh( 19, 52)=gg( 33, 32)+ry*fg( 19, 32)
    fh( 20, 52)=gg( 34, 32)+ry*fg( 20, 32)
    fh( 11, 53)=gg( 22, 33)+ry*fg( 11, 33)
    fh( 12, 53)=gg( 24, 33)+ry*fg( 12, 33)
    fh( 13, 53)=gg( 25, 33)+ry*fg( 13, 33)
    fh( 14, 53)=gg( 27, 33)+ry*fg( 14, 33)
    fh( 15, 53)=gg( 28, 33)+ry*fg( 15, 33)
    fh( 16, 53)=gg( 29, 33)+ry*fg( 16, 33)
    fh( 17, 53)=gg( 31, 33)+ry*fg( 17, 33)
    fh( 18, 53)=gg( 32, 33)+ry*fg( 18, 33)
    fh( 19, 53)=gg( 33, 33)+ry*fg( 19, 33)
    fh( 20, 53)=gg( 34, 33)+ry*fg( 20, 33)
    fh( 11, 54)=gg( 22, 34)+ry*fg( 11, 34)
    fh( 12, 54)=gg( 24, 34)+ry*fg( 12, 34)
    fh( 13, 54)=gg( 25, 34)+ry*fg( 13, 34)
    fh( 14, 54)=gg( 27, 34)+ry*fg( 14, 34)
    fh( 15, 54)=gg( 28, 34)+ry*fg( 15, 34)
    fh( 16, 54)=gg( 29, 34)+ry*fg( 16, 34)
    fh( 17, 54)=gg( 31, 34)+ry*fg( 17, 34)
    fh( 18, 54)=gg( 32, 34)+ry*fg( 18, 34)
    fh( 19, 54)=gg( 33, 34)+ry*fg( 19, 34)
    fh( 20, 54)=gg( 34, 34)+ry*fg( 20, 34)
    fh( 11, 55)=gg( 22, 35)+ry*fg( 11, 35)
    fh( 12, 55)=gg( 24, 35)+ry*fg( 12, 35)
    fh( 13, 55)=gg( 25, 35)+ry*fg( 13, 35)
    fh( 14, 55)=gg( 27, 35)+ry*fg( 14, 35)
    fh( 15, 55)=gg( 28, 35)+ry*fg( 15, 35)
    fh( 16, 55)=gg( 29, 35)+ry*fg( 16, 35)
    fh( 17, 55)=gg( 31, 35)+ry*fg( 17, 35)
    fh( 18, 55)=gg( 32, 35)+ry*fg( 18, 35)
    fh( 19, 55)=gg( 33, 35)+ry*fg( 19, 35)
    fh( 20, 55)=gg( 34, 35)+ry*fg( 20, 35)
    fh( 11, 56)=gg( 23, 35)+rz*fg( 11, 35)
    fh( 12, 56)=gg( 25, 35)+rz*fg( 12, 35)
    fh( 13, 56)=gg( 26, 35)+rz*fg( 13, 35)
    fh( 14, 56)=gg( 28, 35)+rz*fg( 14, 35)
    fh( 15, 56)=gg( 29, 35)+rz*fg( 15, 35)
    fh( 16, 56)=gg( 30, 35)+rz*fg( 16, 35)
    fh( 17, 56)=gg( 32, 35)+rz*fg( 17, 35)
    fh( 18, 56)=gg( 33, 35)+rz*fg( 18, 35)
    fh( 19, 56)=gg( 34, 35)+rz*fg( 19, 35)
    fh( 20, 56)=gg( 35, 35)+rz*fg( 20, 35)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_gh( )
    gh( 21, 36)=hg( 36, 21)+rx*gg( 21, 21)
    gh( 22, 36)=hg( 37, 21)+rx*gg( 22, 21)
    gh( 23, 36)=hg( 38, 21)+rx*gg( 23, 21)
    gh( 24, 36)=hg( 39, 21)+rx*gg( 24, 21)
    gh( 25, 36)=hg( 40, 21)+rx*gg( 25, 21)
    gh( 26, 36)=hg( 41, 21)+rx*gg( 26, 21)
    gh( 27, 36)=hg( 42, 21)+rx*gg( 27, 21)
    gh( 28, 36)=hg( 43, 21)+rx*gg( 28, 21)
    gh( 29, 36)=hg( 44, 21)+rx*gg( 29, 21)
    gh( 30, 36)=hg( 45, 21)+rx*gg( 30, 21)
    gh( 31, 36)=hg( 46, 21)+rx*gg( 31, 21)
    gh( 32, 36)=hg( 47, 21)+rx*gg( 32, 21)
    gh( 33, 36)=hg( 48, 21)+rx*gg( 33, 21)
    gh( 34, 36)=hg( 49, 21)+rx*gg( 34, 21)
    gh( 35, 36)=hg( 50, 21)+rx*gg( 35, 21)
    gh( 21, 37)=hg( 36, 22)+rx*gg( 21, 22)
    gh( 22, 37)=hg( 37, 22)+rx*gg( 22, 22)
    gh( 23, 37)=hg( 38, 22)+rx*gg( 23, 22)
    gh( 24, 37)=hg( 39, 22)+rx*gg( 24, 22)
    gh( 25, 37)=hg( 40, 22)+rx*gg( 25, 22)
    gh( 26, 37)=hg( 41, 22)+rx*gg( 26, 22)
    gh( 27, 37)=hg( 42, 22)+rx*gg( 27, 22)
    gh( 28, 37)=hg( 43, 22)+rx*gg( 28, 22)
    gh( 29, 37)=hg( 44, 22)+rx*gg( 29, 22)
    gh( 30, 37)=hg( 45, 22)+rx*gg( 30, 22)
    gh( 31, 37)=hg( 46, 22)+rx*gg( 31, 22)
    gh( 32, 37)=hg( 47, 22)+rx*gg( 32, 22)
    gh( 33, 37)=hg( 48, 22)+rx*gg( 33, 22)
    gh( 34, 37)=hg( 49, 22)+rx*gg( 34, 22)
    gh( 35, 37)=hg( 50, 22)+rx*gg( 35, 22)
    gh( 21, 38)=hg( 36, 23)+rx*gg( 21, 23)
    gh( 22, 38)=hg( 37, 23)+rx*gg( 22, 23)
    gh( 23, 38)=hg( 38, 23)+rx*gg( 23, 23)
    gh( 24, 38)=hg( 39, 23)+rx*gg( 24, 23)
    gh( 25, 38)=hg( 40, 23)+rx*gg( 25, 23)
    gh( 26, 38)=hg( 41, 23)+rx*gg( 26, 23)
    gh( 27, 38)=hg( 42, 23)+rx*gg( 27, 23)
    gh( 28, 38)=hg( 43, 23)+rx*gg( 28, 23)
    gh( 29, 38)=hg( 44, 23)+rx*gg( 29, 23)
    gh( 30, 38)=hg( 45, 23)+rx*gg( 30, 23)
    gh( 31, 38)=hg( 46, 23)+rx*gg( 31, 23)
    gh( 32, 38)=hg( 47, 23)+rx*gg( 32, 23)
    gh( 33, 38)=hg( 48, 23)+rx*gg( 33, 23)
    gh( 34, 38)=hg( 49, 23)+rx*gg( 34, 23)
    gh( 35, 38)=hg( 50, 23)+rx*gg( 35, 23)
    gh( 21, 39)=hg( 36, 24)+rx*gg( 21, 24)
    gh( 22, 39)=hg( 37, 24)+rx*gg( 22, 24)
    gh( 23, 39)=hg( 38, 24)+rx*gg( 23, 24)
    gh( 24, 39)=hg( 39, 24)+rx*gg( 24, 24)
    gh( 25, 39)=hg( 40, 24)+rx*gg( 25, 24)
    gh( 26, 39)=hg( 41, 24)+rx*gg( 26, 24)
    gh( 27, 39)=hg( 42, 24)+rx*gg( 27, 24)
    gh( 28, 39)=hg( 43, 24)+rx*gg( 28, 24)
    gh( 29, 39)=hg( 44, 24)+rx*gg( 29, 24)
    gh( 30, 39)=hg( 45, 24)+rx*gg( 30, 24)
    gh( 31, 39)=hg( 46, 24)+rx*gg( 31, 24)
    gh( 32, 39)=hg( 47, 24)+rx*gg( 32, 24)
    gh( 33, 39)=hg( 48, 24)+rx*gg( 33, 24)
    gh( 34, 39)=hg( 49, 24)+rx*gg( 34, 24)
    gh( 35, 39)=hg( 50, 24)+rx*gg( 35, 24)
    gh( 21, 40)=hg( 36, 25)+rx*gg( 21, 25)
    gh( 22, 40)=hg( 37, 25)+rx*gg( 22, 25)
    gh( 23, 40)=hg( 38, 25)+rx*gg( 23, 25)
    gh( 24, 40)=hg( 39, 25)+rx*gg( 24, 25)
    gh( 25, 40)=hg( 40, 25)+rx*gg( 25, 25)
    gh( 26, 40)=hg( 41, 25)+rx*gg( 26, 25)
    gh( 27, 40)=hg( 42, 25)+rx*gg( 27, 25)
    gh( 28, 40)=hg( 43, 25)+rx*gg( 28, 25)
    gh( 29, 40)=hg( 44, 25)+rx*gg( 29, 25)
    gh( 30, 40)=hg( 45, 25)+rx*gg( 30, 25)
    gh( 31, 40)=hg( 46, 25)+rx*gg( 31, 25)
    gh( 32, 40)=hg( 47, 25)+rx*gg( 32, 25)
    gh( 33, 40)=hg( 48, 25)+rx*gg( 33, 25)
    gh( 34, 40)=hg( 49, 25)+rx*gg( 34, 25)
    gh( 35, 40)=hg( 50, 25)+rx*gg( 35, 25)
    gh( 21, 41)=hg( 36, 26)+rx*gg( 21, 26)
    gh( 22, 41)=hg( 37, 26)+rx*gg( 22, 26)
    gh( 23, 41)=hg( 38, 26)+rx*gg( 23, 26)
    gh( 24, 41)=hg( 39, 26)+rx*gg( 24, 26)
    gh( 25, 41)=hg( 40, 26)+rx*gg( 25, 26)
    gh( 26, 41)=hg( 41, 26)+rx*gg( 26, 26)
    gh( 27, 41)=hg( 42, 26)+rx*gg( 27, 26)
    gh( 28, 41)=hg( 43, 26)+rx*gg( 28, 26)
    gh( 29, 41)=hg( 44, 26)+rx*gg( 29, 26)
    gh( 30, 41)=hg( 45, 26)+rx*gg( 30, 26)
    gh( 31, 41)=hg( 46, 26)+rx*gg( 31, 26)
    gh( 32, 41)=hg( 47, 26)+rx*gg( 32, 26)
    gh( 33, 41)=hg( 48, 26)+rx*gg( 33, 26)
    gh( 34, 41)=hg( 49, 26)+rx*gg( 34, 26)
    gh( 35, 41)=hg( 50, 26)+rx*gg( 35, 26)
    gh( 21, 42)=hg( 36, 27)+rx*gg( 21, 27)
    gh( 22, 42)=hg( 37, 27)+rx*gg( 22, 27)
    gh( 23, 42)=hg( 38, 27)+rx*gg( 23, 27)
    gh( 24, 42)=hg( 39, 27)+rx*gg( 24, 27)
    gh( 25, 42)=hg( 40, 27)+rx*gg( 25, 27)
    gh( 26, 42)=hg( 41, 27)+rx*gg( 26, 27)
    gh( 27, 42)=hg( 42, 27)+rx*gg( 27, 27)
    gh( 28, 42)=hg( 43, 27)+rx*gg( 28, 27)
    gh( 29, 42)=hg( 44, 27)+rx*gg( 29, 27)
    gh( 30, 42)=hg( 45, 27)+rx*gg( 30, 27)
    gh( 31, 42)=hg( 46, 27)+rx*gg( 31, 27)
    gh( 32, 42)=hg( 47, 27)+rx*gg( 32, 27)
    gh( 33, 42)=hg( 48, 27)+rx*gg( 33, 27)
    gh( 34, 42)=hg( 49, 27)+rx*gg( 34, 27)
    gh( 35, 42)=hg( 50, 27)+rx*gg( 35, 27)
    gh( 21, 43)=hg( 36, 28)+rx*gg( 21, 28)
    gh( 22, 43)=hg( 37, 28)+rx*gg( 22, 28)
    gh( 23, 43)=hg( 38, 28)+rx*gg( 23, 28)
    gh( 24, 43)=hg( 39, 28)+rx*gg( 24, 28)
    gh( 25, 43)=hg( 40, 28)+rx*gg( 25, 28)
    gh( 26, 43)=hg( 41, 28)+rx*gg( 26, 28)
    gh( 27, 43)=hg( 42, 28)+rx*gg( 27, 28)
    gh( 28, 43)=hg( 43, 28)+rx*gg( 28, 28)
    gh( 29, 43)=hg( 44, 28)+rx*gg( 29, 28)
    gh( 30, 43)=hg( 45, 28)+rx*gg( 30, 28)
    gh( 31, 43)=hg( 46, 28)+rx*gg( 31, 28)
    gh( 32, 43)=hg( 47, 28)+rx*gg( 32, 28)
    gh( 33, 43)=hg( 48, 28)+rx*gg( 33, 28)
    gh( 34, 43)=hg( 49, 28)+rx*gg( 34, 28)
    gh( 35, 43)=hg( 50, 28)+rx*gg( 35, 28)
    gh( 21, 44)=hg( 36, 29)+rx*gg( 21, 29)
    gh( 22, 44)=hg( 37, 29)+rx*gg( 22, 29)
    gh( 23, 44)=hg( 38, 29)+rx*gg( 23, 29)
    gh( 24, 44)=hg( 39, 29)+rx*gg( 24, 29)
    gh( 25, 44)=hg( 40, 29)+rx*gg( 25, 29)
    gh( 26, 44)=hg( 41, 29)+rx*gg( 26, 29)
    gh( 27, 44)=hg( 42, 29)+rx*gg( 27, 29)
    gh( 28, 44)=hg( 43, 29)+rx*gg( 28, 29)
    gh( 29, 44)=hg( 44, 29)+rx*gg( 29, 29)
    gh( 30, 44)=hg( 45, 29)+rx*gg( 30, 29)
    gh( 31, 44)=hg( 46, 29)+rx*gg( 31, 29)
    gh( 32, 44)=hg( 47, 29)+rx*gg( 32, 29)
    gh( 33, 44)=hg( 48, 29)+rx*gg( 33, 29)
    gh( 34, 44)=hg( 49, 29)+rx*gg( 34, 29)
    gh( 35, 44)=hg( 50, 29)+rx*gg( 35, 29)
    gh( 21, 45)=hg( 36, 30)+rx*gg( 21, 30)
    gh( 22, 45)=hg( 37, 30)+rx*gg( 22, 30)
    gh( 23, 45)=hg( 38, 30)+rx*gg( 23, 30)
    gh( 24, 45)=hg( 39, 30)+rx*gg( 24, 30)
    gh( 25, 45)=hg( 40, 30)+rx*gg( 25, 30)
    gh( 26, 45)=hg( 41, 30)+rx*gg( 26, 30)
    gh( 27, 45)=hg( 42, 30)+rx*gg( 27, 30)
    gh( 28, 45)=hg( 43, 30)+rx*gg( 28, 30)
    gh( 29, 45)=hg( 44, 30)+rx*gg( 29, 30)
    gh( 30, 45)=hg( 45, 30)+rx*gg( 30, 30)
    gh( 31, 45)=hg( 46, 30)+rx*gg( 31, 30)
    gh( 32, 45)=hg( 47, 30)+rx*gg( 32, 30)
    gh( 33, 45)=hg( 48, 30)+rx*gg( 33, 30)
    gh( 34, 45)=hg( 49, 30)+rx*gg( 34, 30)
    gh( 35, 45)=hg( 50, 30)+rx*gg( 35, 30)
    gh( 21, 46)=hg( 36, 31)+rx*gg( 21, 31)
    gh( 22, 46)=hg( 37, 31)+rx*gg( 22, 31)
    gh( 23, 46)=hg( 38, 31)+rx*gg( 23, 31)
    gh( 24, 46)=hg( 39, 31)+rx*gg( 24, 31)
    gh( 25, 46)=hg( 40, 31)+rx*gg( 25, 31)
    gh( 26, 46)=hg( 41, 31)+rx*gg( 26, 31)
    gh( 27, 46)=hg( 42, 31)+rx*gg( 27, 31)
    gh( 28, 46)=hg( 43, 31)+rx*gg( 28, 31)
    gh( 29, 46)=hg( 44, 31)+rx*gg( 29, 31)
    gh( 30, 46)=hg( 45, 31)+rx*gg( 30, 31)
    gh( 31, 46)=hg( 46, 31)+rx*gg( 31, 31)
    gh( 32, 46)=hg( 47, 31)+rx*gg( 32, 31)
    gh( 33, 46)=hg( 48, 31)+rx*gg( 33, 31)
    gh( 34, 46)=hg( 49, 31)+rx*gg( 34, 31)
    gh( 35, 46)=hg( 50, 31)+rx*gg( 35, 31)
    gh( 21, 47)=hg( 36, 32)+rx*gg( 21, 32)
    gh( 22, 47)=hg( 37, 32)+rx*gg( 22, 32)
    gh( 23, 47)=hg( 38, 32)+rx*gg( 23, 32)
    gh( 24, 47)=hg( 39, 32)+rx*gg( 24, 32)
    gh( 25, 47)=hg( 40, 32)+rx*gg( 25, 32)
    gh( 26, 47)=hg( 41, 32)+rx*gg( 26, 32)
    gh( 27, 47)=hg( 42, 32)+rx*gg( 27, 32)
    gh( 28, 47)=hg( 43, 32)+rx*gg( 28, 32)
    gh( 29, 47)=hg( 44, 32)+rx*gg( 29, 32)
    gh( 30, 47)=hg( 45, 32)+rx*gg( 30, 32)
    gh( 31, 47)=hg( 46, 32)+rx*gg( 31, 32)
    gh( 32, 47)=hg( 47, 32)+rx*gg( 32, 32)
    gh( 33, 47)=hg( 48, 32)+rx*gg( 33, 32)
    gh( 34, 47)=hg( 49, 32)+rx*gg( 34, 32)
    gh( 35, 47)=hg( 50, 32)+rx*gg( 35, 32)
    gh( 21, 48)=hg( 36, 33)+rx*gg( 21, 33)
    gh( 22, 48)=hg( 37, 33)+rx*gg( 22, 33)
    gh( 23, 48)=hg( 38, 33)+rx*gg( 23, 33)
    gh( 24, 48)=hg( 39, 33)+rx*gg( 24, 33)
    gh( 25, 48)=hg( 40, 33)+rx*gg( 25, 33)
    gh( 26, 48)=hg( 41, 33)+rx*gg( 26, 33)
    gh( 27, 48)=hg( 42, 33)+rx*gg( 27, 33)
    gh( 28, 48)=hg( 43, 33)+rx*gg( 28, 33)
    gh( 29, 48)=hg( 44, 33)+rx*gg( 29, 33)
    gh( 30, 48)=hg( 45, 33)+rx*gg( 30, 33)
    gh( 31, 48)=hg( 46, 33)+rx*gg( 31, 33)
    gh( 32, 48)=hg( 47, 33)+rx*gg( 32, 33)
    gh( 33, 48)=hg( 48, 33)+rx*gg( 33, 33)
    gh( 34, 48)=hg( 49, 33)+rx*gg( 34, 33)
    gh( 35, 48)=hg( 50, 33)+rx*gg( 35, 33)
    gh( 21, 49)=hg( 36, 34)+rx*gg( 21, 34)
    gh( 22, 49)=hg( 37, 34)+rx*gg( 22, 34)
    gh( 23, 49)=hg( 38, 34)+rx*gg( 23, 34)
    gh( 24, 49)=hg( 39, 34)+rx*gg( 24, 34)
    gh( 25, 49)=hg( 40, 34)+rx*gg( 25, 34)
    gh( 26, 49)=hg( 41, 34)+rx*gg( 26, 34)
    gh( 27, 49)=hg( 42, 34)+rx*gg( 27, 34)
    gh( 28, 49)=hg( 43, 34)+rx*gg( 28, 34)
    gh( 29, 49)=hg( 44, 34)+rx*gg( 29, 34)
    gh( 30, 49)=hg( 45, 34)+rx*gg( 30, 34)
    gh( 31, 49)=hg( 46, 34)+rx*gg( 31, 34)
    gh( 32, 49)=hg( 47, 34)+rx*gg( 32, 34)
    gh( 33, 49)=hg( 48, 34)+rx*gg( 33, 34)
    gh( 34, 49)=hg( 49, 34)+rx*gg( 34, 34)
    gh( 35, 49)=hg( 50, 34)+rx*gg( 35, 34)
    gh( 21, 50)=hg( 36, 35)+rx*gg( 21, 35)
    gh( 22, 50)=hg( 37, 35)+rx*gg( 22, 35)
    gh( 23, 50)=hg( 38, 35)+rx*gg( 23, 35)
    gh( 24, 50)=hg( 39, 35)+rx*gg( 24, 35)
    gh( 25, 50)=hg( 40, 35)+rx*gg( 25, 35)
    gh( 26, 50)=hg( 41, 35)+rx*gg( 26, 35)
    gh( 27, 50)=hg( 42, 35)+rx*gg( 27, 35)
    gh( 28, 50)=hg( 43, 35)+rx*gg( 28, 35)
    gh( 29, 50)=hg( 44, 35)+rx*gg( 29, 35)
    gh( 30, 50)=hg( 45, 35)+rx*gg( 30, 35)
    gh( 31, 50)=hg( 46, 35)+rx*gg( 31, 35)
    gh( 32, 50)=hg( 47, 35)+rx*gg( 32, 35)
    gh( 33, 50)=hg( 48, 35)+rx*gg( 33, 35)
    gh( 34, 50)=hg( 49, 35)+rx*gg( 34, 35)
    gh( 35, 50)=hg( 50, 35)+rx*gg( 35, 35)
    gh( 21, 51)=hg( 37, 31)+ry*gg( 21, 31)
    gh( 22, 51)=hg( 39, 31)+ry*gg( 22, 31)
    gh( 23, 51)=hg( 40, 31)+ry*gg( 23, 31)
    gh( 24, 51)=hg( 42, 31)+ry*gg( 24, 31)
    gh( 25, 51)=hg( 43, 31)+ry*gg( 25, 31)
    gh( 26, 51)=hg( 44, 31)+ry*gg( 26, 31)
    gh( 27, 51)=hg( 46, 31)+ry*gg( 27, 31)
    gh( 28, 51)=hg( 47, 31)+ry*gg( 28, 31)
    gh( 29, 51)=hg( 48, 31)+ry*gg( 29, 31)
    gh( 30, 51)=hg( 49, 31)+ry*gg( 30, 31)
    gh( 31, 51)=hg( 51, 31)+ry*gg( 31, 31)
    gh( 32, 51)=hg( 52, 31)+ry*gg( 32, 31)
    gh( 33, 51)=hg( 53, 31)+ry*gg( 33, 31)
    gh( 34, 51)=hg( 54, 31)+ry*gg( 34, 31)
    gh( 35, 51)=hg( 55, 31)+ry*gg( 35, 31)
    gh( 21, 52)=hg( 37, 32)+ry*gg( 21, 32)
    gh( 22, 52)=hg( 39, 32)+ry*gg( 22, 32)
    gh( 23, 52)=hg( 40, 32)+ry*gg( 23, 32)
    gh( 24, 52)=hg( 42, 32)+ry*gg( 24, 32)
    gh( 25, 52)=hg( 43, 32)+ry*gg( 25, 32)
    gh( 26, 52)=hg( 44, 32)+ry*gg( 26, 32)
    gh( 27, 52)=hg( 46, 32)+ry*gg( 27, 32)
    gh( 28, 52)=hg( 47, 32)+ry*gg( 28, 32)
    gh( 29, 52)=hg( 48, 32)+ry*gg( 29, 32)
    gh( 30, 52)=hg( 49, 32)+ry*gg( 30, 32)
    gh( 31, 52)=hg( 51, 32)+ry*gg( 31, 32)
    gh( 32, 52)=hg( 52, 32)+ry*gg( 32, 32)
    gh( 33, 52)=hg( 53, 32)+ry*gg( 33, 32)
    gh( 34, 52)=hg( 54, 32)+ry*gg( 34, 32)
    gh( 35, 52)=hg( 55, 32)+ry*gg( 35, 32)
    gh( 21, 53)=hg( 37, 33)+ry*gg( 21, 33)
    gh( 22, 53)=hg( 39, 33)+ry*gg( 22, 33)
    gh( 23, 53)=hg( 40, 33)+ry*gg( 23, 33)
    gh( 24, 53)=hg( 42, 33)+ry*gg( 24, 33)
    gh( 25, 53)=hg( 43, 33)+ry*gg( 25, 33)
    gh( 26, 53)=hg( 44, 33)+ry*gg( 26, 33)
    gh( 27, 53)=hg( 46, 33)+ry*gg( 27, 33)
    gh( 28, 53)=hg( 47, 33)+ry*gg( 28, 33)
    gh( 29, 53)=hg( 48, 33)+ry*gg( 29, 33)
    gh( 30, 53)=hg( 49, 33)+ry*gg( 30, 33)
    gh( 31, 53)=hg( 51, 33)+ry*gg( 31, 33)
    gh( 32, 53)=hg( 52, 33)+ry*gg( 32, 33)
    gh( 33, 53)=hg( 53, 33)+ry*gg( 33, 33)
    gh( 34, 53)=hg( 54, 33)+ry*gg( 34, 33)
    gh( 35, 53)=hg( 55, 33)+ry*gg( 35, 33)
    gh( 21, 54)=hg( 37, 34)+ry*gg( 21, 34)
    gh( 22, 54)=hg( 39, 34)+ry*gg( 22, 34)
    gh( 23, 54)=hg( 40, 34)+ry*gg( 23, 34)
    gh( 24, 54)=hg( 42, 34)+ry*gg( 24, 34)
    gh( 25, 54)=hg( 43, 34)+ry*gg( 25, 34)
    gh( 26, 54)=hg( 44, 34)+ry*gg( 26, 34)
    gh( 27, 54)=hg( 46, 34)+ry*gg( 27, 34)
    gh( 28, 54)=hg( 47, 34)+ry*gg( 28, 34)
    gh( 29, 54)=hg( 48, 34)+ry*gg( 29, 34)
    gh( 30, 54)=hg( 49, 34)+ry*gg( 30, 34)
    gh( 31, 54)=hg( 51, 34)+ry*gg( 31, 34)
    gh( 32, 54)=hg( 52, 34)+ry*gg( 32, 34)
    gh( 33, 54)=hg( 53, 34)+ry*gg( 33, 34)
    gh( 34, 54)=hg( 54, 34)+ry*gg( 34, 34)
    gh( 35, 54)=hg( 55, 34)+ry*gg( 35, 34)
    gh( 21, 55)=hg( 37, 35)+ry*gg( 21, 35)
    gh( 22, 55)=hg( 39, 35)+ry*gg( 22, 35)
    gh( 23, 55)=hg( 40, 35)+ry*gg( 23, 35)
    gh( 24, 55)=hg( 42, 35)+ry*gg( 24, 35)
    gh( 25, 55)=hg( 43, 35)+ry*gg( 25, 35)
    gh( 26, 55)=hg( 44, 35)+ry*gg( 26, 35)
    gh( 27, 55)=hg( 46, 35)+ry*gg( 27, 35)
    gh( 28, 55)=hg( 47, 35)+ry*gg( 28, 35)
    gh( 29, 55)=hg( 48, 35)+ry*gg( 29, 35)
    gh( 30, 55)=hg( 49, 35)+ry*gg( 30, 35)
    gh( 31, 55)=hg( 51, 35)+ry*gg( 31, 35)
    gh( 32, 55)=hg( 52, 35)+ry*gg( 32, 35)
    gh( 33, 55)=hg( 53, 35)+ry*gg( 33, 35)
    gh( 34, 55)=hg( 54, 35)+ry*gg( 34, 35)
    gh( 35, 55)=hg( 55, 35)+ry*gg( 35, 35)
    gh( 21, 56)=hg( 38, 35)+rz*gg( 21, 35)
    gh( 22, 56)=hg( 40, 35)+rz*gg( 22, 35)
    gh( 23, 56)=hg( 41, 35)+rz*gg( 23, 35)
    gh( 24, 56)=hg( 43, 35)+rz*gg( 24, 35)
    gh( 25, 56)=hg( 44, 35)+rz*gg( 25, 35)
    gh( 26, 56)=hg( 45, 35)+rz*gg( 26, 35)
    gh( 27, 56)=hg( 47, 35)+rz*gg( 27, 35)
    gh( 28, 56)=hg( 48, 35)+rz*gg( 28, 35)
    gh( 29, 56)=hg( 49, 35)+rz*gg( 29, 35)
    gh( 30, 56)=hg( 50, 35)+rz*gg( 30, 35)
    gh( 31, 56)=hg( 52, 35)+rz*gg( 31, 35)
    gh( 32, 56)=hg( 53, 35)+rz*gg( 32, 35)
    gh( 33, 56)=hg( 54, 35)+rz*gg( 33, 35)
    gh( 34, 56)=hg( 55, 35)+rz*gg( 34, 35)
    gh( 35, 56)=hg( 56, 35)+rz*gg( 35, 35)
  end subroutine
!--------------------------------------------------------------------
  subroutine do_hh( )
    hh( 36, 36)=ig( 57, 21)+rx*hg( 36, 21)
    hh( 37, 36)=ig( 58, 21)+rx*hg( 37, 21)
    hh( 38, 36)=ig( 59, 21)+rx*hg( 38, 21)
    hh( 39, 36)=ig( 60, 21)+rx*hg( 39, 21)
    hh( 40, 36)=ig( 61, 21)+rx*hg( 40, 21)
    hh( 41, 36)=ig( 62, 21)+rx*hg( 41, 21)
    hh( 42, 36)=ig( 63, 21)+rx*hg( 42, 21)
    hh( 43, 36)=ig( 64, 21)+rx*hg( 43, 21)
    hh( 44, 36)=ig( 65, 21)+rx*hg( 44, 21)
    hh( 45, 36)=ig( 66, 21)+rx*hg( 45, 21)
    hh( 46, 36)=ig( 67, 21)+rx*hg( 46, 21)
    hh( 47, 36)=ig( 68, 21)+rx*hg( 47, 21)
    hh( 48, 36)=ig( 69, 21)+rx*hg( 48, 21)
    hh( 49, 36)=ig( 70, 21)+rx*hg( 49, 21)
    hh( 50, 36)=ig( 71, 21)+rx*hg( 50, 21)
    hh( 51, 36)=ig( 72, 21)+rx*hg( 51, 21)
    hh( 52, 36)=ig( 73, 21)+rx*hg( 52, 21)
    hh( 53, 36)=ig( 74, 21)+rx*hg( 53, 21)
    hh( 54, 36)=ig( 75, 21)+rx*hg( 54, 21)
    hh( 55, 36)=ig( 76, 21)+rx*hg( 55, 21)
    hh( 56, 36)=ig( 77, 21)+rx*hg( 56, 21)
    hh( 36, 37)=ig( 57, 22)+rx*hg( 36, 22)
    hh( 37, 37)=ig( 58, 22)+rx*hg( 37, 22)
    hh( 38, 37)=ig( 59, 22)+rx*hg( 38, 22)
    hh( 39, 37)=ig( 60, 22)+rx*hg( 39, 22)
    hh( 40, 37)=ig( 61, 22)+rx*hg( 40, 22)
    hh( 41, 37)=ig( 62, 22)+rx*hg( 41, 22)
    hh( 42, 37)=ig( 63, 22)+rx*hg( 42, 22)
    hh( 43, 37)=ig( 64, 22)+rx*hg( 43, 22)
    hh( 44, 37)=ig( 65, 22)+rx*hg( 44, 22)
    hh( 45, 37)=ig( 66, 22)+rx*hg( 45, 22)
    hh( 46, 37)=ig( 67, 22)+rx*hg( 46, 22)
    hh( 47, 37)=ig( 68, 22)+rx*hg( 47, 22)
    hh( 48, 37)=ig( 69, 22)+rx*hg( 48, 22)
    hh( 49, 37)=ig( 70, 22)+rx*hg( 49, 22)
    hh( 50, 37)=ig( 71, 22)+rx*hg( 50, 22)
    hh( 51, 37)=ig( 72, 22)+rx*hg( 51, 22)
    hh( 52, 37)=ig( 73, 22)+rx*hg( 52, 22)
    hh( 53, 37)=ig( 74, 22)+rx*hg( 53, 22)
    hh( 54, 37)=ig( 75, 22)+rx*hg( 54, 22)
    hh( 55, 37)=ig( 76, 22)+rx*hg( 55, 22)
    hh( 56, 37)=ig( 77, 22)+rx*hg( 56, 22)
    hh( 36, 38)=ig( 57, 23)+rx*hg( 36, 23)
    hh( 37, 38)=ig( 58, 23)+rx*hg( 37, 23)
    hh( 38, 38)=ig( 59, 23)+rx*hg( 38, 23)
    hh( 39, 38)=ig( 60, 23)+rx*hg( 39, 23)
    hh( 40, 38)=ig( 61, 23)+rx*hg( 40, 23)
    hh( 41, 38)=ig( 62, 23)+rx*hg( 41, 23)
    hh( 42, 38)=ig( 63, 23)+rx*hg( 42, 23)
    hh( 43, 38)=ig( 64, 23)+rx*hg( 43, 23)
    hh( 44, 38)=ig( 65, 23)+rx*hg( 44, 23)
    hh( 45, 38)=ig( 66, 23)+rx*hg( 45, 23)
    hh( 46, 38)=ig( 67, 23)+rx*hg( 46, 23)
    hh( 47, 38)=ig( 68, 23)+rx*hg( 47, 23)
    hh( 48, 38)=ig( 69, 23)+rx*hg( 48, 23)
    hh( 49, 38)=ig( 70, 23)+rx*hg( 49, 23)
    hh( 50, 38)=ig( 71, 23)+rx*hg( 50, 23)
    hh( 51, 38)=ig( 72, 23)+rx*hg( 51, 23)
    hh( 52, 38)=ig( 73, 23)+rx*hg( 52, 23)
    hh( 53, 38)=ig( 74, 23)+rx*hg( 53, 23)
    hh( 54, 38)=ig( 75, 23)+rx*hg( 54, 23)
    hh( 55, 38)=ig( 76, 23)+rx*hg( 55, 23)
    hh( 56, 38)=ig( 77, 23)+rx*hg( 56, 23)
    hh( 36, 39)=ig( 57, 24)+rx*hg( 36, 24)
    hh( 37, 39)=ig( 58, 24)+rx*hg( 37, 24)
    hh( 38, 39)=ig( 59, 24)+rx*hg( 38, 24)
    hh( 39, 39)=ig( 60, 24)+rx*hg( 39, 24)
    hh( 40, 39)=ig( 61, 24)+rx*hg( 40, 24)
    hh( 41, 39)=ig( 62, 24)+rx*hg( 41, 24)
    hh( 42, 39)=ig( 63, 24)+rx*hg( 42, 24)
    hh( 43, 39)=ig( 64, 24)+rx*hg( 43, 24)
    hh( 44, 39)=ig( 65, 24)+rx*hg( 44, 24)
    hh( 45, 39)=ig( 66, 24)+rx*hg( 45, 24)
    hh( 46, 39)=ig( 67, 24)+rx*hg( 46, 24)
    hh( 47, 39)=ig( 68, 24)+rx*hg( 47, 24)
    hh( 48, 39)=ig( 69, 24)+rx*hg( 48, 24)
    hh( 49, 39)=ig( 70, 24)+rx*hg( 49, 24)
    hh( 50, 39)=ig( 71, 24)+rx*hg( 50, 24)
    hh( 51, 39)=ig( 72, 24)+rx*hg( 51, 24)
    hh( 52, 39)=ig( 73, 24)+rx*hg( 52, 24)
    hh( 53, 39)=ig( 74, 24)+rx*hg( 53, 24)
    hh( 54, 39)=ig( 75, 24)+rx*hg( 54, 24)
    hh( 55, 39)=ig( 76, 24)+rx*hg( 55, 24)
    hh( 56, 39)=ig( 77, 24)+rx*hg( 56, 24)
    hh( 36, 40)=ig( 57, 25)+rx*hg( 36, 25)
    hh( 37, 40)=ig( 58, 25)+rx*hg( 37, 25)
    hh( 38, 40)=ig( 59, 25)+rx*hg( 38, 25)
    hh( 39, 40)=ig( 60, 25)+rx*hg( 39, 25)
    hh( 40, 40)=ig( 61, 25)+rx*hg( 40, 25)
    hh( 41, 40)=ig( 62, 25)+rx*hg( 41, 25)
    hh( 42, 40)=ig( 63, 25)+rx*hg( 42, 25)
    hh( 43, 40)=ig( 64, 25)+rx*hg( 43, 25)
    hh( 44, 40)=ig( 65, 25)+rx*hg( 44, 25)
    hh( 45, 40)=ig( 66, 25)+rx*hg( 45, 25)
    hh( 46, 40)=ig( 67, 25)+rx*hg( 46, 25)
    hh( 47, 40)=ig( 68, 25)+rx*hg( 47, 25)
    hh( 48, 40)=ig( 69, 25)+rx*hg( 48, 25)
    hh( 49, 40)=ig( 70, 25)+rx*hg( 49, 25)
    hh( 50, 40)=ig( 71, 25)+rx*hg( 50, 25)
    hh( 51, 40)=ig( 72, 25)+rx*hg( 51, 25)
    hh( 52, 40)=ig( 73, 25)+rx*hg( 52, 25)
    hh( 53, 40)=ig( 74, 25)+rx*hg( 53, 25)
    hh( 54, 40)=ig( 75, 25)+rx*hg( 54, 25)
    hh( 55, 40)=ig( 76, 25)+rx*hg( 55, 25)
    hh( 56, 40)=ig( 77, 25)+rx*hg( 56, 25)
    hh( 36, 41)=ig( 57, 26)+rx*hg( 36, 26)
    hh( 37, 41)=ig( 58, 26)+rx*hg( 37, 26)
    hh( 38, 41)=ig( 59, 26)+rx*hg( 38, 26)
    hh( 39, 41)=ig( 60, 26)+rx*hg( 39, 26)
    hh( 40, 41)=ig( 61, 26)+rx*hg( 40, 26)
    hh( 41, 41)=ig( 62, 26)+rx*hg( 41, 26)
    hh( 42, 41)=ig( 63, 26)+rx*hg( 42, 26)
    hh( 43, 41)=ig( 64, 26)+rx*hg( 43, 26)
    hh( 44, 41)=ig( 65, 26)+rx*hg( 44, 26)
    hh( 45, 41)=ig( 66, 26)+rx*hg( 45, 26)
    hh( 46, 41)=ig( 67, 26)+rx*hg( 46, 26)
    hh( 47, 41)=ig( 68, 26)+rx*hg( 47, 26)
    hh( 48, 41)=ig( 69, 26)+rx*hg( 48, 26)
    hh( 49, 41)=ig( 70, 26)+rx*hg( 49, 26)
    hh( 50, 41)=ig( 71, 26)+rx*hg( 50, 26)
    hh( 51, 41)=ig( 72, 26)+rx*hg( 51, 26)
    hh( 52, 41)=ig( 73, 26)+rx*hg( 52, 26)
    hh( 53, 41)=ig( 74, 26)+rx*hg( 53, 26)
    hh( 54, 41)=ig( 75, 26)+rx*hg( 54, 26)
    hh( 55, 41)=ig( 76, 26)+rx*hg( 55, 26)
    hh( 56, 41)=ig( 77, 26)+rx*hg( 56, 26)
    hh( 36, 42)=ig( 57, 27)+rx*hg( 36, 27)
    hh( 37, 42)=ig( 58, 27)+rx*hg( 37, 27)
    hh( 38, 42)=ig( 59, 27)+rx*hg( 38, 27)
    hh( 39, 42)=ig( 60, 27)+rx*hg( 39, 27)
    hh( 40, 42)=ig( 61, 27)+rx*hg( 40, 27)
    hh( 41, 42)=ig( 62, 27)+rx*hg( 41, 27)
    hh( 42, 42)=ig( 63, 27)+rx*hg( 42, 27)
    hh( 43, 42)=ig( 64, 27)+rx*hg( 43, 27)
    hh( 44, 42)=ig( 65, 27)+rx*hg( 44, 27)
    hh( 45, 42)=ig( 66, 27)+rx*hg( 45, 27)
    hh( 46, 42)=ig( 67, 27)+rx*hg( 46, 27)
    hh( 47, 42)=ig( 68, 27)+rx*hg( 47, 27)
    hh( 48, 42)=ig( 69, 27)+rx*hg( 48, 27)
    hh( 49, 42)=ig( 70, 27)+rx*hg( 49, 27)
    hh( 50, 42)=ig( 71, 27)+rx*hg( 50, 27)
    hh( 51, 42)=ig( 72, 27)+rx*hg( 51, 27)
    hh( 52, 42)=ig( 73, 27)+rx*hg( 52, 27)
    hh( 53, 42)=ig( 74, 27)+rx*hg( 53, 27)
    hh( 54, 42)=ig( 75, 27)+rx*hg( 54, 27)
    hh( 55, 42)=ig( 76, 27)+rx*hg( 55, 27)
    hh( 56, 42)=ig( 77, 27)+rx*hg( 56, 27)
    hh( 36, 43)=ig( 57, 28)+rx*hg( 36, 28)
    hh( 37, 43)=ig( 58, 28)+rx*hg( 37, 28)
    hh( 38, 43)=ig( 59, 28)+rx*hg( 38, 28)
    hh( 39, 43)=ig( 60, 28)+rx*hg( 39, 28)
    hh( 40, 43)=ig( 61, 28)+rx*hg( 40, 28)
    hh( 41, 43)=ig( 62, 28)+rx*hg( 41, 28)
    hh( 42, 43)=ig( 63, 28)+rx*hg( 42, 28)
    hh( 43, 43)=ig( 64, 28)+rx*hg( 43, 28)
    hh( 44, 43)=ig( 65, 28)+rx*hg( 44, 28)
    hh( 45, 43)=ig( 66, 28)+rx*hg( 45, 28)
    hh( 46, 43)=ig( 67, 28)+rx*hg( 46, 28)
    hh( 47, 43)=ig( 68, 28)+rx*hg( 47, 28)
    hh( 48, 43)=ig( 69, 28)+rx*hg( 48, 28)
    hh( 49, 43)=ig( 70, 28)+rx*hg( 49, 28)
    hh( 50, 43)=ig( 71, 28)+rx*hg( 50, 28)
    hh( 51, 43)=ig( 72, 28)+rx*hg( 51, 28)
    hh( 52, 43)=ig( 73, 28)+rx*hg( 52, 28)
    hh( 53, 43)=ig( 74, 28)+rx*hg( 53, 28)
    hh( 54, 43)=ig( 75, 28)+rx*hg( 54, 28)
    hh( 55, 43)=ig( 76, 28)+rx*hg( 55, 28)
    hh( 56, 43)=ig( 77, 28)+rx*hg( 56, 28)
    hh( 36, 44)=ig( 57, 29)+rx*hg( 36, 29)
    hh( 37, 44)=ig( 58, 29)+rx*hg( 37, 29)
    hh( 38, 44)=ig( 59, 29)+rx*hg( 38, 29)
    hh( 39, 44)=ig( 60, 29)+rx*hg( 39, 29)
    hh( 40, 44)=ig( 61, 29)+rx*hg( 40, 29)
    hh( 41, 44)=ig( 62, 29)+rx*hg( 41, 29)
    hh( 42, 44)=ig( 63, 29)+rx*hg( 42, 29)
    hh( 43, 44)=ig( 64, 29)+rx*hg( 43, 29)
    hh( 44, 44)=ig( 65, 29)+rx*hg( 44, 29)
    hh( 45, 44)=ig( 66, 29)+rx*hg( 45, 29)
    hh( 46, 44)=ig( 67, 29)+rx*hg( 46, 29)
    hh( 47, 44)=ig( 68, 29)+rx*hg( 47, 29)
    hh( 48, 44)=ig( 69, 29)+rx*hg( 48, 29)
    hh( 49, 44)=ig( 70, 29)+rx*hg( 49, 29)
    hh( 50, 44)=ig( 71, 29)+rx*hg( 50, 29)
    hh( 51, 44)=ig( 72, 29)+rx*hg( 51, 29)
    hh( 52, 44)=ig( 73, 29)+rx*hg( 52, 29)
    hh( 53, 44)=ig( 74, 29)+rx*hg( 53, 29)
    hh( 54, 44)=ig( 75, 29)+rx*hg( 54, 29)
    hh( 55, 44)=ig( 76, 29)+rx*hg( 55, 29)
    hh( 56, 44)=ig( 77, 29)+rx*hg( 56, 29)
    hh( 36, 45)=ig( 57, 30)+rx*hg( 36, 30)
    hh( 37, 45)=ig( 58, 30)+rx*hg( 37, 30)
    hh( 38, 45)=ig( 59, 30)+rx*hg( 38, 30)
    hh( 39, 45)=ig( 60, 30)+rx*hg( 39, 30)
    hh( 40, 45)=ig( 61, 30)+rx*hg( 40, 30)
    hh( 41, 45)=ig( 62, 30)+rx*hg( 41, 30)
    hh( 42, 45)=ig( 63, 30)+rx*hg( 42, 30)
    hh( 43, 45)=ig( 64, 30)+rx*hg( 43, 30)
    hh( 44, 45)=ig( 65, 30)+rx*hg( 44, 30)
    hh( 45, 45)=ig( 66, 30)+rx*hg( 45, 30)
    hh( 46, 45)=ig( 67, 30)+rx*hg( 46, 30)
    hh( 47, 45)=ig( 68, 30)+rx*hg( 47, 30)
    hh( 48, 45)=ig( 69, 30)+rx*hg( 48, 30)
    hh( 49, 45)=ig( 70, 30)+rx*hg( 49, 30)
    hh( 50, 45)=ig( 71, 30)+rx*hg( 50, 30)
    hh( 51, 45)=ig( 72, 30)+rx*hg( 51, 30)
    hh( 52, 45)=ig( 73, 30)+rx*hg( 52, 30)
    hh( 53, 45)=ig( 74, 30)+rx*hg( 53, 30)
    hh( 54, 45)=ig( 75, 30)+rx*hg( 54, 30)
    hh( 55, 45)=ig( 76, 30)+rx*hg( 55, 30)
    hh( 56, 45)=ig( 77, 30)+rx*hg( 56, 30)
    hh( 36, 46)=ig( 57, 31)+rx*hg( 36, 31)
    hh( 37, 46)=ig( 58, 31)+rx*hg( 37, 31)
    hh( 38, 46)=ig( 59, 31)+rx*hg( 38, 31)
    hh( 39, 46)=ig( 60, 31)+rx*hg( 39, 31)
    hh( 40, 46)=ig( 61, 31)+rx*hg( 40, 31)
    hh( 41, 46)=ig( 62, 31)+rx*hg( 41, 31)
    hh( 42, 46)=ig( 63, 31)+rx*hg( 42, 31)
    hh( 43, 46)=ig( 64, 31)+rx*hg( 43, 31)
    hh( 44, 46)=ig( 65, 31)+rx*hg( 44, 31)
    hh( 45, 46)=ig( 66, 31)+rx*hg( 45, 31)
    hh( 46, 46)=ig( 67, 31)+rx*hg( 46, 31)
    hh( 47, 46)=ig( 68, 31)+rx*hg( 47, 31)
    hh( 48, 46)=ig( 69, 31)+rx*hg( 48, 31)
    hh( 49, 46)=ig( 70, 31)+rx*hg( 49, 31)
    hh( 50, 46)=ig( 71, 31)+rx*hg( 50, 31)
    hh( 51, 46)=ig( 72, 31)+rx*hg( 51, 31)
    hh( 52, 46)=ig( 73, 31)+rx*hg( 52, 31)
    hh( 53, 46)=ig( 74, 31)+rx*hg( 53, 31)
    hh( 54, 46)=ig( 75, 31)+rx*hg( 54, 31)
    hh( 55, 46)=ig( 76, 31)+rx*hg( 55, 31)
    hh( 56, 46)=ig( 77, 31)+rx*hg( 56, 31)
    hh( 36, 47)=ig( 57, 32)+rx*hg( 36, 32)
    hh( 37, 47)=ig( 58, 32)+rx*hg( 37, 32)
    hh( 38, 47)=ig( 59, 32)+rx*hg( 38, 32)
    hh( 39, 47)=ig( 60, 32)+rx*hg( 39, 32)
    hh( 40, 47)=ig( 61, 32)+rx*hg( 40, 32)
    hh( 41, 47)=ig( 62, 32)+rx*hg( 41, 32)
    hh( 42, 47)=ig( 63, 32)+rx*hg( 42, 32)
    hh( 43, 47)=ig( 64, 32)+rx*hg( 43, 32)
    hh( 44, 47)=ig( 65, 32)+rx*hg( 44, 32)
    hh( 45, 47)=ig( 66, 32)+rx*hg( 45, 32)
    hh( 46, 47)=ig( 67, 32)+rx*hg( 46, 32)
    hh( 47, 47)=ig( 68, 32)+rx*hg( 47, 32)
    hh( 48, 47)=ig( 69, 32)+rx*hg( 48, 32)
    hh( 49, 47)=ig( 70, 32)+rx*hg( 49, 32)
    hh( 50, 47)=ig( 71, 32)+rx*hg( 50, 32)
    hh( 51, 47)=ig( 72, 32)+rx*hg( 51, 32)
    hh( 52, 47)=ig( 73, 32)+rx*hg( 52, 32)
    hh( 53, 47)=ig( 74, 32)+rx*hg( 53, 32)
    hh( 54, 47)=ig( 75, 32)+rx*hg( 54, 32)
    hh( 55, 47)=ig( 76, 32)+rx*hg( 55, 32)
    hh( 56, 47)=ig( 77, 32)+rx*hg( 56, 32)
    hh( 36, 48)=ig( 57, 33)+rx*hg( 36, 33)
    hh( 37, 48)=ig( 58, 33)+rx*hg( 37, 33)
    hh( 38, 48)=ig( 59, 33)+rx*hg( 38, 33)
    hh( 39, 48)=ig( 60, 33)+rx*hg( 39, 33)
    hh( 40, 48)=ig( 61, 33)+rx*hg( 40, 33)
    hh( 41, 48)=ig( 62, 33)+rx*hg( 41, 33)
    hh( 42, 48)=ig( 63, 33)+rx*hg( 42, 33)
    hh( 43, 48)=ig( 64, 33)+rx*hg( 43, 33)
    hh( 44, 48)=ig( 65, 33)+rx*hg( 44, 33)
    hh( 45, 48)=ig( 66, 33)+rx*hg( 45, 33)
    hh( 46, 48)=ig( 67, 33)+rx*hg( 46, 33)
    hh( 47, 48)=ig( 68, 33)+rx*hg( 47, 33)
    hh( 48, 48)=ig( 69, 33)+rx*hg( 48, 33)
    hh( 49, 48)=ig( 70, 33)+rx*hg( 49, 33)
    hh( 50, 48)=ig( 71, 33)+rx*hg( 50, 33)
    hh( 51, 48)=ig( 72, 33)+rx*hg( 51, 33)
    hh( 52, 48)=ig( 73, 33)+rx*hg( 52, 33)
    hh( 53, 48)=ig( 74, 33)+rx*hg( 53, 33)
    hh( 54, 48)=ig( 75, 33)+rx*hg( 54, 33)
    hh( 55, 48)=ig( 76, 33)+rx*hg( 55, 33)
    hh( 56, 48)=ig( 77, 33)+rx*hg( 56, 33)
    hh( 36, 49)=ig( 57, 34)+rx*hg( 36, 34)
    hh( 37, 49)=ig( 58, 34)+rx*hg( 37, 34)
    hh( 38, 49)=ig( 59, 34)+rx*hg( 38, 34)
    hh( 39, 49)=ig( 60, 34)+rx*hg( 39, 34)
    hh( 40, 49)=ig( 61, 34)+rx*hg( 40, 34)
    hh( 41, 49)=ig( 62, 34)+rx*hg( 41, 34)
    hh( 42, 49)=ig( 63, 34)+rx*hg( 42, 34)
    hh( 43, 49)=ig( 64, 34)+rx*hg( 43, 34)
    hh( 44, 49)=ig( 65, 34)+rx*hg( 44, 34)
    hh( 45, 49)=ig( 66, 34)+rx*hg( 45, 34)
    hh( 46, 49)=ig( 67, 34)+rx*hg( 46, 34)
    hh( 47, 49)=ig( 68, 34)+rx*hg( 47, 34)
    hh( 48, 49)=ig( 69, 34)+rx*hg( 48, 34)
    hh( 49, 49)=ig( 70, 34)+rx*hg( 49, 34)
    hh( 50, 49)=ig( 71, 34)+rx*hg( 50, 34)
    hh( 51, 49)=ig( 72, 34)+rx*hg( 51, 34)
    hh( 52, 49)=ig( 73, 34)+rx*hg( 52, 34)
    hh( 53, 49)=ig( 74, 34)+rx*hg( 53, 34)
    hh( 54, 49)=ig( 75, 34)+rx*hg( 54, 34)
    hh( 55, 49)=ig( 76, 34)+rx*hg( 55, 34)
    hh( 56, 49)=ig( 77, 34)+rx*hg( 56, 34)
    hh( 36, 50)=ig( 57, 35)+rx*hg( 36, 35)
    hh( 37, 50)=ig( 58, 35)+rx*hg( 37, 35)
    hh( 38, 50)=ig( 59, 35)+rx*hg( 38, 35)
    hh( 39, 50)=ig( 60, 35)+rx*hg( 39, 35)
    hh( 40, 50)=ig( 61, 35)+rx*hg( 40, 35)
    hh( 41, 50)=ig( 62, 35)+rx*hg( 41, 35)
    hh( 42, 50)=ig( 63, 35)+rx*hg( 42, 35)
    hh( 43, 50)=ig( 64, 35)+rx*hg( 43, 35)
    hh( 44, 50)=ig( 65, 35)+rx*hg( 44, 35)
    hh( 45, 50)=ig( 66, 35)+rx*hg( 45, 35)
    hh( 46, 50)=ig( 67, 35)+rx*hg( 46, 35)
    hh( 47, 50)=ig( 68, 35)+rx*hg( 47, 35)
    hh( 48, 50)=ig( 69, 35)+rx*hg( 48, 35)
    hh( 49, 50)=ig( 70, 35)+rx*hg( 49, 35)
    hh( 50, 50)=ig( 71, 35)+rx*hg( 50, 35)
    hh( 51, 50)=ig( 72, 35)+rx*hg( 51, 35)
    hh( 52, 50)=ig( 73, 35)+rx*hg( 52, 35)
    hh( 53, 50)=ig( 74, 35)+rx*hg( 53, 35)
    hh( 54, 50)=ig( 75, 35)+rx*hg( 54, 35)
    hh( 55, 50)=ig( 76, 35)+rx*hg( 55, 35)
    hh( 56, 50)=ig( 77, 35)+rx*hg( 56, 35)
    hh( 36, 51)=ig( 58, 31)+ry*hg( 36, 31)
    hh( 37, 51)=ig( 60, 31)+ry*hg( 37, 31)
    hh( 38, 51)=ig( 61, 31)+ry*hg( 38, 31)
    hh( 39, 51)=ig( 63, 31)+ry*hg( 39, 31)
    hh( 40, 51)=ig( 64, 31)+ry*hg( 40, 31)
    hh( 41, 51)=ig( 65, 31)+ry*hg( 41, 31)
    hh( 42, 51)=ig( 67, 31)+ry*hg( 42, 31)
    hh( 43, 51)=ig( 68, 31)+ry*hg( 43, 31)
    hh( 44, 51)=ig( 69, 31)+ry*hg( 44, 31)
    hh( 45, 51)=ig( 70, 31)+ry*hg( 45, 31)
    hh( 46, 51)=ig( 72, 31)+ry*hg( 46, 31)
    hh( 47, 51)=ig( 73, 31)+ry*hg( 47, 31)
    hh( 48, 51)=ig( 74, 31)+ry*hg( 48, 31)
    hh( 49, 51)=ig( 75, 31)+ry*hg( 49, 31)
    hh( 50, 51)=ig( 76, 31)+ry*hg( 50, 31)
    hh( 51, 51)=ig( 78, 31)+ry*hg( 51, 31)
    hh( 52, 51)=ig( 79, 31)+ry*hg( 52, 31)
    hh( 53, 51)=ig( 80, 31)+ry*hg( 53, 31)
    hh( 54, 51)=ig( 81, 31)+ry*hg( 54, 31)
    hh( 55, 51)=ig( 82, 31)+ry*hg( 55, 31)
    hh( 56, 51)=ig( 83, 31)+ry*hg( 56, 31)
    hh( 36, 52)=ig( 58, 32)+ry*hg( 36, 32)
    hh( 37, 52)=ig( 60, 32)+ry*hg( 37, 32)
    hh( 38, 52)=ig( 61, 32)+ry*hg( 38, 32)
    hh( 39, 52)=ig( 63, 32)+ry*hg( 39, 32)
    hh( 40, 52)=ig( 64, 32)+ry*hg( 40, 32)
    hh( 41, 52)=ig( 65, 32)+ry*hg( 41, 32)
    hh( 42, 52)=ig( 67, 32)+ry*hg( 42, 32)
    hh( 43, 52)=ig( 68, 32)+ry*hg( 43, 32)
    hh( 44, 52)=ig( 69, 32)+ry*hg( 44, 32)
    hh( 45, 52)=ig( 70, 32)+ry*hg( 45, 32)
    hh( 46, 52)=ig( 72, 32)+ry*hg( 46, 32)
    hh( 47, 52)=ig( 73, 32)+ry*hg( 47, 32)
    hh( 48, 52)=ig( 74, 32)+ry*hg( 48, 32)
    hh( 49, 52)=ig( 75, 32)+ry*hg( 49, 32)
    hh( 50, 52)=ig( 76, 32)+ry*hg( 50, 32)
    hh( 51, 52)=ig( 78, 32)+ry*hg( 51, 32)
    hh( 52, 52)=ig( 79, 32)+ry*hg( 52, 32)
    hh( 53, 52)=ig( 80, 32)+ry*hg( 53, 32)
    hh( 54, 52)=ig( 81, 32)+ry*hg( 54, 32)
    hh( 55, 52)=ig( 82, 32)+ry*hg( 55, 32)
    hh( 56, 52)=ig( 83, 32)+ry*hg( 56, 32)
    hh( 36, 53)=ig( 58, 33)+ry*hg( 36, 33)
    hh( 37, 53)=ig( 60, 33)+ry*hg( 37, 33)
    hh( 38, 53)=ig( 61, 33)+ry*hg( 38, 33)
    hh( 39, 53)=ig( 63, 33)+ry*hg( 39, 33)
    hh( 40, 53)=ig( 64, 33)+ry*hg( 40, 33)
    hh( 41, 53)=ig( 65, 33)+ry*hg( 41, 33)
    hh( 42, 53)=ig( 67, 33)+ry*hg( 42, 33)
    hh( 43, 53)=ig( 68, 33)+ry*hg( 43, 33)
    hh( 44, 53)=ig( 69, 33)+ry*hg( 44, 33)
    hh( 45, 53)=ig( 70, 33)+ry*hg( 45, 33)
    hh( 46, 53)=ig( 72, 33)+ry*hg( 46, 33)
    hh( 47, 53)=ig( 73, 33)+ry*hg( 47, 33)
    hh( 48, 53)=ig( 74, 33)+ry*hg( 48, 33)
    hh( 49, 53)=ig( 75, 33)+ry*hg( 49, 33)
    hh( 50, 53)=ig( 76, 33)+ry*hg( 50, 33)
    hh( 51, 53)=ig( 78, 33)+ry*hg( 51, 33)
    hh( 52, 53)=ig( 79, 33)+ry*hg( 52, 33)
    hh( 53, 53)=ig( 80, 33)+ry*hg( 53, 33)
    hh( 54, 53)=ig( 81, 33)+ry*hg( 54, 33)
    hh( 55, 53)=ig( 82, 33)+ry*hg( 55, 33)
    hh( 56, 53)=ig( 83, 33)+ry*hg( 56, 33)
    hh( 36, 54)=ig( 58, 34)+ry*hg( 36, 34)
    hh( 37, 54)=ig( 60, 34)+ry*hg( 37, 34)
    hh( 38, 54)=ig( 61, 34)+ry*hg( 38, 34)
    hh( 39, 54)=ig( 63, 34)+ry*hg( 39, 34)
    hh( 40, 54)=ig( 64, 34)+ry*hg( 40, 34)
    hh( 41, 54)=ig( 65, 34)+ry*hg( 41, 34)
    hh( 42, 54)=ig( 67, 34)+ry*hg( 42, 34)
    hh( 43, 54)=ig( 68, 34)+ry*hg( 43, 34)
    hh( 44, 54)=ig( 69, 34)+ry*hg( 44, 34)
    hh( 45, 54)=ig( 70, 34)+ry*hg( 45, 34)
    hh( 46, 54)=ig( 72, 34)+ry*hg( 46, 34)
    hh( 47, 54)=ig( 73, 34)+ry*hg( 47, 34)
    hh( 48, 54)=ig( 74, 34)+ry*hg( 48, 34)
    hh( 49, 54)=ig( 75, 34)+ry*hg( 49, 34)
    hh( 50, 54)=ig( 76, 34)+ry*hg( 50, 34)
    hh( 51, 54)=ig( 78, 34)+ry*hg( 51, 34)
    hh( 52, 54)=ig( 79, 34)+ry*hg( 52, 34)
    hh( 53, 54)=ig( 80, 34)+ry*hg( 53, 34)
    hh( 54, 54)=ig( 81, 34)+ry*hg( 54, 34)
    hh( 55, 54)=ig( 82, 34)+ry*hg( 55, 34)
    hh( 56, 54)=ig( 83, 34)+ry*hg( 56, 34)
    hh( 36, 55)=ig( 58, 35)+ry*hg( 36, 35)
    hh( 37, 55)=ig( 60, 35)+ry*hg( 37, 35)
    hh( 38, 55)=ig( 61, 35)+ry*hg( 38, 35)
    hh( 39, 55)=ig( 63, 35)+ry*hg( 39, 35)
    hh( 40, 55)=ig( 64, 35)+ry*hg( 40, 35)
    hh( 41, 55)=ig( 65, 35)+ry*hg( 41, 35)
    hh( 42, 55)=ig( 67, 35)+ry*hg( 42, 35)
    hh( 43, 55)=ig( 68, 35)+ry*hg( 43, 35)
    hh( 44, 55)=ig( 69, 35)+ry*hg( 44, 35)
    hh( 45, 55)=ig( 70, 35)+ry*hg( 45, 35)
    hh( 46, 55)=ig( 72, 35)+ry*hg( 46, 35)
    hh( 47, 55)=ig( 73, 35)+ry*hg( 47, 35)
    hh( 48, 55)=ig( 74, 35)+ry*hg( 48, 35)
    hh( 49, 55)=ig( 75, 35)+ry*hg( 49, 35)
    hh( 50, 55)=ig( 76, 35)+ry*hg( 50, 35)
    hh( 51, 55)=ig( 78, 35)+ry*hg( 51, 35)
    hh( 52, 55)=ig( 79, 35)+ry*hg( 52, 35)
    hh( 53, 55)=ig( 80, 35)+ry*hg( 53, 35)
    hh( 54, 55)=ig( 81, 35)+ry*hg( 54, 35)
    hh( 55, 55)=ig( 82, 35)+ry*hg( 55, 35)
    hh( 56, 55)=ig( 83, 35)+ry*hg( 56, 35)
    hh( 36, 56)=ig( 59, 35)+rz*hg( 36, 35)
    hh( 37, 56)=ig( 61, 35)+rz*hg( 37, 35)
    hh( 38, 56)=ig( 62, 35)+rz*hg( 38, 35)
    hh( 39, 56)=ig( 64, 35)+rz*hg( 39, 35)
    hh( 40, 56)=ig( 65, 35)+rz*hg( 40, 35)
    hh( 41, 56)=ig( 66, 35)+rz*hg( 41, 35)
    hh( 42, 56)=ig( 68, 35)+rz*hg( 42, 35)
    hh( 43, 56)=ig( 69, 35)+rz*hg( 43, 35)
    hh( 44, 56)=ig( 70, 35)+rz*hg( 44, 35)
    hh( 45, 56)=ig( 71, 35)+rz*hg( 45, 35)
    hh( 46, 56)=ig( 73, 35)+rz*hg( 46, 35)
    hh( 47, 56)=ig( 74, 35)+rz*hg( 47, 35)
    hh( 48, 56)=ig( 75, 35)+rz*hg( 48, 35)
    hh( 49, 56)=ig( 76, 35)+rz*hg( 49, 35)
    hh( 50, 56)=ig( 77, 35)+rz*hg( 50, 35)
    hh( 51, 56)=ig( 79, 35)+rz*hg( 51, 35)
    hh( 52, 56)=ig( 80, 35)+rz*hg( 52, 35)
    hh( 53, 56)=ig( 81, 35)+rz*hg( 53, 35)
    hh( 54, 56)=ig( 82, 35)+rz*hg( 54, 35)
    hh( 55, 56)=ig( 83, 35)+rz*hg( 55, 35)
    hh( 56, 56)=ig( 84, 35)+rz*hg( 56, 35)
  end subroutine
!--------------------------------------------------------------------
end module
